function outcoeff=oo_calcmodel(parameters,expdata)

global Locset

if Locset.tracker disp('---- oo_calcmodel ----'); end

coefficients=[]; outcoeff=zeros(6,1);

method=1; % Regression method to use
% All methods produce the same results, except 2 that forces the intercept
% to be equal to y mean. 2 is less accurate than the other

[n_param,n_exp]=size(parameters);

% Sets up X-matrix for two predictors
if n_param==2
    for x=1:n_exp
        X(x,:)=[parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];
    end
end

% handles zero and one experiments
if n_exp==0
    outcoeff=[];
    return
end
if n_exp==1
    outcoeff(1)=expdata;
    return
end

valids=find(ranktest(X));
X=X(:,valids);

% Uncentered direct use of \
if method==1    
    X=[ones(n_exp,1) X];
    coefficients=X\expdata;    
end

% Centers Y, not X
if method==2   
    ymean=mean(expdata);
    coefficients=X\(expdata-ymean);
    coefficients=[ymean; coefficients];    
end

% Centers X and Y
if method==3    
    % Centering
    xmean=mean(X); % Mean values of X
    ymean=mean(expdata);
    ycent=expdata-ymean; % Centered Y 
    Xcent=detrend(X,'constant'); % Centered X
    
    % Calculate coefficients
    coefficients3=Xcent\ycent; %Calculate coefficients 
    interc=ymean-sum(coefficients3 .* xmean'); % Calculates intercept
    coefficients=[interc; coefficients3];    
end

% Standardizes and Centers X and Y
if method==4    
    % Standardization
    weightsX=1./std(X); %X weights
    weightsY=1/std(expdata); % y weights
    for x=1:size(X,1);
        Xw(x,:)=X(x,:).*weightsX; % standardized X
    end   
    yw=expdata*weightsY; % standardized y    
    % centering
    xmean=mean(Xw); % Mean values of X
    ymean=mean(yw); % Mean values of y
    Xcent=detrend(Xw,'constant'); % Centered X    
    ycent=yw-mean(yw); % Centered x    
    % Calculate coefficients and update with weights
    coefficients4=Xcent\ycent; %Calculate coefficients 
    interc=ymean-sum(coefficients4 .* xmean'); % Calculates intercept
    coefficients4=coefficients4.*weightsX'; % Updates coefficients with x weights
    coefficients=[interc; coefficients4];  % Adds intercept
    coefficients=coefficients/weightsY; % Updates coefficients with y weights    
end

% transfer valid coefficients to outcoeff
for x=1:numel(valids)
    outcoeff(valids(x)+1)=coefficients(x+1);    
end
outcoeff(1)=coefficients(1);


% %---------- ranktest --------
function valids=ranktest(X)
% Parameters are sorted by importance, if rank does not increase when a new
% variable is added the effect is set as not valid

[n_exp,n_par]=size(X);
X=[ones(n_exp,1) X];
for x=1:n_par+1
    r(x)=rank(X(:,1:x));
end
valids=[diff(r)>0];




    
    
    
    
    
    
    
    
    










