function oo_closewin
% Used to close active window
% Will reactivate caller window

%disp('---- CLOSEWIN ----') % TEMP
%gcbf_tag=get(gcbf,'Tag') % TEMP

oldpos=get(gcbf,'Position'); % Finds position of closing window

hh=findobj('Type','uicontextmenu','Parent',gcbf); 
if isempty(hh)==0 delete(hh); end % Removes right-click menus

Userdata=get(gcbf,'UserData');
callertag=Userdata.callerwin_tag; % Finds Tag of GUI that opened current
caller=findobj('Tag',callertag'); % Finds handle of GUI that opened current
if caller ~= 0; set(caller,'Position',oldpos); end % moves caller window to position of closing window
set(caller,'Visible','on'); % Re-activate caller GUI

drawnow

mainwin=findobj('Tag','MainWin');
if gcbf ~= mainwin; 
    set(gcbf,'DeleteFcn','') % Avoids that closewin is run again when window is deleted
    delete(gcbf); 
end % Close window (unless mainwin)

% Refresh window
if caller ~= 0; 
    updfcn=get(caller,'ResizeFcn'); eval(updfcn);
end