function oo_copyfigure(call)
% Copies figure to nw window.
% command 'oo_copyfigure' (no inp. parameters) must be given after figure
% is drawn to add menu.

global Metset Locset

if nargin==0 call=0; end

if call==0
    cmenu = uicontextmenu;
    uimenu(cmenu, 'Label', 'Copy Figure', 'Callback', 'oo_copyfigure(1)');
    uimenu(cmenu, 'Label', 'Copy to clipboard (vector)', 'Callback', 'oo_copyfigure(2)');
    uimenu(cmenu, 'Label', 'Copy to clipboard (bmp)', 'Callback', 'oo_copyfigure(2.5)');
    uimenu(cmenu, 'Label', 'Print', 'Callback', 'oo_copyfigure(3)');
    uimenu(cmenu, 'Label', 'Export PDF', 'Callback', 'oo_copyfigure(4)');
    set(gca,'UiContextMenu',cmenu);
end

if call==1
    axesh=gca;
    nyfig=figure; 
    set(nyfig,'Color',[1 1 1])
    h=copyobj(axesh,nyfig); set(h,'Position',[0.05 0.05 0.9 0.9]); 
    child=get(h,'Children'); set(child,'ButtonDownFcn','')
end

% Copy to clipboard
if call==2 || call==2.5 || call==3 || call==4
    
    % handles of figure/axes to be copied
    figh=gcf; axesh=gca;
    
    Userdata=get(gcf,'UserData');
    % gets screen size
    scrwi=1/Userdata.pointwidth;
    scrhe=1/Userdata.pointheight;
    
    figpos=get(gcf,'Position');   
    axesp=get(axesh,'Position');
    axeswi=(axesp(3)*figpos(3))/Userdata.pointwidth;
    axeshe=(axesp(4)*figpos(3))/Userdata.pointheight;
        
    vo=40; ho=60; % vertical/horizontal offset (because labels are outside axes)
    hs=1; vs=1; % multipliers used to decrease scale if necessary
    if axeswi+ho>scrwi hs=scrwi/(axeswi+ho); axeswi=axeswi*hs; end % Ensures fig width will nor be larger than screen width
    if axeshe+vo>scrhe vs=scrhe/(axeshe+vo); axeshe=scrhe*vs; end % Ensures fig height will not he larger than screen height    
    
    % position of new figure
    fighp=(scrwi-(axeswi+ho))/2; % centers
    figvp=(scrhe-(axeshe+vo))/2; % centers
    nyfigpos=[fighp figvp axeswi+ho axeshe+vo]; % position of new figure
    
    %nyfig=figure('Visible','off'); % remove Visible off to keep figure visible
    nyfig=figure;
    set(nyfig,'Units','points','Position',nyfigpos,'Menubar','none')  
    
    nah=copyobj(axesh,nyfig); % Copies figure to nyfig
    % adjust scale
    set(nah,'Units','points','Position',[ho/2 vo/2 axeswi*hs axeshe*vs])
    child=get(nah,'Children'); set(child,'ButtonDownFcn','','Clipping','on')   
    
end

% copy to clipboard
if call==2 || call==2.5      

    if isunix       
        set(nyfig, 'PaperPositionMode', 'auto')         
        if call==2.0 
            fignam=[Locset.path_export filesep Metset.path_export 'figexport.eps'];
            print(nyfig, '-depsc2', '-r75', fignam); 
            oo_message(1,['|b|Figure saved as ' fignam])
        end         
        if call==2.5 
            fignam=[Locset.path_export filesep Metset.path_export 'figexport.png'];
            print(nyfig, '-dpng', '-r75', fignam); 
            oo_message(1,['|b|Figure saved as ' fignam])
        end 
    end
    
    if ispc
        try % Copy using hgexport      
            if call==2 set(nyfig,'Renderer','painter'); hgexport(nyfig,'-clipboard'); end
            %if call==2.5 set(nyfig,'Renderer','ZBuffer'); hgexport(nyfig,'-clipboard'); end
            if call==2.5 set(nyfig,'Renderer','OpenGL'); hgexport(nyfig,'-clipboard'); end 
            disp('--- hgexport ---')
        catch % Use print if not working
            try
                if call==2 print -dmeta -noui; end
                if call==2.5 print -dbitmap -painters -noui; end
                disp('--- print ---')
            catch
                oo_message(1,'|r|Not supported by current Matlab version')
            end
        end   
    end
    set(0,'CurrentFigure',figh); set(figh,'CurrentAxes',axesh)
    close(nyfig)
end


% Print
if call==3
    
    set(nyfig,'PaperPositionMode','auto','PaperOrientation','landscape','Units','centimeters','PaperUnits','centimeters','MenuBar','none')
    set(nah,'Units','normalized')
    
    figpos=get(nyfig,'Position');
    papersize=get(nyfig,'PaperSize');
    if figpos(3)>papersize(1)*0.9 figpos(3)=papersize(1)*0.9; end 
    if figpos(4)>papersize(2)*0.9 figpos(4)=papersize(2)*0.9; end 
    set(nyfig,'Position',figpos)
    
    printdlg(nyfig)
    close(nyfig)    
end

% pdf export
if call==4
    
    set(nyfig,'PaperPositionMode','auto','PaperOrientation','landscape','Units','centimeters','PaperUnits','centimeters','MenuBar','none')
    set(nah,'Units','normalized')
    
    figpos=get(nyfig,'Position');
    papersize=get(nyfig,'PaperSize');
    if figpos(3)>papersize(1)*0.9 figpos(3)=papersize(1)*0.9; end 
    if figpos(4)>papersize(2)*0.9 figpos(4)=papersize(2)*0.9; end 
    set(nyfig,'Position',figpos)
    
    pathname=[Locset.path_export filesep Metset.path_export filesep 'figureexport_' datestr(now,30) '.pdf'];
       
    try
        print('-dpdf',pathname,['-f' num2str(nyfig)])
        oo_message(1,['|b|Figure exported to ' pathname])
        if Metset.report_aopen && ispc
           try
               winopen(pathname);         
           catch
               oo_message(1,'|r|Could not open file'); 
           end
        end
        if Metset.report_aopen && isunix
           try
               system(['xdg-open ' pathname]);   
           catch
               oo_message(1,'|r|Could not open file'); 
           end
        end        
    catch
        oo_message(1,'|r|Could not create pdf file')
    end

    close(nyfig)   

end


