function oo_copylist(call,handle)
% Copies list contents to textfile
% command 'oo_copylist' (no inp. parameters) must be given after figure
% is drawn to add menu.

global Metset Locset
if nargin==0 call=99; end

if call==0 && nargin>1
    cmenu = uicontextmenu;
    item1 = uimenu(cmenu, 'Label', 'Copy Contents', 'Callback', 'oo_copylist(1)');
    set(handle,'UiContextMenu',cmenu);
end

if call==1
    objh=gco; 
    liststr=get(objh,'String');
    
    if iscell(liststr)==0
        [n_lines,n]=size(liststr);
        for x=1:n_lines
            str{x}=liststr(x,:);
        end
    else
        str=liststr;
    end

    n=length(str);
    
    linefeed=char([13 10]);
    fh=fopen([Locset.path_export '\' Metset.path_export '\O_Copylist.txt'],'w');
    for x=1:n
        fprintf(fh,[str{x},linefeed]); 
    end
    fclose(fh);
    oo_message(6,[Locset.path_export '\' Metset.path_export '\O_Copylist.txt'])

end