function oo_copywindow
% Copies window to clipboard.
    
rend=get(gcf,'Renderer'); 
ih=get(gcf,'InvertHardcopy');
ppm=get(gcf,'PaperPositionMode');

set(gcf,'InvertHardcopy','off')
set(gcf,'PaperPositionMode','auto')
set(gcf,'Renderer','zbuffer'); 

try % Copy using hgexport      
    hgexport(nyfig,'-clipboard')        
    catch % Use print if not working
        try
            %set(gcf,'Renderer','OpenGL'); print -dmeta 
            print -dmeta -zbuffer
            %print -dmeta -painters
        catch
            cc_message(1,'|r|Not supported by current Matlab version')
        end
    end
    set(gcf,'Renderer',rend,'InvertHardcopy',ih,'PaperPositionMode',ppm)
end
