function h0=oo_drawwin(winpar,uipar,updfcn)
% h0=oo_drawwin(winpar,uipar,updfcn)
% Draws window and hides caller window
% winpar: ({'Window_name'}{'Window Tag'}{[position]}) 
% - position is optional (missing => full widow size). 
% uipar: Cell, uisettings for each object: 
% ('Associated text','Type',color,[position],'callback command',fonts,'Tag');

% err settes lik 1 hvis vindu ikke kan pnes;
% Test at ikke vinduer med samme navn er pne

% Parameter no 8:
% '-r': align right
% '-l': align lefter
% '-c': align center
% '-fh': fit height to text 

global fonts Pos Colors Locset

%bw=Pos.bw; bh=Pos.bh; % Defines grid
%gh=Pos.gh;% grid height
%x=Pos.gl:Pos.gw:1; % horisontalt grid
%y=Pos.gt+0.5:-Pos.gh:0; % horisontalt grid

caller=gcbf; % handle to GUI that opens the window
callertag=get(caller,'Tag'); % Tag to GUI that opens the window

% Updates position (draws next win over previous)
existingpos=get(caller,'Position'); if isempty(existingpos)==0 Pos.window=existingpos; end

% Checks if window with same Tag exists (Make more specific, check that Tag belongs to window)
h1=findobj('Tag',winpar{1}); 
if isempty(h1)==0; 
    win_name=get(h1,'Name'); 
    message=['|r|"' win_name '" Allready open']; 
    set(h1,'Visible','on'); % Makes window visible
    set(caller,'Visible','off'); % Hides caller GUI
end

% If winpar 3 is not set or is wrong size: window size = full.
% 'Pos.window' (also used as test for message line)
if length(winpar)==3 & length(winpar{3})==4 position=winpar{3}; else position=Pos.window; end

% Defines userdata
Userdata.callerwin_h=caller;
Userdata.callerwin_tag=get(caller,'Tag');
Userdata.callerwin_updfcn=get(caller,'ResizeFcn');
Userdata.callerwin_pos=get(caller,'Position');
Userdata.callerwin_units=get(caller,'Units');
Userdata.callerwin_color=get(caller,'Color');
Userdata.callerwin_currentaxes=get(caller,'CurrentAxes');
Userdata.callerwin_currentaxes_tag=get(Userdata.callerwin_currentaxes,'Tag');
Userdata.callerobj_h=gcbo;
Userdata.callerobj_tag=get(gcbo,'Tag');
Userdata.pixwidth=Pos.pixwidth;
Userdata.pixheight=Pos.pixheight;
Userdata.pointwidth=Pos.pointwidth;
Userdata.pointheight=Pos.pointheight;

% Construct new window
if isempty(h1) %& isempty(h2)
   
    h0 = figure('Color',Colors.bc, ...
	    'PaperPosition',[18 180 576 432], ...
	    'PaperUnits','points', ...
        'Units','normalized',...
        'Position',position, ...
	    'Renderer','OpenGL', ...
	    'RendererMode','auto', ...
	    'Tag',winpar{1}, ...
        'Name',winpar{2},...
        'NumberTitle','off',...
        'Resize','off',...
        'Handlevisibility','on',...
        'Menubar','none',...
        'UserData',Userdata,...
        'ToolBar','none');

    %---------------------- DEFAULT --------------
    set(h0,'DefaultUicontrolFontWeight','bold',...
        'DefaultUicontrolUnits','normalized',...
        'DefaultUicontrolFontSize',fonts(2),...
        'DefaultUicontrolBackgroundColor',Colors.bc,...
        'DefaultUicontrolHorizontalAlignment','center')


    [m,n]=size(uipar);

    for t=1:m
        
        % Sets pushbuttons to togglenuttons
        if strcmpi(uipar{t,2},'Pushbutton')
            uipar{t,2}='Togglebutton'; uipar{t,5}=[uipar{t,5} '; set(gcbo,''Value'',0)'];
        end
               
        h1 = uicontrol('Parent',h0, ...
           'String',uipar{t,1}, ...   
           'Style',uipar{t,2}, ...
	       'BackgroundColor',uipar{t,3}, ...
           'Position',uipar{t,4}, ...	
           'Callback',uipar{t,5}, ...
           'FontSize',fonts(uipar{t,6}), ...
           'Tag',uipar{t,7});
       % Sets defaults for edits and listboxes
       if strcmp(get(h1,'Style'),'edit') | strcmp(get(h1,'Style'),'listbox') 
           set(h1,'FontWeight','normal'); 
           set(h1,'HorizontalAlignment','left'); 
           set(h1,'FontName','FixedWidth')
       end
       % sets defaults for frames
       if strcmp(get(h1,'Style'),'text') 
           set(h1,'HorizontalAlignment','left');   
       end
       % Sets defaults for popupenu
       if strcmp(get(h1,'Style'),'popupmenu') 
           set(h1,'FontName','FixedWidth')
           set(h1,'FontWeight','normal'); 
       end       
          
       %evaluate parameter 8
       if length(uipar(t,:))>7
           if isempty(strfind(uipar{t,8},'-r'))==0 set(h1,'HorizontalAlignment','Right'); end
           if isempty(strfind(uipar{t,8},'-c'))==0 set(h1,'HorizontalAlignment','Center'); end
           if isempty(strfind(uipar{t,8},'-l'))==0 set(h1,'HorizontalAlignment','Left'); end
           if isempty(strfind(uipar{t,8},'-d'))==0 set(h1,'Enable','off'); end
           if isempty(strfind(uipar{t,8},'-bm'))==0 
               set(h1,'Callback',['oo_busy(1.1);' uipar{t,5} ';oo_busy(0.1);'])
           end  % busymessage                 
           if isempty(strfind(uipar{t,8},'-fh'))==0 
               set(h1,'String','X'); ext=get(h1,'Extent');           
               fz=get(h1,'FontSize'); pos=get(h1,'Position'); pos(1,4)=ext(1,4)*1.1; set(h1,'Position',pos);
               set(h1,'String',uipar{t,1});
           end
           if isempty(strfind(uipar{t,8},'-fvp'))==0 
               pos=get(h1,'Position'); he=pos(1,4); o=(Pos.gh-he)/2; pos(1,2)=pos(1,2)+o;
               set(h1,'Position',pos)            
           end
           
       end
   end

    %------------ ADD MESSAGE LINE -----------
    if length(winpar)<3 % If window size is not specified (i.e. full window)
        oo_message(0); 
        %delfunc='set(findobj(''Tag'',get(gcf,''UserData'')),''Visible'',''on'');';
        delfunc='oo_closewin';

        set(h0,'DeleteFcn',delfunc)
        set(caller,'Visible','off')       
    end % MESSAGE LINE
    
    set(h0,'ResizeFcn',updfcn) % Function to be called on resize
    set(h0,'KeyPressFcn',updfcn) % Function to be called on resize
else
    oo_message(1,message); 
end

drawnow

if Locset.tracker
    f=uicontextmenu;
    uimenu(f,'Label','Copy window','Callback','oo_copywindow');
    set(h0,'UIContextMenu',f)
end

%get(h0)

% -------------- REPORT ON ----------

if 0==1 % Switch
    disp(' ')    
    disp('----- QQ_DRAWWIN -----')
    disp(['TAG:' winpar{1}])
    disp(['NAME:' get(h0,'Name')])
    disp(['CALLERTAG: ' callertag])
    disp(['DELETE FCN: ' delfunc])
    disp('----- ---------- -----')
    disp(' ')    
end
    


