function oo_maincall(call)
% function maincall(call)
% Funksjon koblet til hovedvinduet

global Metset Locset Pos Design
%global status

if nargin<1 call=0; end

oo_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    oo_initialsettings
    openwin
    design=[];
    oo_message(1,['|b|Chrombox Optimizer Version: ' Locset.version ]) %'    Method: ' Metset.file_method])  
end

% Resume
if call==88
    fn=[Locset.path_root '\Tempsave.mat'];
    Oldmet=Metset;
    load(fn,'Metset','Design');
    checkmet(Oldmet); % Loader metset
end

% Tempsave
if call==89
    fn=[Locset.path_root '\Tempsave.mat'];
    oo_savefile(fn,Metset,Design,'-o');
end


% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    quitfunction
end
if call==99.1 % Exit
    h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat']; 
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_maincall (update) ----')   
end

if call==-1
    oo_message(1,'|r|Not implemented')
end

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% -------------- SUBFUNCTION CHECKMET -------------------
% Adds fields that where not loaded in Metset. Ensures compatibility with
% old data. 
function checkmet(Oldmet)
global Metset
%disp('--- checkmet ---')

fnam=fieldnames(Oldmet); le=length(fnam);
for x=1:le
    if isfield(Metset,fnam{x})==0 Metset.(fnam{x})=Oldmet.(fnam{x}); end
end

% -------- ------ SUBFUNCTION QUITFUNCTION -------------------
function quitfunction
global Colors Pos

winpos=Pos.window;

h=findobj('Tag','QuitWin');
if isempty(h)
    %winpar={'QuitWin','Quit',[0.1 0.5 0.3 0.4]};
    winpar={'QuitWin','Quit',[winpos(1) winpos(2) winpos(3)*0.25 winpos(4)*0.4]};
    p=1; [ui{p,1:7}] = deal('Return to O','Pushbutton',Colors.close,[0.1 0.1 0.5 0.1],...
        'close(gcf)',2,'');
    p=p+1; [ui{p,1:7}] = deal('Quit Matlab','Pushbutton',Colors.reset,[0.1 0.25 0.5 0.1],...
        'close(gcf); oo_maincall(99.2)',2,'');
    p=p+1; [ui{p,1:7}] = deal('Quit O','Pushbutton',Colors.reset,[0.1 0.4 0.5 0.1],...
        'close(gcf); oo_maincall(99.1); clear all',2,'');
    p=p+1; [ui{p,1:7}] = deal('Save and quit Matlab','Pushbutton',Colors.accept,[0.1 0.55 0.5 0.1],...
        'close(gcf); oo_maincall(89); oo_maincall(99.2)',2,'Disabledbutton');
    p=p+1; [ui{p,1:7}] = deal('Save and quit O','Pushbutton',Colors.accept,[0.1 0.7 0.5 0.1],...
        'close(gcf); oo_maincall(89); oo_maincall(99.1) ; clear all',2,'Disabledbutton');
    p=p+1; [ui{p,1:7}] = deal('Save Method','Pushbutton',Colors.btn{3},[0.1 0.85 0.5 0.1],...
        'oo_maincall(99.3)',2,'Disabledbutton');
    h0=oo_drawwin(winpar,ui,''); 
    set(h0,'WindowStyle','modal');
    disabled=findobj(h0,'Tag','Disabledbutton'); set(disabled,'Enable','off');
end


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='MainWin'; winpar{2}='Chrombox Optimizer: Main';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Quit','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_maincall(99)',3,'','');
p=p+1;[ui{p,1:8}] = deal('Tempsave','Pushbutton',Colors.bc,[x(2) y(1) bw bh*1.5],'oo_maincall(89)',3,'','-bm');
p=p+1;[ui{p,1:8}] = deal('Resume','Pushbutton',Colors.bc,[x(3) y(1) bw bh*1.5],'oo_maincall(88)',3,'','-bm');

% Design
p=p+1;[ui{p,1:8}] = deal('Design','Pushbutton',Colors.btn{1},[x(1) y(8) bw bh],'oo_design(0)',2,'',''); 
p=p+1;[ui{p,1:8}] = deal('Experiments','Pushbutton',Colors.btn{1},[x(1) y(7) bw bh],'oo_readdata(0)',2,'',''); 
p=p+1;[ui{p,1:8}] = deal('2D Model','Pushbutton',Colors.btn{1},[x(1) y(6) bw bh],'oo_model(0)',2,'',''); 
p=p+1;[ui{p,1:8}] = deal('3D Model','Pushbutton',Colors.btn{1},[x(2) y(6) bw bh],'',2,'','-d'); 
p=p+1;[ui{p,1:8}] = deal('VD Model','Pushbutton',Colors.btn{1},[x(3) y(6) bw bh],'oo_model_vd(0)',2,'',''); 
%p=p+1;[ui{p,1:8}] = deal('Model (old)','Pushbutton',Colors.btn{1},[x(5) y(6) bw bh],'oo_model2(0)',2,'',''); 

% Textbox
%p=p+1;[ui{p,1:7}] = deal('','Frame',Colors.bc,[x(8) y(1) bw*2.5 y(8)-y(1)+bh],'',2,'');
%p=p+1;[ui{p,1:7}] = deal('','Text',Colors.bc,[x(8)+bw/4 y(1)+bh/2 bw*2 y(8)-y(1)],'',2,'MainTextBox');


updfcn='oo_maincall(100)'; 
h0=oo_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_maincall(96)')
set(h0,'CloseRequestFcn','oo_maincall(99)')


