function oo_report_xls_multiple(Reportstruct)
global Metset
%oo_message(1,'|r|Excel report not implemented, try Data Interchange format')

pathname=[Reportstruct(1).pathname '.xls'];

for tn=1:length(Reportstruct)
    lno=0; Outstr=[];

    % ------------- Writes header -------------
    for x=1:length(Reportstruct(tn).header)
        lno=lno+1;
        Outstr{lno,1}=[' ' Reportstruct(tn).header{x}];
    end
        
    % ------------- convert to typstr -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells);
    [dummy,n_headerlines]=size(Reportstruct(tn).columntitle);
    U=[]; typestr=[];

    for hn=1:n_headerlines
        lno=lno+1; 
        for cn=1:n_columns
            Outstr{lno,cn}=[' ' Reportstruct(tn).columntitle{cn,hn}];
        end
    end
    
    for rn=1:n_rows
        lno=lno+1;
        for cn=1:n_columns
            if strcmp(Reportstruct(tn).format{cn,rn},'str')
                Outstr{lno,cn}=[' ' Reportstruct(tn).cells{cn,rn}];
            else
                Outstr{lno,cn}=Reportstruct(tn).cells{cn,rn};
                if isnan(Reportstruct(tn).cells{cn,rn})
                    Outstr{lno,cn}='NaN'; 
                end                             
            end
        end
    end
      
    for x=1:length(Reportstruct(tn).footer)
        lno=lno+1;
        Outstr{lno,1}=Reportstruct(tn).footer{x};
    end               


    try
        xlswrite(pathname,Outstr,tn)            
    catch
        oo_message(1,'|r|XLS write failed. File may be open, folder non-existent, or xls write may not be supported by current Matlab version (try dif-export)')
    end    
    
    
    
end % for tn


if isfield(Metset,'report_aopen') && Metset.report_aopen==1
    try
        winopen(pathname)
    catch
        oo_message(1,'|r|Could not open file')
    end
end



