function oo_report_xls_single(Reportstruct,openfile)

if nargin<2 openfile=0; end

lno=0;
for tn=1:length(Reportstruct)

    % ------------- Writes header -------------
    if isfield(Reportstruct(tn),'header') && ~isempty(Reportstruct(tn).header)
        for x=1:length(Reportstruct(tn).header)
            lno=lno+1;
            Outstr{lno,1}=[' ' Reportstruct(tn).header{x}];
        end
    end
        
    % ------------- convert to typstr -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells); n_headerlines=0;
    if isfield(Reportstruct(tn),'columntitle') && ~isempty(Reportstruct(tn).columntitle)
        [dummy,n_headerlines]=size(Reportstruct(tn).columntitle);
    end
    U=[]; typestr=[];

    for hn=1:n_headerlines
        lno=lno+1; 
        for cn=1:n_columns
            Outstr{lno,cn}=[' ' Reportstruct(tn).columntitle{cn,hn}];
        end
    end
    
    for rn=1:n_rows
        lno=lno+1;
        for cn=1:n_columns
            if strcmp(Reportstruct(tn).format{cn,rn},'str')
                Outstr{lno,cn}=[' ' Reportstruct(tn).cells{cn,rn}];
            else
                Outstr{lno,cn}=Reportstruct(tn).cells{cn,rn};
                if isnan(Reportstruct(tn).cells{cn,rn})
                    Outstr{lno,cn}='NaN'; 
                end
            end
        end
    end
    
    if isfield(Reportstruct(tn),'footer') && ~isempty(Reportstruct(tn).footer)
        for x=1:length(Reportstruct(tn).footer)
            lno=lno+1;
            Outstr{lno,1}=Reportstruct(tn).footer{x};
        end
    end               

end % for tn


pathname=[Reportstruct(1).pathname '.xls'];
try
    xlswrite(pathname,Outstr)
    if openfile
        try
            winopen(pathname)
        catch
            oo_message(1,'|r|Could not open file')
        end
    end
             
catch
    oo_message(1,'|r|XLS write failed. File may be open, folder non-existent, or xls write may not be supported by current Matlab version (try dif-export)')
end





