function oo_setlocset(Savesettings)

fileext='';
fh=fopen([Savesettings.path_root '\oo_localsettings.csv'],'r');
if fh~=-1
    fileext='csv'; fclose(fh); 
else
    fh=fopen([Savesettings.path_root '\oo_localsettings.sdv'],'r'); % old type settings
    if fh ~=-1 fileext='sdv'; fclose(fh); end
end
clockv=clock;
datestr=[num2str(clockv(1)) '_' num2str(clockv(2)) '_' num2str(clockv(3)) '_' num2str(clockv(4)) '_' num2str(clockv(5)) '_' num2str(round(clockv(6)))];
oldfn=[Savesettings.path_root '\oo_localsettings.' fileext];
newfn=[Savesettings.path_export '\oo_localsettings_' datestr '.bak'];

if isempty(fileext)
    oo_message(1,'|r|Error: Could not backup old settings, new settings not saved')
else

    % Backups old file
    fh=fopen(oldfn,'r');
    tline=1; p=0;
    while  tline~=-1
        tline=fgetl(fh);
        if tline~=-1 p=p+1; readstr{p}=tline; end
    end
    fclose(fh);

    linefeed=char([13 10]);
    fh=fopen(newfn,'w');
    for x=1:length(readstr)
        fprintf(fh, '%s', [readstr{x} linefeed]);
    end
    fclose(fh);

    % Writes new file
    pathname=[Savesettings.path_root '\oo_localsettings.' fileext]; % 
    linefeed=char([13 10]);
    fh=fopen(pathname,'w');

    Savesettings=rmfield(Savesettings,{'path_code','path_root','scrwidth','scrheight'}); % Fields that are not set in oo_localsettings

    fn=fieldnames(Savesettings); fn=sort(fn);

    for x=1:length(fn)
        varname=fn{x};
        content=Savesettings.(fn{x});
        if isnumeric(content)
            if length(content)>1
                contentstr='[';
                for y=1:length(content)
                    contentstr=[contentstr ' ' num2str(content(y))];
                end
                 contentstr=[contentstr ']'];
            else
                contentstr=num2str(content);
            end
        else
            contentstr=content;
        end
        comment='';
        if strmatch(varname,'defaultmethod') comment='Method to load on startup'; end   
        if strmatch(varname,'defaultfolders') comment='1 use default folder settings, 0 use paths specified below'; end   
        if strmatch(varname,'tracker') comment='For development purposes, 0 or 1'; end
        if strmatch(varname,'version') comment='Code version to use'; end
        if strmatch(varname,'user') comment='User ID for info fields'; end
        if strmatch(varname,'windowpos') comment='Window position and size [leftposition lowerposition width height] in fractions of screen size'; end
        if strmatch(varname,'path_rawdata') comment='Rawdata folder'; end    
        if strmatch(varname,'path_designs') comment='Folder for saved designs'; end    
        if strmatch(varname,'path_experiments') comment='Folder for experimental data'; end     
        if strmatch(varname,'path_models') comment='Folder for saved models'; end            
        if strmatch(varname,'path_results') comment='Folder for results'; end     
        if strmatch(varname,'path_reports') comment='Folder for reports'; end              
        if strmatch(varname,'path_export') comment='Folder for import/export of various data'; end 
        if strmatch(varname,'path_method') comment='Folder for methods'; end
        if strmatch(varname,'defaulfolders') comment='Overrides path settings with default values (oo_root\export,library,method,reports,results,qqraw)'; end  
        printstr{x}=[varname '; ' contentstr '; ' comment];
    end

    for x=1:length(printstr)
        fprintf(fh, '%s', [printstr{x} linefeed]);
    end
    fclose(fh);   
    
    if fh==-1
        oo_message(1,'|r|Error: Could not write new settings to file. File may be open by another application')
    else
        oo_message(1,['|b|Settings saved. Old settings copied to ' newfn])
    end
   
end







