function oo_design(call)
% function maincall(call)
% Funksjon koblet til hovedvinduet

global Metset Design Locset
%global status

if nargin<1 call=0; end

if Locset.tracker disp(['--- oo_design ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    openwin
    getdesigns
    updateparameters
    designupdate
    getcsvdes
end

% select number of factors
% nFactorsEdit
if call==1.1
    Metset.n_factors=Metset.n_factors-1;
end
if call==1.2
    Metset.n_factors=Metset.n_factors+1;
end
if call==1.3
    h=findobj(gcf,'Tag','nFactorsEdit');
    str=get(h,'String');
    val=str2double(str);
    if ~isempty(val) Metset.n_factors=val; end
end
if call>1 && call<2
    if Metset.n_factors>3 Metset.n_factors=3; end
    if Metset.n_factors<2 Metset.n_factors=2; end
    h=findobj(gcf,'Tag','nFactorsEdit');
    set(h,'String',num2str(Metset.n_factors));
    updateparameters
end

% readsettings
if call==2
    readsettings
end

% Create
if call==3
    if sum([Metset.usefactorial,Metset.usestar,Metset.useboxbehnken,Metset.usedoehlert])>0
        buildmodel
        designupdate
    else
        zz_message(1,'No design selected','-r')
    end
end
% import
if call==3.5
    csvimport 
    designupdate
    updateparameters
end
    

% Save/load
if call==4.1
    SaveEdit=findobj(gcf,'Tag','SaveEdit'); filename=get(SaveEdit,'String');
    pathname=[Locset.path_designs '\' Metset.path_designs '\design_' filename '.mat'];
    oo_savefile(pathname,Design,Metset)
    getdesigns
end
if call==4.2
    InclMethCheck=findobj(gcf,'Tag','InclMethCheck');
    inclmeth=get(InclMethCheck,'Value');
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    str=get(DesignFilesPop,'String');
    val=get(DesignFilesPop,'Value');
    filename=str{val};
    pathname=[Locset.path_designs '\' Metset.path_designs '\design_' filename '.mat']; 
    if inclmeth
        Oldmet=Metset;
        load(pathname,'Design','Metset');
        fn=fieldnames(Metset); for x=1:length(fn); Oldmet.(fn{x})=Metset.(fn{x}); end; Metset=Oldmet;
    else
        load(pathname,'Design');
    end
    updateparameters
    designupdate  
end



% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    oo_closewin
end
if call==99.1 % Exit
    h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat']; 
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_design (update) ----')   
    getcsvdes
end

if call==-1
    zz_message(1,'Not implemented','-r')
end

%Design.codesdomain % TEMP
%Design.parametersdomain % TEMP

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------------- csvimport ---------------------
function csvimport
global Locset Metset Design

%disp('---csvimport---')

CsvFilesPop=findobj(gcf,'Tag','CsvFilesPop');

val=get(CsvFilesPop,'Value'); STR=get(CsvFilesPop,'String');

pathname=[Locset.path_designs filesep Metset.path_designs filesep 'design_' STR{val} '.csv'];

if exist(pathname)~=2
    zz_message(1,'File not found','-r')
    return
end

set(findobj(gcf,'Tag','SaveEdit'),'String',STR{val})
    
% reads file and fills STRS
fid = fopen(pathname,'r'); 
readnext=1; ln=0;
if fid~=-1
    maxcols=0;
    while readnext
        tline=fgetl(fid);
        if ~ischar(tline) 
            readnext=0; 
        else
            ln=ln+1; 
            ind=strfind(tline,','); tline(ind)=';'; % Convert "," to ";" 
            STRS{ln}=[tline ';'];
            maxcols=max([maxcols numel(strfind(tline,';'))+1]);
        end
    end
    fclose(fid);
end
maxlines=numel(STRS);

% Find numeric values in X
X=repmat(NaN,maxlines,maxcols); % Preallocate
nl=0;
for x=1:numel(STRS)
    str=STRS{x};
    if ~isempty(str)
        ind=[0 strfind(str,';')];
        if numel(ind)>1
            nl=nl+1;
            for y=1:numel(ind)-1             
                X(nl,y)=str2double(str(ind(y)+1:ind(y+1)-1));
            end
        end
    end
end
 
% Removesd rows and columns with all NaNs
NaNmat=isnan(X); keepind=sum(NaNmat,1)<maxlines; X=X(:,keepind);
[maxlines,maxcols]=size(X); % Updates size of X 
keepind=sum(NaNmat,2)<maxcols; X=X(keepind,:);

% Header
[maxlines,maxcols]=size(X);
for x=1:maxcols
    header{x}=['Param_' num2str(x)]; % Makes temporary header
end
str=STRS{1};
ind=[0 strfind(str,';')];
nc=min([numel(ind)-1 maxcols]);
for x=1:nc
    hstr=str(ind(x)+1:ind(x+1)-1);
    hstr=deblank(fliplr(hstr)); hstr=deblank(fliplr(hstr));
    if isnan(str2double(hstr)) && ~isempty(hstr) % if non-numeric and not empty
        header{x}=hstr;
    end
end

% Creates codes
maxx=max(X); minx=min(X); meanx=mean(X); weights=2./(maxx-minx);
% centering and weighting
for x=1:numel(meanx) codes(:,x)=X(:,x)-meanx(x); codes(:,x)=codes(:,x)*weights(x); end

NDesign.codes=codes;
NDesign.parameters=X;
NDesign.colormatrix=repmat(0.6,maxlines,3);
NDesign.instrumentresolution=repmat(0.001,1,maxcols);
NDesign.paramnames=header;
NDesign.codesdomain(1,:)=repmat(-1,1,maxcols);
NDesign.codesdomain(2,:)=repmat(1,1,maxcols);
NDesign.parametersdomain(1,:)=minx;
NDesign.parametersdomain(2,:)=maxx;
NDesign.n_factors=maxcols;
NDesign.n_experiments=maxlines;

Design=NDesign;

% Updates Metset
Metset.usefactorial=0;
Metset.usestar=0;
Metset.useboxbehnken=0;
Metset.usedoehlert=0;
Metset.usecenter=0;
Metset.normalizedesigns=0;
Metset.n_factors=Design.n_factors;
Metset.factorialscale=1;
Metset.starscale=1;
Metset.doehlertscale=1;
Metset.boxscale=1;
for x=1:Design.n_factors
    Metset.(['param_name' num2str(x)])=Design.paramnames{x};
    Metset.(['param_low' num2str(x)])=minx(x);
    Metset.(['param_high' num2str(x)])=maxx(x);
    Metset.(['param_resol' num2str(x)])=Design.instrumentresolution(x);
end


% ------------------- getcsvdes ---------------------
function getcsvdes
global Locset Metset

searchstr=[Locset.path_designs filesep Metset.path_designs filesep 'design_*.csv'];
D=dir(searchstr);
if isempty(D)
    set(findobj(gcf,'Tag','CsvFilesPop'),'Enable','off','String','-')
else
    for x=1:numel(D)
        ostr{x}=D(x).name(8:end-4);
    end
    set(findobj(gcf,'Tag','CsvFilesPop'),'Enable','on','String',ostr)
end


% ------------------- designupdate ---------------------
function designupdate
global Design

if ~isempty(Design)
    designlist(Design)

    switch Design.n_factors
        case 1
            oo_designplot2(Design)
        case 2
            oo_designplot2(Design)
        case 3
            oo_designplot3(Design)
    end      
end


% ------------------- getdesigns ---------------------
function getdesigns
global Metset Locset

pathname=[Locset.path_designs '\' Metset.path_designs '\design_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        designnames{x}=DD(x).name(8:length(DD(x).name)-4);
    end   
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    set(DesignFilesPop,'String',designnames)   
end
 


% ------------------- designlist ---------------------
function designlist(Design)
global Colors

showstr{1}='empty';

[n_experiments,n_factors]=size(Design.codes);

lineno=0; colno=0;
for x=1:n_experiments
    colno=0;
    lineno=lineno+1; 
    % Numbers
    colno=colno+1;
    numberstr{x}=num2str(x); fl(x,colno)=length(numberstr{x})+1;
    
    % design types
    designtype='Import'; colno=colno+1; 
    if isequal(Design.colormatrix(x,:),Colors.center) designtype='Center'; end
    if isequal(Design.colormatrix(x,:),Colors.factorial) designtype='Factor'; end    
    if isequal(Design.colormatrix(x,:),Colors.star) designtype='Star'; end        
    if isequal(Design.colormatrix(x,:),Colors.box) designtype='BxB'; end        
    if isequal(Design.colormatrix(x,:),Colors.doehlert) designtype='Dhlert'; end     
    typecell{x}=[designtype '  ']; fl(x,colno)=length(typecell{x});
    
    % factors
    for y=1:n_factors
        colno=colno+1;
        codestr=[num2str(Design.codes(x,y),'%+1.3f') ' ']; 
        codecell{x,y}=codestr;
        fl(x,colno)=length(codestr);
    end
    
    % Norm
    colno=colno+1;
    normcell{x}=[' Norm: ' num2str(norm(Design.codes(x,:)),'%1.2f') '  ']; fl(x,colno)=length(normcell{x});
      
    % Parameters
    for y=1:n_factors
        colno=colno+1;
        paramstr=[Design.paramnames{y} ':' num2str(Design.parameters(x,y)) ' '];
        paramcell{x,y}=paramstr; fl(x,colno)=length(paramstr);
    end
end

fieldlengths=max(fl); strtempl=blanks(sum(fieldlengths));
lineno=0;
for x=1:n_experiments
    allstr=strtempl; fieldno=0; lineno=lineno+1;
    
    % numbers
    fieldno=fieldno+1;
    startpos=sum(fieldlengths(1:fieldno))-fl(x,fieldno)+1;
    endpos=startpos+length(numberstr{x})-1;
    allstr(startpos:endpos)=numberstr{x};
    
    % type
    fieldno=fieldno+1;
    %startpos=sum(fieldlengths(1:fieldno))-fl(x,fieldno)+1;
    startpos=sum(fieldlengths(1:fieldno-1))+1;
    endpos=startpos+length(typecell{x})-1;
    allstr(startpos:endpos)=typecell{x};    
    
    % codes
    allstr(sum(fieldlengths(1:fieldno)))='[';
    for y=1:n_factors
        fieldno=fieldno+1;
        startpos=sum(fieldlengths(1:fieldno))-fl(x,fieldno)+1;
        endpos=startpos+length(codecell{x,y})-1;
        %length(codecell{x,y});
        allstr(startpos:endpos)=codecell{x,y};
    end
    allstr(sum(fieldlengths(1:fieldno)))=']';
    
    % Norm
    fieldno=fieldno+1;
    startpos=sum(fieldlengths(1:fieldno))-fl(x,fieldno)+1;
    endpos=startpos+length(normcell{x})-1;
    allstr(startpos:endpos)=normcell{x};   
    
    % Parameters
    for y=1:n_factors
        fieldno=fieldno+1;
        startpos=sum(fieldlengths(1:fieldno-1))+1;
        endpos=startpos+length(paramcell{x,y})-1;
        allstr(startpos:endpos)=paramcell{x,y};
    end  
    
    showstr{lineno}=allstr;
end

lineno=lineno+1;
for y=1:n_factors
    lineno=lineno+1;
    showstr{lineno}=[Design.paramnames{y} ' Range: ' num2str(min(Design.parameters(:,y))) ' to ' num2str(max(Design.parameters(:,y)))];         
end

DesignList=findobj('Tag','DesignList');
set(DesignList,'String',showstr,'BackgroundColor',[1 1 1],'Value',1);

oo_copylist(0,DesignList)



% ------------------- buildmodel ---------------------
function buildmodel
global Metset Design Colors

%disp('--- buildmodel ---')

if Metset.n_factors==2
    scales=[]; design=[]; colormatrix=[];
    if Metset.usecenter
        design=Metset.center2; colormatrix=Colors.center;
    end
    if Metset.usefactorial
        design=[design; normdesign(Metset.factorial2)*Metset.factorialscale]; 
        [n_rows,n_cols]=size(Metset.factorial2); 
        colormatrix=[colormatrix; repmat(Colors.factorial,n_rows,1)];
        scales=[scales Metset.factorialscale];
    end
    if Metset.usestar
        design=[design; normdesign(Metset.star2)*Metset.starscale];
        [n_rows,n_cols]=size(Metset.star2); 
        colormatrix=[colormatrix; repmat(Colors.star,n_rows,1)];    
        scales=[scales Metset.starscale];
    end
    if Metset.usedoehlert
        design=[design; normdesign(Metset.doehlert2)*Metset.doehlertscale];
        [n_rows,n_cols]=size(Metset.doehlert2); 
        colormatrix=[colormatrix; repmat(Colors.doehlert,n_rows,1)];  
        scales=[scales Metset.doehlertscale];
    end    
    codesdomain=Metset.star2*max(scales);
end

if Metset.n_factors==3
    design=Metset.center3; colormatrix=Colors.center;
    scales=[]; design=[]; colormatrix=[];
    if Metset.usecenter
        design=Metset.center3; colormatrix=Colors.center;
    end
    if Metset.usefactorial
        design=[design; normdesign(Metset.factorial3)*Metset.factorialscale];
        [n_rows,n_cols]=size(Metset.factorial3); 
        colormatrix=[colormatrix; repmat(Colors.factorial,n_rows,1)];
        scales=[scales Metset.factorialscale];
    end
    if Metset.usestar
        design=[design; normdesign(Metset.star3)*Metset.starscale];
        [n_rows,n_cols]=size(Metset.star3); 
        colormatrix=[colormatrix; repmat(Colors.star,n_rows,1)]; 
        scales=[scales Metset.starscale];
    end
    if Metset.useboxbehnken
        design=[design; normdesign(Metset.box3)*Metset.boxscale];
        [n_rows,n_cols]=size(Metset.box3); 
        colormatrix=[colormatrix; repmat(Colors.box,n_rows,1)]; 
        scales=[scales Metset.boxscale];
    end
    if Metset.usedoehlert
        design=[design; normdesign(Metset.doehlert3)*Metset.doehlertscale];
        [n_rows,n_cols]=size(Metset.doehlert3); 
        colormatrix=[colormatrix; repmat(Colors.doehlert,n_rows,1)];   
        scales=[scales Metset.doehlertscale];
    end   
    codesdomain=Metset.star3*max(scales);
end

%design % TEMP
%design=normdesign(design)

% Calculates instrumental parameters
[n_rows,n_cols]=size(design);
for x=1:Metset.n_factors
    multiplier(:,x)=repmat(((Metset.(['param_high' num2str(x)]) - Metset.(['param_low' num2str(x)]))/2),n_rows,1);
    meanvalues(:,x)=repmat(((Metset.(['param_high' num2str(x)]) + Metset.(['param_low' num2str(x)]))/2),n_rows,1); 
end
instvalues=design.*multiplier;
instvalues=instvalues+meanvalues;
% Rounds to instrument resolution, adds parameter name
for x=1:Metset.n_factors
    instrumentresolution(x)=Metset.(['param_resol' num2str(x)]);
    instvalues(:,x)=instvalues(:,x)/Metset.(['param_resol' num2str(x)]);
    instvalues(:,x)=round(instvalues(:,x));
    instvalues(:,x)=instvalues(:,x)*Metset.(['param_resol' num2str(x)]);
    parametername{x}=Metset.(['param_name' num2str(x)]);
end
    
% Calculates domain
multiplier=[]; meanvalues=[];
[n_rows,n_cols]=size(codesdomain);
for x=1:Metset.n_factors
    multiplier(:,x)=repmat(((Metset.(['param_high' num2str(x)]) - Metset.(['param_low' num2str(x)]))/2),n_rows,1);
    meanvalues(:,x)=repmat(((Metset.(['param_high' num2str(x)]) + Metset.(['param_low' num2str(x)]))/2),n_rows,1); 
end
parametersdomain=codesdomain.*multiplier;
parametersdomain=parametersdomain+meanvalues;

Design.codes=design;
Design.parameters=instvalues;
Design.colormatrix=colormatrix;
Design.instrumentresolution=instrumentresolution;
Design.paramnames=parametername;
Design.codesdomain=codesdomain;
Design.parametersdomain=parametersdomain;
Design.n_factors=n_cols;
Design.n_experiments=n_rows;

% ------------------- normdesign ---------------------
function design=normdesign(design)
global Metset

[n_exp,n_param]=size(design);

if Metset.normalizedesigns
    for expno=1:n_exp
        nm=norm(design(expno,:));
        if nm>0
            design(expno,:)=design(expno,:)*(nm);
        end
            
    end
else
    for paramno=1:n_param
        range=max(design(:,paramno))-min(design(:,paramno));
        design(:,paramno)=design(:,paramno)*(2/range);
    end 
end

% ------------------- updateparameters ---------------------
function updateparameters
global Metset

for pmno=1:3
    h=findobj(gcf,'Tag',['Metset.param_name' num2str(pmno)]); set(h,'Enable','off','String','')
    h=findobj(gcf,'Tag',['Metset.param_low' num2str(pmno)]); set(h,'Enable','off','String','')
    h=findobj(gcf,'Tag',['Metset.param_high' num2str(pmno)]); set(h,'Enable','off','String','')
    h=findobj(gcf,'Tag',['Metset.param_resol' num2str(pmno)]); set(h,'Enable','off','String','')
end
for pmno=1:Metset.n_factors    
    h=findobj(gcf,'Tag',['Metset.param_name' num2str(pmno)]); set(h,'Enable','on','String',Metset.(['param_name' num2str(pmno)]))
    h=findobj(gcf,'Tag',['Metset.param_low' num2str(pmno)]); set(h,'Enable','on','String',num2str(Metset.(['param_low' num2str(pmno)])))
    h=findobj(gcf,'Tag',['Metset.param_high' num2str(pmno)]); set(h,'Enable','on','String',num2str(Metset.(['param_high' num2str(pmno)])))
    h=findobj(gcf,'Tag',['Metset.param_resol' num2str(pmno)]); set(h,'Enable','on','String',num2str(Metset.(['param_resol' num2str(pmno)])))
end

BoxscaleEdit=findobj(gcf,'Tag','BoxscaleEdit'); 
BoxCheck=findobj(gcf,'Tag','BoxCheck');
if Metset.n_factors<3
    set(BoxscaleEdit,'Enable','off')
    set(BoxCheck,'Enable','off','Value',0)
    Metset.useboxbehnken=0;
else
    set(BoxscaleEdit,'Enable','on')
    set(BoxCheck,'Enable','on')
end

% Sets n_factors
nFactorsEdit=findobj(gcf,'Tag','nFactorsEdit'); set(nFactorsEdit,'String',num2str(Metset.n_factors))

% Sets values for designtype
FactorialCheck=findobj(gcf,'Tag','FactorialCheck'); set(FactorialCheck,'Value',Metset.usefactorial)
StarCheck=findobj(gcf,'Tag','StarCheck'); set(StarCheck,'Value',Metset.usestar)
BoxCheck=findobj(gcf,'Tag','BoxCheck'); set(BoxCheck,'Value',Metset.useboxbehnken)
DoehlertCheck=findobj(gcf,'Tag','DoehlertCheck'); set(DoehlertCheck,'Value',Metset.usedoehlert)
CenterCheck=findobj(gcf,'Tag','CenterCheck'); set(CenterCheck,'Value',Metset.usecenter)
NormCheck=findobj(gcf,'Tag','NormCheck'); set(NormCheck,'Value',Metset.normalizedesigns)

% Sets values for design scales
FactorialscaleEdit=findobj(gcf,'Tag','FactorialscaleEdit'); set(FactorialscaleEdit,'String',num2str(Metset.factorialscale))
StarscaleEdit=findobj(gcf,'Tag','StarscaleEdit'); set(StarscaleEdit,'String',num2str(Metset.starscale))
BoxscaleEdit=findobj(gcf,'Tag','BoxscaleEdit'); set(BoxscaleEdit,'String',num2str(Metset.boxscale))
DoehlertscaleEdit=findobj(gcf,'Tag','DoehlertscaleEdit'); set(DoehlertscaleEdit,'String',num2str(Metset.doehlertscale))
%NormfactorEdit=findobj(gcf,'Tag','NormfactorEdit'); set(NormfactorEdit,'String',num2str(Metset.normfactor))

% Sets values for plots
DrawBoxCheck=findobj(gcf,'Tag','DrawBoxCheck'); set(DrawBoxCheck,'Value',Metset.plot_drawbox)
PlanesCheck=findobj(gcf,'Tag','PlanesCheck'); set(PlanesCheck,'Value',Metset.plot_drawplanes)
LinesCheck=findobj(gcf,'Tag','LinesCheck'); set(LinesCheck,'Value',Metset.plot_drawlines)
%DrawBoxEdit=findobj(gcf,'Tag','DrawBoxEdit'); set(DrawBoxEdit,'String',num2str(Metset.plot_boxscale))
InstrParamCheck=findobj(gcf,'Tag','InstrParamCheck'); set(InstrParamCheck,'Value',Metset.plot_instrumentparameters)


% ------------------- readsettings ---------------------
function readsettings
global Metset Colors

% Reads instrument parameters
for pmno=1:3
    h=findobj(gcf,'Tag',['Metset.param_name' num2str(pmno)]); Metset.(['param_name' num2str(pmno)])=get(h,'String');   
    h=findobj(gcf,'Tag',['Metset.param_low' num2str(pmno)]); val=str2double(get(h,'String'));
    if isempty(val) || isnan(val)
        set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.(['param_low' num2str(pmno)])));
    else
        Metset.(['param_low' num2str(pmno)])=val; set(h,'BackgroundColor',[1 1 1]);
    end    
    h=findobj(gcf,'Tag',['Metset.param_high' num2str(pmno)]); val=str2double(get(h,'String'));
    if isempty(val) || isnan(val)
        set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.(['param_high' num2str(pmno)])));
    else
        Metset.(['param_high' num2str(pmno)])=val; set(h,'BackgroundColor',[1 1 1]);
    end        
    h=findobj(gcf,'Tag',['Metset.param_resol' num2str(pmno)]); val=str2double(get(h,'String'));
    if isempty(val) || isnan(val)
        set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.(['param_resol' num2str(pmno)])));
    else
        Metset.(['param_resol' num2str(pmno)])=val; set(h,'BackgroundColor',[1 1 1]);
    end   
end

% Get values for designtype
FactorialCheck=findobj(gcf,'Tag','FactorialCheck'); Metset.usefactorial=get(FactorialCheck,'Value');
StarCheck=findobj(gcf,'Tag','StarCheck'); Metset.usestar=get(StarCheck,'Value');
BoxCheck=findobj(gcf,'Tag','BoxCheck'); Metset.useboxbehnken=get(BoxCheck,'Value');
DoehlertCheck=findobj(gcf,'Tag','DoehlertCheck'); Metset.usedoehlert=get(DoehlertCheck,'Value');
CenterCheck=findobj(gcf,'Tag','CenterCheck'); Metset.usecenter=get(CenterCheck,'Value');
NormCheck=findobj(gcf,'Tag','NormCheck'); Metset.normalizedesigns=get(NormCheck,'Value');

InstrParamCheck=findobj(gcf,'Tag','InstrParamCheck'); Metset.plot_instrumentparameters=get(InstrParamCheck,'Value');

% Get values for design scale
h=findobj(gcf,'Tag','FactorialscaleEdit'); val=str2double(get(h,'String'));
if isempty(val) || isnan(val) || val<=0
    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.factorialscale));
else
    Metset.factorialscale=val; set(h,'BackgroundColor',Colors.factorial);
end    
h=findobj(gcf,'Tag','StarscaleEdit'); val=str2double(get(h,'String'));
if isempty(val) || isnan(val) || val<=0
    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.starscale));
else
    Metset.starscale=val; set(h,'BackgroundColor',Colors.star);
end  
h=findobj(gcf,'Tag','BoxscaleEdit'); val=str2double(get(h,'String'));
if isempty(val) || isnan(val) || val<=0
    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.boxscale));
else
    Metset.boxscale=val; set(h,'BackgroundColor',Colors.box);
end 
h=findobj(gcf,'Tag','DoehlertscaleEdit'); val=str2double(get(h,'String'));
if isempty(val) || isnan(val) || val<=0
    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.doehlertscale));
else
    Metset.doehlertscale=val; set(h,'BackgroundColor',Colors.doehlert);
end 
%h=findobj(gcf,'Tag','NormfactorEdit'); val=str2double(get(h,'String'));
%if isempty(val) || isnan(val) || val<=0
%    Metset.normfactor=1;
%    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.normfactor));
%else
%    Metset.normfactor=val; set(h,'BackgroundColor',[1 1 1]);
%end 

% read values for plots
DrawBoxCheck=findobj(gcf,'Tag','DrawBoxCheck'); Metset.plot_drawbox=get(DrawBoxCheck,'Value');
PlanesCheck=findobj(gcf,'Tag','PlanesCheck'); Metset.plot_drawplanes=get(PlanesCheck,'Value');
LinesCheck=findobj(gcf,'Tag','LinesCheck'); Metset.plot_drawlines=get(LinesCheck,'Value');

h=findobj(gcf,'Tag','DrawBoxEdit'); val=str2double(get(h,'String'));
if isempty(val) || isnan(val) || val<=0
    set(h,'BackgroundColor',[1 1 0],'String',num2str(Metset.plot_boxscale));
else
    Metset.plot_boxscale=val; set(h,'BackgroundColor',[1 1 1]);
end  




%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='DesignWin'; winpar{2}='Chrombox Optimizer: Design';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_design(99)',3,'','');
%p=p+1;[ui{p,1:8}] = deal('Tempsave','Pushbutton',Colors.bc,[x(2) y(1) bw bh*1.5],'oo_maincall(89)',3,'','-bm');
%p=p+1;[ui{p,1:8}] = deal('Resume','Pushbutton',Colors.bc,[x(3) y(1) bw bh*1.5],'oo_maincall(88)',3,'','-bm');

% Calculate
vp=8;
p=p+1;[ui{p,1:7}] = deal('Create','Pushbutton',Colors.btn{1},[x(1) y(vp) bw bh],'oo_design(3)',2,'FButton');
p=p+1;[ui{p,1:7}] = deal('<','Pushbutton',Colors.bc,[x(2) y(vp) bw/3 bh],'oo_design(1.1)',3,'');
p=p+1;[ui{p,1:7}] = deal('>','Pushbutton',Colors.bc,[x(2)+bw*2/3 y(vp) bw/3 bh],'oo_design(1.2)',3,'');
p=p+1;[ui{p,1:8}] = deal(num2str(Metset.n_factors),'Edit',[1 1 1],[x(2)+bw/3 y(vp) bw/3 bh],'oo_design(1.3)',3,'nFactorsEdit','-c');
p=p+1;[ui{p,1:7}] = deal('Import CSV','Pushbutton',Colors.btn{1},[x(4) y(vp) bw bh],'oo_design(3.5)',2,'FButton');
p=p+1;[ui{p,1:8}] = deal('-','Popupmenu',[1 1 1],[x(5) y(vp) bw eh],'',2,'CsvFilesPop','');


% Normalize
p=p+1;[ui{p,1:7}] = deal('Normalized','Checkbox',Colors.bc,[x(3) y(vp) bw*0.9 eh],'oo_design(2)',2,'NormCheck');
% Include
vp=vp-1;
p=p+1;[ui{p,1:7}] = deal('Factorial','Checkbox',Colors.factorial,[x(1) y(vp) bw eh],'oo_design(2)',2,'FactorialCheck');
p=p+1;[ui{p,1:7}] = deal('Star','Checkbox',Colors.star,[x(2) y(vp) bw eh],'oo_design(2)',2,'StarCheck');
p=p+1;[ui{p,1:7}] = deal('Box-Behnken','Checkbox',Colors.box,[x(3) y(vp) bw eh],'oo_design(2)',2,'BoxCheck');
p=p+1;[ui{p,1:7}] = deal('Doehlert','Checkbox',Colors.doehlert,[x(4) y(vp) bw eh],'oo_design(2)',2,'DoehlertCheck');
% Scale
vp=vp-1;
p=p+1;[ui{p,1:7}] = deal(num2str(Metset.factorialscale),'Edit',Colors.factorial,[x(1)+bw*0.4 y(vp) bw*0.5 eh],'oo_design(2)',2,'FactorialscaleEdit');
p=p+1;[ui{p,1:7}] = deal(num2str(Metset.starscale),'Edit',Colors.star,[x(2)+bw*0.4 y(vp) bw*0.5 eh],'oo_design(2)',2,'StarscaleEdit');
p=p+1;[ui{p,1:7}] = deal(num2str(Metset.boxscale),'Edit',Colors.box,[x(3)+bw*0.4 y(vp) bw*0.5 eh],'oo_design(2)',2,'BoxscaleEdit');
p=p+1;[ui{p,1:7}] = deal(num2str(Metset.doehlertscale),'Edit',Colors.doehlert,[x(4)+bw*0.4 y(vp) bw*0.5 eh],'oo_design(2)',2,'DoehlertscaleEdit');
% Center point
vp=vp-1;
p=p+1;[ui{p,1:7}] = deal('Centerpoint','Checkbox',Colors.center,[x(1) y(vp) bw eh],'oo_design(2)',2,'CenterCheck');

% Frame
vp=vp-1;
p=p+1;[ui{p,1:7}] = deal('','Frame',[0 0 0],[x(1) y(vp)+bh/2 bw*4.5 0.003],'',2,'');
% Plot settings
vp=vp-1;
p=p+1;[ui{p,1:7}] = deal('Plot Instrument parameters','Checkbox',Colors.bc,[x(1) y(vp) bw*2 bh],'oo_design(2)',2,'InstrParamCheck');
%p=p+1;[ui{p,1:7}] = deal('Box Sc:','Text',Colors.bc,[x(2)+bw*0.1 y(vp)-bh/4 bw bh],'',2,'');
%p=p+1;[ui{p,1:7}] = deal('1','Edit',[1 1 1],[x(2)+bw*0.65 y(vp) bw*0.25 eh],'oo_design(2)',2,'DrawBoxEdit');
p=p+1;[ui{p,1:7}] = deal('Box','Checkbox',Colors.bc,[x(3) y(vp) bw*0.5 eh],'oo_design(2)',2,'DrawBoxCheck');
p=p+1;[ui{p,1:7}] = deal('Planes','Checkbox',Colors.bc,[x(3)+bw*0.4 y(vp) bw*0.6 eh],'oo_design(2)',2,'PlanesCheck');
p=p+1;[ui{p,1:7}] = deal('Lines','Checkbox',Colors.bc,[x(4) y(vp) bw eh],'oo_design(2)',2,'LinesCheck');

% instrument parameters
vp=8; ho=gw*0.5;
p=p+1;[ui{p,1:7}] = deal('Instrument parameters','Text',Colors.bc,[x(6)+ho y(vp)-bh/4 bw*2 bh],'',3,'');
for pmno=1:3
    vp=vp-1;
    p=p+1;[ui{p,1:8}] = deal(['Param. ' num2str(pmno)],'Text',Colors.bc,[x(6)+ho y(vp)-bh/4 bw/2 eh],'',2,'','-r');
    p=p+1;[ui{p,1:8}] = deal(Metset.(['param_name' num2str(pmno)]),'Edit',[1 1 1],[x(6)+ho+gw/2 y(vp)-bh/4 bw eh],'oo_design(2)',2,['Metset.param_name' num2str(pmno)],'');
    p=p+1;[ui{p,1:8}] = deal('Low: ','Text',Colors.bc,[x(7)+ho y(vp)-bh/4 gw/2 eh],'',2,'','-r');
    p=p+1;[ui{p,1:8}] = deal(Metset.(['param_low' num2str(pmno)]),'Edit',[1 1 1],[x(7)+ho+gw/2 y(vp)-bh/4 bw/2 eh],'oo_design(2)',2,['Metset.param_low' num2str(pmno)],'-r');
    p=p+1;[ui{p,1:8}] = deal('High: ','Text',Colors.bc,[x(8)+ho y(vp)-bh/4 gw/2 eh],'',2,'','-r');
    p=p+1;[ui{p,1:8}] = deal(Metset.(['param_high' num2str(pmno)]),'Edit',[1 1 1],[x(8)+ho+gw/2 y(vp)-bh/4 bw/2 eh],'oo_design(2)',2,['Metset.param_high' num2str(pmno)],'-r');
    p=p+1;[ui{p,1:8}] = deal('Resol: ','Text',Colors.bc,[x(9)+ho y(vp)-bh/4 gw/2 eh],'',2,'','-r');
    p=p+1;[ui{p,1:8}] = deal(Metset.(['param_resol' num2str(pmno)]),'Edit',[1 1 1],[x(9)+ho+gw/2 y(vp)-bh/4 bw/2 eh],'oo_design(2)',2,['Metset.param_resol' num2str(pmno)],'-r');
end

% Designlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',Colors.center,Pos.leftplot,'',2,'DesignList');

% Save/load
p=p+1;[ui{p,1:8}] = deal('Save as','Pushbutton',Colors.disk,[x(4) y(1) bw bh],'oo_design(4.1)',2,'','');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(5) y(1) bw eh],'',2,'SaveEdit','');
p=p+1;[ui{p,1:8}] = deal('Load','Pushbutton',Colors.disk,[x(6) y(1) bw bh],'oo_design(4.2)',2,'','');
p=p+1;[ui{p,1:8}] = deal('-','Popupmenu',[1 1 1],[x(7) y(1) bw eh],'',2,'DesignFilesPop','');
p=p+1;[ui{p,1:8}] = deal('Include method','Checkbox',Colors.bc,[x(8) y(1) bw*2 eh],'',2,'InclMethCheck','');


% Textbox
%p=p+1;[ui{p,1:7}] = deal('','Frame',Colors.bc,[x(8) y(1) bw*2.5 y(8)-y(1)+bh],'',2,'');
%p=p+1;[ui{p,1:7}] = deal('','Text',Colors.bc,[x(8)+bw/4 y(1)+bh/2 bw*2 y(8)-y(1)],'',2,'MainTextBox');


updfcn='oo_design(100)'; 
h0=oo_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_design(96)')
set(h0,'CloseRequestFcn','oo_design(99)')

h=findobj(gcf,'Tag','InclMethCheck'); set(h,'Value',1)






