function oo_designplot3(Design)
global Metset Colors Pos

%disp('--- oo_designplot3 ---')

if Metset.plot_instrumentparameters
    matrix=Design.parameters;    
    domain=Design.parametersdomain;
else
    matrix=Design.codes; 
    domain=Design.codesdomain;    
end
colormatrix=Design.colormatrix;

freefactor=0.05; % offset for axes.

minx=min(domain(:,1)); maxx=max(domain(:,1));
rangex=(maxx-minx); xoff=rangex*freefactor; limx=[minx-xoff maxx+xoff];
miny=min(domain(:,2)); maxy=max(domain(:,2));
rangey=(maxy-miny); yoff=rangey*freefactor; limy=[miny-yoff maxy+yoff];
minz=min(domain(:,3)); maxz=max(domain(:,3));
rangez=(maxz-minz); zoff=rangez*freefactor; limz=[minz-zoff maxz+zoff];
plotcenter=[(maxx+minx)/2 (maxy+miny)/2 (maxz+minz)/2];

% Creates plot
existingplot=findobj(gcf,'Position',Pos.rightplot); delete(existingplot)
%axesh=subplot('Position',Pos.rightplot,'XTick',[-1 0 1],'YTick',[-1 0 1],'ZTick',[-1 0 1]);
axesh=subplot('Position',Pos.rightplot);
set(axesh,'XTick',[-1 0 1],'YTick',[-1 0 1],'ZTick',[-1 0 1]);

% Adds spheres
[m,n]=size(matrix); 
[XM,YM,ZM]=sphere(50); 
sizex=rangex/40; sizey=rangey/40; sizez=rangez/40;
for x=1:m
    XP=XM*sizex; YP=YM*sizey; ZP=ZM*sizez; % Skalering
    XP=XP+matrix(x,1); YP=YP+matrix(x,2); ZP=ZP+matrix(x,3);  
    h=surf(XP,YP,ZP,'EdgeColor','none','FaceColor',[colormatrix(x,1) colormatrix(x,2) colormatrix(x,3)],'Ambientstrength',0.5);
    %set(h,'FaceLightning','phong','FaceColor','interp','Ambientstrength','0.5')  
    hold on   
end
set(gca,'GridLineStyle','none')
camlight right
lighting phong
material shiny
set(gca,'Projection','Perspective')    
set(gca,'box','off','PlotBoxAspectRatioMode','manual');
set(gca,'CameraTarget',plotcenter,'View',[-22.6824 9.40313])
%campos([-16.3 -39 7])
%set(gca,'View',[-22.6824 9.40313])
%campos([minx miny minz])

% Outer box and background surface
if Metset.plot_drawbox==1  
    fa=0.1; ek=[0.8 0.8 0.8]; %fc='none';
    line([minx maxx],[miny miny],[minz minz],'Color',ek); line([minx maxx],[maxy maxy],[minz minz],'Color',ek)
    line([minx minx],[miny maxy],[minz minz],'Color',ek); line([maxx maxx],[miny maxy],[minz minz],'Color',ek)
    line([minx maxx],[miny miny],[maxz maxz],'Color',ek); line([minx maxx],[maxy maxy],[maxz maxz],'Color',ek)
    line([minx minx],[miny maxy],[maxz maxz],'Color',ek); line([maxx maxx],[miny maxy],[maxz maxz],'Color',ek)
    line([minx minx],[miny miny],[minz maxz],'Color',ek); line([maxx maxx],[miny miny],[minz maxz],'Color',ek)
    line([minx minx],[maxy maxy],[minz maxz],'Color',ek); line([maxx maxx],[maxy maxy],[minz maxz],'Color',ek)
    % Background surface
    fa=0.1; ek=[0.5 0.5 0.5]; fc=[0.8 0.8 0.8];
    fill3([minx maxx maxx minx],[miny miny maxy maxy],[minz minz minz minz],fc,'EdgeColor',ek,'FaceAlpha',fa');
    fill3([maxx maxx maxx maxx],[miny miny maxy maxy],[minz maxz maxz minz],fc,'EdgeColor',ek,'FaceAlpha',fa');
    fill3([minx maxx maxx minx],[maxy maxy maxy maxy],[minz minz maxz maxz],fc,'EdgeColor',ek,'FaceAlpha',fa');
end

% Planes
if Metset.plot_drawplanes
    fa=0.5; fc=[0.9 0.8 0.8]; %ek=[0.5 0.5 0.5];
    p1=patch([maxx maxx minx minx],[maxy miny miny maxy],[plotcenter(3) plotcenter(3) plotcenter(3) plotcenter(3)],fc,'FaceAlpha',fa,'EdgeColor','none');
    p2=patch([maxx maxx minx minx],[plotcenter(2) plotcenter(2) plotcenter(2) plotcenter(2)],[maxz minz minz maxz],fc,'FaceAlpha',fa,'EdgeColor','none'); 
    p3=patch([plotcenter(1) plotcenter(1) plotcenter(1) plotcenter(1)],[maxy maxy miny miny],[maxz minz minz maxz],fc,'FaceAlpha',fa,'EdgeColor','none'); 
end

% --------- LINES -----------

% lines for star
starmatrix=matrix(ismember(colormatrix,Colors.star,'rows'),:);
if ~isempty(starmatrix) && Metset.plot_drawlines
    cms=sum(colormatrix,2); ind=find(cms==sum(Colors.star)); le=length(ind);
    for x=1:le
        pos=matrix(ind(x),:);
        line([plotcenter(1),pos(1)],[plotcenter(2),pos(2)],[plotcenter(3),pos(3)],'Color',Colors.star,'LineWidth',2)
    end
end

% Lines for factorial
factorialmatrix=matrix(ismember(colormatrix,Colors.factorial,'rows'),:);
if ~isempty(factorialmatrix) && Metset.plot_drawlines
    fminx=min(factorialmatrix(:,1)); fmaxx=max(factorialmatrix(:,1)); 
    fminy=min(factorialmatrix(:,2)); fmaxy=max(factorialmatrix(:,2));
    fminz=min(factorialmatrix(:,3)); fmaxz=max(factorialmatrix(:,3));
    fa=0.1; ek=Colors.factorial; 
    patch([fminx fminx fminx fminx],[fminy fmaxy fmaxy fminy],[fminz fminz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
    patch([fmaxx fmaxx fmaxx fmaxx],[fminy fmaxy fmaxy fminy],[fminz fminz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');  
    patch([fminx fmaxx fmaxx fminx],[fminy fminy fmaxy fmaxy],[fminz fminz fminz fminz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
    patch([fminx fmaxx fmaxx fminx],[fminy fminy fmaxy fmaxy],[fmaxz fmaxz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
end

% lines for Box Behnken
bbmatrix=matrix(ismember(colormatrix,Colors.box,'rows'),:);
if ~isempty(bbmatrix) && Metset.plot_drawlines
    fminx=min(bbmatrix(:,1)); fmaxx=max(bbmatrix(:,1)); 
    fminy=min(bbmatrix(:,2)); fmaxy=max(bbmatrix(:,2));
    fminz=min(bbmatrix(:,3)); fmaxz=max(bbmatrix(:,3));
    fa=0.1; ek=Colors.box; 
    patch([fminx fminx fminx fminx],[fminy fmaxy fmaxy fminy],[fminz fminz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
    patch([fmaxx fmaxx fmaxx fmaxx],[fminy fmaxy fmaxy fminy],[fminz fminz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');  
    patch([fminx fmaxx fmaxx fminx],[fminy fminy fmaxy fmaxy],[fminz fminz fminz fminz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
    patch([fminx fmaxx fmaxx fminx],[fminy fminy fmaxy fmaxy],[fmaxz fmaxz fmaxz fmaxz],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
end

% Lines for Doehlert
% Doerhlertlines; Line from each point to four nearest neighbours
dmatrix=matrix(ismember(colormatrix,Colors.doehlert,'rows'),:);
if ~isempty(dmatrix) && Metset.plot_drawlines
    % calculates normalized matrix
    normmatrix(:,1)=dmatrix(:,1)-plotcenter(1); normmatrix(:,2)=dmatrix(:,2)-plotcenter(2); normmatrix(:,3)=dmatrix(:,3)-plotcenter(3);
    normmatrix(:,1)=normmatrix(:,1)/(rangex/2); normmatrix(:,2)=normmatrix(:,2)/(rangey/2); normmatrix(:,3)=normmatrix(:,3)/(rangez/2);
    [m,n]=size(dmatrix);
    % finds neighbours (in normalized matrix) and draws lines (using
    % original matrix)
    for x=1:m
        for y=1:m dist(y)=sum((normmatrix(x,:)-normmatrix(y,:)).^2)^0.5; end
        i4=find(dist==min(dist)); dist(i4)=1000; [sd,i5]=sort(dist);
        for z=1:4
            line([dmatrix(x,1) dmatrix(i5(z),1)],[dmatrix(x,2) dmatrix(i5(z),2)],[dmatrix(x,3) dmatrix(i5(z),3)],'LineWidth',2,'Color',Colors.doehlert);          
        end
    end
end

set(gca,'FontSize',14); 
set(gca,'Xlim',limx,'Ylim',limy,'Zlim',limz)
set(gca,'XTick',[minx; plotcenter(1); maxx],'YTick',[miny; plotcenter(2); maxy],'ZTick',[minz; plotcenter(3); maxz]) 


oo_copyfigure