function cmap=oo_getcmap
% returns color map according to settings in Metset
global Metset

cmap=[];

switch Metset.contour_colormap
    case 'hotcold'
        cmap=hotcold;
    case 'traffic'
        cmap=traffic;
    otherwise
        cmap=eval([Metset.contour_colormap ';']);
end
        

%if strcmp(Metset.contour_colormap,'hotcold')
%    cmap=hotcold;
%else
%    cmap=eval([Metset.contour_colormap ';']);
%end

if Metset.contour_invertscale
    cmap=flipud(cmap);
end

if Metset.contour_invertcolor
    cmap=1-cmap;
end


% Brightness
if Metset.contour_brightness>100 Metset.contour_brightness=100; end
if Metset.contour_brightness<50
    mf=Metset.contour_brightness/50;
    cmap=cmap*mf;
    
end
if Metset.contour_brightness>50
    cmap=1-cmap; % invert
    cf=(100-Metset.contour_brightness)/50; cmap=cmap*cf;
    cmap=1-cmap; % invert back   
end

function cmap=hotcold

CM(1:16,3)=linspace(0.5,1,16); % First blue 0.5 to 1
DM(1:16,3)=1; DM(1:16,2)=linspace(0.0588,0.9412,16); DM(1:16,1)=linspace(0.0588,0.9412,16); % Second, blue to almost white
BM=[CM;DM]; % Blue colors
RM=fliplr(BM); RM=flipud(RM);  RM(:,2)=RM(:,2)*0.95; %red colors
RM(:,3)=RM(:,3)*0.95; % darken 
cmap=[BM;RM];

function cmap=traffic

CM=zeros(64,3);
CM(1:32,2)=1; CM(1:32,1)=linspace(0,1,32);
CM(32:64,1)=1; CM(32:64,2)=linspace(1,0,33);
cmap=CM;















