function oo_initialsettings

% function initialsettings
% Settings for:
% Set global variables Metset, Colors, Pos, fonts

global Metset Pos Colors fonts Locset

%--------- LOCSET --------
if isfield(Locset,'path_rawdata')==0 Locset.path_rawdata=[Locset.path_root '\rawdata']; end % Rawdata
if isfield(Locset,'path_designs')==0 Locset.path_designs=[Locset.path_root '\designs']; end % Saved models
if isfield(Locset,'path_experiments')==0 Locset.path_experiments=[Locset.path_root '\experiments']; end % Experimental data
if isfield(Locset,'path_models')==0 Locset.path_models=[Locset.path_root '\models']; end % Saved models
if isfield(Locset,'path_results')==0 Locset.path_results=[Locset.path_root '\results']; end % Results
if isfield(Locset,'path_reports')==0 Locset.path_reports=[Locset.path_root '\reports']; end % Reports
if isfield(Locset,'path_export')==0 Locset.path_export=[Locset.path_root '\export']; end  % Exporterte filer fra dette prg.
if isfield(Locset,'path_method')==0 Locset.path_method=[Locset.path_root '\methods']; end  % Exporterte filer fra dette prg.
Locset.path_code=[Locset.path_root '\code\' Locset.version]; % Program code
if isfield(Locset,'tracker')==0 Locset.tracker=0; end
if isfield(Locset,'user')==0 Locset.user='Anonymous'; end

% overrides foldersettings if Locset.defaulfolders=1
if isfield(Locset,'defaultfolders') && Locset.defaultfolders==1
    Locset.path_rawdata=[Locset.path_root '\rawdata'];
    Locset.path_designs=[Locset.path_root '\designs'];
    Locset.path_experiments=[Locset.path_root '\experiments'];
    Locset.path_models=[Locset.path_root '\models'];
    Locset.path_results=[Locset.path_root '\results'];
    Locset.path_reports=[Locset.path_root '\reports'];    
    Locset.path_export=[Locset.path_root '\export'];
    Locset.path_method=[Locset.path_root '\methods'];
end

%--------- METSET --------
Metset.path_rawdata=''; 
Metset.path_designs=''; 
Metset.path_experiments=''; 
Metset.path_models='';  
Metset.path_results='';    % Results
Metset.path_reports='';    % Reports
Metset.path_export='';     % Exporterte filer fra dette prg.
Metset.path_method='';     % Metodesamling
Metset.path_code='';       % Program

Metset.file_method='Default';       % Program

Metset.global_overwrite=0; % overwrite files on/off
Metset.global_saveas_v6=1; % Save in Matlab v6.x format
Metset.global_makedir=0; % Automatically create directories 
Metset.global_lastchange=now; % Keeps track of changes to method;
Metset.global_lastsave=now; % Keeps track of changes to method;
Metset.global_warnings=1; % Check for warnings on/off

Metset.center2=[0 0];
Metset.factorial2=[-1 -1 ; -1 1; 1 -1; 1 1]/2^0.5;
Metset.star2=[-1 0; 1 0; 0 -1;  0 1];
Metset.doehlert2=[-1 0; -0.5 -0.866; 1 0; 0.5 0.866; -0.5 0.866; 0.5 -0.866];

Metset.center3=[0 0 0];
Metset.factorial3=[-1 -1 -1; 1 -1 -1; -1 1 -1; 1 1 -1; -1 -1 1; 1 -1 1; -1 1 1; 1 1 1]/3^0.5;
Metset.star3=[-1 0 0; 1 0 0; 0 -1 0; 0 1 0; 0 0 -1; 0 0 1];
Metset.doehlert3=[1 0 0; 0.5 0.866 0; 0.5 0.2887 0.8165; ...
        -1 0 0; -0.5 -0.866 0; -0.5 -0.2887 -0.8165; 0.5 -0.866 0; 0.5 -0.2887 -0.8165; ...
        0 0.5774 -0.8165; -0.5 0.8660 0; -0.5 0.2887 0.8165; 0 -0.5774 0.8165];
Metset.box3=[-1 -1 0; +1 -1 0; -1 1 0; 1 1 0; -1 0 -1; 1 0 -1; -1 0 1; 1 0 1; 0 -1 -1; 0 +1 -1; 0 -1 +1; 0 +1 +1]/2^0.5;    

Metset.usefactorial=0;
Metset.usestar=0;
Metset.useboxbehnken=0;
Metset.usedoehlert=1;
Metset.usecenter=1;
Metset.normalizedesigns=1;

Metset.n_factors=3;
Metset.factorialscale=1;
Metset.starscale=1;
Metset.doehlertscale=1;
Metset.boxscale=1;
%Metset.normfactor=1; % Obsolete

for x=1:3
    Metset.(['param_name' num2str(x)])=['Param-' num2str(x)];
    Metset.(['param_low' num2str(x)])=-1;
    Metset.(['param_high' num2str(x)])=1;
    Metset.(['param_resol' num2str(x)])=0.001;
end

Metset.plot_drawbox=0;
Metset.plot_drawplanes=0;
Metset.plot_drawlines=0;
Metset.plot_boxscale=1;
Metset.plot_instrumentparameters=1;

Metset.import_filetype='Chrombox C'; % File type to import

Metset.report_pref={'Text file (txt)'}; % Preferred report
Metset.report_padstring='0'; % fill for empty values in reports
Metset.report_aopen=1; % Auto open reports
Metset.report_compact=0; % Condensed report (miner)

Metset.contour_levelset='Set levels';
Metset.contour_nlevels=20;
Metset.contour_spacing=1;
Metset.contour_colormap='jet';
Metset.contour_labels=1; % Labels on
Metset.contour_isolines=1; % isolines on
Metset.contour_showdesign=1; % plot design points
Metset.contour_brightness=50; % Adjust brightness
Metset.contour_invertscale=0; % Inverts the scale if on
Metset.contour_invertcolor=0; % Negative colors if on
Metset.contour_centercol=0; % Centers colormap around 0
Metset.contour_colorlimits=0; % use color limits, overrides centering
Metset.contour_colormin=-1; % Fixed Clim lower
Metset.contour_colormax=1; % Fixed Clim, upper

%Metset.param_name='Param-2';
%Metset.param_low=-1;
%Metset.param_high=1;
%Metset.param_high=1;

%--------- POSITIONS ----------

Pos.window=Locset.windowpos;  % Position for main window
Pos.gl=0.02; % grid left
Pos.gb=0.05; % Grid bottom
Pos.gw=0.1; % grid width
Pos.gh=0.04; % grid height
Pos.bh=Pos.gh*0.9; % button height
Pos.bw=Pos.gw*0.9;  % button width
Pos.eh=Pos.bh*0.8; % Edit hight
Pos.textoffset=Pos.gh/10; % Subtract from one-line text to align with buttons

Pos.xg=Pos.gl:Pos.gw:1; % horizontal grid
Pos.yg=Pos.gb:Pos.gh:1; % vertical grid;

Pos.largeplot=[Pos.gl Pos.yg(11) 1-(2*Pos.gl) 1-Pos.yg(11)-Pos.gh*0.5]; % Posisjon for stort plott
Pos.smallplot=[0.6 0.085 0.35 0.34]; % Posisjon for lite plott
Pos.leftplot=[Pos.gl Pos.yg(11) 4*Pos.gw 1-Pos.yg(11)-Pos.gh*0.5]; % Posisjon for stort plott
Pos.rightplot=[Pos.gl+5.5*Pos.gw Pos.yg(11) 4*Pos.gw 1-Pos.yg(11)-Pos.gh*0.5];

% get pixel/point dimensions
mwunits=get(0,'Units'); 
set(0,'Units','pixels'); scrsize=get(0,'ScreenSize');
Pos.pixwidth=1/scrsize(3);
Pos.pixheight=1/scrsize(4);
set(0,'Units','points'); scrsize=get(0,'ScreenSize');
Pos.pointwidth=1/scrsize(3);
Pos.pointheight=1/scrsize(4);
set(0,'Units',mwunits);


%---------- COLORS -------------
Colors.bc=[0.5 0.5 0.7]; % Background color

Colors.btn{1}=[1 0.5 0]; % orange, 
Colors.btn{2}=[1 0.7 0.7]; % pink, LIBRARY
Colors.btn{3}=[0.7 1 0.7]; % light green, RETENTION INDEX
Colors.btn{4}=[0 1 1]; % cyan
Colors.btn{5}=[0.75 0.75 0.75]; % grey
Colors.btn{6}=[0.5 0.5 1]; % blue % REPORT
Colors.btn{7}=[1 1 0.5]; % yellow % LOCK PEAKS

Colors.data=[1 0.5 0];
Colors.meth=[0.4 1 0.6];
Colors.disk=[0.8 0.9 0.9];
Colors.close=[1 1 0.65];
Colors.reset=[1 0 0];
Colors.accept=[0 1 0];
Colors.report=[0.6 0.6 0.6]; 
Colors.blue=[0.5 0.5 1];

Colors.star=[0.7 0 0.7];
Colors.factorial=[0 0.3 1];
Colors.doehlert=[0 0.8 0];
Colors.box=[1 0 0];
Colors.center=[0.5 0.5 0.5];

% ------------ FONTS ------------
fonts=[8 10 12 14 16];
set(0,'Units','Pixels'); screen=get(0,'ScreenSize'); % Collects screen size
if screen(3)<1000 fonts=[6 8 10 12 14]; end

% ------------ UPDATE Zset ------------
oo_setz

%disp('---- oo_initialsettings: Metset  ----') % TEMP
%Metset % TEMP
%disp('---- oo_initialsettings: Locset  ----') % TEMP
%Locset % TEMP
