function oo_model2(call)
% function maincall(call)
% Funksjon koblet til hovedvinduet

global Metset Experimental Locset Modset Models
%global status

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model2 ---' num2str(call)]); end

oo_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    Experimental=[];
    Models=[];
    Modset.listtype=1; % Data
    Modset.codetype=1; % Codes  
    openwin
    getexperiments
    getmodels
end

if call==1.1
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments '\' Metset.path_experiments '\exp_' strs{val} '.mat' ];
    load(pathname,'Experimental')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',strs{val})
    Models=[];
    parameterslist
    boxlist
    listupdate
end


% Change parameter
if call==3.3
    listupdate
end

% Model
if call==4.1
    %disp('--- model ---')
    calcmodels
    Modset.listtype=2;
    listupdate
end
if call==4.2
    %disp('--- model ---')
    calctargetmodels
    Modset.listtype=3;
    listupdate
end

% Surface plots
if call==5.1
    %disp('--- surface ---')
    surfaceplot2
end
if call==5.2
    %disp('--- ind surface ---')
    indcontour
end

% surftype radios
if call==6.1
    tag=get(gcbo,'Tag');
    radios=findobj(gcf,'Tag',tag); set(radios,'Value',0)
    set(gcbo,'Value',1)
end

if call==7.1
    listupdate
end

if call==8.1
    %disp('--- save model ---')
    if isempty(Models)
        oo_message(1,'|r|No models to save')
    else
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        filename=get(FileNameEdit,'String');
        if isempty(filename)
            oo_message(1,'|r|Select file name')
        else
            pathname=[ Locset.path_models '\' Metset.path_models '\mod_' filename '.mat'];
            oo_savefile(pathname,Models,Experimental,Modset)
        end    
    end   
end

if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models '\' Metset.path_models '\mod_' filename '.mat'];
    load(pathname,'Models','Experimental','Modset')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',filename)
    parameterslist
    boxlist
    listupdate  
end

% graphical selection, contour plot
if call==9.1
    %disp('--- graphical selection ----')
    [cp]=get(gca,'CurrentPoint'); xp=cp(1,1); yp=cp(1,2);
    checkpoint(xp,yp)
end
% individual trace info
if call==9.2
    %disp('--- individualinfo ---')
    %get(gcbo)
    userdat=get(gcbo,'UserData');
    str{1}=Experimental.codes{userdat(1)}; str{2}=Experimental.names{userdat(1)}; str{3}=Experimental.shortnames{userdat(1)};
    InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String',str,'Value',1)
end
if call==9.3
    %disp('--- selected point ---')
    xp=get(gcbo,'XData'); 
    xp=xp(1); 
    yp=get(gcbo,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end
if call==9.35
    %disp('--- selected point ---')
    xp=get(gco,'XData');
    xp=xp(1); 
    yp=get(gco,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end

% Input from edit
if call==9.4
    SelXEdit=findobj(gcf,'Tag','SelXEdit');
    xval=str2double(get(SelXEdit,'String'));
    set(SelXEdit,'String',num2str(xval));
    
    SelYEdit=findobj(gcf,'Tag','SelYEdit');
    yval=str2double(get(SelYEdit,'String'));
    set(SelYEdit,'String',num2str(yval));    
    
    if ~isnan(xval) && ~isnan(yval)
        checkpoint(xval,yval)
    end  
end

% set scale
if call==10.1
    str=get(gcbo,'String'); val=str2double(str); 
    if ~(~isnan(val) && val>=0); str='10'; end
    set(gcbo,'String',str)   
end

% minT/MaxT check
if call==11.1
    MinTCheck=findobj(gcf,'Tag','MinTCheck');
    MaxTCheck=findobj(gcf,'Tag','MaxTCheck');
    if gcbo==MinTCheck && get(gcbo,'Value')==1
        set(MaxTCheck,'Value',0)
    end
    if gcbo==MaxTCheck && get(gcbo,'Value')==1
        set(MinTCheck,'Value',0)
    end       
end
    

% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    oo_closewin
end
if call==99.1 % Exit
    %h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    %h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat']; 
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model2 (update) ----')   
end

if call==-1
    oo_message(1,'|r|Not implemented')
end

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

function listupdate
global Modset Models Experimental

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

callertag=get(gcbo,'Tag');

if strcmp(callertag,'CodeRadio')
    codestr=get(gcbo,'String');
    if strcmp(codestr,'Code')
        Modset.codetype=1;
    end
    if strcmp(codestr,'Name')
        Modset.codetype=2;
    end    
    if strcmp(codestr,'Short name')
        Modset.codetype=3;
    end        
end

if strcmp(callertag,'ListTypeRadio')
    liststr=get(gcbo,'String'); 
    if strcmp(liststr,'Show data')
    Modset.listtype=1;
    end
    if strcmp(liststr,'Abs. models')
       Modset.listtype=2;
    end    
    if strcmp(liststr,'Target mod.')
        Modset.listtype=3;
    end   
end

% set code types
if Modset.codetype==1;
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Modset.codetype==2;
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Modset.codetype==3;
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

if isempty(Models) Modset.listtype=1; end 
if isempty(Experimental) Modset.listtype=0; end 

% set list types
if Modset.listtype==1;
    h=findobj(ListTypeRadio,'String','Show data');
    set(h,'Value',1)
    datalist
end
if Modset.listtype==2;
    h=findobj(ListTypeRadio,'String','Abs. models');
    set(h,'Value',1)
    modelslist
end
if Modset.listtype==3;
    h=findobj(ListTypeRadio,'String','Target mod.');
    set(h,'Value',1)
    modelslist
end


% ------------------- indcontour ---------------------
function indcontour
global Models Experimental Pos Modset

DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

varname=getvarname;
if Modset.listtype==3
    varname=[varname '_tg'];
end

if Modset.codetype==1 cmpid=Experimental.codes; end
if Modset.codetype==2 cmpid=Experimental.names; end
if Modset.codetype==3 cmpid=Experimental.shortnames; end

AbsCheck=findobj(gcf,'Tag','AbsCheck');
absolutevalues=get(AbsCheck,'Value');

MinThreshEdit=findobj(gcf,'Tag','MinThreshEdit');
minthresh=str2double(get(MinThreshEdit,'String'));
MaxThreshEdit=findobj(gcf,'Tag','MaxThreshEdit');
maxthresh=str2double(get(MaxThreshEdit,'String'));

if isfield(Models,varname)
    l_models=length(Models.(varname));
else
    oo_message(1,'|r|No models')
    return
end

validtarget=1;
surfcolors=[0 0 1; 0 1 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75];
surfcolors=surfcolors(1:7,:); [n_colors,n]=size(surfcolors); colorno=0; 
missingmodels=[]; missingtargets=[]; validtarget=1; n_valids=0; ZM=[]; 

ph=subplot('Position',Pos.rightplot);
childs=get(ph,'Children');
delete(childs)

plotstatus=[];
vtextpos=1;
for x=1:length(selcmp)
    plotstatus(x)=0; % Sets plotstatus
    
    cmp=selcmp(x);
    colorno=colorno+1; if colorno>n_colors; colorno=1; surfcolors=surfcolors*0.75; end
    %disp(['--- file no ' num2str(cmp) ' ---'])
    if cmp<=l_models
        coeff=Models.(varname){cmp};
    else
        coeff=[]; 
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        %disp('--- passed ---')
        validmodel=1;
        [X_cont,Y_cont,Z_cont]=calcsurf(coeff);
    else
        %disp('---- missing model ---')
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end
    % Check target
    if strcmp(get(gcbo,'Tag'),'TargetSurfBtn'); 
        %disp('---- target surface ---')
        TargetPop=findobj(gcf,'Tag','TargetPop');
        targetfile=get(TargetPop,'Value');
        targetval=Experimental.(varname)(cmp,targetfile);
        if isnan(targetval)
            validtarget=0;
            missingtargets=[missingtargets cmp];
        else
            validtarget=1;        
        end   
        if validmodel && validtarget
            Z_cont=Z_cont-targetval;
        end          
    end
    
    if validmodel && validtarget
        %disp(['--- draws ' num2str(cmp) ' ---'])
        if absolutevalues Z_cont=abs(Z_cont); end   
                
        min_z=min(min(Z_cont));
        max_z=max(max(Z_cont));
        
        % Contour    
        if ~isnan(minthresh)  
            %ZM=Z_cont*-1; %thresh=minthresh*-1;    
            [C,h]=contourf(X_cont,Y_cont,Z_cont*-1,[-minthresh max(max(Z_cont*-1))+1]);
            if strcmpi(get(h(1),'Type'),'hggroup') h=get(h,'Children'); end %'hggroup' returned from newer Matlab versions
            set(h,'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],...
                'LineWidth',2,'EdgeColor',surfcolors(colorno,:)*0.75,...
                'ButtonDownFcn','oo_model2(9.2)','HitTest','on')
            
            Modset.plottype=3; % Ind. contour
            hold on
            
            if minthresh>min_z plotstatus(x)=1; end
            
            %min_z
            %max_z
            %thresh
            %h
            % SJEKK HVORDAN DET LSES I NYERE MATLAB
            % LEGG EVT INN SJEKK FOR OM H ER PATCH ELLER NOE ANNET 
            % GAMMEL KODE
            %set(h,'LineColor',surfcolors(colorno,:)*0.75,'Fill','on')
            %childs=get(h,'Children'); % Finds all patches
            %if ~isempty(childs) warn=0; end % warning if patch not drawn
            %for x=1:length(childs)
            %    set(childs(x),'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],'ButtonDownFcn','oo_model2(9.2)','HitTest','on')
            %end
        end
        
        if ~isnan(maxthresh)  
            [C,h]=contourf(X_cont,Y_cont,Z_cont,[maxthresh max(max(Z_cont))+1]);
            if strcmpi(get(h(1),'Type'),'hggroup') h=get(h,'Children'); end %'hggroup' returned from newer Matlab versions
            set(h,'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],...
                'LineWidth',2,'EdgeColor',surfcolors(colorno,:)*0.75,...
                'ButtonDownFcn','oo_model2(9.2)','HitTest','on')
            Modset.plottype=3; % Ind. contour
            hold on
            
            if max_z>maxthresh plotstatus(x)=1; end
            
        %    ZM=Z_cont; thresh=maxthresh; 
        %    %[C,h]=contour(X_cont,Y_cont,ZM,thresh,'LineWidth',2);
        %    [C,h]=contour(X_cont,Y_cont,ZM,thresh);
        %    set(h,'LineWidth',2)
            
        %    Modset.plottype=3; % Ind. contour
        %    hold on
        %    set(h,'LineColor',surfcolors(colorno,:)*0.75,'Fill','on')
        %    childs=get(h,'Children'); % Finds all patches
        %    if ~isempty(childs) warn=0; end % warning if patch not drawn
        %    for x=1:length(childs)
        %        set(childs(x),'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],'ButtonDownFcn','oo_model2(9.2)','HitTest','on')
        %    end
        end          

        % Adds text
        vtextpos=vtextpos-0.05; str=cmpid{cmp}; 
        if plotstatus(x)==0 str=[str '*']; end  
        th=text(0.97,vtextpos,str,'Units','Normalized','HorizontalAlignment','right',...
            'LineWidth',1,'EdgeColor',surfcolors(colorno,:)*0.75,'Color',surfcolors(colorno,:)*0.75,'FontWeight','Bold');

    end
end

[m,n_points]=size(Experimental.parameters);
hold on
for x=1:n_points
    plot(Experimental.parameters(1,x),Experimental.parameters(2,x),'o',...
        'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
        'MarkerEdgeColor',[1 1 1],'LineWidth', 2)    
end

hold off
oo_copyfigure

% Warnings
str=[];
if ~isempty(missingmodels)
    str=['- Missing models: '];
    for x=1:length(missingmodels)
        str=[str num2str(missingmodels(x)) ' '];
    end
end
if ~isempty(missingtargets)
    str=[' ' str ' - Missing targets: '];
    for x=1:length(missingtargets)
        str=[str num2str(missingtargets(x)) ' '];
    end
end
if isempty(plotstatus) || sum(plotstatus)==0
    str='Warning: No compounds matching thresholds';
end
if isempty(str)
    oo_message(1,'|b|No missing values')
else
    oo_message(1,['|r|' str])
end 

minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off','String','')
end
SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','off','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','off','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','off','String','')

InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')


% ------------------- surfaceplot2 ---------------------
function surfaceplot2
global Models Experimental Modset

DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

varname=getvarname;
if Modset.listtype==3
    varname=[varname '_tg'];
end

AbsCheck=findobj(gcf,'Tag','AbsCheck');
absolutevalues=get(AbsCheck,'Value');

if isfield(Models,varname)
    l_models=length(Models.(varname));
else
    oo_message(1,'|r|No models')
    return
end

missingmodels=[]; missingtargets=[]; validtarget=1; n_valids=0; ZM=[]; ZM_sum=[];
for x=1:length(selcmp)
    cmp=selcmp(x);
    if cmp<=l_models
        coeff=Models.(varname){cmp};
    else
        coeff=[]; 
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        %disp('--- passed ---')
        validmodel=1;
        [X_cont,Y_cont,Z_cont]=calcsurf(coeff);
    else
        %disp('---- missing model ---')
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end
    % Check target
    if strcmp(get(gcbo,'String'),'Target Surface'); 
        TargetPop=findobj(gcf,'Tag','TargetPop');
        targetfile=get(TargetPop,'Value');
        targetval=Experimental.(varname)(cmp,targetfile);
        if isnan(targetval)
            validtarget=0;
            missingtargets=[missingtargets cmp];
        else
            validtarget=1;        
        end   
        if validmodel && validtarget
            Z_cont=Z_cont-targetval;
        end
            
    end
    
    if validmodel && validtarget
        
        if absolutevalues Z_cont=abs(Z_cont); end
               
        n_valids=n_valids+1;
        if n_valids==1
            ZM_sum=Z_cont;
            ZM_max=Z_cont;
            ZM_min=Z_cont;
        else
            ZM_sum=ZM_sum+Z_cont; % sum
            ZM_max=max(ZM_max,Z_cont); % max
            ZM_min=min(ZM_min,Z_cont); % min
        end  
    end
end

if isempty(ZM_sum)==0   
    SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','Value',1);
    surftype=get(SurfTypeRadio,'String');
    if strcmp(surftype,'Mean')
        ZM=ZM_sum/n_valids;
    end
    if strcmp(surftype,'Sum')
        ZM=ZM_sum;
    end    
    if strcmp(surftype,'Max')
        ZM=ZM_max;
    end  
    if strcmp(surftype,'Min')
        ZM=ZM_min;
    end   
    contourplot(X_cont,Y_cont,ZM)
  
    str=[];
    if ~isempty(missingmodels)
        str=['- Missing models: '];
        for x=1:length(missingmodels)
            str=[str num2str(missingmodels(x)) ' '];
        end
    end
    if ~isempty(missingtargets)
        str=[' ' str ' - Missing targets: '];
        for x=1:length(missingtargets)
            str=[str num2str(missingtargets(x)) ' '];
        end
    end
    if isempty(str)
        oo_message(1,'|b|No missing values')
    else
        oo_message(1,['|r|' str])
    end  
    if strcmp(get(gcbo,'String'),'Target Surface'); 
        Modset.plottype=2; % Target surface
    else
        Modset.plottype=1; % Normal surface
    end
        
else 
    oo_message(1,'|r|No valid models')
end


% ------------------- contourplot ---------------------
function contourplot(X_cont,Y_cont,Z_cont)
global Experimental Pos Modset

min_z=min(min(Z_cont)); max_z=max(max(Z_cont));
interv=(max_z-min_z)/20; intervstr=num2str(interv,'%2.1g'); interv=str2num(intervstr);
min_z=min_z/interv; min_z=floor(min_z); min_z=min_z*interv;
max_z=max_z/interv; max_z=ceil(max_z);  max_z=max_z*interv;
v=min_z:interv:max_z;

subplot('Position',Pos.rightplot)
[C,h] = contourf(X_cont,Y_cont,Z_cont,v);
clabel(C,h)
set(h,'ButtonDownFcn','oo_model2(9.1)','Tag','Contourplot')
%get(h(1))

MinThreshEdit=findobj(gcf,'Tag','MinThreshEdit');
minthresh=str2double(get(MinThreshEdit,'String'));
if ~isnan(minthresh)
    hold on
    %[C,h] = contour(X_cont,Y_cont,Z_cont,minthresh,'Edgecolor',[0.5 1 0.5],'LineWidth',2);
    %set(h,'ButtonDownFcn','oo_model2(9.1)')
    [C,h] = contour(X_cont,Y_cont,Z_cont,[minthresh max(max(Z_cont))+1]);
    set(h,'ButtonDownFcn','oo_model2(9.1)','Edgecolor',[0.5 1 0.5],'LineWidth',2)
end
MaxThreshEdit=findobj(gcf,'Tag','MaxThreshEdit');
maxthresh=str2double(get(MaxThreshEdit,'String'));
if ~isnan(maxthresh)
    hold on
    %[C,h] = contour(X_cont,Y_cont,Z_cont,maxthresh,'Edgecolor',[1 0.5 0.5],'LineWidth',2);
    [C,h] = contour(X_cont,Y_cont,Z_cont,[maxthresh max(max(Z_cont))+1]);
    set(h,'Edgecolor',[1 0.5 0.5],'LineWidth',2);
    set(h,'ButtonDownFcn','oo_model2(9.1)')
end   
hold on
    
% TRACES
mintrace=get(findobj(gcf,'Tag','MinTCheck'),'Value');
maxtrace=get(findobj(gcf,'Tag','MaxTCheck'),'Value');

if mintrace || maxtrace  
    % Y-axis trace    
    if mintrace
        [mins,minind]=min(Z_cont');
    else
        [mins,minind]=max(Z_cont');
    end
    xv=X_cont(:,1)';
    yax=Y_cont(1,:);
    yv=Y_cont(1,minind);
    maxind=find(yv==max(yax)); xv(maxind)=[]; yv(maxind)=[];
    minind=find(yv==min(yax)); xv(minind)=[]; yv(minind)=[];
    % Smoothing
    if length(yv)>6
        for x=1:3
            ind=x:3:length(yv);
            yvp=yv(ind);
            xvp=xv(ind);
            Yi(x,:)=spline(xvp,yvp,xv);
        end
        yv=mean(Yi);
    end
    plot(xv,yv,'Color',[1 1 0],'LineWidth',2,'ButtonDownFcn','oo_model2(9.1)')

    % X-axis trace
    if mintrace
        [mins,minind]=min(Z_cont);
    else
        [mins,minind]=max(Z_cont);
    end    
    yv=Y_cont(1,:);
    xax=X_cont(:,1);
    xv=X_cont(minind,1);
    maxind=find(xv==max(xax)); xv(maxind)=[]; yv(maxind)=[];
    minind=find(xv==min(xax)); xv(minind)=[]; yv(minind)=[];
    if length(xv)>6
    % Smoothing
        for x=1:3
            ind=x:3:length(xv);
            xvp=xv(ind);
            yvp=yv(ind);
            Xi(x,:)=spline(yvp,xvp,yv);
        end
        xv=mean(Xi);
    end 
    plot(xv,yv,'Color',[1 0.5 0.5],'LineWidth',2,'ButtonDownFcn','oo_model2(9.1)')
end

% Experiments
[m,n_points]=size(Experimental.parameters);
for x=1:n_points
    plot(Experimental.parameters(1,x),Experimental.parameters(2,x),'o',...
        'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
        'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model2(9.3)')    
end

% Min and max
MinvalEdit1=findobj(gcf,'Tag','MinvalEdit1'); 
MinvalEdit2=findobj(gcf,'Tag','MinvalEdit2');
MinvalEdit3=findobj(gcf,'Tag','MinvalEdit3'); 
MinCheck=findobj(gcf,'Tag','MinCheck');
plotmin=get(MinCheck,'Value');
if plotmin
    minv=min(min(Z_cont));
    [ind1,ind2]=find(Z_cont==minv);
    ind1=ind1(1); ind2=ind2(1);
    minx=X_cont(ind1,ind2);
    miny=Y_cont(ind1,ind2);
    hold on
    plot(minx,miny,'o',...
        'MarkerSize',10,'MarkerFaceColor',[0.5 0.5 1],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model2(9.3)')
    set(MinvalEdit1,'String',num2str(minx,'%6.4g'),'Enable','on')
    set(MinvalEdit2,'String',num2str(miny,'%6.4g'),'Enable','on')
    set(MinvalEdit3,'String',num2str(minv,'%6.4g'),'Enable','on')
else
    set(MinvalEdit1,'String','','Enable','off'); set(MinvalEdit2,'String','','Enable','off'); set(MinvalEdit3,'String','','Enable','off')      
end

MaxvalEdit1=findobj(gcf,'Tag','MaxvalEdit1'); 
MaxvalEdit2=findobj(gcf,'Tag','MaxvalEdit2');
MaxvalEdit3=findobj(gcf,'Tag','MaxvalEdit3'); 
MaxCheck=findobj(gcf,'Tag','MaxCheck');
plotmax=get(MaxCheck,'Value');
if plotmax
    maxv=max(max(Z_cont));
    [ind1,ind2]=find(Z_cont==maxv);
    ind1=ind1(1); ind2=ind2(1);
    maxx=X_cont(ind1,ind2);
    maxy=Y_cont(ind1,ind2);
    hold on
    plot(maxx,maxy,'o',...
        'MarkerSize',10,'MarkerFaceColor',[1 0.5 0.5],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model2(9.3)')
    set(MaxvalEdit1,'String',num2str(maxx,'%6.4g'),'Enable','on')
    set(MaxvalEdit2,'String',num2str(maxy,'%6.4g'),'Enable','on')
    set(MaxvalEdit3,'String',num2str(maxv,'%6.4g'),'Enable','on')
else
    set(MaxvalEdit1,'String','','Enable','off'); set(MaxvalEdit2,'String','','Enable','off'); set(MaxvalEdit3,'String','','Enable','off')      
end

hold off
oo_copyfigure

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','on','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','on','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','on','String','')
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

Modset.currentcont_x=X_cont;
Modset.currentcont_y=Y_cont;
Modset.currentcont_z=Z_cont;

% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(coeff)
global Experimental 

designpoints=find(Experimental.designpoint);

XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
YScaleEdit=findobj('Tag','YScaleEdit'); yscaleoffs=str2double(get(YScaleEdit,'String'));
min_x=min(Experimental.parameters(1,designpoints)); max_x=max(Experimental.parameters(1,designpoints)); o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
min_y=min(Experimental.parameters(2,designpoints)); max_y=max(Experimental.parameters(2,designpoints)); o=(max_y-min_y)*(yscaleoffs/100); min_y=min_y-o; max_y=max_y+o;


res_x=100; res_y=100; %resolution of temperature/gradient
minmax_x=[min_x max_x]; inc_x=(minmax_x(2)-minmax_x(1))/res_x;
minmax_y=[min_y max_y]; inc_y=(minmax_y(2)-minmax_y(1))/res_y;

xs=minmax_x(1):inc_x:minmax_x(2);
le_x=length(xs);
ys=minmax_y(1):inc_y:minmax_y(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
for xc=1:le_x
    for yc=1:le_y
        D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        z_val=[D*coeff];    
        Z_cont(xc,yc)=z_val;     
    end   
end

% ------------------- calctargetmodels ---------------------
function calctargetmodels
global Experimental Models

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)  
ListTypeRadio=findobj(ListTypeRadio,'String','Target mod'); set(ListTypeRadio,'Value',1)
%ImportedDataRadio=findobj(gcf,'Tag','ImportedDataRadio'); set(ImportedDataRadio,'Value',0)  


DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

TargetPop=findobj(gcf,'Tag','TargetPop');
targetfile=get(TargetPop,'Value');
     
varname=getvarname;
designpoints=find(Experimental.designpoint);

parn=Experimental.paramnames{designpoints(1)};
for x=1:length(parn)
    spaceind=strfind(parn{x},' ');
    parn{x}(spaceind)=[];
end

for x=1:length(selcmp)
    cmp=selcmp(x);
    parameters=Experimental.parameters(:,designpoints);
    expdata=Experimental.(varname)(cmp,designpoints);
    targetval=Experimental.(varname)(cmp,targetfile);
    expdata=(expdata-targetval);

    coefficients=oo_calcmodel(parameters,expdata');
    if length(coefficients)==6
        str=[num2str(coefficients(1),'%6.4g') ' + ' ...
            num2str(coefficients(2),'%6.4g') ' ' parn{1} ' + '...
            num2str(coefficients(3),'%6.4g') ' ' parn{2} ' + '...
            num2str(coefficients(4),'%6.4g') ' ' parn{1} ' ' parn{2} ' + '...
            num2str(coefficients(5),'%6.4g') ' ' parn{1} '^2 + '...
            num2str(coefficients(6),'%6.4g') ' ' parn{2} '^2'];
    end
    Models.([varname '_tg']){cmp}=coefficients;
    Models.([varname '_tg_str']){cmp}=str;
    if sum(isnan(coefficients))>0 Models.([varname '_tg_str']){cmp}='Failed, missing values'; end
end

validate


% ------------------- calcmodels ---------------------
function calcmodels
global Experimental Models

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)  
ListTypeRadio=findobj(ListTypeRadio,'String','Abs. models'); set(ListTypeRadio,'Value',1)

DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

varname=getvarname;
designpoints=find(Experimental.designpoint);

parn=Experimental.paramnames{designpoints(1)};
for x=1:length(parn)
    spaceind=strfind(parn{x},' ');
    parn{x}(spaceind)=[];
end

for x=1:length(selcmp)
    cmp=selcmp(x);
    parameters=Experimental.parameters(:,designpoints);
    expdata=Experimental.(varname)(cmp,designpoints);
    
    coefficients=oo_calcmodel(parameters,expdata');
    if length(coefficients)==6
        str=[num2str(coefficients(1),'%6.4g') ' + ' ...
            num2str(coefficients(2),'%6.4g') ' ' parn{1} ' + '...
            num2str(coefficients(3),'%6.4g') ' ' parn{2} ' + '...
            num2str(coefficients(4),'%6.4g') ' ' parn{1} ' ' parn{2} ' + '...
            num2str(coefficients(5),'%6.4g') ' ' parn{1} '^2 + '...
            num2str(coefficients(6),'%6.4g') ' ' parn{2} '^2'];
    end
    Models.(varname){cmp}=coefficients;
    Models.([varname '_str']){cmp}=str;
    if sum(isnan(coefficients))>0 Models.([varname '_str']){cmp}='Failed, missing values'; end
end

validate

% ------------------- checkpoint ---------------------
function checkpoint(xp,yp)
global Experimental Models Modset

xvals=Modset.currentcont_x(:,1);
yvals=Modset.currentcont_y(1,:);

xa=min(find(xvals>=xp)); xb=max(find(xvals<=xp));
if (xp-xvals(xb))<=(xvals(xa)-xp) nxp=xb; else nxp=xa; end
 
ya=min(find(yvals>=yp)); yb=max(find(yvals<=yp));
if (yp-yvals(yb))<=(yvals(ya)-yp) nyp=yb; else nyp=ya; end

zp=Modset.currentcont_z(nxp,nyp);

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'String',num2str(xp,'%6.4g'))
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'String',num2str(yp,'%6.4g'))
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'String',num2str(zp,'%6.4g'))

% Find selected compounds
DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

TargetPop=findobj(gcf,'Tag','TargetPop');
targetfile=get(TargetPop,'Value'); 

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

varname=getvarname;

parameters=[xp,yp];
X=([1; parameters(1); parameters(2); parameters(1)*parameters(2); parameters(1)^2; parameters(2)^2])';   
[m,n_coeff]=size(X);
nanvector=repmat(NaN,6,1); 

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','Value',1);
modeltype=get(ListTypeRadio,'String');

usetarget=0;
if Modset.plottype==2 || strcmp(modeltype,'Target mod.')
    usetarget=1;
end
cc=1; ostr{1,cc}='Compound '; ostr{2,cc}='Calc. '; 
if usetarget ostr{3,cc}='Target '; ostr{4,cc}='Difference '; end
    
for p=1:length(selcmp)
    cmp=selcmp(p);
    if usetarget
        targetval=Experimental.(varname)(cmp,targetfile);
    else
        targetval=0;
    end  

    if cmp<=length(Models.(varname)) && length(Models.(varname){cmp})==n_coeff
        coeff=(Models.(varname){cmp});
    else
        coeff=nanvector;
    end

    if ~isnan(targetval) && sum(isnan(coeff))==0
        calcres=X*coeff;
        diff=calcres-targetval;
        cc=cc+1;
        ostr{1,cc}=[codes{cmp} ': '];
        ostr{2,cc}=[num2str(calcres,'%6.6g') ' '];
        if usetarget
            ostr{3,cc}=[num2str(targetval,'%6.6g') ' '];
            ostr{4,cc}=[num2str(diff,'%6.3g') ' '];
        end
    end
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

InfoBox=findobj(gcf,'Tag','InfoBox');
set(InfoBox,'String',outstr)
oo_copylist(0,InfoBox)



% ------------------- validate ---------------------
function validate
global Experimental Models Pos Modset

DataModelsList=findobj(gcf,'Tag','DataModelsList');
selcmp=get(DataModelsList,'Value');

targetmodel=0;
varname=getvarname;
designpoints=find(Experimental.designpoint);
callerstr=get(gcbo,'String');
if strcmp(callerstr,'Target Model');
    targetmodel=1;
    TargetPop=findobj(gcf,'Tag','TargetPop');
    targetfile=get(TargetPop,'Value'); 
end

designpoints=find(Experimental.designpoint);
parameters=Experimental.parameters(:,designpoints);
[n_param,n_exp]=size(parameters);
if n_param==2
    for x=1:n_exp
        X(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];   
    end
end

if targetmodel
    for p=1:length(selcmp)
        cmp=selcmp(p);
        coeff=(Models.([varname '_tg']){cmp});
        expdata=(Experimental.(varname)(cmp,designpoints))';
        targetval=Experimental.(varname)(cmp,targetfile);
        if ~isempty(targetval) && ~isnan(targetval)
            calcres=X*coeff;
            expdata=expdata-targetval;
            sqdiff=abs(calcres-expdata);
            sumerr(p)=sum(sqdiff);  
        end
    end
 
else
    for p=1:length(selcmp)
        cmp=selcmp(p);
        coeff=(Models.(varname){cmp});
        if sum(isnan(coeff))==0
            calcres=X*coeff;
            expdata=(Experimental.(varname)(cmp,designpoints))';
            sqdiff=abs(calcres-expdata);
            sumerr(p)=sum(sqdiff);   
        end
    end
end

subplot('Position',Pos.rightplot)
h=barh(sumerr);
set(h,'Edgecolor','none','FaceColor',[1 0.5 0.5])

minerr=min(sumerr); maxerr=max(sumerr); hp=(maxerr-minerr)/50;

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

for p=1:length(selcmp)
    cmp=selcmp(p); 
    text(hp,p,codes{cmp},'FontWeight','bold')
end
text(0.95,0.95,'Sum of errors','Units','Normalized','HorizontalAlignment','right','FontWeight','bold','FontSize',12)
ylim([0,length(selcmp)+1])

Modset.plottype=4; % Errorplot
oo_copyfigure



% ------------------- boxlist ---------------------
function boxlist
global Experimental

%n_assigned=length(Experimental.paramnames);
for expno=1:length(Experimental.expname)
    str{1,expno}=[num2str(expno) ') ' Experimental.expname{expno} ': '];
    if Experimental.designpoint(expno)==1
        paramnames=Experimental.paramnames{expno};
        n_param=length(paramnames);
        for paramno=1:n_param
            paramnames=Experimental.paramnames{expno};
            if isfield(Experimental,'paramnames') && ~isempty(Experimental.paramnames{expno})
                str{1+paramno,expno}=[paramnames{paramno} ': ' num2str(Experimental.parameters(paramno,expno)) '. '];       
            end
        end
    end     
end

str(cellfun('isempty',str))={'-'};

[m,n]=size(str); outstr=[];
for x=1:m
    outstr=[outstr strvcat(str{x,:})];
end

BoxesList=findobj(gcf,'Tag','BoxesList');
set(BoxesList,'String',outstr)

TargetPop=findobj(gcf,'Tag','TargetPop');
set(TargetPop,'String',outstr)


% ------------------- parameterslist ---------------------
function parameterslist
global Experimental

strno=0; str=[];
fn=fieldnames(Experimental);
for x=1:length(fn)
    if strcmp(fn{x}, 'rt_exp') strno=strno+1; str{strno}='Retention time (RT)'; end
    if strcmp(fn{x}, 'ri_exp') strno=strno+1; str{strno}='Retention index (RI)'; end
    if strcmp(fn{x}, 'wbl_exp') strno=strno+1; str{strno}='Peak width (RT units)'; end
    if strcmp(fn{x}, 'wbl_ri_exp') strno=strno+1; str{strno}='Peak width (RI units)'; end
    if strcmp(fn{x}, 'area_exp') strno=strno+1; str{strno}='Area'; end
    if strcmp(fn{x}, 'height_exp') strno=strno+1; str{strno}='Height'; end
    if strcmp(fn{x}, 'responsefactor_exp') strno=strno+1; str{strno}='Response factor'; end
end

ParametersList=findobj(gcf,'Tag','ParametersList');
set(ParametersList,'String',str)


% ------------------- datalist ---------------------
function datalist
global Experimental Modset

varname=getvarname;

n_exp=length(Experimental.paramnames);
n_comp=length(Experimental.codes);

for compno=1:n_comp
    if Modset.codetype==1 ostr{1,compno}=[num2str(compno) ') ' Experimental.codes{compno} ' ']; end
    if Modset.codetype==2 ostr{1,compno}=[num2str(compno) ') ' Experimental.names{compno} ' ']; end
    if Modset.codetype==3 ostr{1,compno}=[num2str(compno) ') ' Experimental.shortnames{compno} ' ']; end
    for expno=1:n_exp
        ostr{1+expno,compno}=[num2str(expno) ')' num2str(Experimental.(varname)(compno,expno),'%6.4g') ' '];
    end
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

DataModelsList=findobj(gcf,'Tag','DataModelsList');
set(DataModelsList,'String',outstr)
oo_copylist(0,DataModelsList)


% ------------------- modelslist ---------------------
function modelslist
global Experimental Models Modset

varname=getvarname;
if Modset.listtype==3; % Targetmodels
    varname=[varname '_tg'];  
end

n_comp=length(Experimental.codes);
if isfield(Models,[varname '_str'])
    [m,n_lines]=size(Models.([varname '_str']));
else
    n_lines=0;
end

for compno=1:n_comp
    if Modset.codetype==1 ostr{1,compno}=[num2str(compno) ') ' Experimental.codes{compno} ' ']; end
    if Modset.codetype==2 ostr{1,compno}=[num2str(compno) ') ' Experimental.names{compno} ' ']; end
    if Modset.codetype==3 ostr{1,compno}=[num2str(compno) ') ' Experimental.shortnames{compno} ' ']; end
    
    if compno<=n_lines && ~isempty(Models.([varname '_str']){compno})
        ostr{2,compno}=Models.([varname '_str']){compno};
    else
        ostr{2,compno}='Not calculated';
    end  
    
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

DataModelsList=findobj(gcf,'Tag','DataModelsList');
set(DataModelsList,'String',outstr)
oo_copylist(0,DataModelsList)

TargetSurfBtn=findobj(gcf,'Tag','TargetSurfBtn');
if Modset.listtype==3
    set(TargetSurfBtn,'Enable','off')
else
    set(TargetSurfBtn,'Enable','on')
end


% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments '\' Metset.path_experiments '\exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- getmodels ---------------------
function getmodels
global Metset Locset

pathname=[Locset.path_models '\' Metset.path_models '\mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- getvarname ---------------------
function varname=getvarname

ParametersList=findobj(gcf,'Tag','ParametersList');
val=get(ParametersList,'Value');
str=get(ParametersList,'String');
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt_exp' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri_exp' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl_exp' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri_exp' ; end
if strcmp(selpar,'Area') varname='area_exp' ; end
if strcmp(selpar,'Height') varname='height_exp' ; end
if strcmp(selpar,'Response factor') varname='responsefactor_exp' ; end


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='ModelsWin'; winpar{2}='Chrombox Optimizer: Model';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model2(99)',3,'','');
%p=p+1;[ui{p,1:8}] = deal('Tempsave','Pushbutton',Colors.bc,[x(2) y(1) bw bh*1.5],'oo_maincall(89)',3,'','-bm');
%p=p+1;[ui{p,1:8}] = deal('Resume','Pushbutton',Colors.bc,[x(3) y(1) bw bh*1.5],'oo_maincall(88)',3,'','-bm');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(1) y(5) gw*2+bw gh*4],'',2,'BoxesList');
p=p+1;[ui{p,1:8}] = deal('Target:','Text',Colors.bc,[x(1) y(4) bw eh],'',2,'','-r');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(4) gw+bw bh],'',2,'TargetPop');

% Parameterslist
p=p+1;[ui{p,1:7}] = deal('Parameters:','Text',Colors.bc,[x(4) y(9) gw+bw eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(5) gw*0.5+bw gh*4],'oo_model2(3.3)',2,'ParametersList');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(1) y(10) bw eh],'oo_model2(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(1)+gw/2 y(10) bw eh],'oo_model2(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(2) y(10) bw eh],'oo_model2(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_model2(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Abs. models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_model2(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Target mod.','Radiobutton',Colors.bc,[x(3)+gw*4/3 y(10) gw+bw eh],'oo_model2(7.1)',2,'ListTypeRadio');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Model','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(8) bw  bh],'oo_model2(4.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Target Model','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(7) bw  bh],'oo_model2(4.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Use absolute difference','Checkbox',Colors.bc,[x(5)+gw/2 y(3) bw+gw/2  bh],'',2,'AbsCheck');
p=p+1;[ui{p,1:7}] = deal('Surface','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(6) bw  bh],'oo_model2(5.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Individual','Pushbutton',Colors.btn{1},[x(6)+gw/2 y(6) bw  bh],'oo_model2(5.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Target Surface','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(5) bw  bh],'oo_model2(5.1)',2,'TargetSurfBtn');
p=p+1;[ui{p,1:7}] = deal('Individual','Pushbutton',Colors.btn{1},[x(6)+gw/2 y(5) bw  bh],'oo_model2(5.2)',2,'TargetSurfBtn');
p=p+1;[ui{p,1:7}] = deal('Mean','Radiobutton',Colors.bc,[x(5)+gw/2 y(4) bw+gw/2  bh],'oo_model2(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Sum','Radiobutton',Colors.bc,[x(6) y(4) bw+gw/2  bh],'oo_model2(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Min','Radiobutton',Colors.bc,[x(6)+gw/2 y(4) bw+gw/2  bh],'oo_model2(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Max','Radiobutton',Colors.bc,[x(7) y(4) bw+gw/2  bh],'oo_model2(6.1)',2,'SurfTypeRadio');

% Min/Max
p=p+1;[ui{p,1:7}] = deal('X-val','Text',Colors.bc,[x(8)+gw/2 y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Y-Val','Text',Colors.bc,[x(9) y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Response','Text',Colors.bc,[x(9)+gw/2 y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Threshold','Text',Colors.bc,[x(10) y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Min T','Checkbox',Colors.bc,[x(8)-bw*0.5 y(9) bw  bh],'oo_model2(11.1)',2,'MinTCheck');
p=p+1;[ui{p,1:7}] = deal('Min P','Checkbox',Colors.bc,[x(8) y(9) bw  bh],'',2,'MinCheck');

p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(9) bw/2 eh],'',2,'MinvalEdit1');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(9) bw/2 eh],'',2,'MinvalEdit2');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(9) bw/2 eh],'',2,'MinvalEdit3');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(10) y(9) bw/2 eh],'',2,'MinThreshEdit');
p=p+1;[ui{p,1:7}] = deal('Max T','Checkbox',Colors.bc,[x(8)-bw*0.5 y(8) bw  bh],'oo_model2(11.1)',2,'MaxTCheck');
p=p+1;[ui{p,1:7}] = deal('Max P','Checkbox',Colors.bc,[x(8) y(8) bw  bh],'',2,'MaxCheck');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(8) bw/2 eh],'',2,'MaxvalEdit1');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(8) bw/2 eh],'',2,'MaxvalEdit2');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(8) bw/2 eh],'',2,'MaxvalEdit3');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(10) y(8) bw/2 eh],'',2,'MaxThreshEdit');

% Selected
p=p+1;[ui{p,1:8}] = deal('Selected:','Text',Colors.bc,[x(8) y(7) bw/2  eh],'',2,'','-r');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(7) bw/2 eh],'oo_model2(9.4)',2,'SelXEdit');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(7) bw/2 eh],'oo_model2(9.4)',2,'SelYEdit');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(7) bw/2 eh],'',2,'SelZEdit');
%p=p+1;[ui{p,1:7}] = deal('Calc','Pushbutton',Colors.btn{1},[x(10) y(7) bw/2 eh],'',2,'');

% Infotext
p=p+1;[ui{p,1:8}] = deal('-','Listbox',[1 1 1],[x(7)+gw/2 y(2) gw*2+bw gh*4+eh],'',2,'InfoBox','');

% Scale
p=p+1;[ui{p,1:8}] = deal('X-scale +/-','Text',Colors.bc,[x(6)+gw/2 y(9) bw*2/3 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[x(6)+gw/2+bw*2/3 y(9) bw/3 eh],'oo_model2(10.1)',2,'XScaleEdit','-c');
p=p+1;[ui{p,1:8}] = deal('Y-scale +/-','Text',Colors.bc,[x(6)+gw/2 y(8) bw*2/3 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[x(6)+gw/2+bw*2/3 y(8) bw/3 eh],'oo_model2(10.1)',2,'YScaleEdit','-c');

% Load / Save
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_model2(1.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_model2(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedModelsPop');
p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_model2(8.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

updfcn='oo_model2(100)'; 
h0=oo_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model2(96)')
set(h0,'CloseRequestFcn','oo_model2(99)')

% Multiple selections
FilesList=findobj(gcf,'Tag','DataModelsList'); set(FilesList,'Max',2,'Min',0)
minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off')
end

MeanCheck=findobj(gcf,'Tag','MeanCheck'); set(MeanCheck,'Value',1);
AbsCheck=findobj(gcf,'Tag','AbsCheck'); set(AbsCheck,'Value',1);

SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','String','Mean'); set(SurfTypeRadio,'Value',1)
CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)

