function oo_model_vda(call)
% function oo_model_vda(call)
% Function called from oo_model_vda

global Metset Locset EMod TMod
%global status

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model_vda ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    [EMod,TMod]=getmodels;
    meanparam
    openwin
    setpops
    emodlist
    % Select VD+Int if present
    EModPop=findobj(gcf,'Tag','EModPop'); ind=strmatch('VD+Int',get(EModPop,'String')); 
    if ~isempty(ind) set(EModPop,'Value',ind); end
    tmodlist   
    plotupdate
end

% ---------- Select models ----------  
if call==1.1 emodlist; plotupdate; end
if call==1.2 tmodlist; plotupdate; end

% ---------- Select code ----------
if call==2.1
    CodeRadio=findobj(gcf,'Tag','CodeRadio');
    set(CodeRadio,'Value',0); set(gcbo,'Value',1);
    emodlist; tmodlist;
end

% ---------- eval tables ----------
if call==3.1 eval_emodlist; meanparam; plotupdate; end
if call==3.2 eval_tmodlist; meanparam; plotupdate; end


% ------ plotinputs ------
% unspecific
if call==5.0
    plotupdate
end
% percent+/-
if call==5.1
    val=str2double(get(gcbo,'String'));
    if isnan(val) || val<-20 set(gcbo,'String',10); end   
    plotupdate
end
% isoEdit
if call==5.3
    val=str2double(get(gcbo,'String'));
    if isnan(val) || val<0 
        set(gcbo,'String',1); set(findobj(gcf,'Tag','AutoIsoCheck'),'Value',1)
    else
        set(findobj(gcf,'Tag','AutoIsoCheck'),'Value',0)
    end   
    plotupdate
end
% WbisoEdit
if call==5.4
    val=str2double(get(gcbo,'String'));
    if isnan(val) || val<0 
        set(gcbo,'String',1); set(findobj(gcf,'Tag','AutoWbIsoCheck'),'Value',1)
    else
        set(findobj(gcf,'Tag','AutoWbIsoCheck'),'Value',0)
    end   
    plotupdate
end

% Output to InfoBox
% Single point
if call==6.1
    userdat=get(gcbo,'UserData');
    str{1}=['Velocity: ' num2str(userdat(1),4)];
    str{2}=['Gradient: ' num2str(userdat(2),4)];
    str{3}=['Inv. efficiency: ' num2str(userdat(3),4)];
    str{4}=['Ret. time: ' num2str(userdat(4),4)];
    InfoBox=findobj(gcf,'Tag','InfoBox');
    set(InfoBox,'String',str)
    oo_copylist(0,InfoBox)
end
% line
if call==6.2
    smcell=smtocell(get(gcbo,'UserData'));
    InfoBox=findobj(gcf,'Tag','InfoBox');
    set(InfoBox,'String',smcell)
    oo_copylist(0,InfoBox)   
end


% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    oo_closewin
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model_vda (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end


% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------------- plotupdate ---------------------
function plotupdate 

PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
str=get(PlotTypePop,'String');
plottype=str{get(PlotTypePop,'Value')};

switch plottype
    case 'Opt Vel'
        plot_optvel
    case 'Eff/Time'
        plot_efftime
end
        
% ------------------- plot_efftime ---------------------
function plot_efftime
global EMod TMod

%disp('--- plot_efftime ---')

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

[XT_cont,YT_cont,ZT_cont]=calcsurf(TMod(tmodno));
[XE_cont,YE_cont,ZE_cont]=calcsurf(EMod(emodno));

if ~isequal(XT_cont,XE_cont) || ~isequal(YT_cont,YE_cont)
    zz_message(1,'Error: Parameter ranges for time and efficiency models do not match','-r')
    return
end

R_cont=1./(ZE_cont.*ZT_cont); % PPC/Time
fillcont(XT_cont,YT_cont,R_cont)

% ------------------- plot_optvel ---------------------
function plot_optvel
global EMod TMod

%disp('--- plot_optvel ---')

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

% Check that design space is the same
dse=[min(EMod(emodno).design(1,:)) max(EMod(emodno).design(1,:)); min(EMod(emodno).design(2,:)) max(EMod(emodno).design(2,:))];
dst=[min(TMod(tmodno).design(1,:)) max(TMod(tmodno).design(1,:)); min(TMod(tmodno).design(2,:)) max(TMod(tmodno).design(2,:))];
if ~isequal(dse,dst) 
    zz_message(1,'The design space of the selected models differ','-r')
    return
end

[X_cont,Y_cont,Z_cont]=calcsurf(TMod(tmodno));
fillcont(X_cont,Y_cont,Z_cont)

iv=Y_cont(1,:);
uv=optvel(EMod(emodno).meanparam,iv,EMod(emodno).modeltype);
hold on
emaxline=plot(uv,iv,'-','Color',[1 1 1],'LineWidth',2);
hold off

% --- Contourlevels ---
%disp('--- contourlevels ---')
% fin max/min values for countours (at top and bottom of opt vel line)
zv=getz([min(uv) max(uv)],[min(iv) max(iv)],EMod(emodno).meanparam,EMod(emodno).modeltype);
%zr=range(zv) % does not work in 2013a
zr=max(zv)-min(zv);
a=linspace(zv(1)-0.1*zr,zv(2)+0.1*zr,20)';
astr=unique(cellstr(num2str(a,2)));
for x=1:numel(astr)
    contlevels(x)=str2double(astr{x});
end
contlevels=sort(contlevels);

contmax=max(contlevels);
contmin=min(contlevels);
spa=(contmax-contmin)/(numel(contlevels)-1);
nlev=numel(contlevels);
if nlev<10 spa=spa/2; contlevels=contmin:spa:contmax; end

% Use userset levels
avgspace=(max(contlevels)-min(contlevels))/(numel(contlevels)-1);
oldv=contlevels;
AutoWbIsoCheck=findobj(gcf,'Tag','AutoWbIsoCheck');
WbIsoEdit=findobj(gcf,'Tag','WbIsoEdit');
if ~get(AutoWbIsoCheck,'Value')
    isosp=str2double(get(WbIsoEdit,'String'));
    minv=min(contlevels);
    maxv=max(contlevels);
    f=1/isosp;  
    minv=minv*f; minv=floor(minv); minv=minv/f;
    maxv=maxv*f; maxv=floor(maxv); maxv=maxv/f;  
    contlevels=minv:isosp:maxv;

    if numel(contlevels)>100
        set(AutoWbIsoCheck,'Value',1);  contlevels=oldv;
        zz_message(1,'Too many wb contour levels - Iso distance set to auto','-r')
    end
    if numel(contlevels)<5
        set(AutoWbIsoCheck,'Value',1);  contlevels=oldv;
        zz_message(1,'Too few wb contour levels - Iso distance set to auto','-r')
    end
end
if get(AutoWbIsoCheck,'Value') 
    % userdefined
    set(WbIsoEdit,'String',num2str(avgspace))   
end

contlevels(contlevels>max(zv))=[];
contlevels(contlevels<min(zv))=[];

hold on
[X_cont,Y_cont,Z_cont]=calcsurf(EMod(emodno));
topcont(X_cont,Y_cont,Z_cont,contlevels)
hold off

% add labels
if get(findobj(gcf,'Tag','WbLabCheck'),'Value')
    xvect=linspace(min(uv),max(uv));
    for lno=1:numel(contlevels)
        gradv=getcont(contlevels(lno),xvect,EMod(emodno).meanparam,EMod(emodno).modeltype);
        [maxy,maxind]=max(gradv); 
        if ~isempty(maxind)
            maxind=maxind(1); maxy=maxy(1);
            maxx=xvect(maxind);
            text(maxx,maxy,num2str(contlevels(lno)),...
                'HorizontalAlignment','right',...
                'VerticalAlignment','bottom',...
                'FontWeight','bold',...
                'FontSize',12,...
                'Color',[1 1 1])
        end  
    end
end

% Find optimum
xrange(1)=min(min(X_cont));
xrange(2)=max(max(X_cont));
yrange(1)=min(min(Y_cont));
yrange(2)=max(max(Y_cont));

[xval,yval,zval,eff]=findopt(contlevels,xrange,yrange);

iv=Y_cont(1,:);
iv=linspace(yrange(1),yrange(2),100);
uv=interp1(yval,xval,iv,'spline','extrap');

hold on
uoptline=plot(uv,iv,'-','Color',[0 0 0],'LineWidth',2);
for x=1:numel(xval)  
    plot(xval(x),yval(x),'o','MarkerFaceColor',[0 0 0],'MarkerEdgeColor',[1 1 1],'UserData',[xval(x) yval(x) eff(x) zval(x)],'ButtonDownFcn','oo_model_vda(6.1)')
end
hold off



% Statistics for info box
iv=get(gca,'YTick');

uvm=optvel(EMod(emodno).meanparam,iv,EMod(emodno).modeltype); % max eff at grad
evm=getz(uvm,iv,EMod(emodno).meanparam,EMod(emodno).modeltype); % inverse eff at max eff
tvm=getz(uvm,iv,TMod(tmodno).meanparam,TMod(tmodno).modeltype); % time at optimum

uvo=interp1(yval,xval,iv,'spline','extrap'); % uv optimum
evo=getz(uvo,iv,EMod(emodno).meanparam,EMod(emodno).modeltype); % inverse eff at optimum
tvo=getz(uvo,iv,TMod(tmodno).meanparam,TMod(tmodno).modeltype); % time at optimum

SM=[iv' uvm' evm' tvm' uvo' evo' tvo'];

smcell=smtocell(SM);
InfoBox=findobj(gcf,'Tag','InfoBox');
set(InfoBox,'String',smcell)
oo_copylist(0,InfoBox)

set(emaxline,'ButtonDownFcn','oo_model_vda(6.2)','UserData',SM)
set(uoptline,'ButtonDownFcn','oo_model_vda(6.2)','UserData',SM)

% ------------------- smtocell ---------------------

function smcell=smtocell(SM)

[m,n]=size(SM);
p=1; str(p,:)={'Grad','u(max)','w(max)','t(max)','u(opt)','w(opt)','t(opt)'};
p=p+1; str(p,:)={'-','-','-','-','-','-','-'};
for x=1:m
    p=p+1;
    for y=1:n
        str{p,y}=num2str(SM(x,y),4);
    end
end

[m,n]=size(str); s=repmat('  ',m,1);
cstr=[strvcat(str(:,1)) s  ...
    strvcat(str(:,2)) s ...
    strvcat(str(:,3)) s ...
    strvcat(str(:,4)) s ...
    strvcat(str(:,5)) s ...
    strvcat(str(:,6)) s ...
    strvcat(str(:,7)) s];

[m,n]=size(cstr);
cstr(2,:)=repmat('-',1,n);
cstr(m+1,:)=repmat('-',1,n);

for x=1:m+1
    smcell{x}=cstr(x,:);
end

smcell{x+1}='Grad = Gradient';
smcell{x+2}='White line:';
smcell{x+3}='- u(max) = Velocity that gives maximum efficiency at gradient';
smcell{x+4}='- w(max) = Inverse efficiency at u(max)';
smcell{x+5}='- t(max) = Time at u(max)';
smcell{x+6}='Black line:';
smcell{x+7}='- u(opt) = Optimal velocity at gradient (efficiency/time tradeoff)';
smcell{x+8}='- w(opt) = Inverse efficiency at u(opt)';
smcell{x+9}='- t(opt) = Time at u(opt)';
        
% ------------------- findopt ---------------------
function [xval,yval,zval,eff]=findopt(eff,xrange,yrange)
global EMod TMod
%disp('---- findopt ----')

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

xval=[]; yval=[]; zval=[];

ecoeff=EMod(emodno).meanparam;
etype=EMod(emodno).modeltype;
tcoeff=TMod(tmodno).meanparam;
ttype=TMod(tmodno).modeltype;

yo=(yrange(2)-yrange(1))*0.1; % Adds a 10% offset on y to handle contours that are just inside the plot
% Prescreen to find x-range that is within y-range
xtest=linspace(xrange(1),xrange(2),100);
for lno=1:numel(eff)
    yv=getcont(eff(lno),xtest,ecoeff,etype);
    xv=xtest(yv<=yrange(2)+yo & yv>=yrange(1)-yo);
    minx{lno}=min(xtest(yv>=yrange(1)-yo & yv<=yrange(2)+yo));
    maxx{lno}=max(xtest(yv>=yrange(1)-yo & yv<=yrange(2)+yo));
end


% delete if empty values in minx/maxx
empties=[find(cellfun('isempty',minx)) find(cellfun('isempty',maxx))];
if ~isempty(empties)
    eff(empties)=[];
    minx(empties)=[];
    maxx(empties)=[];
end

% Find optimal efficiency/time tradeoff
brlevel=(yrange(2)-yrange(1))/1000; % Breaklevel 1/1000 of total x-range
for lno=1:numel(eff)   
    
    xmin=minx{lno}; xmax=maxx{lno}; % Initial values for range

    for p=1:10
        xv=linspace(xmin,xmax,10);
        yv=getcont(eff(lno),xv,ecoeff,etype);
        zv=getz(xv,yv,tcoeff,ttype);
        [zv,ind]=sort(zv); 
        if numel(ind)>3 
            ind(4:end)=[]; 
        end
        xv=xv(ind); 

        xmin=min(xv);
        xmax=max(xv);
        
        % Break if xrange<1/1000 of total range
        if (xmax-xmin)<brlevel 
            break
        end
    end

    xval(lno)=xv(1);
    yval(lno)=yv(1);
    zval(lno)=zv(1);

end
%disp('---- end findopt ----')



% ---------- getcont ---------
function gradv=getcont(clev,uv,coeff,modtype)
% returns gradients for peak width model as function o
% clev = contour level
% uv = velocity vector
% coeff = model coefficients
% modtype = model type
% gradv = gradient vector

%disp(['---- getcont: ' modtype '----'])

if numel(coeff)<7 coeff(numel(coeff)+1:7)=0; end

nr=numel(uv);
av=repmat(coeff(1),1,nr);
bv=repmat(coeff(2),1,nr);
cv=repmat(coeff(3),1,nr);
dv=repmat(coeff(4),1,nr);
ev=repmat(coeff(5),1,nr);
fv=repmat(coeff(6),1,nr);
gv=repmat(coeff(7),1,nr);
wv=repmat(clev,1,nr);

if strcmp(modtype,'VD+Int') && coeff(7)~=0
    kv=av+(bv./uv)+(cv.*uv)-wv;
    lv=dv+(ev./uv)+fv.*uv;
    gradv=(-lv+(sqrt((lv.^2)-4*gv.*kv)))./(2*gv);
end

if strcmp(modtype,'VD+Int') && coeff(7)==0
    gradv=(-av+wv-(bv./uv)-(cv.*uv)) ./ (dv+(ev./uv)+(fv.*uv)); 
end

if strcmp(modtype,'Quad+Int') 
    kv=av-wv+(bv.*uv)+(ev.*(uv.^2));
    lv=cv+(dv.*uv);
    gradv=(-lv+(sqrt((lv.^2)-4*fv.*kv)))./(2*fv);
end

%disp(['---- end getcont: ' modtype '----'])


% ------------------- getz ---------------------
function zval=getz(xval,yval,coeff,modeltype)
%disp('---- getz ----')

zval=[];
if strcmp(modeltype,'VD+Int')
    zval=coeff(1) + coeff(2)./xval + coeff(3).*xval + coeff(4).*yval + coeff(5).*yval./xval + coeff(6).*xval.*yval + coeff(7).*yval.^2;
end
if strcmp(modeltype,'Quad+Int')
    zval=coeff(1) + coeff(2).*xval + coeff(3)*yval + coeff(4).*xval.*yval + coeff(5).*xval.^2 + coeff(6).*yval.^2;
end    
if strcmp(modeltype,'Log+Int')
    xval=log(xval); yval=log(yval);
    zval=coeff(1) + coeff(2).*xval + coeff(3)*yval + coeff(4).*xval.*yval;
    zval=exp(zval);
end 

% ------------------- optvel ---------------------
function uv=optvel(coeff,iv,modeltype)
% function that returns optimal velocity (minimum in van Deemter curves)
% for any gradient.
% iv is vector of gradients
% uv is vector of optimal velocities
% coeff is coefficients
% modeltype is 'VD+Int' or 'Quad+Int'

if strcmp(modeltype,'VD+Int')
    b=coeff(2); c=coeff(3); e=coeff(5); f=coeff(6);
    uv=((b+e*iv)./(c+f*iv)).^0.5;      
end

if strcmp(modeltype,'Quad+Int')
    b=coeff(2); d=coeff(4); e=coeff(5); 
    uv=(-b-(d.*iv))/(2*e); % Vector of optimal velocity 
end

% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(Model)

%disp('--- calcsurf ---')

modeltype=strmatch(Model.modeltype,{'Quad+Int','Log+Int','VD+Int'});

XScaleEdit=findobj(gcf,'Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
YScaleEdit=findobj(gcf,'Tag','YScaleEdit'); yscaleoffs=str2double(get(YScaleEdit,'String'));

%xscaleoffs=5; yscaleoffs=5;

des=Model.design;
coeff=Model.meanparam';

min_x=min(des(1,:)); max_x=max(des(1,:)); 
if max_x-min_x <=0 min_x=-1; max_x=1; end
o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
min_y=min(des(2,:)); max_y=max(des(2,:)); 
if max_y-min_y <=0 min_y=-1; max_y=1; end
o=(max_y-min_y)*(yscaleoffs/100); min_y=min_y-o; max_y=max_y+o;

res_x=100; res_y=100; %resolution of temperature/gradient
minmax_x=[min_x max_x]; inc_x=(minmax_x(2)-minmax_x(1))/res_x;
minmax_y=[min_y max_y]; inc_y=(minmax_y(2)-minmax_y(1))/res_y;

xs=minmax_x(1):inc_x:minmax_x(2);
le_x=length(xs);
ys=minmax_y(1):inc_y:minmax_y(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
if modeltype==2 xs=log(xs); ys=log(ys); end % take ln of all values if ln-model of time
for xc=1:le_x
    for yc=1:le_y
        if modeltype==1 % Quad+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        end
        if modeltype==2 % Log+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc)]; 
        end
        if modeltype==3 % VD+Int
            D=[1 1/xs(xc) xs(xc) ys(yc) ys(yc)/xs(xc) xs(xc)*ys(yc) ys(yc)^2];           
        end 
        z_val=[D*coeff];
        Z_cont(xc,yc)=z_val;     
    end   
end

if modeltype==2
    Z_cont=exp(Z_cont);
end


% ------------------- topcont ---------------------
function topcont(X_cont,Y_cont,Z_cont,contlevels)
global Metset

%disp('---- topcont ----')

v=contlevels; 
try
    [C,h] = contour(X_cont,Y_cont,Z_cont,v,'LineStyle','-','Color',[1 1 1],'LineWidth',2);
catch
    [C,h] = contour(X_cont,Y_cont,Z_cont,v);
    set(h,'LineStyle','-','EdgeColor',[1 1 1],'LineWidth',2)
end

oo_copyfigure


% ------------------- fillcont ---------------------
function fillcont(X_cont,Y_cont,Z_cont)
global Pos Metset

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; % To be edited
end

lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

% Use userset levels
oldv=v;
AutoIsoCheck=findobj(gcf,'Tag','AutoIsoCheck');
IsoEdit=findobj(gcf,'Tag','IsoEdit');
if ~get(AutoIsoCheck,'Value')
    isosp=str2double(get(IsoEdit,'String'));
    minv=min(v);
    maxv=max(v);
    v=minv:isosp:maxv;
    f=1/isosp;
    v=v*f;
    v=floor(v);
    v=v/f;
    if numel(v)>100
        set(AutoIsoCheck,'Value',1);  v=oldv;
        zz_message(1,'Too many contour levels - Iso distance set to auto','-r')
    end
    if numel(v)<5
        set(AutoIsoCheck,'Value',1);  v=oldv;
        zz_message(1,'Too few contour levels - Iso distance set to auto','-r')
    end
end
if get(AutoIsoCheck,'Value') 
    % userdefined
    set(IsoEdit,'String',num2str(avgspace))   
end

if Metset.contour_isolines linestr='-'; else linestr='none'; end

% Plotting
ppos=Pos.leftplot; ppos(2)=Pos.yg(10)+Pos.gh*0.4;
ph=findobj(gcf,'Position',ppos,'Type','axes'); delete(ph) % deletes old plot
subplot('Position',ppos)
if numel(v)>2 && numel(v)<200
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr); % New matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v);
        set(h,'LineStyle',linestr)
    end
else
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,'LineStyle',linestr); % New matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont);
        set(h,'LineStyle',linestr)
    end
end

if get(findobj(gcf,'Tag','ContLabCheck'),'Value') clabel(C,h); end

%if Metset.contour_labels clabel(C,h); end
set(h,'ButtonDownFcn','oo_model_vd(9.1)','Tag','Contourplot');

% Centers clim if colormap is hotcold
if Metset.contour_centercol
    cm=[min(v) max(v)];
    set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

% set colormap (temporarily changes method map)
methodmap=Metset.contour_colormap;
CMapPop=findobj(gcf,'Tag','CMapPop');
str=get(CMapPop,'String');
cmap=str{get(CMapPop,'Value')};
Metset.contour_colormap=cmap;
set(gcf,'Colormap',oo_getcmap);
Metset.contour_colormap=methodmap;

oo_copyfigure


% ----------------- MEANPARAM -----------------
function meanparam
global EMod TMod

% ---- EMod ----
for x=1:numel(EMod)
    nmod=numel(EMod(x).param);
    npar=numel(EMod(x).parnames);
    P=NaN(nmod,npar);
    for modno=1:nmod
        P(modno,:)=EMod(x).param{modno}';
    end
    P=P(EMod(x).active,:);
    EMod(x).meanparam=mean(P,1);        
end

% ---- TMod ----
for x=1:numel(TMod)
    nmod=numel(TMod(x).param);
    npar=numel(TMod(x).parnames);
    TMod(x).meanparam=TMod(x).param{TMod(x).active}';
end


% ----------------- GETMODELS -----------------
function [EMod,TMod]=getmodels
global Models Experimental 

EMod=[]; TMod=[];

neffmod=0; 
for x=1:numel(Models)
    if isfield(Models,'wbl_ri_exp') && ~isempty(Models(x).wbl_ri_exp)
        neffmod=neffmod+1;
        EMod(neffmod).parameter='wbl_ri_exp';
        EMod(neffmod).modeltype=Models(x).modeltype;
        
        nval=0; design=[];
        for modno=1:numel(Models(x).wbl_ri_exp)
            if ~isempty(Models(x).wbl_ri_exp{modno}) && sum(isnan(Models(x).wbl_ri_exp{modno}))==0
                nval=nval+1;
                EMod(neffmod).param{nval}=Models(x).wbl_ri_exp{modno};
                EMod(neffmod).code{nval}=Experimental.codes{modno};
                EMod(neffmod).names{nval}=Experimental.names{modno};
                EMod(neffmod).shortnames{nval}=Experimental.shortnames{modno};
                design=[design Models(x).wbl_ri_exp_design{modno}];
            end     
        end
        design=design'; 
        EMod(neffmod).design=unique(design,'rows')';
        EMod(neffmod).velocityvar=Models(x).velocityvar;
        EMod(neffmod).interactvar=Models(x).interactvar;
        EMod(neffmod).parnames=Models(x).parnames;         
        EMod(neffmod).active=repmat(true,1,numel(EMod(neffmod).param)); % Select all
    end    
end

nrtmod=0;
for x=1:numel(Models)
    if isfield(Models,'rt_exp') && ~isempty(Models(x).rt_exp)
        nrtmod=nrtmod+1;
        TMod(nrtmod).parameter='rt_exp';
        TMod(nrtmod).modeltype=Models(x).modeltype;
        
        nval=0; design=[];
        for modno=1:numel(Models(x).rt_exp)
            if ~isempty(Models(x).rt_exp{modno}) && sum(isnan(Models(x).rt_exp{modno}))==0
                nval=nval+1;
                TMod(nrtmod).param{nval}=Models(x).rt_exp{modno};
                TMod(nrtmod).code{nval}=Experimental.codes{modno};
                TMod(nrtmod).names{nval}=Experimental.names{modno};
                TMod(nrtmod).shortnames{nval}=Experimental.shortnames{modno};
                design=[design Models(x).rt_exp_design{modno}];
            end     
        end
        design=design'; 
        TMod(nrtmod).design=unique(design,'rows')';
        TMod(nrtmod).velocityvar=Models(x).velocityvar;
        TMod(nrtmod).interactvar=Models(x).interactvar;
        TMod(nrtmod).parnames=Models(x).parnames; 
        TMod(nrtmod).active(numel(TMod(nrtmod).param))=true; % Select last
    end    
end

% ----------------- SETPOPS -----------------
function setpops
global EMod TMod

EModPop=findobj(gcf,'Tag','EModPop');
if ~isempty(EMod)
    for x=1:numel(EMod)
        pstr='';
        if strcmp(EMod(x).parameter,'wbl_ri_exp') pstr='Wb, RI units'; end
        estr{x}=[EMod(x).modeltype ' (' pstr ')'];
    end
    set(EModPop,'String',estr,'Enable','on')
end

TModPop=findobj(gcf,'Tag','TModPop');
if ~isempty(TMod)
    for x=1:numel(TMod)
        pstr='';
        if strcmp(TMod(x).parameter,'rt_exp') pstr='Ret. time'; end
        estr{x}=[TMod(x).modeltype ' (' pstr ')'];
    end
    set(TModPop,'String',estr,'Enable','on')
end

% ----------------- TMODLIST -----------------
function tmodlist
global TMod Pos

% Select model to display
TModPop=findobj(gcf,'Tag','TModPop');
modno=get(TModPop,'Value');

T.Data=[];
T.TableName='TModTable';
T.Position=[Pos.xg(6) Pos.yg(3) Pos.gw*4.5 Pos.gh*9];

if ~isempty(TMod)
    
    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
    rstr=get(CodeRadio,'String');
    switch rstr
        case 'Code'
            rnam=TMod(modno).code;
        case 'Name'
            rnam=TMod(modno).names;
        case 'Short name'
            rnam=TMod(modno).shortnames;
    end    
    
    for x=1:numel(TMod(modno).param)
        T.Data{x,1}=TMod(modno).active(x); 
        param=TMod(modno).param{x};
        T.RowName{x}=rnam{x};
        for y=1:numel(param) T.Data{x,y+1}=param(y); end        
    end
    for x=1:numel(TMod(modno).parnames) T.ColumnName{x+1}=TMod(modno).parnames{x}; end      
    [m,n]=size(T.Data);
    for x=2:n
        T.ColumnFormat{x}=deal(4); 
        T.ColumnWidth{x}=deal(80);
    end
    T.ColumnEditable=[1 zeros(1,n-1)];
end
T.AllowEmpty=0;
T.AllowNan=0;
T.ColumnFormat{1}='excl_binary';
T.ColumnName{1}='Sel';
T.ColumnWidth{1}=50;
T.ViewPref=1;
T.CellEditCallback='oo_model_vda(3.2)';
T.ListSelCol=1;

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

% ----------------- EVAL_TMODLIST -----------------
function eval_tmodlist
global TMod

TModPop=findobj(gcf,'Tag','TModPop');
modno=get(TModPop,'Value');

TMod(modno).active=cell2mat(zz_tabletool('getcol','TModTable',1))';


% ----------------- EMODLIST -----------------
function emodlist
global EMod Pos

% Select model to display
EModPop=findobj(gcf,'Tag','EModPop');
modno=get(EModPop,'Value');

T.Data=[];
T.TableName='EModTable';
T.Position=[Pos.xg(6) Pos.yg(14) Pos.gw*4.5 Pos.gh*9];

if ~isempty(EMod)
    
    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
    rstr=get(CodeRadio,'String');
    switch rstr
        case 'Code'
            rnam=EMod(modno).code;
        case 'Name'
            rnam=EMod(modno).names;
        case 'Short name'
            rnam=EMod(modno).shortnames;
    end
    
    for x=1:numel(EMod(modno).param)
        T.Data{x,1}=EMod(modno).active(x);
        param=EMod(modno).param{x};
        T.RowName{x}=rnam{x};
        for y=1:numel(param) T.Data{x,y+1}=param(y); end        
    end
    for x=1:numel(EMod(modno).parnames) T.ColumnName{x+1}=EMod(modno).parnames{x}; end      
    [m,n]=size(T.Data);
    for x=2:n
        T.ColumnFormat{x}=deal(4); 
        T.ColumnWidth{x}=deal(80);
    end
    T.ColumnEditable=[1 zeros(1,n-1)];
end
T.AllowEmpty=0;
T.AllowNan=0;
T.ColumnFormat{1}='binary';
T.ColumnName{1}='Sel';
T.ColumnWidth{1}=50;
T.ViewPref=1;
T.CellEditCallback='oo_model_vda(3.1)';
T.ListSelCol=1;

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);
    

% ----------------- EVAL_EMODLIST -----------------
function eval_emodlist
global EMod

EModPop=findobj(gcf,'Tag','EModPop');
modno=get(EModPop,'Value');

EMod(modno).active=cell2mat(zz_tabletool('getcol','EModTable',1))';


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; 
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
x=Pos.xg; y=Pos.yg;

winpar{1}='ModelsVdaWin'; winpar{2}='Chrombox Optimizer: VD models';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model_vda(99)',3,'','');

% Models list
p=p+1;[ui{p,1:8}] = deal('Efficiency models:','Text',Colors.bc,[x(6) y(23) gw eh],'',3,'','');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(9) y(23) gw*1.5 eh],'oo_model_vda(1.1)',2,'EModPop','-d');
p=p+1;[ui{p,1:8}] = deal('Time models:','Text',Colors.bc,[x(6) y(12) gw eh],'',3,'','');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(9) y(12) gw*1.5 eh],'oo_model_vda(1.2)',2,'TModPop','-d');

% InfoBox
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(1) y(3) gw*2.8 gh*6.5],'',2,'InfoBox');

% Functions frame
hp=x(4); vp=y(1);
p=p+1;[ui{p,1:8}] = deal('','Frame',Colors.bc,[hp vp bw*2 gh*8.5],'',2,'','');

p=p+1;[ui{p,1:8}] = deal('Plot:','Text',Colors.bc,[hp+gw*0.05 vp+gh*6+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal({'Opt Vel','Eff/Time'},'PopupMenu',[1 1 1],[hp+gw*0.8 vp+gh*7 gw*0.95 eh],'oo_model_vda(5.0)',2,'PlotTypePop','-fh');

p=p+1;[ui{p,1:8}] = deal('X-scale %','Text',Colors.bc,[hp+gw*0.05 vp+gh*5+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[hp+gw*0.8 vp+gh*6 gw*0.4 eh],'oo_model_vda(5.1)',2,'XScaleEdit','-c -fh');

p=p+1;[ui{p,1:8}] = deal('Y-scale %','Text',Colors.bc,[hp+gw*0.05 vp+gh*4+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[hp+gw*0.8 vp+gh*5 gw*0.4 eh],'oo_model_vda(5.1)',2,'YScaleEdit','-c -fh');

cmaps={'jet','hsv','hot','cool','spring','summer','autumn','winter','gray','bone','copper','pink','hotcold','traffic','white'};
p=p+1;[ui{p,1:8}] = deal('Color map','Text',Colors.bc,[hp+gw*0.05 vp+gh*3+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal(cmaps,'PopupMenu',[1 1 1],[hp+gw*0.8 vp+gh*4 gw*0.95 eh],'oo_model_vda(5.0)',2,'CMapPop','-fh');

p=p+1;[ui{p,1:8}] = deal('Iso dist:','Text',Colors.bc,[hp+gw*0.05 vp+gh*2+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('1','Edit',[1 1 1],[hp+gw*0.8 vp+gh*3 gw*0.4 eh],'oo_model_vda(5.3)',2,'IsoEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','Checkbox',Colors.bc,[hp+gw*1.25 vp+gh*3 gw*0.5 eh],'oo_model_vda(5)',2,'AutoIsoCheck','-c -fh');

p=p+1;[ui{p,1:8}] = deal('Wb iso dist:','Text',Colors.bc,[hp+gw*0.05 vp+gh+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('1','Edit',[1 1 1],[hp+gw*0.8 vp+gh*2 gw*0.4 eh],'oo_model_vda(5.4)',2,'WbIsoEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','Checkbox',Colors.bc,[hp+gw*1.25 vp+gh*2 gw*0.5 eh],'oo_model_vda(5)',2,'AutoWbIsoCheck','-c -fh');

p=p+1;[ui{p,1:8}] = deal('Contour labels','Checkbox',Colors.bc,[hp+gw*0.05 vp+gh gw eh],'oo_model_vda(5)',2,'ContLabCheck','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Wb labels','Checkbox',Colors.bc,[hp+gw*0.05 vp+gh*0.1 gw eh],'oo_model_vda(5)',2,'WbLabCheck','-c -fh');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(6) y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(6)+gw/2 y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(7) y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');


updfcn='oo_model_vda(100)'; 
h0=oo_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model_vda(96)')
set(h0,'CloseRequestFcn','oo_model_vda(99)')

CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)

cval=strmatch(Metset.contour_colormap,cmaps,'exact'); 
if numel(cval)==1 && ~isnan(cval) set(findobj(gcf,'Tag','CMapPop'),'Value',cval); end

set(findobj(gcf,'Tag','ContLabCheck'),'Value',Metset.contour_labels)
set(findobj(gcf,'Tag','WbLabCheck'),'Value',1)

