function oo_report_dif(Reportstruct,openfile)
global Metset

zz_obsfun

if nargin<2 openfile=0; end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct(1).pathname];
fh=fopen([Reportstruct(1).pathname '.dif'],'w');

if fh==-1; 
    oo_message(1,'|r|Warning, could not write to file, file may be open or output folder may not exist'); 
else
    
    [n_cols,n_rows]=size(Reportstruct(1).cells);
    fprintf(fh,['TABLE',linefeed]);
    fprintf(fh,['0,1',linefeed]);
    fprintf(fh,['"EXCEL"',linefeed]);
    fprintf(fh,['VECTORS',linefeed]);
    fprintf(fh,['0,' num2str(n_rows) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['TUPLES',linefeed]);
    fprintf(fh,['0,' num2str(n_cols) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['DATA',linefeed]);
    fprintf(fh,['0,0',linefeed]);
    fprintf(fh,['""',linefeed]);

    % ----------------

    for tn=1:length(Reportstruct)
        [n_cols,n_rows]=size(Reportstruct(tn).cells);

        % Header
        if isfield(Reportstruct(tn),'header') && ~isempty(Reportstruct(tn).header)
            for x=1:length(Reportstruct(tn).header)
                fprintf(fh,['-1,0',linefeed]);
                fprintf(fh,['BOT',linefeed]);
                str1=['1,0']; fprintf(fh,[str1,linefeed]);
                str2=['"' Reportstruct(tn).header{x} '"']; fprintf(fh,[str2,linefeed]);
            end
        end
    
        % Column headers
        if isfield(Reportstruct(tn),'columntitle') && ~isempty(Reportstruct(tn).columntitle)
            [dummy,n_headers]=size(Reportstruct(tn).columntitle);
            for hn=1:n_headers
                fprintf(fh,['-1,0',linefeed]);
                fprintf(fh,['BOT',linefeed]);
                for cn=1:n_cols
                    str1=['1,0']; fprintf(fh,[str1,linefeed]);
                    str2=['" ' Reportstruct(tn).columntitle{cn,hn} '"']; fprintf(fh,[str2,linefeed]);
                end 
            end
        end

        % Main body
        for rn=1:n_rows
            fprintf(fh,['-1,0',linefeed]);
            fprintf(fh,['BOT',linefeed]);
            for cn=1:n_cols
                if strcmp(Reportstruct(tn).format{cn,rn},'str')
                    str1=['1,0']; fprintf(fh,[str1,linefeed]);
                    str2=['" ' Reportstruct(tn).cells{cn,rn} '"']; fprintf(fh,[str2,linefeed]);
                else
                    str1=['0,' num2str(Reportstruct(tn).cells{cn,rn},Reportstruct(tn).format{cn,rn})]; fprintf(fh,[str1,linefeed]);
                    str2=['v']; fprintf(fh,[str2,linefeed]);
                end
            end
        end

        % Footer
        if isfield(Reportstruct(tn),'footer') && ~isempty(Reportstruct(tn).footer)
            for x=1:length(Reportstruct(tn).footer)
                fprintf(fh,['-1,0',linefeed]);
                fprintf(fh,['BOT',linefeed]);
                str1=['1,0']; fprintf(fh,[str1,linefeed]);
                str2=['"' Reportstruct(tn).footer{x} '"']; fprintf(fh,[str2,linefeed]);
            end
        end

    end % For tn

    %---------------

    % End of file
    fprintf(fh,['-1,0',linefeed]);
    fprintf(fh,['EOD']);

    fclose(fh);

    if openfile
        %a=dos([Reportstruct(1).pathname '.dif']);
        try
            winopen([Reportstruct(1).pathname '.dif'])
        catch
            oo_message(1,'|r||r|Could not open file. File may be in use or selected folder may not exist'); 
        end
        
    end

end %if fh==-1












