function oo_report_txt(Reportstruct,openfile)

zz_obsfun

if nargin<2 openfile=0; end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.txt'],'w');

if fh==-1; 
    oo_message(1,'|r|Warning, could not write to file, file may be open or output folder may not exist'); 
else
    for tn=1:length(Reportstruct)

        % ------------- Writes header -------------
        if isfield(Reportstruct(tn),'header') && ~isempty(Reportstruct(tn).header)
            for x=1:length(Reportstruct(tn).header)
                fprintf(fh,[Reportstruct(tn).header{x},linefeed]);
            end
        end
        
        % ------------- convert to typstr -------------
        [n_columns,n_rows]=size(Reportstruct(tn).cells);
        n_headers=0;
        if isfield(Reportstruct(tn),'columntitle') && ~isempty(Reportstruct(tn).columntitle)
            [dummy,n_headers]=size(Reportstruct(tn).columntitle);
        end
        U=[]; typestr=[];
        for x=1:n_columns
            ln=0;
            for hn=1:n_headers
                ln=ln+1; typestr{ln,x}=[Reportstruct(tn).columntitle{x,hn} '  '];
            end
            ln=ln+1;
            for y=1:n_rows
                if strcmpi(Reportstruct(tn).format{x,y},'str')
                    ln=ln+1; typestr{ln,x}=[Reportstruct(tn).cells{x,y} '  '];
                else
                    ln=ln+1; typestr{ln,x}=[num2str(Reportstruct(tn).cells{x,y},Reportstruct(tn).format{x,y}) '  '];
                end
            end
            U=[U char(typestr{:,x});];
        end       

        [m,linewidth]=size(U); 
        U(:,linewidth-1:linewidth)=[];
        separator=repmat('-',1,linewidth-2); U(n_headers+1,:)=separator; U(m+1,:)=separator;

        % Writes cellcontents
        for x=1:m+1
            fprintf(fh,[U(x,:) linefeed]);
        end

        % Writes footer
        if isfield(Reportstruct(tn),'footer') && ~isempty(Reportstruct(tn).footer)
            for x=1:length(Reportstruct(tn).footer)
                fprintf(fh,[Reportstruct(tn).footer{x},linefeed]);
            end
        end

    end % for tn

    fclose(fh);

    % Opens
    if openfile
        
        try
            winopen([Reportstruct(1).pathname '.txt'])
        catch
            oo_message(1,'|r|Could not open file. File may be in use or selected folder may not exist'); 
        end    

    end

end % if fid==-1











