function oo_model(call)
% function maincall(call)
% Funksjon koblet til hovedvinduet

global Metset Imported Locset Tempset Design
%global status

if nargin<1 call=0; end

disp(['--- oo_model ---' num2str(call)])

oo_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    Imported=[];
    openwin
    getexperiments
    getdesigns
    filetypeupdate
    dirupdate
end

% FileTypes/Directory
if call==1.1
    %disp('--- filetypeupdate ----')
    filetypeupdate
    dirupdate
end
if call==1.2
    %disp('--- dirupdate ---')
    dirupdate
end

% import
if call==2.1
    readdata
    meanvalues(1:length(Imported))
    boxlist
    boxinfo
    chromlist
    parameterlist
    compoundlist
end

% Select box
if call==3.1
    chromlist
    parameterlist
    compoundlist
    boxinfo
end
% select chromatogram
if call==3.2
    %disp('-- select chrom ---')
end
% select parameter
if call==3.3
    ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','Value',1);
    if strcmp(get(ListTypeRadio,'String'),'Import')
        compoundlist
    else
        exportlist
    end
end
% select compound
if call==3.4
    %disp('-- select compound ---')
end    

% CodeRadios
if call==4.1
    CodeRadio=findobj(gcf,'Tag','CodeRadio');
    set(CodeRadio,'Value',0); set(gcbo,'Value',1)   
    ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','Value',1);
    if strcmp(get(ListTypeRadio,'String'),'Import')
        compoundlist
    else
        exportlist
    end
end

% select/deselect
if call==5.1
    %disp('--- select ---')
    select(1)
    BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
    meanvalues(currentbox)
    compoundlist  
end
if call==5.2
    %disp('--- deselect ---')
    select(0)
    BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
    meanvalues(currentbox)
    compoundlist  
end

% Listtype
if call==6.1
    ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio');
    set(ListTypeRadio,'Value',0); set(gcbo,'Value',1)
    if ~isempty(Imported)
        compoundlist
    end
    
end
if call==6.2
    ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio');
    set(ListTypeRadio,'Value',0); set(gcbo,'Value',1)
    if ~isempty(Imported)
        exportlist
    end    
end

% save/load
if call==7.1
    %disp('--- save data ---')
    savedata
end
if call==7.2
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments '\' Metset.path_experiments '\exp_' strs{val} '.mat' ];
    load(pathname,'Imported')
    allcodes
    boxlist
    boxinfo
    chromlist
    parameterlist
    compoundlist 
end
% load design
if call==7.3
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    str=get(DesignFilesPop,'String');
    val=get(DesignFilesPop,'Value');
    filename=str{val};
    pathname=[Locset.path_designs '\' Metset.path_designs '\design_' filename '.mat']; 
    load(pathname,'Design');
    parametersupdate
end

% Change boxname
if call==8.1
    BoxNameEdit=findobj(gcf,'Tag','BoxNameEdit');
    boxname=get(BoxNameEdit,'String');
    BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
    if isempty(boxname)
        set(BoxNameEdit,'BackgroundColor',[1 1 0])       
    else
        Imported(currentbox).boxname=boxname;
        set(BoxNameEdit,'BackgroundColor',[1 1 1])
        boxlist; boxinfo
    end
end
% assign
if call==8.2
    %disp('--- assign ---')
    assign  
    boxinfo
end


    
    


% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    oo_closewin
end
if call==99.1 % Exit
    %h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    %h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat']; 
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model (update) ----')   
end

if call==-1
    oo_message(1,'|r|Not implemented')
end

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------------- assign ---------------------
function assign
global Imported Design

BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
ParametersPop=findobj(gcf,'Tag','ParametersPop'); currentparam=get(ParametersPop,'Value');

Imported(currentbox).parameters=Design.parameters(currentparam,:);
Imported(currentbox).paramnames=Design.paramnames;
Imported(currentbox).color=Design.colormatrix(currentparam,:);


% ------------------- boxinfo ---------------------
function boxinfo
global Imported

BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
boxname=Imported(currentbox).boxname;

BoxNameEdit=findobj(gcf,'Tag','BoxNameEdit');
set(BoxNameEdit,'String',boxname)

ParametersText=findobj(gcf,'Tag','ParametersText');
lineno=1; str{lineno}=['Parameters for: ' boxname];
if isfield(Imported,'parameters') && ~isempty(Imported(currentbox).parameters)
    for x=1:length(Imported(currentbox).paramnames)
        lineno=lineno+1;
        str{lineno}=[Imported(currentbox).paramnames{x} ': ' num2str(Imported(currentbox).parameters(x))];
    end
else
    lineno=lineno+1; str{lineno}='Not assigned';
end
set(ParametersText,'String',str)


% ------------------- parametersupdate ---------------------
function parametersupdate
global Design

[n_exp,n_param]=size(Design.parameters);
for expno=1:n_exp
    str{expno}=[num2str(expno) ') '];
    for paramno=1:n_param
        str{expno}=[str{expno} Design.paramnames{paramno} ': ' num2str(Design.parameters(expno,paramno)) '. '];
    end   
end

ParametersPop=findobj(gcf,'Tag','ParametersPop');
set(ParametersPop,'String',str,'Enable','on')


% ------------------- getdesigns ---------------------
function getdesigns
global Metset Locset

pathname=[Locset.path_designs '\' Metset.path_designs '\design_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        designnames{x}=DD(x).name(8:length(DD(x).name)-4);
    end   
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    set(DesignFilesPop,'String',designnames)   
end

% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments '\' Metset.path_experiments '\exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- savedata ---------------------
function savedata
global Imported Tempset Metset Locset

%disp('--- oo_model/savedata ---')

Experimental=[];

if ~isempty(Imported)
    
    fn=fieldnames(Imported);
    exportfields=[]; n_exports=0;
    for fnno=1:length(fn)
        if strfind(fn{fnno},'_exp')
            n_exports=n_exports+1;
            exportfields{n_exports}=fn{fnno};
        end
    end

    allcodes=Tempset.allcodes;
    for varno=1:length(exportfields)  
        for cmpno=1:length(allcodes)
            currentcode=allcodes{cmpno};   
            for boxno=1:length(Imported)
                Experimental.(exportfields{varno})(cmpno,boxno)=NaN;
                ind=strmatch(currentcode,Imported(boxno).cmp_code);
                if ~isempty(ind) && ~isempty(Imported(boxno).(exportfields{varno})) && ~isnan(Imported(boxno).([exportfields{varno}])(ind))
                    Experimental.(exportfields{varno})(cmpno,boxno)=Imported(boxno).(exportfields{varno})(ind);
                end
            end
        end
    end
    
    for boxno=1:length(Imported)
        if isfield(Imported,'parameters') && ~isempty(Imported(boxno).parameters)
            Experimental.parameters(:,boxno)=Imported(boxno).parameters;
            Experimental.paramnames{boxno}=Imported(boxno).paramnames;
            Experimental.color(:,boxno)=Imported(boxno).color;
        end
    end  
end

if isempty(Experimental)
    oo_message(1,'|r|No data')
else
    
    for expno=1:length(Imported)
        Experimental.expname{expno}=Imported(expno).boxname;
    end
    
    Experimental.codes=Tempset.allcodes;
    Experimental.names=Tempset.allnames;
    Experimental.shortnames=Tempset.allshortnames;

    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    filename=get(FileNameEdit,'String');
    
    pathname=[Locset.path_experiments '\' Metset.path_experiments '\exp_' filename ];
    
    oo_savefile(pathname,Experimental,Imported,Metset)

end


% ------------------- meanvalues ---------------------
function meanvalues(boxnumbers)
global Imported Tempset

parameters=[{'rt'},{'ri'},{'wbl'},{'wbl_ri'},{'area'},{'height'},{'responsefactor'}];
allcodes=Tempset.allcodes;

for boxes=1:length(boxnumbers)
    boxno=boxnumbers(boxes);
    for cmpno=1:length(allcodes)
        currentcode=allcodes{cmpno};
        ind=strmatch(currentcode,Imported(boxno).cmp_code);
        if ~isempty(ind) 
            for varno=1:length(parameters)
                varnam=parameters{varno};
                if ~isempty(Imported(boxno).(varnam))                  
                    meanvarnam=[varnam '_exp'];
                    %disp(['--- ----' varnam])
                    values=Imported(boxno).(varnam)(ind,:);
                    useind=find(Imported(boxno).Selected.(varnam)(ind,:));
                    Imported(boxno).(meanvarnam)(ind,1)=mean(values(useind));
                end
            end
        end  
    end
end
    
%Imported(boxno).Selected.ri
%Imported(boxno)

% ------------------- select ---------------------
function select(inp)
global Imported Tempset

%allcodes=Tempset.allcodes;
BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value');
ChromatogramsList=findobj(gcf,'Tag','ChromatogramsList'); selectedchroms=get(ChromatogramsList,'Value');
CompoundList=findobj(gcf,'Tag','CompoundList'); selectedcomp=get(CompoundList,'Value');

ParametersList=findobj(gcf,'Tag','ParametersList'); str=get(ParametersList,'String'); val=get(ParametersList,'Value'); parameter=str{val};
if strcmp(parameter,'Retention time (RT)') var='rt'; end
if strcmp(parameter,'Retention index (RI)') var='ri'; end
if strcmp(parameter,'Peak width (RT units)') var='wbl'; end
if strcmp(parameter,'Peak width (RI units)') var='wbl_ri'; end
if strcmp(parameter,'Area') var='area'; end
if strcmp(parameter,'Height') var='height'; end
if strcmp(parameter,'Response factor') var='responsefactor'; end

for chrno=1:length(selectedchroms)
    curentchrom=selectedchroms(chrno);
    for cmpno=1:length(selectedcomp)
        currentcomp=selectedcomp(cmpno);      
        currentcode=Tempset.allcodes{currentcomp};  
        ind=strmatch(currentcode,Imported(currentbox).cmp_code);
        if isempty(ind)==0
            Imported(currentbox).Selected.(var)(ind,curentchrom)=inp;
        end 
        % Deselect NaN-values
        if isnan(Imported(currentbox).(var)(ind,curentchrom))
            Imported(currentbox).Selected.(var)(ind,curentchrom)=0;
        end
            
    end
end

% ------------------- Exportlist ---------------------
function exportlist
global Imported Tempset

CompoundList=findobj(gcf,'Tag','CompoundList');
CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1); codestr=get(CodeRadio,'String');
if isempty(codestr) 
    codestr='Code'; set(findobj(gcf,'Tag','CodeRadio','String','Code'),'Value',1);
end
CodeCheck=findobj(gcf,'Tag','CodeRadio','String','Code'); usecodes=get(CodeCheck,'Value');
NameCheck=findobj(gcf,'Tag','CodeRadio','String','Name'); usenames=get(NameCheck,'Value');
ShortNameCheck=findobj(gcf,'Tag','CodeRadio','String','Short Name'); useshortnames=get(ShortNameCheck,'Value');

ParametersList=findobj(gcf,'Tag','ParametersList'); str=get(ParametersList,'String'); val=get(ParametersList,'Value'); parameter=str{val};
if strcmp(parameter,'Retention time (RT)') var='rt'; end
if strcmp(parameter,'Retention index (RI)') var='ri'; end
if strcmp(parameter,'Peak width (RT units)') var='wbl'; end
if strcmp(parameter,'Peak width (RI units)') var='wbl_ri'; end
if strcmp(parameter,'Area') var='area'; end
if strcmp(parameter,'Height') var='height'; end
if strcmp(parameter,'Response factor') var='responsefactor'; end


allcodes=Tempset.allcodes;
for cmpno=1:length(allcodes)
    currentcode=allcodes{cmpno};
    
    if usecodes==1 ostr{1,cmpno}=[Tempset.allcodes{cmpno}]; end
    if usenames==1 ostr{1,cmpno}=[Tempset.allnames{cmpno}]; end
    if useshortnames==1 ostr{1,cmpno}=[Tempset.allshortnames{cmpno}]; end     
     
    for boxno=1:length(Imported)
        ostr{boxno+1,cmpno}=[' ' num2str(boxno) ') -'];
        ind=strmatch(currentcode,Imported(boxno).cmp_code);
        if ~isempty(ind) && ~isempty(Imported(boxno).([var '_exp'])) && ~isnan(Imported(boxno).([var '_exp'])(ind))
            ostr{boxno+1,cmpno}=[' ' num2str(boxno) ') ' num2str(Imported(boxno).([var '_exp'])(ind),'%6.4g')];
        end
    end

end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

vals=get(CompoundList,'Value');
vals(find(vals>length(outstr)))=[];
if isempty(vals) vals=1; end
set(CompoundList,'Value',vals);

set(CompoundList,'String',outstr)

% ------------------- Compoundlist ---------------------
function compoundlist
global Imported Tempset

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0); 
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','String','Import'); set(ListTypeRadio,'Value',1); 

allcodes=Tempset.allcodes;
BoxesList=findobj(gcf,'Tag','BoxesList'); currentbox=get(BoxesList,'Value'); 
CompoundList=findobj(gcf,'Tag','CompoundList');

CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1); codestr=get(CodeRadio,'String');
if isempty(codestr) 
    codestr='Code'; set(findobj(gcf,'Tag','CodeRadio','String','Code'),'Value',1);
end
CodeCheck=findobj(gcf,'Tag','CodeRadio','String','Code'); usecodes=get(CodeCheck,'Value');
NameCheck=findobj(gcf,'Tag','CodeRadio','String','Name'); usenames=get(NameCheck,'Value');
ShortNameCheck=findobj(gcf,'Tag','CodeRadio','String','Short Name'); useshortnames=get(ShortNameCheck,'Value');

BoxesList=findobj(gcf,'Tag','BoxesList'); boxno=get(BoxesList,'Value');
ParametersList=findobj(gcf,'Tag','ParametersList'); str=get(ParametersList,'String'); val=get(ParametersList,'Value'); parameter=str{val};
ChromatogramsList=findobj(gcf,'Tag','ChromatogramsList'); selectedchroms=get(ChromatogramsList,'Value');

if strcmp(parameter,'Retention time (RT)') var='rt'; end
if strcmp(parameter,'Retention index (RI)') var='ri'; end
if strcmp(parameter,'Peak width (RT units)') var='wbl'; end
if strcmp(parameter,'Peak width (RI units)') var='wbl_ri'; end
if strcmp(parameter,'Area') var='area'; end
if strcmp(parameter,'Height') var='height'; end
if strcmp(parameter,'Response factor') var='responsefactor'; end

n_chroms=length(Imported(currentbox).filenames);
for cmpno=1:length(allcodes)
    currentcode=allcodes{cmpno};
 
    if usecodes==1 ostr{1,cmpno}=[Tempset.allcodes{cmpno} ' ']; end
    if usenames==1 ostr{1,cmpno}=[Tempset.allnames{cmpno} ' ']; end
    if useshortnames==1 ostr{1,cmpno}=[Tempset.allshortnames{cmpno} ' ']; end   
    
    for valno=1:n_chroms ostr{valno+1,cmpno}=[num2str(valno) '-)']; end
    ostr{n_chroms+2,cmpno}=' ';
    
    ind=strmatch(currentcode,Imported(currentbox).cmp_code);
    if ~isempty(ind)
        vals=Imported(currentbox).(var)(ind,:);  
        for valno=1:length(vals)
            ostr{valno+1,cmpno}=[num2str(valno) '-)'];
            if ~isnan(vals(valno))
                if Imported(currentbox).Selected.(var)(ind,valno)
                    ostr{valno+1,cmpno}=[num2str(valno) '+)' num2str(vals(valno),'%6.4g') ' ' ];
                else
                    ostr{valno+1,cmpno}=[num2str(valno) '-)' num2str(vals(valno),'%6.4g') ' ' ];
                end
                
            end
        end
        if isnan(Imported(currentbox).([var '_exp'])(ind))==0
            ostr{n_chroms+2,cmpno}=[' Exp: ' num2str(Imported(currentbox).([var '_exp'])(ind),'%6.4g')];
        end
    end
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

vals=get(CompoundList,'Value');
vals(find(vals>length(outstr)))=[];
if isempty(vals) vals=1; end
set(CompoundList,'Value',vals);

set(CompoundList,'String',outstr)

%Imported(currentbox).Selected




% ------------------- BOXLIST ---------------------
function boxlist
global Imported

for boxno=1:length(Imported)
    str{boxno}=[num2str(boxno) ') ' Imported(boxno).boxname];
end
BoxesList=findobj(gcf,'Tag','BoxesList');
val=get(BoxesList,'Value'); 
if val>length(str) set(BoxesList,'Value',length(str)); end
set(BoxesList,'String',str)



% ------------------- CHROMLIST ---------------------
function chromlist
global Imported

BoxesList=findobj(gcf,'Tag','BoxesList');
boxno=get(BoxesList,'Value');

for fileno=1:length(Imported(boxno).filenames)
    str{fileno}=[num2str(fileno) ') ' Imported(boxno).filenames{fileno}];
end

ChromatogramsList=findobj(gcf,'Tag','ChromatogramsList');

vals=get(ChromatogramsList,'Value');
vals(find(vals>length(str)))=[];
if isempty(vals) vals=1; end
set(ChromatogramsList,'Value',vals);

set(ChromatogramsList,'String',str)

% ------------------- PARAMETERLIST ---------------------
function parameterlist
global Imported

BoxesList=findobj(gcf,'Tag','BoxesList');
boxno=get(BoxesList,'Value');

str=[]; paramno=0;
Imported(boxno)
if isfield(Imported,'rt') && ~isempty(Imported(boxno).rt)
    paramno=paramno+1; str{paramno}='Retention time (RT)';
end
if isfield(Imported,'ri') && ~isempty(Imported(boxno).ri)
    paramno=paramno+1; str{paramno}='Retention index (RI)';
end    
if isfield(Imported,'wbl') && ~isempty(Imported(boxno).wbl)
    paramno=paramno+1; str{paramno}='Peak width (RT units)';
end 
if isfield(Imported,'wbl_ri') && ~isempty(Imported(boxno).wbl_ri)
    paramno=paramno+1; str{paramno}='Peak width (RI units)';
end 
if isfield(Imported,'area') && ~isempty(Imported(boxno).area)
    paramno=paramno+1; str{paramno}='Area';
end
if isfield(Imported,'height') && ~isempty(Imported(boxno).height)
    paramno=paramno+1; str{paramno}='Height';
end
if isfield(Imported,'responsefactor') && ~isempty(Imported(boxno).responsefactor)
    paramno=paramno+1; str{paramno}='Response factor';
end

ParametersList=findobj(gcf,'Tag','ParametersList');

val=get(ParametersList,'Value'); 
if val>length(str) set(ParametersList,'Value',length(str)); end

set(ParametersList,'String',str)



% ------------------- READDATA ---------------------
function readdata
global Metset Imported Tempset

PathEdit=findobj(gcf,'Tag','PathEdit');
pathstr=get(PathEdit,'String');

FilesList=findobj(gcf,'Tag','FilesList');
str=get(FilesList,'String');
selectedfiles=get(FilesList,'Value');

if strcmp(get(gcbo,'String'),'Read selected')
    Imported=[];  
end
n_boxes=length(Imported);


for boxno=1:length(selectedfiles)
    fileno=selectedfiles(boxno);
    if strcmp(Metset.import_filetype, 'Chrombox C')
        filename=['res_' str{fileno} '.mat'];
        load([pathstr '\' filename],'Databox');
        Outdata=getdata_C(Databox);
        fn=fieldnames(Outdata);
        for fnno=1:length(fn)
            Imported(boxno+n_boxes).(fn{fnno})=Outdata.(fn{fnno});
        end  
    end
    if strcmp(Metset.import_filetype, 'Chrombox Q')
        filename=['res_' str{fileno} '.mat'];
        load([pathstr '\' filename],'RE');
        Outdata=getdata_Q(RE);
        Outdata.filenames={str{fileno}};
        fn=fieldnames(Outdata);
        for fnno=1:length(fn)
            Imported(boxno+n_boxes).(fn{fnno})=Outdata.(fn{fnno});
        end         
        
    end
    Imported(boxno+n_boxes).boxname=str{fileno} ;
end

allcodes

% ------------------- ALLCODES ---------------------
function allcodes
global Tempset Imported

allcodes=[];
for boxno=1:length(Imported)
    for cmpno=1:length(Imported(boxno).cmp_code)
        ind = strmatch(Imported(boxno).cmp_code{cmpno},allcodes);
        if isempty(ind)
            ind=length(allcodes)+1;
            allcodes{ind}=Imported(boxno).cmp_code{cmpno};
            allshortnames{ind}=Imported(boxno).cmp_shortname{cmpno};
            allnames{ind}=Imported(boxno).cmp_name{cmpno};
        end    
    end
end

[alc,ind]=sort(allcodes);
Tempset.allcodes=allcodes(ind);  
Tempset.allshortnames=allshortnames(ind); 
Tempset.allnames=allnames(ind); 
%Imported

% ------------------- GETDATA_Q ---------------------
function Outdata=getdata_Q(RE)

Outdata=[];

codes=[]; shortnames=[]; names=[]; rt=[]; ri=[]; area=[]; wbl=[]; height=[];  responsefactor=[];
cmpno=0;
for pno=1:length(RE)
    if isfield(RE,'identified') && ~isempty(RE(pno).identified) && RE(pno).identified==1
        cmpno=cmpno+1;

        if isfield(RE,'rt') && ~isempty(RE(pno).rt)
            rt(cmpno,1)=RE(pno).rt;
            selected.rt(cmpno,1)=1;
        end
        if isfield(RE,'ri_calc') && ~isempty(RE(pno).ri_calc)
            ri(cmpno,1)=RE(pno).ri_calc;
            selected.ri(cmpno,1)=1;
        end        
        if isfield(RE,'area') && ~isempty(RE(pno).area)
            area(cmpno,1)=RE(pno).area;
            selected.area(cmpno,1)=1;
        end  
        if isfield(RE,'whh') && ~isempty(RE(pno).whh)
            wbl(cmpno,1)=RE(pno).whh*2.355;
            selected.wbl(cmpno,1)=1;           
        end 
        if isfield(RE,'cas_nr') && ~isempty(RE(pno).cas_nr)
            codes{1,cmpno}=RE(pno).cas_nr;
        end 
        if isfield(RE,'compound_code') && ~isempty(RE(pno).compound_code)
            shortnames{1,cmpno}=RE(pno).compound_code;
        end  
        if isfield(RE,'compound_name') && ~isempty(RE(pno).compound_name)
            names{1,cmpno}=RE(pno).compound_name;
        end  
    end
end

height=[];
responsefactor=[];

% selected
[m,n]=size(rt); selected.rt=ones(m,n);
[m,n]=size(ri); selected.ri=ones(m,n);
[m,n]=size(area); selected.area=ones(m,n);
[m,n]=size(wbl); selected.wbl=ones(m,n);
[m,n]=size(height); selected.height=ones(m,n);
[m,n]=size(responsefactor); selected.responsefactor=ones(m,n);

% sets zeros to NaN
zerovalues=find(rt==0); rt(zerovalues)=NaN; selected.rt(zerovalues)=0;
zerovalues=find(ri==0); ri(zerovalues)=NaN; selected.ri(zerovalues)=0;
zerovalues=find(area==0); area(zerovalues)=NaN; selected.area(zerovalues)=0;
zerovalues=find(wbl==0); wbl(zerovalues)=NaN; selected.wbl(zerovalues)=0;
zerovalues=find(height==0); height(zerovalues)=NaN; selected.height(zerovalues)=0;
zerovalues=find(responsefactor==0); responsefactor(zerovalues)=NaN; selected.responsefactor(zerovalues)=0;

Outdata.filenames={'-'};
Outdata.cmp_code=codes;
Outdata.cmp_name=names;
Outdata.cmp_shortname=shortnames;
Outdata.rt=rt;
Outdata.ri=ri;
Outdata.wbl=wbl;
Outdata.area=area;
Outdata.height=height;
Outdata.responsefactor=responsefactor;
Outdata.Selected=selected;



% ------------------- GETDATA_C ---------------------
function Outdata=getdata_C(Databox)

Outdata=[];

n_files=length(Databox);

allcodes=[]; shortnames=[]; names=[]; rt=[]; ri=[]; area=[]; wbl=[]; wbl_ri=[]; height=[];  responsefactor=[];
for fno=1:n_files
    %Databox(fno).Peakdata
    filenames{fno}=Databox(fno).file_name;
    Peakdata=Databox(fno).Peakdata;
    n_peaks=length(Peakdata);    
    %nwblri=0; % TEMP
    for pno=1:n_peaks
        if Peakdata(pno).identified==1     
            code=Peakdata(pno).cmp_code;
            ind = strmatch(code,allcodes);
            if isempty(ind)
                ind=length(allcodes)+1;
                allcodes{ind}=code;
                shortnames{ind}=Peakdata(pno).cmp_shortname;
                names{ind}=Peakdata(pno).cmp_name;
            end
            if isfield(Peakdata,'max_rt') && ~isempty(Peakdata(pno).max_rt)
                rt(ind,fno)=Peakdata(pno).max_rt;
            end           
            if isfield(Peakdata,'max_ri') && ~isempty(Peakdata(pno).max_ri)
                ri(ind,fno)=Peakdata(pno).max_ri;
            end
            if isfield(Peakdata,'area') && ~isempty(Peakdata(pno).area)
                area(ind,fno)=Peakdata(pno).area;
            end 
            if isfield(Peakdata,'wbl') && ~isempty(Peakdata(pno).wbl)
                wbl(ind,fno)=Peakdata(pno).wbl;
            end 
            if isfield(Peakdata,'wbl_ri') && ~isempty(Peakdata(pno).wbl_ri)
                wbl_ri(ind,fno)=Peakdata(pno).wbl_ri;
                %nwblri=nwblri+1; wblris=Peakdata(pno).wbl_ri; % TEMP
            end                    
            if isfield(Peakdata,'height') && ~isempty(Peakdata(pno).height)
                height(ind,fno)=Peakdata(pno).height;
            end 
            if isfield(Peakdata,'responsefactor') && ~isempty(Peakdata(pno).responsefactor)
                responsefactor(ind,fno)=Peakdata(pno).responsefactor;
            end                        
        end    
    end
end

% selected
[m,n]=size(rt); selected.rt=ones(m,n);
[m,n]=size(ri); selected.ri=ones(m,n);
[m,n]=size(area); selected.area=ones(m,n);
[m,n]=size(wbl); selected.wbl=ones(m,n);
[m,n]=size(wbl); selected.wbl_ri=ones(m,n);
[m,n]=size(height); selected.height=ones(m,n);
[m,n]=size(responsefactor); selected.responsefactor=ones(m,n);

% sets zeros to NaN
zerovalues=find(rt==0); rt(zerovalues)=NaN; selected.rt(zerovalues)=0;
zerovalues=find(ri==0); ri(zerovalues)=NaN; selected.ri(zerovalues)=0;
zerovalues=find(area==0); area(zerovalues)=NaN; selected.area(zerovalues)=0;
zerovalues=find(wbl==0); wbl(zerovalues)=NaN; selected.wbl(zerovalues)=0;
zerovalues=find(wbl_ri==0); wbl_ri(zerovalues)=NaN; selected.wbl_ri(zerovalues)=0;
zerovalues=find(height==0); height(zerovalues)=NaN; selected.height(zerovalues)=0;
zerovalues=find(responsefactor==0); responsefactor(zerovalues)=NaN; selected.responsefactor(zerovalues)=0;

% Sets Outdata
Outdata.filenames=filenames;
Outdata.cmp_code=allcodes;
Outdata.cmp_name=names;
Outdata.cmp_shortname=shortnames;
Outdata.rt=rt;
Outdata.ri=ri;
Outdata.wbl=wbl;
Outdata.wbl_ri=wbl_ri;
Outdata.area=area;
Outdata.height=height;
Outdata.responsefactor=responsefactor;
Outdata.Selected=selected;

%wblris % TEMP

%Outdata

% ------------------- DIRUPDATE ---------------------
function dirupdate
global Metset %Locset

%disp('--- dirupdate ---')

PathEdit=findobj(gcf,'Tag','PathEdit');
pathstr=get(PathEdit,'String');
SearchStrEdit=findobj(gcf,'Tag','SearchStrEdit');
searchstr=get(SearchStrEdit,'String');
FilesList=findobj(gcf,'Tag','FilesList');

DD=dir([pathstr '\' searchstr]);

for x=1:length(DD)
    %files{x}=DD(x).name;
    fn=DD(x).name;
    if strcmp(Metset.import_filetype, 'Chrombox C')
        fn=fn(5:length(fn)-4);
    end
    if strcmp(Metset.import_filetype, 'Chrombox Q')
        fn=fn(5:length(fn)-4);
    end
    files{x}=fn;
        
end

vals=get(FilesList,'Value');
vals(find(vals>length(files)))=[];
if isempty(vals) vals=1; end
set(FilesList,'Value',vals);


set(FilesList,'String',files)


% ------------------- FILETYPEUPDATE ---------------------
function filetypeupdate
global Metset Locset

%disp('--- filetypeupdate ---')

FileTypeRadio=findobj(gcf,'Tag','FileTypeRadio');
seltype=find(gcbo==FileTypeRadio);
if isempty(seltype)==0
    selradio=FileTypeRadio(seltype);
    set(FileTypeRadio,'Value',0)
    set(FileTypeRadio(seltype),'Value',1)
    Metset.import_filetype=get(FileTypeRadio(seltype),'String');
else
    set(FileTypeRadio,'Value',0)
    currentradio=findobj(gcf,'Tag','FileTypeRadio','String',Metset.import_filetype);
    set(currentradio,'Value',1)
end

pathstr='';
if strcmp(Metset.import_filetype, 'Chrombox C')
    pathstr=[Locset.path_cbc '\' Metset.path_cbc '\'];
    searchstr='res_*.mat';
end
if strcmp(Metset.import_filetype, 'Chrombox Q')
    pathstr=[Locset.path_cbq '\' Metset.path_cbq '\'];
    searchstr='res_*.mat';
end    

PathEdit=findobj(gcf,'Tag','PathEdit');
set(PathEdit,'String',pathstr)
SearchStrEdit=findobj(gcf,'Tag','SearchStrEdit');
set(SearchStrEdit,'String',searchstr)



%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='ExperimentsWin'; winpar{2}='Chrombox Optimizer: Import experiments';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model(99)',3,'','');
%p=p+1;[ui{p,1:8}] = deal('Tempsave','Pushbutton',Colors.bc,[x(2) y(1) bw bh*1.5],'oo_maincall(89)',3,'','-bm');
%p=p+1;[ui{p,1:8}] = deal('Resume','Pushbutton',Colors.bc,[x(3) y(1) bw bh*1.5],'oo_maincall(88)',3,'','-bm');

% Fileslist
p=p+1;[ui{p,1:7}] = deal('Available data:','Text',Colors.bc,[x(1) y(23) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(1) y(11) gw*2+bw gh*12],'',2,'FilesList');
% Directory
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[Pos.leftplot(1) y(10) gw+bw eh],'oo_model(1.2)',2,'PathEdit');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[Pos.leftplot(1)+gw+bw y(10) gw eh],'oo_model(1.2)',2,'SearchStrEdit');
%FiletypeRadios
p=p+1;[ui{p,1:7}] = deal('Chrombox C','Radiobutton',Colors.bc,[x(1) y(9) bw eh],'oo_model(1.1)',2,'FileTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Chrombox Q','Radiobutton',Colors.bc,[x(2) y(9) bw eh],'oo_model(1.1)',2,'FileTypeRadio');
% Read
p=p+1;[ui{p,1:7}] = deal('Read selected','Pushbutton',Colors.disk,[x(1) y(8) bw eh],'oo_model(2.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Append','Pushbutton',Colors.disk,[x(2) y(8) bw eh],'oo_model(2.1)',2,'');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(4) y(23) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(19) gw+bw gh*4],'oo_model(3.1)',2,'BoxesList');
p=p+1;[ui{p,1:7}] = deal('Chromatograms:','Text',Colors.bc,[x(4) y(18) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(14) gw+bw gh*4],'oo_model(3.2)',2,'ChromatogramsList');
p=p+1;[ui{p,1:7}] = deal('Parameters:','Text',Colors.bc,[x(4) y(13) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(10) gw+bw gh*3],'oo_model(3.3)',2,'ParametersList');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('Compound list:','Text',Colors.bc,[x(6) y(23) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('Import','Radiobutton',Colors.bc,[x(8) y(23) bw eh],'oo_model(6.1)',3,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Export','Radiobutton',Colors.bc,[x(9) y(23) bw eh],'oo_model(6.2)',3,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(6) y(10) gw*3+bw gh*13],'oo_model(3.4)',2,'CompoundList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(6) y(9) bw eh],'oo_model(4.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(6)+gw/2 y(9) bw eh],'oo_model(4.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short Name','RadioButton',Colors.bc,[x(7) y(9) bw eh],'oo_model(4.1)',2,'CodeRadio');

% select/deselect
p=p+1;[ui{p,1:7}] = deal('Select','Pushbutton',Colors.btn{1},[x(8) y(9) bw eh],'oo_model(5.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Deselect','Pushbutton',Colors.btn{1},[x(9) y(9) bw eh],'oo_model(5.2)',2,'');

% Export/ load
p=p+1;[ui{p,1:7}] = deal('Save Exp.','Pushbutton',Colors.disk,[x(1) y(6) bw eh],'oo_model(7.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Experiment','Edit',[1 1 1],[x(2) y(6) gw+bw eh],'',2,'FileNameEdit');
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(1) y(5) bw eh],'oo_model(7.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(5) gw+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Design','Pushbutton',Colors.disk,[x(1) y(4) bw eh],'oo_model(7.3)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(4) gw+bw eh],'',2,'DesignFilesPop');

% Assign
p=p+1;[ui{p,1:8}] = deal('Box name:','Text',Colors.bc,[x(5) y(8) bw eh],'',2,'','-r');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(6) y(8) gw+bw eh],'oo_model(8.1)',2,'BoxNameEdit');
p=p+1;[ui{p,1:8}] = deal('Assign to:','Text',Colors.bc,[x(5) y(7) bw eh],'',2,'','-r');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(6) y(7) gw+bw eh],'oo_model(8.2)',2,'ParametersPop');
p=p+1;[ui{p,1:7}] = deal('','Text',Colors.bc,[x(6) y(4) gw+bw gh*2+eh],'',2,'ParametersText');

updfcn='oo_model(100)'; 
h0=oo_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model(96)')
set(h0,'CloseRequestFcn','oo_model(99)')
% Multiple selections
FilesList=findobj(gcf,'Tag','FilesList'); set(FilesList,'Max',2,'Min',0)
FilesList=findobj(gcf,'Tag','ChromatogramsList'); set(FilesList,'Max',2,'Min',0)
FilesList=findobj(gcf,'Tag','CompoundList'); set(FilesList,'Max',2,'Min',0)
% List type
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','String','Import'); set(ListTypeRadio,'Value',1)


ShortNameCheck=findobj(gcf,'Tag','ShortNameCheck'); set(ShortNameCheck,'Value',1)

ParametersPop=findobj(gcf,'Tag','ParametersPop'); set(ParametersPop,'Enable','off')







