function oo_savefile(varargin)
%
% function oo_savefile(varargin)
% 
% Fuction for saving, cheks if files or folders exists
% Typical syntax: oo_savefile(fnam,CL,XBL,XR,RE,fileset,Metset,Info)
% Note that variables to be saved are not specified in '' as in Matlab save
% command
% Option '-o' overwrites files without prompting
% Option '-s' suppress message "data saved to.."
% Behaviour is controlled by the following global variables:
%    - Metset.global_saveas_v6=1; Save in Matlab v6.x format
%    - Metset.global_overwrite=1; Overwrite files without warning
%    - Metset.global_makedir=0; Automatically create directories 

persistent pathstr filename fileext save_Variables options
global Metset Locset

if Locset.tracker disp(['--- oo_savefile --- ']); end

if nargin==1
    an=varargin{1};
end

if nargin>1
    pathname=varargin{1};    
    separators=findstr('\',pathname);
    pathstr=pathname(1:max(separators)-1);

    fileext=pathname(length(pathname)-3:length(pathname));
    if strcmp(fileext,'.mat');
        filename=pathname(max(separators)+1:length(pathname)-4);
    else
        filename=pathname(max(separators)+1:length(pathname));
        fileext='.mat';
    end
    
    options=[]; save_Variables=[];
    for x=2:length(varargin) 
        if isempty(inputname(x))
            options=[options varargin{x}];
        else
            save_Variables.(inputname(x))=varargin{x};
        end        
    end

    if isempty(findstr('-o',options))==0
        an=1; % overwrite
    else       
        an=2; % Normal save
    end
    
end

if an==1
    %disp('---- overwrite ----')
    err=checkmakedir(pathstr);
    if err==0 
        pathname=[pathstr filesep filename fileext];
        savefile(pathname,save_Variables,options); 
    else
        fixwindow(pathstr,filename,fileext,err)
    end
end

if an==2
    %disp('---- save normal ---')
    err=checkmakedir(pathstr);
    if err==0 && Metset.global_overwrite==0 
        err=checkfile(pathstr,filename,fileext); 
    end    
    if err==0 
        pathname=[pathstr filesep filename fileext];
        savefile(pathname,save_Variables,options); 
    else
        fixwindow(pathstr,filename,fileext,err)
    end    
end

if an==3
    %disp('---- save with new name ---')
    pathstr=get(findobj(gcf,'Tag','NewPathEdit'),'String');
    filename=get(findobj(gcf,'Tag','NewNameEdit'),'String');
    fileext=get(findobj(gcf,'Tag','NewExtEdit'),'String');
    FilenameWin=findobj('Tag','FilenameWin'); close(FilenameWin) % Must come after reading of new names
    pathname=[pathstr '\' filename fileext];
    savefile(pathname,save_Variables,options);  
end


% call from NewPathEdit
if an==10.1
    %disp('--- set path ----')
    checkstatus
end
% Create new folder
if an==10.2  
    NewPathEdit=findobj(gcf,'Tag','NewPathEdit');
    newpath=get(NewPathEdit,'String');
    newpath=strrep(newpath,[filesep filesep],filesep);
    if newpath(end)==filesep
        newpath=newpath(1:end-1);
    end
    seppos=strfind(newpath,filesep);
    modir=newpath(1:seppos(end)-1);
    dadir=newpath(seppos(end)+1:numel(newpath));
    [s, mess, messid]  = mkdir(modir,dadir);
    checkstatus    
end
% Edit filename
if an==10.3
    checkstatus 
end
if an==10.4
    getname
    checkstatus
end

% Always overwrite-check, makes changes to method
if an==15
    Metset.global_overwrite=get(gcbo,'Value');
end

% ================== SUBFUNCTIONS ==================

% ------------------ GETNAME -------------------
function getname

NewPathEdit=findobj(gcf,'Tag','NewPathEdit'); 
OldNameEdit=findobj(gcf,'Tag','OldNameEdit'); 
NewNameEdit=findobj(gcf,'Tag','NewNameEdit'); 
NewExtEdit=findobj(gcf,'Tag','NewExtEdit'); 

inname=get(OldNameEdit,'String');
pathstr=get(NewPathEdit,'String');
fileext=get(NewExtEdit,'String');

p=0; tryno=0; filename=inname;
while p==0
    tryno=tryno+1;
    filename=[inname '(' num2str(tryno) ')'];
    D=dir([pathstr filesep filename fileext]);
    if isempty(D)
        p=1;
    end
    if tryno>100 p=1; end
end

set(NewNameEdit,'String',filename)


% ------------------ CHECKDIR -------------------
function err=checkdir(pathstr)

err=0;
isadir=isdir(pathstr);
if isadir==0
    err=1;
end

% ------------------ CHECKMAKEDIR -------------------
function err=checkmakedir(pathstr)
global Metset

err=0;
isadir=isdir(pathstr);
if isadir==0
    err=1;
    if Metset.global_makedir 
        %disp('--- makes dir ---')
        status = mkdir(pathstr);
        if status==1 err=0; end
    end   
end


% ------------------ CHECKFILE -------------------
function err=checkfile(pathstr,filename,fileext)

D=dir([pathstr filesep filename fileext]);

err=0;
if isempty(D)==0
    %disp('--- file exists ---')
    err=2;
end


% ------------------ FIXWINDOW -------------------

function fixwindow(pathstr,filename,fileext,err)
global Colors Pos

hp=Pos.window(1)+0.1;
vp=Pos.window(1)+0.1;
wh=Pos.window(3)/2;
ww=Pos.window(4)*0.7;

if err==1 errormsg='Warning: Attempt to save to a non-existent folder'; end
if err==2 errormsg='Warning: File name already exists'; end

h=findobj('Tag','FilenameWin');
if isempty(h)
    winpar={'FilenameWin','Warning',[hp vp ww wh]};
    p=1; [ui{p,1:7}] = deal(errormsg,'text',Colors.bc,[0.1 0.80 0.5 0.1],' ',4,'');
    p=p+1; [ui{p,1:7}] = deal('Current path/name','text',Colors.bc,[0.1 0.72 0.5 0.06],' ',3,'');
    p=p+1; [ui{p,1:7}] = deal([pathstr],'Edit',[1 1 1],[0.1 0.65 0.5 0.06],'',2,'OldPathEdit'); 
    p=p+1; [ui{p,1:7}] = deal([filename],'Edit',[1 1 1],[0.6 0.65 0.25 0.06],'',2,'OldNameEdit');
    p=p+1; [ui{p,1:7}] = deal([fileext],'Edit',[1 1 1],[0.85 0.65 0.05 0.06],'',2,'OldExtEdit');
    p=p+1; [ui{p,1:7}] = deal('Proposed path/name','text',Colors.bc,[0.1 0.42 0.5 0.06],' ',3,'');
    p=p+1; [ui{p,1:7}] = deal('','Edit',[1 1 1],[0.1 0.35 0.5 0.06],'oo_savefile(10.1)',2,'NewPathEdit');  
    p=p+1; [ui{p,1:7}] = deal('','Edit',[1 1 1],[0.6 0.35 0.25 0.06],'oo_savefile(10.3)',2,'NewNameEdit');  
    p=p+1; [ui{p,1:7}] = deal('','Edit',[1 1 1],[0.85 0.35 0.05 0.06],'',2,'NewExtEdit'); 
    p=p+1; [ui{p,1:8}] = deal('Save with new name','Pushbutton',Colors.accept,[0.1 0.25 0.2 0.08],'oo_savefile(3); ',2,'SaveNewButton','-bm');  
    p=p+1; [ui{p,1:8}] = deal('Create new folder','Pushbutton',Colors.accept,[0.4 0.25 0.2 0.08],'oo_savefile(10.2)',2,'CreateFolderButton','-bm'); 
    p=p+1; [ui{p,1:8}] = deal('Propose name','Pushbutton',Colors.accept,[0.7 0.25 0.2 0.08],'oo_savefile(10.4)',2,'ProposeNameButton','-bm'); 
    p=p+1; [ui{p,1:8}] = deal('Overwrite','Pushbutton',Colors.reset,[0.1 0.55 0.2 0.08],'oo_savefile(1); close(gcf)',2,'OverwriteButton','-bm');
    p=p+1; [ui{p,1:8}] = deal('Always overwrite files','Checkbox',Colors.bc,[0.4 0.55 0.4 0.08],'oo_savefile(15)',2,'OverwriteCheck','-bm');
    p=p+1; [ui{p,1:8}] = deal('Do not save','Pushbutton',Colors.reset,[0.1 0.1 0.2 0.08],'close(gcf); ',2,'','-bm');
    p=p+1; [ui{p,1:8}] = deal('','Text',Colors.bc,[0.4 0.1 0.5 0.1],'',3,'FixWinMessage','');
    h0=oo_drawwin(winpar,ui,''); 
    set(h0,'WindowStyle','modal');
end

NewPathEdit=findobj(gcf,'Tag','NewPathEdit'); set(NewPathEdit,'String',pathstr);
NewNameEdit=findobj(gcf,'Tag','NewNameEdit'); set(NewNameEdit,'String',filename);
NewExtEdit=findobj(gcf,'Tag','NewExtEdit'); set(NewExtEdit,'String',fileext);
OldNameEdit=findobj(gcf,'Tag','OldNameEdit'); set(OldNameEdit,'Enable','off');
OldPathEdit=findobj(gcf,'Tag','OldPathEdit'); set(OldPathEdit,'Enable','off');
OldExtEdit=findobj(gcf,'Tag','OldExtEdit'); set(OldExtEdit,'Enable','off');
NewExtEdit=findobj(gcf,'Tag','NewExtEdit'); set(NewExtEdit,'Enable','off');

OverwriteCheck=findobj(gcf,'Tag','OverwriteCheck'); set(OverwriteCheck,'Enable','off')

checkstatus


% ------------------ CHECKSTATUS -------------------
function checkstatus
%disp('--- checkstatus ---')

NewPathEdit=findobj(gcf,'Tag','NewPathEdit');
NewNameEdit=findobj(gcf,'Tag','NewNameEdit');
NewExtEdit=findobj(gcf,'Tag','NewExtEdit');

CreateFolderButton=findobj(gcf,'Tag','CreateFolderButton');
SaveNewButton=findobj(gcf,'Tag','SaveNewButton');
OverwriteButton=findobj(gcf,'Tag','OverwriteButton');
ProposeNameButton=findobj(gcf,'Tag','ProposeNameButton');

FixWinMessage=findobj(gcf,'Tag','FixWinMessage');

pathstr=get(NewPathEdit,'String');
filename=get(NewNameEdit,'String');
fileext=get(NewExtEdit,'String');

err=checkdir(pathstr);
if err==0 
    err=checkfile(pathstr,filename,fileext); 
end

if err==1
    set(NewPathEdit,'BackgroundColor',[1 1 0])
    set(NewNameEdit,'BackgroundColor',[1 1 1],'Enable','off')
    set(SaveNewButton,'Enable','off')
    set(OverwriteButton,'Enable','off')
    set(ProposeNameButton,'Enable','off')
    set(CreateFolderButton,'Enable','on')
    errorstr={'Path is not valid','Change to valid path or create folder'};
end

if err==2
    set(NewPathEdit,'BackgroundColor',[1 1 1])
    set(NewNameEdit,'BackgroundColor',[1 1 0],'Enable','on')
    set(SaveNewButton,'Enable','off')
    set(OverwriteButton,'Enable','on')
    set(OverwriteButton,'Enable','on')
    set(CreateFolderButton,'Enable','off')
    set(ProposeNameButton,'Enable','on')
    errorstr={'Selected filename exist in the proposed folder','Overwrite, or change path or filename'};
end

if err==0
    set(NewPathEdit,'BackgroundColor',[1 1 1],'Enable','on')
    set(NewNameEdit,'BackgroundColor',[1 1 1],'Enable','on')
    set(SaveNewButton,'Enable','on')
    set(OverwriteButton,'Enable','on')
    set(CreateFolderButton,'Enable','off')
    errorstr={'Path is valid','File name is valid'};
end

set(FixWinMessage,'String',errorstr)


% ------------------ SAVEFILE -------------------
function savefile(pathname,save_Variables,options)
global Metset

%disp('--- oo_savefile/savefile ---')
savefiledata_pathname=pathname;
savefiledata_Variables=save_Variables;
savefiledata_options=options;
savefiledata_Metset=Metset;

savefiledata_varnames=fieldnames(savefiledata_Variables); savefiledata_savestr2=['save ' savefiledata_pathname];
for savefiledata_x=1:length(savefiledata_varnames)
    eval([savefiledata_varnames{savefiledata_x} ' = save_Variables.' savefiledata_varnames{savefiledata_x} ';']);
    savefiledata_savestr2=[savefiledata_savestr2 ' ' savefiledata_varnames{savefiledata_x}];
end

if savefiledata_Metset.global_saveas_v6==1
    savefiledata_savestr1=[savefiledata_savestr2 ' -v6'];
else
    savefiledata_savestr1=savefiledata_savestr2;
end
%savefiledata_savestr1 % TEMP
%savefiledata_savestr2 % TEMP

savefiledata_passed=0;

try
    %disp('---- tries string 1 ----')
    eval(savefiledata_savestr1)
    savefiledata_passed=1;
    %disp('---- string 1 passed ----')
catch
    try
        %disp('---- tries string 2 ----')
        eval(savefiledata_savestr2)
        savefiledata_passed=1;
        %disp('---- string 2 passed ----')
    catch
        %disp('---- both failed ----')
    end
end

if savefiledata_passed==1
    if isempty(findstr('-s',savefiledata_options))
        oo_message(1,['|b|Data saved to ' savefiledata_pathname])
    end
else
    oo_message(1,['|r| Error: Save failed'])
end

Metset=savefiledata_Metset; % resets global variable

    