function oo_settings(an)

global Metset Fileset Locset

oo_message(2)

if an==1
    wintag=get(gcf,'Tag');
    openwin
    getmets
    settoggle(wintag)
    evaltoggle
end

% Togglebuttons
if an==1.1
    h=findobj('Tag','WinToggle'); set(h,'Value',0); set(gco,'Value',1); evaltoggle 
end

% Text_set
if an==2.1 txtstr=get(gco,'String'); vn=get(gco,'UserData'); Metset.(vn)=txtstr; end
% Num_set
if an==2.20 % numbers
    txtstr=get(gco,'String'); num=str2double(txtstr); vn=get(gco,'UserData'); 
    if isnan(num) num=Metset.(vn); oo_message(1,'|r|Numeric input only'); end
    Metset.(vn)=num; set(gco,'String',num2str(num)); 
    Metset.lastchange=now; 
end 
% Numpos_set
if an==2.21 % Positive number
    txtstr=get(gco,'String'); num=str2double(txtstr); vn=get(gco,'UserData'); 
    if isnan(num) || num<=0  num=Metset.(vn); oo_message(1,'|r|Positive numbers only'); end
    Metset.(vn)=num; set(gco,'String',num2str(num)); 
    Metset.lastchange=now; 
end 
% Int_set
if an==2.25 
    txtstr=get(gco,'String'); num=str2double(txtstr); vn=get(gco,'UserData'); 
    if isnan(num) num=Metset.(vn); oo_message(1,'|r|Numeric input only'); end
    num=round(num); Metset.(vn)=num; set(gco,'String',num2str(num)); 
    Metset.lastchange=now; 
end  
% Intpos_set
if an==2.26 
    txtstr=get(gco,'String'); num=str2double(txtstr); vn=get(gco,'UserData'); 
    if isnan(num) || num<=0  num=Metset.(vn); oo_message(1,'|r|Positive integers only'); end
    num=round(num); Metset.(vn)=num; set(gco,'String',num2str(num)); 
    Metset.lastchange=now; 
end 

% Checkbox
if an==2.3 num=get(gco,'Value'); vn=get(gco,'UserData'); Metset.(vn)=num; end        
% Checkbox
if an==2.4 num=get(gco,'Value'); str=get(gco,'String'); vn=get(gco,'UserData'); Metset.(vn)=str{num}; end    
% Path settings
if an==2.5 || an==2.6 res=checkdir; end
if an==2.5 && res(1)==1 txtstr=get(gco,'String'); vn=get(gco,'UserData'); Locset.(vn)=txtstr; end
if an==2.6 && res(2)==1 txtstr=get(gco,'String'); vn=get(gco,'UserData'); Metset.(vn)=txtstr; end

% Check for testplot
if an>2 && an<3
    if get(findobj('Tag','WinToggle','String','Plots'),'Value')
        testplot
    end
end


% Changes to Locset
% Textset
if an==4.1 txtstr=get(gco,'String'); vn=get(gco,'UserData'); Locset.(vn)=txtstr; end
% Numset
if an==4.2 txtstr=get(gco,'String'); num=str2double(txtstr); vn=get(gco,'UserData'); Locset.(vn)=num; end    
% Checkbox
if an==4.3 num=get(gco,'Value'); vn=get(gco,'UserData'); Locset.(vn)=num; end        
% Checkbox
if an==4.4 num=get(gco,'Value'); str=get(gco,'String'); vn=get(gco,'UserData'); Locset.(vn)=str{num}; end  


% Save
if an==3.1
    if isfield(Locset,'user')==0 Locset.user='Anonymous'; end
    fn=fieldnames(Metset); n=length(fn);
    h=findobj('Tag','CurrentMethEdit'); currentmeth=get(h,'String'); 
    if isempty(currentmeth)==0
        pathname=[Locset.path_method,'\met_',currentmeth,'.mat'];
        Metset.file_method=currentmeth; 
        for x=1:n Settings.(fn{x})=Metset.(fn{x}); end
        Info.savedby='ChromBox D'; Info.version=Locset.version; Info.function='oo_settings'; Info.date=date; Info.clockvector=clock; Info.matlabversion=version; Info.user=Locset.user;   
        oo_savefile(pathname,Settings,Info,'-o')   
        getmets
    else
        oo_message(1,'|r|Method name not given')
    end
end

% Load
if an==3.2
    h=findobj(gcf,'Tag','MethsPop'); str=get(h,'String'); if iscell(str)==0 str=cellstr(str); end
    val=get(h,'Value');
    h=findobj('Tag','CurrentMethEdit'); set(h,'String',str{val});
    currentmeth=str{val}; pathname=[Locset.path_method,'\met_',currentmeth,'.mat'];
    load(pathname);
    Settings.dummy=[]; fn=fieldnames(Settings); n=length(fn);
    for x=1:n Metset.(fn{x})=Settings.(fn{x}); end   
    Metset.file_method=currentmeth;
    oo_setz; % updates Zset
end

if an>3.0 && an<=3.9  
    getmets
    evaltoggle
    Fileset.global_methodfile=currentmeth; % Setter metodenavn i Fileset (riktig metode kan loades)
    h=findobj('Tag','CurrMethTxt'); set(h,'String',['Current Method: ' Fileset.global_methodfile])
end

% Store local settings
if an==4
    Savesettings=Locset;
    VersionPop=findobj(gcf,'Tag','SetFrEd','UserData','VersionPop');
    codes=get(VersionPop,'String'); val=get(VersionPop,'Value'); Savesettings.version=codes{val};
    oo_setlocset(Savesettings)    
end
% Select code
if an==4.5
    codes=get(gcbo,'String'); val=get(gcbo,'Value'); selectedversion=codes{val}; 
    currentversion=Locset.version;
    if ~strcmp(selectedversion,currentversion) oo_message(1,['|b|New code selected. Press [Save local settings] and restart to change from ' currentversion]); end
end

% =========================================================================
%                         S U B F U N C T I O N S
% =========================================================================
% ------------------- Checkdir ---------------------
function res=checkdir
global Locset Metset
res=[1 1];

currentvar=get(gcbo,'UserData');
loch=findobj('UserData',currentvar,'CallBack','oo_settings(2.5)');
meth=findobj('UserData',currentvar,'CallBack','oo_settings(2.6)');
set(loch,'BackgroundColor',[1 1 1]);
set(meth,'BackgroundColor',[1 1 1]);

allpath=[get(loch,'String') '\' get(meth,'String')]; isall=isdir(allpath);
locpath=[get(loch,'String')]; isloc=isdir(locpath);

if isall==0 && isloc==0
    set(loch,'BackgroundColor',[1 1 0]);  set(loch,'String',Locset.(currentvar)); res(1)=0;
    if isempty(meth)==0
        set(meth,'BackgroundColor',[1 1 0]);  set(meth,'String',Metset.(currentvar)); res(2)=0;
    end   
end
if isall==0 && isloc==1 && isempty(meth)==0
    set(meth,'BackgroundColor',[1 1 0]); set(meth,'String',Metset.(currentvar)); res(2)=0;
end 

if sum(res)<2 oo_message(1,['|r|' allpath ' Does not exist']); end


% ------------------- settoggle ---------------------
function settoggle(wintag)

wintoggles=findobj('Tag','WinToggle'); set(wintoggles,'Value',0)

%wintag % TEMP
a=0;
if strmatch(wintag,'MainWin') wintoggle=findobj(wintoggles,'String','General'); set(wintoggle,'Value',1); a=1; end
if strmatch(wintag,'ModelsWin') wintoggle=findobj(wintoggles,'String','Plots'); set(wintoggle,'Value',1); a=1; end
%if strmatch(wintag,'BlWin') wintoggle=findobj(wintoggles,'String','Baseline'); set(wintoggle,'Value',1); a=1; end
%if strmatch(wintag,'PeakWin') wintoggle=findobj(wintoggles,'String','Find Peaks'); set(wintoggle,'Value',1); a=1; end
%if strmatch(wintag,'QuantWin') wintoggle=findobj(wintoggles,'String','Quantify'); set(wintoggle,'Value',1); a=1; end
%if strmatch(wintag,'ResultsWin') wintoggle=findobj(wintoggles,'String','Results'); set(wintoggle,'Value',1); a=1; end
if a==0 wintoggle=findobj(wintoggles,'String','General'); set(wintoggle,'Value',1); end
% Problem hvis ingen satt!!

% ------------------- EVALTOGGLE ---------------------
function evaltoggle
h=findobj('Tag','WinToggle'); h=findobj(h,'Value',1); str=get(h,'String');
if strmatch(str,'Directories') setpath; end
if strmatch(str,'General') setglobal; end
if strmatch(str,'Reports') setreport; end
if strmatch(str,'Plots') setplots; end

%if strmatch(str,'Class Def.') setclass; end

% ------------------- getmets ---------------------
function getmets
global Metset Locset
%disp('---- GETMETS ----')

pathname=[Locset.path_method,'\met_*'] ;
DD=dir(pathname);
n=length(DD);

fn{1}='';
for x=1:n
    nam=DD(x).name;
    fn{x}=nam(5:length(nam)-4);
end

if isfield(Metset,'file_method')   
    h=findobj('Tag','MethsPop'); set(h,'String',fn); 
    pos=strmatch(Metset.file_method,fn,'exact');
    if isempty(pos) pos=1; end
    set(h,'Value',pos);
    CurrentMethEdit=findobj('Tag','CurrentMethEdit'); set(CurrentMethEdit,'String',Metset.file_method);
end
%disp('---- end GETMETS ----')

% ------------------- CLEARFRAME ---------------------
function clearframe
%disp('---- CLEARFRAME ----')

h=findobj('Tag','SetFrTxt'); delete(h);
h=findobj('Tag','SetFrEd'); delete(h);
h=findobj('Tag','SetFrSep'); delete(h);
h=findobj('Tag','SetFrCh'); delete(h);
h=findobj('Tag','SetFrBtn'); delete(h);
%disp('---- end CLEARFRAME ----') SetFrBtn

Testplot=findobj(gcf,'Tag','Testplot'); delete(Testplot)

% ============================== SET___ =================================


% ------------------- SETREPORT ---------------------
function setreport
global Metset Locset

clearframe;
pos=0.85;
pos=pop_set(pos,'Preferred report:',{'Text file (txt)','Data Interchange format (dif)','Excel (xls), single sheet','Excel (xls), multiple sheets'},'report_pref','');
pos=check_set(pos,'Auto open','report_aopen',' ');


% ------------------- SETPLOTS ---------------------
function setplots
global Metset Locset

clearframe;
pos=0.85;
pos=pop_set(pos,'Set levels / spacing',{'Set levels','Set difference'},'contour_levelset','Define number of contours or the spacing between isolines');
pos=intpos_set(pos,'Number of isolines','contour_nlevels','Approximate number of isolines, used with "Set levels"');
pos=numpos_set(pos,'Spacing between isolines','contour_spacing','Spacing between isolimnes, used with "Set difference"');
cmaps={'jet','hsv','hot','cool','spring','summer','autumn','winter','gray','bone','copper','pink','hotcold','traffic','white'};
pos=pop_set(pos,'Color map:',cmaps,'contour_colormap','Colors of surface plots');
pos=check_set(pos,'Show labels','contour_labels',' ');
pos=check_set(pos,'Show isolines','contour_isolines',' ');
pos=check_set(pos,'Show design','contour_showdesign',' ');
pos=intpos_set(pos,'Brightness','contour_brightness','Integer 1-100. 50 is neutral');
pos=check_set(pos,'Inverse colors','contour_invertcolor','Inverts colors (display as negative)');
pos=check_set(pos,'Inverse scale','contour_invertscale','Inverts the color scale');
pos=check_set(pos,'Center colormap','contour_centercol','Centers the colormap around 0 (use with "posneg")');
pos=check_set(pos,'Apply color limits','contour_colorlimits','Use upper and lower limits of color scale, overrides centering');
pos=num_set(pos,'Color min','contour_colormin','Minimum of Color map');
pos=num_set(pos,'Color max','contour_colormax','Maximum of Color map');
testplot

% ------------------- SETGLOBAL ---------------------
function setglobal
global Metset Locset

clearframe;
pos=0.8;

pos=check_set(pos,'Save in Matlab v6.x format','global_saveas_v6','');
pos=check_set(pos,'Overwrite without warning','global_overwrite','Results files, reports and filters (other files are always overwritten)');
pos=check_set(pos,'Automatically create folders','global_makedir','');
pos=separator(pos,1);

%pos=pop_set(pos,'Column:',Metset.global_columns,'global_selcol','Select column');

%D=dir([Locset.path_library,'/class_*']); % Leser klasser fra Library-dir
%D=D(find(cat(2,D.isdir))); for x=1:length(D) DD{x}=D(x).name(7:length(D(x).name)); end % Variabel for klasse-navn
%pos=pop_set(pos,'Class:',DD,'global_class','Compound class');

% ------------------- SETPATH ---------------------
function setpath
global Metset Locset Pos Colors

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; 
y=0.93:-Pos.gh:0;

clearframe;

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(2) y(3) bw*2.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String','Local Settings',...
    'FontSize',12,...
    'Tag','SetFrTxt',...
    'HorizontalAlignment','Center');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(4)+bw/2 y(3) bw*2.3 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String','Method Settings',...
    'FontSize',12,...
    'Tag','SetFrTxt',...
    'HorizontalAlignment','Center');


defaultfolders=0; if isfield(Locset,'defaultfolders') && Locset.defaultfolders==1 defaultfolders=1; end
pos=0.8; %Metset.path_class=['class_' Metset.global_class];
%pos=path_set(pos,{'C Root:','path_root','','Root directory for data and settings'});
%pos=path_set(pos,{'C Rawdata:','path_qqraw','path_qqraw','Directory for QQ-Rawdata (Mat format)'});
folderpos(1)=pos; pos=path_set(pos,{'Rawdata:','path_rawdata','path_rawdata','Rawdata directory'});
folderpos(2)=pos; pos=path_set(pos,{'Designs:','path_designs','path_designs','Stored designs directory'});
folderpos(3)=pos; pos=path_set(pos,{'Experiments:','path_experiments','path_experiments','Experimental data directory'});
folderpos(4)=pos; pos=path_set(pos,{'Models:','path_models','path_models','Stored models directory'});
folderpos(5)=pos; pos=path_set(pos,{'Results:','path_results','path_results','Stored results directory'});
folderpos(6)=pos; pos=path_set(pos,{'Reports:','path_reports','path_reports','Stored reports directory'});
folderpos(7)=pos; pos=path_set(pos,{'Export:','path_export','path_export','Export directory'});
if defaultfolders folderpos(8)=pos; pos=text_set2(pos,'Default folders','Folders set to default at start. Controlled by ''defaultfolders'' in oo_localsettings',''); end
%pos=path_set(pos,{'Code:','path_code','','Program code / Version'});
%pos=separator(pos,1);
%pos=path_set(pos,{'Chrombox C:','path_cbc','path_cbc','Chrombox C results folder'});
%pos=path_set(pos,{'Chrombox Q:','path_cbq','path_cbq','Chrombox Q results folder'});

%pos=path_set(pos,{'Agilent Import:','path_agilent','path_agilent','HP/Agilent MS Chemstation format'});
%pos=path_set(pos,{'CDF Import:','path_cdf','path_cdf','AIA-CDF import'});
%pos=path_set(pos,{'Extricator Import:','path_prs','path_prs','Exportet mat files from PRS Extricator'});
%pos=path_set(pos,{'Matlab Import:','path_matlab','path_matlab','Various mat formats'});
%pos=path_set(pos,{'CSV Import:','path_csv','path_csv','Comma separated values'});
pos=separator(pos,1);

if defaultfolders
    for fn=1:length(folderpos)
        uicontrol('Parent',gcf,'BackgroundColor',[0 1 0],'Position',[x(2)-bw*0.15 folderpos(fn)+eh*0.3 bw*0.10 eh*0.6],'Style','Text','Tag','SetFrEd');
    end
end

% Finds code versions
D=dir([Locset.path_root,'\code']); DD=D(cat(2,D.isdir));
cn=0;
for t=1:length(DD)
    if ~(strcmp(DD(t).name,'.') || strcmp(DD(t).name,'..'))
        cn=cn+1; codestr{cn}=DD(t).name;
    end
end

currentversion=strmatch(Locset.version,codestr,'exact');
if isempty(currentversion) || length(currentversion)>1 currentversion=1; end

h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String','Code version:',...
    'Tag','SetFrTxt');

popmen = uicontrol('Parent',gcf, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2) pos bw eh], ...
    'HorizontalAlignment','left',...
    'Style','Popupmenu',...
    'Value',currentversion,...
    'Callback','oo_settings(4.5)',...
    'Tag','SetFrEd',...
    'UserData','VersionPop',...
	'String',codestr);

h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.btn{6}, ...
	'Position',[x(3)+bw/2 pos bw bh], ...
    'Style','Pushbutton',...
	'String','Save local settings',...
    'FontSize',10,...
    'Tag','SetFrBtn',...
    'HorizontalAlignment','Center',...
    'Callback','oo_settings(4.0)');


%h1 = uicontrol('Parent',winh, ...
%    'BackgroundColor',Colors.btn{6}, ...
%	'Position',[x(2) pos bw*2.5 bh], ...
%    'Style','Pushbutton',...
%    'HorizontalAlignment','left',...
%	'String','Save local settings',...
%    'FontSize',10,...
%    'Tag','SetFrBtn',...
%    'HorizontalAlignment','Center',...
%    'Callback','oo_settings(4.0)');


% ------------------- SETRES ---------------------
%function setres
%global Metset

%clearframe;
%pos=0.8;
%pos=num_set(pos,'Homolog RI Dist:','results_homridiff','Distance in RI units between homologs');
%pos=check_set(pos,'Fit peak parameters','results_peakfit','Calculate peak parameters by gaussian fit');
%pos=check_set(pos,'Kurtosis = 1','results_kurt','Off allows kurtosis different from 1 (slow calculation)');
%pos=num_set(pos,'Fit to peakwidth (sigma):','results_sigma','Peakwith (standard deviations) used in fitting function (=> 4)');


% ------------------- SETLIB ---------------------
%function setlib
%global Metset

%oo_libset(1);

% ------------------- SETCLASS ---------------------
%function setclass
%global Metset

%oo_classdef(1);

% ============================= EDIT FUNCTIONS =================================

% ------------------- pop_set ---------------------
function pos=pop_set(pos,txtstr,alt_cell,vn,expl)
% pos: vert. position, txtstr: tekst, alt_cell: Celle med alternativer, vn: fieldname; expl: forklaring 
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
popmen = uicontrol('Parent',winh, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw*3 eh], ...
    'HorizontalAlignment','left',...
    'Style','Popupmenu',...
    'UserData',vn,...
    'Callback','oo_settings(2.4)',...
    'Tag','SetFrEd',...
	'String',alt_cell);
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(6) pos bw*3 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;

val=strmatch(Metset.(vn),alt_cell); val=val(1);
if isempty(val) val=1; end
set(popmen,'Value',val);

% ------------------- path_set ---------------------
function pos=path_set(pos,incell)
global Pos Colors Metset Locset

txtstr=incell{1}; Locset_vn=incell{2}; Metset_vn=incell{3}; expl=incell{4}; 
dstr=''; if length(incell)==5 dstr=incell{5}; end

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2) pos bw*2.5 eh], ...
    'HorizontalAlignment','left',...
    'Style','Edit',...
    'UserData',Locset_vn,...
    'Callback','oo_settings(2.5)',...
    'Tag','SetFrEd',...
	'String',Locset.(Locset_vn));
if dstr=='l'; set(h1,'Enable','off'); end
if isdir(Locset.(Locset_vn))==0 set(h1,'BackgroundColor',[1 1 0]); end

if isempty(Metset_vn)==0
    h1 = uicontrol('Parent',winh, ...
        'BackgroundColor',[1 1 1], ...
    	'Position',[x(4)+bw/2 pos bw*2.3 eh], ...
        'HorizontalAlignment','left',...
        'Style','Edit',...
        'UserData',Metset_vn,...
        'Callback','oo_settings(2.6)',...
        'Tag','SetFrEd',...
	    'String',Metset.(Metset_vn));    
    if dstr=='r'; set(h1,'Enable','off'); end
    if isdir([Locset.(Locset_vn) '\' Metset.(Metset_vn)])==0 set(h1,'BackgroundColor',[1 1 0]); end
end

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(7) pos bw*2.5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;

% ------------------- text_set ---------------------
function pos=text_set(pos,txtstr,vn,expl)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw*3 eh], ...
    'HorizontalAlignment','left',...
    'Style','Edit',...
    'UserData',vn,...
    'Callback','oo_settings(2.1)',...
    'Tag','SetFrEd',...
	'String',Metset.(vn));
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(6) pos bw*3 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;


% ------------------- text_set2 ---------------------
function pos=text_set2(pos,txtstr1,txtstr2,txtstr3)
global Pos Colors 

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr1,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(2) pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Style','Text',...
    'Tag','SetFrTxt',...
	'String',txtstr2);
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(7) pos bw*2.5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',txtstr3);

pos=pos-gh;

% ------------------- num_set ---------------------
function pos=num_set(pos,txtstr,vn,expl)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw/2 eh], ...
    'HorizontalAlignment','right',...
    'Style','Edit',...
    'UserData',vn,...
    'Callback','oo_settings(2.2)',...
    'Tag','SetFrEd',...
	'String',Metset.(vn));
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(3)+bw/3 pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;

% ------------------- numpos_set ---------------------
function pos=numpos_set(pos,txtstr,vn,expl)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw/2 eh], ...
    'HorizontalAlignment','right',...
    'Style','Edit',...
    'UserData',vn,...
    'Callback','oo_settings(2.21)',...
    'Tag','SetFrEd',...
	'String',Metset.(vn));
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(3)+bw/3 pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;


% ------------------- int_set ---------------------
function pos=int_set(pos,txtstr,vn,expl)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw/2 eh], ...
    'HorizontalAlignment','right',...
    'Style','Edit',...
    'UserData',vn,...
    'Callback','oo_settings(2.25)',...
    'Tag','SetFrEd',...
	'String',Metset.(vn));
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(3)+bw/3 pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;


% ------------------- intpos_set ---------------------
function pos=intpos_set(pos,txtstr,vn,expl) % positive integer
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',[1 1 1], ...
	'Position',[x(2)+bw/2 pos bw/2 eh], ...
    'HorizontalAlignment','right',...
    'Style','Edit',...
    'UserData',vn,...
    'Callback','oo_settings(2.26)',...
    'Tag','SetFrEd',...
	'String',Metset.(vn));
h1 = uicontrol('Parent',gcf, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(3)+bw/3 pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;


% ------------------- check_set ---------------------
function pos=check_set(pos,txtstr,vn,expl)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 

winh=findobj('Tag','SetWin','Type','figure');

h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(1) pos bw*1.5 eh], ...
    'Style','Text',...
    'HorizontalAlignment','left',...
	'String',txtstr,...
    'Tag','SetFrTxt');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(2)+bw/2 pos bw/3 eh], ...
    'HorizontalAlignment','right',...
    'Style','Checkbox',...
    'UserData',vn,...
    'Callback','oo_settings(2.3)',...
    'Value',Metset.(vn),...
    'Tag','SetFrCh');
h1 = uicontrol('Parent',winh, ...
    'BackgroundColor',Colors.bc, ...
	'Position',[x(3)+bw/3 pos bw*5 eh], ...
    'HorizontalAlignment','left',...
    'Tag','SetFrTxt',...
    'Style','Text',...
	'String',expl);
pos=pos-gh;

% ------------------- Separator ---------------------
function pos=separator(pos,an)
global Pos Colors Metset

bw=Pos.bw; bh=Pos.bh; eh=Pos.eh; gh=Pos.gh;% 
x=0.055:Pos.gw:1; y=0.93:-Pos.gh:0; 
pos=pos+gh/1.7;

winh=findobj('Tag','SetWin','Type','figure');

if an==1
    h1 = uicontrol('Parent',winh, ...
        'BackgroundColor',[0 0 0], ...
	    'Position',[x(1) pos bw*8 0.002], ...
        'Tag','SetFrSep',...
        'Style','Frame');
end
pos=pos-gh;

%======================================== OTHER ========================================

% ------------------- testplot ---------------------
function testplot
global Metset

Testplot=findobj(gcf,'Tag','Testplot'); delete(Testplot)

h=subplot('Position',[0.9 0.4 0.05 0.5]);

spacing=Metset.contour_spacing;

ncol=100; lower=-1; higher=2;

X_cont=repmat([0 1],ncol,1);
y=linspace(lower*spacing*10,higher*spacing*10,ncol)';
Y_cont=repmat(y,1,2); 
Z_cont=Y_cont;

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; 
end
lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

if Metset.contour_isolines linestr='-'; else linestr='none'; end
try
    [C,d] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr); % For newer Matlab versions    
catch
    [C,d] = contourf(X_cont,Y_cont,Z_cont,v);   
    set(d,'LineStyle',linestr); 
end
    
if Metset.contour_labels clabel(C,d); end

if Metset.contour_centercol
    cm=[min(v) max(v)]; set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

set(gcf,'Colormap',oo_getcmap);
set(h,'XTickLabel',[])
set(gca,'Tag','Testplot')

oo_copyfigure


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global fonts Pos Colors Metset Locset
%disp('---- OPENWIN ----')

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;
buw=bw*1.3;

winpar{1}='SetWin'; winpar{2}='Chrombox O: Settings';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% FRAME

%p=p+1;[ui{p,1:7}] = deal(['Current Method: ' Metset.file_method],'Text',Colors.bc,[x(1) y(2) bw*4 bh],'',3,'CurrMethTxt');
%p=p+1;[ui{p,1:7}] = deal('','Frame',Colors.bc,[x(1) y(18) bw*9 y(2)-y(18)],'',2,'');
% CLOSE
p=p+1;[ui{p,1:7}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_setz; oo_closewin',3,'');
% Load/Save Method
%vp=y(20)+bh/2;
p=p+1;[ui{p,1:7}] = deal('Load Meth.','Pushbutton',Colors.btn{6},[x(3) y(1) bw bh],'oo_settings(3.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Save Meth.','Pushbutton',Colors.btn{6},[x(6) y(1) bw bh],'oo_settings(3.1)',2,'');

p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(7) y(1) bw*1.5 bh],'',2,'CurrentMethEdit');
p=p+1;[ui{p,1:7}] = deal('-','Popupmenu',[1 1 1],[x(4) y(1) bw*1.5 bh],'',2,'MethsPop');

% Togglebuttons
vp=1-bh*2;
o=0;   p=p+1;[ui{p,1:7}] = deal('General','Togglebutton',Colors.btn{3},[x(1)+o*buw vp buw bh],'oo_settings(1.1)',2,'WinToggle');
o=o+1; p=p+1;[ui{p,1:7}] = deal('Directories','Togglebutton',Colors.btn{3},[x(1)+o*buw vp buw bh],'oo_settings(1.1)',2,'WinToggle');
o=o+1; p=p+1;[ui{p,1:7}] = deal('Reports','Togglebutton',Colors.btn{3},[x(1)+o*buw vp buw bh],'oo_settings(1.1)',2,'WinToggle');
o=o+1; p=p+1;[ui{p,1:7}] = deal('Plots','Togglebutton',Colors.btn{3},[x(1)+o*buw vp buw bh],'oo_settings(1.1)',2,'WinToggle');

updfcn='oo_settings(100)';
h0=oo_drawwin(winpar,ui,updfcn); 

SettingsBtn=findobj(gcf,'Tag','SettingsBtn'); set(SettingsBtn,'Enable','off');


%h=findobj('Tag','MethTxt'); set(h,'HorizontalAlignment','Right')
%h=findobj('Style','PopupMenu'); set(h,'FontName','FixedWidth','FontWeight','Normal')

