function zz_message(an,varargin)

% zz_message(call,'String','options')
% SAM 140705
%
% External calls:
%
% call==0 create messageline
% call==1 display message on messageline
% call==2 clear messageline
% call==3 display log
% call==4 clear log
% call==6 opens file 
% call==7 popupmessage 
%
% Internal calls:
% call==10.1 prev message
% call==10.3 display info
% call==11.1 Opens last exported file
% call==11.2 Opens last folder of file
%
% Required fields in Zset:
% path_root
% path_export
% call_info
% call_settings
% fonts
%
% Options:
% '-r','-g', '-b': Text color (black if none)
% '-l' add to log
% '-nd' nodisplay (do not show at messageline)
%
% use -- as separators in logs

global  Zset  MessageLog

%if Zset.tracker disp(['--- zz_message ---' num2str(an)]); end

if numel(varargin)>0 
    messagetxt=varargin{1};
end
if numel(varargin)>1
    options=varargin{2};
else
    options='';
end

% ---------- EXTERNAL CALLS -----------  

% Legger inn linje
if an==0 drawbox; end

% Message to screen and log
if an==1
    
    % display
    %strtest=strfind(options,'-nd')
    if isempty(strfind(options,'-nd'))
        typemess(messagetxt,options,0)
    end
    
    % add to log
    if strfind(options,'-l')
        if isempty(MessageLog) || ~isstruct(MessageLog)
            MessageLog=[];
            MessageLog.text=cell(0);
            MessageLog.time=[];
            MessageLog.options=cell(0);
        end
        nmess=numel(MessageLog.time);
        MessageLog.text{nmess+1}=messagetxt;
        MessageLog.time(nmess+1)=now;
        MessageLog.options{nmess+1}=options;        
        
        if nmess>10
            MessageLog.text(1)=[]; MessageLog.time(1)=[]; MessageLog.options(1)=[];
        end
    end
end

% Clear messageline
if an==2
    h=findobj('Tag','MessageTxt');
    set(h,'String',' ');
end
    
% Display log (popup)
if an==3 && isstruct(MessageLog) && numel(MessageLog.text)>0

    for x=1:numel(MessageLog.text)
        msg=MessageLog.text{x}; 
        logstr{x}=[datestr(MessageLog.time(x),13) ': ' msg];
    end

    % Make Popup
    wh=findobj('Tag','MessLogWin','Type','Figure');
    
    if isempty(wh)
    
        defpos=get(gcbf,'Position');
        ww=defpos(3)*0.3; wh=defpos(4)*0.3;
        lp=defpos(1)+defpos(3)/2-ww/2;
        hp=defpos(2)+defpos(4)/2-wh/2;
        winpos=[lp hp ww wh];    
        bccol=get(gcbf,'Color');

        wh = figure('Color',bccol, ...
            'Units','normalized',...
            'Position',winpos, ...
    	    'Tag','MessLogWin', ...
            'Name','Message log',...
            'NumberTitle','off',...
            'Handlevisibility','on',...
            'Menubar','none',...
            'ToolBar','none',...
            'DefaultUicontrolUnits','normalized');

        h1 = uicontrol('Parent',wh, ...
            'BackgroundColor',[1 1 1], ...
	        'Position',[0 0 1 1], ...
            'Style','ListBox',...
            'HorizontalAlignment','left',...
            'Tag','MessTextBox',...
            'FontName','FixedWidth',...
            'FontSize',Zset.fonts(2));
    end
    
    MessTextBox=findobj(wh,'Tag','MessTextBox');
    set(MessTextBox,'String',logstr);
    figure(wh); % Bring window to front
    % set(wh,'WindowStyle','modal'); set(wh,'WindowStyle','normal'); % Alternative

end

% Clear log
if an==4
    MessageLog=[];
    MessageLog.text=cell(0);
    MessageLog.time=[];
    MessageLog.options=cell(0);
    wh=findobj('Tag','MessLogWin','Type','Figure'); close(wh);
    zz_message(1,'Cleared log')
end

% Opens a file
if an==6
    showfile(messagetxt); % Opens file with path messagetext
end


% ---------- INTERNAL CALLS ----------

% disp old messages
if an==10.1
    typemess('','',1) % Display message from stack
end

% info
if an==10.3
    eval(Zset.call_info) 
end

% opens last file
if an==11.1 && isfield(Zset,'lastexport') && ~isempty(Zset.lastexport)   
    if exist(Zset.lastexport)==2
        if ispc
            try
                winopen(Zset.lastexport)
            catch
                zz_message(1,['Could not open ' Zset.lastexport],'-r')
            end
        end
        if isunix
            try
                system(['xdg-open "' Zset.lastexport '"'])
            catch
                zz_message(1,['Could not open ' Zset.lastexport],'-r')
            end
        end
    end
end

% opens folder of last file
if an==11.2 && isfield(Zset,'lastexport') && ~isempty(Zset.lastexport)       
    [fpath,fname,fext]=fileparts(Zset.lastexport);
    if ispc && isdir(fpath)
        try
            winopen(fpath)
            
        catch
            zz_message(1,['Could not open folder' fpath],'-r')
            
        end
    end
    if isunix && isdir(fpath)
        try
            system(['xdg-open "' fpath '"'])
        catch
            zz_message(1,['Could not open ' fpath],'-r')
        end
    end
end

% popup message
if an==7
    defpos=get(gcbf,'Position');
    ww=defpos(3)*0.3; wh=defpos(4)*0.3;
    lp=defpos(1)+defpos(3)/2-ww/2;
    hp=defpos(2)+defpos(4)/2-wh/2;
    winpos=[lp hp ww wh];
    bccol=get(gcbf,'Color');

    wh = figure('Color',bccol, ...
        'Units','normalized',...
        'Position',winpos, ...
	    'Tag','MessPop', ...
        'Name','Message',...
        'NumberTitle','off',...
        'Handlevisibility','on',...
        'Menubar','none',...
        'ToolBar','none',...
        'DefaultUicontrolUnits','normalized');
  
    h1 = uicontrol('Parent',wh, ...
        'BackgroundColor',[1 1 1], ...
	    'Position',[0 0 1 1], ...
        'Style','ListBox',...
        'HorizontalAlignment','left',...
	    'String',messagetxt,...
        'Tag','MessTextBox',...
        'FontName','FixedWidth',...
        'FontSize',Zset.fonts(2));
end
    



% ----------------------------------------------------------
% ----------------------- SUBFUNCTIONS ---------------------
% ----------------------------------------------------------

function typemess(textstr,options,an)
persistent Mstack messno

tstr=[]; mopt=[];

if an==0
    tstr=textstr;
    mopt=options;
    
    ind=numel(Mstack)+1;
    
    % Saves displaid messages
    Mstack(ind).text=tstr;
    Mstack(ind).options=mopt;
    Mstack(ind).time=now;   
    messno=0;
    % Save max 11 messages
    if numel(Mstack)>11 Mstack(1:numel(Mstack)-11)=[]; end
end

% Display old messages
if an==1
    messno=messno+1;
    if messno>numel(Mstack)-1 messno=0; end
    if numel(Mstack)>1 
        tstr=['[' num2str(-messno) '] ' Mstack(numel(Mstack)-messno).text];
        mopt=Mstack(numel(Mstack)-messno).options;
    end
end

% Output to messageline
h=findobj('Tag','MessageTxt');
if ~isempty(tstr)
    set(h,'HorizontalAlignment','Center');
    set(h,'ForegroundColor',[0 0 0])
    if strfind(mopt,'-r') set(h,'ForegroundColor',[1 0 0]); end
    if strfind(mopt,'-g') set(h,'ForegroundColor',[0 0.5 0]); end
    if strfind(mopt,'-b') set(h,'ForegroundColor',[0 0 1]); end
    set(h,'String',tstr); 
else
    set(h,'String',''); 
end

% ---------------- SHOWFILE ------------- Obsolete?
function showfile(messagetxt)

%global Locset
%if isfield(Locset,'editor')==0 Locset.editor='default'; end

if ispc
    try 
        winopen(messagetxt)
    catch
        zz_message(1,'Could not open file','-r')
    end
end
if isunix
    try 
        system(['xdg-open "' messagetxt '"'])
    catch
        zz_message(1,'Could not open file','r')
    end
end



% ---------------- TEGNER LINJE -------------
function drawbox

global Zset

%hp=0; % Vertikal posisjon til messageline
%hp=0.025; % Vertikal posisjon til messageline

% ---- Message line ----

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[1 0 0],...
    'BackgroundColor',[1 1 1],...
    'Position',[0.125 0 0.725 0.03], ...
	'String',' ', ...
    'FontSize',Zset.fonts(3),...
	'Style','text', ...
    'Tag','MessageTxt');

% ---- Left side buttons ----

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(10.3)', ...
	'Position',[0 0 0.025 0.03], ...
	'String','i');

cbf=['winopen(''', Zset.path_root filesep 'Notes.txt'');'];
if isunix
    cbf=['system(''xdg-open "' Zset.path_root filesep 'Notes.txt"'');'];
end
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[0.025 0 0.025 0.03], ...
	'String','N');

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...    
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(3)', ...
	'Position',[0.05 0 0.025 0.03], ...
	'String','Log');

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(4)', ...
	'Position',[0.075 0 0.025 0.03], ...
	'String','CL');

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(10.1)', ...
	'Position',[0.1 0 0.025 0.03], ...
	'String','>>');

% ----------- RIGHT SIDE --------------

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',Zset.call_settings, ...
	'Position',[1-0.05 0 0.050 0.03], ...
	'String','Settings',...
    'Tag','SettingsBtn');

% Free modal windows
cbf='set(findobj(''Type'',''Figure''),''Visible'',''on'');set(findobj(''Type'',''Figure''),''WindowStyle'',''normal'');';
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[1-0.075 0 0.025 0.03], ...
	'String','FW');

% Open explorer
cbf=['winopen(''' Zset.path_root ''');'];
if isunix
    cbf=['system(''xdg-open "' Zset.path_root '"'');'];
end
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[1-0.1 0 0.025 0.03], ...
	'String','OR');

% open folder of last exported file
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(11.2)', ...
	'Position',[1-0.125 0 0.025 0.03], ...
	'String','OD');

% open last exported file
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(11.1)', ...
	'Position',[1-0.150 0 0.025 0.03], ...
	'String','OF');

