function zz_report_clip(Reportstruct,varargin)
% Function for sending reportstruct to clipboard
% varargin is used as dummy to ensure compliance with other reports that
% has an 'openfile' variable as second input
% SAM 140607

linefeed=char([13 10]);
tn=1; 
cstr={};lno=0;

% ------------- Writes header -------------
if isfield(Reportstruct,'header')
    for x=1:length(Reportstruct(tn).header)
        lno=lno+1;
        cstr{lno,1}=Reportstruct(tn).header{x};
    end
end
        
% ------------- Writes cells -------------
[n_columns,n_rows]=size(Reportstruct(tn).cells);
[dummy,n_headers]=size(Reportstruct(tn).columntitle);
U=[]; typestr=[]; 
for x=1:n_columns
    for hn=1:n_headers
        cstr{lno+hn,x}=[Reportstruct(tn).columntitle{x,hn}];
    end
    sline=lno+n_headers;
    for y=1:n_rows
        
        if strcmp(Reportstruct(tn).format{x,y},'str')
            cstr{sline+y,x}=[Reportstruct(tn).cells{x,y}];
        else
            cstr{sline+y,x}=[num2str(Reportstruct(tn).cells{x,y},Reportstruct(tn).format{x,y})];
        end
    end
end       

% ------------- Writes footer -------------
if isfield(Reportstruct,'footer')
    [nrow,ncol]=size(cstr); 
    for x=1:length(Reportstruct(tn).footer)
        cstr{nrow+x,1}=[Reportstruct(tn).footer{x},linefeed];
    end
end

% ------------- Formats and copies -------------
if ~isempty(cstr)
    [nrow,ncol]=size(cstr);
    ostr=[];
    for rn=1:nrow
        for cn=1:ncol
            ostr=[ostr cstr{rn,cn} char(9)]; 
        end
        ostr(end)=[]; ostr=[ostr linefeed];
    end
    clipboard('copy', ostr)
end















