function zz_report_csv(Reportstruct,openfile)

global  Zset

if nargin<2 openfile=0; end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.csv'],'w');

if fh==-1; 
    zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r'); 
else
    for tn=1:length(Reportstruct)

        % ------------- Writes header -------------
        if isfield(Reportstruct,'header')
            for x=1:length(Reportstruct(tn).header)
                fprintf(fh,[Reportstruct(tn).header{x},linefeed]);
            end
        end
        
        % ------------- convert to typstr -------------
        [n_columns,n_rows]=size(Reportstruct(tn).cells);
        [dummy,n_headers]=size(Reportstruct(tn).columntitle);
        typestr=[]; ln=0;
        
        for hno=1:n_headers
            ln=ln+1; typestr{ln}=[];
            for cno=1:n_columns
                typestr{ln}=[typestr{ln} Reportstruct(tn).columntitle{cno,hno} ';'];
            end
        end
        for rno=1:n_rows
            ln=ln+1; typestr{ln}=[];
            for cno=1:n_columns
                if strcmpi(Reportstruct(tn).format{cno,rno},'str')
                    typestr{ln}=[typestr{ln} Reportstruct(tn).cells{cno,rno} ';'];       
                else
                    typestr{ln}=[typestr{ln} num2str(Reportstruct(tn).cells{cno,rno},Reportstruct(tn).format{cno,rno}) ';'];   
                end
            end
        end

        % Write fields
        for x=1:numel(typestr)
            if typestr{x}(end)==';' typestr{x}(end)=[]; end
            fprintf(fh,[typestr{x} linefeed]);
        end
               
        % Writes footer
        if isfield(Reportstruct,'footer')
            for x=1:length(Reportstruct(tn).footer)
                fprintf(fh,[Reportstruct(tn).footer{x},linefeed]);
            end
        end

    end % for tn

    zz_message(1,['Saved as: ' Reportstruct(1).pathname '.csv'],'-b')
    Zset.lastexport=[Reportstruct(1).pathname '.csv'];
    fclose(fh);

    % Opens
    if openfile && ispc
       try
           winopen([Reportstruct(1).pathname '.csv']);
       catch
           dd_message(1,'|r|Could not open file'); 
       end
    end
    
    if openfile && isunix
       try
           system(['xdg-open "' Reportstruct(1).pathname '.csv"']);
       catch
           zz_message(1,'Could not open file','-r'); 
       end
    end
       

end % if fid==-1











