function zz_report_dif(Reportstruct,openfile)

global  Zset

if nargin<2 openfile=0; end

linefeed=char([13 10]);

ostr{1,1}=''; lno=0; numvals(1,1)=false;

for tn=1:numel(Reportstruct)

    % ------------- header -------------
    if isfield(Reportstruct,'header')
        for x=1:length(Reportstruct(tn).header)
            lno=lno+1; 
            ostr{lno,1}=Reportstruct(tn).header{x};
        end
    end
    
    % ------------- column headers -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells);
    [d,n_headers]=size(Reportstruct(tn).columntitle);
    for hno=1:n_headers
        lno=lno+1;
        for cno=1:n_columns
            ostr{lno,cno}=Reportstruct(tn).columntitle{cno,hno};
        end
    end
      
    % ------------- cell contents -------------
    %numvals=repmat(false,lno+n_rows,n_columns);
    numvals=false(lno+n_rows,n_columns);
    for rno=1:n_rows
        lno=lno+1;
        for cno=1:n_columns
            if strcmpi(Reportstruct(tn).format{cno,rno},'str')
                ostr{lno,cno}=Reportstruct(tn).cells{cno,rno};
            else
                ostr{lno,cno}=num2str(Reportstruct(tn).cells{cno,rno},Reportstruct(tn).format{cno,rno});
                numvals(lno,cno)=true;
            end
        end
    end
        
    % ------------- footer -------------
    if isfield(Reportstruct,'footer')
        for x=1:length(Reportstruct(tn).footer)
            lno=lno+1; ostr{lno,1}=Reportstruct(tn).footer{x};
        end
    end
    
    % Add additional lines at end
    lno=lno+2; ostr{lno,1}=''; numvals(lno,1)=false;     
end % for tn

% Fill inn blanks
ostr(cellfun('isempty',ostr))={''};

[ntup,nvec]=size(ostr);

% ------------- Opens file -------------
fh=fopen([Reportstruct(1).pathname '.dif'],'w');

if fh==-1; 
    zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r'); 
else
    
    fprintf(fh,['TABLE',linefeed]);
    fprintf(fh,['0,1',linefeed]);
    fprintf(fh,['"CHROMBOX DIF"',linefeed]);
    fprintf(fh,['VECTORS',linefeed]);
    fprintf(fh,['0,' num2str(nvec) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['TUPLES',linefeed]);
    fprintf(fh,['0,' num2str(ntup) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['DATA',linefeed]);
    fprintf(fh,['0,0',linefeed]);
    fprintf(fh,['""',linefeed]);
      
    for tupno=1:ntup
        fprintf(fh,['-1,0',linefeed]);
        fprintf(fh,['BOT' linefeed]);       
        for vecno=1:nvec;
            if numvals(tupno,vecno)
                fprintf(fh,['0,' ostr{tupno,vecno} linefeed]); 
                fprintf(fh,['V' linefeed]); 
            else
                fprintf(fh,['1,0' linefeed]); 
                fprintf(fh,['"' ostr{tupno,vecno} '"' linefeed]); 
            end
            
        end
    end
    fprintf(fh,['-1,0',linefeed]);
    fprintf(fh,['EOD',linefeed]);
    
    zz_message(1,['Saved as: ' Reportstruct(1).pathname '.dif'],'-b')
    Zset.lastexport=[Reportstruct(1).pathname '.dif'];
    fclose(fh);

    % Opens
    if openfile && ispc
       try
           winopen([Reportstruct(1).pathname '.dif']);         
       catch
           zz_message(1,'Could not open file','-r'); 
       end
    end
    
    if openfile && isunix
       try
           system(['xdg-open "' Reportstruct(1).pathname '.dif"']);
       catch
           zz_message(1,'Could not open file','-r'); 
       end
    end
       
end % if fid==-1











