function zz_report_slk(Reportstruct,openfile)

global  Zset

if nargin<2 openfile=0; end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.slk'],'w');

if fh==-1; 
    zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r'); 
else
    nl=0; % nlines;
    rno=0; % row number
    typestr=cell(0);
    nl=nl+1; typestr{nl}='ID;P'; % Identifier
    
    for tn=1:length(Reportstruct)

        % ------------- Writes header -------------
        if isfield(Reportstruct,'header')
            for x=1:length(Reportstruct(tn).header)
                nl=nl+1; rno=rno+1;
                typestr{nl}=['C;Y' num2str(rno) ';X1;K"' Reportstruct(tn).header{x} '"'];
            end
        end
        
        % ------------- convert to typstr -------------
        [n_columns,n_rows]=size(Reportstruct(tn).cells);
        [dummy,n_headers]=size(Reportstruct(tn).columntitle);
        
        for hno=1:n_headers
            rno=rno+1;
            for cno=1:n_columns
                nl=nl+1; 
                typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K"' Reportstruct(tn).columntitle{cno,hno} '"'];
            end
        end

        for x=1:n_rows
            rno=rno+1;
            for cno=1:n_columns
                if strcmpi(Reportstruct(tn).format{cno,x},'str')
                    nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K"'  Reportstruct(tn).cells{cno,x} '"']; 
                    
                else
                    nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K'  num2str(Reportstruct(tn).cells{cno,x},Reportstruct(tn).format{cno,x})]; 
                end
            end
        end
        
        % Writes footer
        if isfield(Reportstruct,'footer')
            for x=1:length(Reportstruct(tn).footer)
                rno=rno+1; nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X1;K"'  Reportstruct(tn).footer{x} '"']; 
            end
        end        

        nl=nl+1; typestr{nl}='E'; % End of file
          
        % Write to file
        for x=1:numel(typestr)
            fprintf(fh,[typestr{x} linefeed]);
        end

    end % for tn

    zz_message(1,['Saved as: ' Reportstruct(1).pathname '.slk'],'-b')
    Zset.lastexport=[Reportstruct(1).pathname '.slk'];
    fclose(fh);

    % Opens
    if openfile && ispc
       try
           winopen([Reportstruct(1).pathname '.slk']);
       catch
           dd_message(1,'|r|Could not open file'); 
       end
    end
    
    if openfile && isunix
       try
           system(['xdg-open "' Reportstruct(1).pathname '.slk"']);
       catch
           zz_message(1,'Could not open file','-r'); 
       end
    end
       

end % if fid==-1











