function zz_report_xls_single(Reportstruct,aopen)

global  Zset

if isunix zz_message(1,'Excel export is not supported by current Matlab version','-r'); return; end

% deletes old file
if exist([Reportstruct(1).pathname '.xls'])==2
    delete([Reportstruct(1).pathname '.xls'])
end

lno=0;
for tn=1:length(Reportstruct)

    % ------------- Writes header -------------
    if isfield(Reportstruct,'header')
        for x=1:length(Reportstruct(tn).header)
            lno=lno+1;
            Outstr{lno,1}=[' ' Reportstruct(tn).header{x}];
        end
    end
        
    % ------------- convert to typstr -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells);
    [dummy,n_headerlines]=size(Reportstruct(tn).columntitle);
    U=[]; typestr=[];

    for hn=1:n_headerlines
        lno=lno+1; 
        for cn=1:n_columns
            Outstr{lno,cn}=[' ' Reportstruct(tn).columntitle{cn,hn}];
        end
    end
    
    for rn=1:n_rows
        lno=lno+1;
        for cn=1:n_columns
            if strcmp(Reportstruct(tn).format{cn,rn},'str')
                Outstr{lno,cn}=[' ' Reportstruct(tn).cells{cn,rn}];
            else
                Outstr{lno,cn}=Reportstruct(tn).cells{cn,rn};
                if isnan(Reportstruct(tn).cells{cn,rn})
                    Outstr{lno,cn}='NaN'; 
                end                    
            end
        end
    end
    
    if isfield(Reportstruct,'footer')
        for x=1:length(Reportstruct(tn).footer)
            lno=lno+1;
            Outstr{lno,1}=Reportstruct(tn).footer{x};
        end    
    end

end % for tn


pathname=[Reportstruct(1).pathname '.xls'];
try
    xlswrite(pathname,Outstr)
    Zset.lastexport=pathname;
    zz_message(1,['Saved as: ' pathname],'-b')
    if aopen && ispc
        try
            winopen(pathname);
        catch
            zz_message(1,'Could not open file','-r')      
        end
    end
    if aopen && isunix
        try
            system(['xdg-open "' pathname '"']);
        catch
            zz_message(1,'|r|Could not open file','-r')      
        end
    end
             
catch
    zz_message(1,'XLS write failed. File may be open, folder non-existent, or xls write may not be supported by current Matlab version (try dif-export)','-r')
end





