function oo_designplot2(Design)
% function oo_designplot2(Design)
% ver 230207 SAM
% global Metset Colors Pos
%

global Metset Colors Pos

%disp('--- oo_designplot2 ---')

% set matrix and domain
if Metset.plot_instrumentparameters
    matrix=Design.parameters;    
    domain=Design.parametersdomain;
else
    matrix=Design.codes; 
    domain=Design.codesdomain;    
end
colormatrix=Design.colormatrix;

ranges = max(domain,[],1) - min(domain,[],1);
means=mean(domain,1);
miny=-1; maxy=1; minz=-1; maxz=1; % defaults

if ranges(1)==0
    minx=means(1)-1; maxx=means(1)+1;
else
    minx=min(domain(:,1)); maxx=max(domain(:,1));   
end

[n_obj,n_param]=size(matrix); 
if n_param==2
    if ranges(2)==0
        miny=means(2)-1; maxy=means(2)+1;
    else
        miny=min(domain(:,2)); maxy=max(domain(:,2));
    end
end

freefactor=0.05; % offset for axes.
rangex=(maxx-minx); xoff=rangex*freefactor; limx=[minx-xoff maxx+xoff];
rangey=(maxy-miny); yoff=rangey*freefactor; limy=[miny-yoff maxy+yoff];
rangez=(maxz-minz); zoff=rangez*freefactor; limz=[minz-zoff maxz+zoff];


plotcenter=[(maxx+minx)/2 (maxy+miny)/2];

% Creates plot
existingplot=findobj(gcf,'Position',Pos.rightplot); delete(existingplot)
axesh=subplot('Position',Pos.rightplot); %,'XTick',[-1 0 1],'YTick',[-1 0 1],'ZTick',[-1 0 1]);
set(axesh,'XTick',[-1 0 1],'YTick',[-1 0 1],'ZTick',[-1 0 1])

% Adds spheres
%[m,n]=size(matrix); 
matrix=[matrix zeros(n_obj,3-n_param)]; % Expands to three dimensions
[XM,YM,ZM]=sphere(20); 
sizex=rangex/40; sizey=rangey/40; sizez=rangez/40; 
for x=1:n_obj
    XP=XM*sizex; YP=YM*sizey; ZP=ZM*sizez; % Skalering
    XP=XP+matrix(x,1); YP=YP+matrix(x,2); ZP=ZP+matrix(x,3);  
    h=surf(XP,YP,ZP,'EdgeColor','none','FaceColor',[colormatrix(x,1) colormatrix(x,2) colormatrix(x,3)],'Ambientstrength',0.5);
    %set(h,'FaceLightning','phong','FaceColor','interp','Ambientstrength','0.5')  
    hold on   
end
set(gca,'GridLineStyle','none')
camlight right
lighting phong
material shiny
view(2)

% Outer box and background surface
if Metset.plot_drawbox==1  
    % Background surface
    fa=0.1; ek=[0.5 0.5 0.5]; fc=[0.8 0.8 0.8];
    fill3([minx maxx maxx minx],[miny miny maxy maxy],[minz minz minz minz],fc,'EdgeColor',ek,'FaceAlpha',fa');

end

% --------- LINES -----------

% lines for star
starmatrix=matrix(ismember(colormatrix,Colors.star,'rows'),:);
if ~isempty(starmatrix) && Metset.plot_drawlines
    cms=sum(colormatrix,2); ind=find(cms==sum(Colors.star)); le=length(ind);
    for x=1:le
        pos=matrix(ind(x),:);
        line([plotcenter(1),pos(1)],[plotcenter(2),pos(2)],'Color',Colors.star,'LineWidth',2)
    end
end

% Lines for factorial
factorialmatrix=matrix(ismember(colormatrix,Colors.factorial,'rows'),:);
if ~isempty(factorialmatrix) && Metset.plot_drawlines
    fminx=min(factorialmatrix(:,1)); fmaxx=max(factorialmatrix(:,1)); 
    fminy=min(factorialmatrix(:,2)); fmaxy=max(factorialmatrix(:,2));
    fa=0.1; ek=Colors.factorial; 
    patch([fminx fmaxx fmaxx fminx],[fminy fminy fmaxy fmaxy],[0.9 0.8 0.8],'LineWidth',2,'EdgeColor',ek,'FaceColor','none','FaceAlpha',fa');
end

% Lines for Doehlert
% Doerhlertlines; Line from each point to four nearest neighbours
dmatrix=matrix(ismember(colormatrix,Colors.doehlert,'rows'),:);
if ~isempty(dmatrix) && Metset.plot_drawlines
    % calculates normalized matrix
    normmatrix(:,1)=dmatrix(:,1)-plotcenter(1); normmatrix(:,2)=dmatrix(:,2)-plotcenter(2); 
    normmatrix(:,1)=normmatrix(:,1)/(rangex/2); normmatrix(:,2)=normmatrix(:,2)/(rangey/2);
    [m,n]=size(dmatrix);
    % finds neighbours (in normalized matrix) and draws lines (using
    % original matrix)
    for x=1:m
        for y=1:m dist(y)=sum((normmatrix(x,:)-normmatrix(y,:)).^2)^0.5; end
        i4=find(dist==min(dist)); dist(i4)=1000; [sd,i5]=sort(dist);
        for z=1:2
            line([dmatrix(x,1) dmatrix(i5(z),1)],[dmatrix(x,2) dmatrix(i5(z),2)],'LineWidth',2,'Color',Colors.doehlert);          
        end
    end
end

set(gca,'FontSize',14); 
set(gca,'Xlim',limx,'Ylim',limy,'Zlim',limz)
set(gca,'XTick',[minx; plotcenter(1); maxx],'YTick',[miny; plotcenter(2); maxy]) 

set(gca,'Tag','Designplot2')
zz_copyfigure





