function oo_model(call)
% function oo_model(call)
% ver 2300607 SAM
% global Metset Experimental Locset Modset Models

global Metset Experimental Locset Modset Models
%global status

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0 
    Experimental=[];
    Models=[];
    Modset.listtype=1; % Data
    Modset.codetype=1; % Codes  
    openwin
    getexperiments
    getmodels
    boxlist
    datalist
end

if call==1.1
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' strs{val} '.mat' ];
    load(pathname,'Experimental')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',strs{val})
    Experimental.activecmp(1:numel(Experimental.codes))=deal(false);
    Experimental.activeexp(1:numel(Experimental.expname))=deal(true);
    Models=[];
    parameterslist
    boxlist
    listupdate  
end


% Change parameter
if call==3.3
    listupdate
end

% Model
if call==4.1
    %disp('--- model ---')
    calcmodels
    Modset.listtype=2;
    listupdate
end
if call==4.2
    %disp('--- model ---')
    calctargetmodels
    Modset.listtype=3;
    listupdate
end

% Surface plots
if call==5.1
    %disp('--- surface ---')
    surfaceplot2
end
if call==5.2
    %disp('--- ind surface ---')
    indcontour
end

% surftype radios
if call==6.1
    tag=get(gcbo,'Tag');
    radios=findobj(gcf,'Tag',tag); set(radios,'Value',0)
    set(gcbo,'Value',1)
end

if call==7.1
    listupdate
end

if call==8.1
    %disp('--- save model ---')
    if isempty(Models)
        zz_message(1,'No models to save','-r')
    else
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        filename=get(FileNameEdit,'String');
        if isempty(filename)
            zz_message(1,'Select file name','-r')
        else
            Info.modeltype='2D';
            Info.savedtime=now;
            Info.user=Locset.user;
            Info.codeversion=Locset.version;
            pathname=[ Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
            oo_savefile(pathname,Models,Experimental,Modset,Info)
        end    
    end   
end

if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
    S=load(pathname);
    if (~isfield(S,'Info')) || (isfield(S,'Info') && strcmp(S.Info.modeltype,'2D'))
        Models=S.Models;
        Experimental=S.Experimental;
        Modset=S.Modset;
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        set(FileNameEdit,'String',filename)
        parameterslist
        boxlist
        listupdate  
    else
        if isfield(S,'Info') str=[' (' S.Info.modeltype ')']; else str=''; end
        zz_message(1,['Incorrect model type ' str],'-r')
    end      
end

% graphical selection, contour plot
if call==9.1
    %disp('--- graphical selection ----')
    [cp]=get(gca,'CurrentPoint'); xp=cp(1,1); yp=cp(1,2);
    checkpoint(xp,yp)
end
% individual trace info
if call==9.2
    %disp('--- individualinfo ---')
    %get(gcbo)
    userdat=get(gcbo,'UserData');
    str{1}=Experimental.codes{userdat(1)}; str{2}=Experimental.names{userdat(1)}; str{3}=Experimental.shortnames{userdat(1)};
    InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String',str,'Value',1)
end
if call==9.3
    %disp('--- selected point ---')
    xp=get(gcbo,'XData'); 
    xp=xp(1); 
    yp=get(gcbo,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end
if call==9.35
    %disp('--- selected point ---')
    xp=get(gco,'XData');
    xp=xp(1); 
    yp=get(gco,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end

% Input from edit
if call==9.4
    SelXEdit=findobj(gcf,'Tag','SelXEdit');
    xval=str2double(get(SelXEdit,'String'));
    set(SelXEdit,'String',num2str(xval));
    
    SelYEdit=findobj(gcf,'Tag','SelYEdit');
    yval=str2double(get(SelYEdit,'String'));
    set(SelYEdit,'String',num2str(yval));    
    
    if ~isnan(xval) && ~isnan(yval)
        checkpoint(xval,yval)
    end  
end

if call==9.5
    maha=findobj(gca,'Tag','SelectionMarker');
    if get(gcbo,'Value') set(maha,'Visible','on'); else set(maha,'Visible','off'); end
end

% set scale
if call==10.1
    str=get(gcbo,'String'); val=str2double(str); 
    if ~(~isnan(val) && val>=0); str='10'; end
    set(gcbo,'String',str)   
end

% minT/MaxT check
if call==11.1
    MinTCheck=findobj(gcf,'Tag','MinTCheck');
    MaxTCheck=findobj(gcf,'Tag','MaxTCheck');
    if gcbo==MinTCheck && get(gcbo,'Value')==1
        set(MaxTCheck,'Value',0)
    end
    if gcbo==MaxTCheck && get(gcbo,'Value')==1
        set(MinTCheck,'Value',0)
    end       
end

% EVALUATE LISTS
if call==12.1 evalboxlist; end
if call==12.2 evaldatalist; end    
if call==12.3 evalmodelslist; end 

% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end
if call==99.1 % Exit
    %h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    %h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat'];
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end

%Models
%Models.ri_exp % TEMP
%Models.rt_exp % TEMP
%Models.rt_exp_str{1} % TEMP
% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

function listupdate
global Modset Models Experimental

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

callertag=get(gcbo,'Tag');

if strcmp(callertag,'CodeRadio')
    codestr=get(gcbo,'String');
    if strcmp(codestr,'Code')
        Modset.codetype=1;
    end
    if strcmp(codestr,'Name')
        Modset.codetype=2;
    end    
    if strcmp(codestr,'Short name')
        Modset.codetype=3;
    end        
end

if strcmp(callertag,'ListTypeRadio')
    liststr=get(gcbo,'String'); 
    if strcmp(liststr,'Show data')
    Modset.listtype=1;
    end
    if strcmp(liststr,'Abs. models')
       Modset.listtype=2;
    end    
    if strcmp(liststr,'Target mod.')
        Modset.listtype=3;
    end   
end

% set code types
if Modset.codetype==1;
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Modset.codetype==2;
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Modset.codetype==3;
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

if isempty(Models) Modset.listtype=1; end 
if isempty(Experimental) Modset.listtype=0; end 

if Modset.listtype~=1 && zz_tabletool('Exist','DataTable')
    zz_tabletool('Delete','DataTable');
end
if Modset.listtype==1 && zz_tabletool('Exist','ModelsTable')
    zz_tabletool('Delete','DataTable');
end


% set list types
if Modset.listtype==0 datalist; end

if Modset.listtype==1;
    h=findobj(ListTypeRadio,'String','Show data');
    set(h,'Value',1)
    datalist
end
if Modset.listtype==2;
    h=findobj(ListTypeRadio,'String','Abs. models');
    set(h,'Value',1)
    modelslist
end
if Modset.listtype==3;
    h=findobj(ListTypeRadio,'String','Target mod.');
    set(h,'Value',1)
    modelslist
end


% ------------------- indcontour ---------------------
function indcontour
global Models Experimental Pos Modset

selcmp=find(Experimental.activecmp);

varname=getvarname;
if Modset.listtype==3
    varname=[varname '_tg'];
end

if Modset.codetype==1 cmpid=Experimental.codes; end
if Modset.codetype==2 cmpid=Experimental.names; end
if Modset.codetype==3 cmpid=Experimental.shortnames; end

AbsCheck=findobj(gcf,'Tag','AbsCheck');
absolutevalues=get(AbsCheck,'Value');

MinThreshEdit=findobj(gcf,'Tag','MinThreshEdit');
minthresh=str2double(get(MinThreshEdit,'String'));
MaxThreshEdit=findobj(gcf,'Tag','MaxThreshEdit');
maxthresh=str2double(get(MaxThreshEdit,'String'));

if isfield(Models,varname)
    l_models=length(Models.(varname));
else
    zz_message(1,'|r|No models','-r')
    return
end

surfcolors=[0 0 1; 0 1 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75];
surfcolors=surfcolors(1:7,:); [n_colors,n]=size(surfcolors); colorno=0; 
missingmodels=[]; missingtargets=[]; validtarget=1; n_valids=0; ZM=[]; 

ph=subplot('Position',Pos.rightplot);
childs=get(ph,'Children');
delete(childs)

plotstatus=[];
vtextpos=1;
for x=1:length(selcmp)
    plotstatus(x)=0; % Sets plotstatus
    
    cmp=selcmp(x);
    colorno=colorno+1; if colorno>n_colors; colorno=1; surfcolors=surfcolors*0.75; end
    %disp(['--- file no ' num2str(cmp) ' ---'])
    if cmp<=l_models
        coeff=Models.(varname){cmp};
    else
        coeff=[]; 
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        %disp('--- passed ---')
        validmodel=1;
        [X_cont,Y_cont,Z_cont]=calcsurf(coeff);
    else
        %disp('---- missing model ---')
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end
    % Check target
    if strcmp(get(gcbo,'Tag'),'TargetSurfBtn'); 
        %disp('---- target surface ---')
        %TargetPop=findobj(gcf,'Tag','TargetPop');
        %targetfile=get(TargetPop,'Value');
        
        targetfile=find(cell2mat(zz_tabletool('getcol','BoxTable',3)));
        
        targetval=Experimental.(varname)(cmp,targetfile);
        if isnan(targetval)
            validtarget=0;
            missingtargets=[missingtargets cmp];
        else
            validtarget=1;        
        end   
        if validmodel && validtarget
            Z_cont=Z_cont-targetval;
        end          
    end
    
    if validmodel && validtarget
        %disp(['--- draws ' num2str(cmp) ' ---'])
        if absolutevalues Z_cont=abs(Z_cont); end   
                
        min_z=min(min(Z_cont));
        max_z=max(max(Z_cont));
        
        % Contour    
        if ~isnan(minthresh) && isnan(maxthresh) 
            %ZM=Z_cont*-1; %thresh=minthresh*-1;    
            [C,h]=contourf(X_cont,Y_cont,Z_cont*-1,[-minthresh max(max(Z_cont*-1))+1]);

            if ~isempty(h)

                if strcmpi(get(h(1),'Type'),'hggroup') h=get(h,'Children'); end %'hggroup' returned from some Matlab versions  

                set(h,'FaceColor',surfcolors(colorno,:),'UserData',[cmp min_z max_z],...
                    'LineWidth',2,'EdgeColor',surfcolors(colorno,:)*0.75,...
                    'ButtonDownFcn','oo_model(9.2)','HitTest','on')

                try
                    set(h,'FaceAlpha',0.25); % FaceAlphafails on some Matlab versions
                catch
                end
           
                Modset.plottype=3; % Ind. contour
                
                hold on
            
                if minthresh>min_z plotstatus(x)=1; end
            end
            

        end
        
        if ~isnan(maxthresh) && isnan(minthresh)  
            [C,h]=contourf(X_cont,Y_cont,Z_cont,[maxthresh max(max(Z_cont))+1]);
            if ~isempty(h)
                if strcmpi(get(h(1),'Type'),'hggroup') h=get(h,'Children'); end %'hggroup' returned from newer Matlab versions
                set(h,'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],...
                    'LineWidth',2,'EdgeColor',surfcolors(colorno,:)*0.75,...
                    'ButtonDownFcn','oo_model(9.2)','HitTest','on')
                Modset.plottype=3; % Ind. contour
                hold on
            
                if max_z>maxthresh plotstatus(x)=1; end
            end
            
        end  
        
        % If both min and max threshold is set
        if ~isnan(maxthresh) && ~isnan(minthresh)  
            meanthresh=mean([maxthresh minthresh])
            dlim=(max([maxthresh minthresh])-min([maxthresh minthresh]))/2
            Z_cont=Z_cont-meanthresh; Z_cont=abs(Z_cont); Z_cont=-Z_cont;
            
            [C,h]=contourf(X_cont,Y_cont,Z_cont,[-dlim 1]);
            if ~isempty(h)
                if strcmpi(get(h(1),'Type'),'hggroup') h=get(h,'Children'); end %'hggroup' returned from newer Matlab versions
                set(h,'FaceColor',surfcolors(colorno,:),'FaceAlpha',0.25,'UserData',[cmp min_z max_z],...
                    'LineWidth',2,'EdgeColor',surfcolors(colorno,:)*0.75,...
                    'ButtonDownFcn','oo_model(9.2)','HitTest','on')
                Modset.plottype=3; % Ind. contour
                plotstatus(x)=1
                hold on
            end            
        end
        
        % Adds text
        vtextpos=vtextpos-0.05; str=cmpid{cmp}; 
        if plotstatus(x)==0 str=[str '*']; end  
        th=text(0.97,vtextpos,str,'Units','Normalized','HorizontalAlignment','right',...
            'LineWidth',1,'EdgeColor',surfcolors(colorno,:)*0.75,'Color',surfcolors(colorno,:)*0.75,'FontWeight','Bold');

    end
end

[m,n_points]=size(Experimental.parameters);
hold on
for x=1:n_points
    plot(Experimental.parameters(1,x),Experimental.parameters(2,x),'o',...
        'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
        'MarkerEdgeColor',[1 1 1],'LineWidth', 2)    
end

hold off

set(gca,'Tag','IndividualTraces')
zz_copyfigure

% Warnings
str=[];
if ~isempty(missingmodels)
    str=['- Missing models: '];
    for x=1:length(missingmodels)
        str=[str num2str(missingmodels(x)) ' '];
    end
end
if ~isempty(missingtargets)
    str=[' ' str ' - Missing targets: '];
    for x=1:length(missingtargets)
        str=[str num2str(missingtargets(x)) ' '];
    end
end
if isempty(plotstatus) || sum(plotstatus)==0
    str='Warning: No compounds matching thresholds';
end
if isempty(str)
    zz_message(1,'No missing values','-b')
else
    zz_message(1,[str],'-r')
end 

minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off','String','')
end
SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','off','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','off','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','off','String','')

InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')


% ------------------- surfaceplot2 ---------------------
function surfaceplot2
global Models Experimental Modset Metset

selcmp=find(Experimental.activecmp);

varname=getvarname;
if Modset.listtype==3
    varname=[varname '_tg'];
end

AbsCheck=findobj(gcf,'Tag','AbsCheck');
absolutevalues=get(AbsCheck,'Value');

if isfield(Models,varname)
    l_models=length(Models.(varname));
else
    zz_message(1,'No models','-r')
    return
end

missingmodels=[]; missingtargets=[]; validtarget=1; n_valids=0; ZM=[]; ZM_sum=[];
for x=1:length(selcmp)
    cmp=selcmp(x);
    if cmp<=l_models
        coeff=Models.(varname){cmp};
    else
        coeff=[]; 
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        %disp('--- passed ---')
        validmodel=1;
        [X_cont,Y_cont,Z_cont]=calcsurf(coeff);
    else
        %disp('---- missing model ---')
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end
    % Check target
    if strcmp(get(gcbo,'String'),'Target Surface')
        
        targetfile=find(cell2mat(zz_tabletool('getcol','BoxTable',3)));
        
        targetval=Experimental.(varname)(cmp,targetfile);
        if isnan(targetval)
            validtarget=0;
            missingtargets=[missingtargets cmp];
        else
            validtarget=1;        
        end   
        if validmodel && validtarget
            Z_cont=Z_cont-targetval;
        end
            
    end
    
    if validmodel && validtarget
        
        if absolutevalues Z_cont=abs(Z_cont); end
               
        n_valids=n_valids+1;
        if n_valids==1
            ZM_sum=Z_cont;
            ZM_max=Z_cont;
            ZM_min=Z_cont;
        else
            ZM_sum=ZM_sum+Z_cont; % sum
            ZM_max=max(ZM_max,Z_cont); % max
            ZM_min=min(ZM_min,Z_cont); % min
        end  
    end
end

if isempty(ZM_sum)==0   
    SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','Value',1);
    surftype=get(SurfTypeRadio,'String');
    if strcmp(surftype,'Mean')
        ZM=ZM_sum/n_valids;
    end
    if strcmp(surftype,'Sum')
        ZM=ZM_sum;
    end    
    if strcmp(surftype,'Max')
        ZM=ZM_max;
    end  
    if strcmp(surftype,'Min')
        ZM=ZM_min;
    end   
    contourplot(X_cont,Y_cont,ZM)
    
    % plot design
    if Metset.contour_showdesign
        DM = [];
        for x=1:length(selcmp)
            cmp=selcmp(x);
            design = Models.([varname '_design']){cmp};
            DM = [DM design];
        end
        DM = unique(DM','rows');
        n_points = size(DM,1);
        
        hold on
        for x=1:n_points
            plot(DM(x,1),DM(x,2),'o',...
                'MarkerSize',10,'MarkerFaceColor',[0.6 0.6 0.6],...
                'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model(9.3)')
        end
        hold off       
    end

    str=[];
    if ~isempty(missingmodels)
        str=['- Missing models: '];
        for x=1:length(missingmodels)
            str=[str num2str(missingmodels(x)) ' '];
        end
    end
    if ~isempty(missingtargets)
        str=[' ' str ' - Missing targets: '];
        for x=1:length(missingtargets)
            str=[str num2str(missingtargets(x)) ' '];
        end
    end
    if isempty(str)
        zz_message(1,'No missing values','-r')
    else
        zz_message(1,str,'-r')
    end  
    if strcmp(get(gcbo,'String'),'Target Surface'); 
        Modset.plottype=2; % Target surface
    else
        Modset.plottype=1; % Normal surface
    end
        
else 
    zz_message(1,'No valid models','-r')
end


% ------------------- contourplot ---------------------
function contourplot(X_cont,Y_cont,Z_cont)
global Experimental Pos Modset Metset

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; 
end

lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

if Metset.contour_isolines linestr='-'; else linestr='none'; end
subplot('Position',Pos.rightplot)
if numel(v)>2 && numel(v)<100
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr); % New ML verisions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v);
        set(h,'LineStyle',linestr)
    end
else
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,'LineStyle',linestr); % New ML verisions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont);
    end   
end

if Metset.contour_labels clabel(C,h); end
set(h,'ButtonDownFcn','oo_model(9.1)','Tag','Contourplot');

% Centers clim if colormap is hotcold
if Metset.contour_centercol
    cm=[min(v) max(v)]; set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

set(gcf,'Colormap',oo_getcmap);

% ------- PLOTTING OF TRACES AND THRESHOLD CONTOURS -----
% THRESHOLDS
MinThreshEdit=findobj(gcf,'Tag','MinThreshEdit');
minthresh=str2double(get(MinThreshEdit,'String'));
if ~isnan(minthresh)
    hold on
    [C,h] = contour(X_cont,Y_cont,Z_cont,[minthresh max(max(Z_cont))+1]);
    set(h,'ButtonDownFcn','oo_model(9.1)','Edgecolor',[0.5 1 0.5],'LineWidth',2)
end
MaxThreshEdit=findobj(gcf,'Tag','MaxThreshEdit');
maxthresh=str2double(get(MaxThreshEdit,'String'));
if ~isnan(maxthresh)
    hold on
    [C,h] = contour(X_cont,Y_cont,Z_cont,[maxthresh max(max(Z_cont))+1]);
    set(h,'Edgecolor',[1 0.5 0.5],'LineWidth',2);
    set(h,'ButtonDownFcn','oo_model(9.1)')
end   
hold on
    
% TRACES
mintrace=get(findobj(gcf,'Tag','MinTCheck'),'Value');
maxtrace=get(findobj(gcf,'Tag','MaxTCheck'),'Value');

if mintrace || maxtrace  
    % Y-axis trace    
    if mintrace
        [mins,minind]=min(Z_cont');
    else
        [mins,minind]=max(Z_cont');
    end
    xv=X_cont(:,1)';
    yax=Y_cont(1,:);
    yv=Y_cont(1,minind);
    maxind=find(yv==max(yax)); xv(maxind)=[]; yv(maxind)=[];
    minind=find(yv==min(yax)); xv(minind)=[]; yv(minind)=[];
    % Smoothing
    if length(yv)>6
        for x=1:3
            ind=x:3:length(yv);
            yvp=yv(ind);
            xvp=xv(ind);
            Yi(x,:)=spline(xvp,yvp,xv);
        end
        yv=mean(Yi);
    end
    plot(xv,yv,'Color',[1 1 0],'LineWidth',2,'ButtonDownFcn','oo_model(9.1)')

    % X-axis trace
    if mintrace
        [mins,minind]=min(Z_cont);
    else
        [mins,minind]=max(Z_cont);
    end    
    yv=Y_cont(1,:);
    xax=X_cont(:,1);
    xv=X_cont(minind,1);
    maxind=find(xv==max(xax)); xv(maxind)=[]; yv(maxind)=[];
    minind=find(xv==min(xax)); xv(minind)=[]; yv(minind)=[];
    if length(xv)>6
    % Smoothing
        for x=1:3
            ind=x:3:length(xv);
            xvp=xv(ind);
            yvp=yv(ind);
            Xi(x,:)=spline(yvp,xvp,yv);
        end
        xv=mean(Xi);
    end 
    plot(xv,yv,'Color',[1 0.5 0.5],'LineWidth',2,'ButtonDownFcn','oo_model(9.1)')
end

% % Experiments
% if Metset.contour_showdesign
%     [m,n_points]=size(Experimental.parameters);
%     for x=1:n_points
%         plot(Experimental.parameters(1,x),Experimental.parameters(2,x),'o',...
%             'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
%             'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model(9.3)')    
%     end
% end

% Min and max
MinvalEdit1=findobj(gcf,'Tag','MinvalEdit1'); 
MinvalEdit2=findobj(gcf,'Tag','MinvalEdit2');
MinvalEdit3=findobj(gcf,'Tag','MinvalEdit3'); 
MinCheck=findobj(gcf,'Tag','MinCheck');
plotmin=get(MinCheck,'Value');
if plotmin
    minv=min(min(Z_cont));
    [ind1,ind2]=find(Z_cont==minv);
    ind1=ind1(1); ind2=ind2(1);
    minx=X_cont(ind1,ind2);
    miny=Y_cont(ind1,ind2);
    hold on
    plot(minx,miny,'o',...
        'MarkerSize',10,'MarkerFaceColor',[0.5 0.5 1],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model(9.3)')
    set(MinvalEdit1,'String',num2str(minx,'%6.4g'),'Enable','on')
    set(MinvalEdit2,'String',num2str(miny,'%6.4g'),'Enable','on')
    set(MinvalEdit3,'String',num2str(minv,'%6.4g'),'Enable','on')
else
    set(MinvalEdit1,'String','','Enable','off'); set(MinvalEdit2,'String','','Enable','off'); set(MinvalEdit3,'String','','Enable','off')      
end

MaxvalEdit1=findobj(gcf,'Tag','MaxvalEdit1'); 
MaxvalEdit2=findobj(gcf,'Tag','MaxvalEdit2');
MaxvalEdit3=findobj(gcf,'Tag','MaxvalEdit3'); 
MaxCheck=findobj(gcf,'Tag','MaxCheck');
plotmax=get(MaxCheck,'Value');
if plotmax
    maxv=max(max(Z_cont));
    [ind1,ind2]=find(Z_cont==maxv);
    ind1=ind1(1); ind2=ind2(1);
    maxx=X_cont(ind1,ind2);
    maxy=Y_cont(ind1,ind2);
    hold on
    plot(maxx,maxy,'o',...
        'MarkerSize',10,'MarkerFaceColor',[1 0.5 0.5],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model(9.3)')
    set(MaxvalEdit1,'String',num2str(maxx,'%6.4g'),'Enable','on')
    set(MaxvalEdit2,'String',num2str(maxy,'%6.4g'),'Enable','on')
    set(MaxvalEdit3,'String',num2str(maxv,'%6.4g'),'Enable','on')
else
    set(MaxvalEdit1,'String','','Enable','off'); set(MaxvalEdit2,'String','','Enable','off'); set(MaxvalEdit3,'String','','Enable','off')      
end

% Slectionpoint
sxv=mean(mean(X_cont));
syv=mean(mean(Y_cont));
maha=plot(sxv,syv,'+',...
    'MarkerSize',12,'MarkerFaceColor',[1 0.7 0.5],...
    'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model(9.3)','Tag','SelectionMarker','Visible','off');
if get(findobj(gcf,'Tag','ShowSelCheck'),'Value') set(maha,'Visible','on'); end


hold off
set(gca,'Tag','surface')
zz_copyfigure

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','on','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','on','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','on','String','')
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

Modset.currentcont_x=X_cont;
Modset.currentcont_y=Y_cont;
Modset.currentcont_z=Z_cont;

% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(coeff)
global Experimental 

designpoints=find(Experimental.designpoint);

XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
YScaleEdit=findobj('Tag','YScaleEdit'); yscaleoffs=str2double(get(YScaleEdit,'String'));
min_x=min(Experimental.parameters(1,designpoints)); max_x=max(Experimental.parameters(1,designpoints)); o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
min_y=min(Experimental.parameters(2,designpoints)); max_y=max(Experimental.parameters(2,designpoints)); o=(max_y-min_y)*(yscaleoffs/100); min_y=min_y-o; max_y=max_y+o;


res_x=100; res_y=100; %resolution of temperature/gradient
minmax_x=[min_x max_x]; inc_x=(minmax_x(2)-minmax_x(1))/res_x;
minmax_y=[min_y max_y]; inc_y=(minmax_y(2)-minmax_y(1))/res_y;

xs=minmax_x(1):inc_x:minmax_x(2);
le_x=length(xs);
ys=minmax_y(1):inc_y:minmax_y(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
for xc=1:le_x
    for yc=1:le_y
        D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        z_val=[D*coeff];    
        Z_cont(xc,yc)=z_val;     
    end   
end


% ------------------- calcmodels ---------------------
function calctargetmodels
global Experimental Models Modset

Calibdata = calibdata;

[m,n]=size(Calibdata.X); if m<2 err=1; zz_message(1,'Too few active experiments','-r'); return; end
if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)  
ListTypeRadio=findobj(ListTypeRadio,'String','Abs. models'); set(ListTypeRadio,'Value',1)

parameters = Calibdata.X';
expdata = Calibdata.Y'-Calibdata.T';

% x-matrix for validation
n_exp = size(parameters,2);
for x=1:n_exp
    XV(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];
end

selcmp=find(Experimental.activecmp);

varname = getvarname;

for x=1:length(selcmp)
    cmp = selcmp(x);
    y_meas = expdata(x,:)';

    [coefficients,n_coeff] = oo_calcmodel(parameters,y_meas);
    Models.([varname '_tg']){cmp} = coefficients;
    if sum(isnan(coefficients))==0 
        y_pred=XV*coefficients; 
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end   
        Models.([varname '_tg_nparam']){cmp}=n_coeff; % Number of parameters
        Models.([varname '_tg_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models.([varname '_tg_errors']){cmp}=[rms rms_adj r2 bias];
        Models.([varname '_tg_predmeas']){cmp}=[y_meas'; y_pred'];
        Models.([varname '_tg_design']){cmp}=parameters;      
    end    
end

Models.parnames={'Const',Calibdata.var1,Calibdata.var2,[Calibdata.var1 char(215) Calibdata.var2],[Calibdata.var1 char(178)],[Calibdata.var2 char(178)]};
Models.errornames={'RMS','RMS_adj','R2','Bias'};

validate


% ------------------- calcmodels ---------------------
function calcmodels
global Experimental Models Modset

Calibdata = calibdata;

[m,n]=size(Calibdata.X); if m<2 err=1; zz_message(1,'Too few active experiments','-r'); return; end
if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)  
ListTypeRadio=findobj(ListTypeRadio,'String','Abs. models'); set(ListTypeRadio,'Value',1)

parameters = Calibdata.X';
expdata = Calibdata.Y';

% x-matrix for validation
n_exp = size(parameters,2);
for x=1:n_exp
    XV(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];
end

selcmp=find(Experimental.activecmp);

varname=getvarname;

for x=1:length(selcmp)
    cmp = selcmp(x);
    y_meas = expdata(x,:)';
    [coefficients,n_coeff] = oo_calcmodel(parameters,y_meas);
    Models.(varname){cmp} = coefficients;
    if sum(isnan(coefficients))==0 
        y_pred=XV*coefficients; 
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end   
        Models.([varname '_nparam']){cmp}=n_coeff; % Number of parameters
        Models.([varname '_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models.([varname '_errors']){cmp}=[rms rms_adj r2 bias];
        Models.([varname '_predmeas']){cmp}=[y_meas'; y_pred'];
        Models.([varname '_design']){cmp}=parameters;      
    end    
end

Models.parnames={'Const',Calibdata.var1,Calibdata.var2,[Calibdata.var1 char(215) Calibdata.var2],[Calibdata.var1 char(178)],[Calibdata.var2 char(178)]};
Models.errornames={'RMS','RMS_adj','R2','Bias'};

Modset.currentmodel = 1;
Modset.currentmodeltype = 'Quad+Int';


validate


% ------------------- calibdata ---------------------
function Calibdata = calibdata
global Experimental Modset 
% Function for finding acitive calibration data

XM = repmat(NaN,numel(Experimental.activeexp),2);
expno=(1:numel(Experimental.activeexp))';
     
% Fills XM, Velocity var is always in column 1;
for x=1:numel(Experimental.paramnames)
    if Experimental.activeexp(x)
        XM(x,1)=Experimental.parameters(1,x);
        XM(x,2)=Experimental.parameters(2,x);
    end
end

% Delete columns that are all 0
NaNc=sum(isnan(XM));
delcols=NaNc==numel(Experimental.activeexp);
XM(:,delcols)=[];
if isempty(XM) expno=[]; end

% get Y-values
YM = Experimental.(getvarname)';

targets = [];
targetfile = find(cell2mat(zz_tabletool('getcol','BoxTable',3)));
if ~isempty(targetfile)
    targets = YM(targetfile,:);
end

delind=find(sum(isnan(XM),2));
XM(delind,:) = [];
YM(delind,:) = [];
expno(delind) = [];

% Constrain Y-values and targets
YM=YM(:,Experimental.activecmp);
targets = targets(Experimental.activecmp);

Calibdata.X=XM;
Calibdata.Y=YM;
Calibdata.T=targets;
Calibdata.expno=expno;
Calibdata.cmpno=find(Experimental.activecmp);

pnames = Experimental.paramnames{1};
Calibdata.var1=pnames{1};
Calibdata.var2=pnames{2};




% ------------------- checkpoint ---------------------
function checkpoint(xp,yp)
global Experimental Models Modset

xvals=Modset.currentcont_x(:,1);
yvals=Modset.currentcont_y(1,:);

xa=min(find(xvals>=xp)); xb=max(find(xvals<=xp));
if (xp-xvals(xb))<=(xvals(xa)-xp) nxp=xb; else nxp=xa; end
 
ya=min(find(yvals>=yp)); yb=max(find(yvals<=yp));
if (yp-yvals(yb))<=(yvals(ya)-yp) nyp=yb; else nyp=ya; end

zp=Modset.currentcont_z(nxp,nyp);

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'String',num2str(xp,'%6.4g'))
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'String',num2str(yp,'%6.4g'))
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'String',num2str(zp,'%6.4g'))

% Move marker
maha=findobj(gca,'Tag','SelectionMarker');
if ~isempty(maha) set(maha,'XData',xp,'YData',yp); end

% Find selected compounds
selcmp=find(Experimental.activecmp);

targetfile=find(cell2mat(zz_tabletool('getcol','BoxTable',3)));

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

varname=getvarname;

parameters=[xp,yp];
X=([1; parameters(1); parameters(2); parameters(1)*parameters(2); parameters(1)^2; parameters(2)^2])';   
[m,n_coeff]=size(X);
nanvector=repmat(NaN,6,1); 

ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio','Value',1);
modeltype=get(ListTypeRadio,'String');

usetarget=0;
if Modset.plottype==2 || strcmp(modeltype,'Target mod.')
    usetarget=1;
end
cc=1; ostr{1,cc}='Compound '; ostr{2,cc}='Calc. '; 
if usetarget ostr{3,cc}='Target '; ostr{4,cc}='Difference '; end
    
for p=1:length(selcmp)
    cmp=selcmp(p);
    if usetarget
        targetval=Experimental.(varname)(cmp,targetfile);
    else
        targetval=0;
    end  

    cmod=Models.(varname);  % current models
    if cmp<=numel(cmod) && numel(cmod{cmp})==n_coeff
        coeff=cmod{cmp};
    else
        coeff=nanvector;
    end

    if ~isnan(targetval) && sum(isnan(coeff))==0
        calcres=X*coeff;
        diff=calcres-targetval;
        cc=cc+1;
        ostr{1,cc}=[codes{cmp} ': '];
        ostr{2,cc}=[num2str(calcres,'%6.6g') ' '];
        if usetarget
            ostr{3,cc}=[num2str(targetval,'%6.6g') ' '];
            ostr{4,cc}=[num2str(diff,'%6.3g') ' '];
        end
    end
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

InfoBox=findobj(gcf,'Tag','InfoBox');
set(InfoBox,'String',outstr)
zz_copylist(0,InfoBox)



% ------------------- validate ---------------------
function validate
global Experimental Models Pos Modset

selcmp=find(Experimental.activecmp);

targetmodel=0;
varname=getvarname;
callerstr=get(gcbo,'String');
if strcmp(callerstr,'Target Model')
    targetmodel=1;
    targetfile=find(cell2mat(zz_tabletool('getcol','BoxTable',3)));
end

designpoints=find(Experimental.designpoint);
parameters=Experimental.parameters(:,designpoints);
[n_param,n_exp]=size(parameters);
if n_param==2
    for x=1:n_exp
        X(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];   
    end
end

if targetmodel
    for p=1:length(selcmp)
  
        cmp=selcmp(p);
        if cmp <= numel(Models.([varname '_predmeas']))
            err = Models.([varname '_tg_predmeas']){cmp};
            sumerr(p) = sum(abs(err(2,:) - err(1,:)));
        else
            sumerr(p) = NaN;
        end
 
    end
 
else
    for p=1:length(selcmp)

        cmp=selcmp(p);
        if cmp <= numel(Models.([varname '_predmeas']))
            err = Models.([varname '_predmeas']){cmp};
            sumerr(p) = sum(abs(err(2,:) - err(1,:)));
        else
            sumerr(p) = NaN;
        end

    end
end

subplot('Position',Pos.rightplot)
h=barh(sumerr);
set(h,'Edgecolor','none','FaceColor',[1 0.5 0.5])

minerr=min(sumerr); maxerr=max(sumerr); hp=(maxerr-minerr)/50;

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

for p=1:length(selcmp)
    cmp=selcmp(p); 
    text(hp,p,codes{cmp},'FontWeight','bold')
end
text(0.95,0.95,'Sum of errors','Units','Normalized','HorizontalAlignment','right','FontWeight','bold','FontSize',12)
ylim([0,length(selcmp)+1])

Modset.plottype=4; % Errorplot

set(gca,'Tag','sumerr')
zz_copyfigure



% ----------------- evalboxlist -------------------
function evalboxlist
global Experimental

val=zz_tabletool('getlastcell','BoxTable');

if numel(val)==1 && val.colindex>3
    Experimental.parameters(val.colindex-3,val.rowindex)=val.val;
end
if val(1).colindex==2
    Experimental.activeexp=cell2mat(zz_tabletool('getcol','BoxTable',2))';    
end
if numel(val)==1 && val.colindex==1
    Experimental.expname{val.rowindex}=val.val;
end


% ------------------- boxlist ---------------------
function boxlist
global Experimental Pos

paramname=cell(0);

T.TableName='BoxTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2+Pos.bw Pos.gh*6];

if isfield(Experimental,'parameters')
    
    [nparam,nexp]=size(Experimental.parameters);

    for expno=1:length(Experimental.expname)
        T.Data{expno,1}=Experimental.expname{expno};
        if Experimental.designpoint(expno)
            T.Data{expno,2}=true;
        else
            T.Data{expno,2}=false;
        end
        T.Data{expno,3}=false;
        for x=1:nparam
            T.Data{expno,x+3}=Experimental.parameters(x,expno);
        end
        if ~isempty(Experimental.paramnames{expno})
            for x=1:numel(Experimental.paramnames{expno})
                paramname{x}=Experimental.paramnames{expno}{x};
            end
        end
        T.RowName{expno}=['Exp ' num2str(expno)];   
    end

    % Set target
    notdesigns=find(~Experimental.designpoint); 
    if isempty(notdesigns)
        T.Data{1,3}=true;
    else
        T.Data{notdesigns(1),3}=true;
    end

    T.ColumnName={'Files','Design','Target'}; 
    for x=1:numel(paramname) T.ColumnName{x+3}=paramname{x}; end
    T.ColumnEditable=[1 1 1 ones(1,numel(paramname))];
    T.ViewPref=1;
    T.CellEditCallback='oo_model(12.1)';
    T.AllowNan=1;    
    T.ColumnFormat={'char','binary','excl_binary'}; for x=1:numel(paramname) T.ColumnFormat{x+3}='numeric'; end
    T.ColumnWidth=[100 50 50 repmat(60,1,numel(paramname))];
    
    T.ListSelCol=3;
    
    if isempty(paramname) zz_message(1,'Warning: Experiments/conditions are not assigned - Assign in Experiments window','-r'); end
    
else
    T.Data=[];    
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);




% ------------------- parameterslist ---------------------
function parameterslist
global Experimental

strno=0; str=[];
fn=fieldnames(Experimental);
for x=1:length(fn)
    if strcmp(fn{x}, 'rt_exp') strno=strno+1; str{strno}='Retention time (RT)'; end
    if strcmp(fn{x}, 'ri_exp') strno=strno+1; str{strno}='Retention index (RI)'; end
    if strcmp(fn{x}, 'wbl_exp') strno=strno+1; str{strno}='Peak width (RT units)'; end
    if strcmp(fn{x}, 'wbl_ri_exp') strno=strno+1; str{strno}='Peak width (RI units)'; end
    if strcmp(fn{x}, 'area_exp') strno=strno+1; str{strno}='Area'; end
    if strcmp(fn{x}, 'height_exp') strno=strno+1; str{strno}='Height'; end
    if strcmp(fn{x}, 'responsefactor_exp') strno=strno+1; str{strno}='Response factor'; end
end

ParametersList=findobj(gcf,'Tag','ParametersList');
set(ParametersList,'String',str)


% ----------------- evaldatalist -------------------
function evaldatalist
global Experimental

val=zz_tabletool('getlastcell','DataTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','DataTable',1))';
end

if val(1).colindex>1
    varname=getvarname;
    Experimental.(varname)(val.rowindex,val.colindex-1)=val.val;
end
    

% ------------------- datalist ---------------------
function datalist
global Experimental Modset Pos

T.TableName='DataTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];

if isfield(Experimental,'paramnames') && isfield(Experimental,'codes')
    n_exp=length(Experimental.paramnames);
    n_comp=length(Experimental.codes);
    
    varname=getvarname;

    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end   
        for expno=1:n_exp
            T.Data{compno,expno+1}=Experimental.(varname)(compno,expno);
        end
        
        if ~isfield(Experimental,'activecmp') % For old models
            Experimental.activecmp=ones(1,numel(Experimental.codes));
        end
        
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    for x=1:n_exp 
        T.ColumnName{x+1}=['Exp ' num2str(x)]; 
        T.ColumnFormat{x+1}=4;
        T.ColumnWidth{x+1}=70;
    end
    T.ColumnEditable=[ones(1,n_exp+1)];
    T.AllowNan=1;
    T.ViewPref=1;
    T.ColumnName{1}='Active';
    T.ColumnFormat{1}='binary';
    T.ColumnWidth{1}=40;
    T.CellEditCallback='oo_model(12.2)';
    T.ListSelCol=1;
else
    T.Data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ----------------- evalmodelslist -------------------
function evalmodelslist
global Experimental

%disp('-- evalmodelslist --')

val=zz_tabletool('getlastcell','ModelsTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','ModelsTable',1))';
end




% ------------------- modelslist ---------------------
function modelslist
global Experimental Models Modset Pos

T.TableName='ModelsTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];

varname=getvarname;
if Modset.listtype==3; % Targetmodels
    varname=[varname '_tg'];  
end

if ~isempty(Models) 
    
    % For old models where parnames and activecmp are not saved
    if ~isfield(Experimental,'activecmp') 
        Experimental.activecmp=ones(1,numel(Experimental.codes));
    end
    if ~isfield(Models,'parnames')
        Models.parnames={'Const','start','grad','startgrad','start','grad'}; 
    end      
    

    n_comp=length(Experimental.codes);
    
    % Constructs T
  
    [T.ColumnName{2:numel(Models.parnames)+1}]=deal(Models.parnames{:});

    T.ColumnName{1}='Active';

    T.Data=cell(numel(Experimental.codes),7);
    
    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end 
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    
    if isfield(Models,varname)
        for cmpno=1:numel(Models.(varname))
            if ~cellfun('isempty',Models.(varname)(cmpno))
                param=Models.(varname){cmpno}';
                for pno=1:numel(param) T.Data{cmpno,pno+1}=param(pno); end
            end
        end
    end
    
    for x=1:numel(Models.parnames) 
        T.ColumnFormat{x+1}=4; 
        T.ColumnWidth{x+1}=80;
    end
    T.AllowEmpty=1;
    T.AllowNan=0;
    T.ColumnFormat{1}='binary'; 
    T.ColumnWidth{1}=50;
    T.ViewPref=1;
    T.CellEditCallback='oo_model(12.3)';
    T.ListSelCol=1;
    T.ColumnEditable=[1 zeros(1,numel(Models.parnames))];
else
    T.data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

TargetSurfBtn=findobj(gcf,'Tag','TargetSurfBtn');
if Modset.listtype==3
    set(TargetSurfBtn,'Enable','off')
else
    set(TargetSurfBtn,'Enable','on')
end


% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- getmodels ---------------------
function getmodels
global Metset Locset

pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- getvarname ---------------------
function varname=getvarname

ParametersList=findobj(gcf,'Tag','ParametersList');
val=get(ParametersList,'Value');
str=get(ParametersList,'String');
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt_exp' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri_exp' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl_exp' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri_exp' ; end
if strcmp(selpar,'Area') varname='area_exp' ; end
if strcmp(selpar,'Height') varname='height_exp' ; end
if strcmp(selpar,'Response factor') varname='responsefactor_exp' ; end


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='ModelsWin'; winpar{2}='Chrombox Optimizer: Model';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model(99)',3,'','');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');

% Parameterslist
p=p+1;[ui{p,1:7}] = deal('Parameters:','Text',Colors.bc,[x(4) y(9) gw+bw eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(5) gw*0.5+bw gh*4],'oo_model(3.3)',2,'ParametersList');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(1) y(10) bw eh],'oo_model(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(1)+gw/2 y(10) bw eh],'oo_model(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(2) y(10) bw eh],'oo_model(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_model(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Abs. models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_model(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Target mod.','Radiobutton',Colors.bc,[x(3)+gw*4/3 y(10) gw+bw eh],'oo_model(7.1)',2,'ListTypeRadio');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Model','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(8) bw  bh],'oo_model(4.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Target Model','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(7) bw  bh],'oo_model(4.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Use absolute difference','Checkbox',Colors.bc,[x(5)+gw/2 y(3) bw+gw/2  bh],'',2,'AbsCheck');
p=p+1;[ui{p,1:7}] = deal('Surface','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(6) bw  bh],'oo_model(5.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Individual','Pushbutton',Colors.btn{1},[x(6)+gw/2 y(6) bw  bh],'oo_model(5.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Target Surface','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(5) bw  bh],'oo_model(5.1)',2,'TargetSurfBtn');
p=p+1;[ui{p,1:7}] = deal('Individual','Pushbutton',Colors.btn{1},[x(6)+gw/2 y(5) bw  bh],'oo_model(5.2)',2,'TargetSurfBtn');
p=p+1;[ui{p,1:7}] = deal('Mean','Radiobutton',Colors.bc,[x(5)+gw/2 y(4) bw+gw/2  bh],'oo_model(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Sum','Radiobutton',Colors.bc,[x(6) y(4) bw+gw/2  bh],'oo_model(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Min','Radiobutton',Colors.bc,[x(6)+gw/2 y(4) bw+gw/2  bh],'oo_model(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Max','Radiobutton',Colors.bc,[x(7) y(4) bw+gw/2  bh],'oo_model(6.1)',2,'SurfTypeRadio');

% Min/Max
p=p+1;[ui{p,1:7}] = deal('X-val','Text',Colors.bc,[x(8)+gw/2 y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Y-Val','Text',Colors.bc,[x(9) y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Response','Text',Colors.bc,[x(9)+gw/2 y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Threshold','Text',Colors.bc,[x(10) y(10)-eh/2 bw/2 eh],'',2,'');
p=p+1;[ui{p,1:7}] = deal('Min T','Checkbox',Colors.bc,[x(8)-bw*0.5 y(9) bw  bh],'oo_model(11.1)',2,'MinTCheck');
p=p+1;[ui{p,1:7}] = deal('Min P','Checkbox',Colors.bc,[x(8) y(9) bw  bh],'',2,'MinCheck');

p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(9) bw/2 eh],'',2,'MinvalEdit1');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(9) bw/2 eh],'',2,'MinvalEdit2');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(9) bw/2 eh],'',2,'MinvalEdit3');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(10) y(9) bw/2 eh],'',2,'MinThreshEdit');
p=p+1;[ui{p,1:7}] = deal('Max T','Checkbox',Colors.bc,[x(8)-bw*0.5 y(8) bw  bh],'oo_model(11.1)',2,'MaxTCheck');
p=p+1;[ui{p,1:7}] = deal('Max P','Checkbox',Colors.bc,[x(8) y(8) bw  bh],'',2,'MaxCheck');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(8) bw/2 eh],'',2,'MaxvalEdit1');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(8) bw/2 eh],'',2,'MaxvalEdit2');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(8) bw/2 eh],'',2,'MaxvalEdit3');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(10) y(8) bw/2 eh],'',2,'MaxThreshEdit');

% Selected
p=p+1;[ui{p,1:8}] = deal('Selected:','Text',Colors.bc,[x(8) y(7) bw/2  eh],'',2,'','-r');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8)+gw/2 y(7) bw/2 eh],'oo_model(9.4)',2,'SelXEdit');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9) y(7) bw/2 eh],'oo_model(9.4)',2,'SelYEdit');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(9)+gw/2 y(7) bw/2 eh],'',2,'SelZEdit');
p=p+1;[ui{p,1:7}] = deal('Marker','Checkbox',Colors.bc,[x(10) y(7) bw/2 eh],'oo_model(9.5)',2,'ShowSelCheck');
%p=p+1;[ui{p,1:7}] = deal('Calc','Pushbutton',Colors.btn{1},[x(10) y(7) bw/2 eh],'',2,'');

% Infotext
p=p+1;[ui{p,1:8}] = deal('-','Listbox',[1 1 1],[x(7)+gw/2 y(2) gw*2+bw gh*4+eh],'',2,'InfoBox','');

% Scale
p=p+1;[ui{p,1:8}] = deal('X-scale %','Text',Colors.bc,[x(6)+gw/2 y(9) bw*2/3 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[x(6)+gw/2+bw*2/3 y(9) bw/3 eh],'oo_model(10.1)',2,'XScaleEdit','-c');
p=p+1;[ui{p,1:8}] = deal('Y-scale %','Text',Colors.bc,[x(6)+gw/2 y(8) bw*2/3 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[x(6)+gw/2+bw*2/3 y(8) bw/3 eh],'oo_model(10.1)',2,'YScaleEdit','-c');

% Load / Save
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_model(1.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_model(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedModelsPop');
p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_model(8.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

updfcn='oo_model(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model(96)')
set(h0,'CloseRequestFcn','oo_model(99)')

% Multiple selections
FilesList=findobj(gcf,'Tag','DataModelsList'); set(FilesList,'Max',2,'Min',0)
minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off')
end

MeanCheck=findobj(gcf,'Tag','MeanCheck'); set(MeanCheck,'Value',1);
AbsCheck=findobj(gcf,'Tag','AbsCheck'); set(AbsCheck,'Value',1);

SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','String','Mean'); set(SurfTypeRadio,'Value',1)
CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)

