function oo_model_isodisp(call)
% function oo_model_isodisp(call)
% ver 180123 SAM
% global Metset Experimental Locset Modset Models

global Metset Experimental Locset Modset Models

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model_isodisp ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0  
    Experimental=[];
    Models=[];
    Modset=[];
    Modset.listtype=1; % Data
    Modset.codetype=1; % Codes  
    Modset.velocityvar='';
    Modset.interactvar='';
    openwin
    getexperiments
    getmodels
    boxlist
    datalist
    dispfunc
end

if call==1.1
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' strs{val} '.mat' ];
    load(pathname,'Experimental')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',strs{val})
    Experimental.activecmp(1:numel(Experimental.codes))=deal(true);
    Experimental.activeexp(1:numel(Experimental.expname))=deal(true);
    Models=[];
    Modset=[]; Modset.listtype=1; Modset.codetype=1; Modset.velocityvar=''; Modset.interactvar=''; Modset.filename=strs{val};
    autovelpop
    calcparam
    parameterslist
    boxlist
    listupdate  
    modeltypes
    Modset.currentplot='Design'; plotupdate
end

% Update parameterslist
if call==3.1
    parameterslist
end
% Change parameter
if call==3.3
    listupdate; plotupdate
end

% CALCULATE
% Standard surface
if call==4.1
    err=calcmodels;
    if err==0 Modset.listtype=2; modeltypes; listupdate; plotupdate; end
end
% vdmodels
if call==4.2
    dispfunc
end
if call==4.3
    err=vdintmodel;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end
if call==4.4
    err=logintmodel;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end

% Plotting
if call==5.0 || call==5.1
    plotupdate
end

if call==7.1
    listupdate; plotupdate
end

if call==8.1
    %disp('--- save model ---')
    if isempty(Models)
        zz_message(1,'No models to save','-r')
    else
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        filename=get(FileNameEdit,'String');
        if isempty(filename)
            zz_message(1,'Select file name','-r')
        else
            Info.modeltype='VD';
            Info.savedtime=now;
            Info.user=Locset.user;
            Info.codeversion=Locset.version;
            pathname=[ Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
            oo_savefile(pathname,Models,Experimental,Modset,Info)
            zz_message(1,['Saved as ' pathname],'-b')
            getmodels
        end    
    end   
end

if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
    S=load(pathname);
    if isfield(S,'Info') && strcmp(S.Info.modeltype,'VD')
       Models=S.Models;
       Experimental=S.Experimental;
       Modset=S.Modset;
       Modset.filename=filename;
       FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
       set(FileNameEdit,'String',filename)
       parameterslist
       boxlist
       listupdate  
       modeltypes
       setvelocitypop
       plotupdate
    else
        if isfield(S,'Info') str=[' (' S.Info.modeltype ')']; else str=''; end
        zz_message(1,['Incorrect model type ' str],'-r')
    end
end

% Point info
if call==9.6
    Userdat=get(gcbo,'UserData');
    if isfield(Userdat,'Infostr')
        T=tableposname;
        T.Data=Userdat.Infostr;
        T.ViewPref=3;
        T.ColumnWidth{1}=200;
        T.ColumnFormat{1}='char';
        T.ColumnName{1}='Selected:';        
        if zz_tabletool('Exist',T.TableName)
            zz_tabletool('Delete',T.TableName);
        end
        zz_tabletool('Create',T);        
    end     
end

% set scale
if call==10.1
    plotupdate
end

% Set velocity and interacting var:
if call==11.1 || call==11.2
    str=get(gcbo,'String'); val=get(gcbo,'Value'); selvar=str{val};
    allpnames=cell(0);
    for x=1:numel(Experimental.paramnames)
        pns=Experimental.paramnames{x};
        for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
    end
    allpnames=unique(allpnames);
    if numel(allpnames)==1 call=-99; end % Skips rest if only one var.
end
if call==11.1
    if strcmp(selvar,Modset.interactvar); Modset.interactvar=Modset.velocityvar; end
    Modset.velocityvar=selvar;
end
if call==11.2
    if strcmp(selvar,Modset.velocityvar); Modset.velocityvar=Modset.interactvar; end
    Modset.interactvar=selvar;
    calcparam
    listupdate
end
if call==11.1 || call==11.2
    setvelocitypop
    PlotTypePop=findobj(gcf,'Tag','PlotTypePop'); str=get(PlotTypePop,'String'); ind=strmatch('Design',str); set(PlotTypePop,'Value',ind); plotupdate
    modeltypes
end

% EVALUATE LISTS
if call==12.1 evalboxlist; calcparam; listupdate; end
if call==12.2 evaldatalist; end    
if call==12.3 evalmodelslist; end 

% Calculate values
if call==14.0
    calcvaltable
end

% Table from userdata
if call==94
    tabfromuserdat
end

% General plotupdate
if call==95
    plotupdate
end

% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model_isodisp (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end



% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------------- dispfunc ---------------------
function dispfunc
global Zset

ModTypePop=findobj(gcf,'Tag','ModTypePop');
Str=get(ModTypePop,'String'); val=get(ModTypePop,'Value');

apos=[Zset.Pos.xg(7)+Zset.Pos.gw*1.1 Zset.Pos.yg(2)+Zset.Pos.gh*0.2 Zset.Pos.gw*1.5  Zset.Pos.gh*1.6];
subplot('Position',apos,'Tag','DispEqPlot');
set(gca,'XTick',[],'YTick',[],'ZTick',[],'Box','off','Visible','off')
delete(get(findobj(gcf,'Tag','DispEqPlot'),'Children'))

try
    switch Str{val}
        case 'Golay (low PD)'
            texstr='$$ H = \frac{B}{u} + C \cdot u $$';
        case 'Golay (high PD)'
            texstr='$$ H = \frac{B}{u^2} + C \cdot u^2 $$';
        case 'Golay (interm. PD)'
            texstr='$$ H = \frac{B}{u^x} + C \cdot u^x $$';
        case 'Golay (C1 & C2)'
            texstr='$$ H = \frac{B}{u^2} + C_1 \cdot u^2 + C_2 \cdot u $$';
        case 'Van Deemter'
            texstr='$$ H = A + \frac{B}{u} + C \cdot u $$';
    end
    text(0,0.5,texstr,'Units','normalized','Interpreter','latex','HorizontalAlignment','left','VerticalAlignment','middle','FontSize',14)   
catch
    switch Str{val}
        case 'Golay (low PD)'
            texstr='H = B/u + C*u';
        case 'Golay (high PD)'
            texstr='H = B/u^2 + C*u^2';
        case 'Golay (interm. PD)'
            texstr='H = B/u^x + C*u^x';
        case 'Golay (C1 & C2)'
            texstr='H = B/u^2 + C_1*u^2 + C_2*u';
        case 'Van Deemter'
            texstr='H = A + B/u + C*u';
    end    
    text(0,0.5,texstr,'Units','normalized','Interpreter','tex','HorizontalAlignment','left','VerticalAlignment','middle','FontSize',14)
end


% ------------------- calcparam ---------------------
function calcparam
global Modset Experimental

Experimental.nplates_exp=((Experimental.rt_exp./Experimental.wbl_exp).^2)*16;

for x=1:numel(Experimental.paramnames)
    ind=find(strcmp(Modset.interactvar,Experimental.paramnames{x}));
    Experimental.plateheight_exp(:,x)=(Experimental.parameters(ind,x) ./ Experimental.nplates_exp(:,x)*1000)';
end


% ======================== PLOTTING FUNCTIONS ===========================

% ------------------- plotupdate ---------------------
function plotupdate
global Modset Experimental

zz_busy(1.1)

if isfield(Modset,'currentplot') currentplot=Modset.currentplot; else currentplot='Dummy'; end

PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
plotoptions=get(PlotTypePop,'String');
val=get(PlotTypePop,'Value');
selplot=plotoptions{val};

if isempty(Experimental)
    plot_dummy('No data'); Modset.currentplot='Dummy'; return
end
if strcmp(selplot,'Design')
    plot_design; 
end
if strcmp(selplot,'H/u')
    plot_hu;
    tabfromuserdat
end
if strcmp(selplot,'Errors')
    Estruct=calc_errors;
    oo_plot_errors(Estruct)      
end
if strcmp(selplot,'Pred. vs meas.')
    Estruct=calc_errors;
    oo_plot_predmeas(Estruct)    
end

Modset.currentplot=selplot;
setval=strmatch(Modset.currentplot,plotoptions);
if ~isempty(setval) set(PlotTypePop,'Value',setval); end

zz_busy(0.1)


% ------------------- plot_design ---------------------
function plot_design
global Pos

[setscale,xl,yl]=readsetscale;

Calibdata=calibdata;

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

subplot('Position',Pos.rightplot)

if ~isempty(Calibdata.X)
    
    [n_exp,n_factors]=size(Calibdata.X); 
    if n_factors<2 Calibdata.X(1:n_exp,2)=0; end
    
    if setscale      
        xl=[min(Calibdata.X(:,1)) max(Calibdata.X(:,1))];
        yl=[min(Calibdata.X(:,2)) max(Calibdata.X(:,2))];
        xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
        yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;
    end
    
    [m,n]=size(Calibdata.X);
    for x=1:m
    
        h=plot(Calibdata.X(x,1),Calibdata.X(x,2),'o','MarkerSize',18,'MarkerFaceColor',[0.8 0.8 0.8],'MarkerEdgeColor',[0.6 0.6 0.6],'LineWidth',3);
        text(Calibdata.X(x,1),Calibdata.X(x,2),num2str(Calibdata.expno(x)),'HorizontalAlignment','Center','FontWeight','bold')
        hold on
    end
    hold off
    
    setlims(xl,yl)
    
else
    text(0,0,'No data','HorizontalAlignment','Center','FontSize',18,'FontWeight','bold')
    xlim([-1 1]); ylim([-1 1]);
end

set(gca,'Tag','DesignPlot')
zz_copyfigure

% Delete table
T=tableposname;
if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end


% ------------------- plot_dummy ---------------------
function plot_dummy(str)
global Pos 

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
ah=subplot('Position',Pos.rightplot);
set(ah,'XTick',[],'YTick',[])
text(0.5,0.5,str,'Units','Normalized','HorizontalAlignment','center',...
    'VerticalAlignment','middle','FontWeight','bold','FontSize',12)
setlims([],[])
xlim([-1 1]); ylim([-1 1])


% ------------------- plot_hu ---------------------
function plot_hu
global Models Experimental Modset Pos

[setscale,xl,yl]=readsetscale;

% Check for validity
activecmp=find(Experimental.activecmp);
if isempty(activecmp) plot_dummy('No compounds selected'); return; end
if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); return; end
varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Check model type
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modtypes=get(ModelTypePop,'String');
modtype=modtypes{get(ModelTypePop,'Value')};

% Set variables for plot type
showmean=get(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value');
showind=get(findobj(gcf,'Tag','ShowVdIndCheck'),'Value');
if showmean+showind==0 showmean=1; set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1); end
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 

modno=findmodels(modtype);

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

% Check levels
nmod=0; varname=getvarname; P=[];
paramcell=Models(modno).(varname);
designcell=Models(modno).([varname '_design']);
predmeascell=Models(modno).([varname '_predmeas']);

for x=1:numel(activecmp)
    if numel(paramcell)>=activecmp(x) && ~isempty(paramcell{activecmp(x)}) && sum(isnan(paramcell{activecmp(x)}))==0
        nmod=nmod+1;
        PlotColor(nmod,:)=cols(activecmp(x),:);
        P(nmod,:)=paramcell{activecmp(x)};
        
        DM=designcell{activecmp(x)}; 
        Designpoints{nmod}=DM(1,:);
        minv(nmod)=min(DM(1,:));
        maxv(nmod)=max(DM(1,:));
        
        PM=predmeascell{activecmp(x)}; Measpoints{nmod}=PM(1,:); % Measured for plotting        
        labels{nmod}=cmplab{activecmp(x)};
    end
end

if nmod==0 plot_dummy('No valid models selected'); return; end

% Constructs x-axis
if setscale
    xl=[min(min(minv)) max(max(maxv))];
    xo=(xl(2)-xl(1))/10;
    xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
end  
x_axis=linspace(xl(1),xl(2),100);

% Get plot values
for x=1:nmod
    Vstruct(x)=calcvalues(x_axis,P(x,:),modtype);  
end

ah=subplot('Position',Pos.rightplot); 
if showind
    for x=1:nmod        
        if showabc 
            fn=fieldnames(Vstruct); 
            for pno=1:numel(fn)-2
                plot(x_axis,Vstruct(x).(fn{pno}),'Color',PlotColor(x,:),'LineWidth',1); hold on               
            end
        end
        if showsum 
            plot(x_axis,Vstruct(x).eSum,'Color',PlotColor(x,:),'LineWidth',2); hold on
        end
        if showpoints
            if numel(Designpoints{x})==numel(Measpoints{x})
                for pno=1:numel(Designpoints{x})
                    %Labels
                    vel=Designpoints{x}(pno);
                    S=calcvalues(vel,P(x,:),modtype); calcval=S.eSum;
                    Userdat.Infostr{1,1}=labels{x};
                    Userdat.Infostr{2,1}=[Modset.velocityvar ': ' num2str(vel)];
                    Userdat.Infostr{3,1}=['Measured: ' num2str(Measpoints{x}(pno),4)];
                    Userdat.Infostr{4,1}=['Calculated: ' num2str(calcval,4)];
                    Userdat.Infostr{5,1}=['Deviation: ' num2str(calcval-Measpoints{x}(pno),2)];
                    plot(vel,Measpoints{x}(pno),'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',PlotColor(x,:),'UserData',Userdat,'ButtonDownFcn','oo_model_isodisp(9.6)');
                end
            end
        end   
    end
end

% Mean model      
% creates x/y-values, calc model.
dp=[]; mp=[];
for x=1:numel(activecmp)
    DM=Models(modno).([varname '_design']){activecmp(x)};
    MM=Models(modno).([varname '_predmeas']){activecmp(x)};
    if ~isempty(DM) && ~isempty(MM)
        dp=[dp DM(1,:)];
        mp=[mp MM(1,:)];
    end
end

[mcoeff,my_pred,mparnames]=dispmodel(dp',mp',modtype);
Mstruct=calcvalues(x_axis,mcoeff,modtype);
[moptvel,mhmin]=getoptvel(mcoeff,modtype);

if showmean    
    if showabc
        fn=fieldnames(Mstruct); 
        for pno=1:numel(fn)-2
            plot(x_axis,Mstruct.(fn{pno}),'Color',[0 0 0],'LineWidth',3); hold on
        end
    end
    if showsum 
        plot(x_axis,Mstruct.eSum,'Color',[0 0 0],'LineWidth',4); hold on
    end    
    if showpoints
        dv=unique(dp);
        for x=1:numel(dv)
            ind=dp==dv(x);
            hv(x)=mean(mp(ind));
        end
        plot(dv,hv,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',[0 0 0])
    end
end
hold off

if setscale
    axis tight
    yl=get(ah,'ylim');
    if yl(1)>0
        yl(1)=0;
    else
        yl(1)=yl(1)-(yl(2)-yl(1))*0.05;
    end
    yl(2)=yl(2)+(yl(2)-yl(1))*0.02;
end

setlims(xl,yl)

texthp=xl(2)+(xl(2)-xl(1))*0.02;
textvp=linspace(yl(2)*0.98,0,max([20 nmod+1]));
textext=[];

if showind && nmod>1
    for x=1:nmod
        th=text(texthp,textvp(x),labels{x},'FontWeight','normal','FontSize',10,'Fontweight','bold','Color',PlotColor(x,:));
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);       
    end
    if showmean
        th=text(texthp,textvp(x+1),'Mean','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',[0 0 0]);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
else
    if showmean col=[0 0 0]; else col=PlotColor(1,:);end
    if showsum
        th=text(texthp,Mstruct.eSum(end),'Sum','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);       
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
    if showabc
        fn=fieldnames(Mstruct);
        for x=1:numel(fn)-2
            v=Mstruct.(fn{x}); vp=v(end);
            th=text(texthp,vp,Mstruct.effnames{x},'FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
            ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
            
        end   
    end
end

xlim([xl(1) xl(2)+(xl(2)-xl(1))*0.02+(max(textext)*1.5)])

% Table
for p=1:numel(mparnames) Data{1,p}=mcoeff(p); ColumnFormat{p}=4; end
Data{1,numel(mparnames)+1}=moptvel; Data{1,numel(mparnames)+2}=mhmin; 
ColumnFormat{1,numel(mparnames)+1}=4; ColumnFormat{1,numel(mparnames)+2}=4;
RowName{1}='Mean';
% Individual
for x=1:numel(labels)
    [optvel,hmin]=getoptvel(P(x,:),modtype);  
    RowName{x+1,1}=labels{x};
    for p=1:numel(mparnames) Data{x+1,p}=P(x,p); end
    Data{x+1,numel(mparnames)+1}=optvel; Data{x+1,numel(mparnames)+2}=hmin; 
    
    
end
mparnames{numel(mparnames)+1}='Opt.Vel.'; mparnames{numel(mparnames)+1}='Min. H ';

% Table
T=tableposname;
T.Data=Data;
T.RowName=RowName;
T.ColumnName=mparnames;
T.ViewPref=3;
T.ColumnFormat=ColumnFormat;
%T.ColumnWidth=60;
T.HeaderText{1}=modtype;

%if zz_tabletool('Exist',T.TableName)==1
%    zz_tabletool('Delete',T.TableName);
%end
%zz_tabletool('Create',T);

UserData.T=T;

set(gca,'Tag','PlotHu','UserData',UserData,'ButtonDownFcn','oo_model_isodisp(94)')
zz_copyfigure

% ------------------- readsetscale ---------------------
function [setscale,xl,yl]=readsetscale

xl=[]; yl=[];

% Read or set scale
if any(strcmp(get(gcbo,'Tag'),{'XScaleLowEdit','XScaleHighEdit','YScaleLowEdit','YScaleHighEdit'}))    
    
    xl(1)=str2double(get(findobj(gcf,'Tag','XScaleLowEdit'),'String'));
    xl(2)=str2double(get(findobj(gcf,'Tag','XScaleHighEdit'),'String'));
    xl=sort(xl);
    yl(1)=str2double(get(findobj(gcf,'Tag','YScaleLowEdit'),'String'));
    yl(2)=str2double(get(findobj(gcf,'Tag','YScaleHighEdit'),'String'));
    yl=sort(yl);
    
    if any(~(xl>-inf & xl<inf)) || any(~(yl>-inf & yl<inf))
        setscale=true;
    else
        setscale=false;
    end
else
    setscale=true;
end


% ------------------- tabfromuserdat ---------------------
function tabfromuserdat

disptab=1;
try
    seltype=get(gcf,'SelectionType');
    if ~strcmp(seltype,'normal')
        disptab=0;
    end
catch
end

if disptab
    UserData=get(gca,'Userdata');
    if isempty(UserData)
        UserData.T=tableposname;
    end
    if zz_tabletool('Exist',UserData.T.TableName)==1
        zz_tabletool('Delete',UserData.T.TableName);
    end
    zz_tabletool('Create',UserData.T);
end


% ------------------- setlims ---------------------
function setlims(xl,yl)

xl=sort(xl); yl=sort(yl); 
xen='on'; yen='on';

if numel(xl)~=2 xl=[0 0]; end
if numel(yl)~=2 yl=[0 0]; end

xlstr=num2str(xl(1),3); xhstr=num2str(xl(2),3);
ylstr=num2str(yl(1),3); yhstr=num2str(yl(2),3); 

if xl(1)==xl(2) xen='off'; xlstr='-'; xhstr='-'; end
if yl(1)==yl(2) yen='off'; ylstr='-'; yhstr='-'; end

set(findobj(gcf,'Tag','XScaleLowEdit'),'String',xlstr,'Enable',xen)
set(findobj(gcf,'Tag','XScaleHighEdit'),'String',xhstr,'Enable',xen)
set(findobj(gcf,'Tag','YScaleLowEdit'),'String',ylstr,'Enable',yen)
set(findobj(gcf,'Tag','YScaleHighEdit'),'String',yhstr,'Enable',yen)

if xl(2)>xl(1) xlim(xl); else xlim([xl(1)-1 xl(2)+1]); end
if yl(2)>yl(1) ylim(yl); else ylim([yl(1)-1 yl(2)+1]); end


% ------------------- modeltypes ---------------------
function modeltypes
global Modset Models

ModelTypePop=findobj(gcf,'Tag','ModelTypePop');

if ~isempty(Models)    
    for x=1:numel(Models)
        Mtstr{x}=Models(x).modeltype;
    end
    Modset.modtypes=Mtstr;    
    set(ModelTypePop,'String',Mtstr,'Value',Modset.currentmodel)    
else
    set(ModelTypePop,'String','Types','Value',1)
end


% ------------------- autovelpop ---------------------
function autovelpop
global Experimental Modset

n_names=0; allnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pnames=Experimental.paramnames{x};
    for y=1:numel(pnames)
        if ~isempty(pnames{y})
            n_names=n_names+1;
            allnames{n_names}=pnames{y};
        end
    end
end
uniquenames=unique(allnames);

% Find matches that can be mobile phase vel.
C={'flo','vel','spe','mob','car'};
for x=1:numel(uniquenames)
    sc(x)=sum(strncmpi(uniquenames{x},C,3));
end
[d,ind]=max(sc); [d,ind2]=min(sc);

Modset.velocityvar=uniquenames{ind};

if numel(uniquenames)>1
    Modset.interactvar=uniquenames{ind2};
end

setvelocitypop


% ------------------- setvelocitypop ---------------------
function setvelocitypop
global Experimental Modset

InterVaryPop=findobj(gcf,'Tag','InterVaryPop');
VelocityPop=findobj(gcf,'Tag','VelocityPop');

allpnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pns=Experimental.paramnames{x};
    for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
end
allpnames=unique(allpnames);

dummystr={'-'};
if numel(allpnames)>0
    set(VelocityPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.velocityvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(VelocityPop,'Value',ind)
else
    set(VelocityPop,'String',dummystr,'Enable','off','Value',1)
end
if numel(allpnames)>1        
    set(InterVaryPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.interactvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(InterVaryPop,'Value',ind)    
else
    set(InterVaryPop,'String',dummystr,'Enable','off','Value',1)
end


% ------------------- listupdate ---------------------
function listupdate
global Modset Models Experimental

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

callertag=get(gcbo,'Tag');

if strcmp(callertag,'CodeRadio')
    codestr=get(gcbo,'String');
    if strcmp(codestr,'Code')
        Modset.codetype=1;
    end
    if strcmp(codestr,'Name')
        Modset.codetype=2;
    end    
    if strcmp(codestr,'Short name')
        Modset.codetype=3;
    end        
end

if strcmp(callertag,'ListTypeRadio')
    liststr=get(gcbo,'String');
    if strcmp(liststr,'Show data')
       Modset.listtype=1;
    end
    if strcmp(liststr,'Show models')
       Modset.listtype=2;
    end     
end

% set code types
if Modset.codetype==1
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Modset.codetype==2
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Modset.codetype==3
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

if isempty(Models) Modset.listtype=1; end 
if isempty(Experimental) Modset.listtype=0; end 

if Modset.listtype~=1 && zz_tabletool('Exist','DataTable')
    zz_tabletool('Delete','DataTable');
end
if Modset.listtype==1 && zz_tabletool('Exist','ModelsTable')
    zz_tabletool('Delete','DataTable');
end

% set list types
if Modset.listtype==0 datalist; end

if Modset.listtype==1
    h=findobj(ListTypeRadio,'String','Show data');
    set(h,'Value',1)
    datalist
end
if Modset.listtype==2
    h=findobj(ListTypeRadio,'String','Show models');
    set(h,'Value',1)
    modelslist
end


% ------------------- calibdata ---------------------
function Calibdata=calibdata
global Experimental Modset 
% Function for finding acitive calibration data

XM=repmat(NaN,numel(Experimental.activeexp),2);
expno=(1:numel(Experimental.activeexp))';

% Fills XM, Velocity var is always in column 1;
for x=1:numel(Experimental.paramnames)
    if Experimental.activeexp(x)
        pamcell=Experimental.paramnames{x};       
        if ~isempty(Modset.velocityvar)
            ind=strmatch(Modset.velocityvar,pamcell,'Exact');
            if ~isempty(ind)
                ind=ind(1);
                XM(x,1)=Experimental.parameters(ind,x);
            end
        end
        if ~isempty(Modset.interactvar)
            ind2=strmatch(Modset.interactvar,pamcell,'Exact');
            if ~isempty(ind2)
                ind2=ind2(1);
                XM(x,2)=Experimental.parameters(ind2,x);
            end
        end
    end
end
                
% Delete columns that are all 0
NaNc=sum(isnan(XM));
delcols=NaNc==numel(Experimental.activeexp);
XM(:,delcols)=[];
if isempty(XM) expno=[]; end

% get Y-values
YM=Experimental.(getvarname)';   

delind=find(sum(isnan(XM),2));

XM(delind,:)=[];
YM(delind,:)=[];
expno(delind)=[];

% Constrain Y-values
YM=YM(:,Experimental.activecmp);

Calibdata.X=XM;
Calibdata.Y=YM;
Calibdata.expno=expno;
Calibdata.cmpno=find(Experimental.activecmp);
Calibdata.var1=Modset.velocityvar;
Calibdata.var2=Modset.interactvar;
   

% ------------------- findmodels ---------------------
function modno=findmodels(modeltype)
global Models

n_models=numel(Models);
if n_models==0
    modno=[]; 
else
    for x=1:numel(Models) 
        modeltypes{x}=Models(x).modeltype; 
    end
    modno=strmatch(modeltype,modeltypes);
    if ~isempty(modno)
        modno=modno(1);
    end
end


% ------------------- dispmodels ---------------------
function [coeff,y_pred,parnames]=dispmodel(velocity,plateh,modeltype)

coeff=[]; y_pred=[];

y=plateh;

switch modeltype
    case 'Golay (low PD)'
        %X=[1./velocity velocity]
        coeff=[1./velocity velocity]\plateh;   
        y_pred=coeff(1)./velocity + coeff(2).*velocity;
        parnames={'B','C'};
        
    case 'Golay (high PD)'
        X=[1./(velocity.^2) velocity.^2];
        coeff=X\y; 
        y_pred=coeff(1)./velocity.^2 + coeff(2).*velocity.^2;
        parnames={'B','C'};
        
    case 'Golay (interm. PD)'
        xv=1:0.01:2;
        for p=1:numel(xv)           
            X=[1./(velocity.^xv(p)) velocity.^xv(p)];         
            coeff=X\y;
            y_pred=coeff(1)./velocity.^xv(p) + coeff(2).*velocity.^xv(p);
            ssr(p)=sum((y-y_pred).^2);
        end
        [minv,minp]=min(ssr);
        x=xv(minp);
        X=[1./(velocity.^x) velocity.^x];
        coeff=X\y;
        y_pred=coeff(1)./velocity.^x + coeff(2).*velocity.^x;
        if any(isnan(coeff)) x=NaN; end
        coeff=[coeff; x];
        parnames={'B','C','x'};
        
    case 'Golay (C1 & C2)'
        X=[1./(velocity.^2) velocity.^2 velocity];
        coeff=X\y;
        y_pred=coeff(1)./velocity.^2 + coeff(2).*velocity.^2 +coeff(3)*velocity;
        parnames={'B','C1','C2'};
        
    case 'Van Deemter'
        X=[ones(numel(velocity),1) 1./velocity velocity];
        coeff=X\y; 
        y_pred=coeff(1) + coeff(2)./velocity + coeff(3).*velocity;
        parnames={'A','B','C'};            
end


% ------------------- calcmodels ---------------------
function err=calcmodels
global Experimental Models Modset

if isempty(Experimental)
    err=true;
    zz_message(1,'No experiment is loaded','-r')
    return
end

err=false;

ModTypePop=findobj(gcf,'Tag','ModTypePop');
Str=get(ModTypePop,'String');
modeltype=Str{get(ModTypePop,'Value')};
varname=getvarname;
selcmp=find(Experimental.activecmp);

modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

Calibdata=calibdata;

expdata=Calibdata.Y';

parn{1}=Calibdata.var1; spaceind=strfind(parn{1},' '); parn{1}(spaceind)=[];


for x=1:length(selcmp)
    cmp=selcmp(x);   
    
    % Get x and y
    y_meas=expdata(x,:)';   
    DM=Calibdata.X;
   
    % Delete NaNs 
    delind=isnan(y_meas);
    y_meas(delind)=[];
    DM(delind,:)=[];
    
    [coefficients,y_pred,parnames]=dispmodel(DM(:,1),y_meas,modeltype);
    n_coeff=numel(coefficients);
    
    Models(modno).(varname){cmp}=coefficients;
    
    if sum(isnan(coefficients))==0 
        
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end    
        Models(modno).([varname '_nparam']){cmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models(modno).([varname '_errors']){cmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){cmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){cmp}=DM';   
    end
    
    Models(modno).parnames=parnames;
    Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};
    
    Modset.currentmodel=modno;
    
end

PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
Str=get(PlotTypePop,'String');
ind=find(strcmpi('H/u',Str));
if ~isempty(ind) set(PlotTypePop,'Value',ind); end


% ------------------- getoptvel ---------------------
function [optvel,minh]=getoptvel(coeff,modtype)

optvel=NaN; minh=NaN;

switch modtype
    case 'Golay (low PD)'
        optvel=(coeff(1)/coeff(2))^0.5;
        minh=coeff(1)/optvel + coeff(2)*optvel;
        
    case 'Golay (high PD)'
        optvel=(coeff(1)/coeff(2))^0.25;
        minh=coeff(1)/optvel^2 + coeff(2)*optvel^2;
        
    case 'Golay (interm. PD)'
        optvel=(coeff(1)/coeff(2))^(0.5/coeff(3));
        minh=coeff(1)/optvel^coeff(3) + coeff(2)*optvel^coeff(3);    
        
    case 'Golay (C1 & C2)'
        
    case 'Van Deemter'  
        optvel=(coeff(2)/coeff(3))^0.5;
        minh=coeff(1) + coeff(2)/optvel + coeff(3)*optvel;
                
end
        

% ------------------- calcvalues ---------------------
function Vstruct=calcvalues(xval,coeff,modtype)

%disp('---- calcvalues ----')

switch modtype
    case 'Golay (low PD)'
        Vstruct.eB=coeff(1)./xval;
        Vstruct.eC=coeff(2)*xval;
        Vstruct.eSum=Vstruct.eB+Vstruct.eC;
        Vstruct.effnames={'B','C'};
        
    case 'Golay (high PD)'
        Vstruct.eB=coeff(1)./(xval.^2);
        Vstruct.eC=coeff(2)*(xval.^2);
        Vstruct.eSum=Vstruct.eB+Vstruct.eC;
        Vstruct.effnames={'B','C'};
        
     case 'Golay (interm. PD)'
        Vstruct.eB=coeff(1)./(xval.^coeff(3));
        Vstruct.eC=coeff(2)*(xval.^coeff(3));
        Vstruct.eSum=Vstruct.eB+Vstruct.eC;
        Vstruct.effnames={'B','C'};   

     case 'Golay (C1 & C2)'
        Vstruct.eB=coeff(1)./(xval.^2);
        Vstruct.eC1=coeff(2)*(xval.^2);
        Vstruct.eC2=coeff(3)*xval;
        Vstruct.eSum=Vstruct.eB+Vstruct.eC1+Vstruct.eC2;
        Vstruct.effnames={'B','C1','C2'};   
        
    case 'Van Deemter'
        Vstruct.eA=repmat(coeff(1),1,numel(xval));
        Vstruct.eB=coeff(2)./xval;
        Vstruct.eC=coeff(3)*xval;
        Vstruct.eSum=Vstruct.eA+Vstruct.eB+Vstruct.eC;
        Vstruct.effnames={'A','B','C'}; 
        
end
    

% ------------------- calc_errors ---------------------
function Estruct=calc_errors
global Experimental Models Pos Modset

T=tableposname;
Estruct.plotpos=Pos.rightplot;
Estruct.tablepos=T.Position;
Estruct.tablename=T.TableName;

if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); setlims([],[]); return; end

modno=Modset.currentmodel;
selcmp=find(Experimental.activecmp);
if isempty(selcmp) plot_dummy('No compounds selected'); return; end

varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end

switch Modset.codetype
    case 1; cmplabs=Experimental.codes;
    case 2; cmplabs=Experimental.names;
    case 3; cmplabs=Experimental.shortnames;
end

ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
modelstr=str{val}; 

valids=find(~cellfun('isempty',Models(modno).([varname '_errors'])));
valids=intersect(valids,selcmp);

if isempty(valids)
    return   
end

terrornames=Models(modno).errornames;
rmseind=strmatch('RMS',terrornames,'exact'); rmseind=rmseind(1);
rmseadjind=strmatch('RMS_adj',terrornames,'exact'); rmseadjind=rmseadjind(1);
biasind=strmatch('Bias',terrornames,'exact'); biasind=biasind(1);

for vno=1:numel(valids)
    terrors=Models(modno).([varname '_errors']){valids(vno)};
    
    rmse(vno)=terrors(rmseind);
    rmseadj(vno)=terrors(rmseadjind);
    bias(vno)=terrors(biasind);
        
    predmeas=Models(modno).([varname '_predmeas']){valids(vno)};
    Measured{vno}=predmeas(1,:);
    Predicted{vno}=predmeas(2,:);
    
    n_exp(vno)=length(Measured{vno}); 
    
    R=corrcoef(Measured{vno},Predicted{vno});
    correl(vno)=R(1,2);
       
    des{vno}=(Models(modno).([varname '_design']){valids(vno)})';
     
end

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

Estruct.modeltype=Models(modno).modeltype;
Estruct.parameter=modelstr;
Estruct.rmse=rmse;
Estruct.rmse_adj=rmseadj;
Estruct.Measured=Measured;
Estruct.Predicted=Predicted;
Estruct.Design=des;
Estruct.n_exp=n_exp;
Estruct.correl=correl;
Estruct.bias=bias;
Estruct.Labels=cmplabs(valids);
Estruct.Colors=cols(valids,:);
Estruct.Varnames{1}=Models(modno).velocityvar; Estruct.Varnames{2}=Models(modno).interactvar; 


% ------------------- calcvaltable ---------------------
function calcvaltable
global Experimental Models Modset Pos

varnam=getvarname;

if isfield(Models,varnam) && ~isempty(Models(Modset.currentmodel).(varnam))
    
    T.TableName='CalculatedTable';
    
    winw=Pos.window(3); winh=Pos.window(4);
    winl=Pos.window(1); winb=Pos.window(2);
    lp=winl+winw*0.02; vp=winb+winh*0.45; tw=winw*0.52; th=winh*0.53;
    T.Position=[lp vp tw th];
    
    modno=Modset.currentmodel;
    paramcell=Models(modno).(varnam);
    valmodels=find(~cellfun('isempty',paramcell));
    modtype=Models(modno).modeltype;
    
    if Modset.codetype==1 T.RowName=Experimental.codes; end
    if Modset.codetype==2 T.RowName=Experimental.names; end
    if Modset.codetype==3 T.RowName=Experimental.shortnames; end
    
    T.RowName{numel(T.RowName)+1}=Modset.velocityvar;
    
    for x=1:numel(Experimental.paramnames)
        ind(x,:)=strcmp(Modset.velocityvar,Experimental.paramnames{x});
    end
    velocities=Experimental.parameters(ind');
    
    T.Data=cell(numel(T.RowName),numel(velocities));
    
    for x=1:numel(valmodels)
        coeff=paramcell{valmodels(x)};
        Vstruct=calcvalues(velocities,coeff,modtype);
        for y=1:numel(Vstruct.eSum)
            T.Data{valmodels(x),y}=Vstruct.eSum(y);
        end
    end
    for x=1:numel(velocities)
        T.Data{end,x}=velocities(x);
    end
    
    for x=1:numel(velocities)
        T.ColumnName{x}=['Exp ' num2str(x)];
        T.ColumnFormat{x}=4;
        T.ColumnWidth{x}=70;
    end
    
    T.ColumnEditable=[zeros(1,numel(velocities))];
    T.AllowNan=1;
    T.ViewPref=1;
    T.Popup=1;
    T.PopupTitle='Calculated values';
    T.PopupResizable=1;
    T.PopupModal=0;
    ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
    T.HeaderText={['Calculated values for ' modtype],['Variable is ' str{val}]};
    T.FooterText={Modset.filename,datestr(now)};
    
    if zz_tabletool('Exist',T.TableName)
        zz_tabletool('Delete',T.TableName);
        pause(0.5)
    end
    zz_tabletool('Create',T);
    
else
    zz_message(1,'No model of this type','-r')
end


% ----------------- evalboxlist -------------------
function evalboxlist
global Experimental

val=zz_tabletool('getlastcell','BoxTable');

if numel(val)==1 && val.colindex==1
    Experimental.expname{val.rowindex}=val.val;
end
if val(1).colindex==2
    Experimental.activeexp=cell2mat(zz_tabletool('getcol','BoxTable',2))';    
end
if numel(val)==1 && val.colindex>2
    Experimental.parameters(val.colindex-2,val.rowindex)=val.val;
end

plot_design 


% ------------------- boxlist ---------------------
function boxlist
global Experimental Pos

paramname=cell(0);

T.TableName='BoxTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2+Pos.bw Pos.gh*6];

if isfield(Experimental,'parameters')
    [nparam,nexp]=size(Experimental.parameters);

    for expno=1:length(Experimental.expname)
        T.Data{expno,1}=Experimental.expname{expno};
        if Experimental.activeexp(expno)
            T.Data{expno,2}=true;
        else
            T.Data{expno,2}=false;
        end
        %T.Data{expno,3}=false;
        for x=1:nparam
            T.Data{expno,x+2}=Experimental.parameters(x,expno);
        end
        if ~isempty(Experimental.paramnames{expno})
            for x=1:numel(Experimental.paramnames{expno})
                paramname{x}=Experimental.paramnames{expno}{x};
            end
        end
        T.RowName{expno}=['Exp ' num2str(expno)];   
    end

    T.ColumnName={'Files','Active'}; 
    for x=1:numel(paramname) T.ColumnName{x+2}=paramname{x}; end
    T.ColumnEditable=[1 1 ones(1,numel(paramname))];
    T.ViewPref=1;
    T.CellEditCallback='oo_model_isodisp(12.1)';
    T.AllowNan=1;    
    T.ColumnFormat={'char','binary'}; for x=1:numel(paramname) T.ColumnFormat{x+2}='numeric'; end
    T.ColumnWidth=[100 50 repmat(60,1,numel(paramname))];    
    T.ListSelCol=2;   
    
    if isempty(paramname) zz_message(1,'Warning: Experiments/conditions are not assigned - Assign in Experiments window','-r'); end
    
else
    T.Data=[];    
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- parameterslist ---------------------
function parameterslist
global Experimental

ParametersList=findobj(gcf,'Tag','ParametersList'); set(ParametersList,'Enable','off')

if isempty(Experimental) return; end

showall=get(findobj(gcf,'Tag','AllParamCheck'),'Value');
currentstr=get(ParametersList,'String'); if ~iscell(currentstr) currentstr={''}; end
currentval=get(ParametersList,'Value'); if currentval>numel(currentstr) currentval=1; end
currentsel=currentstr{currentval};
preferred='Plate height (mm)';
currentvar=getvarname;

strno=0; str=[];
fn=fieldnames(Experimental);
for x=1:length(fn)  
    if strcmp(fn{x}, 'plateheight_exp') strno=strno+1; str{strno}='Plate height (mm)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'nplates_exp') strno=strno+1; str{strno}='Number of plates'; end       
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'rt_exp') strno=strno+1; str{strno}='Retention time (RT)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'ri_exp') strno=strno+1; str{strno}='Retention index (RI)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'wbl_exp') strno=strno+1; str{strno}='Peak width (RT units)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'wbl_ri_exp') strno=strno+1; str{strno}='Peak width (RI units)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'area_exp') strno=strno+1; str{strno}='Area'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'height_exp') strno=strno+1; str{strno}='Height'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'responsefactor_exp') strno=strno+1; str{strno}='Response factor'; end
end

if ~isempty(str) && iscell(str)
    ind=strmatch(currentsel,str,'exact'); 
    if isempty(ind) ind=strmatch(preferred,str,'exact'); end
    if isempty(ind) ind=1; end 
    set(ParametersList,'String',str,'Value',ind,'Enable','on')
end



% ----------------- evaldatalist -------------------
function evaldatalist
global Experimental

val=zz_tabletool('getlastcell','DataTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','DataTable',1))';
end

if val(1).colindex>1
    varname=getvarname;
    Experimental.(varname)(val.rowindex,val.colindex-1)=val.val;
end
    

% ------------------- datalist ---------------------
function datalist
global Experimental Modset Pos

T.TableName='DataTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];

if isfield(Experimental,'paramnames') && isfield(Experimental,'codes')
    n_exp=length(Experimental.paramnames);
    n_comp=length(Experimental.codes);
    
    varname=getvarname;

    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end   
        for expno=1:n_exp
            T.Data{compno,expno+1}=Experimental.(varname)(compno,expno);
        end
        
        if ~isfield(Experimental,'activecmp') % For old models
            Experimental.activecmp=ones(1,numel(Experimental.codes));
        end
        
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    
    if strcmp(varname,'nplates_exp') colf='%8.0f'; else colf=4; end
    
    for x=1:n_exp 
        T.ColumnName{x+1}=['Exp ' num2str(x)]; 
        T.ColumnFormat{x+1}=colf;
        T.ColumnWidth{x+1}=70;
    end
    T.ColumnEditable=[ones(1,n_exp+1)];
    T.AllowNan=1;
    T.ViewPref=1;
    T.ColumnName{1}='Active';
    T.ColumnFormat{1}='binary';
    T.ColumnWidth{1}=40;
    T.CellEditCallback='oo_model_isodisp(12.2)';
    T.ListSelCol=1;
else
    T.Data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ----------------- evalmodelslist -------------------
function evalmodelslist
global Experimental

val=zz_tabletool('getlastcell','ModelsTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','ModelsTable',1))';
end

if get(findobj(gcf,'Tag','PlotUpdCheck'),'Value')
    plotupdate
end


% ------------------- modelslist ---------------------
function modelslist
global Experimental Models Modset Pos

if ~isfield(Modset,'currentmodel') return; end

% Select model to display
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modeltypestr=get(ModelTypePop,'String'); 
if gcbo==ModelTypePop
    val=get(ModelTypePop,'Value'); 
    modeltype=modeltypestr{val};
    modno=findmodels(modeltype);
    if ~isempty(modno) 
        Modset.currentmodel=modno; 
        Modset.currentmodeltype=modeltype;
    else
        zz_message(1,['No models of type ' modeltype],'-r');
    end
end   
modno=Modset.currentmodel;
modeltype=Models(modno).modeltype;
val=strmatch(modeltype,modeltypestr); 
if ~isempty(val) val=val(1); set(ModelTypePop,'Value',val); end   

T.TableName='ModelsTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];
varname=getvarname;

if ~isempty(Models) 
    
    % For old models where parnames and activecmp are not saved
    if ~isfield(Experimental,'activecmp') 
        Experimental.activecmp=ones(1,numel(Experimental.codes));
    end
    if ~isfield(Models,'parnames')
        Models(modno).parnames={'Const','start','grad','start�grad','start�','grad�'}; 
    end      
    
    n_comp=length(Experimental.codes);
    
    % Constructs T
    [T.ColumnName{2:numel(Models(modno).parnames)+1}]=deal(Models(modno).parnames{:});
    T.ColumnName{1}='Active';
    
    n_param=numel(Models(modno).parnames);
    T.Data=cell(numel(Experimental.codes),1+n_param);
    
    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end 
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    
    if isfield(Models,varname)
        for cmpno=1:numel(Models(modno).(varname))
            if ~cellfun('isempty',Models(modno).(varname)(cmpno))
                param=Models(modno).(varname){cmpno}';
                for pno=1:numel(param) T.Data{cmpno,pno+1}=param(pno); end
            end
        end
    end
    
    for x=1:numel(Models(modno).parnames) 
        T.ColumnFormat{x+1}=4; 
        T.ColumnWidth{x+1}=80;
    end
    T.AllowEmpty=1;
    T.AllowNan=0;
    T.ColumnFormat{1}='binary'; 
    T.ColumnWidth{1}=50;
    T.ViewPref=1;
    T.CellEditCallback='oo_model_isodisp(12.3)';
    T.ListSelCol=1;
    T.ColumnEditable=[1 zeros(1,numel(Models(modno).parnames))];
else
    T.data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

Modset.listtype=2;

% Set correct model type
val=strmatch(Models(Modset.currentmodel).modeltype,modeltypestr);
if ~isempty(val)
    val=val(1); set(ModelTypePop,'Value',val)
end


% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end


% ------------------- getmodels ---------------------
function getmodels
global Metset Locset

pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- getvarname ---------------------
function varname=getvarname

ParametersList=findobj(gcf,'Tag','ParametersList');
val=get(ParametersList,'Value');
str=get(ParametersList,'String');
if isempty(str) varname=[]; return; end
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt_exp' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri_exp' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl_exp' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri_exp' ; end
if strcmp(selpar,'Area') varname='area_exp' ; end
if strcmp(selpar,'Height') varname='height_exp' ; end
if strcmp(selpar,'Response factor') varname='responsefactor_exp' ; end
if strcmp(selpar,'Number of plates') varname='nplates_exp' ; end
if strcmp(selpar,'Plate height (mm)') varname='plateheight_exp' ; end


% ------------------- tableposname ---------------------
function T=tableposname

global Pos

T.TableName='PlotVDInfoTable';
T.Position=[Pos.gl+6.6*Pos.gw Pos.yg(4) Pos.gw*1.4 Pos.gh*6];
T.Position=[Pos.gl+5.5*Pos.gw Pos.yg(4) Pos.gw*2.6 Pos.gh*6];
T.Data=cell(0);


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; 
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
x=Pos.xg; y=Pos.yg;

winpar{1}='IsoDispWin'; winpar{2}='Chrombox Optimizer: Isothermal/Isocratic dispersion';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model_isodisp(99)',3,'','');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');

% Parameterslist
p=p+1;[ui{p,1:8}] = deal('Parameters:','Text',Colors.bc,[x(4) y(9) gw+bw eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Show all','Checkbox',Colors.bc,[x(4)+gw*0.8 y(9) gw+bw eh],'oo_model_isodisp(3.1)',2,'AllParamCheck','-fvp -fh');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(6) gw*0.5+bw gh*3],'oo_model_isodisp(3.3)',2,'ParametersList');

% Velocity list and second var
p=p+1;[ui{p,1:7}] = deal('Mobile phase velocity:','Text',Colors.bc,[x(4) y(3)+gh*2.0 gw*0.5+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3)+gh*1.4 gw*0.5+bw eh],'oo_model_isodisp(11.1)',2,'VelocityPop','-d');
p=p+1;[ui{p,1:7}] = deal('Column length (m):','Text',Colors.bc,[x(4) y(3)+gh*0.6 gw*0.5+bw  eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3) gw*0.5+bw eh],'oo_model_isodisp(11.2)',2,'InterVaryPop','-d');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(1) y(10) bw eh],'oo_model_isodisp(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(1)+gw/2 y(10) bw eh],'oo_model_isodisp(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(2) y(10) bw eh],'oo_model_isodisp(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_model_isodisp(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Show models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_model_isodisp(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Types','PopupMenu',[1 1 1],[x(4)+gw/2 y(10) gw*1.4 eh],'oo_model_isodisp(7.1)',2,'ModelTypePop');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Calc.','Pushbutton',Colors.btn{1},[x(6)+gw/2 y(3) bw  bh],'oo_model_isodisp(4.1)',2,'CalcBtn');
mstr={'Golay (low PD)','Golay (high PD)','Golay (interm. PD)','Golay (C1 & C2)','Van Deemter'};
p=p+1;[ui{p,1:7}] = deal(mstr,'Popupmenu',[1 1 1],[x(6)+gw/2 y(2) gw*1.5  bh],'oo_model_isodisp(4.2)',2,'ModTypePop');

% Figure selection
p=p+1;[ui{p,1:8}] = deal('Plot type:','Text',Colors.bc,[1-x(1)-gw*1.35 y(9) gw*1.25 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Upd:','Pushbutton',Colors.bc,[1-x(1)-gw*1.35+gw*0.45 y(9) gw*0.4 eh],'oo_model_isodisp(5.1)',2,'PlotUpdBtn','-fvp -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','CheckBox',Colors.bc,[1-x(1)-gw*1.35+gw*0.9 y(9) gw*0.4 eh],'',2,'PlotUpdCheck','-fvp -fh');
str={'Design','H/u','Errors','Pred. vs meas.'};
p=p+1;[ui{p,1:8}] = deal(str,'Popupmenu',[1 1 1],[1-x(1)-gw*1.35 y(8)+gh*0.25 gw*1.25 eh],'oo_model_isodisp(5.0)',2,'PlotTypePop','');

% Scale
vp=y(7)+gh*0.4;
p=p+1;[ui{p,1:8}] = deal('X-scale: ','Text',Colors.bc,[1-x(1)-gw*1.2 vp-eh*0.4 gw*0.5 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.7 vp gw*0.3 eh],'oo_model_isodisp(10.1)',2,'XScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.4 vp gw*0.3 eh],'oo_model_isodisp(10.1)',2,'XScaleHighEdit','-c -fh -d');
vp=y(7)-gh*0.4;
p=p+1;[ui{p,1:8}] = deal('Y-scale: ','Text',Colors.bc,[1-x(1)-gw*1.2 vp-eh*0.4 gw*0.5 eh],'',2,'','-r -fh -fvp');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.7 vp gw*0.3 eh],'oo_model_isodisp(10.1)',2,'YScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.4 vp gw*0.3 eh],'oo_model_isodisp(10.1)',2,'YScaleHighEdit','-c -fh -d');

% H/u plot options
vp=y(5)+gh*0.5;
p=p+1;[ui{p,1:8}] = deal('H/u plot options:','Text',Colors.bc,[1-x(1)-gw*0.8 vp gw*0.8 eh],'',2,'','');
vp=vp-gh*0.7; p=p+1;[ui{p,1:8}] = deal('Mean','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_isodisp(95)',2,'ShowVdMeanCheck','');
vp=vp-gh*0.7; p=p+1;[ui{p,1:8}] = deal('Indiv.','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_isodisp(95)',2,'ShowVdIndCheck','');
vp=vp-gh*0.7; p=p+1;[ui{p,1:8}] = deal('Sums','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_isodisp(95)',2,'ShowVdSumCheck','');
vp=vp-gh*0.7; p=p+1;[ui{p,1:8}] = deal('ABC','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_isodisp(95)',2,'ShowVdABCCheck','');
vp=vp-gh*0.7; p=p+1;[ui{p,1:8}] = deal('Observ.','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_isodisp(95)',2,'ShowVdObsCheck','');

% Load / Save
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_model_isodisp(1.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_model_isodisp(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedModelsPop');
p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_model_isodisp(8.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Calc. Val.','Pushbutton',Colors.btn{1},[1-x(1)-bw*1.15 y(1) bw*0.55 eh],'oo_model_isodisp(14)',2,'');

updfcn='oo_model_isodisp(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model_isodisp(96)')
set(h0,'CloseRequestFcn','oo_model_isodisp(99)')

% Multiple selections
FilesList=findobj(gcf,'Tag','DataModelsList'); set(FilesList,'Max',2,'Min',0)
minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off')
end

set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdObsCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdABCCheck'),'Value',1);

set(findobj(gcf,'Tag','CodeRadio','String','Code'),'Value',1)
set(findobj(gcf,'Tag','PlotUpdCheck'),'Value',1)
set(findobj(gcf,'Tag','OptVelCheck'),'Value',1)






