function oo_model_vd(call)
% function oo_model_vd(call)
% ver 230607 SAM
% global Metset Experimental Locset Modset Models

global Metset Experimental Locset Modset Models

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model_vd ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0  
    Experimental=[];
    Models=[];
    Modset=[];
    Modset.listtype=1; % Data
    Modset.codetype=1; % Codes  
    Modset.velocityvar='';
    Modset.interactvar='';
    openwin
    getexperiments
    getmodels
    boxlist
    datalist
end

if call==1.1
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' strs{val} '.mat' ];
    load(pathname,'Experimental')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',strs{val})
    Experimental.activecmp(1:numel(Experimental.codes))=deal(true);
    Experimental.activeexp(1:numel(Experimental.expname))=deal(true);
    Models=[];
    Modset=[]; Modset.listtype=1; Modset.codetype=1; Modset.velocityvar=''; Modset.interactvar=''; Modset.filename=strs{val};
    parameterslist
    boxlist
    listupdate  
    autovelpop
    modeltypes
    Modset.currentplot='Design'; plotupdate
end

% Update parameterslist
if call==3.1
    parameterslist
end
% Change parameter
if call==3.3
    listupdate; plotupdate
end

% Standard surface
if call==4.1
    err=calcmodels;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end
% vdmodels
if call==4.2
    err=vdmodel;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end
if call==4.3
    err=vdintmodel;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end
if call==4.4
    err=logintmodel;
    if err==0 Modset.listtype=2; listupdate; plotupdate; end
end

% Plotting
if call==5.0 || call==5.1
    plotupdate
end

% surftype radios
if call==6.1
    plotupdate
end

if call==7.1
    listupdate; plotupdate
end

if call==8.1
    %disp('--- save model ---')
    if isempty(Models)
        zz_message(1,'No models to save','-r')
    else
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        filename=get(FileNameEdit,'String');
        if isempty(filename)
            zz_message(1,'Select file name','-r')
        else
            Info.modeltype='VD';
            Info.savedtime=now;
            Info.user=Locset.user;
            Info.codeversion=Locset.version;
            pathname=[ Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
            oo_savefile(pathname,Models,Experimental,Modset,Info)
            zz_message(1,['Saved as ' pathname],'-b')
            getmodels
        end    
    end   
end

if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
    S=load(pathname);
    if isfield(S,'Info') && strcmp(S.Info.modeltype,'VD')
       Models=S.Models;
       Experimental=S.Experimental;
       Modset=S.Modset;
       Modset.filename=filename;
       FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
       set(FileNameEdit,'String',filename)
       modeltypes 
       parameterslist
       boxlist
       listupdate  
       modeltypes
       setvelocitypop
       plotupdate
    else
        if isfield(S,'Info') str=[' (' S.Info.modeltype ')']; else str=''; end
        zz_message(1,['Incorrect model type ' str],'-r')
    end
end

% graphical selection, contour plot
if call==9.1
    %disp('--- graphical selection ----')
    [cp]=get(gca,'CurrentPoint'); xp=cp(1,1); yp=cp(1,2);
    checkpoint(xp,yp)
end

if call==9.3
    %disp('--- selected point ---')
    xp=get(gcbo,'XData'); 
    xp=xp(1); 
    yp=get(gcbo,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end
if call==9.35
    %disp('--- selected point ---')
    xp=get(gco,'XData');
    xp=xp(1); 
    yp=get(gco,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end
% Input from edit
if call==9.4
    SelXEdit=findobj(gcf,'Tag','SelXEdit');
    xval=str2double(get(SelXEdit,'String'));
    set(SelXEdit,'String',num2str(xval));
    
    SelYEdit=findobj(gcf,'Tag','SelYEdit');
    yval=str2double(get(SelYEdit,'String'));
    set(SelYEdit,'String',num2str(yval));    
    
    if ~isnan(xval) && ~isnan(yval)
        checkpoint(xval,yval)
    end  
end
if call==9.5
    maha=findobj(gca,'Tag','SelectionMarker');
    if get(gcbo,'Value') set(maha,'Visible','on'); else set(maha,'Visible','off'); end
end
% Point selection in VD all levels
if call==9.6
    Userdat=get(gcbo,'UserData');
    if isfield(Userdat,'Infostr')
        T=tableposname;
        T.Data=Userdat.Infostr;
        T.ViewPref=3;
        T.ColumnWidth{1}=200;
        T.ColumnFormat{1}='char';
        T.ColumnName{1}='Selected:';        
        if zz_tabletool('Exist',T.TableName)
            zz_tabletool('Delete',T.TableName);
        end
        zz_tabletool('Create',T);        
    end
end

% set scale
if call==10.1 
    plotupdate; 
end

% Set velocity and interacting var:
if call==11.1 || call==11.2
    str=get(gcbo,'String'); val=get(gcbo,'Value'); selvar=str{val};
    InterVaryPop=findobj(gcf,'Tag','InterVaryPop');
    VelocityPop=findobj(gcf,'Tag','VelocityPop');
    allpnames=cell(0);
    for x=1:numel(Experimental.paramnames)
        pns=Experimental.paramnames{x};
        for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
    end
    allpnames=unique(allpnames);
    if numel(allpnames)==1 call=-99; end % Skips rest if only one var.
end

if call==11.1
    if strcmp(selvar,Modset.interactvar); Modset.interactvar=Modset.velocityvar; end
    Modset.velocityvar=selvar;
end
if call==11.2
    if strcmp(selvar,Modset.velocityvar); Modset.velocityvar=Modset.interactvar; end
    Modset.interactvar=selvar;
end
if call==11.1 || call==11.2
    setvelocitypop
    PlotTypePop=findobj(gcf,'Tag','PlotTypePop'); str=get(PlotTypePop,'String'); ind=strmatch('Design',str); set(PlotTypePop,'Value',ind); plotupdate
    modeltypes
end

% EVALUATE LISTS
if call==12.1 evalboxlist; end
if call==12.2 evaldatalist; end    
if call==12.3 evalmodelslist; end 

% EVALUATE  A-CHECKS
if call==13.1 && get(gcbo,'Value')
    set(findobj(gcf,'Tag','ZeroACheck'),'Value',0)
    set(findobj(gcf,'Tag','MeanACheck'),'Value',0)
    set(gcbo,'Value',1)
end

% Calculate values
if call==14.0
    calcvalues
end

% Table from userdata
if call==94
    tabfromuserdat
end

% General plotupdate
if call==95
    plotupdate
end

% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end


% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model_vd (update) ----')   
    plotupdate
end

if call==-1
    zz_message(1,'Not implemented','-r')
end

%Modset
%Models
%if ~isempty(Models) 
%    Models(1)
%end
%if numel(Models)>1 
%    Models(2)
%end
%Experimental

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ======================== PLOTTING FUNCTIONS ===========================


% ------------------- plotupdate ---------------------
function plotupdate
global Modset Experimental

%disp('--- plotupdate ---')

zz_busy(1.1)

surfoptvis='off';
vdoptvis='off';

if isfield(Modset,'currentplot') currentplot=Modset.currentplot; else currentplot='Dummy'; end

% validplots
% 'Design','Surface','VD all levels','VD single level','Errors','Pred. vs meas.'
validplots={'Design'}; defaultplot={'Design'}; % always valid 

if isfield(Modset,'currentmodeltype')
    if strcmp(Modset.currentmodeltype,'VD')
        validplots={'Design','VD single level','Errors','Pred. vs meas.'};
        defaultplot='VD single level';
    end  
    if strncmp(Modset.currentmodeltype,'VD ',3)
        validplots={'Design','VD all levels','VD single level','Errors','Pred. vs meas.'};
        defaultplot='VD single level';
    end    
    if strcmp(Modset.currentmodeltype,'Quad+Int')
        validplots={'Design','Surface','Errors','Pred. vs meas.'};
        defaultplot='Surface';
    end
    if strcmp(Modset.currentmodeltype,'Log+Int')
        validplots={'Design','Surface','Errors','Pred. vs meas.'};
        defaultplot='Surface';
    end    
    if strcmp(Modset.currentmodeltype,'VD+Int')
        validplots={'Design','VD all levels','Surface','Opt. velocity','Errors','Pred. vs meas.'};
        defaultplot='Surface';
   end
end

PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
plotoptions=get(PlotTypePop,'String');
val=get(PlotTypePop,'Value');
selplot=plotoptions{val};
if isempty(strmatch(selplot,validplots))
    if strcmp('PlotTypePop',get(gcbo,'Tag')) 
        if isfield(Modset,'currentmodeltype') zz_message(1,[selplot ' is not a valid plot option for models of type ' Modset.currentmodeltype],'-r'); end
        selplot=currentplot;
    else
        selplot=defaultplot;
    end
end

% if designplot and new models
btnstr={'QuadIntBtn','TimeModBtn','VDIntBtn','VDBtn'};
if ~isempty(get(gcbo,'Tag')) && ~isempty(strmatch(get(gcbo,'Tag'),btnstr))
    selplot=defaultplot;
end

if isempty(Experimental)
    plot_dummy('No data'); Modset.currentplot='Dummy'; return
end
if strcmp(selplot,'Design')
    plot_design; 
end
if strcmp(selplot,'Errors')
    Estruct=calc_errors;
    oo_plot_errors(Estruct)
end
if strcmp(selplot,'Pred. vs meas.')
    Estruct=calc_errors;
    oo_plot_predmeas(Estruct)
end
if strcmp(selplot,'Surface')
    plot_surface; 
    surfoptvis='on';
    tabfromuserdat
end
if strcmp(selplot,'Opt. velocity')
    plot_optvel; 
    %surfoptvis='on';
    %tabfromuserdat
end


if strcmp(selplot,'VD single level')
    plot_vd_single; 
    vdoptvis='on';
    tabfromuserdat
end
if strcmp(selplot,'VD all levels') && ~strncmp('VD+',Modset.currentmodeltype,3)
    plot_vd_multiple; 
    vdoptvis='on';
    tabfromuserdat
end
if strcmp(selplot,'VD all levels') && strncmp('VD+',Modset.currentmodeltype,3)
    plot_vd_est; 
    vdoptvis='on';
    tabfromuserdat
end

Modset.currentplot=selplot;
setval=strmatch(Modset.currentplot,plotoptions);
if ~isempty(setval) set(PlotTypePop,'Value',setval); end

% Update surface options visibility
set(findobj(gcf,'Tag','SurfTypePop'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','SelXYText'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','OptVelCheck'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','SelXEdit'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','SelYEdit'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','ShowSelCheck'),'Visible',surfoptvis)
set(findobj(gcf,'Tag','SurfTypeTxt'),'Visible',surfoptvis)

set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Visible',vdoptvis)
set(findobj(gcf,'Tag','ShowVdIndCheck'),'Visible',vdoptvis)
set(findobj(gcf,'Tag','ShowVdSumCheck'),'Visible',vdoptvis)
set(findobj(gcf,'Tag','ShowVdABCCheck'),'Visible',vdoptvis)
set(findobj(gcf,'Tag','ShowVdObsCheck'),'Visible',vdoptvis)

zz_busy(0.1)

% ------------------- plot_design ---------------------
function plot_design
global Pos

[setscale,xl,yl]=readsetscale;

Calibdata=calibdata;

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

subplot('Position',Pos.rightplot)

if ~isempty(Calibdata.X)
    
    [n_exp,n_factors]=size(Calibdata.X); 
    if n_factors<2 Calibdata.X(1:n_exp,2)=0; end
    
    if setscale      
        xl=[min(Calibdata.X(:,1)) max(Calibdata.X(:,1))];
        yl=[min(Calibdata.X(:,2)) max(Calibdata.X(:,2))];
        xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
        yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;
    end
    
    [m,n]=size(Calibdata.X);
    for x=1:m
    
        h=plot(Calibdata.X(x,1),Calibdata.X(x,2),'o','MarkerSize',18,'MarkerFaceColor',[0.8 0.8 0.8],'MarkerEdgeColor',[0.6 0.6 0.6],'LineWidth',3);
        text(Calibdata.X(x,1),Calibdata.X(x,2),num2str(Calibdata.expno(x)),'HorizontalAlignment','Center','FontWeight','bold')
        hold on
    end
    hold off
    
    setlims(xl,yl)
    
else
    text(0,0,'No data','HorizontalAlignment','Center','FontSize',18,'FontWeight','bold')
    xlim([-1 1]); ylim([-1 1]);
end

set(gca,'Tag','DesignPlot')
zz_copyfigure

% Delete table
T=tableposname;
if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end

% ------------------- plot_dummy ---------------------
function plot_dummy(str)
global Pos 

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
ah=subplot('Position',Pos.rightplot);
set(ah,'XTick',[],'YTick',[])
text(0.5,0.5,str,'Units','Normalized','HorizontalAlignment','center',...
    'VerticalAlignment','middle','FontWeight','bold','FontSize',12)
setlims([],[])
xlim([-1 1]); ylim([-1 1])


% ------------------- plot_surface ---------------------
function plot_surface
global Models Experimental Modset Pos

%disp('--- plot_surface ---')

[setscale,xl,yl]=readsetscale;

if ~isfield(Modset,'currentmodel') return; end

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

modno=Modset.currentmodel;
typematch=strmatch(Models(modno).modeltype,{'Quad+Int','Log+Int','VD+Int'},'exact');
if isempty(typematch) plot_dummy('Models cannot be shown as surface'); return; end % Wrong model type

selcmp=find(Experimental.activecmp);
if isempty(selcmp) plot_dummy('No compounds selected'); return; end

varname=getvarname;

if isfield(Models,varname)
    l_models=length(Models(modno).(varname));
else
    plot_dummy('No valid models selected');
    return
end

missingmodels=[]; validmodels=[]; n_valids=0; ZM=[]; ZM_sum=[]; alldesign=[]; 
for x=1:length(selcmp)
    cmp=selcmp(x); coeff=[]; design=[]; % initialization

    if cmp<=l_models
        coeff=Models(modno).(varname){cmp};
        if isfield(Models(modno),[varname '_design']) && numel(Models(modno).([varname '_design']))>=cmp
            design=Models(modno).([varname '_design']){cmp};
        end
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        validmodel=1;
        
        if setscale
            xl=[min(design(1,:)) max(design(1,:))];
            yl=[min(design(2,:)) max(design(2,:))];
            xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
            yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;
        end

        [X_cont,Y_cont,Z_cont]=calcsurf(coeff,xl,yl,typematch);
    else
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end

    if validmodel              
        n_valids=n_valids+1;
        alldesign=[alldesign design];
        validmodels(n_valids)=cmp; 
        if n_valids==1
            ZM_sum=Z_cont;
            ZM_max=Z_cont;
            ZM_min=Z_cont;
        else
            ZM_sum=ZM_sum+Z_cont; % sum
            ZM_max=max(ZM_max,Z_cont); % max
            ZM_min=min(ZM_min,Z_cont); % min
        end  
        CM(n_valids,:)=coeff'; % Save coefficients, used for optimal velocity
    end
end

if isempty(ZM_sum)==0   
    SurfTypePop=findobj(gcf,'Tag','SurfTypePop');
    Str=get(SurfTypePop,'String');
    surftype=Str{get(SurfTypePop,'Value')};
    
    if strcmp(surftype,'Mean')
        ZM=ZM_sum/n_valids;
        HeaderText{3}='Mean surface of:';
    end
    if strcmp(surftype,'Sum')
        ZM=ZM_sum;
        HeaderText{3}='Sum surface of:';
    end    
    if strcmp(surftype,'Max')
        ZM=ZM_max;
        HeaderText{3}='Max surface of:';
    end  
    if strcmp(surftype,'Min')
        ZM=ZM_min;
        HeaderText{3}='Min surface of:';
    end   
    
    alldesign=unique(alldesign','rows')'; 
    contourplot(X_cont,Y_cont,ZM,alldesign)  
    

    % Adds data to Modset.lasteffcont and Modset.lasttimecont
    if strcmp(varname,'wbl_ri_exp')
        Modset.lasteffcont.X=X_cont; Modset.lasteffcont.Y=Y_cont; Modset.lasteffcont.Z=ZM; 
        Modset.lasteffcont.varname=varname; Modset.lasteffcont.surftype=surftype;
        Modset.lasteffcont.modeltype=Models(modno).modeltype;
        switch Modset.codetype
            case 1; Modset.lasteffcont.cmplabs=Experimental.codes(selcmp);
            case 2; Modset.lasteffcont.cmplabs=Experimental.names(selcmp);
            case 3; Modset.lasteffcont.cmplabs=Experimental.shortnames(selcmp);
        end
        Modset.lasteffcont.alldesign=alldesign;
    end
    if strcmp(varname,'rt_exp')
        Modset.lasttimecont.X=X_cont; Modset.lasttimecont.Y=Y_cont; Modset.lasttimecont.Z=ZM; 
        Modset.lasttimecont.varname=varname; Modset.lasttimecont.surftype=surftype;
        Modset.lasttimecont.modeltype=Models(modno).modeltype;
        switch Modset.codetype
            case 1; Modset.lasttimecont.cmplabs=Experimental.codes(selcmp);
            case 2; Modset.lasttimecont.cmplabs=Experimental.names(selcmp);
            case 3; Modset.lasttimecont.cmplabs=Experimental.shortnames(selcmp);
        end
        Modset.lasttimecont.alldesign=alldesign;
    end        
    
    % Add line for Optimal Velocity
    if strcmp(varname,'wbl_ri_exp') && get(findobj(gcf,'Tag','OptVelCheck'),'Value') && strcmp(Models(modno).modeltype,'VD+Int')
        CC=mean(CM,1); I=Y_cont(1,:); B=CC(2); C=CC(3); E=CC(5); F=CC(6);
        ov=((B+E*I)./(C+F*I)).^0.5; % Vector of optimal velocity  
        hold on
        vstr='Vel.'; if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar) vstr=Modset.velocityvar; end
        istr='I'; if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar) istr=Modset.interactvar; end
        
        tstr=['Opt.' vstr ' = root('];
        if E~=0 tstr=[tstr '(' num2str(B,3) '+' num2str(E,3) char(215) istr ')/']; else tstr=[tstr num2str(B,3)  '/' ]; end
        if F~=0 tstr=[tstr '(' num2str(C,3) '+' num2str(F,3) char(215) istr '))']; else tstr=[tstr num2str(C,3)  ')' ]; end
        UserDat.text=tstr;
        plot(ov,I,'-','Color',[0.5 0.5 0.5],'LineWidth',2,'Tag','OptvelLine','ButtonDownFcn','oo_model_vd(9.3)','UserData',UserDat);
        hold off
    end

    % set userdata
    Userdat.plottype='surface';
    Userdat.modeltype=Models(modno).modeltype;
    %set(gca,'UserData',Userdat); 
           
    % set text box
    HeaderText{1}=['Model type: ' Models(modno).modeltype];
    ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
    HeaderText{2}=['Variable:' str{val}];   
    if ~isempty(validmodels)
        switch Modset.codetype
            case 1; cmplabs=Experimental.codes;
            case 2; cmplabs=Experimental.names;
            case 3; cmplabs=Experimental.shortnames;
        end
        for x=1:numel(validmodels) 
            Data(x,1)=cmplabs(validmodels(x));
        end        
    end
  
    T=tableposname;
    T.Data=Data;
    T.RowName=[];
    T.ColumnName=[];
    T.ViewPref=3;
    T.ColumnFormat{1}='char';
    T.ColumnWidth{1}=60;
    T.HeaderText=HeaderText;
    
    Userdat.T=T; % Attatch table as UserData
    
    set(gca,'UserData',Userdat,'ButtonDownFcn','oo_model_vd(94)'); 
       
    str=[];
    if ~isempty(missingmodels)
        str=['- Missing models: '];
        for x=1:length(missingmodels)
            str=[str num2str(missingmodels(x)) ' '];
        end
    end
    if isempty(str)
        zz_message(1,'No missing values','-b')
    else
        zz_message(1,[str],'-r')
    end  
    
    setlims(xl,yl)
     
else 
    plot_dummy('No valid models selected');
end


% ------------------- plot_optvel ---------------------
function plot_optvel
global Models Experimental Modset Pos Metset

[setscale,xl,yl]=readsetscale;

Calibdata=calibdata;

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

subplot('Position',Pos.rightplot)

% Dummyplots
varname=getvarname;
if ~strcmp(varname,'wbl_ri_exp')
    plot_dummy('Variable must be peak width in RI units');
    return
end
modno=Modset.currentmodel;
if isfield(Models,varname)
    l_models=length(Models(modno).(varname));
else
    plot_dummy('No valid models selected');
    return
end

selcmp=find(Experimental.activecmp);
if isempty(selcmp) plot_dummy('No compounds selected'); return; end

% Get data 
missingmodels=[]; validmodels=[]; n_valids=0; ZM=[]; ZM_sum=[]; alldesign=[]; 
for x=1:length(selcmp)
    cmp=selcmp(x); coeff=[]; design=[]; % initialization

    if cmp<=l_models
        coeff=Models(modno).(varname){cmp};
        if isfield(Models(modno),[varname '_design']) && numel(Models(modno).([varname '_design']))>=cmp
            design=Models(modno).([varname '_design']){cmp};
        end
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        validmodel=1;
        
        if setscale
            xl=[min(design(1,:)) max(design(1,:))];
            yl=[min(design(2,:)) max(design(2,:))];
            xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
            yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;
        end

    else
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end

    if validmodel              
        n_valids=n_valids+1;
        alldesign=[alldesign design];
        validmodels(n_valids)=cmp; 

        CM(n_valids,:)=coeff'; % Save coefficients, used for optimal velocity
        
    end
end

if isempty(validmodels)
    plot_dummy('No valid models selected');
    return    
end

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Get colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

% Plot design
design=unique(alldesign','rows')';
if Metset.contour_showdesign && ~isempty(design)
    [m,n_points]=size(design);
    for x=1:n_points
        plot(design(1,x),design(2,x),'o',...
            'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
            'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model_vd(9.3)')    
        hold on
    end
end

% Vertical text position
vpos = linspace(0.95,0.05,max([20 numel(validmodels)]));
iv = linspace(yl(1),yl(2),100);
for modno=1:numel(validmodels)    
    b=CM(modno,2); c=CM(modno,3); e=CM(modno,5); f=CM(modno,6);
    ov=((b+e*iv)./(c+f*iv)).^0.5; % Vector of optimal velocity      
    plot(ov,iv,'LineWidth',2,'Color',cols(validmodels(modno),:)); hold on    
    text(0.95,vpos(modno),cmplab{validmodels(modno)},'Units','normalized',...
        'HorizontalAlignment','right','FontWeight','bold','Color',cols(validmodels(modno),:))   
end
   
setlims(xl,yl)

set(gca,'Tag','PlotOptVel')
% Use if table attached as userdata
%set(gca,'Tag','PlotOptVel','UserData',UserData,'ButtonDownFcn','oo_model_vd(94)')
zz_copyfigure

% Delete table
T=tableposname;
if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end


% ------------------- plot_vd_est ---------------------
function plot_vd_est
global Models Experimental Modset Pos

[setscale,xl,yl]=readsetscale;

% Check for validity
activecmp=find(Experimental.activecmp);
if isempty(activecmp) plot_dummy('No compounds selected'); return; end
if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); return; end
varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

% Set variables for plot type
set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdIndCheck'),'Value',0);
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 

for x=1:numel(Models) modeltypes{x}=Models(x).modeltype; end
modind=strmatch('VD+Int',modeltypes);
if isempty(modind) plot_dummy('No VD+Int models'); return; end

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Find models
activecmp=Experimental.activecmp;
if sum(activecmp)==0 plot_dummy('No compounds selected'); return; end % nothing selected

varname=getvarname;

% Get model data and constrain to valid models
p=0;
for x=1:numel(Models(modind).(varname))
    c=Models(modind).(varname){x};
    if activecmp(x) && sum(isnan(c))==0 && numel(c)==7
        p=p+1;
        Coeff{p}=Models(modind).(varname){x};
        Labels(p)=cmplab(x);
        Designs{p}=Models(modind).([varname '_design']){x};
        Predmeas{p}=Models(modind).([varname '_predmeas']){x}; % first row in predmeas is measured
    end      
end

% Find the correct designpoints (xp and yp)
xp=[]; yp=[]; 
if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar)
    velname=Modset.velocityvar;
    for p=1:numel(Experimental.paramnames)
        xind=strmatch(velname,Experimental.paramnames{p}); xind=xind(1);
        xp(p)=Experimental.parameters(xind,p);
    end   
    xp=xp(Experimental.activeexp);
end
if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar)
    intname=Modset.interactvar;
    for p=1:numel(Experimental.paramnames)
        yind=strmatch(intname,Experimental.paramnames{p}); yind=yind(1);
        yp(p)=Experimental.parameters(yind,p);
    end 
    yp=yp(Experimental.activeexp);
    
end

ylevels=unique(yp); if isempty(ylevels) ylevels=0; end

% Estimate A, B and C terms
for lno=1:numel(ylevels)
    meas=[]; lev=[]; xvals=[];  % Initialize variables for saving avg of observations
    for p=1:numel(Coeff)
        c=Coeff{p};
        A_terms(p)=c(1)+c(4)*ylevels(lno)+c(7)*ylevels(lno)^2;
        B_terms(p)=c(2)+c(5)*ylevels(lno);
        C_terms(p)=c(3)+c(6)*ylevels(lno);
        
        % Variables for saving avg of observations
        meas=[meas Predmeas{p}(1,:)];
        lev=[lev Designs{p}(2,:)];
        xvals=[xvals Designs{p}(1,:)];
        
    end
    A_means(lno)=mean(A_terms);
    B_means(lno)=mean(B_terms);
    C_means(lno)=mean(C_terms);
    
    % Saves data for plotting of observed values
    levind=lev==ylevels(lno); % Finds data with right levels
    xvals=xvals(levind); meas=meas(levind); % Constrains
    uniquex=unique(xvals); meanmeas=[];
    for x=1:numel(uniquex)
        ind=find(xvals==uniquex(x));
        measind=meas(ind);
        measind(isnan(measind))=[]; % removes NaNs
        meanmeas(x)=mean(measind);    
    end
    Observ{lno}=[uniquex; repmat(ylevels(lno),1,numel(uniquex)); meanmeas]; % Saves observations for later use
end

% Constructs x-axis
if setscale
    xl=[min(xp) max(xp)];
    xo=(xl(2)-xl(1))/10;
    xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
end
x_axis=linspace(xl(1),xl(2),100);
x_axis_inv=1./x_axis;

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(ylevels)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

ah=subplot('Position',Pos.rightplot); 
for modno=1:numel(ylevels)
    A=repmat(A_means(modno),1,numel(x_axis));
    B=B_means(modno)*x_axis_inv;
    C=C_means(modno)*x_axis;
    S=(A+B+C);
    if showabc
        plot(x_axis,[A;B;C],'Color',cols(modno,:)); hold on
    end
    if showsum
        plot(x_axis,S,'Color',cols(modno,:),'LineWidth',2); hold on
    end    
    optivel(modno)=(B_means(modno)/C_means(modno))^0.5;       
    yminv(modno)=A_means(modno)+B_means(modno)/optivel(modno)+C_means(modno)*optivel(modno);
    
    if showpoints
        Infotempl(7:numel(Labels)+6,1)=deal(Labels(1:numel(Labels)));
        %plot(Observ{modno}(1,:),Observ{modno}(3,:),'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',cols(modno,:))
        for pno=1:numel(Observ{modno}(1,:))           
            xvalue=Observ{modno}(1,pno);
            calcvalue=A_means(modno)+B_means(modno)/xvalue+C_means(modno)*xvalue;
            Userdat.Infostr=Infotempl;
            Userdat.Infostr(1:6)=deal({[Modset.velocityvar ': ' num2str(xvalue)]; ...
                [Modset.interactvar ': ' num2str(Observ{modno}(2,pno))]; ...
                ['Mean measured: ' num2str(Observ{modno}(3,pno),4)]; ...
                ['Calculated: ' num2str(calcvalue,4)] ; ...
                ['Deviation: ' num2str(calcvalue-Observ{modno}(3,pno),2)]; ...
                'Included compounds:'});        
            plot(Observ{modno}(1,pno),Observ{modno}(3,pno),'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',cols(modno,:),'UserData',Userdat,'ButtonDownFcn','oo_model_vd(9.6)') 
        end
    end              
end
hold off
text(0.5,0.95,'Calculated from VD+Int model','Units','Normalized','HorizontalAlignment','Center','FontSize',12,'FontWeight','bold')

% Scaling and labels
if setscale
    axis tight
    yl=get(ah,'ylim');
    if yl(1)>0
        yl(1)=0;
    else
        yl(1)=yl(1)-(yl(2)-yl(1))*0.05;
    end
    yl(2)=yl(2)+(yl(2)-yl(1))*0.02;
end

setlims(xl,yl)

% labels
texthp=xl(2)+(xl(2)-xl(1))*0.02;
textvp=linspace(yl(2)*0.98,0,max([20 numel(ylevels)+1]));
textext=[];
if isfield(Modset,'interactvar') str=Modset.interactvar; else str=''; end
for modno=1:numel(ylevels)
    th=text(texthp,textvp(modno),[str '=' num2str(ylevels(modno))],'Color',cols(modno,:),'FontWeight','bold','FontSize',12);
    ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
end
xlim([xl(1) xl(2)+(xl(2)-xl(1))*0.02+(max(textext)*1.5)])

% Text
if isfield(Modset,'interactvar') str=Modset.interactvar; else str=''; end
if isfield(Modset,'velocityvar') str2=Modset.velocityvar; else str2=''; end
for modno=1:numel(ylevels)
    Data{modno,1}=A_means(modno); Data{modno,2}=B_means(modno); Data{modno,3}=C_means(modno); Data{modno,4}=optivel(modno); Data{modno,5}=yminv(modno);
    RowName{modno}=[str '=' num2str(ylevels(modno))];
end
ColumnName={'A','B','C',['Opt ' str2],'Min y'};

% Table
T=tableposname;
T.Data=Data;
T.RowName=RowName;
T.ColumnName=ColumnName;
T.ViewPref=3;
T.ColumnFormat={4,4,4,4,4};
T.HeaderText{1}='Mean VD models calculated from VD+INT';
T.FooterText{1}='Applied compounds:';
nl=2; T.FooterText{2}='';
for x=1:numel(Labels)
    T.FooterText{nl}=[T.FooterText{nl} ' ' Labels{x}];
    if numel(T.FooterText{nl}) > 15
        nl=nl+1; T.FooterText{nl}='';
    end    
end
UserData.T=T; % Attach table as userdata

set(gca,'Tag','PlotVDEst','UserData',UserData,'ButtonDownFcn','oo_model_vd(94)')
zz_copyfigure


% ------------------- plot_vd_multiple ---------------------
function plot_vd_multiple
global Models Experimental Modset Pos

[setscale,xl,yl]=readsetscale;

% Check for validity
activecmp=find(Experimental.activecmp);
if isempty(activecmp) plot_dummy('No compounds selected'); return; end
if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); return; end
varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end


eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

% Check model type
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modtypes=get(ModelTypePop,'String');
modtype=modtypes{get(ModelTypePop,'Value')};
if ~strncmp(modtype,'VD',2) plot_dummy('Incorrect model type'); return; end % Wrong type

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

for x=1:numel(Models)
    modeltypes{x}=Models(x).modeltype;
end
teststr=['VD ' Modset.interactvar];
validmodels=strmatch(teststr,modeltypes);
if isempty(validmodels) plot_dummy('No VD models'); return; end

% Set variables for plot type
set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdIndCheck'),'Value',0);
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 

% Check levels
for modno=1:numel(validmodels)
    nmod=0; varname=getvarname; P=[];
    paramcell=Models(validmodels(modno)).(varname);
    designcell=Models(validmodels(modno)).([varname '_design']);
    predmeascell=Models(validmodels(modno)).([varname '_predmeas']);
    
    meas=[]; xvals=[]; yvals=[];  % Initialize variables for saving avg of observations
    
    for x=1:numel(activecmp)
        if numel(paramcell)>=activecmp(x) && ~isempty(paramcell{activecmp(x)}) && numel(paramcell{activecmp(x)})==3 && sum(isnan(paramcell{activecmp(x)}))==0
            nmod=nmod+1;           
            DM=designcell{activecmp(x)};
            minv(nmod)=min(DM(1,:));
            maxv(nmod)=max(DM(1,:));
            P(nmod,:)=paramcell{activecmp(x)};
            labels{modno,nmod}=cmplab{activecmp(x)};
            % Calculation of measured
            meas=[meas predmeascell{activecmp(x)}(1,:)];
            xvals=[xvals designcell{activecmp(x)}(1,:)];
            yvals=[yvals designcell{activecmp(x)}(2,:)];
        end
    end
    
    if nmod==0 plot_dummy('No valid models selected'); return; end
    
    % Saves observations
    [uniquex,uind]=unique(xvals); uniquey=yvals(uind);
    for x=1:numel(uniquex)
        ind=find(xvals==uniquex(x)); 
        measind=meas(ind);
        measind(isnan(measind))=[]; % removes NaNs
        meanmeas(x)=mean(measind);
    end
    Observ{modno}=[uniquex; uniquey; meanmeas]; % Saves observations for later use

    nanind=find(sum(isnan(P),2)); 
    if ~isempty(nanind) P(nanind,:)=[]; labels{modno,nanind}=''; end 
    parameters{modno}=mean(P,1); % parameters stored here
end

% Constructs x-axis
if setscale
    xl=[min(min(minv)) max(max(maxv))];
    xo=(xl(2)-xl(1))/10;
    xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
end
    
x_axis=linspace(xl(1),xl(2),100);
x_axis_inv=1./x_axis;

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(validmodels)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

ah=subplot('Position',Pos.rightplot); 
for modno=1:numel(validmodels)
    modlabels=labels(modno,:); ind=~cellfun('isempty',modlabels); modlabels=modlabels(ind)';
    Infotempl(7:numel(modlabels)+6)=deal(modlabels(1:numel(modlabels)));
    
    param=parameters{modno};
    if ~isempty(param) && sum(isnan(param))==0
        A=repmat(param(1),1,numel(x_axis));
        B=param(2)*x_axis_inv;
        C=param(3)*x_axis;
        S=(A+B+C);
        if showabc
            plot(x_axis,[A;B;C],'Color',cols(modno,:)); hold on
        end
        if showsum
            plot(x_axis,S,'Color',cols(modno,:),'LineWidth',2); hold on
        end    
        if showpoints           
           oxv=Observ{modno}(1,:);
           oyv=Observ{modno}(3,:);
           oev=Observ{modno}(2,:);
           for pn=1:numel(oxv)
               calcval=param(1)+param(2)/oxv(pn)+param(3)*oxv(pn);
               Userdat.Infostr=(Infotempl)';
               Userdat.Infostr(1:6)=deal({[Modset.velocityvar ': ' num2str(oxv(pn))]; ...
                   [Modset.interactvar ': ' num2str(oev(pn))]; ...
                   ['Mean measured: ' num2str(oyv(pn),4)]; ...
                   ['Calculated: ' num2str(calcval,4)] ; ...
                   ['Deviation: ' num2str(oyv(pn)-calcval,2)] ; ...
                   'Included compounds:'});

               plot(oxv(pn),oyv(pn),'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',cols(modno,:),'UserData',Userdat,'ButtonDownFcn','oo_model_vd(9.6)')
                  
           end
           
        end  
        optivel(modno)=(param(2)/param(3))^0.5;
    end 
end
text(0.5,0.95,'Independent VD models','Units','Normalized','HorizontalAlignment','Center','FontSize',12,'FontWeight','bold')
hold off

if setscale
    axis tight
    yl=get(ah,'ylim');
    if yl(1)>0
        yl(1)=0;
    else
        yl(1)=yl(1)-(yl(2)-yl(1))*0.05;
    end
    yl(2)=yl(2)+(yl(2)-yl(1))*0.02;
end

setlims(xl,yl)

% labels
texthp=xl(2)+(xl(2)-xl(1))*0.02;
textvp=linspace(yl(2)*0.98,0,max([20 nmod+1]));
textext=[];
for modno=1:numel(validmodels)
    str=Models(validmodels(modno)).modeltype;
    th=text(texthp,textvp(modno),str(4:end),'Color',cols(modno,:),'FontWeight','bold','FontSize',12);
    ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
end
xlim([xl(1) xl(2)+(xl(2)-xl(1))*0.02+(max(textext)*1.5)])

% Text
HeaderText{1}='Mean VD models';
[m,n_cmp]=size(labels);
for modno=1:numel(validmodels)
    param=parameters{modno};
    yminv=param(1)+param(2)/optivel(modno)+param(3)*optivel(modno);   
    Data{modno,1}=param(1); Data{modno,2}=param(2); Data{modno,3}=param(3); Data{modno,4}=optivel(modno); Data{modno,5}=yminv;
    RowName{modno}=['M' num2str(modno)];
    HeaderText{modno+1}=['M' num2str(modno) ': ' Models(validmodels(modno)).modeltype(4:end) ' = ' num2str(optivel(modno),4)]; 
    
end

alllabels=labels;
alllabels(cellfun('isempty',alllabels))={''};
alllabels=unique(alllabels); alllabels(cellfun('isempty',alllabels))=[];
for modno=1:numel(validmodels)
    ostr2{1,modno+1}=[Models(validmodels(modno)).modeltype(4:end) '  ']; 
    usedcmp=labels(modno,:);
    usedcmp(cellfun('isempty',usedcmp))=[];
    for x=1:numel(alllabels)
        ind=strmatch(alllabels{x},usedcmp,'exact');
        if isempty(ind) pmat(x,modno)=1; else pmat(x,modno)=0; end % 1 demotes misssing compund
    end
end
for x=1:numel(alllabels)
    if any(pmat(x,:))
        str='(';
        for y=1:numel(pmat(x,:))
             if ~pmat(x,y)
                 str=[str 'M' num2str(y)];
             end            
        end
        str=[str ')'];
        alllabels{x}=[alllabels{x} str];
    end 
end

if isfield(Modset,'velocityvar') str2=Modset.velocityvar; else str2='u'; end
T=tableposname;
T.Data=Data;
T.RowName=RowName;
T.ColumnName={'A','B','C',['Opt ' str2],'Min y'};
T.ViewPref=3;
T.ColumnFormat={4,4,4,4,4};
%T.ColumnWidth=60;
T.HeaderText=HeaderText;
T.FooterText{1}='Applied compounds:';
nl=2; T.FooterText{2}='';
for x=1:numel(alllabels)
    T.FooterText{nl}=[T.FooterText{nl} ' ' alllabels{x}];
    if numel(T.FooterText{nl}) > 15
        nl=nl+1; T.FooterText{nl}='';
    end
    
end
UserData.T=T;    

set(gca,'Tag','VD all levels','UserData',UserData','ButtonDownFcn','oo_model_vd(94)')
zz_copyfigure


% ------------------- plot_vd_single ---------------------
function plot_vd_single
global Models Experimental Modset Pos

[setscale,xl,yl]=readsetscale;

% Check for validity
activecmp=find(Experimental.activecmp);
if isempty(activecmp) plot_dummy('No compounds selected'); return; end
if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); return; end
varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Check model type
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modtypes=get(ModelTypePop,'String');
modtype=modtypes{get(ModelTypePop,'Value')};
if ~strncmp(modtype,'VD',2) plot_dummy('Incorrect model type'); return; end % Wrong type

% Set variables for plot type
showmean=get(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value');
showind=get(findobj(gcf,'Tag','ShowVdIndCheck'),'Value');
if showmean+showind==0 showmean=1; set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1); end
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end

modno=findmodels(modtype); % model number

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

% Check levels
nmod=0; varname=getvarname; P=[];
paramcell=Models(modno).(varname);
designcell=Models(modno).([varname '_design']);
predmeascell=Models(modno).([varname '_predmeas']);
for x=1:numel(activecmp)
    if numel(paramcell)>=activecmp(x) && ~isempty(paramcell{activecmp(x)}) && numel(paramcell{activecmp(x)})==3 && sum(isnan(paramcell{activecmp(x)}))==0
        nmod=nmod+1;
        PlotColor(nmod,:)=cols(activecmp(x),:);
        P(nmod,:)=paramcell{activecmp(x)};
        
        DM=designcell{activecmp(x)}; 
        Designpoints{nmod}=DM(1,:);
        minv(nmod)=min(DM(1,:));
        maxv(nmod)=max(DM(1,:));
        
        PM=predmeascell{activecmp(x)}; Measpoints{nmod}=PM(1,:); % Measured for plotting        
        labels{nmod}=cmplab{activecmp(x)};
    end
end

if nmod==0 plot_dummy('No valid models selected'); return; end

% Constructs x-axis
if setscale
    xl=[min(min(minv)) max(max(maxv))];
    xo=(xl(2)-xl(1))/10;
    xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
end  
x_axis=linspace(xl(1),xl(2),100);
x_axis_inv=1./x_axis;

% Calculate matrices
A=repmat(P(:,1),1,numel(x_axis)); mina=min(min(A)); maxa=max(max(A)); mean_A=mean(A,1);
B=P(:,2)*x_axis_inv; minb=min(min(B)); maxb=max(max(B)); mean_B=mean(B,1);
C=P(:,3)*x_axis; minc=min(min(C)); maxc=max(max(C)); mean_C=mean(C,1);
S=A+B+C; mins=min(min(S)); maxs=max(max(S)); mean_S=mean(S,1);
miny=min([mina minb minc mins]); maxy=max([maxa maxb maxc maxs]);

% Plotting
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 
ah=subplot('Position',Pos.rightplot); 
if showind
    for x=1:nmod            
        if showabc 
            plot(x_axis,A(x,:),'Color',PlotColor(x,:),'LineWidth',1); hold on; 
            plot(x_axis,B(x,:),'Color',PlotColor(x,:),'LineWidth',1);
            plot(x_axis,C(x,:),'Color',PlotColor(x,:),'LineWidth',1);
        end
        if showsum 
            plot(x_axis,S(x,:),'Color',PlotColor(x,:),'LineWidth',2); hold on
        end
        if showpoints
            if numel(Designpoints{x})==numel(Measpoints{x})
                %Designpoints{x}
                for pno=1:numel(Designpoints{x})
                    %Labels
                    vel=Designpoints{x}(pno);
                    calcval=P(x,1)+P(x,2)/vel+P(x,3)*vel;
                    Userdat.Infostr{1,1}=labels{x};
                    Userdat.Infostr{2,1}=[Modset.velocityvar ': ' num2str(vel)];
                    Userdat.Infostr{3,1}=['Measured: ' num2str(Measpoints{x}(pno),4)];
                    Userdat.Infostr{4,1}=['Calculated: ' num2str(calcval,4)];
                    Userdat.Infostr{5,1}=['Deviation: ' num2str(calcval-Measpoints{x}(pno),2)];
                    plot(vel,Measpoints{x}(pno),'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',PlotColor(x,:),'UserData',Userdat,'ButtonDownFcn','oo_model_vd(9.6)');
                end
            end
        end   
    end
end

if showmean
    if showabc
        plot(x_axis,mean_A,'Color',[0 0 0],'LineWidth',3);  hold on
        plot(x_axis,mean_B,'Color',[0 0 0],'LineWidth',3);
        plot(x_axis,mean_C,'Color',[0 0 0],'LineWidth',3);
    end
    if showsum 
        plot(x_axis,mean_S,'Color',[0 0 0],'LineWidth',4); hold on
    end    
    if showpoints
        design=[]; for x=1:nmod design=[design Designpoints{x}]; end; design=unique(design);
        for dno=1:numel(design)
            vals=[];
            for modno=1:nmod
                meas=Measpoints{modno}; ind=find(Designpoints{nmod}==design(dno)); 
                if ~isempty(ind) ind=ind(1); vals=[vals meas(ind)]; end
            end
            vals(isnan(vals))=[]; meanvals(dno)=mean(vals);
        end
        plot(design,meanvals,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',[0 0 0])
    end
end
hold off

if setscale
    axis tight
    yl=get(ah,'ylim');
    if yl(1)>0
        yl(1)=0;
    else
        yl(1)=yl(1)-(yl(2)-yl(1))*0.05;
    end
    yl(2)=yl(2)+(yl(2)-yl(1))*0.02;
end

setlims(xl,yl)

texthp=xl(2)+(xl(2)-xl(1))*0.02;
textvp=linspace(yl(2)*0.98,0,max([20 nmod+1]));
textext=[];

if showind && nmod>1
    for x=1:nmod
        th=text(texthp,textvp(x),labels{x},'FontWeight','normal','FontSize',10,'Fontweight','bold','Color',PlotColor(x,:));
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);       
    end
    if showmean
        th=text(texthp,textvp(x+1),'Mean','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',[0 0 0]);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
else
    if showmean col=[0 0 0]; else col=PlotColor(1,:);end
    if showsum
        th=text(texthp,mean_S(end),'Sum','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);       
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
    if showabc
        th=text(texthp,mean_A(end),'A','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
        th=text(texthp,mean_B(end),'B','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
        th=text(texthp,mean_C(end),'C','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);    
    end
end

xlim([xl(1) xl(2)+(xl(2)-xl(1))*0.02+(max(textext)*1.5)])

% --- Table ---
optvel=(mean(P(:,2))/mean(P(:,3)))^0.5;
yminv=mean(P(:,1)) + mean(P(:,2))/optvel + mean(P(:,3))*optvel;

Data{1,1}=mean(P(:,1)); Data{1,2}=mean(P(:,2)); Data{1,3}=mean(P(:,3)); Data{1,4}=optvel; Data{1,5}=yminv;  
RowName{1,1}='Mean';
for x=1:numel(labels)
    optvel=(mean(P(x,2))/mean(P(x,3)))^0.5; 
    yminv=mean(P(x,1)) + mean(P(x,2))/optvel + mean(P(x,3))*optvel;
    Data{x+1,1}=P(x,1); Data{x+1,2}=P(x,2); Data{x+1,3}=P(x,3); Data{x+1,4}=optvel; Data{x+1,5}=yminv;
    RowName{x+1,1}=labels{x};
end

% Table
if isfield(Modset,'velocityvar') str2=Modset.velocityvar; else str2='u'; end
T=tableposname;
T.Data=Data;
T.RowName=RowName;
T.ColumnName={'A','B','C',['Opt ' str2],'Min y'};
T.ViewPref=3;
T.ColumnFormat={4,4,4,4,4};
%T.ColumnWidth=60;
T.HeaderText{1}=['Models: ' modtype];
   
UserData.T=T;

set(gca,'Tag','PlotVDSingle','UserData',UserData,'ButtonDownFcn','oo_model_vd(94)')
zz_copyfigure


% ------------------- readsetscale ---------------------
function [setscale,xl,yl]=readsetscale

xl=[]; yl=[];

% Read or set scale
if any(strcmp(get(gcbo,'Tag'),{'XScaleLowEdit','XScaleHighEdit','YScaleLowEdit','YScaleHighEdit'}))    
    
    xl(1)=str2double(get(findobj(gcf,'Tag','XScaleLowEdit'),'String'));
    xl(2)=str2double(get(findobj(gcf,'Tag','XScaleHighEdit'),'String'));
    xl=sort(xl);
    yl(1)=str2double(get(findobj(gcf,'Tag','YScaleLowEdit'),'String'));
    yl(2)=str2double(get(findobj(gcf,'Tag','YScaleHighEdit'),'String'));
    yl=sort(yl);
    
    if any(~(xl>-inf & xl<inf)) || any(~(yl>-inf & yl<inf))
        setscale=true;
    else
        setscale=false;
    end
else
    setscale=true;
end


% ------------------- tabfromuserdat ---------------------
function tabfromuserdat

disptab=1;
try
    seltype=get(gcf,'SelectionType');
    if ~strcmp(seltype,'normal')
        disptab=0;
    end
catch
end

if disptab
    UserData=get(gca,'Userdata');
    if isempty(UserData)
        UserData.T=tableposname;
    end
    if zz_tabletool('Exist',UserData.T.TableName)==1
        zz_tabletool('Delete',UserData.T.TableName);
    end
    zz_tabletool('Create',UserData.T);
end


% ------------------- setlims ---------------------
function setlims(xl,yl)

xl=sort(xl); yl=sort(yl); 
xen='on'; yen='on';

if numel(xl)~=2 xl=[0 0]; end
if numel(yl)~=2 yl=[0 0]; end

xlstr=num2str(xl(1),3); xhstr=num2str(xl(2),3);
ylstr=num2str(yl(1),3); yhstr=num2str(yl(2),3); 

if xl(1)==xl(2) xen='off'; xlstr='-'; xhstr='-'; end
if yl(1)==yl(2) yen='off'; ylstr='-'; yhstr='-'; end

set(findobj(gcf,'Tag','XScaleLowEdit'),'String',xlstr,'Enable',xen)
set(findobj(gcf,'Tag','XScaleHighEdit'),'String',xhstr,'Enable',xen)
set(findobj(gcf,'Tag','YScaleLowEdit'),'String',ylstr,'Enable',yen)
set(findobj(gcf,'Tag','YScaleHighEdit'),'String',yhstr,'Enable',yen)

if xl(2)>xl(1) xlim(xl); else xlim([xl(1)-1 xl(2)+1]); end
if yl(2)>yl(1) ylim(yl); else ylim([yl(1)-1 yl(2)+1]); end


% ------------------- modeltypes ---------------------
function modeltypes
global Modset Experimental

ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
VDlevelsPop=findobj(gcf,'Tag','VDlevelsPop');


intlevels=repmat(NaN,1,numel(Experimental.activeexp));
vellevels=intlevels;

% Finds levels of interacting variable
for x=1:numel(Experimental.paramnames)
    pamcell=Experimental.paramnames{x};  
    if ~isempty(Modset.velocityvar)
        ind1=strmatch(Modset.velocityvar,pamcell,'Exact');
        if ~isempty(ind1)
            ind1=ind1(1);
            vellevels(x)=Experimental.parameters(ind1,x);
        end
    end    
    if ~isempty(Modset.interactvar)
        ind2=strmatch(Modset.interactvar,pamcell,'Exact');
        if ~isempty(ind2)
            ind2=ind2(1);
            intlevels(x)=Experimental.parameters(ind2,x);
        end
    end    
end
vellevels=unique(vellevels); vellevels(isnan(vellevels))=[]; 
Modset.velocityvar_levels=vellevels;
intlevels=unique(intlevels); intlevels(isnan(intlevels))=[];
Modset.interactvar_levels=intlevels;

VdModtype{1}='All levels'; Modtype{1}='Quad+Int'; Modtype{2}='Log+Int'; VDIntBtn=findobj(gcf,'Tag','VDIntBtn');
if ~isempty(intlevels)   
    Modtype{3}='VD+Int'; set(VDIntBtn,'Enable','on')     
    for x=1:numel(intlevels)
        Modtype{numel(Modtype)+1}=['VD '  Modset.interactvar '=' num2str(intlevels(x))];
        VdModtype{numel(VdModtype)+1}=[Modset.interactvar '=' num2str(intlevels(x))];
    end
else
    Modtype{3}='VD'; set(VDIntBtn,'Enable','off')     
end

set(ModelTypePop,'String',Modtype)
if get(ModelTypePop,'Value')>numel(Modtype) set(ModelTypePop,'Value',1); end
set(VDlevelsPop,'String',VdModtype)
if get(VDlevelsPop,'Value')>numel(VdModtype) set(VDlevelsPop,'Value',1); end

Modset.modtypes=Modtype;


% ------------------- autovelpop ---------------------
function autovelpop
global Experimental Modset

n_names=0; allnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pnames=Experimental.paramnames{x};
    for y=1:numel(pnames)
        if ~isempty(pnames{y})
            n_names=n_names+1;
            allnames{n_names}=pnames{y};
        end
    end
end
uniquenames=unique(allnames);

% Find matches that can be mobile phase vel.
C={'flo','vel','spe','mob','car'};
for x=1:numel(uniquenames)
    sc(x)=sum(strncmpi(uniquenames{x},C,3));
end
[d,ind]=max(sc); [d,ind2]=min(sc);

Modset.velocityvar=uniquenames{ind};

if numel(uniquenames)>1
    Modset.interactvar=uniquenames{ind2};
end

setvelocitypop

% ------------------- setvelocitypop ---------------------
function setvelocitypop
global Experimental Modset

InterVaryPop=findobj(gcf,'Tag','InterVaryPop');
VelocityPop=findobj(gcf,'Tag','VelocityPop');

allpnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pns=Experimental.paramnames{x};
    for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
end
allpnames=unique(allpnames);

dummystr={'-'};
if numel(allpnames)>0
    set(VelocityPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.velocityvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(VelocityPop,'Value',ind)
else
    set(VelocityPop,'String',dummystr,'Enable','off','Value',1)
end
if numel(allpnames)>1        
    set(InterVaryPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.interactvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(InterVaryPop,'Value',ind)    
else
    set(InterVaryPop,'String',dummystr,'Enable','off','Value',1)
end



% ------------------- listupdate ---------------------
function listupdate
global Modset Models Experimental

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

callertag=get(gcbo,'Tag');

if strcmp(callertag,'CodeRadio')
    codestr=get(gcbo,'String');
    if strcmp(codestr,'Code')
        Modset.codetype=1;
    end
    if strcmp(codestr,'Name')
        Modset.codetype=2;
    end    
    if strcmp(codestr,'Short name')
        Modset.codetype=3;
    end        
end

if strcmp(callertag,'ListTypeRadio')
    liststr=get(gcbo,'String');
    if strcmp(liststr,'Show data')
       Modset.listtype=1;
    end
    if strcmp(liststr,'Show models')
       Modset.listtype=2;
    end     
end

% set code types
if Modset.codetype==1;
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Modset.codetype==2;
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Modset.codetype==3;
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

if isempty(Models) Modset.listtype=1; end 
if isempty(Experimental) Modset.listtype=0; end 

if Modset.listtype~=1 && zz_tabletool('Exist','DataTable')
    zz_tabletool('Delete','DataTable');
end
if Modset.listtype==1 && zz_tabletool('Exist','ModelsTable')
    zz_tabletool('Delete','DataTable');
end

% set list types
if Modset.listtype==0 datalist; end

if Modset.listtype==1
    h=findobj(ListTypeRadio,'String','Show data');
    set(h,'Value',1)
    datalist
end
if Modset.listtype==2
    h=findobj(ListTypeRadio,'String','Show models');
    set(h,'Value',1)
    modelslist
end


% ------------------- calibdata ---------------------
function Calibdata = calibdata
global Experimental Modset 
% Function for finding acitive calibration data

XM=repmat(NaN,numel(Experimental.activeexp),2);
expno=(1:numel(Experimental.activeexp))';

% Fills XM, Velocity var is always in column 1;
for x=1:numel(Experimental.paramnames)
    if Experimental.activeexp(x)
        pamcell=Experimental.paramnames{x};       
        if ~isempty(Modset.velocityvar)
            ind=strmatch(Modset.velocityvar,pamcell,'Exact');
            if ~isempty(ind)
                ind=ind(1);
                XM(x,1)=Experimental.parameters(ind,x);
            end
        end
        if ~isempty(Modset.interactvar)
            ind2=strmatch(Modset.interactvar,pamcell,'Exact');
            if ~isempty(ind2)
                ind2=ind2(1);
                XM(x,2)=Experimental.parameters(ind2,x);
            end
        end
    end
end
                
% Delete columns that are all 0
NaNc=sum(isnan(XM));
delcols=NaNc==numel(Experimental.activeexp);
XM(:,delcols)=[];
if isempty(XM) expno=[]; end

% get Y-values
YM=Experimental.(getvarname)';   

delind=find(sum(isnan(XM),2));

XM(delind,:)=[];
YM(delind,:)=[];
expno(delind)=[];

% Constrain Y-values
YM=YM(:,Experimental.activecmp);

Calibdata.X=XM;
Calibdata.Y=YM;
Calibdata.expno=expno;
Calibdata.cmpno=find(Experimental.activecmp);
Calibdata.var1=Modset.velocityvar;
Calibdata.var2=Modset.interactvar;


% ------------------- contourplot ---------------------
function contourplot(X_cont,Y_cont,Z_cont,design)
global Experimental Pos Modset Metset

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; % To be edited
end

lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

if Metset.contour_isolines linestr='-'; else linestr='none'; end
subplot('Position',Pos.rightplot)
if numel(v)>2 && numel(v)<200
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr); % Only for newer Matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v); 
        set(h,'LineStyle',linestr);
    end
else
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,'LineStyle',linestr); % Only for newer Matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont); 
        set(h,'LineStyle',linestr);
    end
end

if Metset.contour_labels clabel(C,h); end
set(h,'ButtonDownFcn','oo_model_vd(9.1)','Tag','Contourplot');

% Centers clim if colormap is hotcold
if Metset.contour_centercol
    cm=[min(v) max(v)];
    set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

set(gcf,'Colormap',oo_getcmap);

% EXTRAS
hold on
    
% PLOTS DESIGN POINTS
if Metset.contour_showdesign && ~isempty(design)
    [m,n_points]=size(design);
    for x=1:n_points
        plot(design(1,x),design(2,x),'o',...
            'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
            'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model_vd(9.3)')    
    end
end

% Min and max
MinvalEdit1=findobj(gcf,'Tag','MinvalEdit1'); 
MinvalEdit2=findobj(gcf,'Tag','MinvalEdit2');
MinvalEdit3=findobj(gcf,'Tag','MinvalEdit3'); 
MinCheck=findobj(gcf,'Tag','MinCheck');
plotmin=get(MinCheck,'Value');
if plotmin
    minv=min(min(Z_cont));
    [ind1,ind2]=find(Z_cont==minv);
    ind1=ind1(1); ind2=ind2(1);
    minx=X_cont(ind1,ind2);
    miny=Y_cont(ind1,ind2);
    hold on
    plot(minx,miny,'o',...
        'MarkerSize',10,'MarkerFaceColor',[0.5 0.5 1],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model_vd(9.3)')
    set(MinvalEdit1,'String',num2str(minx,'%6.4g'),'Enable','on')
    set(MinvalEdit2,'String',num2str(miny,'%6.4g'),'Enable','on')
    set(MinvalEdit3,'String',num2str(minv,'%6.4g'),'Enable','on')
else
    set(MinvalEdit1,'String','','Enable','off'); set(MinvalEdit2,'String','','Enable','off'); set(MinvalEdit3,'String','','Enable','off')      
end

MaxvalEdit1=findobj(gcf,'Tag','MaxvalEdit1'); 
MaxvalEdit2=findobj(gcf,'Tag','MaxvalEdit2');
MaxvalEdit3=findobj(gcf,'Tag','MaxvalEdit3'); 
MaxCheck=findobj(gcf,'Tag','MaxCheck');
plotmax=get(MaxCheck,'Value');
if plotmax
    maxv=max(max(Z_cont));
    [ind1,ind2]=find(Z_cont==maxv);
    ind1=ind1(1); ind2=ind2(1);
    maxx=X_cont(ind1,ind2);
    maxy=Y_cont(ind1,ind2);
    hold on
    plot(maxx,maxy,'o',...
        'MarkerSize',10,'MarkerFaceColor',[1 0.5 0.5],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model_vd(9.3)')
    set(MaxvalEdit1,'String',num2str(maxx,'%6.4g'),'Enable','on')
    set(MaxvalEdit2,'String',num2str(maxy,'%6.4g'),'Enable','on')
    set(MaxvalEdit3,'String',num2str(maxv,'%6.4g'),'Enable','on')
else
    set(MaxvalEdit1,'String','','Enable','off'); set(MaxvalEdit2,'String','','Enable','off'); set(MaxvalEdit3,'String','','Enable','off')      
end

% Slectionpoint
sxv=mean(mean(X_cont));
syv=mean(mean(Y_cont));
maha=plot(sxv,syv,'+',...
    'MarkerSize',12,'MarkerFaceColor',[1 0.7 0.5],...
    'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model_vd(9.3)','Tag','SelectionMarker','Visible','off');
if get(findobj(gcf,'Tag','ShowSelCheck'),'Value') set(maha,'Visible','on'); end

hold off

set(gca,'Tag','ContourPlot')
zz_copyfigure

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','on','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','on','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','on','String','')

Modset.currentcont_x=X_cont;
Modset.currentcont_y=Y_cont;
Modset.currentcont_z=Z_cont;

% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(coeff,minmax_x,minmax_y,modeltype)

%disp('--- calcsurf ---')

res_x=100; res_y=100; %resolution 
inc_x=(minmax_x(2)-minmax_x(1))/res_x;
inc_y=(minmax_y(2)-minmax_y(1))/res_y;

xs=minmax_x(1):inc_x:minmax_x(2);
le_x=length(xs);
ys=minmax_y(1):inc_y:minmax_y(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
if modeltype==2 xs=log(xs); ys=log(ys); end % take ln of all values if ln-model of time
for xc=1:le_x
    for yc=1:le_y
        if modeltype==1 % Quad+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        end
        if modeltype==2 % Log+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc)]; 
        end
        if modeltype==3 % VD+Int
            D=[1 1/xs(xc) xs(xc) ys(yc) ys(yc)/xs(xc) xs(xc)*ys(yc) ys(yc)^2];           
        end 
        z_val=[D*coeff];
        Z_cont(xc,yc)=z_val;     
    end   
end

if modeltype==2
    Z_cont=exp(Z_cont);
end
    

% ------------------- findmodels ---------------------
function modno=findmodels(modeltype)
global Models

n_models=numel(Models);
if n_models==0
    modno=[]; 
else
    for x=1:numel(Models) 
        modeltypes{x}=Models(x).modeltype; 
    end
    modno=strmatch(modeltype,modeltypes);
    if ~isempty(modno)
        modno=modno(1);
    end
end


% ------------------- calcmodels ---------------------
function err=calcmodels
global Experimental Models Modset

err=0;

Calibdata = calibdata;
[m,n]=size(Calibdata.X); if m<2 err=1; zz_message(1,'Too few active experiments','-r'); return; end

if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

% Check for existing models and defines modno
modeltype='Quad+Int';
modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

parameters=Calibdata.X';
[n_par,n_exp]=size(parameters);
if n_par<2 
    parameters(2,1:n_exp)=0;
end

expdata=Calibdata.Y';

% x-matrix for validation
for x=1:n_exp
    XV(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];
end

selcmp=find(Experimental.activecmp);
varname=getvarname;

parn{1}=Calibdata.var1; parn{2}=Calibdata.var2;
for x=1:length(parn)
    spaceind=strfind(parn{x},' ');
    parn{x}(spaceind)=[];
end

for x=1:length(selcmp)
    cmp=selcmp(x);   
    y_meas=expdata(x,:)';
    [coefficients,n_coeff]=oo_calcmodel(parameters,y_meas);
    Models(modno).(varname){cmp}=coefficients;
    if sum(isnan(coefficients))==0 
        y_pred=XV*coefficients; 
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end   
        Models(modno).([varname '_nparam']){cmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models(modno).([varname '_errors']){cmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){cmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){cmp}=parameters;      
    end
end

Models(modno).parnames={'Const',parn{1},parn{2},[parn{1} char(215) parn{2}],[parn{1} char(178)],[parn{2} char(178)]};
Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};

Modset.currentmodel=modno;
Modset.currentmodeltype=modeltype;


% ------------------- logintmodel ---------------------
function err=logintmodel

err=0; % Change to 1 if errors

global Experimental Models Modset

Calibdata=calibdata;

[m,n]=size(Calibdata.X); 
if n<2 err=1; zz_message(1,'Not enough variables','-r'); return; end
if m<4 err=1; zz_message(1,'Model needs at least 4 experiments','-r'); return; end
if numel(unique(Calibdata.X(:,1)))<2 err=1; zz_message(1,'Model needs at least 2 levels on each variable','-r'); return; end
if numel(unique(Calibdata.X(:,2)))<2 err=1; zz_message(1,'Model needs at least 2 levels on each variable','-r'); return; end


if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end
[m,n]=size(Calibdata.X); if n<2 zz_message(1,'Model type needs two varied parameters','-r'); return; end


% Check for existing models and defines modno
modeltype='Log+Int';
modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

parameters=Calibdata.X';
[n_par,n_exp]=size(parameters);
if n_par<2 
    parameters(2,1:n_exp)=0;
end
expdata=Calibdata.Y';

% Check for zeros or negative numbers before taking log
if sum(sum(expdata<=0))>0 || sum(sum(parameters<=0))>0
    err=1; zz_message(1,'Zeros or negative numbers in matrix, cannot calculate model','-r'); return
end
    
logparam=log(parameters);
logexpdata=log(expdata);

% x-matrix for validation
for x=1:n_exp
    XV(x,:)=[1 logparam(1,x) logparam(2,x) logparam(1,x)*logparam(2,x)];
end

selcmp=find(Experimental.activecmp);
varname=getvarname;

parn{1}=Calibdata.var1; parn{2}=Calibdata.var2;
for x=1:length(parn)
    spaceind=strfind(parn{x},' ');
    parn{x}(spaceind)=[];
end

for x=1:length(selcmp)
    cmp=selcmp(x);   
    y_meas=logexpdata(x,:)';
    coefficients=XV\y_meas;
    n_coeff=4;
    Models(modno).(varname){cmp}=coefficients;
    if sum(isnan(coefficients))==0 
        y_pred=XV*coefficients;
        
        % Convert to exponents to get correct stats
        y_meas=exp(y_meas); 
        y_pred=exp(y_pred);
        
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end   
        Models(modno).([varname '_nparam']){cmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models(modno).([varname '_errors']){cmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){cmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){cmp}=parameters;      
    end
end

Models(modno).parnames={'Const',['ln(' parn{1} ')'],['ln(' parn{2} ')'],['ln(' parn{1} ')' char(215) 'ln(' parn{2} ')']};
Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};

Modset.currentmodel=modno;
Modset.currentmodeltype=modeltype;


% ------------------- vdintmodel ---------------------
function err=vdintmodel
global Modset Models Experimental

err=0; % Change to 1 if errors

Calibdata=calibdata;

% Check for 3 or more velocity levels
if numel(unique(Calibdata.X(:,1)))<3 err=1; zz_message(1,'Model needs at least 3 velocity levels','-r'); return; end

if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

includeA=~get(findobj(gcf,'Tag','ZeroACheck'),'Value'); % Force A to be 0
includeI=get(findobj(gcf,'Tag','IncludeICheck'),'Value');
includeBI=get(findobj(gcf,'Tag','IncludeBICheck'),'Value');
includeCI=get(findobj(gcf,'Tag','IncludeCICheck'),'Value');
includeII=get(findobj(gcf,'Tag','IncludeIICheck'),'Value');
testsign=get(findobj(gcf,'Tag','SignTestCheck'),'Value');
signthresh=str2double(get(findobj(gcf,'Tag','SignTestEdit'),'String'));
if isnan(signthresh) || signthresh<0
    set(findobj(gcf,'Tag','SignTestEdit'),'String','0.1'); signthresh=0.1;
end

validpars=find([includeA 1 1 includeI includeBI includeCI includeII]);

% Check for existing models and defines modno
modeltype='VD+Int';
modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

% Get parameters
parameters=Calibdata.X';
[n_par,n_exp]=size(parameters);
if n_par<2 
    parameters(2,1:n_exp)=0;
end
expdata=Calibdata.Y;

% Builds x-matrix
for x=1:n_exp
    XM(x,:)=[1 1/parameters(1,x) parameters(1,x) parameters(2,x) parameters(2,x)*(1/parameters(1,x)) parameters(2,x)*parameters(1,x) parameters(2,x)^2];
    % Constant B/x C*x I BI/x CI*x I*I
end
XM=XM(:,validpars);

% Ranktest
[n_exp,n_par]=size(XM);
for x=1:n_par
    r(x)=rank(XM(:,1:x));
end
valids=[1 diff(r)>0];
XM=XM(:,find(valids));
validpars=validpars(find(valids));

[m,n_cmp]=size(expdata);

% validation
[n_exp,n_par]=size(XM);

selcmp=find(Experimental.activecmp);
varname=getvarname;

for cmpno=1:n_cmp
    y_meas=expdata(:,cmpno);
    yvar=var(y_meas);
    % significance testing
    LX=XM; % Copy of XM
    tvalidpars=validpars; % copy of validpars
    if testsign
        for x=1:n_par
            TX=LX(:,1:x);
            tcoeff=(TX\y_meas);
            ty_pred=TX*tcoeff;
            explvar(x)=100*((yvar-var(ty_pred-y_meas))/yvar); % explained variance in %      
        end
        usevar=[100 diff(explvar)]>signthresh;
        LX=LX(:,usevar);
        tvalidpars=tvalidpars(usevar);
    end
    
    n_coeff=numel(tvalidpars);
    
    coefficients=(LX\y_meas); 
    y_pred=LX*coefficients;
    res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
    rms=(sumsq/numel(res))^0.5; % unadjusted rms     
    if numel(res)-n_coeff <1
        rms_adj=inf;
    else
        rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
    end    
    r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
    bias=mean(res);

    coeffout=zeros(7,1);
    for x=1:numel(tvalidpars)
        coeffout(tvalidpars(x))=coefficients(x);
    end
    
    Models(modno).(varname){selcmp(cmpno)}=coeffout;
    
    Models(modno).([varname '_nparam']){selcmp(cmpno)}=n_coeff; % Number of parameters
    Models(modno).([varname '_df']){selcmp(cmpno)}=numel(res)-n_coeff; % degrees of freedom    
    Models(modno).([varname '_errors']){selcmp(cmpno)}=[rms rms_adj r2 bias];
    Models(modno).([varname '_predmeas']){selcmp(cmpno)}=[y_meas'; y_pred'];
    Models(modno).([varname '_design']){selcmp(cmpno)}=parameters;
        
    Models(modno).parnames={'Const',['1/' Calibdata.var1],...
        [Calibdata.var1],[Calibdata.var2],...
        [Calibdata.var2 '/' Calibdata.var1],...
        [Calibdata.var1 char(215) Calibdata.var2],...
        [Calibdata.var2 char(178)]};
    Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};    
    
end

Modset.currentmodel=modno;
Modset.currentmodeltype=modeltype;


% ------------------- vdmodel ---------------------
function err=vdmodel
global Modset Models

err=0;

Calibdata=calibdata;

if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

VDlevelsPop=findobj(gcf,'Tag','VDlevelsPop');
vdlevel=get(VDlevelsPop,'Value')-1; 

varname=getvarname;

% transfers Calibdata to Data according to level of parameter 2 and checks
% that there is sufficient points in level 1
Data=[];
if ~isempty(Modset.interactvar) 
    if vdlevel==0
        par2levels=unique(Calibdata.X(:,2));  %all levels of interacting var 
    else
        par2levels=Modset.interactvar_levels(vdlevel); % selected level
    end
    for x=1:numel(par2levels)
        ind=find(Calibdata.X(:,2)==par2levels(x));
        par1levels=unique(Calibdata.X(ind,1));
        if numel(par1levels)<3 par2levels(x)=NaN; end
    end
    par2levels(isnan(par2levels))=[];
    if ~isempty(par2levels)
        for x=1:numel(par2levels)
            ind=find(Calibdata.X(:,2)==par2levels(x));
            Data(x).X=Calibdata.X(ind,:);
            Data(x).Y=Calibdata.Y(ind,:);
            Data(x).expno=Calibdata.expno(ind,:);
            Data(x).cmpno=Calibdata.cmpno;
            Data(x).modeltype=['VD ' Calibdata.var2 '=' num2str(par2levels(x))];
        end  
    end
else
    par1levels=unique(Calibdata.X(:,1));
    if numel(par1levels)>=3
        Data(1).X=Calibdata.X;
        Data(1).Y=Calibdata.Y;
        Data(1).expno=Calibdata.expno;
        Data(1).cmpno=Calibdata.cmpno;
        Data(1).modeltype=['VD'];
    end
end

if isempty(Data) err=1; zz_message(1,'Each model needs at least three velocity levels','-r'); return; end


zeroA=get(findobj(gcf,'Tag','ZeroACheck'),'Value'); % Force A to be 0
if zeroA n_coeff=2; else n_coeff=3; end

allA=[];
for mo=1:numel(Data)
    modno=findmodels(Data(mo).modeltype);
    if isempty(modno) modno=numel(Models)+1; end
    Models(modno).modeltype=Data(mo).modeltype;
    Models(modno).velocityvar=Modset.velocityvar;
    Models(modno).interactvar=Modset.interactvar;
      
    [n_exp,n_cmp]=size(Data(mo).Y);
    
    for cmp=1:n_cmp
        currentcmp=Data(mo).cmpno(cmp);

        % Regression
        if zeroA
            T(1:n_exp,1)=1./Data(mo).X(:,1);
            T(1:n_exp,2)=Data(mo).X(:,1);  
        else    
            T(1:n_exp,1)=1;
            T(1:n_exp,2)=1./Data(mo).X(:,1);
            T(1:n_exp,3)=Data(mo).X(:,1);
        end
        
        y_meas=Data(mo).Y(:,cmp);
        coefficients=(T\y_meas);
        if zeroA
            Models(modno).(getvarname){currentcmp}=[0; coefficients];
        else
            Models(modno).(getvarname){currentcmp}=coefficients;
        end
        allA(cmp)=coefficients(1);
        
        % validation
        y_pred=T*coefficients;
        res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
        rms=(sumsq/numel(res))^0.5;  
        if numel(res)-n_coeff <1
            rms_adj=inf;
        else
            rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
        end

        r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
        bias=mean(res);
        
        Models(modno).([varname '_nparam']){currentcmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){currentcmp}=numel(res)-n_coeff; % degrees of freedom                
        Models(modno).([varname '_errors']){currentcmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){currentcmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){currentcmp}=Data(mo).X';
        
        Models(modno).parnames={'A (Const)',['B / ' Calibdata.var1],['C x ' Calibdata.var1]};
        Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};

    end    
end

% Recalculate with mean A
T=[]; allA(isnan(allA))=[];
if get(findobj(gcf,'Tag','MeanACheck'),'Value') && numel(allA)>1
    meanA=mean(allA);
    for mo=1:numel(Data)
        modno=findmodels(Data(mo).modeltype);
        if isempty(modno) modno=numel(Models)+1; end
        Models(modno).modeltype=Data(mo).modeltype;
        
        [n_exp,n_cmp]=size(Data(mo).Y);
    
        for cmp=1:n_cmp
            currentcmp=Data(mo).cmpno(cmp);

            % Regression
            T(1:n_exp,1)=1./Data(mo).X(:,1);
            T(1:n_exp,2)=Data(mo).X(:,1);

            y_meas=Data(mo).Y(:,cmp)-meanA; % subtracts mean A and solves without A-term
            coefficients=(T\y_meas);
            Models(modno).(getvarname){currentcmp}=[meanA; coefficients]; % adds meanA to coefficients
 
            % validation
            y_meas=y_meas+meanA; % adds back mean A
            y_pred=T*coefficients+meanA; % adds back mean A
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5;       
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
            
            Models(modno).([varname '_nparam']){currentcmp}=n_coeff; % Number of parameters
            Models(modno).([varname '_df']){currentcmp}=numel(res)-n_coeff; % degrees of freedom    
            Models(modno).([varname '_errors']){currentcmp}=[rms rms_adj r2 bias];
            Models(modno).([varname '_predmeas']){currentcmp}=[y_meas'; y_pred'];
            Models(modno).([varname '_design']){currentcmp}=Data(mo).X';
            Models(modno).parnames={'A (Const)',['B / ' Calibdata.var1],['C x ' Calibdata.var1]};
            Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};
        end    
    end
end

Modset.currentmodel=modno;
Modset.currentmodeltype=Data(mo).modeltype;


% ------------------- calcvalues ---------------------
function calcvalues
global Experimental Models Modset Pos

% Check for valid models
ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
str=get(ModelTypePop,'String'); val=get(ModelTypePop,'Value');
modeltype=str{val};
if strcmp(modeltype,'VD')
    matchstr=[modeltype Modset.velocityvar];
    for x=1:numel(Models) 
        teststr{x}=[Models(x).modeltype Models(x).velocityvar];   
    end
else
    matchstr=[modeltype Modset.velocityvar Modset.interactvar];
    for x=1:numel(Models) 
        teststr{x}=[Models(x).modeltype Models(x).velocityvar Models(x).interactvar];   
    end    
end
modind=strmatch(matchstr,teststr,'exact'); 
if isempty(modind) zz_message(1,['No ' modeltype ' models of variables ' Modset.velocityvar ' ' Modset.interactvar],'-r'); return; end
modind=modind(1);

varname=getvarname;

ParametersList=findobj(gcf,'Tag','ParametersList');
str=get(ParametersList,'String'); val=get(ParametersList,'Value');
paramname=str{val};

if ~isfield(Models,varname) || isempty(Models(modind).(varname))
    zz_message(1,['No models of type ' modeltype ' for ' paramname],'-r'); return
end

% Find the correct designpoints (xp and yp)
xp=[]; yp=[]; 
if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar)
    velname=Modset.velocityvar;
    for p=1:numel(Experimental.paramnames)
        xind=strmatch(velname,Experimental.paramnames{p}); xind=xind(1);
        xp(p)=Experimental.parameters(xind,p);
    end    
end
if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar)
    intname=Modset.interactvar;
    for p=1:numel(Experimental.paramnames)
        yind=strmatch(intname,Experimental.paramnames{p}); yind=yind(1);
        yp(p)=Experimental.parameters(yind,p);
    end 
end

n_exp=numel(Experimental.paramnames);
n_cmp=numel(Experimental.codes);

Data=cell(n_cmp,n_exp);


if strncmp(modeltype,'VD ',3) || strcmp(modeltype,'VD')
    intlevel=[]; 
    if isfield(Modset,'interactvar_levels') && ~isempty(Modset.interactvar_levels)
        for x=1:numel(Modset.interactvar_levels)
            tstr{x}=['VD ' intname '=' num2str(Modset.interactvar_levels(x))];
        end
        intlevel=strmatch(modeltype,tstr); intlevel=intlevel(1);
    end
    if ~isempty(intlevel)
        valids=find(yp==Modset.interactvar_levels(intlevel));
    else
        valids=1:numel(xp);
    end
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==3
             for dno=1:numel(valids)
                Data{cmpno,valids(dno)}=coeff(1)+coeff(2)/xp(valids(dno))+coeff(3)*xp(valids(dno));            
            end
         end
    end
end

if strcmp(modeltype,'VD+Int')
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==7
            for dno=1:numel(xp)
                Data{cmpno,dno}=coeff(1)+coeff(2)/xp(dno)+coeff(3)*xp(dno)+coeff(4)*yp(dno)+coeff(5)*yp(dno)/xp(dno)+coeff(6)*xp(dno)*yp(dno)+coeff(7)*yp(dno)^2;
            end
        end
    end 
end
if strcmp(modeltype,'Quad+Int')
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==6
            for dno=1:numel(xp)
                Data{cmpno,dno}=coeff(1)+coeff(2)*xp(dno)+coeff(3)*yp(dno)+coeff(4)*xp(dno)*yp(dno)+coeff(5)*xp(dno)^2+coeff(6)*yp(dno)^2;
            end
        end
    end      
end
if strcmp(modeltype,'Log+Int')
    logxp=log(xp); logyp=log(yp);
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==4
            for dno=1:numel(xp)
                Data{cmpno,dno}=exp(coeff(1)+coeff(2)*logxp(dno)+coeff(3)*logyp(dno)+coeff(4)*logxp(dno)*logyp(dno));
            end
        end
    end      
end

%Experimental
Data(cellfun('isempty',Data))={NaN};

if Modset.codetype==1 rownames=Experimental.codes; end
if Modset.codetype==2 rownames=Experimental.names; end
if Modset.codetype==3 rownames=Experimental.shortnames; end 

% Add experimental conditions
[m,n]=size(Data); % use m
if ~isempty(xp)
    for x=1:numel(xp) Data{m+1,x}=xp(x); end; rownames{m+1}=velname;
end
[m,n]=size(Data); % use m
if ~isempty(yp)
    for y=1:numel(yp) Data{m+1,y}=yp(y); end; rownames{m+1}=intname;
end

T.Data=Data;
T.TableName='CalculatedTable';

winw=Pos.window(3); winh=Pos.window(4);
winl=Pos.window(1); winb=Pos.window(2);
lp=winl+winw*0.02; vp=winb+winh*0.45; tw=winw*0.52; th=winh*0.53;

T.Position=[lp vp tw th];

for x=1:n_exp 
    T.ColumnName{x}=['Exp ' num2str(x)]; 
    T.ColumnFormat{x}=4;
    T.ColumnWidth{x}=70;
end
T.RowName=rownames;
T.ColumnEditable=[zeros(1,n_exp)];
T.AllowNan=1;
T.ViewPref=1;
T.Popup=1;
T.PopupTitle='Calculated values';
T.PopupResizable=1;
T.PopupModal=0;
T.HeaderText={['Calculated values for ' modeltype],['Variable is ' paramname]};
T.FooterText={Modset.filename,datestr(now)};

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
pause(0.5)

zz_tabletool('Create',T);


% ------------------- calc_errors ---------------------
function Estruct=calc_errors
global Experimental Models Pos Modset

T=tableposname;
Estruct.plotpos=Pos.rightplot;
Estruct.tablepos=T.Position;
Estruct.tablename=T.TableName;

if ~isfield(Modset,'currentmodel') plot_dummy('No valid models selected'); setlims([],[]); return; end

modno=Modset.currentmodel;
selcmp=find(Experimental.activecmp);
if isempty(selcmp) plot_dummy('No compounds selected'); return; end

varname=getvarname;
if ~isfield(Models,varname) plot_dummy('No valid models selected'); return; end

switch Modset.codetype
    case 1; cmplabs=Experimental.codes;
    case 2; cmplabs=Experimental.names;
    case 3; cmplabs=Experimental.shortnames;
end

ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
modelstr=str{val}; 

valids=find(~cellfun('isempty',Models(modno).([varname '_errors'])));
valids=intersect(valids,selcmp);

if isempty(valids)
    return   
end

terrornames=Models(modno).errornames;
rmseind=strmatch('RMS',terrornames,'exact'); rmseind=rmseind(1);
rmseadjind=strmatch('RMS_adj',terrornames,'exact'); rmseadjind=rmseadjind(1);
biasind=strmatch('Bias',terrornames,'exact'); biasind=biasind(1);

for vno=1:numel(valids)
    terrors=Models(modno).([varname '_errors']){valids(vno)};
    
    rmse(vno)=terrors(rmseind);
    rmseadj(vno)=terrors(rmseadjind);
    bias(vno)=terrors(biasind);
        
    predmeas=Models(modno).([varname '_predmeas']){valids(vno)};
    Measured{vno}=predmeas(1,:);
    Predicted{vno}=predmeas(2,:);
    
    n_exp(vno)=length(Measured{vno}); 
    
    R=corrcoef(Measured{vno},Predicted{vno});
    correl(vno)=R(1,2);
       
    des{vno}=(Models(modno).([varname '_design']){valids(vno)})';
     
end

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

Estruct.modeltype=Models(modno).modeltype;
Estruct.parameter=modelstr;
Estruct.rmse=rmse;
Estruct.rmse_adj=rmseadj;
Estruct.Measured=Measured;
Estruct.Predicted=Predicted;
Estruct.Design=des;
Estruct.n_exp=n_exp;
Estruct.correl=correl;
Estruct.bias=bias;
Estruct.Labels=cmplabs(valids);
Estruct.Colors=cols(valids,:);
Estruct.Varnames{1}=Models(modno).velocityvar; Estruct.Varnames{2}=Models(modno).interactvar; 



% ------------------- checkpoint ---------------------
function checkpoint(xp,yp)
global Experimental Models Modset

xvals=Modset.currentcont_x(:,1);
yvals=Modset.currentcont_y(1,:);

xa=min(find(xvals>=xp)); xb=max(find(xvals<=xp));
if (xp-xvals(xb))<=(xvals(xa)-xp) nxp=xb; else nxp=xa; end
 
ya=min(find(yvals>=yp)); yb=max(find(yvals<=yp));
if (yp-yvals(yb))<=(yvals(ya)-yp) nyp=yb; else nyp=ya; end

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'String',num2str(xp,'%6.4g'))
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'String',num2str(yp,'%6.4g'))

% Move marker
maha=findobj(gca,'Tag','SelectionMarker');
if ~isempty(maha) set(maha,'XData',xp,'YData',yp); end

% Find selected compounds
selcmp=find(Experimental.activecmp);

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

varname=getvarname;

ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
str=get(ModelTypePop,'String'); val=get(ModelTypePop,'Value');
modeltype=str{val};

for x=1:numel(Models) modeltypestr{x}=Models(x).modeltype; end

modind=strmatch(modeltype,modeltypestr,'exact');

cc=1;  
for p=1:length(selcmp)
    cmp=selcmp(p);
    cmod=Models(modind).(varname);  % current models
    coeff=cmod{cmp};
    calcres=NaN;
    if strmatch(modeltype,'VD+Int')
        if numel(coeff)==7 && sum(isnan(coeff))==0
            calcres=coeff(1)+coeff(2)/xp+coeff(3)*xp+coeff(4)*yp+coeff(5)*yp/xp + coeff(6)*xp*yp+coeff(7)*yp^2;
        end
    end
    if strmatch(modeltype,'Quad+Int')
        if numel(coeff)==6 && sum(isnan(coeff))==0
            calcres=coeff(1)+coeff(2)*xp+coeff(3)*yp+coeff(4)*xp*yp + coeff(5)*xp^2 +coeff(6)*yp^2;   
        end
    end  
    if strmatch(modeltype,'Log+Int')
        if numel(coeff)==4 && sum(isnan(coeff))==0
            calcres=exp(coeff(1)+coeff(2)*log(xp)+coeff(3)*log(yp)+coeff(4)*log(xp)*log(yp));   
        end
    end     
    
    if ~isnan(calcres)
        cc=cc+1;
        RowName{cc}=codes{cmp}; Data{cc,1}=calcres;
    end
end

if strcmp(get(gcbo,'Tag'),'OptvelLine')
    Userdat=get(gcbo,'Userdata'); tstr{1}=Userdat.text; outstr=tstr;
end

% Prepare first table line
datavect=cell2mat(Data);
datavect(isnan(datavect))=[];
SurfTypePop=findobj(gcf,'Tag','SurfTypePop');
Str=get(SurfTypePop,'String');
RowName{1}=Str{get(SurfTypePop,'Value')}; 
switch RowName{1}
    case 'Mean'
        Data{1,1}=mean(datavect);
    case 'Sum'
        Data{1,1}=sum(datavect);
    case 'Min'
        Data{1,1}=min(datavect);
    case 'Max'
        Data{1,1}=max(datavect);    
end

T=tableposname;
T.Data=Data;
T.RowName=RowName;
T.ColumnName=[];
T.ViewPref=3;
T.ColumnFormat{1}='%6.4g';
T.ColumnWidth{1}=60;
T.HeaderText{1}='Value at position:';
T.HeaderText{2}=['x = ' num2str(xp,'%6.4g')];
T.HeaderText{3}=['y = ' num2str(yp,'%6.4g')];

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ----------------- evalboxlist -------------------
function evalboxlist
global Experimental

val=zz_tabletool('getlastcell','BoxTable');

if numel(val)==1 && val.colindex==1
    Experimental.expname{val.rowindex}=val.val;
end
if val(1).colindex==2
    Experimental.activeexp=cell2mat(zz_tabletool('getcol','BoxTable',2))';    
end
if numel(val)==1 && val.colindex>2
    Experimental.parameters(val.colindex-2,val.rowindex)=val.val;
end

plot_design 

% ------------------- boxlist ---------------------
function boxlist
global Experimental Pos

paramname=cell(0);

T.TableName='BoxTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2+Pos.bw Pos.gh*6];

if isfield(Experimental,'parameters')
    [nparam,nexp]=size(Experimental.parameters);

    for expno=1:length(Experimental.expname)
        T.Data{expno,1}=Experimental.expname{expno};
        if Experimental.activeexp(expno)
            T.Data{expno,2}=true;
        else
            T.Data{expno,2}=false;
        end
        %T.Data{expno,3}=false;
        for x=1:nparam
            T.Data{expno,x+2}=Experimental.parameters(x,expno);
        end
        if ~isempty(Experimental.paramnames{expno})
            for x=1:numel(Experimental.paramnames{expno})
                paramname{x}=Experimental.paramnames{expno}{x};
            end
        end
        T.RowName{expno}=['Exp ' num2str(expno)];   
    end

    T.ColumnName={'Files','Active'}; 
    for x=1:numel(paramname) T.ColumnName{x+2}=paramname{x}; end
    T.ColumnEditable=[1 1 ones(1,numel(paramname))];
    T.ViewPref=1;
    T.CellEditCallback='oo_model_vd(12.1)';
    T.AllowNan=1;    
    T.ColumnFormat={'char','binary'}; for x=1:numel(paramname) T.ColumnFormat{x+2}='numeric'; end
    T.ColumnWidth=[100 50 repmat(60,1,numel(paramname))];    
    T.ListSelCol=2;   
    
    if isempty(paramname) zz_message(1,'Warning: Experiments/conditions are not assigned - Assign in Experiments window','-r'); end
    
else
    T.Data=[];    
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);



% ------------------- parameterslist ---------------------
function parameterslist
global Experimental

ParametersList=findobj(gcf,'Tag','ParametersList'); set(ParametersList,'Enable','off')

if isempty(Experimental) return; end

showall=get(findobj(gcf,'Tag','AllParamCheck'),'Value');
currentstr=get(ParametersList,'String'); if ~iscell(currentstr) currentstr={''}; end
currentval=get(ParametersList,'Value'); if currentval>numel(currentstr) currentval=1; end
currentsel=currentstr{currentval};
preferred='Peak width (RI units)';
currentvar=getvarname;

strno=0; str=[];
fn=fieldnames(Experimental);
for x=1:length(fn)    
    if strcmp(fn{x}, 'rt_exp') strno=strno+1; str{strno}='Retention time (RT)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'ri_exp') strno=strno+1; str{strno}='Retention index (RI)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'wbl_exp') strno=strno+1; str{strno}='Peak width (RT units)'; end
    if strcmp(fn{x}, 'wbl_ri_exp') strno=strno+1; str{strno}='Peak width (RI units)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'area_exp') strno=strno+1; str{strno}='Area'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'height_exp') strno=strno+1; str{strno}='Height'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'responsefactor_exp') strno=strno+1; str{strno}='Response factor'; end
end

if ~isempty(str) && iscell(str)
    ind=strmatch(currentsel,str,'exact'); 
    if isempty(ind) ind=strmatch(preferred,str,'exact'); end
    if isempty(ind) ind=1; end 
    set(ParametersList,'String',str,'Value',ind,'Enable','on')
end



% ----------------- evaldatalist -------------------
function evaldatalist
global Experimental

val=zz_tabletool('getlastcell','DataTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','DataTable',1))';
end

if val(1).colindex>1
    varname=getvarname;
    Experimental.(varname)(val.rowindex,val.colindex-1)=val.val;
end
    

% ------------------- datalist ---------------------
function datalist
global Experimental Modset Pos

T.TableName='DataTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];

if isfield(Experimental,'paramnames') && isfield(Experimental,'codes')
    n_exp=length(Experimental.paramnames);
    n_comp=length(Experimental.codes);
    
    varname=getvarname;

    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end   
        for expno=1:n_exp
            T.Data{compno,expno+1}=Experimental.(varname)(compno,expno);
        end
        
        if ~isfield(Experimental,'activecmp') % For old models
            Experimental.activecmp=ones(1,numel(Experimental.codes));
        end
        
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    for x=1:n_exp 
        T.ColumnName{x+1}=['Exp ' num2str(x)]; 
        T.ColumnFormat{x+1}=4;
        T.ColumnWidth{x+1}=70;
    end
    T.ColumnEditable=[ones(1,n_exp+1)];
    T.AllowNan=1;
    T.ViewPref=1;
    T.ColumnName{1}='Active';
    T.ColumnFormat{1}='binary';
    T.ColumnWidth{1}=40;
    T.CellEditCallback='oo_model_vd(12.2)';
    T.ListSelCol=1;
else
    T.Data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ----------------- evalmodelslist -------------------
function evalmodelslist
global Experimental

val=zz_tabletool('getlastcell','ModelsTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','ModelsTable',1))';
end

if get(findobj(gcf,'Tag','PlotUpdCheck'),'Value')
    plotupdate
end


% ------------------- modelslist ---------------------
function modelslist
global Experimental Models Modset Pos

if ~isfield(Modset,'currentmodel') return; end

% Select model to display
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modeltypestr=get(ModelTypePop,'String'); 
if gcbo==ModelTypePop
    val=get(ModelTypePop,'Value'); 
    modeltype=modeltypestr{val};
    modno=findmodels(modeltype);
    if ~isempty(modno) 
        Modset.currentmodel=modno; 
        Modset.currentmodeltype=modeltype;
    else
        zz_message(1,['No models of type ' modeltype],'-r');
    end
end   
modno=Modset.currentmodel;
modeltype=Models(modno).modeltype;
val=strmatch(modeltype,modeltypestr); 
if ~isempty(val) val=val(1); set(ModelTypePop,'Value',val); end   

T.TableName='ModelsTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];
varname=getvarname;

if ~isempty(Models) 
    
    % For old models where parnames and activecmp are not saved
    if ~isfield(Experimental,'activecmp') 
        Experimental.activecmp=ones(1,numel(Experimental.codes));
    end
    if ~isfield(Models,'parnames')
        Models(modno).parnames={'Const','start','grad','start�grad','start�','grad�'}; 
    end      
    
    n_comp=length(Experimental.codes);
    
    % Constructs T
    [T.ColumnName{2:numel(Models(modno).parnames)+1}]=deal(Models(modno).parnames{:});
    T.ColumnName{1}='Active';
    
    n_param=numel(Models(modno).parnames);
    T.Data=cell(numel(Experimental.codes),1+n_param);
    
    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end 
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    
    if isfield(Models,varname)
        for cmpno=1:numel(Models(modno).(varname))
            if ~cellfun('isempty',Models(modno).(varname)(cmpno))
                param=Models(modno).(varname){cmpno}';
                for pno=1:numel(param) T.Data{cmpno,pno+1}=param(pno); end
            end
        end
    end
    
    for x=1:numel(Models(modno).parnames) 
        T.ColumnFormat{x+1}=4; 
        T.ColumnWidth{x+1}=80;
    end
    T.AllowEmpty=1;
    T.AllowNan=0;
    T.ColumnFormat{1}='binary'; 
    T.ColumnWidth{1}=50;
    T.ViewPref=1;
    T.CellEditCallback='oo_model_vd(12.3)';
    T.ListSelCol=1;
    T.ColumnEditable=[1 zeros(1,numel(Models(modno).parnames))];
else
    T.data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

Modset.listtype=2;

% Set correct model type
val=strmatch(Models(Modset.currentmodel).modeltype,modeltypestr);
if ~isempty(val)
    val=val(1); set(ModelTypePop,'Value',val)
end


% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- getmodels ---------------------
function getmodels
global Metset Locset

pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- getvarname ---------------------
function varname=getvarname

ParametersList=findobj(gcf,'Tag','ParametersList');
val=get(ParametersList,'Value');
str=get(ParametersList,'String');
if isempty(str) varname=[]; return; end
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt_exp' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri_exp' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl_exp' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri_exp' ; end
if strcmp(selpar,'Area') varname='area_exp' ; end
if strcmp(selpar,'Height') varname='height_exp' ; end
if strcmp(selpar,'Response factor') varname='responsefactor_exp' ; end


% ------------------- tableposname ---------------------
function T=tableposname

global Pos

T.TableName='PlotVDInfoTable';
T.Position=[Pos.gl+5.5*Pos.gw Pos.yg(2) Pos.gw*2.6 Pos.gh*8];
T.Data=cell(0);

%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; 
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
x=Pos.xg; y=Pos.yg;

winpar{1}='ModelsWin'; winpar{2}='Chrombox Optimizer: VD models';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model_vd(99)',3,'','');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');

% Parameterslist
p=p+1;[ui{p,1:8}] = deal('Parameters:','Text',Colors.bc,[x(4) y(9) gw+bw eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Show all','Checkbox',Colors.bc,[x(4)+gw*0.8 y(9) gw+bw eh],'oo_model_vd(3.1)',2,'AllParamCheck','-fvp -fh');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(6) gw*0.5+bw gh*3],'oo_model_vd(3.3)',2,'ParametersList');

% Velocity list and second var
p=p+1;[ui{p,1:7}] = deal('Mobile phase velocity:','Text',Colors.bc,[x(4) y(3)+gh*2.0 gw+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3)+gh*1.4 gw*0.5+bw eh],'oo_model_vd(11.1)',2,'VelocityPop','-d');
p=p+1;[ui{p,1:7}] = deal('Interacting variable:','Text',Colors.bc,[x(4) y(3)+gh*0.6 gw+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3) gw*0.5+bw eh],'oo_model_vd(11.2)',2,'InterVaryPop','-d');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(1) y(10) bw eh],'oo_model_vd(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(1)+gw/2 y(10) bw eh],'oo_model_vd(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(2) y(10) bw eh],'oo_model_vd(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_model_vd(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Show models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_model_vd(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Types','PopupMenu',[1 1 1],[x(4)+gw/2 y(10) gw*1.4 eh],'oo_model_vd(7.1)',2,'ModelTypePop');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Quad+Int','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(9) bw  bh],'oo_model_vd(4.1)',2,'QuadIntBtn');
p=p+1;[ui{p,1:7}] = deal('Log+Int','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(8) bw  bh],'oo_model_vd(4.4)',2,'TimeModBtn');
p=p+1;[ui{p,1:7}] = deal('Van Deemter','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(7) bw  bh],'oo_model_vd(4.2)',2,'VDBtn');
p=p+1;[ui{p,1:7}] = deal('All levels','Popupmenu',[1 1 1],[x(5)+gw/2 y(6) bw  bh],'',2,'VDlevelsPop');
p=p+1;[ui{p,1:8}] = deal('A = 0','Checkbox',Colors.bc,[x(5)+gw/2 y(5)+eh/5 bw/2  eh],'oo_model_vd(13.1)',2,'ZeroACheck','-fvp');
p=p+1;[ui{p,1:8}] = deal('Mean A','Checkbox',Colors.bc,[x(5)+gw*0.92 y(5)+eh/5 bw/2  eh],'oo_model_vd(13.1)',2,'MeanACheck','-fvp');
p=p+1;[ui{p,1:7}] = deal('VD+Interact.','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(4) bw  bh],'oo_model_vd(4.3)',2,'VDIntBtn');
vp=y(3); hp=x(5)+gw/2;
p=p+1;[ui{p,1:7}] = deal('I','Checkbox',Colors.bc,[hp vp bw/2  bh],'',2,'IncludeICheck');
p=p+1;[ui{p,1:7}] = deal('BI','Checkbox',Colors.bc,[hp+bw*0.25 vp bw/2  bh],'',2,'IncludeBICheck');
p=p+1;[ui{p,1:7}] = deal('CI','Checkbox',Colors.bc,[hp+bw*0.5 vp bw/2  bh],'',2,'IncludeCICheck');
p=p+1;[ui{p,1:7}] = deal(['I' char(178)],'Checkbox',Colors.bc,[hp+bw*0.75 vp bw/2  bh],'',2,'IncludeIICheck');
vp=y(2);
p=p+1;[ui{p,1:7}] = deal('Thresh (%)','Checkbox',Colors.bc,[hp vp+eh/5 bw  bh],'',2,'SignTestCheck');
p=p+1;[ui{p,1:8}] = deal('0.1','Edit',[1 1 1],[hp+bw*0.7 vp+eh/5 bw/4  eh],'',2,'SignTestEdit','-c -fh -fvp');

% Figure selection
p=p+1;[ui{p,1:8}] = deal('Plot type:','Text',Colors.bc,[1-x(1)-gw*1.35 y(9) gw*1.25 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Upd:','Pushbutton',Colors.bc,[1-x(1)-gw*1.35+gw*0.45 y(9) gw*0.4 eh],'oo_model_vd(5.1)',2,'PlotUpdBtn','-fvp -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','CheckBox',Colors.bc,[1-x(1)-gw*1.35+gw*0.9 y(9) gw*0.4 eh],'',2,'PlotUpdCheck','-fvp -fh');
str={'Design','Surface','Opt. velocity','VD all levels','VD single level','Errors','Pred. vs meas.'};
p=p+1;[ui{p,1:8}] = deal(str,'Popupmenu',[1 1 1],[1-x(1)-gw*1.35 y(8)+gh*0.25 gw*1.25 eh],'oo_model_vd(5.0)',2,'PlotTypePop','');

% Scale
vp=y(7)+gh*0.4;
p=p+1;[ui{p,1:8}] = deal('X-scale: ','Text',Colors.bc,[1-x(1)-gw*1.35 vp-eh*0.5 gw*0.5 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.8 vp gw*0.35 eh],'oo_model_vd(10.1)',2,'XScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.44 vp gw*0.35 eh],'oo_model_vd(10.1)',2,'XScaleHighEdit','-c -fh -d');
vp=y(7)-gh*0.4;
p=p+1;[ui{p,1:8}] = deal('Y-scale: ','Text',Colors.bc,[1-x(1)-gw*1.35 vp-eh*0.5 gw*0.5 eh],'',2,'','-r -fh -fvp');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.8 vp gw*0.35 eh],'oo_model_vd(10.1)',2,'YScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[1-x(1)-gw*0.44 vp gw*0.35 eh],'oo_model_vd(10.1)',2,'YScaleHighEdit','-c -fh -d');

% VD plot options
vp=y(5)+gh*0.5;
p=p+1;[ui{p,1:8}] = deal('Mean','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_vd(95)',2,'ShowVdMeanCheck','-nvis');
vp=vp-gh*0.8; p=p+1;[ui{p,1:8}] = deal('Indiv.','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_vd(95)',2,'ShowVdIndCheck','-nvis');
vp=vp-gh*0.8; p=p+1;[ui{p,1:8}] = deal('Sums','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_vd(95)',2,'ShowVdSumCheck','-nvis');
vp=vp-gh*0.8; p=p+1;[ui{p,1:8}] = deal('ABC','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_vd(95)',2,'ShowVdABCCheck','-nvis');
vp=vp-gh*0.8; p=p+1;[ui{p,1:8}] = deal('Observ.','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp bw  eh],'oo_model_vd(95)',2,'ShowVdObsCheck','-nvis');

% Surface options
vp=y(5)+gh*0.5;
p=p+1;[ui{p,1:8}] = deal('Type:','Text',Colors.bc,[1-x(1)-gw*1.35 vp-eh*0.2 gw*0.5  eh],'',2,'SurfTypeTxt','-r -fvp -fh -nvis');
p=p+1;[ui{p,1:8}] = deal({'Mean','Sum','Min','Max'},'Popupmenu',[1 1 1],[1-x(1)-gw*0.8 vp gw*0.7 eh],'oo_model_vd(6.1)',2,'SurfTypePop','-nvis');
vp=vp-gh*0.8;
p=p+1;[ui{p,1:8}] = deal('Sel. X/Y:','Text',Colors.bc,[1-x(1)-gw*1.35 vp-eh*0.4 gw*0.5 eh],'',2,'SelXYText','-fh -fvp -r -nvis');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[1-x(1)-gw*0.8 vp gw*0.35 eh],'oo_model_vd(9.4)',2,'SelXEdit','-fh -c -nvis');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[1-x(1)-gw*0.44 vp gw*0.35 eh],'oo_model_vd(9.4)',2,'SelYEdit','-fh -c -nvis');
vp=vp-gh*0.8;
p=p+1;[ui{p,1:8}] = deal('Marker','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp-eh*0.3 bw eh],'oo_model_vd(9.5)',2,'ShowSelCheck','-fh -fvp -nvis');
vp=vp-gh*0.8;
p=p+1;[ui{p,1:8}] = deal('Show opt. vel.','Checkbox',Colors.bc,[1-x(1)-gw*0.8 vp-eh*0.3 bw eh],'oo_model_vd(5.1)',2,'OptVelCheck','-fh -fvp -nvis');

% Load / Save
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_model_vd(1.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_model_vd(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedModelsPop');
p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_model_vd(8.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Calc. Val.','Pushbutton',Colors.btn{1},[1-x(1)-bw*1.15 y(1) bw*0.55 eh],'oo_model_vd(14)',2,'');
p=p+1;[ui{p,1:7}] = deal(['Eff / time'],'Pushbutton',Colors.btn{1},[1-x(1)-bw*0.55 y(1) bw*0.55 eh],'oo_model_vda(0)',2,'');

updfcn='oo_model_vd(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model_vd(96)')
set(h0,'CloseRequestFcn','oo_model_vd(99)')

% Multiple selections
FilesList=findobj(gcf,'Tag','DataModelsList'); set(FilesList,'Max',2,'Min',0)
minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off')
end

MeanCheck=findobj(gcf,'Tag','MeanCheck'); set(MeanCheck,'Value',1);
AbsCheck=findobj(gcf,'Tag','AbsCheck'); set(AbsCheck,'Value',1);

SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','String','Mean'); set(SurfTypeRadio,'Value',1)
CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)
PlotUpdCheck=findobj(gcf,'Tag','PlotUpdCheck'); set(PlotUpdCheck,'Value',1)
OptVelCheck=findobj(gcf,'Tag','OptVelCheck'); set(OptVelCheck,'Value',1)
IncludeICheck=findobj(gcf,'Tag','IncludeICheck'); set(IncludeICheck,'Value',1)
IncludeBICheck=findobj(gcf,'Tag','IncludeBICheck'); set(IncludeBICheck,'Value',1)
IncludeCICheck=findobj(gcf,'Tag','IncludeCICheck'); set(IncludeCICheck,'Value',1)
