function oo_model_vd3(call)
% function oo_model_vd3(call)
% ver 150625 SAM
% global Metset Experimental Locset Modset Models
%

global Metset Experimental Locset Modset Models

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model_vd3 ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    Experimental=[];
    Models=[];
    Modset=[];
    Modset.listtype=1; % Data
    Modset.codetype=1; % Codes  
    Modset.velocityvar='';
    Modset.interactvar='';
    openwin
    getexperiments
    getmodels
    boxlist
    datalist
end

if call==1.1
    %disp('--- load data ---')
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' strs{val} '.mat' ];
    load(pathname,'Experimental')
    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    set(FileNameEdit,'String',strs{val})
    Experimental.activecmp(1:numel(Experimental.codes))=deal(true);
    Experimental.activeexp(1:numel(Experimental.expname))=deal(true);
    
    % Sqares peak widths in RI-units
    if isfield(Experimental,'wbl_ri_exp')
        Experimental.wbl_ri_exp=Experimental.wbl_ri_exp.^2;
    end
       
    Models=[];
    Modset=[]; Modset.listtype=1; Modset.codetype=1; Modset.velocityvar=''; Modset.interactvar=''; Modset.filename=strs{val};
    parameterslist
    boxlist
    listupdate  
    autovelpop
    modeltypes
    Modset.currentplot='Design'; plotupdate
end

% Update parameterslist
if call==3.1
    parameterslist
end
% Change parameter
if call==3.3
    listupdate
end

% Standard surface
if call==4.1
    calcmodels
    Modset.listtype=2; listupdate; plotupdate
end
% vdmodels
if call==4.2
    vdmodel
    Modset.listtype=2; listupdate; plotupdate
end
if call==4.3
    vdintmodel
    Modset.listtype=2; listupdate; plotupdate
end

% Plotting
if call==5.0 || call==5.1
    plotupdate
end

% surftype radios
if call==6.1
    tag=get(gcbo,'Tag');
    radios=findobj(gcf,'Tag',tag); set(radios,'Value',0)
    set(gcbo,'Value',1)
    plotupdate
end

if call==7.1
    listupdate; plotupdate
end

if call==8.1
    %disp('--- save model ---')
    if isempty(Models)
        zz_message(1,'No models to save','-r')
    else
        FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
        filename=get(FileNameEdit,'String');
        if isempty(filename)
            zz_message(1,'Select file name','-r')
        else
            Info.modeltype='VD';
            Info.savedtime=now;
            Info.user=Locset.user;
            Info.codeversion=Locset.version;
            pathname=[ Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
            oo_savefile(pathname,Models,Experimental,Modset,Info)
            zz_message(1,['Saved as ' pathname],'-b')
            getmodels
        end    
    end   
end

if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
    S=load(pathname);
    if isfield(S,'Info') && strcmp(S.Info.modeltype,'VD')
       Models=S.Models;
       Experimental=S.Experimental;
       Modset=S.Modset;
       Modset.filename=filename;
       FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
       set(FileNameEdit,'String',filename)
       parameterslist
       boxlist
       listupdate  
       modeltypes
       setvelocitypop
       plotupdate
    else
        if isfield(S,'Info') str=[' (' S.Info.modeltype ')']; else str=''; end
        zz_message(1,['Incorrect model type ' str],'-r')
    end
end

% graphical selection, contour plot
if call==9.1
    %disp('--- graphical selection ----')
    [cp]=get(gca,'CurrentPoint'); xp=cp(1,1); yp=cp(1,2);
    checkpoint(xp,yp)
end
% individual trace info
if call==9.2
    %disp('--- individualinfo ---')
    %get(gcbo)
    userdat=get(gcbo,'UserData');
    str{1}=Experimental.codes{userdat(1)}; str{2}=Experimental.names{userdat(1)}; str{3}=Experimental.shortnames{userdat(1)};
    InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String',str,'Value',1)
end
if call==9.3
    %disp('--- selected point ---')
    xp=get(gcbo,'XData'); 
    xp=xp(1); 
    yp=get(gcbo,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end
if call==9.35
    %disp('--- selected point ---')
    xp=get(gco,'XData');
    xp=xp(1); 
    yp=get(gco,'YData'); 
    yp=yp(1); checkpoint(xp,yp)   
end

% Input from edit
if call==9.4
    SelXEdit=findobj(gcf,'Tag','SelXEdit');
    xval=str2double(get(SelXEdit,'String'));
    set(SelXEdit,'String',num2str(xval));
    
    SelYEdit=findobj(gcf,'Tag','SelYEdit');
    yval=str2double(get(SelYEdit,'String'));
    set(SelYEdit,'String',num2str(yval));    
    
    if ~isnan(xval) && ~isnan(yval)
        checkpoint(xval,yval)
    end  
end

if call==9.5
    maha=findobj(gca,'Tag','SelectionMarker');
    if get(gcbo,'Value') set(maha,'Visible','on'); else set(maha,'Visible','off'); end
end

% set scale
if call==10.1
    str=get(gcbo,'String'); val=str2double(str); 
    if ~(~isnan(val) && val>=0); str='10'; end
    set(gcbo,'String',str)   
end

% Set velocity and interacting var:
if call==11.1 || call==11.2
    str=get(gcbo,'String'); val=get(gcbo,'Value'); selvar=str{val};
    InterVaryPop=findobj(gcf,'Tag','InterVaryPop');
    VelocityPop=findobj(gcf,'Tag','VelocityPop');
    allpnames=cell(0);
    for x=1:numel(Experimental.paramnames)
        pns=Experimental.paramnames{x};
        for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
    end
    allpnames=unique(allpnames);
    if numel(allpnames)==1 call=-99; end % Skips rest if only one var.
end

if call==11.1
    if strcmp(selvar,Modset.interactvar); Modset.interactvar=Modset.velocityvar; end
    Modset.velocityvar=selvar;
end
if call==11.2
    if strcmp(selvar,Modset.velocityvar); Modset.velocityvar=Modset.interactvar; end
    Modset.interactvar=selvar;
end
if call==11.1 || call==11.2
    setvelocitypop
    PlotTypePop=findobj(gcf,'Tag','PlotTypePop'); str=get(PlotTypePop,'String'); ind=strmatch('Design',str); set(PlotTypePop,'Value',ind); plotupdate
    modeltypes
end

% EVALUATE LISTS
if call==12.1 evalboxlist; end
if call==12.2 evaldatalist; end    
if call==12.3 evalmodelslist; end 

% EVALUATE  A-CHECKS
if call==13.1 && get(gcbo,'Value')
    set(findobj(gcf,'Tag','ZeroACheck'),'Value',0)
    set(findobj(gcf,'Tag','MeanACheck'),'Value',0)
    set(gcbo,'Value',1)
end

% Calculate values
if call==14.0
    calcvalues
end


% General plotupdate
if call==95
    plotupdate
end

% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end


% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model_vd3 (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end

%Modset
%Models
%if ~isempty(Models) 
%    Models(1)
%end
%if numel(Models)>1 
%    Models(2)
%end
%Experimental

% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ======================== PLOTTING FUNCTIONS ===========================


% ------------------- plotupdate ---------------------
function plotupdate
global Modset Experimental

%disp('--- plotupdate ---')

if isfield(Modset,'currentplot') currentplot=Modset.currentplot; else currentplot='Dummy'; end

% validplots
% 'Design','Surface','VD all levels','VD single level','Errors','Pred. vs meas.'
validplots={'Design'}; defaultplot={'Design'}; % always valid 

if isfield(Modset,'currentmodeltype')
    if strcmp(Modset.currentmodeltype,'VD')
        validplots={'Design','VD single level','Errors','Pred. vs meas.'};
        defaultplot='VD single level';
    end  
    if strncmp(Modset.currentmodeltype,'VD ',3)
        validplots={'Design','VD all levels','VD single level','Errors','Pred. vs meas.'};
        defaultplot='VD single level';
    end    
    if strcmp(Modset.currentmodeltype,'Quad+Int')
        validplots={'Design','Surface','Errors','Pred. vs meas.'};
        defaultplot='Surface';
    end
    if strcmp(Modset.currentmodeltype,'VD+Int')
        validplots={'Design','VD all levels','Surface','Errors','Pred. vs meas.'};
        defaultplot='Surface';
   end
end

PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
plotoptions=get(PlotTypePop,'String');
val=get(PlotTypePop,'Value');
selplot=plotoptions{val};
if isempty(strmatch(selplot,validplots))
    if strcmp('PlotTypePop',get(gcbo,'Tag')) 
        if isfield(Modset,'currentmodeltype') zz_message(1,[selplot ' is not a valid plot option for models of type ' Modset.currentmodeltype],'-r'); end
        selplot=currentplot;
    else
        selplot=defaultplot;
    end
end

% if designplot and new models
btnstr={'QuadIntBtn','VDIntBtn','VDBtn'};
if ~isempty(strmatch(get(gcbo,'Tag'),btnstr))
    selplot=defaultplot;
end

if isempty(Experimental)
    plot_dummy('No data'); Modset.currentplot='Dummy'; return
end
if strcmp(selplot,'Design')
    plot_design; 
end
if strcmp(selplot,'Errors')
    plot_validation; 
end
if strcmp(selplot,'Pred. vs meas.')
    plot_predmeas; 
end
if strcmp(selplot,'Surface')
    plot_surface; 
end
if strcmp(selplot,'VD single level')
    plot_vd_single; 
end
if strcmp(selplot,'VD all levels') && ~strncmp('VD+',Modset.currentmodeltype,3)
    plot_vd_multiple; 
end
if strcmp(selplot,'VD all levels') && strncmp('VD+',Modset.currentmodeltype,3)
    plot_vd_est; 
end

Modset.currentplot=selplot;
setval=strmatch(Modset.currentplot,plotoptions);
if ~isempty(setval) set(PlotTypePop,'Value',setval); end


% ------------------- plot_design ---------------------
function plot_design
global Pos

Calibdata=calibdata;

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

subplot('Position',Pos.rightplot)

if ~isempty(Calibdata.X)
    
    [n_exp,n_factors]=size(Calibdata.X); 
    if n_factors<2 Calibdata.X(1:n_exp,2)=0; end

    XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
    YScaleEdit=findobj('Tag','YScaleEdit'); yscaleoffs=str2double(get(YScaleEdit,'String'));
    min_x=min(Calibdata.X(:,1)); max_x=max(Calibdata.X(:,1)); o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
    min_y=min(Calibdata.X(:,2)); max_y=max(Calibdata.X(:,2)); o=(max_y-min_y)*(yscaleoffs/100); min_y=min_y-o; max_y=max_y+o;

    [m,n]=size(Calibdata.X);
    for x=1:m
    
        h=plot(Calibdata.X(x,1),Calibdata.X(x,2),'o','MarkerSize',18,'MarkerFaceColor',[0.8 0.8 0.8],'MarkerEdgeColor',[0.6 0.6 0.6],'LineWidth',3);
        text(Calibdata.X(x,1),Calibdata.X(x,2),num2str(Calibdata.expno(x)),'HorizontalAlignment','Center','FontWeight','bold')
        hold on
    end
    hold off

    if max_x>min_x xlim([min_x max_x]); else xlim([min_x-1 max_x+1]); end
    if max_y>min_y ylim([min_y max_y]); else ylim([min_y-1 max_y+1]); end
    
else
    text(0,0,'No data','HorizontalAlignment','Center','FontSize',18,'FontWeight','bold')
    xlim([-1 1]); ylim([-1 1]);
end

% ------------------- plot_dummy ---------------------
function plot_dummy(str)
global Pos 

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')
ah=subplot('Position',Pos.rightplot);
set(ah,'XTick',[],'YTick',[])
text(0.5,0.5,str,'Units','Normalized','HorizontalAlignment','center',...
    'VerticalAlignment','middle','FontWeight','bold','FontSize',12)
xlim([-1 1]); ylim([-1 1])


% ------------------- plot_surface ---------------------
function plot_surface
global Models Experimental Modset Pos

%disp('--- plot_surface ---')

if ~isfield(Modset,'currentmodel') return; end

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

modno=Modset.currentmodel;
typematch=strmatch(Models(modno).modeltype,{'Quad+Int','VD+Int'},'exact');
if isempty(typematch) plot_dummy('Models cannot be shown as surface'); return; end % Wrong model type

selcmp=find(Experimental.activecmp);

varname=getvarname;

if isfield(Models,varname)
    l_models=length(Models(modno).(varname));
else
    zz_message(1,'No models','-r')
    return
end

missingmodels=[]; validmodels=[]; n_valids=0; ZM=[]; ZM_sum=[]; alldesign=[]; 
for x=1:length(selcmp)
    cmp=selcmp(x);
    if cmp<=l_models
        coeff=Models(modno).(varname){cmp};
        design=Models(modno).([varname '_design']){cmp};
    else
        coeff=[]; design=[];
    end
    if ~isempty(coeff) && sum(isnan(coeff))==0
        validmodel=1;
        [X_cont,Y_cont,Z_cont]=calcsurf(coeff,design,typematch);
    else
        validmodel=0;
        missingmodels=[missingmodels cmp];
    end

    if validmodel              
        n_valids=n_valids+1;
        alldesign=[alldesign design];
        validmodels(n_valids)=cmp; 
        if n_valids==1
            ZM_sum=Z_cont;
            ZM_max=Z_cont;
            ZM_min=Z_cont;
        else
            ZM_sum=ZM_sum+Z_cont; % sum
            ZM_max=max(ZM_max,Z_cont); % max
            ZM_min=min(ZM_min,Z_cont); % min
        end  
        CM(n_valids,:)=coeff; % Save coefficients, used for optimal velocity
    end
end


if isempty(ZM_sum)==0   
    SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','Value',1);
    surftype=get(SurfTypeRadio,'String');
    if strcmp(surftype,'Mean')
        ZM=ZM_sum/n_valids;
        boxstr{3}='Mean surface of:';
    end
    if strcmp(surftype,'Sum')
        ZM=ZM_sum;
        boxstr{3}='Sum surface of:';
    end    
    if strcmp(surftype,'Max')
        ZM=ZM_max;
        boxstr{3}='Max surface of:';
    end  
    if strcmp(surftype,'Min')
        ZM=ZM_min;
        boxstr{3}='Min surface of:';
    end   
    
    alldesign=unique(alldesign','rows')'; 
    contourplot(X_cont,Y_cont,ZM,alldesign)  
    
    % Add line for Optimal Velocity
    if get(findobj(gcf,'Tag','OptVelCheck'),'Value')
        CC=mean(CM,1); I=Y_cont(1,:); B=CC(2); C=CC(3); E=CC(5); F=CC(6);
        ov=((B+E*I)/C).^0.5; % Vector of optimal velocity  
        hold on
        vstr='Vel.'; if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar) vstr=Modset.velocityvar; end
        istr='I'; if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar) istr=Modset.interactvar; end
        UserDat.text=['Opt.' vstr ' = root((' num2str(B,3) ' + ' num2str(E,3) char(215) istr ') / ' num2str(C,3) ')' ];
        h=plot(ov,I,'-','Color',[0.5 0.5 0.5],'LineWidth',2,'Tag','OptvelLine','ButtonDownFcn','oo_model_vd3(9.3)','UserData',UserDat);
        hold off
    end

    % set userdata
    Userdat.plottype='surface';
    Userdat.modeltype=Models(modno).modeltype;
    set(gca,'UserData',Userdat); 
        
    % set text box
    boxstr{1}=['Model type: ' Models(modno).modeltype];
    ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
    boxstr{2}=['Variable:' str{val}];
    if isempty(validmodels)
        boxstr{1}='No valid models';
    else
        switch Modset.codetype
            case 1; cmplabs=Experimental.codes;
            case 2; cmplabs=Experimental.names;
            case 3; cmplabs=Experimental.shortnames;
        end
        for x=1:numel(validmodels)
            boxstr(numel(boxstr)+1)=cmplabs(validmodels(x));  
        end        
        set(InfoBox,'String',boxstr)
        zz_copylist(0,InfoBox)
    end
  
    str=[];
    if ~isempty(missingmodels)
        str=['- Missing models: '];
        for x=1:length(missingmodels)
            str=[str num2str(missingmodels(x)) ' '];
        end
    end
    if isempty(str)
        zz_message(1,'No missing values','-b')
    else
        zz_message(1,str,'-r')
    end  
        
else 
    zz_message(1,'No valid models','-r')
end


% ------------------- plot_validation ---------------------
function plot_validation
global Experimental Models Pos Modset

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

if ~isfield(Modset,'currentmodel') plot_dummy('No models'); return; end

modno=Modset.currentmodel;
selcmp=find(Experimental.activecmp);

varname=getvarname;

switch Modset.codetype
    case 1; cmplabs=Experimental.codes;
    case 2; cmplabs=Experimental.names;
    case 3; cmplabs=Experimental.shortnames;
end

ncmp=0;
for p=1:length(selcmp)
    cmp=selcmp(p);
    if cmp<=numel(Models(modno).([varname '_errors']))       
        terrors=Models(modno).([varname '_errors']){cmp};
        terrornames=Models(modno).errornames;
        rmseind=strmatch('RMS',terrornames,'exact'); rmseind=rmseind(1);
        rmseadjind=strmatch('RMS_adj',terrornames,'exact'); rmseadjind=rmseadjind(1);
        r2ind=strmatch('R2',terrornames,'exact'); r2ind=r2ind(1);
        biasind=strmatch('Bias',terrornames,'exact'); biasind=biasind(1);
        if ~isempty(terrors) && sum(isnan(terrors))==0 
            ncmp=ncmp+1;
            rmse(ncmp)=terrors(rmseind);
            rmseadj(ncmp)=terrors(rmseadjind);
            r2(ncmp)=terrors(r2ind);
            bias(ncmp)=terrors(biasind);
            cmplab{ncmp}=cmplabs{cmp}; 
            df(ncmp)=Models(modno).([varname '_df']){cmp};
            nparam(ncmp)=Models(modno).([varname '_nparam']){cmp};
        end
    end
end

if ncmp==0 plot_dummy('No models selected'); return; end
if sum(df)==0 plot_dummy('No compounds with degrees of freedom > 0'); return; end

% TEXT OUTPUT
nexp=df+nparam; % number of experiments
boxstr{1}='ERRORS:';
boxstr{2}=['Model type: ' Models(modno).modeltype]; 
ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
boxstr{3}=['Variable: ' str{val}]; 
boxstr{4}='';

for p=1:ncmp
    if df(p)>0
        boxstr{numel(boxstr)+1}=[cmplab{p}...
            ', RMSE=' num2str(rmse(p),3)...
            ', RMSE(adj)=' num2str(rmseadj(p),3)...
            ', R' char(178) '=' num2str(r2(p),'%1.4f')...
            ', Bias=' num2str(bias(p),3)...
            ', DF=' num2str(df(p))...
            ', N.exp.=' num2str(nexp(p))];
    else
        boxstr{numel(boxstr)+1}=[cmplab{p} ', Degrees of freedom = 0' ', N.exp.=' num2str(nexp(p))];
    end
end
boxstr{numel(boxstr)+1}=['Mean:'...  
    ', RMSE=' num2str(mean(rmse),3)...
    ', RMSE(adj)=' num2str(mean(rmseadj),3)...
    ', R' char(178) '=' num2str(mean(r2),'%1.4f')...
    ', Bias=' num2str(mean(bias),3)...
    ', DF=' num2str(mean(df),3)...
    ', N.exp.=' num2str(mean(nexp),3)];
    
set(InfoBox,'String',boxstr)
zz_copylist(0,InfoBox)

% PLOTTING
valids=df>0;
cmplab=cmplab(valids);
rmse=rmse(valids);
rmseadj=rmseadj(valids);
ncmp=sum(valids);

hp=max(rmseadj)/100;
subplot('Position',Pos.rightplot)

po=0.4;
for x=1:ncmp
    patch([0 rmseadj(x) rmseadj(x) 0],[x-po x-po x+po x+po],[1 0.5 0.5]*0.8,'EdgeColor','none')
    patch([0 rmse(x) rmse(x) 0],[x-po x-po x+po x+po],[1 0.5 0.5],'EdgeColor','none')
    text(hp,x,[cmplab{x} ', RMSE=' num2str(rmse(x),3) ', RMSE adj.=' num2str(rmseadj(x),3)],'FontWeight','bold')
end
line([0 0],[0,ncmp+1],'Color',[0 0 0])
text(0.95,0.95,'RMSE / RMSE adj.','Units','Normalized','HorizontalAlignment','right','FontWeight','bold','FontSize',12)
set(gca,'Box','on','YTick',[])

ylim([0,ncmp+0.5]*1.08)
maxval=max([rmseadj rmse]); 
xlim([0,maxval*1.02])

zz_copyfigure


% ------------------- plot_predmeas ---------------------
function plot_predmeas
global Experimental Models Pos Modset

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

if ~isfield(Modset,'currentmodel') plot_dummy('No models'); return; end

modno=Modset.currentmodel;
selcmp=find(Experimental.activecmp);

varname=getvarname;

predmeas=Models(modno).([varname '_predmeas']);
nvalids=numel(predmeas)-sum(cellfun('isempty',predmeas));

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

switch Modset.codetype
    case 1; cmplabs=Experimental.codes;
    case 2; cmplabs=Experimental.names;
    case 3; cmplabs=Experimental.shortnames;
end

subplot('Position',Pos.rightplot)
nplot=0;

allpredmeas=[];
for p=1:length(selcmp)
    cmp=selcmp(p);
    if cmp<=numel(Models(modno).([varname '_predmeas']))
        predmeas=Models(modno).([varname '_predmeas']){cmp};
        if sum(sum(isnan(predmeas)))==0
            allpredmeas=[allpredmeas predmeas];
            if ~isempty(predmeas)
                nplot=nplot+1;
                plot(predmeas(1,:),predmeas(2,:),'o','MarkerFaceColor',cols(cmp,:),'MarkerEdgeColor','none'); hold on
                minv(nplot)=min(min(predmeas)); maxv(nplot)=max(max(predmeas));
                errors{nplot}=Models(modno).([varname '_errors']){cmp};
                cmplab{nplot}=cmplabs{cmp};
                textcol{nplot}=cols(cmp,:);
            end
        end
    end
end

if nplot==0 plot_dummy('No valid models'); return; end

maxv=max(maxv); minv=min(minv); o=(maxv-minv)/20;
xlim([minv-o maxv+o]); ylim([minv-o maxv+o])
line([minv maxv],[minv maxv],'Color',[0.7 0.7 0.7]);

text(0.03,0.95,'Predicted','Units','Normalized','FontWeight','bold','FontSize',10)
text(0.97,0.05,'Measured','Units','Normalized','FontWeight','bold','HorizontalAlignment','right','FontSize',10)

% calc overall R2
R=corrcoef(allpredmeas(1,:),allpredmeas(2,:)); R2=R(1,2)^2;

% set text box and header
headerstr{1}='Predicted vs measured'; boxstr{1}='PREDICTED VS MEASURED:';
boxstr{2}=['Model type: ' Models(modno).modeltype]; headerstr{2}=boxstr{2};
ParametersList=findobj(gcf,'Tag','ParametersList'); val=get(ParametersList,'Value'); str=get(ParametersList,'String');
boxstr{3}=['Variable: ' str{val}]; headerstr{3}=boxstr{3};
boxstr{4}='';
headerstr{4}=['Overall R' char(178) '=' num2str(R2,4)]; 

hp=maxv-o*1.5;
for x=1:numel(cmplab)
    text(minv-o*0.2,hp,cmplab{x},'Color',textcol{x},'FontWeight','bold')
    hp=hp-o*0.8;
    boxstr{numel(boxstr)+1}=[cmplab{x} ', RMSE(adj)=' num2str(errors{x}(2),3) ', R' char(178) '=' num2str(errors{x}(3),3) ', Bias=' num2str(errors{x}(4),3)];
end
boxstr{numel(boxstr)+1}=headerstr{4};

set(InfoBox,'String',boxstr)
zz_copylist(0,InfoBox)

text(0.5,0.95,headerstr,'Units','Normalized','FontWeight','bold','FontSize',12,'HorizontalAlignment','center','VerticalAlignment','top')

zz_copyfigure

% ------------------- plot_vd_est ---------------------
function plot_vd_est
global Models Experimental Modset Pos

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

% Set variables for plot type
set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdIndCheck'),'Value',0);
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 

for x=1:numel(Models) modeltypes{x}=Models(x).modeltype; end
modind=strmatch('VD+Int',modeltypes);
if isempty(modind) plot_dummy('No VD+Int models'); return; end

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Find models
activecmp=Experimental.activecmp;
if sum(activecmp)==0 plot_dummy('No compounds selected'); return; end % nothing selected

varname=getvarname;

% Get model data and constrain to valid models
p=0;
for x=1:numel(Models(modind).(varname))
    c=Models(modind).(varname){x};
    if activecmp(x) && sum(isnan(c))==0 && numel(c)==7
        p=p+1;
        Coeff{p}=Models(modind).(varname){x};
        Labels(p)=cmplab(x);
        Designs{p}=Models(modind).([varname '_design']){x};
        Predmeas{p}=Models(modind).([varname '_predmeas']){x}; % first row in predmeas is measured
    end      
end

% Find the correct designpoints (xp and yp)
xp=[]; yp=[]; 
if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar)
    velname=Modset.velocityvar;
    for p=1:numel(Experimental.paramnames)
        xind=strmatch(velname,Experimental.paramnames{p}); xind=xind(1);
        xp(p)=Experimental.parameters(xind,p);
    end   
    xp=xp(Experimental.activeexp);
end
if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar)
    intname=Modset.interactvar;
    for p=1:numel(Experimental.paramnames)
        yind=strmatch(intname,Experimental.paramnames{p}); yind=yind(1);
        yp(p)=Experimental.parameters(yind,p);
    end 
    yp=yp(Experimental.activeexp);
    
end

ylevels=unique(yp); if isempty(ylevels) ylevels=0; end

% Estimate A, B and C terms
for lno=1:numel(ylevels)
    meas=[]; lev=[]; xvals=[];  % Initialize variables for saving avg of observations
    for p=1:numel(Coeff)
        c=Coeff{p};
        A_terms(p)=c(1)+c(4)*ylevels(lno)+c(7)*ylevels(lno)^2;
        B_terms(p)=c(2)+c(5)*ylevels(lno);
        C_terms(p)=c(3)+c(6)*ylevels(lno);
        
        % Variables for saving avg of observations
        meas=[meas Predmeas{p}(1,:)];
        lev=[lev Designs{p}(2,:)];
        xvals=[xvals Designs{p}(1,:)];
        
    end
    A_means(lno)=mean(A_terms);
    B_means(lno)=mean(B_terms);
    C_means(lno)=mean(C_terms);
    
    % Saves data for plotting of observed values
    levind=lev==ylevels(lno); % Finds data with right levels
    xvals=xvals(levind); meas=meas(levind); % Constrains
    uniquex=unique(xvals); meanmeas=[];
    for x=1:numel(uniquex)
        ind=find(xvals==uniquex(x));
        measind=meas(ind);
        measind(isnan(measind))=[]; % removes NaNs
        meanmeas(x)=mean(measind);
    end
    Observ{lno}=[uniquex; meanmeas]; % Saves observations for later use
end

% Constructs x-axis
XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
min_x=min(xp); max_x=max(xp); 
if max_x-min_x <=0 min_x=-1; max_x=1; end
o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
x_axis=linspace(min_x,max_x,100);
x_axis_inv=1./x_axis;

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(ylevels)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

ah=subplot('Position',Pos.rightplot); 
for modno=1:numel(ylevels)
    A=repmat(A_means(modno),1,numel(x_axis));
    B=B_means(modno)*x_axis_inv;
    C=C_means(modno)*x_axis;
    S=(A+B+C);
    if showabc
        plot(x_axis,[A;B;C],'Color',cols(modno,:)); hold on
    end
    if showsum
        plot(x_axis,S,'Color',cols(modno,:),'LineWidth',2); hold on
    end    
    optivel(modno)=(B_means(modno)/C_means(modno))^0.5;       
    yminv(modno)=A_means(modno)+B_means(modno)/optivel(modno)+C_means(modno)*optivel(modno);
    if showpoints
        plot(Observ{modno}(1,:),Observ{modno}(2,:).^2,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',cols(modno,:))
    end              
end
hold off
text(0.5,0.95,'Calculated from VD+Int model','Units','Normalized','HorizontalAlignment','Center','FontSize',12,'FontWeight','bold')

% Scaling and labels
axis tight
[yax]=get(ah,'ylim'); 
ymin=yax(1); ymax=yax(2); xmin=min(x_axis); xmax=max(x_axis);
yrange=ymax-ymin; xrange=xmax-xmin;
texthp=xmax+xrange/100;
textvp=linspace(ymax*0.98,0,max([20 numel(ylevels)+1]));
textext=[];
if isfield(Modset,'interactvar') str=Modset.interactvar; else str=''; end
for modno=1:numel(ylevels)
    th=text(texthp,textvp(modno),[str '=' num2str(ylevels(modno))],'Color',cols(modno,:),'FontWeight','bold','FontSize',12);
    ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
end

minyval=ymin-yrange*0.05; if minyval>0 minyval=0; end
xlim([xmin xmax+xrange/100+(max(textext)*1.5)])
ylim([minyval ymax+yrange*0.05])

zz_copyfigure

% Text
ostr{1,1}='MEAN VD MODELS CALCULATED FROM VD+INT';
if isfield(Modset,'interactvar') str=Modset.interactvar; else str=''; end
for modno=1:numel(ylevels)
    ostr{numel(ostr)+1,1}=['Optimal vel. for ' str '=' num2str(ylevels(modno)) ' = ' num2str(optivel(modno),'%6.4f') ', Min.Y = ' num2str(yminv(modno),4)];
    ostr{numel(ostr)+1,1}=['A = ' num2str(A_means(modno),'%6.4f') ', B = ' num2str(B_means(modno),'%6.4f') ', C = ' num2str(C_means(modno),'%6.4f')];
end
ostr{numel(ostr)+1,1}=' ';
ostr{numel(ostr)+1,1}='Applied compounds:';
for x=1:numel(Labels)
    ostr{numel(ostr)+1,1}=Labels{x}; 
end

set(InfoBox,'String',ostr)
zz_copylist(0,InfoBox)




% ------------------- plot_vd_multiple ---------------------
function plot_vd_multiple
global Models Experimental Modset Pos

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

activecmp=find(Experimental.activecmp);
if isempty(activecmp) plot_dummy('No compounds selected'); return; end % nothing selected

% Check model type
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modtypes=get(ModelTypePop,'String');
modtype=modtypes{get(ModelTypePop,'Value')};
if ~strncmp(modtype,'VD',2) plot_dummy('Incorrect model type'); return; end % Wrong type

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

for x=1:numel(Models)
    modeltypes{x}=Models(x).modeltype;
end
teststr=['VD ' Modset.interactvar];
validmodels=strmatch(teststr,modeltypes);
if isempty(validmodels) plot_dummy('No VD models'); return; end

% Set variables for plot type
set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1);
set(findobj(gcf,'Tag','ShowVdIndCheck'),'Value',0);
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value'); 

% Check levels
for modno=1:numel(validmodels)
    nmod=0; varname=getvarname; P=[];
    paramcell=Models(validmodels(modno)).(varname);
    designcell=Models(validmodels(modno)).([varname '_design']);
    predmeascell=Models(validmodels(modno)).([varname '_predmeas']);
    
    meas=[]; xvals=[];  % Initialize variables for saving avg of observations
    
    for x=1:numel(activecmp)
        if numel(paramcell)>=activecmp(x) && ~isempty(paramcell{activecmp(x)}) && numel(paramcell{activecmp(x)})==3 && sum(isnan(paramcell{activecmp(x)}))==0
            nmod=nmod+1;           
            DM=designcell{activecmp(x)};
            minv(nmod)=min(DM(1,:));
            maxv(nmod)=max(DM(1,:));
            P(nmod,:)=paramcell{activecmp(x)};
            labels{modno,nmod}=cmplab{activecmp(x)};
            % Calculation of measured
            meas=[meas predmeascell{activecmp(x)}(1,:)];
            xvals=[xvals designcell{activecmp(x)}(1,:)];
        end
    end
    
    % Saves observations
    uniquex=unique(xvals);
    for x=1:numel(uniquex)
        ind=find(xvals==uniquex(x)); 
        measind=meas(ind);
        measind(isnan(measind))=[]; % removes NaNs
        meanmeas(x)=mean(measind);
    end
    Observ{modno}=[uniquex; meanmeas]; % Saves observations for later use

    nanind=find(sum(isnan(P),2)); 
    if ~isempty(nanind) P(nanind,:)=[]; labels{modno,nanind}=''; end 
    parameters{modno}=mean(P,1); % parameters stored here
end

% Constructs x-axis
XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
min_x=min(min(minv)); max_x=max(max(maxv)); 
if max_x-min_x <=0 min_x=-1; max_x=1; end
o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
x_axis=linspace(min_x,max_x,100);
x_axis_inv=1./x_axis;

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 1 1 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(validmodels)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

ah=subplot('Position',Pos.rightplot); 
for modno=1:numel(validmodels)
    param=parameters{modno};
    if ~isempty(param) && sum(isnan(param))==0
        A=repmat(param(1),1,numel(x_axis));
        B=param(2)*x_axis_inv;
        C=param(3)*x_axis;
        S=(A+B+C);
        if showabc
            plot(x_axis,[A;B;C],'Color',cols(modno,:)); hold on
        end
        if showsum
            plot(x_axis,S,'Color',cols(modno,:),'LineWidth',2); hold on
        end    
        if showpoints
           plot(Observ{modno}(1,:),Observ{modno}(2,:).^2,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',cols(modno,:))
        end  
        optivel(modno)=(param(2)/param(3))^0.5;
    end 
end
text(0.5,0.95,'Independent VD models','Units','Normalized','HorizontalAlignment','Center','FontSize',12,'FontWeight','bold')
hold off


% Scaling and labels
axis tight
[yax]=get(ah,'ylim'); 
ymin=yax(1); ymax=yax(2); xmin=min(x_axis); xmax=max(x_axis);
yrange=ymax-ymin; xrange=xmax-xmin;
texthp=xmax+xrange/100;
textvp=linspace(ymax*0.98,0,max([20 nmod+1]));
textext=[];
for modno=1:numel(validmodels)
    str=Models(validmodels(modno)).modeltype;
    th=text(texthp,textvp(modno),str(4:end),'Color',cols(modno,:),'FontWeight','bold','FontSize',12);
    ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
end

minyval=ymin-yrange*0.05; if minyval>0 minyval=0; end
xlim([xmin xmax+xrange/100+(max(textext)*1.5)])
ylim([minyval ymax+yrange*0.05])

zz_copyfigure

% Text
ostr{1,1}='MEAN VD MODELS';
[m,n_cmp]=size(labels);
for modno=1:numel(validmodels)
    param=parameters{modno};
    yminv=param(1)+param(2)/optivel(modno)+param(3)*optivel(modno);
    ostr{numel(ostr)+1,1}=['Optimal vel. for ' Models(validmodels(modno)).modeltype(4:end) ' = ' num2str(optivel(modno),'%6.4f') ', Min.Y = ' num2str(yminv,4)];
    ostr{numel(ostr)+1,1}=['A = ' num2str(param(1),'%6.4f') ', B = ' num2str(param(2),'%6.4f') ', C = ' num2str(param(3),'%6.4f')];
end
ostr{numel(ostr)+1,1}=' ';
ostr{numel(ostr)+1,1}='Applied compounds:';
STR1=strvcat(ostr);

ostr2{1,1}=' ';
alllabels=labels;
alllabels(cellfun('isempty',alllabels))={''};
alllabels=unique(alllabels); alllabels(cellfun('isempty',alllabels))=[];
for y=1:numel(alllabels) ostr2{y+1,1}=[alllabels{y} '  ']; end
for modno=1:numel(validmodels)
    ostr2{1,modno+1}=[Models(validmodels(modno)).modeltype(4:end) '  ']; 
    usedcmp=labels(modno,:);
    usedcmp(cellfun('isempty',usedcmp))=[];
    for x=1:numel(alllabels)
        ind=strmatch(alllabels{x},usedcmp,'exact');
        if isempty(ind) ostr2{x+1,modno+1}='   '; else ostr2{x+1,modno+1}='+  '; end
    end
end

[m,n]=size(ostr2); STR2=[];
for x=1:n STR2=[STR2 strvcat(ostr2(:,x))]; end

set(InfoBox,'String',strvcat(STR1,STR2))
zz_copylist(0,InfoBox)


% ------------------- plot_vd_single ---------------------
function plot_vd_single
global Models Experimental Modset Pos

disp('--- plot_vd_single --- (vd3)')

eh=findobj(gcf,'Position',Pos.rightplot); delete(eh) % deletes existing
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

% Compound labels
if Modset.codetype==1 cmplab=Experimental.codes; end
if Modset.codetype==2 cmplab=Experimental.names; end
if Modset.codetype==3 cmplab=Experimental.shortnames; end

% Check model type
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modtypes=get(ModelTypePop,'String');
modtype=modtypes{get(ModelTypePop,'Value')};
if ~strncmp(modtype,'VD',2) plot_dummy('Incorrect model type'); return; end % Wrong type

% Set variables for plot type
showmean=get(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value');
showind=get(findobj(gcf,'Tag','ShowVdIndCheck'),'Value');
if showmean+showind==0 showmean=1; set(findobj(gcf,'Tag','ShowVdMeanCheck'),'Value',1); end
showabc=get(findobj(gcf,'Tag','ShowVdABCCheck'),'Value');
showsum=get(findobj(gcf,'Tag','ShowVdSumCheck'),'Value');
if showabc+showsum==0 showsum=1; set(findobj(gcf,'Tag','ShowVdSumCheck'),'Value',1); end

modno=findmodels(modtype); % model number

activecmp=find(Experimental.activecmp); 
if isempty(activecmp) plot_dummy('No models selected'); return; end % nothing selected

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(Experimental.activecmp)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end

% Check levels
nmod=0; varname=getvarname; P=[];
paramcell=Models(modno).(varname);
designcell=Models(modno).([varname '_design']);
predmeascell=Models(modno).([varname '_predmeas']);
for x=1:numel(activecmp)
    if numel(paramcell)>=activecmp(x) && ~isempty(paramcell{activecmp(x)}) && numel(paramcell{activecmp(x)})==3 && sum(isnan(paramcell{activecmp(x)}))==0
        nmod=nmod+1;
        PlotColor(nmod,:)=cols(activecmp(x),:);
        P(nmod,:)=paramcell{activecmp(x)};
        
        DM=designcell{activecmp(x)}; 
        Designpoints{nmod}=DM(1,:);
        minv(nmod)=min(DM(1,:));
        maxv(nmod)=max(DM(1,:));
        
        PM=predmeascell{activecmp(x)}; Measpoints{nmod}=PM(1,:); % Measured for plotting        
        labels{nmod}=cmplab{activecmp(x)};
    end
end

% Constructs x-axis
XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
min_x=min(minv); max_x=max(maxv); 
if max_x-min_x <=0 min_x=-1; max_x=1; end
o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
x_axis=linspace(min_x,max_x,100);
x_axis_inv=1./x_axis;

% Calculate matrices
A=repmat(P(:,1),1,numel(x_axis)); mina=min(min(A)); maxa=max(max(A)); mean_A=mean(A,1);
B=P(:,2)*x_axis_inv; minb=min(min(B)); maxb=max(max(B)); mean_B=mean(B,1);
C=P(:,3)*x_axis; minc=min(min(C)); maxc=max(max(C)); mean_C=mean(C,1);
S=A+B+C; mins=min(min(S)); maxs=max(max(S)); mean_S=mean(S,1);
miny=min([mina minb minc mins]); maxy=max([maxa maxb maxc maxs]);

% Plotting
showpoints=get(findobj(gcf,'Tag','ShowVdObsCheck'),'Value')
ah=subplot('Position',Pos.rightplot); 
if showind
    for x=1:nmod    
        
        if showabc 
            plot(x_axis,A(x,:),'Color',PlotColor(x,:),'LineWidth',1); hold on; 
            plot(x_axis,B(x,:),'Color',PlotColor(x,:),'LineWidth',1);
            plot(x_axis,C(x,:),'Color',PlotColor(x,:),'LineWidth',1);
        end
        if showsum 
            plot(x_axis,S(x,:),'Color',PlotColor(x,:),'LineWidth',2); hold on
        end
        if showpoints
            if numel(Designpoints{x})==numel(Measpoints{x})
                plot(Designpoints{x},Measpoints{x}.^2,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',PlotColor(x,:));
            end
        end   
    end
end

if showmean
    if showabc
        plot(x_axis,mean_A,'Color',[0 0 0],'LineWidth',3);  hold on
        plot(x_axis,mean_B,'Color',[0 0 0],'LineWidth',3);
        plot(x_axis,mean_C,'Color',[0 0 0],'LineWidth',3);
    end
    if showsum 
        plot(x_axis,mean_S,'Color',[0 0 0],'LineWidth',4); hold on
    end    
    if showpoints
        design=[]; for x=1:nmod design=[design Designpoints{x}]; end; design=unique(design);
        for dno=1:numel(design)
            vals=[];
            for modno=1:nmod
                meas=Measpoints{modno}; ind=find(Designpoints{nmod}==design(dno)); 
                if ~isempty(ind) ind=ind(1); vals=[vals meas(ind)]; end
            end
            vals(isnan(vals))=[]; meanvals(dno)=mean(vals);
        end
        plot(design,meanvals.^2,'o','MarkerEdgeColor',[1 1 1],'MarkerFaceColor',[0 0 0])
    end
end
hold off

% Scaling and labels
axis tight
[yax]=get(ah,'ylim'); 
ymin=min([yax(1) 0]); ymax=yax(2); xmin=min(x_axis); xmax=max(x_axis);
yrange=ymax-ymin; xrange=xmax-xmin;
texthp=xmax+xrange/100;
textvp=linspace(ymax,ymin,max([20 nmod+1]));
textext=[];

if showind && nmod>1
    for x=1:nmod
        th=text(texthp,textvp(x),labels{x},'FontWeight','normal','FontSize',10,'Fontweight','bold','Color',PlotColor(x,:));
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);       
    end
    if showmean
        th=text(texthp,textvp(x+1),'Mean','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',[0 0 0]);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
else
    if showmean col=[0 0 0]; else col=PlotColor(1,:);end
    if showsum
        th=text(texthp,mean_S(end),'Sum','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);       
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
    end
    if showabc
        th=text(texthp,mean_A(end),'A','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
        th=text(texthp,mean_B(end),'B','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);
        th=text(texthp,mean_C(end),'C','FontWeight','normal','FontSize',12,'Fontweight','bold','Color',col);
        ext=get(th,'Extent'); textext(numel(textext)+1)=ext(3);    
    end
end

minyval=ymin-yrange*0.05; if minyval>0 minyval=0; end
xlim([xmin xmax+xrange/100+(max(textext)*1.5)])
ylim([minyval ymax+yrange*0.05])

zz_copyfigure

str{1}=['MODELS: ' modtype];
optvel=(mean(P(:,2))/mean(P(:,3)))^0.5;
yminv=mean(P(:,1)) + mean(P(:,2))/optvel + mean(P(:,3))*optvel;
str{2}=['Optimal velocity for mean: ' num2str(optvel,4) ', Min.Y: ' num2str(yminv,4)];

str{3}=['Mean A=' num2str(mean(P(:,1)),4) ', Mean B=' num2str(mean(P(:,2)),4) ', Mean C=' num2str(mean(P(:,3)),4)];
str{5}='Individual models:';
for x=1:numel(labels)
    optvel=(mean(P(x,2))/mean(P(x,3)))^0.5; 
    yminv=mean(P(x,1)) + mean(P(x,2))/optvel + mean(P(x,3))*optvel;   
    str{numel(str)+1}=[labels{x} ': A=' num2str(P(x,1),4) ', B=' num2str(P(x,2),4) ', C=' num2str(P(x,3),4) ', Opt.Vel=' num2str(optvel,4) ', Min.Y=' num2str(yminv,4)];
end

set(InfoBox,'String',str)
zz_copylist(0,InfoBox)


% ------------------- modeltypes ---------------------
function modeltypes
global Modset Experimental

ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
VDlevelsPop=findobj(gcf,'Tag','VDlevelsPop');


intlevels=repmat(NaN,1,numel(Experimental.activeexp));
vellevels=intlevels;

% Finds levels of interacting variable
for x=1:numel(Experimental.paramnames)
    pamcell=Experimental.paramnames{x};  
    if ~isempty(Modset.velocityvar)
        ind1=strmatch(Modset.velocityvar,pamcell,'Exact');
        if ~isempty(ind1)
            ind1=ind1(1);
            vellevels(x)=Experimental.parameters(ind1,x);
        end
    end    
    if ~isempty(Modset.interactvar)
        ind2=strmatch(Modset.interactvar,pamcell,'Exact');
        if ~isempty(ind2)
            ind2=ind2(1);
            intlevels(x)=Experimental.parameters(ind2,x);
        end
    end    
end
vellevels=unique(vellevels); vellevels(isnan(vellevels))=[]; 
Modset.velocityvar_levels=vellevels;
intlevels=unique(intlevels); intlevels(isnan(intlevels))=[];
Modset.interactvar_levels=intlevels;

VdModtype{1}='All levels'; Modtype{1}='Quad+Int'; VDIntBtn=findobj(gcf,'Tag','VDIntBtn');
if ~isempty(intlevels)   
    Modtype{2}='VD+Int'; set(VDIntBtn,'Enable','on')     
    for x=1:numel(intlevels)
        Modtype{numel(Modtype)+1}=['VD '  Modset.interactvar '=' num2str(intlevels(x))];
        VdModtype{numel(VdModtype)+1}=[Modset.interactvar '=' num2str(intlevels(x))];
    end
else
    Modtype{2}='VD'; set(VDIntBtn,'Enable','off')     
end

set(ModelTypePop,'String',Modtype)
if get(ModelTypePop,'Value')>numel(Modtype) set(ModelTypePop,'Value',1); end
set(VDlevelsPop,'String',VdModtype)
if get(VDlevelsPop,'Value')>numel(VdModtype) set(VDlevelsPop,'Value',1); end

Modset.modtypes=Modtype;


% ------------------- autovelpop ---------------------
function autovelpop
global Experimental Modset

n_names=0; allnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pnames=Experimental.paramnames{x};
    for y=1:numel(pnames)
        if ~isempty(pnames{y})
            n_names=n_names+1;
            allnames{n_names}=pnames{y};
        end
    end
end
uniquenames=unique(allnames);

% Find matches that can be mobile phase vel.
C={'flo','vel','spe','mob','car'};
for x=1:numel(uniquenames)
    sc(x)=sum(strncmpi(uniquenames{x},C,3));
end
[d,ind]=max(sc); [d,ind2]=min(sc);

Modset.velocityvar=uniquenames{ind};

if numel(uniquenames)>1
    Modset.interactvar=uniquenames{ind2};
end

setvelocitypop

% ------------------- setvelocitypop ---------------------
function setvelocitypop
global Experimental Modset

InterVaryPop=findobj(gcf,'Tag','InterVaryPop');
VelocityPop=findobj(gcf,'Tag','VelocityPop');

allpnames=cell(0);
for x=1:numel(Experimental.paramnames)
    pns=Experimental.paramnames{x};
    for y=1:numel(pns) allpnames{numel(allpnames)+1}=pns{y}; end      
end
allpnames=unique(allpnames);

dummystr={'-'};
if numel(allpnames)>0
    set(VelocityPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.velocityvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(VelocityPop,'Value',ind)
else
    set(VelocityPop,'String',dummystr,'Enable','off','Value',1)
end
if numel(allpnames)>1        
    set(InterVaryPop,'String',allpnames,'Enable','on')
    ind=strmatch(Modset.interactvar,allpnames); if isempty(ind) ind=1; end; ind=ind(1);
    set(InterVaryPop,'Value',ind)    
else
    set(InterVaryPop,'String',dummystr,'Enable','off','Value',1)
end



% ------------------- listupdate ---------------------
function listupdate
global Modset Models Experimental

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

callertag=get(gcbo,'Tag');

if strcmp(callertag,'CodeRadio')
    codestr=get(gcbo,'String');
    if strcmp(codestr,'Code')
        Modset.codetype=1;
    end
    if strcmp(codestr,'Name')
        Modset.codetype=2;
    end    
    if strcmp(codestr,'Short name')
        Modset.codetype=3;
    end        
end

if strcmp(callertag,'ListTypeRadio')
    liststr=get(gcbo,'String');
    if strcmp(liststr,'Show data')
       Modset.listtype=1;
    end
    if strcmp(liststr,'Show models')
       Modset.listtype=2;
    end     
end

% set code types
if Modset.codetype==1;
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Modset.codetype==2;
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Modset.codetype==3;
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

if isempty(Models) Modset.listtype=1; end 
if isempty(Experimental) Modset.listtype=0; end 

if Modset.listtype~=1 && zz_tabletool('Exist','DataTable')
    zz_tabletool('Delete','DataTable');
end
if Modset.listtype==1 && zz_tabletool('Exist','ModelsTable')
    zz_tabletool('Delete','DataTable');
end

% set list types
if Modset.listtype==0 datalist; end

if Modset.listtype==1;
    h=findobj(ListTypeRadio,'String','Show data');
    set(h,'Value',1)
    datalist
end
if Modset.listtype==2;
    h=findobj(ListTypeRadio,'String','Show models');
    set(h,'Value',1)
    modelslist
end



% ------------------- calibdata ---------------------
function Calibdata=calibdata
global Experimental Modset 
% Function for finding acitive calibration data

XM=repmat(NaN,numel(Experimental.activeexp),2);
expno=(1:numel(Experimental.activeexp))';

% Fills XM, Velocity var is always in column 1;
for x=1:numel(Experimental.paramnames)
    if Experimental.activeexp(x)
        pamcell=Experimental.paramnames{x};       
        if ~isempty(Modset.velocityvar)
            ind=strmatch(Modset.velocityvar,pamcell,'Exact');
            if ~isempty(ind)
                ind=ind(1);
                XM(x,1)=Experimental.parameters(ind,x);
            end
        end
        if ~isempty(Modset.interactvar)
            ind2=strmatch(Modset.interactvar,pamcell,'Exact');
            if ~isempty(ind2)
                ind2=ind2(1);
                XM(x,2)=Experimental.parameters(ind2,x);
            end
        end
    end
end
                
% Delete columns that are all 0
NaNc=sum(isnan(XM));
delcols=NaNc==numel(Experimental.activeexp);
XM(:,delcols)=[];
if isempty(XM) expno=[]; end

% get Y-values
YM=Experimental.(getvarname)';   

delind=find(sum(isnan(XM),2));

XM(delind,:)=[];
YM(delind,:)=[];
expno(delind)=[];

% Constrain Y-values
YM=YM(:,Experimental.activecmp);

Calibdata.X=XM;
Calibdata.Y=YM;
Calibdata.expno=expno;
Calibdata.cmpno=find(Experimental.activecmp);
Calibdata.var1=Modset.velocityvar;
Calibdata.var2=Modset.interactvar;


% ------------------- contourplot ---------------------
function contourplot(X_cont,Y_cont,Z_cont,design)
global Experimental Pos Modset Metset

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; % To be edited
end

lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

if Metset.contour_isolines linestr='-'; else linestr='none'; end
subplot('Position',Pos.rightplot)
if numel(v)>2 && numel(v)<200
    [C,h] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr);
else
    [C,h] = contourf(X_cont,Y_cont,Z_cont);
end

if Metset.contour_labels clabel(C,h); end
set(h,'ButtonDownFcn','oo_model_vd3(9.1)','Tag','Contourplot');

% Centers clim if colormap is hotcold
if Metset.contour_centercol
    cm=[min(v) max(v)];
    set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

set(gcf,'Colormap',oo_getcmap);

% EXTRAS
hold on
    
% PLOTS DESIGN POINTS
if Metset.contour_showdesign
    [m,n_points]=size(design);
    for x=1:n_points
        plot(design(1,x),design(2,x),'o',...
            'MarkerSize',10,'MarkerFaceColor',Experimental.color(:,x),...
            'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model_vd3(9.3)')    
    end
end

% Min and max
MinvalEdit1=findobj(gcf,'Tag','MinvalEdit1'); 
MinvalEdit2=findobj(gcf,'Tag','MinvalEdit2');
MinvalEdit3=findobj(gcf,'Tag','MinvalEdit3'); 
MinCheck=findobj(gcf,'Tag','MinCheck');
plotmin=get(MinCheck,'Value');
if plotmin
    minv=min(min(Z_cont));
    [ind1,ind2]=find(Z_cont==minv);
    ind1=ind1(1); ind2=ind2(1);
    minx=X_cont(ind1,ind2);
    miny=Y_cont(ind1,ind2);
    hold on
    plot(minx,miny,'o',...
        'MarkerSize',10,'MarkerFaceColor',[0.5 0.5 1],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model_vd3(9.3)')
    set(MinvalEdit1,'String',num2str(minx,'%6.4g'),'Enable','on')
    set(MinvalEdit2,'String',num2str(miny,'%6.4g'),'Enable','on')
    set(MinvalEdit3,'String',num2str(minv,'%6.4g'),'Enable','on')
else
    set(MinvalEdit1,'String','','Enable','off'); set(MinvalEdit2,'String','','Enable','off'); set(MinvalEdit3,'String','','Enable','off')      
end

MaxvalEdit1=findobj(gcf,'Tag','MaxvalEdit1'); 
MaxvalEdit2=findobj(gcf,'Tag','MaxvalEdit2');
MaxvalEdit3=findobj(gcf,'Tag','MaxvalEdit3'); 
MaxCheck=findobj(gcf,'Tag','MaxCheck');
plotmax=get(MaxCheck,'Value');
if plotmax
    maxv=max(max(Z_cont));
    [ind1,ind2]=find(Z_cont==maxv);
    ind1=ind1(1); ind2=ind2(1);
    maxx=X_cont(ind1,ind2);
    maxy=Y_cont(ind1,ind2);
    hold on
    plot(maxx,maxy,'o',...
        'MarkerSize',10,'MarkerFaceColor',[1 0.5 0.5],...
        'MarkerEdgeColor',[0 1 0],'LineWidth',2,'ButtonDownFcn','oo_model_vd3(9.3)')
    set(MaxvalEdit1,'String',num2str(maxx,'%6.4g'),'Enable','on')
    set(MaxvalEdit2,'String',num2str(maxy,'%6.4g'),'Enable','on')
    set(MaxvalEdit3,'String',num2str(maxv,'%6.4g'),'Enable','on')
else
    set(MaxvalEdit1,'String','','Enable','off'); set(MaxvalEdit2,'String','','Enable','off'); set(MaxvalEdit3,'String','','Enable','off')      
end

% Slectionpoint
sxv=mean(mean(X_cont));
syv=mean(mean(Y_cont));
maha=plot(sxv,syv,'+',...
    'MarkerSize',12,'MarkerFaceColor',[1 0.7 0.5],...
    'MarkerEdgeColor',[1 1 1],'LineWidth',2,'ButtonDownFcn','oo_model_vd3(9.3)','Tag','SelectionMarker','Visible','off');
if get(findobj(gcf,'Tag','ShowSelCheck'),'Value') set(maha,'Visible','on'); end

hold off

zz_copyfigure

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'Enable','on','String','')
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'Enable','on','String','')
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'Enable','on','String','')
InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')

Modset.currentcont_x=X_cont;
Modset.currentcont_y=Y_cont;
Modset.currentcont_z=Z_cont;

% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(coeff,design,modeltype)

%disp('--- calcsurf ---')

XScaleEdit=findobj('Tag','XScaleEdit'); xscaleoffs=str2double(get(XScaleEdit,'String'));
YScaleEdit=findobj('Tag','YScaleEdit'); yscaleoffs=str2double(get(YScaleEdit,'String'));

min_x=min(design(1,:)); max_x=max(design(1,:)); 
if max_x-min_x <=0 min_x=-1; max_x=1; end
o=(max_x-min_x)*(xscaleoffs/100); min_x=min_x-o; max_x=max_x+o;
min_y=min(design(2,:)); max_y=max(design(2,:)); 
if max_y-min_y <=0 min_y=-1; max_y=1; end
o=(max_y-min_y)*(yscaleoffs/100); min_y=min_y-o; max_y=max_y+o;

res_x=100; res_y=100; %resolution of temperature/gradient
minmax_x=[min_x max_x]; inc_x=(minmax_x(2)-minmax_x(1))/res_x;
minmax_y=[min_y max_y]; inc_y=(minmax_y(2)-minmax_y(1))/res_y;

xs=minmax_x(1):inc_x:minmax_x(2);
le_x=length(xs);
ys=minmax_y(1):inc_y:minmax_y(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
for xc=1:le_x
    for yc=1:le_y
        if modeltype==1 % Quad+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        end
        if modeltype==2 % VD+Int
            D=[1 1/xs(xc) xs(xc) ys(yc) ys(yc)/xs(xc) xs(xc)*ys(yc) ys(yc)^2];
        end        
        z_val=[D*coeff];    
        Z_cont(xc,yc)=z_val;     
    end   
end


% ------------------- findmodels ---------------------
function modno=findmodels(modeltype)
global Models

n_models=numel(Models);
if n_models==0; 
    modno=[]; 
else
    for x=1:numel(Models) 
        modeltypes{x}=Models(x).modeltype; 
    end
    modno=strmatch(modeltype,modeltypes);
    if ~isempty(modno)
        modno=modno(1);
    end
end


% ------------------- calcmodels ---------------------
function calcmodels
global Experimental Models Modset

Calibdata=calibdata;
if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

% Check for existing models and defines modno
modeltype='Quad+Int';
modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

parameters=Calibdata.X';
[n_par,n_exp]=size(parameters);
if n_par<2 
    parameters(2,1:n_exp)=0;
end

expdata=Calibdata.Y';

% x-matrix for validation
for x=1:n_exp
    XV(x,:)=[1 parameters(1,x) parameters(2,x) parameters(1,x)*parameters(2,x) parameters(1,x)^2 parameters(2,x)^2];
end

selcmp=find(Experimental.activecmp);
varname=getvarname;

parn{1}=Calibdata.var1; parn{2}=Calibdata.var2;
for x=1:length(parn)
    spaceind=strfind(parn{x},' ');
    parn{x}(spaceind)=[];
end

for x=1:length(selcmp)
    cmp=selcmp(x);   
    y_meas=expdata(x,:)';
    [coefficients,n_coeff]=oo_calcmodel(parameters,y_meas);
    Models(modno).(varname){cmp}=coefficients;
    if sum(isnan(coefficients))==0 
        y_pred=XV*coefficients; 
        y_pred=y_pred.^0.5; y_meas=y_meas.^0.5;
        if numel(y_pred)>1
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5; % unadjusted rms 
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
        else
            rms=0; r2=0; bias=0;
        end   
        Models(modno).([varname '_nparam']){cmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){cmp}=numel(res)-n_coeff; % degrees of freedom
        Models(modno).([varname '_errors']){cmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){cmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){cmp}=parameters;
        
    end
end

Models(modno).parnames={'Const',parn{1},parn{2},[parn{1} char(215) parn{2}],[parn{1} char(178)],[parn{2} char(178)]};
Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};

Modset.currentmodel=modno;
Modset.currentmodeltype=modeltype;

plot_validation


% ------------------- vdintmodel ---------------------
function vdintmodel
global Modset Models Experimental

Calibdata=calibdata;

if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

includeA=~get(findobj(gcf,'Tag','ZeroACheck'),'Value'); % Force A to be 0
includeI=get(findobj(gcf,'Tag','IncludeICheck'),'Value');
includeBI=get(findobj(gcf,'Tag','IncludeBICheck'),'Value');
includeCI=get(findobj(gcf,'Tag','IncludeCICheck'),'Value');
includeII=get(findobj(gcf,'Tag','IncludeIICheck'),'Value');
testsign=get(findobj(gcf,'Tag','SignTestCheck'),'Value');
signthresh=str2double(get(findobj(gcf,'Tag','SignTestEdit'),'String'));
if isnan(signthresh) || signthresh<0
    set(findobj(gcf,'Tag','SignTestEdit'),'String','0.1'); signthresh=0.1;
end

validpars=find([includeA 1 1 includeI includeBI includeCI includeII]);

% Check for existing models and defines modno
modeltype='VD+Int';
modno=findmodels(modeltype);
if isempty(modno) modno=numel(Models)+1; end
Models(modno).modeltype=modeltype;
Models(modno).velocityvar=Modset.velocityvar;
Models(modno).interactvar=Modset.interactvar;

% Get parameters
parameters=Calibdata.X';
[n_par,n_exp]=size(parameters);
if n_par<2 
    parameters(2,1:n_exp)=0;
end
expdata=Calibdata.Y;

% Builds x-matrix
for x=1:n_exp
    XM(x,:)=[1 1/parameters(1,x) parameters(1,x) parameters(2,x) parameters(2,x)*(1/parameters(1,x)) parameters(2,x)*parameters(1,x) parameters(2,x)^2];
    % Constant B/x C*x I BI/x CI*x I*I
end
XM=XM(:,validpars);

% Ranktest
[n_exp,n_par]=size(XM);
for x=1:n_par
    r(x)=rank(XM(:,1:x));
end
valids=[1 diff(r)>0];
XM=XM(:,find(valids));
validpars=validpars(find(valids));

[m,n_cmp]=size(expdata);

% validation
[n_exp,n_par]=size(XM);

selcmp=find(Experimental.activecmp);
varname=getvarname;

for cmpno=1:n_cmp
    y_meas=expdata(:,cmpno);
    yvar=var(y_meas);
    % significance testing
    LX=XM; % Copy of XM
    tvalidpars=validpars; % copy of validpars
    if testsign
        for x=1:n_par
            TX=LX(:,1:x);
            tcoeff=(TX\y_meas);
            ty_pred=TX*tcoeff;
            explvar(x)=100*((yvar-var(ty_pred-y_meas))/yvar); % explained variance in %     
        end
        usevar=[100 diff(explvar)]>signthresh;
        LX=LX(:,usevar);
        tvalidpars=tvalidpars(usevar);
    end
    
    n_coeff=numel(tvalidpars);
    
    coefficients=(LX\y_meas); 
    y_pred=LX*coefficients;
    y_pred=y_pred.^0.5; y_meas=y_meas.^0.5; % Only for vd_model3
    res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
    rms=(sumsq/numel(res))^0.5; % unadjusted rms     
    if numel(res)-n_coeff <1
        rms_adj=inf;
    else
        rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
    end    
    r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
    bias=mean(res);

    coeffout=zeros(7,1);
    for x=1:numel(tvalidpars)
        coeffout(tvalidpars(x))=coefficients(x);
    end
    
    Models(modno).(varname){selcmp(cmpno)}=coeffout;
    
    Models(modno).([varname '_nparam']){selcmp(cmpno)}=n_coeff; % Number of parameters
    Models(modno).([varname '_df']){selcmp(cmpno)}=numel(res)-n_coeff; % degrees of freedom    
    Models(modno).([varname '_errors']){selcmp(cmpno)}=[rms rms_adj r2 bias];
    Models(modno).([varname '_predmeas']){selcmp(cmpno)}=[y_meas'; y_pred'];
    Models(modno).([varname '_design']){selcmp(cmpno)}=parameters;
        
    Models(modno).parnames={'Const',['1/' Calibdata.var1],...
        [Calibdata.var1],[Calibdata.var2],...
        [Calibdata.var2 '/' Calibdata.var1],...
        [Calibdata.var1 char(215) Calibdata.var2],...
        [Calibdata.var2 char(178)]};
    Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};    
    
end

Modset.currentmodel=modno;
Modset.currentmodeltype=modeltype;




% ------------------- vdmodel ---------------------
function vdmodel
global Modset Models

Calibdata=calibdata;

if ~isfield(Calibdata,'expno') || isempty(Calibdata.expno) zz_message(1,'No active experiments','-r'); return; end
if ~isfield(Calibdata,'cmpno') || isempty(Calibdata.cmpno) zz_message(1,'No active compounds','-r'); return; end

VDlevelsPop=findobj(gcf,'Tag','VDlevelsPop');
vdlevel=get(VDlevelsPop,'Value')-1; 

varname=getvarname;

% transfers Calibdata to Data according to level of parameter 2 and checks
% that there is sufficient points in level 1
Data=[];
if ~isempty(Modset.interactvar) 
    if vdlevel==0
        par2levels=unique(Calibdata.X(:,2));  %all levels of interacting var 
    else
        par2levels=Modset.interactvar_levels(vdlevel); % selected level
    end
    for x=1:numel(par2levels)
        ind=find(Calibdata.X(:,2)==par2levels(x));
        par1levels=unique(Calibdata.X(ind,1));
        if numel(par1levels)<3 par2levels(x)=NaN; end
    end
    par2levels(isnan(par2levels))=[];
    if ~isempty(par2levels)
        for x=1:numel(par2levels)
            ind=find(Calibdata.X(:,2)==par2levels(x));
            Data(x).X=Calibdata.X(ind,:);
            Data(x).Y=Calibdata.Y(ind,:);
            Data(x).expno=Calibdata.expno(ind,:);
            Data(x).cmpno=Calibdata.cmpno;
            Data(x).modeltype=['VD ' Calibdata.var2 '=' num2str(par2levels(x))];
        end  
    end
else
    par1levels=unique(Calibdata.X(:,1));
    if numel(par1levels)>=3
        Data(1).X=Calibdata.X;
        Data(1).Y=Calibdata.Y;
        Data(1).expno=Calibdata.expno;
        Data(1).cmpno=Calibdata.cmpno;
        Data(1).modeltype=['VD'];
    end
end

if isempty(Data) zz_message(1,'Not enough data points','-r'); return; end


zeroA=get(findobj(gcf,'Tag','ZeroACheck'),'Value'); % Force A to be 0
if zeroA n_coeff=2; else n_coeff=3; end

allA=[];
for mo=1:numel(Data)
    modno=findmodels(Data(mo).modeltype);
    if isempty(modno) modno=numel(Models)+1; end
    Models(modno).modeltype=Data(mo).modeltype;
    Models(modno).velocityvar=Modset.velocityvar;
    Models(modno).interactvar=Modset.interactvar;
      
    [n_exp,n_cmp]=size(Data(mo).Y);
    
    for cmp=1:n_cmp
        currentcmp=Data(mo).cmpno(cmp);

        % Regression
        if zeroA
            T(1:n_exp,1)=1./Data(mo).X(:,1);
            T(1:n_exp,2)=Data(mo).X(:,1);  
        else    
            T(1:n_exp,1)=1;
            T(1:n_exp,2)=1./Data(mo).X(:,1);
            T(1:n_exp,3)=Data(mo).X(:,1);
        end
        
        y_meas=Data(mo).Y(:,cmp);
        coefficients=(T\y_meas);
        if zeroA
            Models(modno).(getvarname){currentcmp}=[0; coefficients];
        else
            Models(modno).(getvarname){currentcmp}=coefficients;
        end
        allA(cmp)=coefficients(1);
        
        % validation
        y_pred=T*coefficients; 
        y_pred=y_pred.^0.5; y_meas=y_meas.^0.5; % Only for vd_model3
        res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
        rms=(sumsq/numel(res))^0.5;  
        if numel(res)-n_coeff <1
            rms_adj=inf;
        else
            rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
        end

        r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
        bias=mean(res);
        
        Models(modno).([varname '_nparam']){currentcmp}=n_coeff; % Number of parameters
        Models(modno).([varname '_df']){currentcmp}=numel(res)-n_coeff; % degrees of freedom                
        Models(modno).([varname '_errors']){currentcmp}=[rms rms_adj r2 bias];
        Models(modno).([varname '_predmeas']){currentcmp}=[y_meas'; y_pred'];
        Models(modno).([varname '_design']){currentcmp}=Data(mo).X';
        
        Models(modno).parnames={'A (Const)',['B / ' Calibdata.var1],['C x ' Calibdata.var1]};
        Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};

    end    
end

% Recalculate with mean A
T=[]; allA(isnan(allA))=[];
if get(findobj(gcf,'Tag','MeanACheck'),'Value') && numel(allA)>1
    meanA=mean(allA);
    for mo=1:numel(Data)
        modno=findmodels(Data(mo).modeltype);
        if isempty(modno) modno=numel(Models)+1; end
        Models(modno).modeltype=Data(mo).modeltype;
        
        [n_exp,n_cmp]=size(Data(mo).Y);
    
        for cmp=1:n_cmp
            currentcmp=Data(mo).cmpno(cmp);

            % Regression
            T(1:n_exp,1)=1./Data(mo).X(:,1);
            T(1:n_exp,2)=Data(mo).X(:,1);

            y_meas=Data(mo).Y(:,cmp)-meanA; % subtracts mean A and solves without A-term
            coefficients=(T\y_meas);
            Models(modno).(getvarname){currentcmp}=[meanA; coefficients]; % adds meanA to coefficients
 
            % validation
            y_meas=y_meas+meanA; % adds back mean A
            y_pred=T*coefficients+meanA; % adds back mean A
            y_pred=y_pred.^0.5; y_meas=y_meas.^0.5; % Only for vd_model3
            res=y_pred-y_meas; sqres=res.^2; sumsq=sum(sqres);
            rms=(sumsq/numel(res))^0.5;       
            if numel(res)-n_coeff <1
                rms_adj=inf;
            else
                rms_adj=(sumsq/(numel(res)-n_coeff))^0.5; % rms adjusted for degrees of freedom  
            end
            r=corrcoef(y_pred,y_meas); r2=r(1,2)^2;
            bias=mean(res);
            
            Models(modno).([varname '_nparam']){currentcmp}=n_coeff; % Number of parameters
            Models(modno).([varname '_df']){currentcmp}=numel(res)-n_coeff; % degrees of freedom    
            Models(modno).([varname '_errors']){currentcmp}=[rms rms_adj r2 bias];
            Models(modno).([varname '_predmeas']){currentcmp}=[y_meas'; y_pred'];
            Models(modno).([varname '_design']){currentcmp}=Data(mo).X';
            Models(modno).parnames={'A (Const)',['B / ' Calibdata.var1],['C x ' Calibdata.var1]};
            Models(modno).errornames={'RMS','RMS_adj','R2','Bias'};
        end    
    end
end

Modset.currentmodel=modno;
Modset.currentmodeltype=Data(mo).modeltype;


% ------------------- calcvalues ---------------------
function calcvalues
global Experimental Models Modset Pos

% Check for valid models
ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
str=get(ModelTypePop,'String'); val=get(ModelTypePop,'Value');
modeltype=str{val};
if strcmp(modeltype,'VD')
    matchstr=[modeltype Modset.velocityvar];
    for x=1:numel(Models) 
        teststr{x}=[Models(x).modeltype Models(x).velocityvar];   
    end
else
    matchstr=[modeltype Modset.velocityvar Modset.interactvar];
    for x=1:numel(Models) 
        teststr{x}=[Models(x).modeltype Models(x).velocityvar Models(x).interactvar];   
    end    
end
modind=strmatch(matchstr,teststr,'exact'); 
if isempty(modind) zz_message(1,['No ' modeltype ' models of variables ' Modset.velocityvar ' ' Modset.interactvar],'-r'); return; end
modind=modind(1);

varname=getvarname;

ParametersList=findobj(gcf,'Tag','ParametersList');
str=get(ParametersList,'String'); val=get(ParametersList,'Value');
paramname=str{val};

if ~isfield(Models,varname) || isempty(Models(modind).(varname))
    zz_message(1,['No models of type ' modeltype ' for ' paramname],'-r'); return
end

% Find the correct designpoints (xp and yp)
xp=[]; yp=[]; 
if isfield(Modset,'velocityvar') && ~isempty(Modset.velocityvar)
    velname=Modset.velocityvar;
    for p=1:numel(Experimental.paramnames)
        xind=strmatch(velname,Experimental.paramnames{p}); xind=xind(1);
        xp(p)=Experimental.parameters(xind,p);
    end    
end
if isfield(Modset,'interactvar') && ~isempty(Modset.interactvar)
    intname=Modset.interactvar;
    for p=1:numel(Experimental.paramnames)
        yind=strmatch(intname,Experimental.paramnames{p}); yind=yind(1);
        yp(p)=Experimental.parameters(yind,p);
    end 
end

n_exp=numel(Experimental.paramnames);
n_cmp=numel(Experimental.codes);

Data=cell(n_cmp,n_exp);


if strncmp(modeltype,'VD ',3) || strcmp(modeltype,'VD')
    intlevel=[]; 
    if isfield(Modset,'interactvar_levels') && ~isempty(Modset.interactvar_levels)
        for x=1:numel(Modset.interactvar_levels)
            tstr{x}=['VD ' intname '=' num2str(Modset.interactvar_levels(x))];
        end
        intlevel=strmatch(modeltype,tstr); intlevel=intlevel(1);
    end
    if ~isempty(intlevel)
        valids=find(yp==Modset.interactvar_levels(intlevel));
    else
        valids=1:numel(xp);
    end
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==3
             for dno=1:numel(valids)
                Data{cmpno,valids(dno)}=coeff(1)+coeff(2)/xp(valids(dno))+coeff(3)*xp(valids(dno));            
            end
         end
    end
end

if strcmp(modeltype,'VD+Int')
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==7
            for dno=1:numel(xp)
                Data{cmpno,dno}=coeff(1)+coeff(2)/xp(dno)+coeff(3)*xp(dno)+coeff(4)*yp(dno)+coeff(5)*yp(dno)/xp(dno)+coeff(6)*xp(dno)*yp(dno)+coeff(7)*yp(dno)^2;
            end
        end
    end 
end
if strcmp(modeltype,'Quad+Int')
    for cmpno=1:numel(Models(modind).(varname))
        coeff=Models(modind).(varname){cmpno};
        if numel(coeff)==6
            for dno=1:numel(xp)
                Data{cmpno,dno}=coeff(1)+coeff(2)*xp(dno)+coeff(3)*yp(dno)+coeff(4)*xp(dno)*yp(dno)+coeff(5)*xp(dno)^2+coeff(6)*yp(dno)^2;
            end
        end
    end   
    
end

%Experimental
Data(cellfun('isempty',Data))={NaN};

if Modset.codetype==1 rownames=Experimental.codes; end
if Modset.codetype==2 rownames=Experimental.names; end
if Modset.codetype==3 rownames=Experimental.shortnames; end 

% Add experimental conditions
[m,n]=size(Data); % use m
if ~isempty(xp)
    for x=1:numel(xp) Data{m+1,x}=xp(x); end; rownames{m+1}=velname;
end
[m,n]=size(Data); % use m
if ~isempty(yp)
    for y=1:numel(yp) Data{m+1,y}=yp(y); end; rownames{m+1}=intname;
end

T.Data=Data;
T.TableName='CalculatedTable';

winw=Pos.window(3); winh=Pos.window(4);
winl=Pos.window(1); winb=Pos.window(2);
lp=winl+winw*0.02; vp=winb+winh*0.45; tw=winw*0.52; th=winh*0.53;

T.Position=[lp vp tw th];

for x=1:n_exp 
    T.ColumnName{x}=['Exp ' num2str(x)]; 
    T.ColumnFormat{x}=4;
    T.ColumnWidth{x}=70;
end
T.RowName=rownames;
T.ColumnEditable=[zeros(1,n_exp)];
T.AllowNan=1;
T.ViewPref=1;
T.Popup=1;
T.PopupTitle='Calculated values';
T.PopupResizable=1;
T.PopupModal=0;
T.HeaderText={['Calculated values for ' modeltype],['Variable is ' paramname]};
T.FooterText={Modset.filename,datestr(now)};

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
pause(0.5)

zz_tabletool('Create',T);


% ------------------- checkpoint ---------------------
function checkpoint(xp,yp)
global Experimental Models Modset

xvals=Modset.currentcont_x(:,1);
yvals=Modset.currentcont_y(1,:);

xa=min(find(xvals>=xp)); xb=max(find(xvals<=xp));
if (xp-xvals(xb))<=(xvals(xa)-xp) nxp=xb; else nxp=xa; end
 
ya=min(find(yvals>=yp)); yb=max(find(yvals<=yp));
if (yp-yvals(yb))<=(yvals(ya)-yp) nyp=yb; else nyp=ya; end

zp=Modset.currentcont_z(nxp,nyp);

SelXEdit=findobj('Tag','SelXEdit'); set(SelXEdit,'String',num2str(xp,'%6.4g'))
SelYEdit=findobj('Tag','SelYEdit'); set(SelYEdit,'String',num2str(yp,'%6.4g'))
SelZEdit=findobj('Tag','SelZEdit'); set(SelZEdit,'String',num2str(zp,'%6.4g'))

% Move marker
maha=findobj(gca,'Tag','SelectionMarker');
if ~isempty(maha) set(maha,'XData',xp,'YData',yp); end

% Find selected compounds
selcmp=find(Experimental.activecmp);

%targetfile=find(cell2mat(zz_tabletool('getcol','BoxTable',3)))

if Modset.codetype==1 codes=Experimental.codes; end
if Modset.codetype==2 codes=Experimental.names; end
if Modset.codetype==3 codes=Experimental.shortnames; end

varname=getvarname;
parameters=[xp,yp];

ModelTypePop=findobj(gcf,'Tag','ModelTypePop');
str=get(ModelTypePop,'String'); val=get(ModelTypePop,'Value');
modeltype=str{val};

for x=1:numel(Models) modeltypestr{x}=Models(x).modeltype; end
modind=strmatch(modeltype,modeltypestr,'exact');

cc=1; ostr{1,cc}='Compound '; ostr{2,cc}='Calc. '; 
    
for p=1:length(selcmp)
    cmp=selcmp(p);
    cmod=Models(modind).(varname);  % current models
    coeff=cmod{cmp};
    calcres=NaN;
    if strmatch(modeltype,'VD+Int')
        if numel(coeff)==7 && sum(isnan(coeff))==0
            calcres=coeff(1)+coeff(2)/xp+coeff(3)*xp+coeff(4)*yp+coeff(5)*yp/xp + coeff(6)*xp*yp+coeff(7)*yp^2;
        end
    end
    if strmatch(modeltype,'Quad+Int')
        if numel(coeff)==6 && sum(isnan(coeff))==0
            calcres=coeff(1)+coeff(2)*xp+coeff(3)*yp+coeff(4)*xp*yp + coeff(5)*xp^2 +coeff(6)*yp^2;   
        end
    end  
    if ~isnan(calcres)
        cc=cc+1;
        ostr{1,cc}=[codes{cmp} ': '];
        ostr{2,cc}=[num2str(calcres,'%6.6g') ' '];
    end
end

[m,n]=size(ostr); outstr=[];
for x=1:m
    outstr=[outstr strvcat(ostr{x,:})];
end

if strcmp(get(gcbo,'Tag'),'OptvelLine')
    Userdat=get(gcbo,'Userdata'); tstr{1}=Userdat.text; outstr=tstr;
   % ostr=tstr;
end

InfoBox=findobj(gcf,'Tag','InfoBox');
set(InfoBox,'String',outstr)
zz_copylist(0,InfoBox)


% ----------------- evalboxlist -------------------
function evalboxlist
global Experimental

val=zz_tabletool('getlastcell','BoxTable');

if numel(val)==1 && val.colindex==1
    Experimental.expname{val.rowindex}=val.val;
end
if val(1).colindex==2
    Experimental.activeexp=cell2mat(zz_tabletool('getcol','BoxTable',2))';    
end
if numel(val)==1 && val.colindex>2
    Experimental.parameters(val.colindex-2,val.rowindex)=val.val;
end

plot_design    

% ------------------- boxlist ---------------------
function boxlist
global Experimental Pos

T.TableName='BoxTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2+Pos.bw Pos.gh*6];

if isfield(Experimental,'parameters')
    [nparam,nexp]=size(Experimental.parameters);

    for expno=1:length(Experimental.expname)
        T.Data{expno,1}=Experimental.expname{expno};
        if Experimental.activeexp(expno)
            T.Data{expno,2}=true;
        else
            T.Data{expno,2}=false;
        end
        %T.Data{expno,3}=false;
        for x=1:nparam
            T.Data{expno,x+2}=Experimental.parameters(x,expno);
        end
        if ~isempty(Experimental.paramnames{expno})
            for x=1:numel(Experimental.paramnames{expno})
                paramname{x}=Experimental.paramnames{expno}{x};
            end
        end
        T.RowName{expno}=['Exp ' num2str(expno)];   
    end

    T.ColumnName={'Files','Active'}; 
    for x=1:numel(paramname) T.ColumnName{x+2}=paramname{x}; end
    T.ColumnEditable=[1 1 ones(1,numel(paramname))];
    T.ViewPref=1;
    T.CellEditCallback='oo_model_vd3(12.1)';
    T.AllowNan=1;    
    T.ColumnFormat={'char','binary'}; for x=1:numel(paramname) T.ColumnFormat{x+2}='numeric'; end
    T.ColumnWidth=[100 50 repmat(60,1,numel(paramname))];    
    T.ListSelCol=2;    
else
    T.Data=[];    
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- parameterslist ---------------------
function parameterslist
global Experimental

ParametersList=findobj(gcf,'Tag','ParametersList'); set(ParametersList,'Enable','off')

if isempty(Experimental) return; end

showall=get(findobj(gcf,'Tag','AllParamCheck'),'Value');
currentstr=get(ParametersList,'String'); if ~iscell(currentstr) currentstr={''}; end
currentval=get(ParametersList,'Value'); if currentval>numel(currentstr) currentval=1; end
currentsel=currentstr{currentval};
preferred='Peak width (RI units)';
currentvar=getvarname;

strno=0; str=[];
fn=fieldnames(Experimental);
for x=1:length(fn)    
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'rt_exp') strno=strno+1; str{strno}='Retention time (RT)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'ri_exp') strno=strno+1; str{strno}='Retention index (RI)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'wbl_exp') strno=strno+1; str{strno}='Peak width (RT units)'; end
    if strcmp(fn{x}, 'wbl_ri_exp') strno=strno+1; str{strno}='Peak width (RI units)'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'area_exp') strno=strno+1; str{strno}='Area'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'height_exp') strno=strno+1; str{strno}='Height'; end
    if (showall || strcmp(fn{x},currentvar)) && strcmp(fn{x}, 'responsefactor_exp') strno=strno+1; str{strno}='Response factor'; end
end

if ~isempty(str) && iscell(str)
    ind=strmatch(currentsel,str,'exact'); 
    if isempty(ind) ind=strmatch(preferred,str,'exact'); end
    if isempty(ind) ind=1; end 
    set(ParametersList,'String',str,'Value',ind,'Enable','on')
end


% ----------------- evaldatalist -------------------
function evaldatalist
global Experimental

val=zz_tabletool('getlastcell','DataTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','DataTable',1))';
end

if val(1).colindex>1
    varname=getvarname;
    Experimental.(varname)(val.rowindex,val.colindex-1)=val.val;
end
    

% ------------------- datalist ---------------------
function datalist
global Experimental Modset Pos

T.TableName='DataTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];

if isfield(Experimental,'paramnames') && isfield(Experimental,'codes')
    n_exp=length(Experimental.paramnames);
    n_comp=length(Experimental.codes);
    
    varname=getvarname;

    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end   
        for expno=1:n_exp
            T.Data{compno,expno+1}=Experimental.(varname)(compno,expno);
        end
        
        if ~isfield(Experimental,'activecmp') % For old models
            Experimental.activecmp=ones(1,numel(Experimental.codes));
        end
        
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    for x=1:n_exp 
        T.ColumnName{x+1}=['Exp ' num2str(x)]; 
        T.ColumnFormat{x+1}=4;
        T.ColumnWidth{x+1}=70;
    end
    T.ColumnEditable=[ones(1,n_exp+1)];
    T.AllowNan=1;
    T.ViewPref=1;
    T.ColumnName{1}='Active';
    T.ColumnFormat{1}='binary';
    T.ColumnWidth{1}=40;
    T.CellEditCallback='oo_model_vd3(12.2)';
    T.ListSelCol=1;
else
    T.Data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ----------------- evalmodelslist -------------------
function evalmodelslist
global Experimental

val=zz_tabletool('getlastcell','ModelsTable');

if val(1).colindex==1
    Experimental.activecmp=cell2mat(zz_tabletool('getcol','ModelsTable',1))';
end

if get(findobj(gcf,'Tag','PlotUpdCheck'),'Value')
    plotupdate
end


% ------------------- modelslist ---------------------
function modelslist
global Experimental Models Modset Pos

% Select model to display
ModelTypePop=findobj(gcf,'Tag','ModelTypePop'); 
modeltypestr=get(ModelTypePop,'String'); 
if gcbo==ModelTypePop
    val=get(ModelTypePop,'Value'); 
    modeltype=modeltypestr{val};
    modno=findmodels(modeltype);
    if ~isempty(modno) 
        Modset.currentmodel=modno; 
        Modset.currentmodeltype=modeltype;
    else
        zz_message(1,['No models of type ' modeltype],'-r');
    end
end   
modno=Modset.currentmodel;
modeltype=Models(modno).modeltype;
val=strmatch(modeltype,modeltypestr); 
if ~isempty(val) val=val(1); set(ModelTypePop,'Value',val); end   

T.TableName='ModelsTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) Pos.gw*4+Pos.bw Pos.leftplot(4)];
varname=getvarname;

if ~isempty(Models) 
    
    % For old models where parnames and activecmp are not saved
    if ~isfield(Experimental,'activecmp') 
        Experimental.activecmp=ones(1,numel(Experimental.codes));
    end
    if ~isfield(Models,'parnames')
        Models(modno).parnames={'Const','start','grad','startgrad','start','grad'}; 
    end      
    
    n_comp=length(Experimental.codes);
    
    % Constructs T
    [T.ColumnName{2:numel(Models(modno).parnames)+1}]=deal(Models(modno).parnames{:});
    T.ColumnName{1}='Active';
    
    n_param=numel(Models(modno).parnames);
    T.Data=cell(numel(Experimental.codes),1+n_param);
    
    for compno=1:n_comp
        if Modset.codetype==1 T.RowName{compno}=Experimental.codes{compno}; end
        if Modset.codetype==2 T.RowName{compno}=Experimental.names{compno}; end
        if Modset.codetype==3 T.RowName{compno}=Experimental.shortnames{compno}; end 
        T.Data{compno,1}=Experimental.activecmp(compno);
    end
    
    if isfield(Models,varname)
        for cmpno=1:numel(Models(modno).(varname))
            if ~cellfun('isempty',Models(modno).(varname)(cmpno))
                param=Models(modno).(varname){cmpno}';
                for pno=1:numel(param) T.Data{cmpno,pno+1}=param(pno); end
            end
        end
    end
    
    for x=1:numel(Models(modno).parnames) 
        T.ColumnFormat{x+1}=4; 
        T.ColumnWidth{x+1}=80;
    end
    T.AllowEmpty=1;
    T.AllowNan=0;
    T.ColumnFormat{1}='binary'; 
    T.ColumnWidth{1}=50;
    T.ViewPref=1;
    T.CellEditCallback='oo_model_vd3(12.3)';
    T.ListSelCol=1;
    T.ColumnEditable=[1 zeros(1,numel(Models(modno).parnames))];
else
    T.data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

Modset.listtype=2;

% Set correct model type
val=strmatch(Models(Modset.currentmodel).modeltype,modeltypestr);
if ~isempty(val)
    val=val(1); set(ModelTypePop,'Value',val)
end


% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- getmodels ---------------------
function getmodels
global Metset Locset

pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- getvarname ---------------------
function varname=getvarname

ParametersList=findobj(gcf,'Tag','ParametersList');
val=get(ParametersList,'Value');
str=get(ParametersList,'String');
if isempty(str) varname=[]; return; end
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt_exp' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri_exp' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl_exp' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri_exp' ; end
if strcmp(selpar,'Area') varname='area_exp' ; end
if strcmp(selpar,'Height') varname='height_exp' ; end
if strcmp(selpar,'Response factor') varname='responsefactor_exp' ; end


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors 

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; 
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
x=Pos.xg; y=Pos.yg;

winpar{1}='VDModels2Win'; winpar{2}='Chrombox Optimizer: VD models3';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model_vd3(99)',3,'','');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');

% Parameterslist
p=p+1;[ui{p,1:8}] = deal('Parameters:','Text',Colors.bc,[x(4) y(9) gw+bw eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Show all','Checkbox',Colors.bc,[x(4)+gw*0.8 y(9) gw+bw eh],'oo_model_vd3(3.1)',2,'AllParamCheck','-fvp -fh');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(4) y(6) gw*0.5+bw gh*3],'oo_model_vd3(3.3)',2,'ParametersList');

% Velocity list and second var
p=p+1;[ui{p,1:7}] = deal('Mobile phase velocity:','Text',Colors.bc,[x(4) y(3)+gh*2.0 gw+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3)+gh*1.4 gw*0.5+bw eh],'oo_model_vd3(11.1)',2,'VelocityPop','-d');
p=p+1;[ui{p,1:7}] = deal('Interacting variable:','Text',Colors.bc,[x(4) y(3)+gh*0.6 gw+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(4) y(3) gw*0.5+bw eh],'oo_model_vd3(11.2)',2,'InterVaryPop','-d');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(1) y(10) bw eh],'oo_model_vd3(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(1)+gw/2 y(10) bw eh],'oo_model_vd3(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(2) y(10) bw eh],'oo_model_vd3(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_model_vd3(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Show models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_model_vd3(7.1)',2,'ListTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Types','PopupMenu',[1 1 1],[x(4)+gw/2 y(10) gw*1.4 eh],'oo_model_vd3(7.1)',2,'ModelTypePop');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Quad+Int','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(8) bw  bh],'oo_model_vd3(4.1)',2,'QuadIntBtn');
p=p+1;[ui{p,1:7}] = deal('Van Deemter','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(7) bw  bh],'oo_model_vd3(4.2)',2,'VDBtn');
p=p+1;[ui{p,1:7}] = deal('All levels','Popupmenu',[1 1 1],[x(5)+gw/2 y(6) bw  bh],'',2,'VDlevelsPop');
p=p+1;[ui{p,1:8}] = deal('A = 0','Checkbox',Colors.bc,[x(5)+gw/2 y(5)+eh/5 bw/2  eh],'oo_model_vd3(13.1)',2,'ZeroACheck','-fvp');
p=p+1;[ui{p,1:8}] = deal('Mean A','Checkbox',Colors.bc,[x(5)+gw*0.92 y(5)+eh/5 bw/2  eh],'oo_model_vd3(13.1)',2,'MeanACheck','-fvp');
p=p+1;[ui{p,1:7}] = deal('VD+Interact.','Pushbutton',Colors.btn{1},[x(5)+gw/2 y(4) bw  bh],'oo_model_vd3(4.3)',2,'VDIntBtn');
vp=y(3); hp=x(5)+gw/2;
p=p+1;[ui{p,1:7}] = deal('I','Checkbox',Colors.bc,[hp vp bw/2  bh],'',2,'IncludeICheck');
p=p+1;[ui{p,1:7}] = deal('BI','Checkbox',Colors.bc,[hp+bw*0.25 vp bw/2  bh],'',2,'IncludeBICheck');
p=p+1;[ui{p,1:7}] = deal('CI','Checkbox',Colors.bc,[hp+bw*0.5 vp bw/2  bh],'',2,'IncludeCICheck');
p=p+1;[ui{p,1:7}] = deal(['I' char(178)],'Checkbox',Colors.bc,[hp+bw*0.75 vp bw/2  bh],'',2,'IncludeIICheck');
vp=y(2);
p=p+1;[ui{p,1:7}] = deal('Thresh (%)','Checkbox',Colors.bc,[hp vp+eh/5 bw  bh],'',2,'SignTestCheck');
p=p+1;[ui{p,1:8}] = deal('0.1','Edit',[1 1 1],[hp+bw*0.7 vp+eh/5 bw/4  eh],'',2,'SignTestEdit','-c -fh -fvp');
% Plotting
p=p+1;[ui{p,1:8}] = deal('','Frame',Colors.bc,[x(6)+gw/2 y(7)-gh*0.7 1-x(1)-(x(6)+gw/2) gh*3.8],'',2,'','');
% Infotext
p=p+1;[ui{p,1:8}] = deal('','Listbox',[1 1 1],[x(6)+gw*0.55 y(7)-gh*0.4 gw*2.5 gh*3.2],'',2,'InfoBox','');
% Figure selection
p=p+1;[ui{p,1:8}] = deal('Plot type:','Text',Colors.bc,[1-x(1)-gw*1.35 y(9) gw*1.25 eh],'',2,'','');
p=p+1;[ui{p,1:8}] = deal('Upd:','Pushbutton',Colors.bc,[1-x(1)-gw*1.35+gw*0.45 y(9) gw*0.4 eh],'oo_model_vd3(5.1)',2,'PlotUpdBtn','-fvp -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','CheckBox',Colors.bc,[1-x(1)-gw*1.35+gw*0.9 y(9) gw*0.4 eh],'',2,'PlotUpdCheck','-fvp -fh');
str={'Design','Surface','VD all levels','VD single level','Errors','Pred. vs meas.'};
p=p+1;[ui{p,1:8}] = deal(str,'Popupmenu',[1 1 1],[1-x(1)-gw*1.35 y(8)+gh*0.25 gw*1.25 eh],'oo_model_vd3(5.0)',2,'PlotTypePop','');
% Scale
vp=y(7)+gh*0.4;
p=p+1;[ui{p,1:8}] = deal('X-scale %  ','Text',Colors.bc,[1-x(1)-gw*1.2 vp-eh*0.4 gw*0.8 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[1-x(1)-gw*0.4 vp gw*0.3 eh],'oo_model_vd3(10.1)',2,'XScaleEdit','-c -fh');
vp=y(7)-gh*0.4;
p=p+1;[ui{p,1:8}] = deal('Y-scale %  ','Text',Colors.bc,[1-x(1)-gw*1.2 vp-eh*0.4 gw*0.8 eh],'',2,'','-r -fh -fvp');
p=p+1;[ui{p,1:8}] = deal('10','Edit',[1 1 1],[1-x(1)-gw*0.4 vp gw*0.3 eh],'oo_model_vd3(10.1)',2,'YScaleEdit','-c -fh');
% VD plot options
p=p+1;[ui{p,1:8}] = deal('','Frame',Colors.bc,[x(6)+gw/2 y(2) 1-x(1)-(x(6)+gw/2) gh*1.2],'',2,'','');
vp=y(2)+gh*0.1;
p=p+1;[ui{p,1:8}] = deal('VD plot options:','Text',Colors.bc,[x(6)+gw*0.55 vp gw*0.8 eh],'',2,'','');
p=p+1;[ui{p,1:7}] = deal('Mean','Checkbox',Colors.bc,[x(7)+gw*0.4 vp gw*0.8  bh],'oo_model_vd3(95)',2,'ShowVdMeanCheck');
p=p+1;[ui{p,1:7}] = deal('Indiv.','Checkbox',Colors.bc,[x(7)+gw*1.0 vp gw*0.8  bh],'oo_model_vd3(95)',2,'ShowVdIndCheck');
p=p+1;[ui{p,1:7}] = deal('Sums','Checkbox',Colors.bc,[x(7)+gw*1.6 vp gw*0.8  bh],'oo_model_vd3(95)',2,'ShowVdSumCheck');
p=p+1;[ui{p,1:7}] = deal('ABC','Checkbox',Colors.bc,[x(7)+gw*2.2 vp gw*0.7  bh],'oo_model_vd3(95)',2,'ShowVdABCCheck');
p=p+1;[ui{p,1:7}] = deal('Observ.','Checkbox',Colors.bc,[x(7)+gw*2.8 vp gw*0.7  bh],'oo_model_vd3(95)',2,'ShowVdObsCheck');
% Surface options
p=p+1;[ui{p,1:8}] = deal('','Frame',Colors.bc,[x(6)+gw/2 y(3)+gh*0.4 1-x(1)-(x(6)+gw/2) gh*2.7],'',2,'','');
vp=y(5);
p=p+1;[ui{p,1:8}] = deal('Surface options:','Text',Colors.bc,[x(6)+gw*0.55 vp gw  eh],'',2,'','');
% Type
p=p+1;[ui{p,1:7}] = deal('Mean','Radiobutton',Colors.bc,[x(7)+gw/2 vp bw+gw/2  bh],'oo_model_vd3(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Sum','Radiobutton',Colors.bc,[x(7)+gw vp bw+gw/2  bh],'oo_model_vd3(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Min','Radiobutton',Colors.bc,[x(7)+gw*1.5 vp bw+gw/2  bh],'oo_model_vd3(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Max','Radiobutton',Colors.bc,[x(7)+gw*2 vp bw+gw/2  bh],'oo_model_vd3(6.1)',2,'SurfTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Min P','Checkbox',Colors.bc,[x(7)+gw*2.5 vp bw  bh],'',2,'MinCheck');
p=p+1;[ui{p,1:7}] = deal('Max P','Checkbox',Colors.bc,[x(7)+gw*3 vp bw*0.6  bh],'',2,'MaxCheck');
% Min/Max
vp=y(4);
p=p+1;[ui{p,1:8}] = deal('X-val','Text',Colors.bc,[x(8)+gw/2 vp bw/2 eh],'',2,'','-fh -fvp');
p=p+1;[ui{p,1:8}] = deal('Y-Val','Text',Colors.bc,[x(9) vp bw/2 eh],'',2,'','-fh -fvp');
p=p+1;[ui{p,1:8}] = deal('Response','Text',Colors.bc,[x(9)+gw/2 vp bw/2 eh],'',2,'','-fh -fvp');

% Selected
vp=y(4)-gh*0.3;
% Optimal velocity check
p=p+1;[ui{p,1:8}] = deal('Show opt. vel.','Checkbox',Colors.bc,[x(6)+gw*0.55 vp-eh*0.3 gw  eh],'oo_model_vd3(5.1)',2,'OptVelCheck','-fh -fvp');
p=p+1;[ui{p,1:8}] = deal('Selection:','Text',Colors.bc,[x(8) vp-eh*0.4 bw/2  eh],'',2,'','-r -fh -fvp');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(8)+gw/2 vp bw/2 eh],'oo_model_vd3(9.4)',2,'SelXEdit','-fh -c');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(9) vp bw/2 eh],'oo_model_vd3(9.4)',2,'SelYEdit','-fh -c');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(9)+gw/2 vp bw/2 eh],'',2,'SelZEdit','-fh -c');
p=p+1;[ui{p,1:8}] = deal('Marker','Checkbox',Colors.bc,[x(10) vp-eh*0.3 bw/2 eh],'oo_model_vd3(9.5)',2,'ShowSelCheck','-fh -fvp');
% Load / Save
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_model_vd3(1.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_model_vd3(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedModelsPop');
p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_model_vd3(8.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Calc. Val.','Pushbutton',Colors.btn{1},[1-x(1)-bw y(1) bw eh],'oo_model_vd3(14)',2,'');

updfcn='oo_model_vd3(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model_vd3(96)')
set(h0,'CloseRequestFcn','oo_model_vd3(99)')

% Multiple selections
FilesList=findobj(gcf,'Tag','DataModelsList'); set(FilesList,'Max',2,'Min',0)
minmaxtags={'MinvalEdit1','MinvalEdit2','MinvalEdit3','MaxvalEdit1','MaxvalEdit2','MaxvalEdit3'};
for x=1:length(minmaxtags)
    MinMaxEdits=findobj(gcf,'Tag',minmaxtags{x});
    set(MinMaxEdits,'Enable','off')
end

MeanCheck=findobj(gcf,'Tag','MeanCheck'); set(MeanCheck,'Value',1);
AbsCheck=findobj(gcf,'Tag','AbsCheck'); set(AbsCheck,'Value',1);

SurfTypeRadio=findobj(gcf,'Tag','SurfTypeRadio','String','Mean'); set(SurfTypeRadio,'Value',1)
CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)
PlotUpdCheck=findobj(gcf,'Tag','PlotUpdCheck'); set(PlotUpdCheck,'Value',1)
OptVelCheck=findobj(gcf,'Tag','OptVelCheck'); set(OptVelCheck,'Value',1)
