function oo_model_vda(call)
% function oo_model_vda(call)
% ver 180115
% Function called from oo_model_vd
% global Locset EMod TMod

global Locset EMod TMod

%EMod
%TMod

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_model_vda ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0
    [EMod,TMod]=getmodels;
    meanparam
    openwin
    setpops
    emodlist
    % Select VD+Int if present
    EModPop=findobj(gcf,'Tag','EModPop'); ind=strmatch('VD+Int',get(EModPop,'String')); 
    if ~isempty(ind) set(EModPop,'Value',ind); end
    tmodlist   
    plotupdate
end

% ---------- Select models ----------  
if call==1.1 emodlist; plotupdate; end
if call==1.2 tmodlist; plotupdate; end

% ---------- Select code ----------
if call==2.1
    CodeRadio=findobj(gcf,'Tag','CodeRadio');
    set(CodeRadio,'Value',0); set(gcbo,'Value',1);
    emodlist; tmodlist;
end

% ---------- eval tables ----------
if call==3.1 eval_emodlist; meanparam; plotupdate; end
if call==3.2 eval_tmodlist; meanparam; plotupdate; end


% ------ plotinputs ------
% unspecific
if call==5.0
    plotupdate
end
if call==5.1
    val=str2double(get(gcbo,'String')); 
    if ~(val>-inf & val<inf) set(gcbo,'String',0); end
    plotupdate
end
if call==5.15
    val=str2double(get(gcbo,'String')); 
    if ~(val>0 & val<inf) set(gcbo,'String',100); end
    plotupdate
end
% percent+/-
%if call==5.1
    %val=str2double(get(gcbo,'String'));
    %if isnan(val) || val<-20 set(gcbo,'String',10); end   
    %plotupdate
%end
% isoEdit
if call==5.3
    val=str2double(get(gcbo,'String'));
    if isnan(val) || val<0 
        set(gcbo,'String',1); set(findobj(gcf,'Tag','AutoIsoCheck'),'Value',1)
    else
        set(findobj(gcf,'Tag','AutoIsoCheck'),'Value',0)
    end   
    plotupdate
end
% WbisoEdit
if call==5.4
    val=str2double(get(gcbo,'String'));
    if isnan(val) || val<0 
        set(gcbo,'String',1); set(findobj(gcf,'Tag','AutoWbIsoCheck'),'Value',1)
    else
        set(findobj(gcf,'Tag','AutoWbIsoCheck'),'Value',0)
    end   
    plotupdate
end

% Output to InfoBox
% Single point
if call==6.1
    userdat=get(gcbo,'UserData');
    str{1}=['Velocity: ' num2str(userdat(1),4)];
    str{2}=['Gradient: ' num2str(userdat(2),4)];
    str{3}=['Inv. efficiency: ' num2str(userdat(3),4)];
    str{4}=['Ret. time: ' num2str(userdat(4),4)];
    InfoBox=findobj(gcf,'Tag','InfoBox');
    set(InfoBox,'String',str)
    zz_copylist(0,InfoBox)
end
% line
if call==6.2
    smcell=smtocell(get(gcbo,'UserData'));
    InfoBox=findobj(gcf,'Tag','InfoBox');
    set(InfoBox,'String',smcell)
    zz_copylist(0,InfoBox)   
end


% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_model_vda (update) ----') 
    oo_model_vda(5)
end

if call==-1
    zz_message(1,'Not implemented','-r')
end


% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------------- readsetscale ---------------------
function [setscale,xl,yl]=readsetscale

xl=[]; yl=[];

% Read or set scale
if any(strcmp(get(gcbo,'Tag'),{'XScaleLowEdit','XScaleHighEdit','YScaleLowEdit','YScaleHighEdit'}))    
    
    xl(1)=str2double(get(findobj(gcf,'Tag','XScaleLowEdit'),'String'));
    xl(2)=str2double(get(findobj(gcf,'Tag','XScaleHighEdit'),'String'));
    xl=sort(xl);
    yl(1)=str2double(get(findobj(gcf,'Tag','YScaleLowEdit'),'String'));
    yl(2)=str2double(get(findobj(gcf,'Tag','YScaleHighEdit'),'String'));
    yl=sort(yl);
    
    if any(~(xl>-inf & xl<inf)) || any(~(yl>-inf & yl<inf))
        setscale=true;
    else
        setscale=false;
    end
else
    setscale=true;
end


% ------------------- setlims ---------------------
function setlims(xl,yl)

xl=sort(xl); yl=sort(yl); 
xen='on'; yen='on';

if numel(xl)~=2 xl=[0 0]; end
if numel(yl)~=2 yl=[0 0]; end

xlstr=num2str(xl(1),3); xhstr=num2str(xl(2),3);
ylstr=num2str(yl(1),3); yhstr=num2str(yl(2),3); 

if xl(1)==xl(2) xen='off'; xlstr='-'; xhstr='-'; end
if yl(1)==yl(2) yen='off'; ylstr='-'; yhstr='-'; end

set(findobj(gcf,'Tag','XScaleLowEdit'),'String',xlstr,'Enable',xen)
set(findobj(gcf,'Tag','XScaleHighEdit'),'String',xhstr,'Enable',xen)
set(findobj(gcf,'Tag','YScaleLowEdit'),'String',ylstr,'Enable',yen)
set(findobj(gcf,'Tag','YScaleHighEdit'),'String',yhstr,'Enable',yen)

if xl(2)>xl(1) xlim(xl); else xlim([xl(1)-1 xl(2)+1]); end
if yl(2)>yl(1) ylim(yl); else ylim([yl(1)-1 yl(2)+1]); end

% ------------------- plotupdate ---------------------
function plotupdate 

ModTypePop=findobj(gcf,'Tag','ModTypePop');
str=get(ModTypePop,'String');
modtype=str{get(ModTypePop,'Value')};

switch modtype
    case 'Opt Vel'
        setvisrange='on'; setvispop='off';
        set(findobj(gcf,'Tag','RateText'),'String','Rates (low, step, high):')
        plot_optvel
    case 'PPC/time (one)'
        PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
        str=get(PlotTypePop,'String');
        plottype=str{get(PlotTypePop,'Value')};
        setvisrange='off'; setvispop='on';
        set(findobj(gcf,'Tag','RateText'),'String','Plot type:')
        switch  plottype
            case 'Surface'
                plot_efftime_one
            case 'Errors'
                Estruct=calc_errors_one;
                oo_plot_errors(Estruct)
            case 'Pred. vs. meas.'
                Estruct=calc_errors_one;
                oo_plot_predmeas(Estruct)
        end
        
    case 'PPC/time (ind)'
        PlotTypePop=findobj(gcf,'Tag','PlotTypePop');
        str=get(PlotTypePop,'String');
        plottype=str{get(PlotTypePop,'Value')};
        setvisrange='off'; setvispop='on';
        set(findobj(gcf,'Tag','RateText'),'String','Plot type:')
        switch  plottype
            case 'Surface'
                plot_efftime_ind
            case 'Errors'
                Estruct=calc_errors_ind;          
                oo_plot_errors(Estruct)
            case 'Pred. vs. meas.'
                Estruct=calc_errors_ind;              
                oo_plot_predmeas(Estruct)
        end
     
end

set(findobj(gcf,'Tag','PlotTypePop'),'Visible',setvispop)
set(findobj(gcf,'Tag','RateLowEdit'),'Visible',setvisrange)
set(findobj(gcf,'Tag','RateStepEdit'),'Visible',setvisrange)
set(findobj(gcf,'Tag','RateHighEdit'),'Visible',setvisrange)


% ------------------- calc_errors_one ---------------------
function Estruct=calc_errors_one
global EMod TMod Pos

if isempty(EMod) || isempty(TMod) return; end

actives=find(EMod.active);
if numel(actives)==0
    zz_message(1,'No compound selected','-r')
    return
end

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(EMod.code)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end
cols=cols(actives,:);

homdist=str2double(get(findobj(gcf,'Tag','HomDistEdit'),'String'));

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

%eparam=EMod(emodno).param(EMod(emodno).active);
edesign=EMod(emodno).design(EMod(emodno).active);
epredmeas=EMod(emodno).predmeas(EMod(emodno).active);
edf=EMod(emodno).df(EMod(emodno).active); % degrees of freedom
ecode=EMod(emodno).code(EMod(emodno).active);
enames=EMod(emodno).names(EMod(emodno).active);
eshortnames=EMod(emodno).shortnames(EMod(emodno).active);

%tparam=TMod(tmodno).param(TMod(tmodno).active);
tdesign=TMod(tmodno).design(TMod(tmodno).active);
tpredmeas=TMod(tmodno).predmeas(TMod(tmodno).active);
tdf=TMod(tmodno).df(TMod(tmodno).active); % degrees of freedom
tcode=TMod(tmodno).code(TMod(tmodno).active);
tnames=TMod(tmodno).names(TMod(tmodno).active);
tshortnames=TMod(tmodno).shortnames(TMod(tmodno).active);

timeconst=str2double(get(findobj(gcf,'Tag','TimeConstEdit'),'String'));

CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
rstr=get(CodeRadio,'String');
switch rstr
    case 'Code'
        rnam=EMod(emodno).code;
    case 'Name'
        rnam=EMod(emodno).names;
    case 'Short name'
        rnam=EMod(emodno).shortnames;
end

tdes=tdesign{1}';
tmeas=tpredmeas{1}(1,:)+timeconst;
tpred=tpredmeas{1}(2,:)+timeconst;
tndf=tdf{1}; % time model degrees of freedom

for x=1:numel(ecode)
    
    %disp('-------------------')
    
    edes=edesign{x}';
    emeas=epredmeas{x}(1,:);
    epred=epredmeas{x}(2,:);
    endf=edf{x}; % peak width model degrees of freedom

    if isequal(edes,tdes)
        meastime=tmeas;
        predtime=tpred;
        measwidth=emeas;
        predwidth=epred;
        [nexp,n]=size(edes);
        odesign{x}=edes;
    else
        cdes=union(edes,tdes,'rows');
        odesign{x}=cdes;
        [nexp,n]=size(cdes);
        
        meastime=[]; predtime=[]; measwidth=[]; predwidth=[];       
        for expno=1:nexp            
            [lia,tind]=ismember(cdes(expno,:),tdes,'rows'); % tind=index for time data
            [lia,eind]=ismember(cdes(expno,:),edes,'rows'); % eind=index for efficiency data           
            % fetch measured time and peak widths
            meastime(expno)=tmeas(tind);
            predtime(expno)=tpred(tind);
            measwidth(expno)=emeas(eind);
            predwidth(expno)=epred(eind);            
        end
    end
    
    ppc_p=homdist./predwidth; % Predicted PPC
    ppc_m=homdist./measwidth; % Measured PPC
    
    
    %ppctime_p=ppc_p./predtime; % Predicted PPC/time
    ppctime_m{x}=ppc_m./meastime; % Measured PPC/time
    ppctime_p{x}=ppc_p./predtime;
    %ppctime_m=homdist./(measwidth.*meastime);
    %ppctime_e=ppctime_p-ppctime_m
    
    % Direct calculation of RMSE
    %rmse_ppctime(x)=(sum((ppctime_p-ppctime_m).^2)/numel(ppctime_m))^0.5;   
    
    % Estimated RMSE from propagation of error
    relerr_time=(predtime-meastime)./meastime; % Relative errors, time
    relerr_ppc=(ppc_p-ppc_m)./ppc_m;         
    rel_rmse_time=(sum((relerr_time).^2)/numel(relerr_time))^0.5;
    rel_rmse_ppc=(sum((relerr_ppc).^2)/numel(relerr_ppc))^0.5;    
    rel_rmse_ppctime_est=(rel_rmse_ppc^2+rel_rmse_time^2)^0.5;
    rmse_ppctime(x)=rel_rmse_ppctime_est*mean(ppctime_m{x}); 
    
    % Adjusted RMSE from propagation of error
    relerr_time=(predtime-meastime)./meastime; % Relative errors, time
    relerr_ppc=(ppc_p-ppc_m)./ppc_m;         
    rel_rmse_time=(sum((relerr_time).^2)/tndf)^0.5;
    rel_rmse_ppc=(sum((relerr_ppc).^2)/endf)^0.5;    
    rel_rmse_ppctime_est=(rel_rmse_ppc^2+rel_rmse_time^2)^0.5;
    adj_rmse_ppctime(x)=rel_rmse_ppctime_est*mean(ppctime_m{x});    
    
    R=corrcoef(ppctime_m{x},ppctime_p{x}); correl(x)=R(1,2);
    
    bias(x)=mean(ppctime_p{x})-mean(ppctime_m{x});

    % mean normalization
    %rmse_time=sqrt(sum((predtime-meastime).^2)/numel(meastime));
    %rmse_ppc=sqrt(sum((ppc_p-ppc_m).^2)/numel(ppc_m));    
    %rel_rmse_time=rmse_time/mean(meastime);
    %rel_rmse_ppc=rmse_ppc/mean(ppc_m);
    %rel_rmse_ppctime_est=sqrt(rel_rmse_ppc^2+rel_rmse_time^2);
    %rmse_ppctime_est4(x)=rel_rmse_ppctime_est*mean(ppctime_m); 
    
    % Adj RMSE from mean
    %adj_rmse_time=sqrt(sum((predtime-meastime).^2)/tndf);
    %adj_rmse_ppc=sqrt(sum((ppc_p-ppc_m).^2)/endf);  
    %rel_adj_rmse_time=adj_rmse_time/mean(meastime);
    %rel_adj_rmse_ppc=adj_rmse_ppc/mean(ppc_m);
    %rel_adj_rmse_ppctime_est=sqrt(rel_adj_rmse_ppc^2+rel_adj_rmse_time^2);
    %adj_rmse_ppctime_est2(x)=rel_adj_rmse_ppctime_est*mean(ppctime_m); 
    
    
    %adj_rel_rmse_time=(sum((relerr_time).^2)/tndf)^0.5;
    %adj_rel_rmse_ppc=(sum((relerr_ppc).^2)/endf)^0.5;
    %adj_rel_rmse_ppctime_est=(adj_rel_rmse_time^2+adj_rel_rmse_width^2)^0.5
    %adj_rel_rmse_ppctime_est=(adj_rel_rmse_time^2+adj_rel_rmse_ppc^2)^0.5
    %adj_rmse_ppctime_est(x)=adj_rel_rmse_ppctime_est*mean(ppctime_p); % Estimated adj RMSE from error propagation
    
    Namestr{x}=rnam{actives(x)};
    n_exp(x)=nexp;
  
end

ppos=Pos.leftplot; ppos(2)=Pos.yg(10)+Pos.gh*0.4;
Estruct.plotpos=ppos;
Estruct.tablepos=[Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5];
Estruct.tablename='ModelVdaTable';
Estruct.modeltype=[EMod(emodno).modeltype ' / ' TMod(tmodno).modeltype];
Estruct.parameter=[EMod(emodno).parameter ' / ' TMod(tmodno).parameter];
Estruct.rmse=rmse_ppctime;
Estruct.rmse_adj=adj_rmse_ppctime;
Estruct.Measured=ppctime_m;
Estruct.Predicted=ppctime_p;
Estruct.Design=odesign;
Estruct.n_exp=n_exp;
Estruct.correl=correl;
Estruct.bias=bias;
Estruct.Varnames{1}=EMod.velocityvar; Estruct.Varnames{2}=EMod.interactvar; 
Estruct.Labels=Namestr;
Estruct.Colors=cols;
 

% ------------------- calc_errors_ind ---------------------
function Estruct=calc_errors_ind
global EMod TMod Pos

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');


emodcodes=EMod(emodno).code(EMod(emodno).active);
tmodcodes=TMod(tmodno).code;
commoncodes=intersect(emodcodes,tmodcodes);

% Check validity
vEind=[]; vTind=[]; alldesign=[];
for x=1:numel(commoncodes)
    eind=find(strcmp(commoncodes{x},EMod(emodno).code)); eind=eind(1);
    tind=find(strcmp(commoncodes{x},TMod(tmodno).code)); tind=tind(1);
    ep=EMod(emodno).param{eind};
    tp=TMod(tmodno).param{tind};
    if ~(any(isnan(ep)) && any(isnan(tp)))
        vEind(numel(vEind)+1)=eind;
        vTind(numel(vTind)+1)=tind;  
        alldesign=[alldesign EMod(emodno).design{eind} TMod(tmodno).design{tind}];  
    end
end
if numel(vEind)==0 
    plot_dummy('No valid model combinations')
    return; 
end % return if no valids

% Set colors
linecol=[0 0 1; 0 0.8 0; 1 0 0; 0.8 0.8 0; 1 0 1; 0 1 1; 0.75 0.75 0.75]*0.9; [n_colors,n]=size(linecol); 
nrep=ceil(numel(EMod.code)/n_colors); cols=[];
for x=1:nrep cols=[cols; linecol]; linecol=linecol*0.75; end
cols=cols(vEind,:);

homdist=str2double(get(findobj(gcf,'Tag','HomDistEdit'),'String'));

%eparam=EMod(emodno).param(EMod(emodno).active);
edesign=EMod(emodno).design(vEind);
epredmeas=EMod(emodno).predmeas(vEind);
edf=EMod(emodno).df(vEind); % degrees of freedom
ecode=EMod(emodno).code(vEind);
enames=EMod(emodno).names(vEind);
eshortnames=EMod(emodno).shortnames(vEind);

%tparam=TMod(tmodno).param(TMod(tmodno).active);
tdesign=TMod(tmodno).design(vTind);
tpredmeas=TMod(tmodno).predmeas(vTind);
tdf=TMod(tmodno).df(vTind); % degrees of freedom
tcode=TMod(tmodno).code(vTind);
tnames=TMod(tmodno).names(vTind);
tshortnames=TMod(tmodno).shortnames(vTind);

timeconst=str2double(get(findobj(gcf,'Tag','TimeConstEdit'),'String'));

CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
rstr=get(CodeRadio,'String');
switch rstr
    case 'Code'
        rnam=EMod(emodno).code;
    case 'Name'
        rnam=EMod(emodno).names;
    case 'Short name'
        rnam=EMod(emodno).shortnames;
end

for x=1:numel(vEind)

    edes=edesign{x}';
    emeas=epredmeas{x}(1,:);
    epred=epredmeas{x}(2,:);
    endf=edf{x}; % peak width model degrees of freedom
    
    tdes=tdesign{x}';
    tmeas=tpredmeas{x}(1,:)+timeconst;
    tpred=tpredmeas{x}(2,:)+timeconst;
    tndf=tdf{x}; % time model degrees of freedom    

    if isequal(edes,tdes)
        meastime=tmeas;
        predtime=tpred;
        measwidth=emeas;
        predwidth=epred;
        [nexp,n]=size(edes);
        odesign{x}=edes;
    else
        cdes=union(edes,tdes,'rows');
        odesign{x}=cdes;
        [nexp,n]=size(cdes);
        
        meastime=[]; predtime=[]; measwidth=[]; predwidth=[];       
        for expno=1:nexp            
            [lia,tind]=ismember(cdes(expno,:),tdes,'rows'); % tind=index for time data
            [lia,eind]=ismember(cdes(expno,:),edes,'rows'); % eind=index for efficiency data           
            % fetch measured time and peak widths
            meastime(expno)=tmeas(tind);
            predtime(expno)=tpred(tind);
            measwidth(expno)=emeas(eind);
            predwidth(expno)=epred(eind);            
        end
    end
    
    ppc_p=homdist./predwidth; % Predicted PPC
    ppc_m=homdist./measwidth; % Measured PPC
    
    
    %ppctime_p=ppc_p./predtime; % Predicted PPC/time
    ppctime_m{x}=ppc_m./meastime; % Measured PPC/time
    ppctime_p{x}=ppc_p./predtime;
    %ppctime_m=homdist./(measwidth.*meastime);
    %ppctime_e=ppctime_p-ppctime_m
    
    % Direct calculation of RMSE
    %rmse_ppctime(x)=(sum((ppctime_p-ppctime_m).^2)/numel(ppctime_m))^0.5;   
    
    % Estimated RMSE from propagation of error
    relerr_time=(predtime-meastime)./meastime; % Relative errors, time
    relerr_ppc=(ppc_p-ppc_m)./ppc_m;         
    rel_rmse_time=(sum((relerr_time).^2)/numel(relerr_time))^0.5;
    rel_rmse_ppc=(sum((relerr_ppc).^2)/numel(relerr_ppc))^0.5;    
    rel_rmse_ppctime_est=(rel_rmse_ppc^2+rel_rmse_time^2)^0.5;
    rmse_ppctime(x)=rel_rmse_ppctime_est*mean(ppctime_m{x}); 
    
    % Adjusted RMSE from propagation of error
    relerr_time=(predtime-meastime)./meastime; % Relative errors, time
    relerr_ppc=(ppc_p-ppc_m)./ppc_m;         
    rel_rmse_time=(sum((relerr_time).^2)/tndf)^0.5;
    rel_rmse_ppc=(sum((relerr_ppc).^2)/endf)^0.5;    
    rel_rmse_ppctime_est=(rel_rmse_ppc^2+rel_rmse_time^2)^0.5;
    adj_rmse_ppctime(x)=rel_rmse_ppctime_est*mean(ppctime_m{x});    
    
    R=corrcoef(ppctime_m{x},ppctime_p{x}); correl(x)=R(1,2);
    
    bias(x)=mean(ppctime_p{x})-mean(ppctime_m{x});

    % mean normalization
    %rmse_time=sqrt(sum((predtime-meastime).^2)/numel(meastime));
    %rmse_ppc=sqrt(sum((ppc_p-ppc_m).^2)/numel(ppc_m));    
    %rel_rmse_time=rmse_time/mean(meastime);
    %rel_rmse_ppc=rmse_ppc/mean(ppc_m);
    %rel_rmse_ppctime_est=sqrt(rel_rmse_ppc^2+rel_rmse_time^2);
    %rmse_ppctime_est4(x)=rel_rmse_ppctime_est*mean(ppctime_m); 
    
    % Adj RMSE from mean
    %adj_rmse_time=sqrt(sum((predtime-meastime).^2)/tndf);
    %adj_rmse_ppc=sqrt(sum((ppc_p-ppc_m).^2)/endf);  
    %rel_adj_rmse_time=adj_rmse_time/mean(meastime);
    %rel_adj_rmse_ppc=adj_rmse_ppc/mean(ppc_m);
    %rel_adj_rmse_ppctime_est=sqrt(rel_adj_rmse_ppc^2+rel_adj_rmse_time^2);
    %adj_rmse_ppctime_est2(x)=rel_adj_rmse_ppctime_est*mean(ppctime_m); 
    
    
    %adj_rel_rmse_time=(sum((relerr_time).^2)/tndf)^0.5;
    %adj_rel_rmse_ppc=(sum((relerr_ppc).^2)/endf)^0.5;
    %adj_rel_rmse_ppctime_est=(adj_rel_rmse_time^2+adj_rel_rmse_width^2)^0.5
    %adj_rel_rmse_ppctime_est=(adj_rel_rmse_time^2+adj_rel_rmse_ppc^2)^0.5
    %adj_rmse_ppctime_est(x)=adj_rel_rmse_ppctime_est*mean(ppctime_p); % Estimated adj RMSE from error propagation
    
    Namestr{x}=rnam{vEind(x)};
    n_exp(x)=nexp;
  
end

ppos=Pos.leftplot; ppos(2)=Pos.yg(10)+Pos.gh*0.4;
Estruct.plotpos=ppos;
Estruct.tablepos=[Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5];
Estruct.tablename='ModelVdaTable';
Estruct.modeltype=[EMod(emodno).modeltype ' / ' TMod(tmodno).modeltype];
Estruct.parameter=[EMod(emodno).parameter ' / ' TMod(tmodno).parameter];
Estruct.rmse=rmse_ppctime;
Estruct.rmse_adj=adj_rmse_ppctime;
Estruct.Measured=ppctime_m;
Estruct.Predicted=ppctime_p;
Estruct.Design=odesign;
Estruct.n_exp=n_exp;
Estruct.correl=correl;
Estruct.bias=bias;
Estruct.Varnames{1}=EMod.velocityvar; Estruct.Varnames{2}=EMod.interactvar; 
Estruct.Labels=Namestr;
Estruct.Colors=cols;


% ------------------- plot_predmeas ---------------------
function plot_predmeas(Estruct)

%return

ph=findobj(gcf,'Position',Estruct.plotpos,'Type','axes'); delete(ph) % deletes old plot
subplot('Position',Estruct.plotpos)

allpred=[]; allmeas=[];
for x=1:numel(Estruct.Measured)
    allpred=[allpred Estruct.Predicted{x}];
    allmeas=[allmeas Estruct.Measured{x}];
    C=corrcoef(Estruct.Measured{x},Estruct.Predicted{x});
    r(x)=C(1,2);
end
minv=min([allpred allmeas]);
maxv=max([allpred allmeas]);

C=corrcoef(allpred,allmeas);
r_overall=C(1,2);

line([minv maxv],[minv maxv],'Color',[0.7 0.7 0.7]); hold on
text(0.03,0.95,'Predicted','Units','Normalized','FontWeight','bold','FontSize',10)
text(0.97,0.05,'Measured','Units','Normalized','FontWeight','bold','HorizontalAlignment','right','FontSize',10)

% set text box and header
headerstr{1}='Predicted vs measured'; 
headerstr{2}=['Parameter: ' Estruct.parameter]; 
headerstr{3}=['Model type: ' Estruct.modeltype]; 
headerstr{4}=['Mean R' char(178) '=' num2str(mean(r)^2,4)]; 
headerstr{5}=['Overall R' char(178) '=' num2str(r_overall^2,4)]; 
text(0.5,0.95,headerstr,'Units','Normalized','FontWeight','bold','FontSize',12,'HorizontalAlignment','center','VerticalAlignment','top','Interpreter','none')

for x=1:numel(Estruct.Measured)
    plot(Estruct.Measured{x},Estruct.Predicted{x},'o','MarkerFaceColor',Estruct.Colors(x,:),'MarkerEdgeColor','none'); 
end

o=(maxv-minv)/20;
hp=maxv-o*1.5;
for x=1:numel(Estruct.Labels)
    text(minv-o*0.2,hp,Estruct.Labels{x},'Color',Estruct.Colors(x,:),'FontWeight','bold')
    hp=hp-o*0.8;
end

xlim([minv-o maxv+o]); ylim([minv-o maxv+o]);

set(gca,'Tag','PlotPredMeas')
zz_copyfigure

% Table
colno=0;
if isfield(Estruct,'correl') && ~isempty(Estruct.correl)
    colno=colno+1;
    for x=1:numel(Estruct.correl) Data{x,colno}=Estruct.correl(x)^2; end
    ColumnName{colno}=['R' char(178)];
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.correl.^2);
end
if isfield(Estruct,'bias') && ~isempty(Estruct.bias)
    colno=colno+1;
    for x=1:numel(Estruct.bias) Data{x,colno}=Estruct.bias(x); end
    ColumnName{colno}='Bias';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.bias);
end
if isfield(Estruct,'rmse') && ~isempty(Estruct.rmse)
    colno=colno+1;
    for x=1:numel(Estruct.rmse) Data{x,colno}=Estruct.rmse(x); end
    ColumnName{colno}='RMSE';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse);
end
if isfield(Estruct,'rmse_adj') && ~isempty(Estruct.rmse_adj)
    colno=colno+1;
    for x=1:numel(Estruct.rmse_adj) Data{x,colno}=Estruct.rmse_adj(x); end
    ColumnName{colno}='RMSE(adj)';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse_adj);
end
if isfield(Estruct,'n_exp') && ~isempty(Estruct.n_exp)
    colno=colno+1;
    for x=1:numel(Estruct.n_exp) Data{x,colno}=Estruct.n_exp(x); end
    ColumnName{colno}='N. Exp.';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.n_exp);
end

Labels=Estruct.Labels;
[nrows,ncols]=size(Data);
if nrows>1
    Labels{nrows+1}='Mean';
    for x=1:ncols
        Data{nrows+1,x}=Meancell{x};       
    end
end

% Table
T.Data=Data;
T.TableName=Estruct.tablename;
T.Position=Estruct.tablepos;
T.ColumnName=ColumnName;
T.ColumnFormat=ColumnFormat;
T.RowName=Labels;
T.ColumnEditable=false;
T.ViewPref=3;

T.HeaderText{1}='PREDICTED VS MEASURED:';
T.HeaderText{2}=['Model type: ' Estruct.modeltype];
T.HeaderText{3}=['Parameter: ' Estruct.parameter];

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- plot_efftime_ind ---------------------
function plot_efftime_ind
global EMod TMod Pos

%disp('--- plot_efftime_ind ---')

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

emodcodes=EMod(emodno).code(EMod(emodno).active);
tmodcodes=TMod(tmodno).code;
commoncodes=intersect(emodcodes,tmodcodes);

% Check validity
vEind=[]; vTind=[]; alldesign=[];
for x=1:numel(commoncodes)
    eind=find(strcmp(commoncodes{x},EMod(emodno).code)); eind=eind(1);
    tind=find(strcmp(commoncodes{x},TMod(tmodno).code)); tind=tind(1);
    ep=EMod(emodno).param{eind};
    tp=TMod(tmodno).param{tind};
    if ~(any(isnan(ep)) && any(isnan(tp)))
        vEind(numel(vEind)+1)=eind;
        vTind(numel(vTind)+1)=tind;  
        alldesign=[alldesign EMod(emodno).design{eind} TMod(tmodno).design{tind}];  
    end
end
if numel(vEind)==0 
    plot_dummy('No valid model combinations')
    return; 
end % return if no valids

cdesign=unique(alldesign','rows')';
velrange=[min(cdesign(1,:)) max(cdesign(1,:))];
raterange=[min(cdesign(2,:)) max(cdesign(2,:))];

[setscale,xl,yl]=readsetscale;
if setscale   
    xl=velrange;
    yl=raterange;
    xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
    yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;   
end
res_x=100; res_y=100; %resolution of x and y

inc_x=(xl(2)-xl(1))/res_x;
inc_y=(yl(2)-yl(1))/res_y;

xs=xl(1):inc_x:xl(2);
le_x=length(xs);
ys=yl(1):inc_y:yl(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

homridist=str2double(get(findobj(gcf,'Tag','HomDistEdit'),'String'));

emodtype=strmatch(EMod(emodno).modeltype,{'Quad+Int','Log+Int','VD+Int'});
if emodtype==2 xse=log(xs); yse=log(ys); else xse=xs; yse=ys; end % take ln of all values if ln-model 
tmodtype=strmatch(TMod(tmodno).modeltype,{'Quad+Int','Log+Int','VD+Int'});
if tmodtype==2 xst=log(xs); yst=log(ys); else xst=xs; yst=ys; end % take ln of all values if ln-model 

for x=1:numel(vEind)

    eparam=EMod(emodno).param{vEind(x)};
    D=[];
        
    for xc=1:le_x
        for yc=1:le_y
            if emodtype==1 % Quad+Int
                D=[1 xse(xc) yse(yc) xse(xc)*yse(yc) xse(xc)^2 yse(yc)^2];
            end
            if emodtype==2 % Log+Int
                D=[1 xse(xc) yse(yc) xse(xc)*yse(yc)];
            end
            if emodtype==3 % VD+Int
                D=[1 1/xse(xc) xse(xc) yse(yc) yse(yc)/xse(xc) xse(xc)*yse(yc) yse(yc)^2];
            end
            z_val=[D*eparam];
            EZ_cont(xc,yc)=z_val;
        end
    end
    if emodtype==2 EZ_cont=exp(EZ_cont); end
        
    tparam=TMod(tmodno).param{vTind(x)};
    D=[];
   
    for xc=1:le_x
        for yc=1:le_y
            if tmodtype==1 % Quad+Int
                D=[1 xst(xc) yst(yc) xst(xc)*yst(yc) xst(xc)^2 yst(yc)^2];
            end
            if tmodtype==2 % Log+Int
                D=[1 xst(xc) yst(yc) xst(xc)*yst(yc)];
            end
            if tmodtype==3 % VD+Int
                D=[1 1/xst(xc) xst(xc) yst(yc) yst(yc)/xst(xc) xst(xc)*yst(yc) yst(yc)^2];
            end
            z_val=[D*tparam];
            TZ_cont(xc,yc)=z_val;
        end
    end
    if tmodtype==2 TZ_cont=exp(TZ_cont); end    
    
    % Add timeconstant
    timeconst=str2double(get(findobj(gcf,'Tag','TimeConstEdit'),'String'));
    TZ_cont=TZ_cont+timeconst;
    
    R_block(:,:,x)=homridist./(EZ_cont.*TZ_cont);
    %R_block(:,:,x)=EZ_cont; % TEMP
    %R_block(:,:,x)=TZ_cont; % TEMP   
end

R_cont=mean(R_block,3);
fillcont(X_cont,Y_cont,R_cont) 
set(gca,'Tag','plot_efftime_ind')
zz_copyfigure

setlims(xl,yl)

% Table
CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
rstr=get(CodeRadio,'String');
switch rstr
    case 'Code'
        rnam=EMod(emodno).code(vEind);
    case 'Name'
        rnam=EMod(emodno).names(vEind);
    case 'Short name'
        rnam=EMod(emodno).shortnames(vEind);
end

T.Data(:,1)=rnam'; T.Data(:,2)=rnam';
T.TableName='ModelVdaTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5];
T.ColumnName={'PPC','Time'};
T.ColumnFormat={'str','str'};
T.RowName=[];
T.ColumnEditable=false;
T.ViewPref=3;

T.HeaderText{1}='PPC/time (individual):';
T.HeaderText{2}=['Peak width model type: ' EMod.modeltype];
T.HeaderText{3}=['Time model type: ' TMod.modeltype];
T.HeaderText{4}=['Homolog RI distance: ' num2str(homridist)];
T.HeaderText{5}=['Added time constant: ' num2str(timeconst)];

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);




% ------------------- plot_efftime_one ---------------------
function plot_efftime_one
global EMod TMod Pos

%disp('--- plot_efftime_one ---')

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

[XT_cont,YT_cont,ZT_cont]=calcsurf(TMod(tmodno));
[XE_cont,YE_cont,ZE_cont]=calcsurf(EMod(emodno));

% Add timeconstant
timeconst=str2double(get(findobj(gcf,'Tag','TimeConstEdit'),'String'));
ZT_cont=ZT_cont+timeconst;

if ~isequal(XT_cont,XE_cont) || ~isequal(YT_cont,YE_cont)
    zz_message(1,'Error: Parameter ranges for time and efficiency models do not match','-r')
    return
end

R_cont=1./(ZE_cont.*ZT_cont); % PPC/Time
homridist=str2double(get(findobj(gcf,'Tag','HomDistEdit'),'String'));
R_cont=R_cont*homridist;
fillcont(XT_cont,YT_cont,R_cont)

set(gca,'Tag','plot_efftime_one')
zz_copyfigure

% Table
CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
rstr=get(CodeRadio,'String');
switch rstr
    case 'Code'
        enam=EMod(emodno).code(EMod(emodno).active);
        tnam=TMod(tmodno).code(TMod(tmodno).active);
    case 'Name'
        enam=EMod(emodno).names(EMod(emodno).active);
        tnam=TMod(tmodno).names(TMod(tmodno).active);
    case 'Short name'
        enam=EMod(emodno).shortnames(EMod(emodno).active);
        tnam=TMod(tmodno).shortnames(TMod(tmodno).active);
end

T.Data(:,1)=enam'; T.Data(1:numel(enam),2)=tnam;
T.TableName='ModelVdaTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5];
T.ColumnName={'PPC','Time'};
T.ColumnFormat={'str','str'};
T.RowName=[];
T.ColumnEditable=false;
T.ViewPref=3;

T.HeaderText{1}='PPC/time (single):';
T.HeaderText{2}=['Peak width model type: ' EMod.modeltype];
T.HeaderText{3}=['Time model type: ' TMod.modeltype];
T.HeaderText{4}=['Homolog RI distance: ' num2str(homridist)];
T.HeaderText{5}=['Added time constant: ' num2str(timeconst)];

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- plot_optvel ---------------------
function plot_optvel
global EMod TMod

%disp('--- plot_optvel ---')

if isempty(EMod) || isempty(TMod) return; end

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

% Check that model range  is the same
%dse=[min(EMod(emodno).design(1,:)) max(EMod(emodno).design(1,:)); min(EMod(emodno).design(2,:)) max(EMod(emodno).design(2,:))];
%dst=[min(TMod(tmodno).design(1,:)) max(TMod(tmodno).design(1,:)); min(TMod(tmodno).design(2,:)) max(TMod(tmodno).design(2,:))];
%if ~isequal(dse,dst) 
%    zz_message(1,'The design space of the selected models differ','-r')
%    return
%end

if ~isequal(EMod(emodno).velocityrange,TMod(tmodno).velocityrange) || ~isequal(EMod(emodno).interactrange,TMod(tmodno).interactrange)
    zz_message(1,'The design space of the selected models differ','-r')
    return
end
    

[X_cont,Y_cont,Z_cont]=calcsurf(TMod(tmodno));
% Add time constant
timeconst=str2double(get(findobj(gcf,'Tag','TimeConstEdit'),'String'));
Z_cont=Z_cont+timeconst;
fillcont(X_cont,Y_cont,Z_cont)

iv=Y_cont(1,:);
uv=optvel(EMod(emodno).meanparam,iv,EMod(emodno).modeltype);
hold on
emaxline=plot(uv,iv,'-','Color',[1 1 1],'LineWidth',2);
hold off

% --- Contourlevels ---
%disp('--- contourlevels ---')
% fin max/min values for countours (at top and bottom of opt vel line)
zv=getz([min(uv) max(uv)],[min(iv) max(iv)],EMod(emodno).meanparam,EMod(emodno).modeltype);
%zr=range(zv) % does not work in 2013a
zr=max(zv)-min(zv);
a=linspace(zv(1)-0.1*zr,zv(2)+0.1*zr,20)';
astr=unique(cellstr(num2str(a,2)));
for x=1:numel(astr)
    contlevels(x)=str2double(astr{x});
end
contlevels=sort(contlevels);

contmax=max(contlevels);
contmin=min(contlevels);
spa=(contmax-contmin)/(numel(contlevels)-1);
nlev=numel(contlevels);
if nlev<10 spa=spa/2; contlevels=contmin:spa:contmax; end

% Use userset levels
avgspace=(max(contlevels)-min(contlevels))/(numel(contlevels)-1);
oldv=contlevels;
AutoWbIsoCheck=findobj(gcf,'Tag','AutoWbIsoCheck');
WbIsoEdit=findobj(gcf,'Tag','WbIsoEdit');
if ~get(AutoWbIsoCheck,'Value')
    isosp=str2double(get(WbIsoEdit,'String'));
    minv=min(contlevels);
    maxv=max(contlevels);
    f=1/isosp;  
    minv=minv*f; minv=floor(minv); minv=minv/f;
    maxv=maxv*f; maxv=floor(maxv); maxv=maxv/f;  
    contlevels=minv:isosp:maxv;

    if numel(contlevels)>100
        set(AutoWbIsoCheck,'Value',1);  contlevels=oldv;
        zz_message(1,'Too many wb contour levels - Iso distance set to auto','-r')
    end
    if numel(contlevels)<5
        set(AutoWbIsoCheck,'Value',1);  contlevels=oldv;
        zz_message(1,'Too few wb contour levels - Iso distance set to auto','-r')
    end
end
if get(AutoWbIsoCheck,'Value') 
    % userdefined
    set(WbIsoEdit,'String',num2str(avgspace))   
end

contlevels(contlevels>max(zv))=[];
contlevels(contlevels<min(zv))=[];

hold on
[X_cont,Y_cont,Z_cont]=calcsurf(EMod(emodno));
topcont(X_cont,Y_cont,Z_cont,contlevels)
hold off

% add labels
if get(findobj(gcf,'Tag','WbLabCheck'),'Value')
    xvect=linspace(min(uv),max(uv));
    for lno=1:numel(contlevels)
        gradv=getcont(contlevels(lno),xvect,EMod(emodno).meanparam,EMod(emodno).modeltype);
        [maxy,maxind]=max(gradv); 
        if ~isempty(maxind)
            maxind=maxind(1); maxy=maxy(1);
            maxx=xvect(maxind);
            text(maxx,maxy,num2str(contlevels(lno)),...
                'HorizontalAlignment','right',...
                'VerticalAlignment','bottom',...
                'FontWeight','bold',...
                'FontSize',12,...
                'Color',[1 1 1])
        end  
    end
end

% Find optimum
xrange(1)=min(min(X_cont));
xrange(2)=max(max(X_cont));
yrange(1)=min(min(Y_cont));
yrange(2)=max(max(Y_cont));

[xval,yval,zval,eff]=findopt(contlevels,xrange,yrange);

iv=linspace(yrange(1),yrange(2),100);
uv=interp1(yval,xval,iv,'spline','extrap');

hold on
uoptline=plot(uv,iv,'-','Color',[0 0 0],'LineWidth',2);
for x=1:numel(xval)  
    plot(xval(x),yval(x),'o','MarkerFaceColor',[0 0 0],'MarkerEdgeColor',[1 1 1],'UserData',[xval(x) yval(x) eff(x) zval(x)],'ButtonDownFcn','oo_model_vda(6.1)')
end
hold off

set(gca,'Tag','plot_optvel')
zz_copyfigure


% Statistics for info box
setrate=1;
if any(strcmp(get(gcbo,'Tag'),{'RateLowEdit','RateStepEdit','RateHighEdit'}))
    lv=str2double(get(findobj(gcf,'Tag','RateLowEdit'),'String'));
    sv=str2double(get(findobj(gcf,'Tag','RateStepEdit'),'String'));
    hv=str2double(get(findobj(gcf,'Tag','RateHighEdit'),'String'));    
    if ~any(~([lv sv hv]>-inf & [lv sv hv]<inf))
        iv=lv:sv:hv;
        if numel(iv)>1
            setrate=0;
        end
    end
end
if setrate    
    iv=get(gca,'YTick');
    set(findobj(gcf,'Tag','RateLowEdit'),'String',num2str(min(iv)),'Enable','on')
    set(findobj(gcf,'Tag','RateStepEdit'),'String',num2str(median(diff(iv))),'Enable','on')
    set(findobj(gcf,'Tag','RateHighEdit'),'String',num2str(max(iv)),'Enable','on')
end

uvm=optvel(EMod(emodno).meanparam,iv,EMod(emodno).modeltype); % max eff at grad
evm=getz(uvm,iv,EMod(emodno).meanparam,EMod(emodno).modeltype); % inverse eff at max eff
tvm=getz(uvm,iv,TMod(tmodno).meanparam,TMod(tmodno).modeltype); % time at optimum

uvo=interp1(yval,xval,iv,'spline','extrap'); % uv optimum
evo=getz(uvo,iv,EMod(emodno).meanparam,EMod(emodno).modeltype); % inverse eff at optimum
tvo=getz(uvo,iv,TMod(tmodno).meanparam,TMod(tmodno).modeltype); % time at optimum

tvm=tvm+timeconst;
tvo=tvo+timeconst;

SM=[iv' uvm' evm' tvm' uvo' evo' tvo'];

%smcell=smtocell(SM);
optveltable(SM)

%InfoBox=findobj(gcf,'Tag','InfoBox');
%set(InfoBox,'String',smcell)
%zz_copylist(0,InfoBox)

set(emaxline,'ButtonDownFcn','oo_model_vda(6.2)','UserData',SM)
set(uoptline,'ButtonDownFcn','oo_model_vda(6.2)','UserData',SM)


% ------------------- plot_dummy ---------------------
function plot_dummy(str)
global Pos 

ppos=Pos.leftplot; ppos(2)=Pos.yg(10)+Pos.gh*0.4;
ph=findobj(gcf,'Position',ppos,'Type','axes'); delete(ph) % deletes old plot
%InfoBox=findobj(gcf,'Tag','InfoBox'); set(InfoBox,'String','')
ah=subplot('Position',ppos);
set(ah,'XTick',[],'YTick',[])
text(0.5,0.5,str,'Units','Normalized','HorizontalAlignment','center',...
    'VerticalAlignment','middle','FontWeight','bold','FontSize',12)
setlims([],[])
xlim([-1 1]); ylim([-1 1])


% ------------------- optveltable ---------------------
function optveltable(SM)
global Pos

T.Data=SM;
T.TableName='ModelVdaTable';
T.Position=[Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5];
T.ColumnName={'Rate','u(opt)','w(opt)','t(opt)','u(topt)','w(topt)','t(topt)'};
T.ColumnFormat={4,4,4,4,4,4,4};
T.RowName=[];
T.ColumnEditable=false;
T.ViewPref=3;

T.FooterText{1}='White line:';
T.FooterText{2}='- u(opt) = Velocity that gives maximum efficiency at rate';
T.FooterText{3}='- w(opt) = Inverse efficiency at u(opt)';
T.FooterText{4}='- t(opt) = Time at u(opt)';
T.FooterText{5}='Black line:';
T.FooterText{6}='- u(topt) = Time optimal velocity at rate (efficiency/time tradeoff)';
T.FooterText{7}='- w(topt) = Inverse efficiency at u(topt)';
T.FooterText{8}='- t(topt) = Time at u(topt)';

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- smtocell ---------------------

function smcell=smtocell(SM)

[m,n]=size(SM);
p=1; str(p,:)={'Rate','u(opt)','w(opt)','t(opt)','u(topt)','w(topt)','t(topt)'};
p=p+1; str(p,:)={'-','-','-','-','-','-','-'};
for x=1:m
    p=p+1;
    for y=1:n
        str{p,y}=num2str(SM(x,y),4);
    end
end

[m,n]=size(str); s=repmat('  ',m,1);
cstr=[strvcat(str(:,1)) s  ...
    strvcat(str(:,2)) s ...
    strvcat(str(:,3)) s ...
    strvcat(str(:,4)) s ...
    strvcat(str(:,5)) s ...
    strvcat(str(:,6)) s ...
    strvcat(str(:,7)) s];

[m,n]=size(cstr);
cstr(2,:)=repmat('-',1,n);
cstr(m+1,:)=repmat('-',1,n);

for x=1:m+1
    smcell{x}=cstr(x,:);
end

%smcell{x+1}='Rate = Gradient';
smcell{x+2}='White line:';
smcell{x+3}='- u(opt) = Velocity that gives maximum efficiency at rate';
smcell{x+4}='- w(opt) = Inverse efficiency at u(opt)';
smcell{x+5}='- t(opt) = Time at u(opt)';
smcell{x+6}='Black line:';
smcell{x+7}='- u(topt) = Time optimal velocity at rate (efficiency/time tradeoff)';
smcell{x+8}='- w(topt) = Inverse efficiency at u(topt)';
smcell{x+9}='- t(topt) = Time at u(topt)';

        
% ------------------- findopt ---------------------
function [xval,yval,zval,eff]=findopt(eff,xrange,yrange)
global EMod TMod
%disp('---- findopt ----')

EModPop=findobj(gcf,'Tag','EModPop');
emodno=get(EModPop,'Value');

TModPop=findobj(gcf,'Tag','TModPop');
tmodno=get(TModPop,'Value');

xval=[]; yval=[]; zval=[];

ecoeff=EMod(emodno).meanparam;
etype=EMod(emodno).modeltype;
tcoeff=TMod(tmodno).meanparam;
ttype=TMod(tmodno).modeltype;

yo=(yrange(2)-yrange(1))*0.1; % Adds a 10% offset on y to handle contours that are just inside the plot
% Prescreen to find x-range that is within y-range
xtest=linspace(xrange(1),xrange(2),100);
for lno=1:numel(eff)
    yv=getcont(eff(lno),xtest,ecoeff,etype);
    xv=xtest(yv<=yrange(2)+yo & yv>=yrange(1)-yo);
    minx{lno}=min(xtest(yv>=yrange(1)-yo & yv<=yrange(2)+yo));
    maxx{lno}=max(xtest(yv>=yrange(1)-yo & yv<=yrange(2)+yo));
end


% delete if empty values in minx/maxx
empties=[find(cellfun('isempty',minx)) find(cellfun('isempty',maxx))];
if ~isempty(empties)
    eff(empties)=[];
    minx(empties)=[];
    maxx(empties)=[];
end

% Find optimal efficiency/time tradeoff
brlevel=(yrange(2)-yrange(1))/1000; % Breaklevel 1/1000 of total x-range
for lno=1:numel(eff)   
    
    xmin=minx{lno}; xmax=maxx{lno}; % Initial values for range

    for p=1:10
        xv=linspace(xmin,xmax,10);
        yv=getcont(eff(lno),xv,ecoeff,etype);
        zv=getz(xv,yv,tcoeff,ttype);
        [zv,ind]=sort(zv); 
        if numel(ind)>3 
            ind(4:end)=[]; 
        end
        xv=xv(ind); 

        xmin=min(xv);
        xmax=max(xv);
        
        % Break if xrange<1/1000 of total range
        if (xmax-xmin)<brlevel 
            break
        end
    end

    xval(lno)=xv(1);
    yval(lno)=yv(1);
    zval(lno)=zv(1);

end
%disp('---- end findopt ----')



% ---------- getcont ---------
function gradv=getcont(clev,uv,coeff,modtype)
% returns gradients for peak width model as function o
% clev = contour level
% uv = velocity vector
% coeff = model coefficients
% modtype = model type
% gradv = gradient vector

%disp(['---- getcont: ' modtype '----'])

if numel(coeff)<7 coeff(numel(coeff)+1:7)=0; end

nr=numel(uv);
av=repmat(coeff(1),1,nr);
bv=repmat(coeff(2),1,nr);
cv=repmat(coeff(3),1,nr);
dv=repmat(coeff(4),1,nr);
ev=repmat(coeff(5),1,nr);
fv=repmat(coeff(6),1,nr);
gv=repmat(coeff(7),1,nr);
wv=repmat(clev,1,nr);

if strcmp(modtype,'VD+Int') && coeff(7)~=0
    kv=av+(bv./uv)+(cv.*uv)-wv;
    lv=dv+(ev./uv)+fv.*uv;
    gradv=(-lv+(sqrt((lv.^2)-4*gv.*kv)))./(2*gv);
end

if strcmp(modtype,'VD+Int') && coeff(7)==0
    gradv=(-av+wv-(bv./uv)-(cv.*uv)) ./ (dv+(ev./uv)+(fv.*uv)); 
end

if strcmp(modtype,'Quad+Int') 
    kv=av-wv+(bv.*uv)+(ev.*(uv.^2));
    lv=cv+(dv.*uv);
    gradv=(-lv+(sqrt((lv.^2)-4*fv.*kv)))./(2*fv);
end

%disp(['---- end getcont: ' modtype '----'])


% ------------------- getz ---------------------
function zval=getz(xval,yval,coeff,modeltype)
%disp('---- getz ----')

zval=[];
if strcmp(modeltype,'VD+Int')
    zval=coeff(1) + coeff(2)./xval + coeff(3).*xval + coeff(4).*yval + coeff(5).*yval./xval + coeff(6).*xval.*yval + coeff(7).*yval.^2;
end
if strcmp(modeltype,'Quad+Int')
    zval=coeff(1) + coeff(2).*xval + coeff(3)*yval + coeff(4).*xval.*yval + coeff(5).*xval.^2 + coeff(6).*yval.^2;
end    
if strcmp(modeltype,'Log+Int')
    xval=log(xval); yval=log(yval);
    zval=coeff(1) + coeff(2).*xval + coeff(3)*yval + coeff(4).*xval.*yval;
    zval=exp(zval);
end 

% ------------------- optvel ---------------------
function uv=optvel(coeff,iv,modeltype)
% function that returns optimal velocity (minimum in van Deemter curves)
% for any gradient.
% iv is vector of gradients
% uv is vector of optimal velocities
% coeff is coefficients
% modeltype is 'VD+Int' or 'Quad+Int'

if strcmp(modeltype,'VD+Int')
    b=coeff(2); c=coeff(3); e=coeff(5); f=coeff(6);
    uv=((b+e*iv)./(c+f*iv)).^0.5;      
end

if strcmp(modeltype,'Quad+Int')
    b=coeff(2); d=coeff(4); e=coeff(5); 
    uv=(-b-(d.*iv))/(2*e); % Vector of optimal velocity 
end


% ------------------- calcsurf ---------------------
function [X_cont,Y_cont,Z_cont]=calcsurf(Model)

[setscale,xl,yl]=readsetscale;

modeltype=strmatch(Model.modeltype,{'Quad+Int','Log+Int','VD+Int'});

coeff=Model.meanparam';

if setscale   
    xl=Model.velocityrange;
    yl=Model.interactrange;
    xo=(xl(2)-xl(1))/10; xl(1)=xl(1)-xo; xl(2)=xl(2)+xo;
    yo=(yl(2)-yl(1))/10; yl(1)=yl(1)-yo; yl(2)=yl(2)+yo;      
end

res_x=100; res_y=100; %resolution of x and y

inc_x=(xl(2)-xl(1))/res_x;
inc_y=(yl(2)-yl(1))/res_y;

xs=xl(1):inc_x:xl(2);
le_x=length(xs);
ys=yl(1):inc_y:yl(2);
le_y=length(ys);

% Calculates X and Y matrix
for xc=1:le_x
    for yc=1:le_y     
        X_cont(xc,yc)=xs(xc);  
        Y_cont(xc,yc)=ys(yc);                  
    end   
end

% Calculates Z-matrix
if modeltype==2 xs=log(xs); ys=log(ys); end % take ln of all values if ln-model of time
for xc=1:le_x
    for yc=1:le_y
        if modeltype==1 % Quad+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc) xs(xc)^2 ys(yc)^2]; 
        end
        if modeltype==2 % Log+Int
            D=[1 xs(xc) ys(yc) xs(xc)*ys(yc)]; 
        end
        if modeltype==3 % VD+Int
            D=[1 1/xs(xc) xs(xc) ys(yc) ys(yc)/xs(xc) xs(xc)*ys(yc) ys(yc)^2];           
        end 
        z_val=[D*coeff];
        Z_cont(xc,yc)=z_val;     
    end   
end

if modeltype==2
    Z_cont=exp(Z_cont);
end

setlims(xl,yl)


% ------------------- topcont ---------------------
function topcont(X_cont,Y_cont,Z_cont,contlevels)

%disp('---- topcont ----')

v=contlevels; 
try
    [C,h] = contour(X_cont,Y_cont,Z_cont,v,'LineStyle','-','Color',[1 1 1],'LineWidth',2);
catch
    [C,h] = contour(X_cont,Y_cont,Z_cont,v);
    set(h,'LineStyle','-','EdgeColor',[1 1 1],'LineWidth',2)
end

%zz_copyfigure


% ------------------- fillcont ---------------------
function fillcont(X_cont,Y_cont,Z_cont)
global Pos Metset

min_z=min(min(Z_cont)); 
max_z=max(max(Z_cont));
if strcmp(Metset.contour_levelset,'Set levels') 
    nlevels=Metset.contour_nlevels; if nlevels<2; nlevels=2; end
    avgspace=(max_z-min_z)/nlevels; avgspace=str2double(num2str(avgspace,1)); % avgspace skal ha et signifikant siffer
else
    avgspace=Metset.contour_spacing; % To be edited
end

lower=-[0:avgspace:-min_z+avgspace]; higher=[0:avgspace:max_z+avgspace]; lh=unique([lower higher]);
ind=lh>min_z-avgspace & lh<max_z+avgspace; % finds matching indices
v=lh(ind); % creates v  

% Use userset levels
oldv=v;
AutoIsoCheck=findobj(gcf,'Tag','AutoIsoCheck');
IsoEdit=findobj(gcf,'Tag','IsoEdit');
if ~get(AutoIsoCheck,'Value')
    isosp=str2double(get(IsoEdit,'String'));
    minv=min(v);
    maxv=max(v);
    v=minv:isosp:maxv;
    f=1/isosp;
    v=v*f;
    v=floor(v);
    v=v/f;
    if numel(v)>100
        set(AutoIsoCheck,'Value',1);  v=oldv;
        zz_message(1,'Too many contour levels - Iso distance set to auto','-r')
    end
    if numel(v)<5
        set(AutoIsoCheck,'Value',1);  v=oldv;
        zz_message(1,'Too few contour levels - Iso distance set to auto','-r')
    end
end
if get(AutoIsoCheck,'Value') 
    % userdefined
    set(IsoEdit,'String',num2str(avgspace))   
end

if Metset.contour_isolines linestr='-'; else linestr='none'; end

% Plotting
ppos=Pos.leftplot; ppos(2)=Pos.yg(10)+Pos.gh*0.4;
ph=findobj(gcf,'Position',ppos,'Type','axes'); delete(ph) % deletes old plot
subplot('Position',ppos)
if numel(v)>2 && numel(v)<200
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v,'LineStyle',linestr); % New matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont,v);
        set(h,'LineStyle',linestr)
    end
else
    try
        [C,h] = contourf(X_cont,Y_cont,Z_cont,'LineStyle',linestr); % New matlab versions
    catch
        [C,h] = contourf(X_cont,Y_cont,Z_cont);
        set(h,'LineStyle',linestr)
    end
end

if get(findobj(gcf,'Tag','ContLabCheck'),'Value') clabel(C,h); end

%if Metset.contour_labels clabel(C,h); end
%set(h,'ButtonDownFcn','oo_model_vd(9.1)','Tag','Contourplot');

% Centers clim if colormap is hotcold
if Metset.contour_centercol
    cm=[min(v) max(v)];
    set(gca,'Clim',[-max(abs(cm)) max(abs(cm))]);
end
if Metset.contour_colorlimits && (Metset.contour_colormin~=Metset.contour_colormax)
    cm=sort([Metset.contour_colormin Metset.contour_colormax]); 
    set(gca,'Clim',cm);
end

% set colormap (temporarily changes method map)
methodmap=Metset.contour_colormap;
CMapPop=findobj(gcf,'Tag','CMapPop');
str=get(CMapPop,'String');
cmap=str{get(CMapPop,'Value')};
Metset.contour_colormap=cmap;
set(gcf,'Colormap',oo_getcmap);
Metset.contour_colormap=methodmap;

%zz_copyfigure


% ----------------- MEANPARAM -----------------
function meanparam
global EMod TMod

% ---- EMod ----
for x=1:numel(EMod)
    nmod=numel(EMod(x).param);
    npar=numel(EMod(x).parnames);
    P=NaN(nmod,npar);
    for modno=1:nmod
        P(modno,:)=EMod(x).param{modno}';
    end
    P=P(EMod(x).active,:);
    EMod(x).meanparam=mean(P,1);        
end

% ---- TMod ----
for x=1:numel(TMod)
    nmod=numel(TMod(x).param);
    npar=numel(TMod(x).parnames);
    TMod(x).meanparam=TMod(x).param{TMod(x).active}';
end


% ----------------- GETMODELS -----------------
function [EMod,TMod]=getmodels
global Models Experimental 

EMod=[]; TMod=[];

neffmod=0; 
for x=1:numel(Models)
    
    if isfield(Models,'wbl_ri_exp') && ~isempty(Models(x).wbl_ri_exp)
        neffmod=neffmod+1;
        EMod(neffmod).parameter='wbl_ri_exp';
        EMod(neffmod).modeltype=Models(x).modeltype;
        
        nval=0; design=[]; alldp=[];
        for modno=1:numel(Models(x).wbl_ri_exp)
            if ~isempty(Models(x).wbl_ri_exp{modno}) && sum(isnan(Models(x).wbl_ri_exp{modno}))==0
                nval=nval+1;
                EMod(neffmod).param{nval}=Models(x).wbl_ri_exp{modno};
                EMod(neffmod).design{nval}=Models(x).wbl_ri_exp_design{modno};
                EMod(neffmod).predmeas{nval}=Models(x).wbl_ri_exp_predmeas{modno}; 
                EMod(neffmod).df{nval}=Models(x).wbl_ri_exp_df{modno}; 
                EMod(neffmod).code{nval}=Experimental.codes{modno};
                EMod(neffmod).names{nval}=Experimental.names{modno};
                EMod(neffmod).shortnames{nval}=Experimental.shortnames{modno};
                alldp=[alldp Models(x).wbl_ri_exp_design{modno}];
            end     
        end
        EMod(neffmod).velocityvar=Models(x).velocityvar;
        EMod(neffmod).velocityrange=[min(alldp(1,:)) max(alldp(1,:))];
        EMod(neffmod).interactvar=Models(x).interactvar;
        EMod(neffmod).interactrange=[min(alldp(2,:)) max(alldp(2,:))];
        EMod(neffmod).parnames=Models(x).parnames;         
        EMod(neffmod).active=repmat(true,1,numel(EMod(neffmod).param)); % Select all
    end    
end

nrtmod=0;
for x=1:numel(Models)
    
    if isfield(Models,'rt_exp') && ~isempty(Models(x).rt_exp)
        nrtmod=nrtmod+1;
        TMod(nrtmod).parameter='rt_exp';
        TMod(nrtmod).modeltype=Models(x).modeltype;
        
        nval=0; design=[]; alldp=[];
        for modno=1:numel(Models(x).rt_exp)
            if ~isempty(Models(x).rt_exp{modno}) && sum(isnan(Models(x).rt_exp{modno}))==0
                nval=nval+1;
                TMod(nrtmod).param{nval}=Models(x).rt_exp{modno};
                TMod(nrtmod).design{nval}=Models(x).rt_exp_design{modno};
                TMod(nrtmod).predmeas{nval}=Models(x).rt_exp_predmeas{modno};
                TMod(nrtmod).df{nval}=Models(x).rt_exp_df{modno}; 
                TMod(nrtmod).code{nval}=Experimental.codes{modno};
                TMod(nrtmod).names{nval}=Experimental.names{modno};
                TMod(nrtmod).shortnames{nval}=Experimental.shortnames{modno};
                alldp=[alldp Models(x).rt_exp_design{modno}]; 
            end   
        end
        TMod(nrtmod).velocityvar=Models(x).velocityvar;       
        TMod(nrtmod).velocityrange=[min(alldp(1,:)) max(alldp(1,:))];
        TMod(nrtmod).interactvar=Models(x).interactvar;
        TMod(nrtmod).interactrange=[min(alldp(2,:)) max(alldp(2,:))];
        TMod(nrtmod).parnames=Models(x).parnames; 
        TMod(nrtmod).active(numel(TMod(nrtmod).param))=true; % Select last
    end    
end



% ----------------- SETPOPS -----------------
function setpops
global EMod TMod

EModPop=findobj(gcf,'Tag','EModPop');
if ~isempty(EMod)
    for x=1:numel(EMod)
        pstr='';
        if strcmp(EMod(x).parameter,'wbl_ri_exp') pstr='Wb, RI units'; end
        estr{x}=[EMod(x).modeltype ' (' pstr ')'];
    end
    set(EModPop,'String',estr,'Enable','on')
end

TModPop=findobj(gcf,'Tag','TModPop');
if ~isempty(TMod)
    for x=1:numel(TMod)
        pstr='';
        if strcmp(TMod(x).parameter,'rt_exp') pstr='Ret. time'; end
        estr{x}=[TMod(x).modeltype ' (' pstr ')'];
    end
    set(TModPop,'String',estr,'Enable','on')
end

% ----------------- TMODLIST -----------------
function tmodlist
global TMod Pos

% Select model to display
TModPop=findobj(gcf,'Tag','TModPop');
modno=get(TModPop,'Value');

T.Data=[];
T.TableName='TModTable';
T.Position=[Pos.xg(6) Pos.yg(3) Pos.gw*4.5 Pos.gh*9];

if ~isempty(TMod)
    
    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
    rstr=get(CodeRadio,'String');
    switch rstr
        case 'Code'
            rnam=TMod(modno).code;
        case 'Name'
            rnam=TMod(modno).names;
        case 'Short name'
            rnam=TMod(modno).shortnames;
    end    
    
    for x=1:numel(TMod(modno).param)
        T.Data{x,1}=TMod(modno).active(x); 
        param=TMod(modno).param{x};
        T.RowName{x}=rnam{x};
        for y=1:numel(param) T.Data{x,y+1}=param(y); end        
    end
    for x=1:numel(TMod(modno).parnames) T.ColumnName{x+1}=TMod(modno).parnames{x}; end      
    [m,n]=size(T.Data);
    for x=2:n
        T.ColumnFormat{x}=deal(4); 
        T.ColumnWidth{x}=deal(80);
    end
    T.ColumnEditable=[1 zeros(1,n-1)];
end
T.AllowEmpty=0;
T.AllowNan=0;
T.ColumnFormat{1}='excl_binary';
T.ColumnName{1}='Sel';
T.ColumnWidth{1}=50;
T.ViewPref=1;
T.CellEditCallback='oo_model_vda(3.2)';
T.ListSelCol=1;

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

% ----------------- EVAL_TMODLIST -----------------
function eval_tmodlist
global TMod

TModPop=findobj(gcf,'Tag','TModPop');
modno=get(TModPop,'Value');

TMod(modno).active=cell2mat(zz_tabletool('getcol','TModTable',1))';


% ----------------- EMODLIST -----------------
function emodlist
global EMod Pos

% Select model to display
EModPop=findobj(gcf,'Tag','EModPop');
modno=get(EModPop,'Value');

T.Data=[];
T.TableName='EModTable';
T.Position=[Pos.xg(6) Pos.yg(14) Pos.gw*4.5 Pos.gh*9];

if ~isempty(EMod)
    
    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1);
    rstr=get(CodeRadio,'String');
    switch rstr
        case 'Code'
            rnam=EMod(modno).code;
        case 'Name'
            rnam=EMod(modno).names;
        case 'Short name'
            rnam=EMod(modno).shortnames;
    end
    
    for x=1:numel(EMod(modno).param)
        T.Data{x,1}=EMod(modno).active(x);
        param=EMod(modno).param{x};
        T.RowName{x}=rnam{x};
        for y=1:numel(param) T.Data{x,y+1}=param(y); end        
    end
    for x=1:numel(EMod(modno).parnames) T.ColumnName{x+1}=EMod(modno).parnames{x}; end      
    [m,n]=size(T.Data);
    for x=2:n
        T.ColumnFormat{x}=deal(4); 
        T.ColumnWidth{x}=deal(80);
    end
    T.ColumnEditable=[1 zeros(1,n-1)];
end
T.AllowEmpty=0;
T.AllowNan=0;
T.ColumnFormat{1}='binary';
T.ColumnName{1}='Sel';
T.ColumnWidth{1}=50;
T.ViewPref=1;
T.CellEditCallback='oo_model_vda(3.1)';
T.ListSelCol=1;

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);
    

% ----------------- EVAL_EMODLIST -----------------
function eval_emodlist
global EMod

EModPop=findobj(gcf,'Tag','EModPop');
modno=get(EModPop,'Value');

EMod(modno).active=cell2mat(zz_tabletool('getcol','EModTable',1))';


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors Metset

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; 
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
x=Pos.xg; y=Pos.yg;

winpar{1}='ModelsVdaWin'; winpar{2}='Chrombox Optimizer: VD models';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_model_vda(99)',3,'','');

% Models list
voff=gh*0.1;
p=p+1;[ui{p,1:8}] = deal('Efficiency models:','Text',Colors.bc,[x(6) y(23) gw eh],'',3,'','');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(9) y(23) gw*1.5 eh],'oo_model_vda(1.1)',2,'EModPop','-d');
p=p+1;[ui{p,1:8}] = deal('Homolog RI dist:','Text',Colors.bc,[x(7)+gw/4 y(23)-voff bw+gw/4 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('100','Edit',[1 1 1],[x(8)+gw/2 y(23)+voff gw*0.3 eh],'oo_model_vda(5.15)',2,'HomDistEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Time models:','Text',Colors.bc,[x(6) y(12) gw eh],'',3,'','');
p=p+1;[ui{p,1:8}] = deal('Add constant:','Text',Colors.bc,[x(7)+gw/4 y(12)-voff bw+gw/4 eh],'',2,'','-r');
p=p+1;[ui{p,1:8}] = deal('0','Edit',[1 1 1],[x(8)+gw/2 y(12)+voff gw*0.3 eh],'oo_model_vda(5.1)',2,'TimeConstEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(9) y(12) gw*1.5 eh],'oo_model_vda(1.2)',2,'TModPop','-d');

% RateRange
% Pos.xg(1) Pos.yg(3) Pos.gw*2.8 Pos.gh*6.5
hp=x(2); vp=y(1)+gh*0.5;
p=p+1;[ui{p,1:8}] = deal('Rates (low, step, high):','Text',Colors.bc,[hp+gw*0.4 y(2)+gh*0.2 gw*2 eh],'',2,'RateText',' -fh');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.4 vp gw*0.4 eh],'oo_model_vda(5.0)',2,'RateLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.9 vp gw*0.4 eh],'oo_model_vda(5.0)',2,'RateStepEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*1.4 vp gw*0.4 eh],'oo_model_vda(5.0)',2,'RateHighEdit','-c -fh -d');

% PlotType
p=p+1;[ui{p,1:8}] = deal({'Surface','Errors','Pred. vs. meas.'},'PopupMenu',[1 1 1],[hp+gw*0.4 y(1)+gh*0.5 gw*1.5 eh],'oo_model_vda(5.0)',2,'PlotTypePop','-nvis -fh');

% Functions frame
hp=x(4); vp=y(1);
p=p+1;[ui{p,1:8}] = deal('','Frame',Colors.bc,[hp vp bw*2 gh*8.0],'',2,'','');

p=p+1;[ui{p,1:8}] = deal('Plot:','Text',Colors.bc,[hp+gw*0.05 vp+gh*6+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal({'Opt Vel','PPC/time (one)','PPC/time (ind)'},'PopupMenu',[1 1 1],[hp+gw*0.8 vp+gh*7 gw*0.95 eh],'oo_model_vda(5.0)',2,'ModTypePop','-fh');

p=p+1;[ui{p,1:8}] = deal('X-scale:','Text',Colors.bc,[hp+gw*0.05 vp+gh*5+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.8 vp+gh*6 gw*0.4 eh],'oo_model_vda(5.0)',2,'XScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.8+gw*0.5 vp+gh*6 gw*0.4 eh],'oo_model_vda(5.0)',2,'XScaleHighEdit','-c -fh -d');

p=p+1;[ui{p,1:8}] = deal('Y-scale:','Text',Colors.bc,[hp+gw*0.05 vp+gh*4+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.8 vp+gh*5 gw*0.4 eh],'oo_model_vda(5.0)',2,'YScaleLowEdit','-c -fh -d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[hp+gw*0.8+gw*0.5 vp+gh*5 gw*0.4 eh],'oo_model_vda(5.0)',2,'YScaleHighEdit','-c -fh -d');

cmaps={'jet','hsv','hot','cool','spring','summer','autumn','winter','gray','bone','copper','pink','hotcold','traffic','white'};
p=p+1;[ui{p,1:8}] = deal('Color map','Text',Colors.bc,[hp+gw*0.05 vp+gh*3+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal(cmaps,'PopupMenu',[1 1 1],[hp+gw*0.8 vp+gh*4 gw*0.95 eh],'oo_model_vda(5.0)',2,'CMapPop','-fh');

p=p+1;[ui{p,1:8}] = deal('Iso dist:','Text',Colors.bc,[hp+gw*0.05 vp+gh*2+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('1','Edit',[1 1 1],[hp+gw*0.8 vp+gh*3 gw*0.4 eh],'oo_model_vda(5.3)',2,'IsoEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','Checkbox',Colors.bc,[hp+gw*1.25 vp+gh*3 gw*0.5 eh],'oo_model_vda(5)',2,'AutoIsoCheck','-c -fh');

p=p+1;[ui{p,1:8}] = deal('Wb iso dist:','Text',Colors.bc,[hp+gw*0.05 vp+gh+eh gw*0.7 eh],'',2,'','-r -fvp -fh');
p=p+1;[ui{p,1:8}] = deal('1','Edit',[1 1 1],[hp+gw*0.8 vp+gh*2 gw*0.4 eh],'oo_model_vda(5.4)',2,'WbIsoEdit','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Auto','Checkbox',Colors.bc,[hp+gw*1.25 vp+gh*2 gw*0.5 eh],'oo_model_vda(5)',2,'AutoWbIsoCheck','-c -fh');

p=p+1;[ui{p,1:8}] = deal('Contour labels','Checkbox',Colors.bc,[hp+gw*0.05 vp+gh gw eh],'oo_model_vda(5)',2,'ContLabCheck','-c -fh');
p=p+1;[ui{p,1:8}] = deal('Wb labels','Checkbox',Colors.bc,[hp+gw*0.05 vp+gh*0.1 gw eh],'oo_model_vda(5)',2,'WbLabCheck','-c -fh');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(6) y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(6)+gw/2 y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(7) y(2) bw eh],'oo_model_vda(2.1)',2,'CodeRadio');

updfcn='oo_model_vda(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_model_vda(96)')
set(h0,'CloseRequestFcn','oo_model_vda(99)')

CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)

cval=strmatch(Metset.contour_colormap,cmaps,'exact'); 
if numel(cval)==1 && ~isnan(cval) set(findobj(gcf,'Tag','CMapPop'),'Value',cval); end

set(findobj(gcf,'Tag','ContLabCheck'),'Value',Metset.contour_labels)
set(findobj(gcf,'Tag','WbLabCheck'),'Value',1)

