function oo_patternopt(call)
% function oo_patternopt(call)
% ver 150626 SAM
% global Metset Experimental Locset Modset Models

global Metset Locset Patdata Patset Pattern
%global status

if nargin<1 call=0; end

if Locset.tracker==1 disp(['--- oo_patternopt ---' num2str(call)]); end

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0;  
    Patdata=[]; 
    Patset.codetype=1;
    openwin
    getmodels
    getsettings
    modelslist
    varlist
end

% Select table / Chrom
if call==2
    set(findobj(gcf,'Tag','TabPlotRadio'),'Value',0);
    set(gcbo,'Value',1)
    if strcmp(get(gcbo,'String'),'Table') modelslist;  end
    if strcmp(get(gcbo,'String'),'Chrom.') plotprof; proftable; end   
    if strcmp(get(gcbo,'String'),'Surf.') surfplot; end   
end
% logcheck
if call==2.1
    if strcmpi(get(findobj(gcf,'Tag','TabPlotRadio','Value',1),'String'),'Surf.')
        surfplot
    end
end

% Change parameter
if call==3.3
    listupdate
end

% Adjust parameters
if call>4 && call<4.4
    sval=get(gcbo,'Value');
    slidno=int8((call-4)*10);
    minmax=zz_tabletool('getdata','VarTable');
    minv=minmax{slidno,1}; maxv=minmax{slidno,2};
    val=minv+(maxv-minv)*sval;
    set(findobj(gcf,'Tag',['ParamEdit' num2str(slidno)]),'String',num2str(val,4)) 
    Patset.sliderval(slidno)=sval;
    Patset.paramval(slidno)=val;
end
if call>4.4 && call<4.9
    minmax=zz_tabletool('getdata','VarTable');
    edno=int8((call-4.4)*10);
    minv=minmax{edno,1}; maxv=minmax{edno,2};    
    str=get(gcbo,'String'); val=str2double(str);
    if isnan(val) val=Patset.paramval(edno); set(gcbo,'String',num2str(val)); end
    if val>maxv val=maxv; end
    if val<minv val=minv; end    
    sval=(val-minv)/(maxv-minv);    
    set(findobj(gcf,'Tag',['Slider' num2str(edno)]),'Value',sval)    
    set(gcbo,'String',num2str(val,4))    
    Patset.sliderval(edno)=sval;
    Patset.paramval(edno)=val;    
end

% Evaluate tables
% models list
if call==5.1
    evalmodlist
end
% Variables list
if call==5.2
    celldata=zz_tabletool('getlastcell','VarTable');
    varno=celldata.rowindex;
    minmax=zz_tabletool('getdata','VarTable');
    minv=minmax{varno,1}; maxv=minmax{varno,2};  
    ParamEdit=findobj(gcf,'Tag',['ParamEdit' num2str(varno)]);
    currentval=str2double(get(ParamEdit,'String'));
    if currentval<minv currentval=minv; end
    if currentval>maxv currentval=maxv; end
    set(ParamEdit,'String',num2str(currentval,4));
    sval=(currentval-minv)/(maxv-minv);
    set(findobj(gcf,'Tag',['Slider' num2str(varno)]),'Value',sval)  
end
    
% Codes/names
if call==7.1
    set(findobj(gcf,'Tag','CodeRadio'),'Value',0); set(gcbo,'Value',1);    
    str=get(findobj(gcf,'Tag','CodeRadio','Value',1),'String');
    switch str
        case 'Code'
            Patset.codetype=1;
        case 'Name'
            Patset.codetype=2;
        case 'Short name'
            Patset.codetype=3;
    end

    str=get(findobj(gcf,'Tag','TabPlotRadio','Value',1),'String');
    switch str
        case 'Table'
            listupdate
        case 'Chrom.'
            plotprof; proftable
    end
end

% load model
if call==8.2
    %disp('--- load model ---')
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    str=get(SavedModelsPop,'String'); val=get(SavedModelsPop,'Value');
    filename=str{val};
    pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_' filename '.mat'];
    
    S=load(pathname);
    if isfield(S.Models,'rt_exp') || isfield(S.Models,'ri_exp')
        Patdata=[];
        if isfield(S,'Info') && isfield(S.Info,'modeltype')
            Patdata.modeltype=S.Info.modeltype;
        else
            Patdata.modeltype='2D';
        end

        Patdata.codes=S.Experimental.codes;
        Patdata.names=S.Experimental.names;
        Patdata.shortnames=S.Experimental.shortnames;
        if isfield(S.Models,'ri_exp')
            Patdata.ri_mod=S.Models.ri_exp;
        end
        if isfield(S.Models,'rt_exp')
            Patdata.rt_mod=S.Models.rt_exp;
        end
        Patdata.parnames=S.Models.parnames;
        Patdata.design=S.Experimental.parameters(:,~isnan(sum(S.Experimental.parameters)));
        
        Patdata.varnames=S.Experimental.paramnames{1};
               
        [m,n]=size(S.Experimental.area_exp);
        for x=1:m
            v=S.Experimental.area_exp(x,:);
            Patdata.size(x)=mean(v(~isnan(v)));
        end
        Patdata.normsize=Patdata.size/max(Patdata.size);
        Patdata.analyte=ones(m,1);
        Patdata.activecmp=ones(m,1);  
        Patdata.weight=ones(m,1);  
        
        ParametersPop=findobj(gcf,'Tag','ParametersPop');
        str=[]; 
        if isfield(Patdata,'ri_mod') str{numel(str)+1}='Retention index (RI)'; end
        if isfield(Patdata,'rt_mod') str{numel(str)+1}='Retention time (RT)'; end
        
        if ~isempty(str)
            set(ParametersPop,'String',str,'Enable','on','Value',1)
        else
            set(ParametersPop,'String','No models','Enable','off','Value',1)
        end
        
        TabPlotRadio=findobj(gcf,'Tag','TabPlotRadio'); set(TabPlotRadio,'Value',0)
        TabPlotRadio=findobj(gcf,'Tag','TabPlotRadio','String','Table'); set(TabPlotRadio,'Value',1,'Enable','on')
        modelslist     
        varlist
        initsettings
        
        set(findobj(gcf,'Tag','SetNameEdit'),'String',zz_legalfname(filename),'Enable','on')
        set(findobj(gcf,'Tag','SaveSetButton'),'Enable','on')
            
    else
        zz_message(1,'No retention models found')
    end
    
end

% Save settings
if call==8.3
    Info.datatype='Patternopt settings';
    Info.savetime=now;
    Info.user=Locset.user;
    Info.codeversion=Locset.version;
    
    filename=zz_legalfname(get(findobj(gcf,'Tag','SetNameEdit'),'String'));
    pathname=zz_legalpath([ Locset.path_root filesep 'patternopt' filesep 'patset_' filename '.mat']);
    
    oo_savefile(pathname,Patdata,Patset,Pattern,Info)
    getsettings
end

% Load settings
if call==8.4
    SavedSettingsPop=findobj(gcf,'Tag','SavedSettingsPop');
    str=get(SavedSettingsPop,'String');
    val=get(SavedSettingsPop,'Value');
    filename=str{val};
    pathname=[ Locset.path_root filesep 'patternopt' filesep 'patset_' filename '.mat'];
    S=load(pathname);
    Patdata=S.Patdata;
    Patset=S.Patset;
    Pattern=S.Pattern;
        
    if ~isempty(Patdata)
        
        ParametersPop=findobj(gcf,'Tag','ParametersPop');
        str=[]; 
        if isfield(Patdata,'ri_mod') str{numel(str)+1}='Retention index (RI)'; end
        if isfield(Patdata,'rt_mod') str{numel(str)+1}='Retention time (RT)'; end
        
        if ~isempty(str)
            set(ParametersPop,'String',str,'Enable','on','Value',1)
        else
            set(ParametersPop,'String','No models','Enable','off','Value',1)
        end    
        
        set(findobj(gcf,'Tag','SetNameEdit'),'String',zz_legalfname(filename),'Enable','on')
        set(findobj(gcf,'Tag','SaveSetButton'),'Enable','on')
             
        set(findobj(gcf,'Tag','TabPlotRadio'),'Value',0)
        set(findobj(gcf,'Tag','TabPlotRadio','String','Table'),'Value',1,'Enable','on')
        modelslist     
        varlist          
    end
    if ~isempty(Pattern)
        set(findobj(gcf,'Tag','TabPlotRadio','String','Chrom.'),'Enable','on')
    end
    if isfield(Patdata,'surfx')
        set(findobj(gcf,'Tag','TabPlotRadio','String','Surf.'),'Enable','on')
        set(findobj(gcf,'Tag','LogSurfCheck'),'Enable','on')        
    end
    
    for x=1:numel(Patset.sliderval)
        set(findobj(gcf,'Tag',['Slider' num2str(x)]),'Value',Patset.sliderval(x))
        set(findobj(gcf,'Tag',['ParamEdit' num2str(x)]),'String',num2str(Patset.paramval(x)),'Enable','on')
    end    
    set(findobj(gcf,'Tag','PeakWidthEdit'),'String',num2str(Patset.peakwidth));
    set(findobj(gcf,'Tag','ResolutionEdit'),'String',num2str(Patset.resolution));
 
end


% Calc pattern
if call==10.1 
    varpar(1)=str2double(get(findobj(gcf,'Tag','ParamEdit1'),'String'));
    varpar(2)=str2double(get(findobj(gcf,'Tag','ParamEdit2'),'String'));
    Pattern=calcpattern(varpar);
    Pattern=calcprof(Pattern);
    plotprof; proftable
end

% Optimize
if call==11.1
    OptTypeRadio=findobj(gcf,'Tag','OptTypeRadio','Value',1);
    if strcmp(get(OptTypeRadio,'String'),'Overlap')
        optoverlap
    end
    if strcmp(get(OptTypeRadio,'String'),'Distance')
        optdist
    end
    surfplot
end
% Set opt type
if call==11.5
    OptTypeRadio=findobj(gcf,'Tag','OptTypeRadio');
    set(OptTypeRadio,'Value',0)
    set(gcbo,'Value',1)
end

% Set parameter from click in surface
if call==11.6
    vals=get(gcbo,'UserData');

    set(findobj(gcf,'Tag','ParamEdit1'),'String',num2str(vals(1),4))
    set(findobj(gcf,'Tag','ParamEdit2'),'String',num2str(vals(2),4))
    
    minmax=zz_tabletool('getdata','VarTable');
    frac1=(vals(1)-minmax{1,1}) / (minmax{1,2}-minmax{1,1});
    frac2=(vals(2)-minmax{2,1}) / (minmax{2,2}-minmax{2,1});    
    set(findobj(gcf,'Tag','Slider1'),'Value',frac1);
    set(findobj(gcf,'Tag','Slider2'),'Value',frac2);
    
    CurrentPointMarker=findobj(gca,'Tag','CurrentPointMarker');
    set(CurrentPointMarker,'XData',vals(1)); set(CurrentPointMarker,'YData',vals(2))
    
end

% Surface click
if call==12.1
    C=get(gca,'Currentpoint');
    xv=C(1,1); yv=C(1,2);
    
    CurrentPointMarker=findobj(gca,'Tag','CurrentPointMarker');
    set(CurrentPointMarker,'XData',xv); set(CurrentPointMarker,'YData',yv)

    set(findobj(gcf,'Tag','ParamEdit1'),'String',num2str(xv,4))
    set(findobj(gcf,'Tag','ParamEdit2'),'String',num2str(yv,4))    
    
    minmax=zz_tabletool('getdata','VarTable');
    frac1=(xv-minmax{1,1}) / (minmax{1,2}-minmax{1,1});
    frac2=(yv-minmax{2,1}) / (minmax{2,2}-minmax{2,1});    
    set(findobj(gcf,'Tag','Slider1'),'Value',frac1);
    set(findobj(gcf,'Tag','Slider2'),'Value',frac2);    
    
end


if call==15.1
    val=str2double(get(gcbo,'String'));
    if val>0
        Patset.peakwidth=val;
    else
        set(gcbo,'String',num2str(Patset.peakwidth))
    end
end
if call==15.2
    val=str2double(get(gcbo,'String'));
    if val>0
        Patset.resolution=val;
    else
        set(gcbo,'String',num2str(Patset.peakwidth))
    end
end
    



% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end
if call==99.1 % Exit
    %h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    %h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method '\' Metset.path_method '\met_' Metset.file_method '.mat'];
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_patternopt (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end


 
 
 
% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------ INITSETTINGS ------------
function initsettings
global Patset

T=zz_tabletool('getall','VarTable');
for x=1:T.n_rows    
    Patset.paramval(x)=(T.Data{x,1}+T.Data{x,2})/2;
    Patset.sliderval(x)=0.5;   
    set(findobj(gcf,'Tag',['Slider' num2str(x)]),'Value',0.5,'Enable','on'); 
    set(findobj(gcf,'Tag',['ParamEdit' num2str(x)]),'String',num2str(Patset.paramval(x)),'Enable','on');    
end

Patset.peakwidth=0.05;
set(findobj(gcf,'Tag','PeakWidthEdit'),'String',num2str(Patset.peakwidth));
Patset.resolution=1.5;
set(findobj(gcf,'Tag','ResolutionEdit'),'String',num2str(Patset.resolution));

% ------------ GETSETTINGS ------------
function getsettings
global Locset

str=[];
pnam=[Locset.path_root filesep 'patternopt'];
if isdir(pnam)
    D=dir([pnam filesep 'patset_*.mat']);
    if ~isempty(D)
        for x=1:numel(D)
            tstr=D(x).name;
            str{x}=tstr(8:end-4);
        end
    end
end
if ~isempty(str)
    set(findobj(gcf,'Tag','SavedSettingsPop'),'String',str,'Enable','on')
    set(findobj(gcf,'Tag','LoadSetButton'),'Enable','on')
end



% ------------ OPTDIST ------------
function optdist
global Patdata

minmax=zz_tabletool('getdata','VarTable');

MapResEdit=findobj(gcf,'Tag','MapResEdit');
mapres=str2double(get(MapResEdit,'String'));
if isnan(mapres)
    mapres=11; set(MapResEdit,'String',num2str(mapres));
end

p1=linspace(minmax{1,1},minmax{1,2},mapres);
p2=linspace(minmax{2,1},minmax{2,2},mapres);

t=0; % TEMP
for x=1:numel(p1)
    for y=1:numel(p2)
        varpar=[p1(x) p2(y)];
        Locpattern=calcpattern(varpar);
        %Locpattern=calcprof(Locpattern);       
        PM(y,x)=Locpattern.lowestdist;
        
        %t=t+1; % TEMP
        %tracker1(t,:)=[p1(x) p2(y)]; % TEMP
        %tracker2(t)=Locpattern.totpenal; % TEMP
        
        
    end
end

Patdata.surfx=p1;
Patdata.surfy=p2;
Patdata.surfz=PM;
Patdata.showmin=0;
Patdata.showmax=1;


% ------------ OPTOVERLAP ------------
function optoverlap
global Patdata 

minmax=zz_tabletool('getdata','VarTable');

MapResEdit=findobj(gcf,'Tag','MapResEdit');
mapres=str2double(get(MapResEdit,'String'));
if isnan(mapres)
    mapres=11; set(MapResEdit,'String',num2str(mapres));
end

p1=linspace(minmax{1,1},minmax{1,2},mapres);
p2=linspace(minmax{2,1},minmax{2,2},mapres);

bcol=get(gcf,'Color');
wbh2=waitbar(0,'Calculating','Color',bcol);
for x=1:numel(p1)
    for y=1:numel(p2)
        varpar=[p1(x) p2(y)];
        Locpattern=calcpattern(varpar);
        Locpattern=calcprof(Locpattern);       
        PM(y,x)=Locpattern.totpenal;
        
        %t=t+1; % TEMP
        %tracker1(t,:)=[p1(x) p2(y)]; % TEMP
        %tracker2(t)=Locpattern.totpenal; % TEMP
            
    end
    waitbar(x/numel(p1))
end
waitbar(1); close(wbh2)

Patdata.surfx=p1;
Patdata.surfy=p2;
Patdata.surfz=PM;
Patdata.showmin=1;
Patdata.showmax=0;

%[mv,ind]=min(tracker2) % TEMP
%tracker1(ind,:) % TEMP


% ---------- SURFPLOT ----------  
function surfplot
global Patdata Pos Patset

% Clear chromatogram
delete(findobj(gcf,'Tag','ProfPlot'))
hidezoomline
if zz_tabletool('Exist','PatternTable')==1
    zz_tabletool('Delete','PatternTable');
end

% clear table
if zz_tabletool('Exist','ModelsTable')==1
    zz_tabletool('Delete','ModelsTable');
end

vo=Pos.gh;
subplot('Position',[Pos.leftplot(1) Pos.leftplot(2)+vo 1-(Pos.leftplot(1)*2) Pos.leftplot(4)-vo])

p1=Patdata.surfx;
p2=Patdata.surfy;
PM=Patdata.surfz;

LogSurfCheck=findobj(gcf,'Tag','LogSurfCheck');
if get(LogSurfCheck,'Value')
    %PM=log10(PM);
    PM=PM.^0.5;
    PM(PM>0)=log10(PM(PM>0));
end

[C,h] = contourf(p1,p2,PM);
clabel(C,h)
set(h,'ButtonDownFcn','oo_patternopt(12.1)')


set(gcf,'Colormap',oo_getcmap);

if Patdata.showmax
    [mv,ind1]=max(max(PM));
    [mv,ind2]=max(max(PM'));   
end
if Patdata.showmin
    [mv,ind1]=min(min(PM));
    [mv,ind2]=min(min(PM'));    
end
if Patdata.showmin || Patdata.showmax
    
    hold on

    plot(p1(ind1),p2(ind2),'o','MarkerFaceColor',[1 0.5 0],'MarkerEdgeColor',[1 1 1],'MarkerSize',10,...
        'ButtonDownFcn','oo_patternopt(11.6)','LineWidth',2,'UserData',[p1(ind1) p2(ind2)]);
    if ind1<=numel(p1)/2
        halstr='left';
    else
        halstr='right';
    end
    if ind2<=numel(p2)/2
        valstr='bottom';
    else
        valstr='top';
    end
    text(p1(ind1),p2(ind2),['  ' num2str(p1(ind1)) '/' num2str(p2(ind2)) ' (' num2str(mv,4) ')  '],...
        'HorizontalAlignment',halstr,'VerticalAlignment',valstr,'FontSize',12,...
        'FontWeight','bold','Color',[1 1 1],'ButtonDownFcn','oo_patternopt(11.6)','UserData',[p1(ind1) p2(ind2)])
end

plot(Patset.paramval(1),Patset.paramval(2),'+','MarkerEdgeColor',[1 1 1],'MarkerSize',12,'LineWidth',2,'Tag','CurrentPointMarker')

set(findobj(gcf,'Tag','TabPlotRadio'),'Value',0)
set(findobj(gcf,'Tag','TabPlotRadio','String','Surf.'),'Value',1,'Enable','on')
set(findobj(gcf,'Tag','LogSurfCheck'),'Enable','on')

hold off

set(gca,'Tag','Surfplot')
zz_copyfigure


% ------------ PLOTPROF ------------
function plotprof
global Pos Pattern Patset

% Clear table
if zz_tabletool('Exist','ModelsTable')==1
    zz_tabletool('Delete','ModelsTable');
end

% Clear surface
delete(findobj(gcf,'Tag','Surfplot'))

vo=Pos.gh;
subplot('Position',[Pos.leftplot(1) Pos.leftplot(2)+vo 1-(Pos.leftplot(1)*2) Pos.leftplot(4)-vo])

if Patset.codetype==1 labels=Pattern.codes; end
if Patset.codetype==2 labels=Pattern.names; end
if Patset.codetype==3 labels=Pattern.shortnames; end

for x=1:numel(Pattern.calcpos)
    col=[0.5 0.5 0.5];
    if Pattern.analyte(x)
        col=[0 0.5 0];
    end
    if Pattern.interference(x)
        col=[1 0 0];
    end
    
    plot(Pattern.xscale,Pattern.prof(x,:),'Color',col)
    
    str1=''; if Pattern.penalties(x)>0 str1=num2str(Pattern.penalties(x),'%6.0f'); end
    str2=labels{x};
    text(Pattern.calcpos(x),max(Pattern.prof(x,:)),{str1,str2},'HorizontalAlignment','center','VerticalAlignment','bottom','Color',col,'Clipping','on')

    hold on
end
plot(Pattern.xscale,Pattern.sumprof,'Color',[0 0 0],'LineStyle',':')
hold off

if ~isfield(Pattern,'li') || isempty(Pattern.li)
    Pattern.li=1;
end
if ~isfield(Pattern,'ri') || isempty(Pattern.ri) || Pattern.ri>numel(Pattern.xscale)
    Pattern.ri=numel(Pattern.xscale);
end

str{1}=['Total Penalty: ' num2str(Pattern.totpenal,'%6.0f')];
str{2}=['Lowest dist.: ' num2str(Pattern.lowestdist,3)];
str{3}=['Peak width: ' num2str(Pattern.peakwidth)];
str{4}=['Resolution: ' num2str(Pattern.resolution)];
for x=1:numel(Pattern.varnames)
    str{4+x}=[Pattern.varnames{x} ': ' num2str(Pattern.varpar(x))];
end

text(0.98, 0.98, str,...
    'VerticalAlignment','top','HorizontalAlignment','right','FontSize',12,'Units','normalized')

TabPlotRadio=findobj(gcf,'Tag','TabPlotRadio'); set(TabPlotRadio,'Value',0)
TabPlotRadio=findobj(gcf,'Tag','TabPlotRadio','String','Chrom.'); set(TabPlotRadio,'Value',1,'Enable','on')

set(gca,'Tag','ProfPlot')
zz_copyfigure

showzoomline


% ------------------- proftable ---------------------
function proftable
global Pos Pattern

T.TableName='PatternTable';
T.Position=[Pos.xg(6) Pos.yg(2) 1-Pos.xg(6)-Pos.xg(1) Pos.gh*7+Pos.bh];

sizenorm=sum(Pattern.size)/100;

for x=1:numel(Pattern.calcpos)
    T.Data{x,1}=Pattern.codes{x};
    T.Data{x,2}=Pattern.names{x};
    T.Data{x,3}=Pattern.shortnames{x};
    T.Data{x,4}=Pattern.calcpos(x);
    T.Data{x,5}=Pattern.mindist(x);
    T.Data{x,6}=Pattern.penalties(x);    
    T.Data{x,7}=Pattern.size(x);   
    T.Data{x,8}=Pattern.size(x)/sizenorm;   
end

T.ColumnWidth=[50 50 50 50 50 50 50 50];
T.ColumnFormat={'str','str','str','%6.4f','%6.4f','%6.0f','%6.0f',4};
T.ColumnName={'Code','Name','Short','Pos','MinDist','Penalty','Size','Percent'};
T.RowName=[];

str{1}=[];
for x=1:numel(Pattern.varnames)
    str{1}=[str{1} Pattern.varnames{x} ': ' num2str(Pattern.varpar(x)), ', '];
end
str{1}=[str{1} 'Peak Width: ' num2str(Pattern.peakwidth) ', Resolution: ' num2str(Pattern.resolution)];

T.FooterText=str;

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ------------------- showzoomline ---------------------
function showzoomline

Plotcontrol=findobj(gcf,'Tag','Plotcontrol');
if isempty(Plotcontrol)
    oo_plot_scale(0)   
else
    set(findobj(gcf,'Tag','Plotcontrol'),'Visible','on')
    set(findobj(gcf,'Tag','CenterZoomBtn'),'Visible','on')
    set(findobj(gcf,'Tag','Plotslider'),'Visible','on')
    set(findobj(gcf,'Tag','Xscale_low_edit'),'Visible','on')
    set(findobj(gcf,'Tag','Xscale_high_edit'),'Visible','on')
    set(findobj(gcf,'Tag','XLockToggle'),'Visible','on')
    set(findobj(gcf,'Tag','Yscale_low_edit'),'Visible','on')
    set(findobj(gcf,'Tag','Yscale_high_edit'),'Visible','on')
    set(findobj(gcf,'Tag','Yscale_exp_edit'),'Visible','on')
    set(findobj(gcf,'Tag','YLockToggle'),'Visible','on')
    set(findobj(gcf,'Tag','ASToggle'),'Visible','on')
    set(findobj(gcf,'Tag','Zoomlineobj'),'Visible','on')
end
oo_plot_scale(100)
    
% ------------------- showzoomline ---------------------
function hidezoomline

Plotcontrol=findobj(gcf,'Tag','Plotcontrol');
if ~isempty(Plotcontrol)
    set(findobj(gcf,'Tag','Plotcontrol'),'Visible','off')
    set(findobj(gcf,'Tag','CenterZoomBtn'),'Visible','off')
    set(findobj(gcf,'Tag','Plotslider'),'Visible','off')
    set(findobj(gcf,'Tag','Xscale_low_edit'),'Visible','off')
    set(findobj(gcf,'Tag','Xscale_high_edit'),'Visible','off')
    set(findobj(gcf,'Tag','XLockToggle'),'Visible','off')
    set(findobj(gcf,'Tag','Yscale_low_edit'),'Visible','off')
    set(findobj(gcf,'Tag','Yscale_high_edit'),'Visible','off')
    set(findobj(gcf,'Tag','Yscale_exp_edit'),'Visible','off')
    set(findobj(gcf,'Tag','YLockToggle'),'Visible','off')
    set(findobj(gcf,'Tag','ASToggle'),'Visible','off')
    set(findobj(gcf,'Tag','Zoomlineobj'),'Visible','off')
end
    

% ------------------- calcprof ---------------------
function Locpattern=calcprof(Locpattern)
global Patset

%disp('---- calcprof ----')

peakwidth=Patset.peakwidth;
s=peakwidth/4;
minx=min(Locpattern.calcpos)-6*peakwidth;
maxx=max(Locpattern.calcpos)+6*peakwidth;
Locpattern.peakwidth=peakwidth;


Locpattern.xscale=minx:peakwidth/20:maxx;

for x=1:numel(Locpattern.calcpos)
    Locpattern.prof(x,:)=exp(-((Locpattern.xscale-Locpattern.calcpos(x)).^2)/( 2*s^2 )) * Locpattern.normsize(x);
end
Locpattern.sumprof=sum(Locpattern.prof);

resolution=Patset.resolution;
if isnan(resolution);
    resolution=1.5;
    set(ResolutionEdit,'String',num2str(resolution,2));
end
Locpattern.resolution=resolution;


interference=Locpattern.mindist<peakwidth*resolution;
Locpattern.interference=interference.*Locpattern.analyte;

penalties=zeros(1,numel(Locpattern.interference));
interfers=find(Locpattern.interference);

for x=1:numel(interfers)
  
    le=Locpattern.calcpos(interfers(x)) - peakwidth*(resolution*0.5);
    re=Locpattern.calcpos(interfers(x)) + peakwidth*(resolution*0.5);
    li=max(find(Locpattern.xscale<=le));
    ri=min(find(Locpattern.xscale>=re));

    xv=Locpattern.xscale(li:ri);
    yv=Locpattern.prof(interfers(x),li:ri);
    yv2=Locpattern.sumprof(li:ri);
    
    penalties(interfers(x)) = 1000*(1-(sum(yv)/sum(yv2)));
    
    %figure
    %plot(xv,[yv;yv2])

end

Locpattern.penalties=penalties;
Locpattern.totpenal=sum(penalties.*Locpattern.weight);






% ------------------- calcpattern ---------------------
function Locpattern=calcpattern(varpar)
global Patdata 

Locpattern=[]; Coeff=[];

wh=findobj('Tag','PatternsearchWin','Type','figure');
ParametersPop=findobj(wh,'Tag','ParametersPop');

if strcmpi(get(ParametersPop,'Enable'),'on')
    str=get(ParametersPop,'String');
    val=get(ParametersPop,'Value');
    str=str{val};
    
    if strcmp(str,'Retention index (RI)');
        Coeff=Patdata.ri_mod;
        Locpattern.response='ri';
    end
    if strcmp(str,'Retention time (RT)');
        Coeff=Patdata.rt_mod;
        Locpattern.response='rt';
    end    
end

%varpar(1)=str2double(get(findobj(gcf,'Tag','ParamEdit1'),'String'));
%varpar(2)=str2double(get(findobj(gcf,'Tag','ParamEdit2'),'String'));

nres=0; 

Locpattern.modeltype=Patdata.modeltype;
Locpattern.varnames=Patdata.varnames;
Locpattern.varpar=varpar;

for x=1:numel(Coeff)
    lc=Coeff{x};
    if ~isempty(lc) && sum(isnan(lc))==0 && Patdata.activecmp(x) 
        nres=nres+1;        
        Locpattern.calcpos(nres)=lc(1) + lc(2)*varpar(1) + lc(3)*varpar(2) + lc(4)*varpar(1)*varpar(2) + lc(5)*varpar(1)^2 + lc(6)*varpar(2)^2;
        Locpattern.codes{nres}=Patdata.codes{x};
        Locpattern.names{nres}=Patdata.names{x};
        Locpattern.shortnames{nres}=Patdata.shortnames{x};      
        Locpattern.size(nres)=Patdata.size(x);
        Locpattern.normsize(nres)=Patdata.normsize(x);
        Locpattern.analyte(nres)=Patdata.analyte(x);
        Locpattern.weight(nres)=Patdata.weight(x);
    end
end

for x=1:numel(Locpattern.calcpos)
    Locpattern.DM(x,:)=Locpattern.calcpos-Locpattern.calcpos(x);
    Locpattern.DM(x,x)=Inf;
end
Locpattern.DM=abs(Locpattern.DM);
Locpattern.mindist=min(Locpattern.DM);

Locpattern.lowestdist=min(Locpattern.mindist(Locpattern.analyte==1));


% ------------------- getmodels ---------------------
function getmodels
global Metset Locset
    
pathname=[Locset.path_models filesep Metset.path_models filesep 'mod_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        modnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedModelsPop=findobj(gcf,'Tag','SavedModelsPop');
    set(SavedModelsPop,'String',modnames)   
end


% ------------------- modelslist ---------------------
function modelslist
global Pos Patdata Patset

% Clear chromatogram
delete(findobj(gcf,'Tag','ProfPlot'))
hidezoomline
if zz_tabletool('Exist','PatternTable')==1
    zz_tabletool('Delete','PatternTable');
end


% Clear surface
delete(findobj(gcf,'Tag','Surfplot'))

T.TableName='ModelsTable';
T.Position=[Pos.leftplot(1) Pos.leftplot(2) 1-(Pos.leftplot(1)*2) Pos.leftplot(4)];

ParametersPop=findobj(gcf,'Tag','ParametersPop');
Coeff=[];
if strcmpi(get(ParametersPop,'Enable'),'on')
    str=get(ParametersPop,'String');
    val=get(ParametersPop,'Value');
    str=str{val};
    
    if strcmp(str,'Retention index (RI)');
        Coeff=Patdata.ri_mod;
    end
    if strcmp(str,'Retention time (RT)');
        Coeff=Patdata.rt_mod;
    end    
end

if ~isempty(Coeff) 
    n_comp=length(Patdata.codes);
    
    % Constructs T
    T.ColumnName{1}='Active';
    T.ColumnName{2}='Analyte';
    T.ColumnName{3}='Size';
    T.ColumnName{4}='Weight';
    [T.ColumnName{5:numel(Patdata.parnames)+4}]=deal(Patdata.parnames{:});
   
    T.Data=cell(numel(Patdata.codes),10); 
    
    for compno=1:n_comp
        if Patset.codetype==1 T.RowName{compno}=Patdata.codes{compno}; end
        if Patset.codetype==2 T.RowName{compno}=Patdata.names{compno}; end
        if Patset.codetype==3 T.RowName{compno}=Patdata.shortnames{compno}; end 
        T.Data{compno,1}=Patdata.activecmp(compno);
        T.Data{compno,2}=Patdata.analyte(compno);
        T.Data{compno,3}=Patdata.normsize(compno);
        T.Data{compno,4}=Patdata.weight(compno);
    end

    for cmpno=1:numel(Coeff)
        if ~cellfun('isempty',Coeff(cmpno))
            param=Coeff{cmpno}';
            for pno=1:numel(param) T.Data{cmpno,pno+4}=param(pno); end
        end
    end    
    
    for x=1:numel(Patdata.parnames) 
        T.ColumnFormat{x+3}=4; 
        T.ColumnWidth{x+3}=80;
    end
    T.AllowEmpty=1;
    T.AllowNan=1;
    T.ColumnFormat{1}='binary'; 
    T.ColumnWidth{1}=50;
    T.ColumnFormat{2}='binary'; 
    T.ColumnWidth{2}=50;
    T.ColumnFormat{3}=3; 
    T.ColumnWidth{3}=50;
    T.ColumnFormat{4}=3; 
    T.ColumnWidth{4}=50;
    T.ViewPref=1;
    T.CellEditCallback='oo_patternopt(5.1)';
    T.ListSelCol=1;
    T.ColumnEditable=[1 1 1 1 ones(1,numel(Patdata.parnames))];
else
    T.data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);


% ---------- EVALMODLIST ----------
function evalmodlist
global Patdata

val=zz_tabletool('getlastcell','ModelsTable');

if numel(val)>1
    Patdata.activecmp=cell2mat(zz_tabletool('getcol','ModelsTable',1));
end

if numel(val)==1 && val.colindex==1
    Patdata.activecmp(val.rowindex)=val.val; 
end
if numel(val)==1 && val.colindex==2
    Patdata.analyte(val.rowindex)=val.val; 
end
if numel(val)==1 && val.colindex==3
    Patdata.normsize(val.rowindex)=val.val; 
end
if numel(val)==1 && val.colindex==4
    Patdata.weigth(val.rowindex)=val.val; 
end
if numel(val)==1 && val.colindex>4 
    ParametersPop=findobj(gcf,'Tag','ParametersPop');
    str=get(ParametersPop,'String');
    str=str{get(ParametersPop,'Value')};
    if strcmp(str,'Retention index (RI)');
        Patdata.ri_mod{val.rowindex}(val.colindex-4)=val.val;        
    end
    if strcmp(str,'Retention time (RT)');
        Patdata.rt_mod{val.rowindex}(val.colindex-4)=val.val;
    end    
end
    

% ------------ VARLIST ------------
function varlist
global Patdata Pos

T.TableName='VarTable';
T.Position=[Pos.xg(1) Pos.yg(4) Pos.gw+Pos.bw Pos.gh*3];

% Reset sliders
for x=1:3
    h=findobj(gcf,'Tag',['ParamText' num2str(x)]); set(h,'String',['Param ' num2str(x)]);
    h=findobj(gcf,'Tag',['Slider' num2str(x)]); set(h,'Value',0.5,'Enable','off');
    h=findobj(gcf,'Tag',['ParamEdit' num2str(x)]); set(h,'String','-','Enable','off')
end

if isfield(Patdata,'design')
    [m,n]=size(Patdata.design);
    for x=1:m
        T.Data{x,1}=min(Patdata.design(x,:));
        T.Data{x,2}=max(Patdata.design(x,:));
        T.RowName{x}=Patdata.varnames{x};
        
        % Sliders/edits
        h=findobj(gcf,'Tag',['ParamText' num2str(x)]); set(h,'String',[Patdata.varnames{x} ':']);
        set(findobj(gcf,'Tag',['Slider' num2str(x)]),'Enable','on');        
        
        %Patset.paramval(x)=T.Data{x,1}*0.5+T.Data{x,2}*0.5;
        set(findobj(gcf,'Tag',['ParamEdit' num2str(x)]),'Enable','on');
    end

    T.ColumnName{1}='Min'; T.ColumnName{2}='Max'; 
    T.ColumnFormat{1}=4; T.ColumnFormat{2}=4;
    T.ColumnWidth{1}=80; T.ColumnWidth{2}=80;
    T.AllowEmpty=0;
    T.AllowNan=0;
    T.ViewPref=1;
    T.CellEditCallback='oo_patternopt(5.2)';
    T.ColumnEditable=[1 1];
else
    T.Data=[];
end

if zz_tabletool('Exist',T.TableName)==1
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);

% ------------ LISTUPDATE ------------
function listupdate
global Patset 

CodeRadio=findobj(gcf,'Tag','CodeRadio'); set(CodeRadio,'Value',0)
%ListTypeRadio=findobj(gcf,'Tag','ListTypeRadio'); set(ListTypeRadio,'Value',0)

%callertag=get(gcbo,'Tag');
%if strcmp(callertag,'CodeRadio')
%    codestr=get(gcbo,'String');
%    if strcmp(codestr,'Code')
%        Patset.codetype=1;
%    end
%    if strcmp(codestr,'Name')
%        Patset.codetype=2;
%    end    
%    if strcmp(codestr,'Short name')
%        Patset.codetype=3;
%    end        
%end

% set code types
if Patset.codetype==1;
    h=findobj(CodeRadio,'String','Code');
    set(h,'Value',1)
end
if Patset.codetype==2;
    h=findobj(CodeRadio,'String','Name');
    set(h,'Value',1)
end
if Patset.codetype==3;
    h=findobj(CodeRadio,'String','Short name');
    set(h,'Value',1)
end

modelslist








%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='PatternsearchWin'; winpar{2}='Chrombox Optimizer: Pattern search';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_patternopt(99)',3,'','');
%p=p+1;[ui{p,1:8}] = deal('Tempsave','Pushbutton',Colors.bc,[x(2) y(1) bw bh*1.5],'oo_maincall(89)',3,'','-bm');
%p=p+1;[ui{p,1:8}] = deal('Resume','Pushbutton',Colors.bc,[x(3) y(1) bw bh*1.5],'oo_maincall(88)',3,'','-bm');

% Parameterslist
p=p+1;[ui{p,1:7}] = deal('Response:','Text',Colors.bc,[x(1) y(9) gw+bw eh],'',2,'');
p=p+1;[ui{p,1:8}] = deal('No models','PopupMenu',[1 1 1],[x(1) y(5) gw+bw gh*4],'oo_patternopt(3.3)',2,'ParametersPop','-d');
p=p+1;[ui{p,1:7}] = deal('Varied:','Text',Colors.bc,[x(1) y(7) gw+bw eh],'',2,'');

% Radiobuttons
%p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[Pos.leftplot(1) Pos.leftplot(2) gw*4+bw Pos.leftplot(4)],'',2,'DataModelsList');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(2) y(1) bw eh],'oo_patternopt(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(2)+gw/2 y(1) bw eh],'oo_patternopt(7.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short name','RadioButton',Colors.bc,[x(3) y(1) bw eh],'oo_patternopt(7.1)',2,'CodeRadio');

vp=Pos.largeplot(2)-Pos.gh*0.8;
p=p+1;[ui{p,1:8}] = deal('Table','RadioButton',Colors.bc,[x(8) vp bw eh],'oo_patternopt(2)',2,'TabPlotRadio','-d');
p=p+1;[ui{p,1:8}] = deal('Chrom.','RadioButton',Colors.bc,[x(8)+gw*0.7 vp bw eh],'oo_patternopt(2)',2,'TabPlotRadio','-d');
p=p+1;[ui{p,1:8}] = deal('Surf.','RadioButton',Colors.bc,[x(8)+gw*1.4 vp bw eh],'oo_patternopt(2)',2,'TabPlotRadio','-d');
p=p+1;[ui{p,1:8}] = deal('Log','CheckBox',Colors.bc,[x(8)+gw*2.1 vp bw eh],'oo_patternopt(2.1)',2,'LogSurfCheck','-d');

%p=p+1;[ui{p,1:7}] = deal('Show data','Radiobutton',Colors.bc,[x(3) y(10) gw+bw eh],'oo_patternopt(7.1)',2,'ListTypeRadio');
%p=p+1;[ui{p,1:7}] = deal('Abs. models','Radiobutton',Colors.bc,[x(3)+gw*2/3 y(10) gw+bw eh],'oo_patternopt(7.1)',2,'ListTypeRadio');
%p=p+1;[ui{p,1:7}] = deal('Target mod.','Radiobutton',Colors.bc,[x(3)+gw*4/3 y(10) gw+bw eh],'oo_patternopt(7.1)',2,'ListTypeRadio');


% Sliders
p=p+1;[ui{p,1:8}] = deal('Param 1:','Text',Colors.bc,[x(3) y(9) bw eh],'',2,'ParamText1','-r');
p=p+1;[ui{p,1:8}] = deal('','Slider',1-((1-Colors.bc)*0.5),[x(4) y(9) gw*1.2 eh],'oo_patternopt(4.1)',2,'Slider1','-d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[x(4)+gw*1.25 y(9) gw*0.5 eh],'oo_patternopt(4.5)',2,'ParamEdit1','-d -r');
p=p+1;[ui{p,1:8}] = deal('Param 2:','Text',Colors.bc,[x(3) y(8) bw eh],'',2,'ParamText2','-r');
p=p+1;[ui{p,1:8}] = deal('','Slider',1-((1-Colors.bc)*0.5),[x(4) y(8) gw*1.2 eh],'oo_patternopt(4.2)',2,'Slider2','-d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[x(4)+gw*1.25 y(8) gw*0.5 eh],'oo_patternopt(4.6)',2,'ParamEdit2','-d -r');
p=p+1;[ui{p,1:8}] = deal('Param 3:','Text',Colors.bc,[x(3) y(7) bw eh],'',2,'ParamText3','-r');
p=p+1;[ui{p,1:8}] = deal('','Slider',1-((1-Colors.bc)*0.5),[x(4) y(7) gw*1.2 eh],'oo_patternopt(4.3)',2,'Slider3','-d');
p=p+1;[ui{p,1:8}] = deal('-','Edit',[1 1 1],[x(4)+gw*1.25 y(7) gw*0.5 eh],'oo_patternopt(4.7)',2,'ParamEdit3','-d -r');

% Peak width
p=p+1;[ui{p,1:8}] = deal('Peak width (4s):','Text',Colors.bc,[x(3) y(6) bw eh],'',2,'','-r');
p=p+1;[ui{p,1:8}] = deal('0.05','Edit',[1 1 1],[x(4) y(6) gw*0.5 eh],'oo_patternopt(15.1)',2,'PeakWidthEdit','-r');
p=p+1;[ui{p,1:8}] = deal('Resol.:','Text',Colors.bc,[x(4)+gw*0.6 y(6) gw*0.6 eh],'',2,'','-r');
p=p+1;[ui{p,1:8}] = deal('1.5','Edit',[1 1 1],[x(4)+gw*1.25 y(6) gw*0.5 eh],'oo_patternopt(15.2)',2,'ResolutionEdit','-r');

% Calculate
p=p+1;[ui{p,1:7}] = deal('Calc Patt.','Pushbutton',Colors.btn{1},[x(4) y(5) bw eh],'oo_patternopt(10.1)',2,'');
% Optimize
p=p+1;[ui{p,1:7}] = deal('Optimize','Pushbutton',Colors.btn{1},[x(4) y(4) bw eh],'oo_patternopt(11.1)',2,'');
p=p+1;[ui{p,1:8}] = deal('11','Edit',[1 1 1],[x(4)+gw*1.25 y(4) gw*0.5 eh],'',2,'MapResEdit','-r');
p=p+1;[ui{p,1:7}] = deal('Overlap','RadioButton',Colors.bc,[x(4) y(3) bw eh],'oo_patternopt(11.5)',2,'OptTypeRadio');
p=p+1;[ui{p,1:7}] = deal('Distance','RadioButton',Colors.bc,[x(4)+gw*0.7 y(3) bw eh],'oo_patternopt(11.5)',2,'OptTypeRadio');

% Load/Save settings
p=p+1;[ui{p,1:8}] = deal('Load Settings','Pushbutton',Colors.disk,[x(4)+gw/2 y(1) bw eh],'oo_patternopt(8.4)',2,'LoadSetButton','-d');
p=p+1;[ui{p,1:8}] = deal('-','PopupMenu',[1 1 1],[x(5)+gw/2 y(1) gw/2+bw eh],'',2,'SavedSettingsPop','-d');
p=p+1;[ui{p,1:8}] = deal('Save Settings','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_patternopt(8.3)',2,'SaveSetButton','-d');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'SetNameEdit','-d');



% Load / Save
%p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(2) y(1) bw eh],'oo_patternopt(1.1)',2,'');
%p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(3) y(1) gw/2+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Models','Pushbutton',Colors.disk,[x(1) y(3) bw eh],'oo_patternopt(8.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(3) gw/2+bw eh],'',2,'SavedModelsPop');
%p=p+1;[ui{p,1:7}] = deal('Save Models','Pushbutton',Colors.disk,[x(7) y(1) bw eh],'oo_patternopt(8.1)',2,'');
%p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[x(8) y(1) gw/2+bw eh],'',2,'FileNameEdit');

updfcn='oo_patternopt(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_patternopt(96)')
set(h0,'CloseRequestFcn','oo_patternopt(99)')

%TabPlotRadio=findobj(gcf,'Tag','TabPlotRadio','String','Table'); set(TabPlotRadio,'Value',1)
CodeRadio=findobj(gcf,'Tag','CodeRadio','String','Code'); set(CodeRadio,'Value',1)
OptTypeRadio=findobj(gcf,'Tag','OptTypeRadio','String','Overlap'); set(OptTypeRadio,'Value',1)