function oo_plot_errors(Estruct)
% function oo_plot_errors(Estruct)
% ver 180118 SAM

if isstruct(Estruct)
    errors_plot(Estruct)
    errors_table(Estruct)
end

% --------------- errors_plot(Estruct) --------------- 
function errors_plot(Estruct)


ph=findobj(gcf,'Position',Estruct.plotpos,'Type','axes'); delete(ph) % deletes old plot
subplot('Position',Estruct.plotpos)

if isfield(Estruct,'rmse')
    
rmse=Estruct.rmse;
rmseadj=Estruct.rmse_adj;
cmplab=Estruct.Labels;    

hp=max(rmseadj)/100;

po=0.4;
for x=1:numel(rmse)
    patch([0 rmseadj(x) rmseadj(x) 0],[x-po x-po x+po x+po],[1 0.5 0.5]*0.8,'EdgeColor','none')
    patch([0 rmse(x) rmse(x) 0],[x-po x-po x+po x+po],[1 0.5 0.5],'EdgeColor','none')
    text(hp,x,[cmplab{x} ', RMSE=' num2str(rmse(x),3) ', RMSE adj.=' num2str(rmseadj(x),3)],'FontWeight','bold')
end
line([0 0],[0,numel(rmse)+1],'Color',[0 0 0])
text(0.95,0.95,'RMSE / RMSE adj.','Units','Normalized','HorizontalAlignment','right','FontWeight','bold','FontSize',12)
set(gca,'Box','on','YTick',[])

maxval=max([rmseadj rmse]);
xl=[0,maxval*1.02];
xlim(xl)
ylim([0,numel(rmse)+0.5]*1.08)

set(gca,'Tag','PlotRMSE','UserData',Estruct)
zz_copyfigure

else
    ah=subplot('Position',Estruct.plotpos);
    set(ah,'XTick',[],'YTick',[])
    text(0.5,0.5,'No valid models selected','Units','Normalized','HorizontalAlignment','center',...
        'VerticalAlignment','middle','FontWeight','bold','FontSize',12)   
    xlim([-1 1]); ylim([-1 1])        
end


% --------------- errors_table(Estruct) --------------- 
function errors_table(Estruct)

T.TableName=Estruct.tablename;
T.Position=Estruct.tablepos;
Data=cell(0);
ColumnName=cell(0);
Labels=cell(0);
ColumnFormat=[];

% Table
colno=0;
if isfield(Estruct,'rmse') && ~isempty(Estruct.rmse)
    colno=colno+1;
    for x=1:numel(Estruct.rmse) Data{x,colno}=Estruct.rmse(x); end
    ColumnName{colno}='RMSE';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse);
end
if isfield(Estruct,'rmse_adj') && ~isempty(Estruct.rmse_adj)
    colno=colno+1;
    for x=1:numel(Estruct.rmse_adj) Data{x,colno}=Estruct.rmse_adj(x); end
    ColumnName{colno}='RMSE(adj)';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse_adj);
end
if isfield(Estruct,'correl') && ~isempty(Estruct.correl)
    colno=colno+1;
    for x=1:numel(Estruct.correl) Data{x,colno}=Estruct.correl(x)^2; end
    ColumnName{colno}=['R' char(178)];
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.correl.^2);
end
if isfield(Estruct,'bias') && ~isempty(Estruct.bias)
    colno=colno+1;
    for x=1:numel(Estruct.bias) Data{x,colno}=Estruct.bias(x); end
    ColumnName{colno}='Bias';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.bias);
end
if isfield(Estruct,'n_exp') && ~isempty(Estruct.n_exp)
    colno=colno+1;
    for x=1:numel(Estruct.n_exp) Data{x,colno}=Estruct.n_exp(x); end
    ColumnName{colno}='N. Exp.';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.n_exp);
end
if isfield(Estruct,'Labels')
    Labels=Estruct.Labels;
end

[nrows,ncols]=size(Data);
if nrows>1
    Labels{nrows+1}='Mean';
    for x=1:ncols
        Data{nrows+1,x}=Meancell{x};       
    end
end

% Table
T.Data=Data;
T.TableName=Estruct.tablename;
T.Position=Estruct.tablepos;
T.ColumnName=ColumnName;
T.ColumnFormat=ColumnFormat;
T.RowName=Labels;
T.ColumnEditable=false;
T.ViewPref=3;
if isfield(Estruct,'modeltype')
    T.HeaderText{1}='ERRORS:';
    T.HeaderText{2}=['Model type: ' Estruct.modeltype];
end
if isfield(Estruct,'parameter')
    T.HeaderText{1}='ERRORS:';
    T.HeaderText{3}=['Parameter: ' Estruct.parameter];
end
if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);
