function oo_plot_predmeas(call)
% function oo_plot_predmeas(Estruct)
% ver 180118 SAM

if isstruct(call)
    Estruct=call;
    predmeas_plot(Estruct)
    predmeas_table(Estruct)
else
    % Click on point
    if call==1
        Userdat=get(gcbo,'UserData');
        Pointerloc=zz_pointerlocation;
        xp=Pointerloc.axesscale_x;
        yp=Pointerloc.axesscale_y;
        
        mdiff=(Userdat.measured-xp).^2;
        pdiff=(Userdat.predicted-yp).^2;
        tdiff=mdiff .* pdiff;
        [minv,minind]=min(tdiff);
        
        RowName{1}='Predicted:'; Data{1,1}=Userdat.predicted(minind);
        RowName{2}='Measured:'; Data{2,1}=Userdat.measured(minind);    
        RowName{3}='Difference:'; Data{3,1}=Userdat.predicted(minind)-Userdat.measured(minind);
        RowName{4}='Rel error (%):'; Data{4,1}=100*(Userdat.predicted(minind)-Userdat.measured(minind))/Userdat.measured(minind);
        
        set(findobj(gca,'Tag','PMPlotMarker'),'XData',Data{2,1},'YData',Data{1,1},'Visible','on')
        
        Estruct=get(gca,'UserData'); 
        T.TableName=Estruct.tablename;
        T.Position=Estruct.tablepos;
        T.Data=Data;
        T.ColumnName=[];
        T.ColumnFormat{1}=4;
        T.RowName=RowName;
        T.ColumnEditable=false;
        T.ViewPref=3;       
        T.HeaderText{1}='PREDICTED AND MEASURED:';
        T.HeaderText{2}=Userdat.Labels;
        
        dp=Userdat.design(minind,:);
        for x=1:numel(dp)
            T.HeaderText{2+x}=[Userdat.Varnames{x} ': ' num2str(dp(x))]; 
        end     
        
        if zz_tabletool('Exist',T.TableName)
            zz_tabletool('Delete',T.TableName);
        end
        zz_tabletool('Create',T);
    end
    
    if call==2
        set(findobj(gca,'Tag','PMPlotMarker'),'Visible','off')
        Estruct=get(gcbo,'UserData');
        predmeas_table(Estruct)       
    end
    
end
    

% --------------- predmeas_plot(Estruct)  ---------------
function predmeas_plot(Estruct)

%if ~isfield(Estruct,'Predicted') 
%    plot_dummy(Estruct); return  
%end

ph=findobj(gcf,'Position',Estruct.plotpos,'Type','axes'); delete(ph) % deletes old plot
subplot('Position',Estruct.plotpos)

if isfield(Estruct,'Measured') && ~isempty(Estruct.Measured)
    
    allpred=[]; allmeas=[];
    for x=1:numel(Estruct.Measured)
        allpred=[allpred Estruct.Predicted{x}];
        allmeas=[allmeas Estruct.Measured{x}];
        C=corrcoef(Estruct.Measured{x},Estruct.Predicted{x});
        r(x)=C(1,2);
    end
    minv=min([allpred allmeas]);
    maxv=max([allpred allmeas]);
    
    C=corrcoef(allpred,allmeas);
    r_overall=C(1,2);
    
    line([minv maxv],[minv maxv],'Color',[0.7 0.7 0.7]); hold on
    text(0.03,0.95,'Predicted','Units','Normalized','FontWeight','bold','FontSize',10)
    text(0.97,0.05,'Measured','Units','Normalized','FontWeight','bold','HorizontalAlignment','right','FontSize',10)
    
    % set text box and header
    headerstr{1}='Predicted vs measured';
    headerstr{2}=['Parameter: ' Estruct.parameter];
    headerstr{3}=['Model type: ' Estruct.modeltype];
    headerstr{4}=['Mean R' char(178) '=' num2str(mean(r)^2,4)];
    headerstr{5}=['Overall R' char(178) '=' num2str(r_overall^2,4)];
    text(0.5,0.95,headerstr,'Units','Normalized','FontWeight','bold','FontSize',12,'HorizontalAlignment','center','VerticalAlignment','top','Interpreter','none')
    
    for x=1:numel(Estruct.Measured)
        Userdat.design=Estruct.Design{x};
        Userdat.predicted=Estruct.Predicted{x};
        Userdat.measured=Estruct.Measured{x};
        Userdat.Labels=Estruct.Labels{x};
        Userdat.Varnames=Estruct.Varnames;
        plot(Estruct.Measured{x},Estruct.Predicted{x},'o','MarkerFaceColor',Estruct.Colors(x,:),'MarkerEdgeColor','none','ButtonDownFcn','oo_plot_predmeas(1)','UserData',Userdat);
    end
    % Marker
    plot((maxv+minv)*0.5,(maxv+minv)*0.5,'o','MarkerFaceColor','none','MarkerEdgeColor',[1 0 0],'Tag','PMPlotMarker','MarkerSize',12,'LineWidth',3,'Visible','off')
    
    o=(maxv-minv)/20;
    hp=maxv-o*1.5;
    for x=1:numel(Estruct.Labels)
        text(minv-o*0.2,hp,Estruct.Labels{x},'Color',Estruct.Colors(x,:),'FontWeight','bold')
        hp=hp-o*0.8;
    end
    
    xlim([minv-o maxv+o]); ylim([minv-o maxv+o]);
    
    set(gca,'Tag','PlotPredMeas','UserData',Estruct,'ButtonDownFcn','oo_plot_predmeas(2)')
    zz_copyfigure
    
else
    ah=subplot('Position',Estruct.plotpos);
    set(ah,'XTick',[],'YTick',[])
    text(0.5,0.5,'No valid models selected','Units','Normalized','HorizontalAlignment','center',...
        'VerticalAlignment','middle','FontWeight','bold','FontSize',12)   
    xlim([-1 1]); ylim([-1 1])   
end


% --------------- predmeas_table(Estruct)  ---------------
function predmeas_table(Estruct)

T.TableName=Estruct.tablename;
T.Position=Estruct.tablepos;
Data=cell(0);
ColumnName=cell(0);
Labels=cell(0);
ColumnFormat=[];

% Table
colno=0;
if isfield(Estruct,'correl') && ~isempty(Estruct.correl)
    colno=colno+1;
    for x=1:numel(Estruct.correl) Data{x,colno}=Estruct.correl(x)^2; end
    ColumnName{colno}=['R' char(178)];
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.correl.^2);
end
if isfield(Estruct,'bias') && ~isempty(Estruct.bias)
    colno=colno+1;
    for x=1:numel(Estruct.bias) Data{x,colno}=Estruct.bias(x); end
    ColumnName{colno}='Bias';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.bias);
end
if isfield(Estruct,'rmse') && ~isempty(Estruct.rmse)
    colno=colno+1;
    for x=1:numel(Estruct.rmse) Data{x,colno}=Estruct.rmse(x); end
    ColumnName{colno}='RMSE';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse);
end
if isfield(Estruct,'rmse_adj') && ~isempty(Estruct.rmse_adj)
    colno=colno+1;
    for x=1:numel(Estruct.rmse_adj) Data{x,colno}=Estruct.rmse_adj(x); end
    ColumnName{colno}='RMSE(adj)';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.rmse_adj);
end
if isfield(Estruct,'n_exp') && ~isempty(Estruct.n_exp)
    colno=colno+1;
    for x=1:numel(Estruct.n_exp) Data{x,colno}=Estruct.n_exp(x); end
    ColumnName{colno}='N. Exp.';
    ColumnFormat{colno}=4;
    Meancell{colno}=mean(Estruct.n_exp);
end
if isfield(Estruct,'Labels')
    Labels=Estruct.Labels;
end

[nrows,ncols]=size(Data);
if nrows>1
    Labels{nrows+1}='Mean';
    for x=1:ncols
        Data{nrows+1,x}=Meancell{x};       
    end
end

% Table
T.Data=Data;
T.ColumnName=ColumnName;
T.ColumnFormat=ColumnFormat;
T.RowName=Labels;
T.ColumnEditable=false;
T.ViewPref=3;

if isfield(Estruct,'modeltype')
    T.HeaderText{1}='PREDICTED VS MEASURED:';
    T.HeaderText{2}=['Model type: ' Estruct.modeltype];
end
if isfield(Estruct,'parameter')
    T.HeaderText{1}='PREDICTED VS MEASURED:';
    T.HeaderText{3}=['Parameter: ' Estruct.parameter];
end

if zz_tabletool('Exist',T.TableName)
    zz_tabletool('Delete',T.TableName);
end
zz_tabletool('Create',T);





