function oo_plot_scale(an)
% function oo_plot_scale(an)
% ver 150703 SAM
% global Pattern Metset Locset
% 
% Function for manipulating chromatographic scale
% an==0: Draws zoomline
% 1>an>2: zoom and scaling
% an==100; updates zoomline and plot according to fileset
% an==101; updates plot and fileset according to zoomlline
% an==102; updates zoomline and fileset according to plot 
% an==103; redraw (change retention scale)
% an==104; initscale
%
% Used by oo_patternopt

global Pattern Metset Locset

if nargin==0; an=0; end

%xlocked=get(findobj(gcf,'Tag','XLockToggle'),'Val')

if Locset.tracker==1 disp(['--- oo_plot_scale --- ' num2str(an)]); end

% -------------- DRAW LINE  ----------------
if an==0 zoomline; end

% Sets chromatogram as current axes
mainchrom=findobj(gcf,'Tag','Mainchrom');
%if isempty(mainchrom) disp('---!! axes not found ---'); an=-1; end
set(gcf,'CurrentAxes',mainchrom)

%ActiveChrom=get(gca,'UserData') % TEMP

% -------------- INITIALIZE  ----------------
%if isfield(fileset,'chrom_li')==0; fileset.chrom_li=1; end
%if isfield(fileset,'chrom_ri')==0; fileset.chrom_ri=length(fileset.rt); end
%if isfield(fileset,'chrom_plotlab')==0; fileset.chrom_plotlab=fileset.rt; end
%if isfield(fileset,'chrom_cent')==0; fileset.chrom_cent=round((fileset.chrom_li+fileset.chrom_ri)/2); end


% ----------------- ZOOM -----------------
% Initialize
if an>1 && an<2
    %disp('--- initialize ---')
    n_scans=numel(Pattern.xscale);
    li=Pattern.li; 
    ri=Pattern.ri;
    cp=(li+ri)/2; 
    zf=(ri-li+1)/n_scans;
end

% Zoom in
if an==1.1 
    zf=zf*0.5; range=round(n_scans*zf);
    li=cp-(range/2); li=ceil(li); ri=cp+(range/2); ri=floor(ri);
end
% Zoom out
if an==1.2 
    zf=zf*2; range=round(n_scans*zf);
    li=cp-(range/2); li=ceil(li); ri=cp+(range/2); ri=floor(ri);  
end  
% Slider
if an==1.3    
    %disp('-- slider --')
    slide=gcbo; value=get(slide,'Value');
    range=1+ri-li;
    cp=round(value);
    li=round(cp-(range/2))+1; 
    ri=round(cp+(range/2));
end

% Adjust by arrow keys
if an==1.35 
    kp=double(get(gcf,'CurrentCharacter'));
    if kp==28 
        %disp('-- left arrow --'); 
        step=round((ri-li)/5); cp=cp-step; li=li-step; ri=ri-step;
    end
    if kp==29 
        %disp('-- right arrow --'); 
        step=round((ri-li)/5); cp=cp+step; li=li+step; ri=ri+step;        
    end  
end

if an==1.5 % Set X manually
    h=findobj('Tag','Xscale_low_edit'); str=get(h,'String'); 
    xlow=str2double(str); xlow=xlow(1);
    ind=Pattern.xscale<=xlow; li=max(ind); 
    if isempty(li) li=1; end
    h=findobj('Tag','Xscale_high_edit'); str=get(h,'String'); 
    xhigh=str2double(str); xhigh=xhigh(1);
    ind=find(Pattern.xscale>=xhigh) ; ri=min(ind); 
    if isempty(ri) ri=length(Pattern.xscale); end
    if ri<li l=li; r=ri; li=r; ri=l; end
    if li==ri li=1; ri=length(Pattern.xscale); end
end

% Updates range and slider
if an>1 && an<2
  
    if li<1 
        range=ri-li; if range>n_scans range=n_scans; end
        li=1; ri=1+range; 
    end; 
    if ri>n_scans; 
        range=ri-li; if range>n_scans range=n_scans; end
        ri=n_scans; li=ri-range; if li<1 li=1; end
    end
    if ri>li
        Pattern.li=li; Pattern.ri=ri; Pattern.cp=round((li+ri)/2);
    end    

    % Check for centering around selected 
    if an==1.1 || an==1.2
        checkcenter
        li=Pattern.li;
        ri=Pattern.ri;
        cp=round(mean([li ri]));
    end
    
    % Scales
    set(chromhandles,'Xlim',[Pattern.xscale(li) Pattern.xscale(ri)])
    
    % UPDATE SLIDER 
    range=ri-li+1; winfrac=range/n_scans;
    maxv=ceil(n_scans-range/2); minv=floor(range/2); val=cp;
    if maxv<val maxv=val; end
    if minv>val minv=val; end
    if minv>=maxv minv=cp-1; maxv=cp+1; end
    if range==n_scans minv=cp-1; maxv=cp+1; val=cp; end
    sliderh=findobj('Tag','Plotslider');  
    set(sliderh,'Max',maxv,'Min',minv,'Value',val,'SliderStep',[winfrac/5 winfrac])
    
    xscale; yscale     
end

% Y-SCALE
if an==3
    manualy
end
if an==3.1 % lock Y
    set(findobj('Tag','ASToggle'),'Value',0)
    set(findobj('Tag','YLockToggle'),'Value',1)
end
if an==3.2 % Autoscale Y
    set(findobj('Tag','YLockToggle'),'Value',0)
    set(findobj('Tag','ASToggle'),'Value',1)
    yscale
end

% Center button pressed
if an==10
    checkcenter
    readfileset
    yscale
end


% ---- UPDATES----
if an==100
    if get(findobj(gcf,'Tag','XLockToggle'),'Val')==0 
        readfileset; 
    else
        manualx
    end
    yscale;
end

if an==103
    redraw; 
end

if an==104
    initscale
end


% ====================================================================================
%                                   SUBFUNCTIONS
% ====================================================================================

% ---------------- checkcenter ------------------
function checkcenter
% Checks if plot should be centered and centers

CenterZoomBtn=findobj(gcf,'Tag','CenterZoomBtn');
if get(CenterZoomBtn,'Value')==1
    centerplot
end

% ---------------- centerplot ------------------
function centerplot
global Pattern


    li=Pattern.li;
    ri=Pattern.ri;
    range=ri-li;
    Pattern.li=round(newcent-range/2);
    Pattern.ri=Pattern.li+range;
    if Pattern.li<1 Pattern.li=1; Pattern.ri=Pattern.li+range; end
    if Pattern.ri>length(Pattern.xscale_rt) Pattern.ri=length(Pattern.xscale); Pattern.li=Pattern.ri-range; end






% ---------------- chromhandles ------------------
% Chromatograms to be scaled must be specified here
function chromh=chromhandles
chromh=findobj('Tag','ProfPlot');


% ---------------- MANUALY ------------------
function manualy

%disp('--- oo_plot_scale/manualy ---')

Yscale_low_edit=findobj('Tag','Yscale_low_edit');
Yscale_high_edit=findobj('Tag','Yscale_high_edit');
Yscale_exp_edit=findobj('Tag','Yscale_exp_edit');
YLockToggle=findobj(gcf,'Tag','YLockToggle'); set(YLockToggle,'Value',1);
ASToggle=findobj(gcf,'Tag','ASToggle'); set(ASToggle,'Value',0);
minymaxy=get(gca,'Ylim'); ymin_old=minymaxy(1); ymax_old=minymaxy(2);

ymi=str2double(get(Yscale_low_edit,'String')); ymi=ymi(1);
yma=str2double(get(Yscale_high_edit,'String')); yma=yma(1);
exp=str2double(get(Yscale_exp_edit,'String')); exp=exp(1);
ymin=ymi*10^exp; 
ymax=yma*10^exp;
if sum(isnan([ymin ymax]))==0 && ymax>ymin
    ylim([ymin ymax]);
else
    ylim([ymin_old ymax_old]);
    ba=10^floor(log10(ymax_old)); yma=round(100*ymax_old/ba)/100; ymi=round(100*ymin_old/ba)/100;
    set(Yscale_low_edit,'String',num2str(ymi),3)
    set(Yscale_high_edit,'String',num2str(yma),3)
    set(Yscale_exp_edit,'String',num2str(log10(ba)))  
end


% ---------------- REDRAW ------------------
function redraw

%disp('---- oo_plot_scale/redraw ----')

wintag=get(gcf,'Tag');
plottag=get(gca,'Tag');

if strcmp(plottag,'Chrom_main') && strcmp(wintag,'MainWin')
    cc_plot_mainchrom(0); 
end
if strcmp(plottag,'Chrom_main') && strcmp(wintag,'AdvEditrWin')
    cc_plot_mainchrom(0); 
end
if strcmp(plottag,'Chrom_template') && strcmp(wintag,'TemplWin')
    cc_plot_templchrom(0); 
end
if strcmp(plottag,'Chrom_main') && strcmp(wintag,'AnalyzeWin')
    cc_plot_analchrom; 
end
%if strcmp(plottag,'Chrom_template') && strcmp(wintag,'TemplWin')
%    cc_plot_templchrom(0); 
%end

if strmatch(wintag,'RiCalibrWin')
    cc_ri_calibrate(100);
    %cc_plot_richrom(0); 
end

%if strmatch(plottag,'Mainchrom') & strmatch(wintag,'PeakWin')
%    cc_plot_peakchrom(0); 
%end
%if strmatch(plottag,'Mainchrom') & strmatch(wintag,'ResultsWin')
%    cc_plot_results(0); 
%end

xscale; yscale;

% ---------------- READFILESET ------------------
function readfileset
% update according to fileset
global Pattern 

%disp('--- oo_plot_scale/readfileset ---')

if isempty(Pattern.li) || isnan(Pattern.li)
    Pattern.ri=length(Pattern.xscale);
    Pattern.li=1;
end

if Pattern.ri>length(Pattern.xscale) Pattern.li=1; Pattern.ri=length(Pattern.xscale); end
set(chromhandles,'Xlim',[Pattern.xscale(Pattern.li) Pattern.xscale(Pattern.ri)]) 

% UPDATE SLIDER 
n_scans=length(Pattern.xscale);
cp=round((Pattern.ri+Pattern.li)/2);
range=Pattern.ri-Pattern.li+1; winfrac=range/n_scans;

maxv=ceil(n_scans-range/2); minv=floor(range/2); val=cp;
if maxv<val maxv=val; end
if minv>val minv=val; end
if minv>=maxv minv=cp-1; maxv=cp+1; end
if range==n_scans minv=cp-1; maxv=cp+1; val=cp; end
sliderh=findobj('Tag','Plotslider');  
set(sliderh,'Max',maxv,'Min',minv,'Value',val,'SliderStep',[winfrac/5 winfrac])

% Edits (X)
if get(findobj(gcf,'Tag','ScaleRadio','String','Scan No.'),'Value') form='%6.0f'; else form=4; end
h=findobj('Tag','Xscale_low_edit'); set(h,'string',num2str(Pattern.xscale(Pattern.li),form))
h=findobj('Tag','Xscale_high_edit'); set(h,'string',num2str(Pattern.xscale(Pattern.ri),form))

% ---------------- MANUALX ------------------
function manualx
global Pattern 

%disp('--- Manualx ---')

lowedit=findobj(gcf,'Tag','Xscale_low_edit'); 
lowx=str2double(get(lowedit,'String'));

highedit=findobj(gcf,'Tag','Xscale_high_edit'); 
highx=str2double(get(highedit,'String'));

lowind=max(find(Pattern.xscale<=lowx)); if isempty(lowind) lowind=1; end
highind=min(find(Pattern.xscale>=highx)); if isempty(highind) highind=length(Pattern.xscale); end

set(lowedit,'String',num2str(Pattern.xscale(lowind)));
set(highedit,'String',num2str(Pattern.xscale(highind)));

Pattern.li=lowind; Pattern.ri=highind; 

set(chromhandles,'Xlim',[Pattern.xscale(lowind) Pattern.xscale(highind)])


% ---------------- YSCALE ------------------
function yscale
global Pattern Pos

%disp('--- oo_plot_scale/yscale ---')

Yscale_low_edit=findobj('Tag','Yscale_low_edit');
Yscale_high_edit=findobj('Tag','Yscale_high_edit');
Yscale_exp_edit=findobj('Tag','Yscale_exp_edit');
YLockToggle=findobj(gcf,'Tag','YLockToggle');
ASToggle=findobj(gcf,'Tag','ASToggle');

hightrace=Pattern.sumprof;
lowtrace=Pattern.sumprof;
  
% IF AUTOSCALE
val=get(YLockToggle,'Value');
if val==0
    set(ASToggle,'Value',1);
    ymax=max(hightrace(Pattern.li:min([Pattern.ri length(hightrace)])));
    ymin=min(lowtrace(Pattern.li:min([Pattern.ri length(lowtrace)])));
    if ymin>ymax; [ymin,ymax]=deal(ymax,ymin); end
    o=(ymax-ymin)*0.02; ymax=ymax+5*o; ymin=ymin-o/10; 
    if ymin==ymax ymin=ymin-1; ymax=ymax+1; end
    if ymax>ymin
        set(chromhandles,'Ylim',[ymin ymax]);
    end
    
    % Sets values in edit
    ba=10^floor(log10(ymax)); yma=round(100*ymax/ba)/100; ymi=round(100*ymin/ba)/100;
    set(Yscale_low_edit,'String',num2str(ymi))
    set(Yscale_high_edit,'String',num2str(yma))
    set(Yscale_exp_edit,'String',num2str(log10(ba)))    
else
    ymi=str2double(get(Yscale_low_edit,'String')); 
    ymi=ymi(1);
    yma=str2double(get(Yscale_high_edit,'String')); 
    yma=yma(1);
    b=str2double(get(Yscale_exp_edit,'String')); ba=10^b(1);
    ymin=ymi*ba; 
    ymax=yma*ba;
    o=(ymax-ymin)*0.02;
    set(chromhandles,'Ylim',[ymin ymax]);
end



% ---------------- XSCALE ------------------
% Setter x-skala
function xscale 
global Pattern 
% Updates Edits for manual settings

%disp('---- oo_plot_scale (xscale) ----')

%set(gca,'Tag','Chromatogram');
%xlim([Pattern(fno).xscale_plot(Pattern(fno).li) Pattern(fno).xscale_plot(Pattern(fno).ri)]);
if get(findobj(gcf,'Tag','ScaleRadio','String','Scan No.'),'Value') form='%6.0f'; else form=4; end
h=findobj('Tag','Xscale_low_edit'); set(h,'string',num2str(Pattern.xscale(Pattern.li),form))
h=findobj('Tag','Xscale_high_edit'); set(h,'string',num2str(Pattern.xscale(Pattern.ri),form))

h=findobj('Tag','ScaleRadio'); set(h,'Value',0)



% -------------- SUBFUNCTION ZOOMLINE -------------------
function zoomline

global fonts Pos 

bw=Pos.bw;
gw=Pos.gw;
bh=Pos.bh;
eh=Pos.eh;
x=Pos.xg; % horisontalt grid
y=Pos.yg; % vertikalt grid
o=bh-eh;
h0=gcf;

vp=Pos.largeplot(2)-Pos.gh*0.75;

% ZOOMLINE
h=findobj(gcf,'Tag','Plotcontrol'); 
if isempty(h)
    hp=x(1);
    uicontrol('Parent',h0,'Callback','oo_plot_scale(1.1)','Position',[hp vp bw/4 eh],'String','+','Tag','Plotcontrol','FontSize',fonts(5));
    uicontrol('Parent',h0,'Callback','oo_plot_scale(1.2)','Position',[hp+bw/4 vp bw/4 eh],'String','-','Tag','Plotcontrol','FontSize',fonts(5));
    uicontrol('Parent',h0,'Callback','oo_plot_scale(10)','Position',[hp+bw/2 vp bw/4 eh],'String','( )','Tag','CenterZoomBtn',...
        'Style','ToggleButton','FontSize',fonts(2),'Enable','off');
    uicontrol('Parent',h0,'Callback','oo_plot_scale(1.3)','Max',100,'SliderStep',[0.02 0.20],'Position',[hp+bw*3/4 vp bw*2 eh], ...
    	'Style','slider','Tag','Plotslider','Value',50.0);
    % Xscale
    hp=x(3)+gw*0.5;
    uicontrol('Parent',h0,'Callback','','Position',[hp vp gw*0.2 eh], ...
    	'Style','Text','Tag','Zoomlineobj','Value',0,'String','X: ','HorizontalAlignment','right');
    uicontrol('Parent',h0,'Callback','oo_plot_scale(1.5)','Position',[hp+gw*0.2 vp gw*0.45 eh], ...
    	'Style','Edit','Tag','Xscale_low_edit','Value',0,'String','--','FontSize',10,'FontName','FixedWidth','FontWeight','Normal');
    uicontrol('Parent',h0,'Callback','oo_plot_scale(1.5)','Position',[hp+gw*0.65 vp gw*0.45 eh], ...
    	'Style','Edit','Tag','Xscale_high_edit','Value',0,'String','--','FontSize',10,'FontName','FixedWidth','FontWeight','Normal');
    uicontrol('Parent',h0,'Position',[hp+gw*1.2 vp gw*0.4 eh], ...
    	'Style','togglebutton','Tag','XLockToggle','Value',0,'String','Lock');
    % Yscale
    hp=x(5);
    uicontrol('Parent',h0,'Callback','','Position',[hp+gw*0.2 vp gw*0.2 eh], ...
    	'Style','Text','Tag','Zoomlineobj','String','Y: ','HorizontalAlignment','right');    
    uicontrol('Parent',h0,'Callback','oo_plot_scale(3)','Position',[hp+gw*0.4 vp gw*0.45 eh], ...
    	'Style','Edit','Tag','Yscale_low_edit','String','--','FontSize',10,'FontName','FixedWidth','FontWeight','Normal');
    uicontrol('Parent',h0,'Callback','oo_plot_scale(3)','Position',[hp+gw*0.85 vp gw*0.45 eh], ...
    	'Style','Edit','Tag','Yscale_high_edit','String','--','FontSize',10,'FontName','FixedWidth','FontWeight','Normal');
    uicontrol('Parent',h0,'Callback','','Position',[hp+gw*1.3 vp gw*0.2 eh], ...
    	'Style','Text','Tag','Zoomlineobj','String','e','HorizontalAlignment','center');
    uicontrol('Parent',h0,'Callback','oo_plot_scale(3)','Position',[hp+1.5*gw vp gw*0.2 eh], ...
    	'Style','Edit','Tag','Yscale_exp_edit','String','-','FontSize',10,'FontName','FixedWidth','FontWeight','Normal');
   % Auto/Manual Y toggle buttons 
   uicontrol('Parent',h0,'Callback','oo_plot_scale(3.1)','Position',[hp+1.8*gw vp gw*0.4 eh], ...
    	'Style','togglebutton','Tag','YLockToggle','Value',0,'String','Lock');
   uicontrol('Parent',h0,'Callback','oo_plot_scale(3.2)','Position',[hp+2.2*gw vp gw*0.4 eh], ...
    	'Style','togglebutton','Tag','ASToggle','Value',1,'String','Auto');       
end

