function oo_readdata(call)
% function oo_readdata(call)
% ver 240612 SAM
% global Metset Imported Locset Tempset Design
%

global Metset Imported Locset Tempset Design

if nargin<1 call=0; end

disp(['--- oo_readdata ---' num2str(call)])

zz_message(2); % Blanker ut meldinger
   
% NEW WIN
if call==0 
    initialize
    Design=[];
    openwin
    getexperiments
    getdesigns
    fileslist
    boxlist2
    chromlist
    compoundlist2
    assignlist
end

% Select directory from edit
if call==1.2
    fileslist 
end
% Select directory using gui
if call==1.3
    PathEdit=findobj(gcf,'Tag','PathEdit');
    pathstr=get(PathEdit,'String');
    directory_name = uigetdir(pathstr,'Select folder');
    if directory_name==0 directory_name=pathstr; end
    set(PathEdit,'String',directory_name)
    fileslist
end

% Import and clear
% Clear
if call==2.0 % delete existing (clear & Read/Replace)
    initialize
end
% import
if call==2.1 % read newfiles 
    if ~isfield(Tempset,'selbox') || isempty(Tempset.selbox)
        Tempset.selbox=1;
    end
    readdata2
    dataupdate
    meanvalues(1:length(Imported))
end
% update
if call>=2.0 && call<3
    parameterlist; chromlist; compoundlist2; boxlist2; assignlist
    if ~isempty(Design) && ~isempty(Imported) assignlist; end
end

% Edit Chromatogram name
if call==3.1
    dat=zz_tabletool('getlastcell','ChromListTab');
    if dat.colindex==2
        Imported(Tempset.selbox).filenames{dat.rowindex}=dat.val;
    end
end

% Select box / edit boxname
if call==3.2
    boxedit;
end

% select parameter
if call==3.3
    BoxDataRadio=findobj(gcf,'Tag','BoxDataRadio');
    if get(BoxDataRadio,'Value')
        compoundlist2
    else
        exportlist2
    end
end

% CodeRadios
if call==4.1
    CodeRadio=findobj(gcf,'Tag','CodeRadio');
    set(CodeRadio,'Value',0); set(gcbo,'Value',1)   
    if get(findobj(gcf,'Tag','BoxDataRadio'),'Value')
        compoundlist2
    else
        exportlist2
    end 
end

% Listtype
if call==6.1 || call==6.2
    if call==6.1
        compoundlist2;        
    end
    if call==6.2
        exportlist2;
    end
end

% save/load
if call==7.1
    savedata
end
if call==7.2
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    strs=get(SavedExperimentsPop,'String');
    val=get(SavedExperimentsPop,'Value');
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' strs{val} '.mat' ];
    load(pathname,'Imported')
    set(findobj(gcf,'Tag','FileNameEdit'),'String',strs{val})  
    allcodes
    boxlist2
    chromlist
    parameterlist
    compoundlist2 
    assignlist 
end
% load design
if call==7.3
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    str=get(DesignFilesPop,'String');
    val=get(DesignFilesPop,'Value');
    filename=str{val};
    pathname=[Locset.path_designs filesep Metset.path_designs filesep 'design_' filename '.mat']; 
    load(pathname,'Design');
    if ~isempty(Design) && ~isempty(Imported) assignlist; end
    set(findobj(gcf,'Tag','ClearDesBtn'),'Enable','on')
end
% clear design
if call==7.35
    Design=[]; set(gcbo,'Enable','off'); assignlist; 
end

% assign using table
if call==8.3
    assign
end
% delete assignments
if call==8.4 
    if ~isempty(Imported)
        [Imported(:).designpoint]=deal(0);
        if isfield(Imported,'paramnames') Imported=rmfield(Imported,'paramnames'); end
        if isfield(Imported,'parameters') Imported=rmfield(Imported,'parameters'); end
        if isfield(Imported,'color') Imported=rmfield(Imported,'color'); end
        assignlist
    end 
end
% add new variable
if call==8.5
    AddVarEdit=findobj(gcf,'Tag','AddVarEdit');
    newname=deblank(get(AddVarEdit,'String')); 
    if ~isempty(newname)
        validname=1;
        % Check if name used before
        if isfield(Imported,'paramnames')
            for bno=1:numel(Imported)
                ind=strmatch(newname,Imported(bno).paramnames,'exact');
                if ~isempty(ind) validname=0; end
            end
        end
        if validname==0 
            set(AddVarEdit,'BackgroundColor',[1 1 0])
            zz_message(1,'Variable name already in use','-r')
            return
        end
        for bno=1:numel(Imported)
            newno=1;
            if isfield(Imported,'paramnames') && ~isempty(Imported(bno).paramnames)
                newno=numel(Imported(bno).paramnames)+1;
            end
            Imported(bno).paramnames{newno}=newname;
            Imported(bno).parameters(newno)=NaN; 
        end
        set(AddVarEdit,'BackgroundColor',[1 1 1])
        assignlist
    else
        set(AddVarEdit,'BackgroundColor',[1 1 0])
        zz_message(1,'Select a variable name','-r')
    end 
end
if call==8.6
    DelVarPop=findobj(gcf,'Tag','DelVarPop');
    str=get(DelVarPop,'String'); val=get(DelVarPop,'Value');
    delname=str{val};
    for bno=1:numel(Imported)
        if ~isempty(Imported(bno).paramnames)
            ind=strmatch(delname,Imported(bno).paramnames);
            Imported(bno).paramnames(ind)=[];
            Imported(bno).parameters(ind)=[];
        end
    end
    assignlist
end
% Autoassign
if call==8.7
    if isfield(Design,'n_experiments') && Design.n_experiments==numel(Imported)
        for x=1:numel(Imported)
            Imported(x).designpoint=x;
            Imported(x).color=Design.colormatrix(x,:);
            Imported(x).paramnames=Design.paramnames;
            Imported(x).parameters=Design.parameters(x,:);
        end
        assignlist
    else
        zz_message(1,'Cannot autoassign. Number of boxes and experimental are not equal','-r')
    end
end

% Inport table edit
if call==9.2
    imptabedit
end
% Export table edit
if call==9.3
    exptabedit
end

% Delete chroms
if call==10.1
    dat=zz_tabletool('getdata','ChromListTab');
    if ~isempty(dat)
        sels=find(cell2mat(dat(:,1)));
        if ~isempty(sels)
            delchrom(Tempset.selbox,sels)
            boxlist2; chromlist; compoundlist2; parameterlist; assignlist
        end
    end
end
% Delete Box
if call==10.2
    dat=zz_tabletool('getdata','BoxListTab');
    if ~isempty(dat)
        sels=find(cell2mat(dat(:,1)));
        Imported(sels)=[];
        if Tempset.selbox>numel(Imported) Tempset.selbox=numel(Imported); end
        parameterlist; chromlist; compoundlist2; boxlist2; assignlist
    end
end


% ---------- KEYPRESS ----------   
if call==96
end

% -------- CLOSE/EXIT ---------
% Quit
if call==99 % Quit
    zz_closewin
end
if call==99.1 % Exit
    %h=get(gcf,'Children'); delete(h); delete(gcf);  
end
if call==99.2 % Exit Matlab
    %h=get(gcf,'Children'); delete(h); delete(gcf); exit 
end
if call==99.3
    %fn=fieldnames(Metset); n=length(fn);
    %pathname=[Locset.path_method filesep Metset.path_method filesep 'met_' Metset.file_method '.mat']; 
    %for x=1:n tempmet.(fn{x})=Metset.(fn{x}); end
    %save(pathname,'tempmet');
end

% ---------- UPDATE ----------   
if call==100
    %disp('---- oo_readdata (update) ----')   
end

if call==-1
    zz_message(1,'Not implemented','-r')
end



% -------------------------------------------------------------------------
% ----------------- S U B F U N C T I O N S -------------------------------
% -------------------------------------------------------------------------

% ------------ INITIALIZE ------------
function initialize
global Tempset Imported Design

Imported=[]; Tempset=[]; Design=[];

Tempset.varnames={'rt','ri','wbl','wbl_ri','area','height','responsefactor'};
Tempset.varexpl={'Retention time (RT)','Retention index (RI)','Peak width (RT units)','Peak width (RI units)','Area','Height','Response factor'};


% ------------ allcodes ------------
% Updates allcodes field in Tempset
function allcodes
global Imported Tempset

codes=cell(0); names=cell(0); shortnames=cell(0); ncodes=0;

for bno=1:numel(Imported)
    if isfield(Imported,'cmp_code') && ~isempty(Imported(bno).cmp_code)
        for x=1:numel(Imported(bno).cmp_code)
            ind=strmatch(Imported(bno).cmp_code{x},codes);
            if isempty(ind)
                ncodes=ncodes+1;
                codes{ncodes}=Imported(bno).cmp_code{x};
                names{ncodes}=Imported(bno).cmp_name{x};
                shortnames{ncodes}=Imported(bno).cmp_shortname{x};
            end
        end
    end
end
[Tempset.allcodes,sortind]=sort(codes); Tempset.allnames=names(sortind); Tempset.allshortnames=shortnames(sortind);


% ------------ DATAUPDATE ------------
function dataupdate
global Imported Tempset

allcodes

% Create matrices
for bno=1:numel(Imported)   
    for vno=1:numel(Tempset.varnames)
        varname=Tempset.varnames{vno};
        if isfield(Imported,varname) && ~isempty(Imported(bno).(varname))
            [ncmp,nchrom]=size(Imported(bno).(varname));
            datamat=repmat(NaN,numel(Tempset.allcodes),nchrom);
            for cmpno=1:ncmp
                ind=strmatch(Imported(bno).cmp_code{cmpno},Tempset.allcodes);
                if ~isempty(ind)
                    ind=ind(1);
                    datamat(ind,:)=Imported(bno).(varname)(cmpno,:);
                end
            end
            Imported(bno).(varname)=datamat;
        end
    end
    
    Imported(bno).cmp_code=Tempset.allcodes;
    Imported(bno).cmp_name=Tempset.allnames;
    Imported(bno).cmp_shortname=Tempset.allshortnames;    

end

% Selected
for bno=1:numel(Imported)  
    for vno=1:numel(Tempset.varnames)
        varname=Tempset.varnames{vno};
        Imported(bno).Selected.(varname)=[];
        if isfield(Imported(bno),varname) && ~isempty(Imported(bno).(varname))
            [m,n]=size(Imported(bno).(varname));
            Imported(bno).Selected.(varname)=zeros(m,n);
            ind=~isnan(Imported(bno).(varname));
            Imported(bno).Selected.(varname)(ind)=1;
        end
    end 
end


% ------------------- delchrom ---------------------
function delchrom(boxno,chromno)
global Imported Tempset

Imported(boxno).filenames(chromno)=[];

%fn={'rt','ri','wbl','wbl_ri','area','height','responsefactor'};
fn=Tempset.varnames;

for fnr=1:numel(fn)
    if ~isempty(Imported(boxno).(fn{fnr}))
        X=Imported(boxno).(fn{fnr}); X(:,chromno)=[]; Imported(boxno).(fn{fnr})=X;
        X=Imported(boxno).Selected.(fn{fnr}); X(:,chromno)=[]; Imported(boxno).Selected.(fn{fnr})=X;      
    end   
end

% deletes or updates entry
if isempty(Imported(boxno).rt)
    Imported(boxno)=[];
    if Tempset.selbox>numel(Imported) Tempset.selbox=numel(Imported); end
else
    meanvalues(boxno)
end
 

% ------------------- combine ---------------------
function combine(boxnos,addasnew)
global Imported Tempset

%disp(['--- combine --- ' num2str(boxnos)])

if isempty(Imported)
    return
end

if nargin<2 addasnew=0; end % set to 1 if new entry should be added to existing list

% Finds codes/names/shortnames
allcodes=cell(0); allfilenames=cell(0); allnames=cell(0); allshortnames=cell(0); 
for x=1:numel(boxnos)
    
    allboxnames{x}=Imported(boxnos(x)).boxname;

    nold=numel(allfilenames); nnew=numel(Imported(boxnos(x)).filenames);
    allfilenames(nold+1:nold+nnew)=deal(Imported(boxnos(x)).filenames(1:nnew)); 
    
    nold=numel(allcodes); nnew=numel(Imported(boxnos(x)).cmp_code);
    allcodes(nold+1:nold+nnew)=deal(Imported(boxnos(x)).cmp_code(1:nnew)); 
    allnames(nold+1:nold+nnew)=deal(Imported(boxnos(x)).cmp_name(1:nnew)); 
    allshortnames(nold+1:nold+nnew)=deal(Imported(boxnos(x)).cmp_shortname(1:nnew));
    
end

% Finds codes and matching indices
[uniquecodes,m,n]=unique(allcodes);
uniquenames=allnames(m);
uniqueshortnames=allshortnames(m);
n_chrom=numel(allfilenames);
n_comp=numel(uniquecodes);
nanmat=repmat(NaN,n_comp,n_chrom);

% Initialize newentry
newentry.filenames=allfilenames;
newentry.cmp_code=uniquecodes;
newentry.cmp_name=uniquenames;
newentry.cmp_shortname=uniqueshortnames;
newentry.rt=nanmat;
newentry.ri=nanmat;
newentry.wbl=nanmat;
newentry.wbl_ri=nanmat;
newentry.area=nanmat;
newentry.height=nanmat;
newentry.responsefactor=nanmat;
newentry.Selected=[];
newentry.boxname=[];
newentry.designpoint=0;

%fn={'rt','ri','wbl','wbl_ri','area','height','responsefactor'};
fn=Tempset.varnames;

% Fill inn data
for cmpno=1:numel(uniquecodes)
    code=uniquecodes{cmpno};
    prevchrom=0;
    for x=1:numel(boxnos)
        n_chroms=numel(Imported(boxnos(x)).filenames);
        oldind1=strmatch(code,Imported(boxnos(x)).cmp_code); 
        oldind2=1:n_chroms;
        newind1=cmpno;
        newind2=oldind2+prevchrom;
        prevchrom=prevchrom+n_chroms;
        if ~isempty(oldind1)
            oldind1=oldind1(1);
            
            % Assign data
            % May fail on older Matlab versions, alternatively use code below
            for fno=1:numel(fn)
                if isfield(Imported,fn{fno}) && ~isempty(Imported(boxnos(x)).(fn{fno}))
                    [nr,nc]=size(Imported(boxnos(x)).(fn{fno}));
                    if nr>=oldind1 && nc>=max(oldind2)
                        newentry.(fn{fno})(newind1,newind2)=Imported(boxnos(x)).(fn{fno})(oldind1,oldind2);
                    end
                else
                    newentry.(fn{fno})=[];
                end
            end       
        end 
    end   
end

% Clean and add Selected
for fno=1:numel(fn)
    hasvals=~isnan(newentry.(fn{fno}));
    ind=find(hasvals);
    if isempty(ind)
        newentry.(fn{fno})=[]; newentry.Selected.(fn{fno})=[];
    else
        newentry.Selected.(fn{fno})=double(hasvals);
    end      
end
    
% Generates boxname
bname=[];
bm=strvcat(allboxnames);
ind=find(std(double(bm)));
if ~isempty(ind) && min(ind)>1
    stemstr=allboxnames{1}(1:(min(ind)-1));
    stemlength=numel(stemstr);
    bname=stemstr;
    for x=1:numel(allboxnames)
        %allboxnames{x}(stemlength+1:numel(allboxnames{x}))
        if length(allboxnames{x})>stemlength
            bname=[bname '_' allboxnames{x}(stemlength+1:numel(allboxnames{x}))];
        end
    end
end
if isempty(bname) bname='Combined'; end
newentry.boxname=bname;

if addasnew
    entno=numel(Imported)+1; delent=[];
else
    entno=boxnos(1); delent=boxnos; delent(1)=[];  
end

fn=fieldnames(newentry);
for fnr=1:numel(fn)
    Imported(entno).(fn{fnr})=newentry.(fn{fnr});
end

if ~isempty(delent)
    Imported(delent)=[];
end

meanvalues(entno)


% ------------------- boxedit ---------------------
function boxedit
global Imported Tempset

dat=zz_tabletool('getlastcell','BoxListTab');
BoxDataRadio=findobj(gcf,'Tag','BoxDataRadio');

if dat(1).colindex==2
    % change name
    Imported(dat.rowindex).boxname=dat.val;
    assignlist  
else
    % select box
    dat=zz_tabletool('getlastcol','BoxListTab');
    Tempset.selbox=find(cell2mat(dat(1).val));
    parameterlist
    if get(BoxDataRadio,'Value') compoundlist2; end  
    chromlist
end


% ------------------- exptabedit ---------------------
function exptabedit
global Imported Tempset

dat=zz_tabletool('getlastcell','ImpExpTab');
expvarname=[getvarname '_exp'];
codes=Imported(dat.colindex).cmp_code;
code=Tempset.allcodes{dat.rowindex};

cmpind=strmatch(code,codes);

if ~isempty(cmpind)
    Imported(dat.colindex).(expvarname)(cmpind)=dat.val;  
end


% ------------------- assignlist ---------------------
function assignlist
global Imported Design Pos

%disp('--- assignlist ---')

SelectText=findobj(gcf,'Tag','SelectText'); set(SelectText,'Visible','on')
viewpref=1;

if zz_tabletool('Exist','AssignTab')==1
    viewpref=zz_tabletool('getparam','AssignTab','tabletype');
    if viewpref==0; viewpref=1; end
    zz_tabletool('Delete','AssignTab');
end

% generate list of parameter names
npas=0; pnames=cell(0);
if ~isempty(Imported)
    for x=1:numel(Imported);
        if isfield(Imported,'paramnames') && ~isempty(Imported(x).paramnames);
            for y=1:numel(Imported(x).paramnames)
                npas=npas+1;
                pnames{npas}=Imported(x).paramnames{y};
            end
        end
    end
end
if ~isempty(Design)
    for x=1:numel(Design.paramnames)
        npas=npas+1;
        pnames{npas}=Design.paramnames{x};
    end
end
[b,m,n] = unique(pnames); [dummy,sind]=sort(m); pnames=b(sind);
       
% generate column headers / formats / editable / cwidths
headers(3:numel(pnames)+2)=pnames(:); headers{1}='Box Name'; headers{2}='Design point';
formats={'text','text'}; [formats{3:numel(pnames)+2}]=deal(4);
editables=[0 0]; editables=[editables ones(1,numel(pnames))];
cwidths={150,150}; [cwidths{3:numel(pnames)+2}]=deal(50);

% fill data
Data=[];
for bno=1:numel(Imported)
    T.RowName{bno}=['Box ' num2str(bno)];
    Data{bno,1}=Imported(bno).boxname;
    Data{bno,2}='Design not loaded';
    [Data{bno,3:numel(pnames)+2}]=deal(NaN);
    if isfield(Imported,'paramnames') && ~isempty(Imported(bno).paramnames);
        for y=1:numel(Imported(bno).paramnames)
            ind=strmatch(Imported(bno).paramnames{y},pnames,'exact');
            Data{bno,2+ind}=Imported(bno).parameters(y);
        end
    end    
end

% fill inn designpoints
if ~isempty(Design)    
    [c,ia,ib]=intersect(Design.paramnames,headers);
    choices{1}='Not assigned';
    [n_despoints,n_param]=size(Design.parameters);   
    for x=1:n_despoints
        str=[num2str(x), ')'];
        for y=1:n_param
            str=[str ' ' Design.paramnames{y} ':' num2str(Design.parameters(x,y))];
        end
        choices{x+1}=str;
    end  
    
    % Assign designpoints
    for bno=1:numel(Imported)
        matchind=[];
        if isfield(Imported,'paramnames') && ~isempty(Imported(bno).paramnames)
            [cx,iax,ibx]=intersect(Design.paramnames,Imported(bno).paramnames);
        
            if numel(iax)==numel(Design.paramnames)
                [cv,iav,matchind]=intersect((Imported(bno).parameters(ibx)),(Design.parameters(:,iax)),'rows'); 
            end
        end
        if isempty(matchind)
            Data{bno,2}=choices{1};
            Imported(bno).designpoint=0;
        else
            Data{bno,2}=choices{matchind+1};
            Imported(bno).designpoint=matchind;
            Imported(bno).color=Design.colormatrix(matchind,:);
        end
    end 
    formats{2}=choices; editables(2)=1;
end

T.Data=Data;
T.ColumnEditable=editables;
T.Popup=0;
T.ViewPref=viewpref;
T.Position=[Pos.xg(6) Pos.yg(1) 1-Pos.xg(6)-Pos.xg(1) Pos.gh*7]; % 1-Pos.xg(6)-Pos.xg(1)
T.CellEditCallback='oo_readdata(8.3)';
T.AllowNan=1;
T.TableName='AssignTab';
T.ColumnFormat=formats;
T.ColumnWidth=cwidths;
T.ColumnName=headers;

zz_tabletool('Create',T);

if isempty(pnames)
    set(findobj(gcf,'Tag','DelVarBtn'),'Enable','off')
    set(findobj(gcf,'Tag','DelVarPop'),'Enable','off','String',' ','Value',1)
else
    set(findobj(gcf,'Tag','DelVarBtn'),'Enable','on')
    set(findobj(gcf,'Tag','DelVarPop'),'Enable','on','String',pnames,'Value',1)
end

if isempty(Data)
    set(findobj(gcf,'Tag','AddVarBtn'),'Enable','off')
    set(findobj(gcf,'Tag','AddVarEdit'),'Enable','off')
else
    set(findobj(gcf,'Tag','AddVarBtn'),'Enable','on')
    set(findobj(gcf,'Tag','AddVarEdit'),'Enable','on')  
end


% ------------------- imptabedit ---------------------
function imptabedit
global Imported Tempset

%disp('---- imptabedit ----')

dat=zz_tabletool('getlastcell','ImpExpTab');
selcmp=dat.rowindex;
varname=getvarname;
boxno=find(cell2mat(zz_tabletool('getcol','BoxListTab',1)));

n_chroms=length(Imported(boxno).filenames);
code=Tempset.allcodes{selcmp};
codes=Imported(boxno).cmp_code;
cmpind=strmatch(code,codes);

if ~isempty(cmpind)
    % New value
    if strncmpi(dat.datatype,'numeric',3)
        chrno=(dat.colindex)/2;
        Imported(boxno).(varname)(cmpind,chrno)=dat.val;
    end
    % Selection on/off
    if strncmpi(dat.datatype,'logical',3)
        chrno=(dat.colindex+1)/2;
        % Sets to zero if corresponding value=NaN
        if isnan(Imported(boxno).(varname)(cmpind,chrno)) && dat.val==1
            dat.val=0;
            arg2.rowindex=dat.rowindex;
            arg2.colindex=dat.colindex;
            arg2.val=dat.val;
            zz_tabletool('setcell','ImpExpTab',arg2);
        end
        Imported(boxno).Selected.(varname)(cmpind,chrno)=dat.val;
    end

    % Updates mean
    meanvalues(boxno); % Calculates new meanvalues
    newmean=Imported(boxno).([varname '_exp'])(cmpind);
    arg2.rowindex=dat.rowindex;
    arg2.colindex=n_chroms*2+1;
    arg2.val=newmean;
    % Updates table
    zz_tabletool('setcell','ImpExpTab',arg2);
end

% ------------------- assign2 ---------------------
function assign
global Imported Design
% Addigns values to Imported
% Columns with all NaNs are omitted

T=zz_tabletool('getall','AssignTab');
Data=T.Data; Data(:,1:2)=[];
paramnames=T.ColumnName; paramnames(1:2)=[];
colindex=T.lastedit_colindex;
rowindex=T.lastedit_rowindex;
colform=T.ColumnFormat;
if iscell(colform{2})
    choices=colform{2};
end

if colindex==2
    selind=strmatch(T.lastedit_value,choices)-1;
    npar=numel(Design.paramnames);
    rowdata=T.Data(rowindex,:);
    if selind==0
        for x=1:npar
            tcind=strmatch(Design.paramnames{x},paramnames);
            Data{rowindex,tcind}=NaN;
            rowdata{tcind+2}=NaN;
        end
        Imported(rowindex).color=[0.5 0.5 0.5];
    else
        for x=1:npar
            tcind=strmatch(Design.paramnames{x},paramnames);
            Data{rowindex,tcind}=Design.parameters(selind,x);
            rowdata{tcind+2}=Design.parameters(selind,x);
        end
        Imported(rowindex).color=Design.colormatrix(selind,:);
    end
    arg2.rowindex=rowindex;
    arg2.val=rowdata;
    zz_tabletool('setrow','AssignTab',arg2);   
    Imported(rowindex).designpoint=selind;    
end

if ~isempty(Data)
    for bno=1:numel(Imported)
        Imported(bno).paramnames=paramnames;
        Imported(bno).parameters=cell2mat(Data(bno,:));
    end
end


% ------------------- getdesigns ---------------------
function getdesigns
global Metset Locset

pathname=[Locset.path_designs filesep Metset.path_designs filesep 'design_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        designnames{x}=DD(x).name(8:length(DD(x).name)-4);
    end   
    DesignFilesPop=findobj(gcf,'Tag','DesignFilesPop');
    set(DesignFilesPop,'String',designnames)   
end

% ------------------- getexperiments ---------------------
function getexperiments
global Metset Locset

pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_*.mat'];
DD=dir(pathname);

if ~isempty(DD)
    for x=1:length(DD)
        expnames{x}=DD(x).name(5:length(DD(x).name)-4);
    end   
    SavedExperimentsPop=findobj(gcf,'Tag','SavedExperimentsPop');
    set(SavedExperimentsPop,'String',expnames)   
end

% ------------------- savedata ---------------------
function savedata
global Imported Tempset Metset Locset

%disp('--- oo_readdata/savedata ---')

Experimental=[];

if ~isempty(Imported)
    
    fn=fieldnames(Imported);
    exportfields=[]; n_exports=0;
    for fnno=1:length(fn)
        if strfind(fn{fnno},'_exp')
            n_exports=n_exports+1;
            exportfields{n_exports}=fn{fnno};
        end
    end

    allcodes=Tempset.allcodes;
    for varno=1:length(exportfields)  
        for cmpno=1:length(allcodes)
            currentcode=allcodes{cmpno};   
            for boxno=1:length(Imported)
                Experimental.(exportfields{varno})(cmpno,boxno)=NaN;
                ind=strmatch(currentcode,Imported(boxno).cmp_code);
                if ~isempty(ind) && ~isempty(Imported(boxno).(exportfields{varno})) && ~isnan(Imported(boxno).([exportfields{varno}])(ind))
                    Experimental.(exportfields{varno})(cmpno,boxno)=Imported(boxno).(exportfields{varno})(ind);
                end
            end
        end
    end
    
    for boxno=1:length(Imported)
        if isfield(Imported,'parameters') && ~isempty(Imported(boxno).parameters)
            Experimental.parameters(:,boxno)=Imported(boxno).parameters;
            Experimental.paramnames{boxno}=Imported(boxno).paramnames;
            if ~isempty(Imported(boxno).color)
                Experimental.color(:,boxno)=Imported(boxno).color;
            else
                Experimental.color(:,boxno)=[0 0 0];
            end
        else
            Experimental.parameters(:,boxno)=NaN;
            Experimental.paramnames{boxno}=[];
            Experimental.color(:,boxno)=[0 0 0];                     
        end
    end  
end

if isempty(Experimental)
    zz_message(1,'No data','-r')
else
    
    for expno=1:length(Imported)
        Experimental.expname{expno}=Imported(expno).boxname;
        Experimental.designpoint(expno)=Imported(expno).designpoint;
    end
    
    Experimental.codes=Tempset.allcodes;
    Experimental.names=Tempset.allnames;
    Experimental.shortnames=Tempset.allshortnames;

    FileNameEdit=findobj(gcf,'Tag','FileNameEdit');
    filename=get(FileNameEdit,'String');
    
    pathname=[Locset.path_experiments filesep Metset.path_experiments filesep 'exp_' filename ];
    
    oo_savefile(pathname,Experimental,Imported,Metset)

end


% ------------------- meanvalues ---------------------
function meanvalues(boxnumbers)
global Imported Tempset

parameters=[{'rt'},{'ri'},{'wbl'},{'wbl_ri'},{'area'},{'height'},{'responsefactor'}];
allcodes=Tempset.allcodes;

for boxes=1:length(boxnumbers)
    boxno=boxnumbers(boxes);
    for cmpno=1:length(allcodes)
        currentcode=allcodes{cmpno};
        ind=strmatch(currentcode,Imported(boxno).cmp_code);
        if ~isempty(ind) 
            for varno=1:length(parameters)
                varnam=parameters{varno};
                if isfield(Imported(boxno),varnam) && ~isempty(Imported(boxno).(varnam))                  
                    meanvarnam=[varnam '_exp'];
                    %disp(['--- ----' varnam])
                    values=Imported(boxno).(varnam)(ind,:);
                    useind=find(Imported(boxno).Selected.(varnam)(ind,:));
                    Imported(boxno).(meanvarnam)(ind,1)=mean(values(useind));
                end
            end
        end  
    end
end
    

% ------------------- Exportlist2 ---------------------
function exportlist2
global Imported Tempset Pos

set(findobj(gcf,'Tag','BoxDataRadio'),'Value',0)
set(findobj(gcf,'Tag','ExportDataRadio'),'Value',1)

parameterlist

if zz_tabletool('Exist','ImpExpTab')==1
    zz_tabletool('Delete','ImpExpTab');
end

set(findobj(gcf,'Tag','BoxDataRadio'),'Value',0,'String','Data for box')
set(findobj(gcf,'Tag','ExportDataRadio'),'Value',1)

T.Data=[];

if ~isempty(Imported)
    
    %CompoundList=findobj(gcf,'Tag','CompoundList');
    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1); 
    codestr=get(CodeRadio,'String');

    if isempty(codestr) 
        codestr='Code'; set(findobj(gcf,'Tag','CodeRadio','String','Code'),'Value',1);
    end
    CodeCheck=findobj(gcf,'Tag','CodeRadio','String','Code'); usecodes=get(CodeCheck,'Value');
    NameCheck=findobj(gcf,'Tag','CodeRadio','String','Name'); usenames=get(NameCheck,'Value');
    ShortNameCheck=findobj(gcf,'Tag','CodeRadio','String','Short Name'); useshortnames=get(ShortNameCheck,'Value');

    DataTypeList=findobj(gcf,'Tag','DataTypeList'); 
    str=get(DataTypeList,'String'); 
    val=get(DataTypeList,'Value'); 

    cform='str'; variab=''; 
    parameter=str{val};
    if strcmp(parameter,'Retention time (RT)') variab='rt'; cform='%6.3f'; end
    if strcmp(parameter,'Retention index (RI)') variab='ri'; cform='%6.4f'; end
    if strcmp(parameter,'Peak width (RT units)') variab='wbl'; cform='%6.4f'; end
    if strcmp(parameter,'Peak width (RI units)') variab='wbl_ri'; cform='%6.5f'; end
    if strcmp(parameter,'Area') variab='area'; cform='%8.2f'; end
    if strcmp(parameter,'Height') variab='height'; cform='%8.2f'; end
    if strcmp(parameter,'Response factor') variab='responsefactor'; cform='%2.4f'; end

    DM=repmat(NaN,length(Tempset.allcodes),length(Imported));

    for cmpno=1:length(Tempset.allcodes)   
        for boxno=1:length(Imported)
            currentcode=Tempset.allcodes{cmpno};
            ind=strmatch(currentcode,Imported(boxno).cmp_code);
            if ~isempty(ind) && ~isempty(Imported(boxno).([variab '_exp'])) && ~isnan(Imported(boxno).([variab '_exp'])(ind))
                DM(cmpno,boxno)=Imported(boxno).([variab '_exp'])(ind);
            end
        end
    end

    if usecodes==1 T.RowName=Tempset.allcodes; end
    if usenames==1 T.RowName=Tempset.allnames; end
    if useshortnames==1 T.RowName=Tempset.allshortnames; end


    T.Data=num2cell(DM);
    T.ColumnEditable=ones(1,length(Imported));

    for x=1:length(Imported)
        T.ColumnEditable(x)=1;
        T.ColumnFormat{x}=cform;
        T.ColumnName{x}=['Box ' num2str(x)];
        T.ColumnWidth{x}=70;
    end
end

T.AllowNan=1;
T.TableName='ImpExpTab';
T.ViewPref=1;
T.Position=[Pos.xg(6) Pos.yg(10) 1-Pos.xg(6)-Pos.xg(1) Pos.gh*13];
T.CellEditCallback='oo_readdata(9.3)';

zz_tabletool('Create',T);


% ------------------- Compoundlist2 ---------------------
function compoundlist2
global Imported Tempset Pos

% update parameterlist
set(findobj(gcf,'Tag','BoxDataRadio'),'Value',1)
set(findobj(gcf,'Tag','ExportDataRadio'),'Value',0)
parameterlist

DataTypeList=findobj(gcf,'Tag','DataTypeList');

if ~isempty(Imported)
    set(findobj(gcf,'Tag','BoxDataRadio'),'String',['Data for box ' Imported(Tempset.selbox).boxname])
end

% Delete existing table
if zz_tabletool('Exist','ImpExpTab')==1
    zz_tabletool('Delete','ImpExpTab');
end

T.Data=[]; boxname='';
if ~isempty(Imported) && strcmp(get(DataTypeList,'Enable'),'on')

    allcodes=Tempset.allcodes;
    currentbox=Tempset.selbox;

    CodeRadio=findobj(gcf,'Tag','CodeRadio','Value',1); codestr=get(CodeRadio,'String');
    if isempty(codestr) 
        codestr='Code'; set(findobj(gcf,'Tag','CodeRadio','String','Code'),'Value',1);
    end
    CodeCheck=findobj(gcf,'Tag','CodeRadio','String','Code'); usecodes=get(CodeCheck,'Value');
    NameCheck=findobj(gcf,'Tag','CodeRadio','String','Name'); usenames=get(NameCheck,'Value');
    ShortNameCheck=findobj(gcf,'Tag','CodeRadio','String','Short Name'); useshortnames=get(ShortNameCheck,'Value');
 
    str=get(DataTypeList,'String'); 
    val=get(DataTypeList,'Value');

    cform='str'; variab=''; 
    parameter=str{val}; 
    if strcmp(parameter,'Retention time (RT)') variab='rt'; cform='%6.3f'; end
    if strcmp(parameter,'Retention index (RI)') variab='ri'; cform='%6.4f'; end
    if strcmp(parameter,'Peak width (RT units)') variab='wbl'; cform='%6.4f'; end
    if strcmp(parameter,'Peak width (RI units)') variab='wbl_ri'; cform='%6.5f'; end
    if strcmp(parameter,'Area') variab='area'; cform='%8.2f'; end
    if strcmp(parameter,'Height') variab='height'; cform='%8.2f'; end
    if strcmp(parameter,'Response factor') variab='responsefactor'; cform='%2.4f'; end

    n_chroms=length(Imported(currentbox).filenames);

    VM=repmat(NaN,length(allcodes),n_chroms);
    SM=repmat(0,length(allcodes),n_chroms);
    expvals=repmat(NaN,length(allcodes),1);
    
    for cmpno=1:length(allcodes)
        currentcode=allcodes{cmpno};
    
        ind=strmatch(currentcode,Imported(currentbox).cmp_code);
        if ~isempty(ind) && ~isempty(variab)
            
            vals=Imported(currentbox).(variab)(ind,:);
            for valno=1:length(vals)
                VM(cmpno,valno)=vals(valno);               
                if Imported(currentbox).Selected.(variab)(ind,valno)
                    SM(cmpno,valno)=1;
                else
                    SM(cmpno,valno)=0;
                end
            end
            expvals(cmpno)=Imported(currentbox).([variab '_exp'])(ind);
        end
    end

    cno=0;
    for x=1:n_chroms
        cno=cno+1; T.Data(:,cno)=SM(:,x);
        T.ColumnFormat{cno}='logical'; T.ColumnName{cno}=['Chr.' num2str(x)]; T.ColumnWidth{cno}=40;
        T.ColumnEditable(cno)=1;
    
        cno=cno+1; T.Data(:,cno)=VM(:,x); T.ColumnName{cno}=['Chrom.' num2str(x)]; T.ColumnWidth{cno}=80;
        T.ColumnFormat{cno}=cform; 
        T.ColumnEditable(cno)=1;    

    end
    cno=cno+1;
    T.Data(:,cno)=expvals;
    T.ColumnFormat{cno}=cform;
    T.ColumnEditable(cno)=0;
    T.ColumnName{cno}='Exp.Val.';

    if usecodes==1 T.RowName=Tempset.allcodes; end
    if usenames==1 T.RowName=Tempset.allnames; end
    if useshortnames==1 T.RowName=Tempset.allshortnames; end
    
end

T.ViewPref=1;
T.Position=[Pos.xg(6) Pos.yg(10) 1-Pos.xg(6)-Pos.xg(1) Pos.gh*13]; 
T.CellEditCallback='oo_readdata(9.2)';
T.AllowNan=1;
T.TableName='ImpExpTab';

zz_tabletool('Create',T);


% ------------------- BOXLIST2 ---------------------
function boxlist2
global Imported Tempset Pos

%disp('---- boxlist2 ----')

if zz_tabletool('Exist','BoxListTab')==1
    zz_tabletool('Delete','BoxListTab');
end

Data=[]; 
if numel(Imported)>0
    if ~isfield(Tempset,'selbox') || Tempset.selbox==0 Tempset.selbox=1; end
    for boxno=1:numel(Imported)
        Data{boxno,1}=false;
        Data{boxno,2}=Imported(boxno).boxname;
    end
    Data{Tempset.selbox,1}=true;
end

T.Data=Data;
T.ViewPref=1;
T.Position=[Pos.xg(4) Pos.yg(17) Pos.gw+Pos.bw Pos.gh*6];
T.CellEditCallback='oo_readdata(3.2)';
T.AllowNan=1;
T.TableName='BoxListTab';
T.ColumnFormat={'excl_logical','string'};
T.ColumnEditable=[1 1];
T.ColumnWidth={30,200};
T.ColumnName={'Sel.','Box Name'};
T.RowName='numeric';
T.ListSelCol=1;
T.RowNamesWidth=25;
T.HorizontalExpansion=1;

zz_tabletool('Create',T);


% ------------------- CHROMLIST ---------------------
function chromlist
global Imported Tempset Pos

%disp('---- chromlist ----')

if ~isfield(Tempset,'selbox') || Tempset.selbox==0 Tempset.selbox=1; end

boxno=Tempset.selbox;

T.Data=[];
if ~isempty(Imported)
    for fileno=1:length(Imported(boxno).filenames)
        T.Data{fileno,1}=false;
        T.Data{fileno,2}=Imported(boxno).filenames{fileno};
    end   
end

T.ViewPref=1;
T.Position=[Pos.xg(4) Pos.yg(10) Pos.gw+Pos.bw Pos.gh*6];
T.CellEditCallback='oo_readdata(3.1)';
T.AllowNan=1;
T.TableName='ChromListTab';
T.ColumnFormat={'logical','string'};
T.ColumnEditable=[1 1];
T.ColumnWidth={30,200};
T.ColumnName={'Sel.','Chrom. Name'};
T.RowName='numeric';
T.RowNamesWidth=25;
T.HorizontalExpansion=1;

if zz_tabletool('exist','ChromListTab') zz_tabletool('delete','ChromListTab'); end
zz_tabletool('Create',T);
  

% ------------------- PARAMETERLIST ---------------------
function parameterlist
global Imported Tempset

DataTypeList = findobj(gcf,'Tag','DataTypeList');

% Get current variable
Cstr = get(DataTypeList,'String');
cvar = Cstr(get(DataTypeList,'Value'));
if iscell(cvar) cvar = cvar{1}; end

tstr=cell(0);
tstr{numel(tstr)+1}='Retention time (RT)'; fstr{numel(tstr)}='rt';
tstr{numel(tstr)+1}='Retention index (RI)'; fstr{numel(tstr)}='ri';
tstr{numel(tstr)+1}='Peak width (RT units)'; fstr{numel(tstr)}='wbl';
tstr{numel(tstr)+1}='Peak width (RI units)'; fstr{numel(tstr)}='wbl_ri';
tstr{numel(tstr)+1}='Area'; fstr{numel(tstr)}='area';
tstr{numel(tstr)+1}='Height'; fstr{numel(tstr)}='height';
tstr{numel(tstr)+1}='Response factor'; fstr{numel(tstr)}='responsefactor';

hasvals=[];
for boxno=1:numel(Imported)
    for fno=1:numel(tstr)
        if isfield(Imported(boxno),fstr{fno})
            hasvals(boxno,fno) = ~isempty(Imported(boxno).(fstr{fno}));
        else
            hasvals(boxno,fno) = false;
        end
    end
end

if get(findobj(gcf,'Tag','ExportDataRadio'),'Value') 
    % Export data
    hasvals=any(hasvals); 
else
    % Box data
    if ~isempty(hasvals)
        hasvals=hasvals(Tempset.selbox,:); 
    end
end

dstr=tstr(find(hasvals));
if isempty(dstr)
    set(DataTypeList,'String','No data','Enable','off','Value',1)
else      
    % Set selection based on previous state
    cval=find(strcmp(cvar,dstr)); 
    if ~isempty(cval)
        cval=cval(1);
        set(DataTypeList,'String',dstr,'Enable','on','Value',cval)
    else
        set(DataTypeList,'String',dstr,'Enable','on','Value',1)
    end     
end


% ------------------- READDATA2 ---------------------
function readdata2
global Imported Tempset

Data=zz_tabletool('getdata','FilesListTab');
if isempty(Data) zz_message(1,'No files','-r'); return; end

sel=find(cell2mat(Data(:,1)));
if isempty(sel) zz_message(1,'No files selected','-r'); return; end
Data=Data(sel,:);

% Exclude files with no results
nsub=cell2mat(Data(:,4)); valids=find(nsub>0); Data=Data(valids,:);
if isempty(Data) zz_message(1,'No valid files selected','-r'); return; end

ReadTypePop=findobj(gcf,'Tag','ReadTypePop'); readval=get(ReadTypePop,'Value'); % Type of import
if readval>4 zz_message(1,'Read mode not implemented','-r'); return; end

% Read new data
PathEdit=findobj(gcf,'Tag','PathEdit'); pathstr=get(PathEdit,'String');

zz_message(1,'--','-l -nd')
zz_message(1,['Importing ' num2str(numel(sel)) ' files'],'-l -nd')

for fileno=1:numel(sel)
    
    if strcmp(Data(fileno,3),'Chrombox C')
        filename=['res_' Data{fileno,2} '.mat'];
        S=load([pathstr filesep filename]);
        Databox=S.Databox;        
        Outdata=getdata_C(Databox);
        if isempty(Outdata.cmp_code)
            zz_message(1,['WARNING: Chrombox C box ' num2str(sel(fileno)) ' (' Data{fileno,2} ') had no identified compounds'],'-lw -nd')
        end
    end

    if strcmp(Data(fileno,3),'Chrombox Q') 
        filename=['res_' Data{fileno,2} '.mat'];
        S=load([pathstr filesep filename]);
        RE=S.RE;
        Outdata=getdata_Q(RE);
        Outdata.filenames=Data(fileno,2);
    end
    
    if strcmp(Data(fileno,3),'Excel xls') 
        Outdata=getdata_excel([pathstr filesep Data{fileno,2} '.xls']);
    end
       
    if strcmp(Data(fileno,3),'Excel xlsx') 
        Outdata=getdata_excel([pathstr filesep Data{fileno,2} '.xlsx']);
    end   
   
    Newdata{fileno}=Outdata; % Puts the outdata struct for each file as cell in newdata;
              
end

% Assign new data
n_boxes=numel(Imported); % Existing boxes

% Normal import Keep boxes of Chrombox C, Chrombox Q in separate boxes
if readval==1
    for fileno=1:numel(Newdata)
        Outdata=Newdata{fileno};
        fn=fieldnames(Outdata);
        for x=1:numel(fn)
            Imported(fileno+n_boxes).(fn{x})=Outdata.(fn{x});
        end 
        Imported(fileno+n_boxes).boxname=Data{fileno,2};
        Imported(fileno+n_boxes).designpoint=0;
    end
end

% Split Subfiles
if readval==2
    nnew=0;
    for fileno=1:numel(Newdata)
        Tempdata=splitdata(Newdata{fileno});
        for subno=1:numel(Tempdata)
            nnew=nnew+1;
            Outdata=Tempdata(subno);
            fn=fieldnames(Outdata);
            for x=1:numel(fn)
                Imported(nnew+n_boxes).(fn{x})=Outdata.(fn{x});
            end
            Imported(nnew+n_boxes).boxname=Outdata.filenames{1};
            Imported(nnew+n_boxes).designpoint=0;            
        end
    end
end

% All files to same box (code continues below)
if readval==3
    boxno=n_boxes+1;
    if numel(Newdata)==1 
        boxname=Data{fileno,2}; 
    else
        boxname='NEWBOX_COMB';
    end
    designpoint=0;
end

% Append to selected box (code continues below)
if readval==4
    if numel(Imported)<1 zz_message(1,'No box to append to','-r'); return; end
    
    boxno=Tempset.selbox;
    boxname=Imported(Tempset.selbox).boxname;
    designpoint=Imported(Tempset.selbox).designpoint;

    % Existing data to keep
    oldfields=fieldnames(Imported(Tempset.selbox)); 
    ind=strmatch('Selected',oldfields);
    delfields=oldfields(ind+1:end);
    Exdata=rmfield(Imported(Tempset.selbox),delfields);
    
    % Create Newdata including Existing as dataset 1
    Tempdata{1}=Exdata;
    for x=1:numel(Newdata)
        Tempdata{1+x}=Newdata{x};
    end
    Newdata=Tempdata;
end

% All to new box or append to selected
if (readval==3 || readval==4) && ~isempty(Newdata{fileno})
    disp('----- if 5 -------')
    % find dimensions of Newdata and Codes
    allcodes=cell(0); allfields=cell(0); allfilenames=cell(0);
    for fileno=1:numel(Newdata)
        codes=Newdata{fileno}.cmp_code;
        allcodes(numel(allcodes)+1:numel(allcodes)+numel(codes))=deal(codes(1:numel(codes)));
        fields=fieldnames(Newdata{fileno});
        allfields(numel(allfields)+1:numel(allfields)+numel(fields))=deal(fields(1:numel(fields)));
        filenames=Newdata{fileno}.filenames;
        allfilenames(numel(allfilenames)+1:numel(allfilenames)+numel(filenames))=deal(filenames(1:numel(filenames)));
    end    
    % Remove general fields
    fn={'filenames','cmp_code','cmp_name','cmp_shortname','Selected'};
    for x=1:numel(fn) ind=strmatch(fn{x},allfields); allfields(ind)=[]; end
    
    % Unique fields and codes:
    allcodes=unique(allcodes);
    allfields=unique(allfields);
    
    % Initial matrix for numeric values
    initmat=repmat(NaN,numel(allcodes),numel(allfilenames));
    
    % Initialization
    %boxno=numel(Imported)+1; 
    nnew=0;
    Imported(boxno).filenames=cell(0); Imported(boxno).cmp_code=allcodes; Imported(boxno).cmp_name=cell(0); Imported(boxno).cmp_shortname=cell(0); 
    for x=1:numel(allfields) Imported(boxno).(allfields{x})=initmat; end  
    
    % Fill in names and shortnames
    for fileno=1:numel(Newdata)      
        codes=Newdata{fileno}.cmp_code;
        
        for codeno=1:numel(codes)
            cind=strmatch(codes{codeno},allcodes); % index referring to new matrix
            Imported(boxno).cmp_name{cind}=Newdata{fileno}.cmp_name{codeno};
            Imported(boxno).cmp_shortname{cind}=Newdata{fileno}.cmp_shortname{codeno};
        end
        
        % File names and data
        for chrno=1:numel(Newdata{fileno}.filenames)
            nnew=nnew+1;
            % Fill inn filenames 
            Imported(boxno).filenames{nnew}=Newdata{fileno}.filenames{chrno};
            
            % Fill inn data
            for fieldno=1:numel(allfields)
                if isfield(Newdata{fileno},allfields{fieldno}) && isnumeric(Newdata{fileno}.(allfields{fieldno}))
                    
                    % Check for size of matrix
                    [n_rows,n_col]=size(Newdata{fileno}.(allfields{fieldno}));

                    for codeno=1:numel(codes)
                        cind=strmatch(codes{codeno},allcodes); % index referring to new matrix
                        if codeno<=n_rows && chrno<=n_col
                            Imported(boxno).(allfields{fieldno})(cind,nnew)=Newdata{fileno}.(allfields{fieldno})(codeno,chrno);
                        end
                    end   
                end
            end

        end

    end
    
    % Check for all empties
    for fieldno=1:numel(allfields)
        if numel(Imported(boxno).(allfields{fieldno})) == sum(sum(isnan(Imported(boxno).(allfields{fieldno}))))
            Imported(boxno).(allfields{fieldno})=[];
        end
    end

    Imported(boxno).boxname=boxname;
    Imported(boxno).designpoint=designpoint;    
  
end

zz_message(1,'--','-l -nd')
zz_message(9)

% ------------------- SPLITDATA ---------------------
function Splitout=splitdata(Indata)

Splitout=[];

if isempty(Indata) return; end

nfiles=numel(Indata.filenames);
if nfiles<2 Splitout=Indata; return; end

Selected=Indata.Selected;

for x=1:nfiles
    Splitout(x).filenames=Indata.filenames(x);
    Splitout(x).cmp_code=Indata.cmp_code;
    Splitout(x).cmp_name=Indata.cmp_name;
    Splitout(x).cmp_shortname=Indata.cmp_shortname;
end

fn={'filenames','cmp_code','cmp_name','cmp_shortname','Selected'};
for x=1:numel(fn)
    if isfield(Indata,fn{x}) 
        Indata=rmfield(Indata,fn{x});
    end
end

% Move data fields
fn=fieldnames(Indata);
for x=1:numel(fn)
    [Splitout(1:nfiles).(fn{x})]=deal([]);
    [m,ncol]=size(Indata.(fn{x}));
    if ncol>0 && isnumeric(Indata.(fn{x}))
        for fno=1:ncol
            Splitout(fno).(fn{x})=Indata.(fn{x})(:,fno);
        end 
    end
end

% Move Selected
fn=fieldnames(Selected);
for x=1:numel(fn)
    for f=1:nfiles
        Splitout(f).Selected.(fn{x})=[];
    end
    [m,ncol]=size(Selected.(fn{x}));
    if ncol>0 && isnumeric(Selected.(fn{x}))
        for fno=1:ncol
            Splitout(fno).Selected.(fn{x})=Selected.(fn{x})(:,fno);
        end 
    end
end


% ------------------- GETDATA_Q ---------------------
function Outdata=getdata_Q(RE)

Outdata=[];

codes=[]; shortnames=[]; names=[]; rt=[]; ri=[]; area=[]; wbl=[]; wbl_ri=[]; %height=[]; %responsefactor=[]; 
cmpno=0; selected=[];
for pno=1:length(RE)
    
    if isfield(RE,'identified') && ~isempty(RE(pno).identified) && RE(pno).identified==1
        cmpno=cmpno+1;
        
        rt(cmpno,1)=NaN; selected.rt(cmpno,1)=0;
        ri(cmpno,1)=NaN; selected.ri(cmpno,1)=0;
        area(cmpno,1)=NaN; selected.area(cmpno,1)=0;
        wbl(cmpno,1)=NaN; selected.wbl(cmpno,1)=0;
        wbl_ri(cmpno,1)=NaN; selected.wbl_ri(cmpno,1)=0;
        %height(cmpno,1)=NaN; selected.height(cmpno,1)=0;
        %responsefactor(cmpno,1)=NaN; selected.responsefactor(cmpno,1)=0;
               
        codes{1,cmpno}='-'; shortnames{1,cmpno}='-'; names{1,cmpno}='-';
                     
        if isfield(RE,'rt') && ~isempty(RE(pno).rt)
            rt(cmpno,1)=RE(pno).rt;
            selected.rt(cmpno,1)=1;
        end
        if isfield(RE,'ri_calc') && ~isempty(RE(pno).ri_calc)
            ri(cmpno,1)=RE(pno).ri_calc;
            selected.ri(cmpno,1)=1;
        end        
        if isfield(RE,'area') && ~isempty(RE(pno).area)
            area(cmpno,1)=RE(pno).area;
            selected.area(cmpno,1)=1;
        end  
        if isfield(RE,'whh') && ~isempty(RE(pno).whh)
            wbl(cmpno,1)=RE(pno).whh*2.355;
            selected.wbl(cmpno,1)=1;           
        end 
        if isfield(RE,'whh_ri') && ~isempty(RE(pno).whh_ri)
            wbl_ri(cmpno,1)=RE(pno).whh_ri*2.355;
            selected.wbl_ri(cmpno,1)=1;   
        end        
        if isfield(RE,'cas_nr') && ~isempty(RE(pno).cas_nr) % For old Q format
            codes{1,cmpno}=RE(pno).cas_nr;
        end 
        if isfield(RE,'cmp_code') && ~isempty(RE(pno).cmp_code) % For new Q format
            codes{1,cmpno}=RE(pno).cmp_code;
        end 
        if isfield(RE,'compound_code') && ~isempty(RE(pno).compound_code) % For old Q format
            shortnames{1,cmpno}=RE(pno).compound_code;
        end  
        if isfield(RE,'cmp_shortname') && ~isempty(RE(pno).cmp_shortname) % For new Q format
            shortnames{1,cmpno}=RE(pno).cmp_shortname;
        end  
        if isfield(RE,'compound_name') && ~isempty(RE(pno).compound_name) % For old Q format
            names{1,cmpno}=RE(pno).compound_name;
        end
        if isfield(RE,'cmp_name') && ~isempty(RE(pno).cmp_name) % For new Q format
            names{1,cmpno}=RE(pno).cmp_name;
        end  
    end
end

Outdata.filenames={'-'};
Outdata.cmp_code=codes;
Outdata.cmp_name=names;
Outdata.cmp_shortname=shortnames;
Outdata.rt=rt;
Outdata.ri=ri;
Outdata.wbl=wbl;
Outdata.wbl_ri=wbl_ri;
Outdata.area=area;
%Outdata.height=height;
%Outdata.responsefactor=responsefactor;
Outdata.Selected=selected;


% ------------------- GETDATA_EXCEL ---------------------
function Outdata=getdata_excel(pname)
% Reads data to excel
% Variable names in first row
% Object names in first column

Outdata=[]; Selected=[];

[status,sheets]=xlsfinfo(pname);
[fpath,fnam,fext]=fileparts(pname);

sheetno=0;
for x=1:numel(sheets)
     
    [num,txt,raw] = xlsread(pname,sheets{x});
    if isempty(num)
        continue
    else

        sheetno=sheetno+1;
        
        Outdata.filenames{sheetno}=sheets{x};
        
        Textvals{sheetno}=txt;
        Rawvals{sheetno}=raw;

        %Set Info
        Info.samplename=sheets{sheetno};
        Info.originalsource_fullpath='';
        Info.originalsource=['Excel file ' pname ', Sheet' sheets{x}];
        Info.acqmethod='';
        Info.operator='';
        Info.xscaleunit='';
        Info.yscaleunit='';
        Info.imported_as=['Excel ' fext];
        Outdata.Info{sheetno}=Info;
    end
end

% Get fields
finam=cell(0);
for x=1:numel(Textvals)
    txt=Textvals{x};
    for y=1:numel(txt(1,:))
        finam{numel(finam)+1}=strtrim(txt{1,y});
    end
end
finam=unique(finam);
validfields={'rt','ri','wbl','wbl_ri','area','height','responsefactor'};
lia = ismember(finam,validfields);
finam=finam(lia);

if isempty(finam) % No valid fields found
    Outdata=[];
    zz_message(1,'No valid variable names in file','-r')
    return; 
end 

if isempty(finam)
    zz_message(1,'No valid fields found','-r')
end

% Get object names
obnam=cell(0);
for x=1:numel(Textvals)
    txt=Textvals{x};
    for y=1:numel(txt(:,1))
        obnam{numel(obnam)+1}=strtrim(txt{y,1});
    end
end
obnam=unique(obnam);
delind=cellfun('isempty',obnam);
obnam(delind)=[];

Outdata.cmp_code=obnam;
Outdata.cmp_name=obnam;
Outdata.cmp_shortname=obnam;

% Create NaN-matrix
nanmat=repmat(NaN,numel(obnam),sheetno);
selmat=zeros(numel(obnam),sheetno);

% Fill inn data
for fino=1:numel(finam)
    
    % Matrixes to be modified and added to Outdata
    od_valmat=nanmat; 
    od_selmat=selmat;
    
    for sheetno=1:numel(Textvals)
        txt=Textvals{sheetno}; % txt is cell
        % Get fields
        lfields=txt(1,:);
        for ii=1:numel(lfields)
            lfields{ii}=strtrim(lfields{ii});
        end
        
        fieldind=find(strcmp(finam(fino),lfields));
        if isempty(fieldind) continue; end
        
        raw=Rawvals{sheetno}; % raw is cell
        
        % get objects
        lobj=txt(:,1);
        for ii=1:numel(lobj)
            lobj{ii}=strtrim(lobj{ii});
        end
        
        for obno=1:numel(obnam)
            obind=find(strcmp(obnam(obno),lobj));
            if ~isempty(obind)
                od_valmat(obno,sheetno)=raw{obind,fieldind};
                od_selmat(obno,sheetno)=1;
            end
        end
    end
    
    Outdata.(finam{fino})=od_valmat;
    Selected.(finam{fino})=od_selmat;

end

Outdata.Selected=Selected;


% ------------------- GETDATA_C ---------------------
function Outdata=getdata_C(Databox)

% disp('--- getdata C ---')

Outdata=[]; names=[]; shortnames=[];

% Finds all codes
n_files=length(Databox);
allcodes=[];
for fno=1:n_files
    filenames{fno}=Databox(fno).file_name;
    % STORES THE INFO FIELD, CURRENTLY NOT USED % TEMP
    if isfield(Databox,'Info') && ~isempty(Databox(fno).Info)
        Info{fno}=Databox(fno).Info;
    else
        Info{fno}=[];
    end
    Peakdata=Databox(fno).Peakdata;
    n_peaks=length(Peakdata);
    if isfield(Peakdata,'cmp_code')
        for pno=1:n_peaks
            code=Peakdata(pno).cmp_code;
            if ~isempty(code)
                ind = strmatch(code,allcodes);
                if isempty(ind)
                    ind=length(allcodes)+1;
                    allcodes{ind}=code;
                    shortnames{ind}=Peakdata(pno).cmp_shortname;
                    names{ind}=Peakdata(pno).cmp_name;
                end
            end
        end
    end
end
n_codes=length(allcodes);

% defines matrices
rt=repmat(NaN,n_codes,n_files); selected.rt=zeros(n_codes,n_files);
ri=repmat(NaN,n_codes,n_files); selected.ri=zeros(n_codes,n_files);
area=repmat(NaN,n_codes,n_files); selected.area=zeros(n_codes,n_files);
wbl=repmat(NaN,n_codes,n_files); selected.wbl=zeros(n_codes,n_files);
wbl_ri=repmat(NaN,n_codes,n_files); selected.wbl_ri=zeros(n_codes,n_files);
height=repmat(NaN,n_codes,n_files);  selected.height=zeros(n_codes,n_files);
responsefactor=repmat(NaN,n_codes,n_files); selected.responsefactor=zeros(n_codes,n_files);

for fno=1:n_files
    Peakdata=Databox(fno).Peakdata;
    n_peaks=length(Peakdata);    
    for pno=1:n_peaks
        if Peakdata(pno).identified==1     
            code=Peakdata(pno).cmp_code;
            ind = strmatch(code,allcodes);
            if isfield(Peakdata,'max_rt') && ~isempty(Peakdata(pno).max_rt)
                rt(ind,fno)=Peakdata(pno).max_rt;
                selected.rt(ind,fno)=1;                
            end           
            if isfield(Peakdata,'max_ri') && ~isempty(Peakdata(pno).max_ri)
                ri(ind,fno)=Peakdata(pno).max_ri;
                selected.ri(ind,fno)=1;      
            end
            if isfield(Peakdata,'area') && ~isempty(Peakdata(pno).area)
                area(ind,fno)=Peakdata(pno).area;
                selected.area(ind,fno)=1;  
            end 
            if isfield(Peakdata,'wbl') && ~isempty(Peakdata(pno).wbl)
                wbl(ind,fno)=Peakdata(pno).wbl;
                selected.wbl(ind,fno)=1;  
            end 
            if isfield(Peakdata,'wbl_ri') && ~isempty(Peakdata(pno).wbl_ri)
                wbl_ri(ind,fno)=Peakdata(pno).wbl_ri;
                selected.wbl_ri(ind,fno)=1;  
            end                    
            if isfield(Peakdata,'height') && ~isempty(Peakdata(pno).height)
                height(ind,fno)=Peakdata(pno).height;
                selected.height(ind,fno)=1;  
            end 
            if isfield(Peakdata,'responsefactor') && ~isempty(Peakdata(pno).responsefactor)
                responsefactor(ind,fno)=Peakdata(pno).responsefactor;
                selected.responsefactor(ind,fno)=1;               
            end                        
        end    
    end
end

% Checks for empties
if isempty(find(~isnan(rt))) rt=[]; selected.rt=[]; end
if isempty(find(~isnan(area))) area=[]; selected.area=[]; end
if isempty(find(~isnan(height))) height=[]; selected.height=[]; end
if isempty(find(~isnan(wbl))) wbl=[]; selected.wbl=[]; end
if isempty(find(~isnan(wbl_ri))) wbl_ri=[]; selected.wbl_ri=[]; end
if isempty(find(~isnan(ri))) ri=[]; selected.ri=[]; end
if isempty(find(~isnan(responsefactor))) responsefactor=[]; selected.responsefactor=[]; end

% Sets Outdata
Outdata.filenames=filenames;
Outdata.Info=Info;
Outdata.cmp_code=allcodes;
Outdata.cmp_name=names;
Outdata.cmp_shortname=shortnames;
Outdata.rt=rt;
Outdata.ri=ri;
Outdata.wbl=wbl;
Outdata.wbl_ri=wbl_ri;
Outdata.area=area;
Outdata.height=height;
Outdata.responsefactor=responsefactor;
Outdata.Selected=selected;


% ------------------- DIRUPDATE ---------------------
function dirupdate
global Metset %Locset

%disp('--- dirupdate ---')

PathEdit=findobj(gcf,'Tag','PathEdit');
pathstr=get(PathEdit,'String');
SearchStrEdit=findobj(gcf,'Tag','SearchStrEdit');
searchstr=get(SearchStrEdit,'String');
FilesList=findobj(gcf,'Tag','FilesList');

if isdir(pathstr)

    DD=dir([pathstr filesep searchstr]);

    if isempty(DD)
        set(PathEdit,'BackgroundColor',[1 1 0])
        zz_message(1,'Selected folder does not contain the chosen data type','-r')
        files='';
    else
        set(PathEdit,'BackgroundColor',[1 1 1])   
        for x=1:length(DD)
            fn=DD(x).name;
            if strcmp(Metset.import_filetype, 'Chrombox C')
                fn=fn(5:length(fn)-4);
            end
            if strcmp(Metset.import_filetype, 'Chrombox Q')
                fn=fn(5:length(fn)-4);
            end
           files{x}=fn;       
        end
        vals=get(FilesList,'Value');
        vals(find(vals>length(files)))=[];
        if isempty(vals) vals=1; end
        set(FilesList,'Value',vals);
    end

    set(FilesList,'String',files); 
    set(FilesList,'Value',1:numel(files));

else
    zz_message(1,'Selected folder does not exist','-r')
end


% ------------------- FILESLIST ---------------------
function fileslist
global Pos Locset Metset

PathEdit=findobj(gcf,'Tag','PathEdit');
pathstr=get(PathEdit,'String');
if isempty(pathstr) pathstr=[Locset.path_rawdata filesep Metset.path_rawdata]; end
if ~isdir(pathstr) pathstr=pwd; end
set(PathEdit,'String',pathstr)

nfiles=0; Data=[];

% Screen for Q-res/C-res
D=dir([pathstr filesep 'res_*.mat']);
for x=1:numel(D)
    S=whos('-file',[pathstr filesep D(x).name]);
    [VN{1:numel(S)}]=deal(S.name);
    
    % identify Chrombox C
    ind=strmatch('Databox',VN);
    if ~isempty(ind)
        nfiles=nfiles+1;
        Data{nfiles,1}=false;
        Data{nfiles,2}=D(x).name(5:end-4);
        Data{nfiles,3}='Chrombox C';
        Z=S(ind).size; 
        Data{nfiles,4}=prod(Z);
        Data{nfiles,5}=datestr(D(x).datenum,0);
    end
    % identify Chrombox Q
    ind=strmatch('XR',VN);
    if ~isempty(ind)
        nfiles=nfiles+1;
        Data{nfiles,1}=false;
        Data{nfiles,2}=D(x).name(5:end-4);
        Data{nfiles,3}='Chrombox Q';
        ind2=strmatch('RE',VN);
        if ~isempty(ind2) Data{nfiles,4}=1; else Data{nfiles,4}=0; end
        Data{nfiles,5}=datestr(D(x).datenum,0);
    end
end

% Screen for xls
D=dir([pathstr filesep '*.xls']);
for x=1:numel(D)
    [status,sheets]=xlsfinfo([pathstr filesep D(x).name]);
    if ~isempty(status)
        nfiles=nfiles+1;
        Data{nfiles,1}=false;
        Data{nfiles,2}=D(x).name(1:end-4);
        Data{nfiles,3}='Excel xls';
        Data{nfiles,4}=numel(sheets);
        Data{nfiles,5}=datestr(D(x).datenum,0);
    end
end

% Screen for xlsx
D=dir([pathstr filesep '*.xlsx']);
for x=1:numel(D)
    [status,sheets]=xlsfinfo([pathstr filesep D(x).name]);
    if ~isempty(status)
        nfiles=nfiles+1;
        Data{nfiles,1}=false;
        Data{nfiles,2}=D(x).name(1:end-5);
        Data{nfiles,3}='Excel xlsx';
        Data{nfiles,4}=numel(sheets);
        Data{nfiles,5}=datestr(D(x).datenum,0);
    end
end

if zz_tabletool('Exist','FilesListTab')
    zz_tabletool('Delete','FilesListTab');
end

T.Data=Data;
T.ViewPref=1;
T.Position=[Pos.xg(1) Pos.yg(11) Pos.gw*2+Pos.bw Pos.gh*12];
T.CellEditCallback='';
T.AllowNan=1;
T.TableName='FilesListTab';
T.ColumnFormat={'logical','string','string',3,'string'};
T.ColumnEditable=[1 0 0 0 0];
T.ColumnWidth={30,200,100,30,200};
T.ColumnName={'Sel.','File Name','Type','Dim','Date'};
T.RowName=[];
T.ListSelCol=1;
T.RowNamesWidth=25;
T.HorizontalExpansion=1;

zz_tabletool('Create',T);


% ------------------- getvarname ---------------------
function varname=getvarname

DataTypeList=findobj('Tag','DataTypeList'); % TEMP Endre til gcf
val=get(DataTypeList,'Value');
str=get(DataTypeList,'String');
selpar=str{val};
if strcmp(selpar,'Retention time (RT)') varname='rt' ; end
if strcmp(selpar,'Retention index (RI)') varname='ri' ; end
if strcmp(selpar,'Peak width (RT units)') varname='wbl' ; end
if strcmp(selpar,'Peak width (RI units)') varname='wbl_ri' ; end
if strcmp(selpar,'Area') varname='area' ; end
if strcmp(selpar,'Height') varname='height' ; end
if strcmp(selpar,'Response factor') varname='responsefactor' ; end


%======================================== WINDOW ========================================
% ------------------- OPENWIN ---------------------
function openwin

global Pos Colors

bw=Pos.bw;
bh=Pos.bh;
eh=Pos.eh; eo=(bh-eh)/2; % edit offset
gh=Pos.gh;% grid height
gw=Pos.gw; % grid width
o1=bw*3+bw/2; % Offset for gruppe 2
x=Pos.xg; y=Pos.yg;

winpar{1}='ExperimentsWin'; winpar{2}='Chrombox Optimizer: Import experiments';

% 'String','Style','Backgroundcolor','Position','Callback','Fonts'
p=0; o=bw/2;
% CLOSE
p=p+1;[ui{p,1:8}] = deal('Close','Pushbutton',Colors.close,[x(1) y(1) bw bh*1.5],'oo_readdata(99)',3,'','');

% Fileslist
p=p+1;[ui{p,1:7}] = deal('Available data:','Text',Colors.bc,[x(1) y(23) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('','Listbox',[1 1 1],[x(1) y(11) gw*2+bw gh*12],'',2,'FilesList');

% Directory
p=p+1;[ui{p,1:7}] = deal('','Edit',[1 1 1],[Pos.leftplot(1)+gw*0.2 y(10) gw*1.8+bw eh],'oo_readdata(1.2)',2,'PathEdit');
p=p+1;[ui{p,1:7}] = deal('.','Pushbutton',Colors.bc,[Pos.leftplot(1) y(10) gw*0.2 eh],'oo_readdata(1.3)',2,'');

% Read
p=p+1;[ui{p,1:8}] = deal('Read Files','Pushbutton',Colors.disk,[x(1) y(8) bw eh],'oo_readdata(2.1)',2,'','-bm');
readstr={'Normal','Split subfiles','All files to same box','Append to sel. box'};
p=p+1;[ui{p,1:7}] = deal(readstr,'Popupmenu',[1 1 1],[x(2) y(8) gw+bw eh],'',2,'ReadTypePop');
p=p+1;[ui{p,1:7}] = deal('Clear All','Pushbutton',Colors.reset,[x(3) y(9) bw eh],'oo_readdata(2.0)',2,'');

% Imported data lists
p=p+1;[ui{p,1:7}] = deal('Imported boxes:','Text',Colors.bc,[x(4) y(23) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('Del.Sel.','Pushbutton',Colors.reset,[x(5)+bw/2 y(23)+eh*0.1 bw/2 eh*0.8],'oo_readdata(10.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('Combine','Pushbutton',Colors.bc,[x(5)+(bw-gw)/2 y(23)+eh*0.1 bw/2 eh*0.8],'oo_readdata(-1)',2,'');
p=p+1;[ui{p,1:7}] = deal('Chromatograms:','Text',Colors.bc,[x(4) y(16) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:7}] = deal('Del.Sel.','Pushbutton',Colors.reset,[x(5)+bw/2 y(16)+eh*0.1 bw/2 eh*0.8],'oo_readdata(10.1)',2,'');

% Data type
p=p+1;[ui{p,1:7}] = deal('Select data type:','Text',Colors.bc,[x(4) y(8) gw+bw eh],'',3,'');
p=p+1;[ui{p,1:8}] = deal('No data','Listbox',[1 1 1],[x(4) y(4) gw+bw gh*4],'oo_readdata(3.3)',2,'DataTypeList','-d');

% Clear design
p=p+1;[ui{p,1:8}] = deal('Clear design','PushButton',Colors.reset,[x(5) y(3) bw eh*0.8],'oo_readdata(7.35)',2,'ClearDesBtn','-d');

% Add/remove variable
p=p+1;[ui{p,1:8}] = deal('Add Var','PushButton',Colors.bc,[x(4)+gw/2 y(2) gw*0.5 eh*0.8],'oo_readdata(8.5)',2,'AddVarBtn','-d');
p=p+1;[ui{p,1:8}] = deal('','Edit',[1 1 1],[x(5) y(2) bw eh*0.8],'',2,'AddVarEdit','-d');
p=p+1;[ui{p,1:8}] = deal('Del. Var','PushButton',Colors.reset,[x(4)+gw/2 y(1) gw*0.5 eh*0.8],'oo_readdata(8.6)',2,'DelVarBtn','-d');
p=p+1;[ui{p,1:8}] = deal(' ','Popupmenu',[1 1 1],[x(5) y(1) bw eh*0.8],'',2,'DelVarPop','-d');

% Compoundlist
p=p+1;[ui{p,1:7}] = deal('Data for box','Radiobutton',Colors.bc,[x(6) y(23) gw*2+bw eh],'oo_readdata(6.1)',3,'BoxDataRadio');
p=p+1;[ui{p,1:7}] = deal('Export data','Radiobutton',Colors.bc,[x(9) y(23) bw eh],'oo_readdata(6.2)',3,'ExportDataRadio');
p=p+1;[ui{p,1:7}] = deal('Code','RadioButton',Colors.bc,[x(6) y(9) bw eh],'oo_readdata(4.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Name','RadioButton',Colors.bc,[x(6)+gw/2 y(9) bw eh],'oo_readdata(4.1)',2,'CodeRadio');
p=p+1;[ui{p,1:7}] = deal('Short Name','RadioButton',Colors.bc,[x(7) y(9) bw eh],'oo_readdata(4.1)',2,'CodeRadio');

% Select parameters
p=p+1;[ui{p,1:7}] = deal('Select design experiments and parameters:','Text',Colors.bc,[x(6) y(8) gw*2+bw eh],'',3,'SelectText');
p=p+1;[ui{p,1:7}] = deal('Clear Selection','Pushbutton',Colors.reset,[1-bw-x(1) y(8)+eh*0.1 bw eh*0.8],'oo_readdata(8.4)',2,'');
p=p+1;[ui{p,1:7}] = deal('Auto assign','Pushbutton',Colors.bc,[1-bw-x(2) y(8)+eh*0.1 bw eh*0.8],'oo_readdata(8.7)',2,'');
% Export/ load
p=p+1;[ui{p,1:7}] = deal('Save Exp.','Pushbutton',Colors.disk,[x(1) y(6) bw eh],'oo_readdata(7.1)',2,'');
p=p+1;[ui{p,1:7}] = deal('ExperimentName','Edit',[1 1 1],[x(2) y(6) gw+bw eh],'',2,'FileNameEdit');
p=p+1;[ui{p,1:7}] = deal('Load Exp.','Pushbutton',Colors.disk,[x(1) y(5) bw eh],'oo_readdata(7.2)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(5) gw+bw eh],'',2,'SavedExperimentsPop');
p=p+1;[ui{p,1:7}] = deal('Load Design','Pushbutton',Colors.disk,[x(1) y(4) bw eh],'oo_readdata(7.3)',2,'');
p=p+1;[ui{p,1:7}] = deal('-','PopupMenu',[1 1 1],[x(2) y(4) gw+bw eh],'',2,'DesignFilesPop');


updfcn='oo_readdata(100)'; 
h0=zz_drawwin(winpar,ui,updfcn);
set(h0,'KeyPressFcn','oo_readdata(96)')
set(h0,'CloseRequestFcn','oo_readdata(99)')
% Multiple selections
FilesList=findobj(gcf,'Tag','FilesList'); set(FilesList,'Max',2,'Min',0)
FilesList=findobj(gcf,'Tag','ChromatogramsList'); set(FilesList,'Max',2,'Min',0)
FilesList=findobj(gcf,'Tag','CompoundList'); set(FilesList,'Max',2,'Min',0)
% List type

BoxDataRadio=findobj(gcf,'Tag','BoxDataRadio'); set(BoxDataRadio,'Value',1);
ExportDataRadio=findobj(gcf,'Tag','ExportDataRadio'); set(ExportDataRadio,'Value',0);

ShortNameCheck=findobj(gcf,'Tag','ShortNameCheck'); set(ShortNameCheck,'Value',1)

%ParametersPop=findobj(gcf,'Tag','ParametersPop'); set(ParametersPop,'Enable','off')
SelectText=findobj(gcf,'Tag','SelectText'); set(SelectText,'Visible','off')







