function zz_closewin
% function zz_closewin
% ver 220311 SAM
%
%

% Used to close active window
% Will reactivate caller window

%disp(['---- zz_closewin ---- ' datestr(now)]) % TEMP
%gcbf_tag=get(gcbf,'Tag') % TEMP

% Get userdata of closing window
Userdata=get(gcbf,'UserData');

% Set modal windows to normal before close
set(gcbf,'WindowStyle','normal') 

% Deletes subwindows specified in deleteonclose
if isfield(Userdata,'deleteonclose') && ~isempty(Userdata.deleteonclose)   
     delete(Userdata.deleteonclose(ishandle(Userdata.deleteonclose)))   
end

hh=findobj('Type','uicontextmenu','Parent',gcbf); 
if isempty(hh)==0 delete(hh); end % Removes right-click menus

% Set caller visible
callertag=Userdata.callerwin_tag; % Finds Tag of GUI that opened current
caller=findobj('Tag',callertag'); % Finds handle of GUI that opened current
if ~isempty(caller)
    try % Uses try here because it fails on Windows when closing the app (caller is root).
        set(caller,'Visible','on'); % Re-activate caller GUI
        figure(caller); % Set caller as active figure
        drawnow
    catch
    end
end

cud=get(gcbf,'UserData'); 

% Close window (unless mainwin)
mainwin=findobj('Tag','MainWin');
if gcbf ~= mainwin 
    % Avoids that closewin is run again when window is deleted
    set(gcbf,'DeleteFcn','') 
    delete(gcbf); 
end 

% Refresh caller window
if caller ~= 0   
    
    Calleruserdat=get(caller,'Userdata');
    eval(Calleruserdat.updfcn);
   
    % On Mac, open and close a dummy window to restore graphics.
    if strncmpi(computer,'MAC',3)
        bgcolor=get(caller,'Color');
        fh=figure('Position',[0 0 0 0],'Color',bgcolor,'ToolBar','none','MenuBar','none','Name','','NumberTitle','off');
        pause(0.1)
        delete(fh)
        if ~isempty(caller)
            figure(caller)
        end
    end
    
    % restore position of caller window (Ubuntu)   
    if strncmpi(computer,'GLN',3)
        drawnow
        if ~isempty(Userdata.callerwin_pos)
            set(caller,'Position',Userdata.callerwin_pos)
        end
    end
end







