function zz_copyfigure(call,varargin)
% function zz_copyfigure(call)
% ver 200226 SAM
% global Zset
%
% Usage:
%   'zz_copyfigure(0)' adds menus, uses default export pathname for exports.
%   'zz_copyfigure(0),'PathName',pathname) adds pathname for figure export. 
%      File extensions are ignored.
%      The default exportpath is used if 'pathname' is a filename without path.
%   'zz_copyfigure' (no inp. parameters) is equivalent to 'zz_copyfigure(0)'.
% 
% Requires global variable 'Zset' and field 'path_export' and 'report_aopen'.
% Applies function 'zz_message'.
% Modifies 'Zset.lastexport'


global Zset

if nargin==0 call=0; end

% Create menu
if call==0
    
    % Check for tag of axes, issue warning to screen if no tag
    axestag=get(gca,'Tag');
    if isempty(axestag)
        fprintf(2,[' ' char(10)])
        fprintf(2,['-------------------------------------' char(10)]) 
        fprintf(2,['zz_copyfigure: WARNING - No axes tag ' char(10)])  
        
        try
            [ST,I] = dbstack;
            if numel(ST)>1
                fprintf(2,[ST(2).name char(10)])
            end
            if numel(ST)>2
                 fprintf(2,['Caller file: ' ST(3).file char(10)])
                 fprintf(2,['Caller name: ' ST(3).name char(10)])
                 fprintf(2,['Caller line: ' num2str(ST(3).line) char(10)])
            end
        end
        fprintf(2,['-------------------------------------' char(10)]) 
    end
    
    % Create menutag and delete old
    menutag=['ZCFigMenu_' axestag];
    delete(findobj(gcf,'Tag',menutag)); % deletes old versions of menu
    cmenu = uicontextmenu; lno=0;
    lno=lno+1; lh(lno)=uimenu(cmenu, 'Label', 'Copy figure', 'Callback', 'zz_copyfigure(1)');
    if ispc lno=lno+1; lh(lno)=uimenu(cmenu, 'Label', 'Copy to clipboard (vector)', 'Callback', 'zz_copyfigure(2)'); end
    if ispc || ismac lno=lno+1; lh(lno)=uimenu(cmenu, 'Label', 'Copy to clipboard (bmp)', 'Callback', 'zz_copyfigure(2.5)'); end
    lno=lno+1; lh(lno)=uimenu(cmenu, 'Label', 'Print', 'Callback', 'zz_copyfigure(3)');
    lno=lno+1; lh(lno)=uimenu(cmenu, 'Label', 'Export', 'Callback', '');
    slm=lh(lno);
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'svg', 'Callback', 'zz_copyfigure(8)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'svg, painters', 'Callback', 'zz_copyfigure(8.5)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'pdf', 'Callback', 'zz_copyfigure(4)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'pdf, painters', 'Callback', 'zz_copyfigure(4.5)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'eps', 'Callback', 'zz_copyfigure(7)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'eps, painters', 'Callback', 'zz_copyfigure(7.5)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'png', 'Callback', 'zz_copyfigure(5)');
    lno=lno+1; lh(lno)=uimenu(slm, 'Label', 'tiff', 'Callback', 'zz_copyfigure(6)');
    
    set(cmenu,'Tag',menutag);
    set(gca,'UiContextMenu',cmenu);  
        
    % Sets pathname parameters for export
    epathname=[Zset.path_export filesep 'figureexport_' datestr(now,30)]; % Default pathname to use for export
    if nargin>1 && numel(varargin)>1 
        for x=1:numel(varargin)-1
            if strcmpi(varargin{x},'PathName')
                tmppathname=varargin{x+1};
            end
        end
        if ischar(tmppathname) 
            [tmppath,tmpname,tmpext]=fileparts(tmppathname);
            if isempty(tmppath) || ~isdir(tmppath) ;
                [tmppath,dummy,tmpext]=fileparts(epathname);
            end
            % Add check for legal filename when zz-function is implemented
            epathname=[tmppath filesep tmpname];    
        end  
    end    
    
    set(lh,'Userdata',epathname)
    
end

if call>0  
    cmap=get(gcf,'Colormap');
end

if call==1
    axesh=gca; 
    nyfig=figure;     
    set(nyfig,'Color',[1 1 1],'Colormap',cmap)
    h=copyobj(axesh,nyfig); set(h,'Position',[0.05 0.05 0.9 0.9]); 
    child=get(h,'Children'); set(child,'ButtonDownFcn','')
end

% Create new figure 
if any([2 2.5 3 4 4.5 5 6 7 7.5 8 8.5] == call)   
    
    % handles of figure/axes to be copied
    figh=gcf; axesh=gca; 
    
    Userdata=get(gcf,'UserData');
    % gets screen size
    scrwi=1/Userdata.pointwidth;
    scrhe=1/Userdata.pointheight;
    
    figpos=get(gcf,'Position');   
    axesp=get(axesh,'Position');
    axeswi=(axesp(3)*figpos(3))/Userdata.pointwidth;
    axeshe=(axesp(4)*figpos(3))/Userdata.pointheight;
        
    vo=40; ho=60; % vertical/horizontal offset (because labels are outside axes)
    hs=1; vs=1; % multipliers used to decrease scale if necessary
    if axeswi+ho>scrwi hs=scrwi/(axeswi+ho); axeswi=axeswi*hs; end % Ensures fig width will nor be larger than screen width
    if axeshe+vo>scrhe vs=scrhe/(axeshe+vo); axeshe=scrhe*vs; end % Ensures fig height will not he larger than screen height    
    
    % position of new figure
    fighp=(scrwi-(axeswi+ho))/2; % centers
    figvp=(scrhe-(axeshe+vo))/2; % centers
    nyfigpos=[fighp figvp axeswi+ho axeshe+vo]; % position of new figure
    
    %nyfig=figure('Visible','off'); % remove Visible off to keep figure visible
    nyfig=figure;
    set(nyfig,'Units','points','Position',nyfigpos,'Menubar','none','Colormap',cmap) 
    % Vecor export using painters
    if any([4.5 7.5 8.5] == call)
        set(nyfig,'Renderer','painters')
    end
    
    nah=copyobj(axesh,nyfig); % Copies figure to nyfig
    % adjust scale and set axes font size to 10
    set(nah,'Units','points','Position',[ho/2 vo/2 axeswi*hs axeshe*vs],'FontSize',10)
    child=get(nah,'Children'); set(child,'ButtonDownFcn','','Clipping','on')   
    
end
     
% Copy to clipboard
if call==2 || call==2.5 

    if ismac && call==2.5
        print(nyfig, '-clipboard', '-r300', '-dbitmap'); 
    end
    
    if ispc
        try % Copy using hgexport      
            if call==2 set(nyfig,'Renderer','painters'); hgexport(nyfig,'-clipboard'); end
            %if call==2.5 set(nyfig,'Renderer','ZBuffer'); hgexport(nyfig,'-clipboard'); end
            if call==2.5 set(nyfig,'Renderer','OpenGL'); hgexport(nyfig,'-clipboard'); end 
        catch % Use print if not working
            try
                if call==2 print -dmeta -noui; end
                if call==2.5 print -dbitmap -painters -noui; end
            catch
                zz_message(1,'Not supported by current Matlab version','-r')
            end
        end   
    end
    set(0,'CurrentFigure',figh); set(figh,'CurrentAxes',axesh)
    close(nyfig)
end

% Print
if call==3
    
    set(nyfig,'PaperPositionMode','auto','PaperOrientation','landscape','Units','centimeters','PaperUnits','centimeters','MenuBar','none')
    set(nah,'Units','normalized')
    
    figpos=get(nyfig,'Position');
    papersize=get(nyfig,'PaperSize');
    if figpos(3)>papersize(1)*0.9 figpos(3)=papersize(1)*0.9; end 
    if figpos(4)>papersize(2)*0.9 figpos(4)=papersize(2)*0.9; end 
    set(nyfig,'Position',figpos)
    
    printdlg(nyfig)
    close(nyfig)    
end

% pdf export
if call==4 || call==4.5
     
    set(nyfig,'PaperPositionMode','auto','PaperOrientation','landscape','Units','centimeters','PaperUnits','centimeters','MenuBar','none')
    set(nah,'Units','normalized')
    
    figpos=get(nyfig,'Position');
    papersize=get(nyfig,'PaperSize');
    if figpos(3)>papersize(1)*0.9 figpos(3)=papersize(1)*0.9; end 
    if figpos(4)>papersize(2)*0.9 figpos(4)=papersize(2)*0.9; end 
    set(nyfig,'Position',figpos)
    
    %fpath=Zset.path_export; if strcmp(fpath(end),filesep) fpath(end)=[]; end
    %pathname=[fpath filesep 'figureexport_' datestr(now,30) '.pdf'];
    pathname=[get(gcbo,'Userdata') '.pdf'];
    
    try               
        %print('-dpdf',pathname,['-f' num2str(figno)])
        print(nyfig, '-dpdf',pathname); 
        zz_message(1,['Figure exported to ' pathname],'-b')
       
        Zset.lastexport=pathname; % File to open by [OF] button on message line
        if Zset.report_aopen openexport(pathname); end
    catch
        zz_message(1,'Could not create pdf file','-r')
    end

    close(nyfig)   

end

% export png
if call==5
    try
        fpath=get(gcbo,'Userdata');
        if strcmp(fpath(end),filesep) fpath(end)=[]; end        
        set(nyfig, 'PaperPositionMode', 'auto')          

        pathname=[fpath '.png'];
        print(nyfig, '-dpng', '-r150', pathname); 
        zz_message(1,['Figure saved as ' pathname],'-b')

        Zset.lastexport=pathname; % File to open by [OF] button on message line
        if Zset.report_aopen openexport(pathname); end
    catch
        zz_message(1,'Could not create png file','-r')        
    end    
    close(nyfig)     
end

% export tiff
if call==6
    try
        fpath=get(gcbo,'Userdata');
        if strcmp(fpath(end),filesep) fpath(end)=[]; end        
        set(nyfig, 'PaperPositionMode', 'auto')          

        pathname=[fpath '.tif'];
        print(nyfig, '-dtiff', '-r150', pathname); 
        zz_message(1,['Figure saved as ' pathname],'-b')

        Zset.lastexport=pathname; % File to open by [OF] button on message line
        if Zset.report_aopen openexport(pathname); end
    catch
        zz_message(1,'Could not create tiff file','-r')        
    end    
    close(nyfig)     
end

% export eps
if call==7 || call==7.5 
    try    
        fpath=get(gcbo,'Userdata');
        if strcmp(fpath(end),filesep) fpath(end)=[]; end        
        set(nyfig, 'PaperPositionMode', 'auto')         
 
        pathname=[fpath '.eps'];
        print(nyfig, '-depsc2', '-r75', pathname); 
        zz_message(1,['Figure saved as ' pathname],'-b')           

        Zset.lastexport=pathname; % File to open by [OF] button on message line
        if Zset.report_aopen openexport(pathname); end
    catch
        zz_message(1,'Could not create eps file','-r')     
    end   
    close(nyfig)   
end

% export svg
if call==8 || call==8.5
    try    
        fpath=get(gcbo,'Userdata');
        if strcmp(fpath(end),filesep) fpath(end)=[]; end        
        set(nyfig, 'PaperPositionMode', 'auto')         
 
        pathname=[fpath '.svg'];
        print(nyfig, '-dsvg', pathname); 
        zz_message(1,['Figure saved as ' pathname],'-b')           

        Zset.lastexport=pathname; % File to open by [OF] button on message line
        if Zset.report_aopen openexport(pathname); end
    catch
        zz_message(1,'Could not create svg file','-r')     
    end   
    close(nyfig)   
end

% ----------- SUBFUNCTION openexport --------
function openexport(pathname)

if ispc
   try
       winopen(pathname);         
   catch
       zz_message(1,'Could not open file','-r'); 
   end
end

if strncmpi(computer,'GLNX',4)        
   err=system(['xdg-open "' pathname '"']); 
   if err
       zz_message(1,'Could not open file','-r'); 
   end
end 

if strncmpi(computer,'MAC',3)         
   err=system(['open ''' pathname '''']); 
   if err
       zz_message(1,'Could not open file','-r'); 
   end
end    



