function zz_copylist(call,handle)
% function zz_copylist(call,handle)
% ver 151001 SAM
% global Zset
%
% Copies list contents to textfile
% command 'zz_copylist' (no inp. parameters) must be given after figure
% is drawn to add menu.
% Requires Zset.path_export to be set

linefeed=char([13 10]);

global Zset
if nargin==0 call=99; end

if call==0 & nargin>1
    
    % Check for tag of axes, issue warning to screen if no tag
    handlepar=get(handle,'Parent');
    listtag=get(handle,'Tag');
    if isempty(listtag)
        fprintf(2,[' ' char(10)])
        fprintf(2,['-----------------------------------' char(10)]) 
        fprintf(2,['zz_copylist: WARNING - No list tag ' char(10)])  
        
        try
            [ST,I] = dbstack;
            if numel(ST)>1
                fprintf(2,[ST(2).name char(10)])
            end
            if numel(ST)>2
                 fprintf(2,['Caller file: ' ST(3).file char(10)])
                 fprintf(2,['Caller name: ' ST(3).name char(10)])
                 fprintf(2,['Caller line: ' num2str(ST(3).line) char(10)])
            end
        end
        fprintf(2,['-----------------------------------' char(10)]) 
    end

    menutag=['ZCListMenu_' listtag];
    delete(findobj(handlepar,'Tag',menutag)); % deletes old versions of menu
    cmenu = uicontextmenu('Parent',handlepar);
    uimenu(cmenu, 'Label', 'Copy Contents', 'Callback', 'zz_copylist(1)');
    set(cmenu,'Tag',menutag);
    set(handle,'UiContextMenu',cmenu);
end

if call==1

    objh=gco; 
    str=get(objh,'String');
    
    % Convert to cell if not
    if ~iscell(str)    
        [nlines,ncols]=size(str);
        copystr=str; str=[];
        for x=1:nlines
            str{x}=copystr(x,:);
        end
    end    
    
    n=length(str);
       
    fh=fopen([Zset.path_export filesep 'copylist.txt'],'w');
    for x=1:n
        fprintf(fh,[str{x} linefeed]); 
    end
    fclose(fh);
    zz_message(6,[Zset.path_export filesep 'copylist.txt'])
end