function zz_copywindow
% function zz_copywindow
% ver 141120 SAM
%
%
% Copies window to clipboard.
    
rend=get(gcf,'Renderer'); 
ih=get(gcf,'InvertHardcopy');
ppm=get(gcf,'PaperPositionMode');

set(gcf,'InvertHardcopy','off')
set(gcf,'PaperPositionMode','auto')
set(gcf,'Renderer','zbuffer'); 

try % Copy using hgexport      
    hgexport(nyfig,'-clipboard')        
    catch % Use print if not working
        try
            %set(gcf,'Renderer','OpenGL'); print -dmeta 
            print -dmeta -zbuffer
            %print -dmeta -painters
        catch
            zz_message(1,'Not supported by current Matlab version','-r')
        end
    end
    set(gcf,'Renderer',rend,'InvertHardcopy',ih,'PaperPositionMode',ppm)
end
