function h0 = zz_drawwin(winpar,uipar,updfcn)

% function h0=zz_drawwin(winpar,uipar,updfcn)
% ver 240125 SAM
% global Zset
%
% h0=zz_drawwin(winpar,uipar,updfcn)
% Draws window and hides caller window
% winpar: ({'Window_name'}{'Window Tag'}{[position]})
% - position is optional (missing => full widow size).
% uipar: Cell, uisettings for each object:
% ('Associated text','Type',color,[position],'callback command',fonts,'Tag');

% Parameter no 8:
% '-r': align right
% '-l': align lefter
% '-c': align center
% '-fh': fit height to text

global Zset
fonts=Zset.fonts;
Pos=Zset.Pos;
Colors=Zset.Colors;

%caller=gcbf; % handle to GUI that opens the window
%callertag=get(caller,'Tag'); % Tag to GUI that opens the window

Wp.caller=gcbf;
Wp.callertag=get(Wp.caller,'Tag');
Wp.position=Pos.window;
Wp.figname='No Name';
Wp.figtag='FigTag';
Wp.updfcn='';
Wp.keypressfcn=' '; % Ensures that keypress function is set to capture any key
Wp.keyreleasefcn='';
Wp.helpfilepath='';
Wp.hidecaller=true;
Wp.messageline=true;
Wp.deletefcn='zz_closewin';

% For winpar inputs as struct
if isstruct(winpar)
    fn=fieldnames(winpar);
    for x=1:numel(fn)
        Wp.(fn{x})=winpar.(fn{x});
    end
end

% For winpar inputs as cell (old method, add warning later)
if iscell(winpar)
    Wp.figtag=winpar{1};
    Wp.figname=winpar{2};
    if numel(winpar)>2
        Wp.position=winpar{3};
        Wp.hidecaller=false;
        Wp.messageline=false;
    end
end
if nargin==3 Wp.updfcn=updfcn; end

% Delete subwindows of caller before anything else is done
% The deleteonclose field must be manually set
if Wp.hidecaller
    CallerUdat=get(Wp.caller,'UserData');
    if isfield(CallerUdat,'deleteonclose') && ~isempty(CallerUdat.deleteonclose)
        delete(CallerUdat.deleteonclose(ishandle(CallerUdat.deleteonclose)))
        % updates
        CallerUdat.deleteonclose=CallerUdat.deleteonclose(ishandle(CallerUdat.deleteonclose));
        set(Wp.caller,'UserData',CallerUdat)
    end
end

% Checks if window with same Tag exists (Make more specific, check that Tag belongs to window)
h1=findobj('Tag',Wp.figtag);
if isempty(h1)==0;
    win_name=get(h1,'Name');
    message=['"' win_name '" Already open'];
    set(h1,'Visible','on'); % Makes window visible
    % Hides caller GUI
    set(Wp.caller,'Visible','off');
end

% Defines userdata
Userdata.callerwin_h=Wp.caller;
Userdata.callerwin_tag=get(Wp.caller,'Tag');
Userdata.callerwin_updfcn=get(Wp.caller,'ResizeFcn');
Userdata.callerwin_pos=get(Wp.caller,'Position');
Userdata.callerwin_units=get(Wp.caller,'Units');
Userdata.callerwin_color=get(Wp.caller,'Color');
Userdata.callerwin_currentaxes=get(Wp.caller,'CurrentAxes');
Userdata.callerwin_currentaxes_tag=get(Userdata.callerwin_currentaxes,'Tag');
Userdata.callerobj_h=gcbo;
Userdata.callerobj_tag=get(gcbo,'Tag');
Userdata.deleteonclose=[]; % Daughter windows that should be deleted (manually set but automatically deleted)
Userdata.pixwidth=Pos.pixwidth;
Userdata.pixheight=Pos.pixheight;
Userdata.pointwidth=Pos.pointwidth;
Userdata.pointheight=Pos.pointheight;
Userdata.updfcn=Wp.updfcn;
Userdata.keypressfcn=Wp.keypressfcn;
Userdata.keyreleasefcn=Wp.keyreleasefcn;
Userdata.helpfilepath=Wp.helpfilepath;

% Construct new window
if isempty(h1) %& isempty(h2)

    h0 = figure('Color',Colors.bc, ...
	    'PaperPosition',[18 180 576 432], ...
	    'PaperUnits','points', ...
        'Units','normalized',...
        'Position',Wp.position, ...
	    'Renderer','OpenGL', ...
	    'RendererMode','auto', ...
	    'Tag',Wp.figtag, ...
        'Name',Wp.figname,...
        'NumberTitle','off',...
        'Resize','off',...
        'Handlevisibility','on',...
        'Menubar','none',...
        'UserData',Userdata,...
        'ToolBar','none',...
        'KeyPressFcn',' '); % Ensures that keypress function is set to capture any key

    %---------------------- DEFAULT --------------
    set(h0,'DefaultUicontrolFontWeight','bold',...
        'DefaultUicontrolUnits','normalized',...
        'DefaultUicontrolFontSize',fonts(2),...
        'DefaultUicontrolBackgroundColor',Colors.bc,...
        'DefaultUicontrolInterruptible','off',...
        'DefaultUicontrolHorizontalAlignment','center')

    % Set behaviour of pushbutton
    % Uses togglebuttons on Windows, not on Linux
    pbtype=1;
    if strncmpi(computer,'MAC',3)  pbtype=2; end % For MAC, disabling of buttons may not work properly because wrong button type is used

    [m,n]=size(uipar);

    for t=1:m

        % Sets pushbuttons to togglenuttons
        if strcmpi(uipar{t,2},'Pushbutton') && pbtype==1
            uipar{t,2}='Togglebutton'; uipar{t,5}=[uipar{t,5} '; set(gcbo,''Value'',0)'];
        end

         % Sets pushbuttons to togglenuttons
        if strcmpi(uipar{t,2},'Pushbutton') && pbtype==2
            uipar{t,5}=['set(gcbo,''Enable'',''off'');' uipar{t,5} '; set(gcbo,''Enable'',''on'')'];
        end

        h1 = uicontrol('Parent',h0, ...
           'String',uipar{t,1}, ...
           'Style',uipar{t,2}, ...
	       'BackgroundColor',uipar{t,3}, ...
           'Position',uipar{t,4}, ...
           'Callback',uipar{t,5}, ...
           'FontSize',fonts(uipar{t,6}), ...
           'Tag',uipar{t,7});
       % Sets defaults for edits and listboxes
       if strcmpi(get(h1,'Style'),'edit') || strcmpi(get(h1,'Style'),'listbox') || strcmpi(get(h1,'Style'),'popupmenu')
           set(h1,'FontWeight','normal');
           set(h1,'HorizontalAlignment','left');
           set(h1,'FontName','FixedWidth')
       end
       % sets defaults for frames
       if strcmp(get(h1,'Style'),'text')
           set(h1,'HorizontalAlignment','left');
       end

       %evaluate parameter 8
       if length(uipar(t,:))>7 && ~isempty(uipar{t,8})

           if isempty(strfind(uipar{t,8},'-r'))==0 set(h1,'HorizontalAlignment','Right'); end
           if isempty(strfind(uipar{t,8},'-c'))==0 set(h1,'HorizontalAlignment','Center'); end
           if isempty(strfind(uipar{t,8},'-l'))==0 set(h1,'HorizontalAlignment','Left'); end
           if isempty(strfind(uipar{t,8},'-nvis'))==0 set(h1,'Visible','off'); end
           if isempty(strfind(uipar{t,8},'-bm'))==0
               set(h1,'Callback',['zz_busy(1.1);' uipar{t,5} ';zz_busy(0.1);'])
           end  % busymessage
           if isempty(strfind(uipar{t,8},'-fh'))==0
               set(h1,'String','X'); ext=get(h1,'Extent');
               fz=get(h1,'FontSize'); pos=get(h1,'Position'); pos(1,4)=ext(1,4)*1.1; set(h1,'Position',pos);
               set(h1,'String',uipar{t,1});
           end
           if isempty(strfind(uipar{t,8},'-fvp'))==0
               pos=get(h1,'Position'); he=pos(1,4); o=(Pos.gh-he)/2; pos(1,2)=pos(1,2)+o;
               set(h1,'Position',pos)
           end
           % Disable on draw
           if isempty(strfind(uipar{t,8},'-d'))==0
               set(h1,'Enable','off')
           end

       end
    end

    % Copy window option
    if Zset.tracker
        f=uicontextmenu;
        uimenu(f,'Label','Copy window','Callback','zz_copywindow');
        set(f,'Tag',['ZZCopywinmenu_' Wp.figtag])
        set(h0,'UIContextMenu',f)
    end

    % Add message line
    if Wp.messageline zz_message(0); end
    % Set delete function
    set(h0,'DeleteFcn',Wp.deletefcn)
    % Set key press function
    try
        set(h0,'WindowKeyPressFcn',Wp.keypressfcn);
    catch % WindowKeyPressFcn not defined for older Matlab versions
        set(h0,'KeyPressFcn',Wp.keypressfcn);
    end
    try
        % Use keyrelease function instead of keypress function to avoid multiple callbacks
        set(h0,'WindowKeyReleaseFcn',Wp.keyreleasefcn);
    catch % WindowKeyREleaseFcn not defined for older Matlab versions
        try
            set(h0,'KeyReleaseFcn',Wp.keyreleasefcn);
        catch
            % Set both keypressfcn and keyreleasefcn to KeyPressFcn if KeyReleaseFcn is not supported
            set(h0,'KeyPressFcn',[Wp.keypressfcn '; ' Wp.keyreleasefcn])
        end
    end

    % Hide caller
    if Wp.hidecaller set(Wp.caller,'Visible','off'); end

else
    zz_message(1,message,'-r');
end

drawnow

% -------------- REPORT ON ----------

if 0==1 % Switch
    disp(' ')
    disp('----- QQ_DRAWWIN -----')
    disp(['TAG:' winpar{1}])
    disp(['NAME:' get(h0,'Name')])
    disp(['CALLERTAG: ' Wp.callertag])
    disp('----- ---------- -----')
    disp(' ')
end



