function fname=zz_legalfname(fname,fopt)
% function fname=zz_legalfname(fname)
% ver 141118 SAM
%
%
% Converts fname to cross-platform legal filenames
% By default valid letters are:
%     ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._-
% Additional letters can be added by plus option string '+()[]' (will add '()[]')
% Letters can be removed by minus in option string '-.' (will remove '.')
% Avoid space unless it is intended to add it. Write '+()[]-.' not '+()[] -.'
% Add filesep by zz_legalfname(fname,['+' filesep])

validstr='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789._-';

if nargin>1 && ischar(fopt)
    
    plusind=strfind(fopt,'+'); 
    plusstr=fopt(plusind:end);
    minuind=strfind(plusstr,'-');
    if ~isempty(minuind) plusstr=plusstr(1:minuind-1); end
       
    minuind=strfind(fopt,'-');
    minustr=fopt(minuind:end);
    plusind=strfind(minustr,'+');
    if ~isempty(plusind) minustr=minustr(1:plusind-1); end
    
    
    if ~isempty(plusstr)
        validstr=unique([validstr plusstr(2:end)]);
    end
    if ~isempty(minustr)
        delind=ismember(validstr,minustr(2:end));
        validstr(delind)=[];
    end    
end

notvalid=~ismember(fname,validstr);
fname(notvalid)='_';

