function zz_message(an,varargin)
% zz_message(call,'String','options')
% ver 191004 SAM
% global Zset MessageLog
%
% Requires zz_copylist and Zset.path_export to be set
%
% External calls:
%
% call==0 create messageline
% call==1 display message on messageline
% call==2 clear messageline
% call==3 display log
% call==4 clear log
% call==6 opens file 
% call==7 popupmessage 
% call==8 orange logbutton
% call==9 display message to check for warnings if logbutton is orange
%
% Internal calls:
% call==10.1 prev message
% call==10.3 display info
% call==11.1 Opens last exported file
% call==11.2 Opens last folder of file
%
% Required fields in Zset:
% path_root
% path_export
% call_info
% call_settings
% fonts
%
% Options:
% '-r','-g', '-b': Text color (black if none)
% '-l' add to log
% '-nd' nodisplay (do not show at messageline)
% '-lw' log warning, turns log button orange, same as zz_message(8)
%
% use -- as separators in logs
% 
% use Zset.lastexport=[full pathname] to manually set file to open with [OF] button

global Zset MessageLog

%if Zset.tracker disp(['--- zz_message ---' num2str(an)]); end

if numel(varargin)>0 
    messagetxt=varargin{1};
end
if numel(varargin)>1
    options=varargin{2};
else
    options='';
end

% ---------- EXTERNAL CALLS -----------  

% Legger inn linje
if an==0 drawbox; end

% Message to screen and log
if an==1
    
    % display
    %strtest=strfind(options,'-nd')
    if isempty(strfind(options,'-nd'))
        typemess(messagetxt,options,0)
    end
    
    % add to log
    if strfind(options,'-l')
        if isempty(MessageLog) || ~isstruct(MessageLog)
            MessageLog=[];
            MessageLog.text=cell(0);
            MessageLog.time=[];
            MessageLog.options=cell(0);
        end
        nmess=numel(MessageLog.time);
        if iscell(messagetxt) 
            messt=now;
            for x=1:numel(messagetxt)
                MessageLog.text{nmess+x}=messagetxt{x};
                MessageLog.time(nmess+x)=messt;
                MessageLog.options{nmess+x}=options; 
            end
        else
            MessageLog.text{nmess+1}=messagetxt;
            MessageLog.time(nmess+1)=now;
            MessageLog.options{nmess+1}=options;    
        end
        
        if nmess>100
            MessageLog.text(1)=[]; MessageLog.time(1)=[]; MessageLog.options(1)=[];
        end
    end
    
    if strfind(options,'-lw')
        set(findobj('Tag','ZZMessageLogButton'),'BackgroundColor',[1 0.5 0])        
    end
    
end

% Clear messageline
if an==2
    h=findobj('Tag','MessageTxt');
    set(h,'String',' ');
end
    
% Display log (popup)
if an==3 set(findobj('Tag','ZZMessageLogButton'),'BackgroundColor',[1 1 1]); end
if an==3 && isstruct(MessageLog) && numel(MessageLog.text)>0

    maxchar=0; empties=[];
    for x=1:numel(MessageLog.text)
        msg=MessageLog.text{x};    
        if strcmp(msg,'--')
            logstr{x}='';
            empties=[empties x];
        else
            logstr{x}=[datestr(MessageLog.time(x),13) ': ' msg];
        end
        maxchar=max([maxchar numel(logstr{x})]);
    end
    
    % Adds separators
    for x=1:numel(empties)
        logstr{empties(x)}=repmat('-',1,maxchar);
    end
    % Removes multiple separators
    if numel(empties>1)
        diffem=diff(empties);
        delind=empties(diffem==1);
        logstr(delind)=[];
    end
    
    % Make Popup
    wh=findobj('Tag','MessLogWin','Type','Figure');
    
    h1=[];    
    if isempty(wh)
    
        defpos=get(gcbf,'Position');
        ww=defpos(3)*0.3; wh=defpos(4)*0.3;
        lp=defpos(1)+defpos(3)/2-ww/2;
        hp=defpos(2)+defpos(4)/2-wh/2;
        winpos=[lp hp ww wh];    
        bccol=get(gcbf,'Color');

        wh = figure('Color',bccol, ...
            'Units','normalized',...
            'Position',winpos, ...
    	    'Tag','MessLogWin', ...
            'Name','Message log',...
            'NumberTitle','off',...
            'KeyPressFcn',' ',...
            'Handlevisibility','on',...
            'Menubar','none',...
            'ToolBar','none',...
            'DefaultUicontrolUnits','normalized');

        h1 = uicontrol('Parent',wh, ...
            'BackgroundColor',[1 1 1], ...
	        'Position',[0 0 1 1], ...
            'Style','ListBox',...
            'HorizontalAlignment','left',...
            'Tag','MessTextBox',...
            'FontName','FixedWidth',...
            'FontSize',Zset.fonts(2));
    end
    
    %logstr=fliplr(logstr); Reverses order
    MessTextBox=findobj(wh,'Tag','MessTextBox');
    set(MessTextBox,'String',logstr);
    figure(wh); % Bring window to front
    % set(wh,'WindowStyle','modal'); set(wh,'WindowStyle','normal'); % Alternative
    try % Use try to handle cases where zz_copylist does not exist
        zz_copylist(0,MessTextBox);
    end
end

% Clear log
if an==4
    set(findobj('Tag','ZZMessageLogButton'),'BackgroundColor',[1 1 1]);
    MessageLog=[];
    MessageLog.text=cell(0);
    MessageLog.time=[];
    MessageLog.options=cell(0);
    wh=findobj('Tag','MessLogWin','Type','Figure'); close(wh);
    zz_message(1,'Cleared log')
end

% Opens a file
if an==6
    showfile(messagetxt); % Opens file with path messagetext
end

% popup message
if an==7
    cfig=gcbf;
    if isempty(cfig) cfig=gcf; end % if figure is closed upon execution
    defpos=get(cfig,'Position');

    ww=defpos(3)*0.3; wh=defpos(4)*0.3;
    lp=defpos(1)+defpos(3)/2-ww/2;
    hp=defpos(2)+defpos(4)/2-wh/2;
    winpos=[lp hp ww wh];
    bccol=get(cfig,'Color');
    
    wh=findobj('Type','figure','Tag','MessPop');
    
    if isempty(wh)

        wh = figure('Color',bccol, ...
            'Units','normalized',...
            'Position',winpos, ...
	        'Tag','MessPop', ...
            'Name','Message',...
            'NumberTitle','off',...
            'KeyPressFcn',' ',...
            'Handlevisibility','on',...
            'Menubar','none',...
            'ToolBar','none',...
            'DefaultUicontrolUnits','normalized');
  
        h1 = uicontrol('Parent',wh, ...
            'BackgroundColor',[1 1 1], ...
	        'Position',[0 0 1 1], ...
            'Style','ListBox',...
            'HorizontalAlignment','left',...
	        'String',messagetxt,...
            'Tag','MessTextBox',...
            'FontName','FixedWidth',...
            'FontSize',Zset.fonts(2));
    else
        
        figure(wh);
        h1=findobj(wh,'Tag','MessTextBox');
        set(h1,'String',messagetxt);
        
    end
    try % Use try to handle cases where zz_copylist does not exist
        zz_copylist(0,h1)
    end
end


% Set logbutton orange
if an==8
    set(findobj('Tag','ZZMessageLogButton'),'BackgroundColor',[1 0.5 0])
end

if an==9
    h=findobj('Tag','ZZMessageLogButton');
    bc=get(h(1),'BackgroundColor');
    if bc(1) > 0 zz_message(1,'WARNING: Check log','-r'); end
end


% ---------- INTERNAL CALLS ----------

% disp old messages
if an==10.1
    typemess('','',1) % Display message from stack
end

% info
if an==10.3
    eval(Zset.call_info) 
end

% opens last file
if an==11.1 && isfield(Zset,'lastexport') && ~isempty(Zset.lastexport)   
    if exist(Zset.lastexport)==2
        if ispc
            try
                winopen(Zset.lastexport)
            catch
                zz_message(1,['Could not open ' Zset.lastexport],'-r')
            end
        end
        if strncmpi(computer,'GLNX',4)
            err=system(['xdg-open "' Zset.lastexport '" &']);
            if err
                zz_message(1,['Could not open ' Zset.lastexport],'-r')
            end
        end
        if strncmpi(computer,'MAC',3)        
            err=system(['open ''' Zset.lastexport '''']);
            if err
                zz_message(1,['Could not open ' Zset.lastexport],'-r')
            end
        end        
    end
end

% opens folder of last file
if an==11.2 && isfield(Zset,'lastexport') && ~isempty(Zset.lastexport)       
    [fpath,fname,fext]=fileparts(Zset.lastexport);
    if ispc && isdir(fpath)
        try
            winopen(fpath)           
        catch
            zz_message(1,['Could not open folder' fpath],'-r')
            
        end
    end
    if strncmpi(computer,'GLNX',4) && isdir(fpath)       
        err=system(['xdg-open "' fpath '" &']);
        if err
            zz_message(1,['Could not open ' fpath],'-r')
        end
    end
    if strncmpi(computer,'MAC',3) && isdir(fpath)  
        err=system(['open ''' fpath '''']);
        if err
            zz_message(1,['Could not open ' fpath],'-r')
        end
    end    
end


    



% ----------------------------------------------------------
% ----------------------- SUBFUNCTIONS ---------------------
% ----------------------------------------------------------

function typemess(textstr,options,an)
persistent Mstack messno

tstr=[]; mopt=[];

if an==0
    tstr=textstr;
    mopt=options;
    
    ind=numel(Mstack)+1;
    
    % Saves displaid messages
    Mstack(ind).text=tstr;
    Mstack(ind).options=mopt;
    Mstack(ind).time=now;   
    messno=0;
    % Save max 11 messages
    if numel(Mstack)>11 Mstack(1:numel(Mstack)-11)=[]; end
end

% Display old messages
if an==1
    messno=messno+1;
    if messno>numel(Mstack)-1 messno=0; end
    if numel(Mstack)>1 
        tstr=['[' num2str(-messno) '] ' Mstack(numel(Mstack)-messno).text];
        mopt=Mstack(numel(Mstack)-messno).options;
    end
end

% Output to messageline
h=findobj('Tag','MessageTxt');
if ~isempty(tstr)
    set(h,'HorizontalAlignment','Center');
    set(h,'ForegroundColor',[0 0 0])
    if strfind(mopt,'-r') set(h,'ForegroundColor',[1 0 0]); end
    if strfind(mopt,'-g') set(h,'ForegroundColor',[0 0.5 0]); end
    if strfind(mopt,'-b') set(h,'ForegroundColor',[0 0 1]); end
    set(h,'String',tstr); 
else
    set(h,'String',''); 
end

% ---------------- SHOWFILE ------------- 
function showfile(messagetxt)
global Zset

%global Locset
%if isfield(Locset,'editor')==0 Locset.editor='default'; end

if ispc
    try 
        winopen(messagetxt)
        Zset.lastexport=messagetxt;
    catch
        zz_message(1,'Could not open file','-r')
    end
end

if strncmpi(computer,'GLNX',4)  
    err=system(['xdg-open "' messagetxt '"']);
    Zset.lastexport=messagetxt;
    if err
        zz_message(1,'Could not open file','r')
    end
end

if strncmpi(computer,'MAC',3) 
    err=system(['open ''' messagetxt '''']);
    Zset.lastexport=messagetxt;
    if err
        zz_message(1,'Could not open file','r')
    end
end



% ---------------- TEGNER LINJE -------------
function drawbox

global Zset

%hp=0; % Vertikal posisjon til messageline
%hp=0.025; % Vertikal posisjon til messageline

% ---- Message line ----

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[1 0 0],...
    'BackgroundColor',[1 1 1],...
    'Position',[0.125 0 0.725 0.03], ...
	'String',' ', ...
    'FontSize',Zset.fonts(3),...
	'Style','text', ...
    'Tag','MessageTxt');

% ---- Left side buttons ----

hp=0; bw=0.025;
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(10.3)', ...
	'Position',[hp 0 bw 0.03], ...
    'TooltipString','Info',...
	'String','I');

udat=get(gcf,'Userdata');
if isfield(udat,'helpfilepath') && ~isempty(udat.helpfilepath)
    cbf=['try web(''' udat.helpfilepath ''', ''-notoolbar''); catch web(''' udat.helpfilepath '''); end'];
    
    hp=hp+bw; bw=0.025;
    h1 = uicontrol('Parent',gcf, ...
        'ForegroundColor',[0 0 1], ...
        'BackgroundColor',[1 1 1], ...
	    'Callback',cbf, ...
	    'Position',[hp 0 bw 0.03], ...
        'TooltipString','Help',...
	    'String','H');  
end
    
cbf=['winopen(''', Zset.path_root filesep 'Notes.txt'');'];
if strncmpi(computer,'GLNX',4)
    cbf=['system(''xdg-open "' Zset.path_root filesep 'Notes.txt" &'');'];
end
if strncmpi(computer,'MAC',3)
    cbf=['system(''open "' Zset.path_root filesep 'Notes.txt"'');'];
end

hp=hp+bw; bw=0.025;
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[hp 0 bw 0.03], ...
    'TooltipString','Open notes',...
	'String','N');

hp=hp+bw; bw=0.025;
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...    
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(3)', ...
	'Position',[hp 0 bw 0.03], ...
	'String','Log',...
    'TooltipString','Open log',...
    'Tag','ZZMessageLogButton');

hp=hp+bw; bw=0.025;
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(4)', ...
	'Position',[hp 0 bw 0.03], ...
    'TooltipString','Clear log',...
	'String','CL');

hp=hp+bw; bw=0.025;
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(10.1)', ...
	'Position',[hp 0 bw 0.03], ...
    'TooltipString','Show previous messages',...
	'String','>>');

% ----------- RIGHT SIDE --------------

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',Zset.call_settings, ...
	'Position',[1-0.05 0 0.050 0.03], ...
	'String','Settings',...
    'TooltipString','Set preferences',...
    'Tag','SettingsBtn');

% Free modal windows
cbf='set(findobj(''Type'',''Figure''),''Visible'',''on'');set(findobj(''Type'',''Figure''),''WindowStyle'',''normal'');';
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[1-0.075 0 0.025 0.03], ...
    'TooltipString','Display hidden windows',...
	'String','FW');

% Open explorer
cbf=['winopen(''' Zset.path_root ''');'];
if strncmpi(computer,'GLNX',4)
    cbf=['system(''xdg-open "' Zset.path_root '" &'');'];
end
if strncmpi(computer,'MAC',3)
    %cbf=['system(''open ''' Zset.path_root ''''');'];
    cbf=['system(''open "' Zset.path_root '"'');'];
end

h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback',cbf, ...
	'Position',[1-0.1 0 0.025 0.03], ...
    'TooltipString','Open Chrombox root',...
	'String','OR');

% open folder of last exported file
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(11.2)', ...
	'Position',[1-0.125 0 0.025 0.03], ...
    'TooltipString','Open folder of last saved file',...
	'String','OD');

% open last exported file
h1 = uicontrol('Parent',gcf, ...
    'ForegroundColor',[0 0 1], ...
    'BackgroundColor',[1 1 1], ...
	'Callback','zz_message(11.1)', ...
	'Position',[1-0.150 0 0.025 0.03], ...
    'TooltipString','Open last saved file',...
	'String','OF');

