function Pointerloc=zz_pointerlocation
% function Pointerloc=zz_pointerlocation
% ver 160325 SAM
%

% May fail to properly estimate figure if outside screen
% Currently support for one screen

Pointerloc.monitorsize_x=[];
Pointerloc.monitorsize_y=[];
Pointerloc.screenpix_x=[];
Pointerloc.screenpix_y=[];
Pointerloc.screennorm_x=[];
Pointerloc.screennorm_y=[];
Pointerloc.figpix_x=[];
Pointerloc.figpix_y=[];
Pointerloc.fignorm_x=[];
Pointerloc.fignorm_y=[];
Pointerloc.axesscale_x=[];
Pointerloc.axesscale_y=[];

% Get current units
screenunits=get(0,'Units');
figunits=get(gcf,'Units');
axesunits=get(gca,'Units');
%objectunits=get(gco,'Units');

% Screen data
set(0,'Units','pixels')
loc=get(0,'Pointerlocation');
try
    monpos=get(0,'MonitorPositions'); % Newer Matlab versions
catch
    monpos=get(0,'ScreenSize'); % Older Matlab versions
end    
Pointerloc.monitorsize_x=monpos(1,3); % Currently support for one screen
Pointerloc.monitorsize_y=monpos(1,4); % Currently support for one screen
Pointerloc.screenpix_x=loc(1);
Pointerloc.screenpix_y=loc(2);
set(0,'Units','normalized')
loc=get(0,'Pointerlocation');
Pointerloc.screennorm_x=loc(1);
Pointerloc.screennorm_y=loc(2);

%Figure data
if ~isempty(gcf)
    set(gcf,'Units','pixels')
    pos=get(gcf,'Position');
    fxlim=[pos(1) pos(1)+pos(3)];
    fylim=[pos(2) pos(2)+pos(4)];
    Pointerloc.figpix_x = interp1(fxlim,[0 Pointerloc.monitorsize_x],Pointerloc.screenpix_x,'linear','extrap');
    Pointerloc.figpix_y = interp1(fylim,[0 Pointerloc.monitorsize_y],Pointerloc.screenpix_y,'linear','extrap');
    set(gcf,'Units','normalized')
    pos=get(gcf,'Position');
    fxlim=[pos(1) pos(1)+pos(3)];
    fylim=[pos(2) pos(2)+pos(4)];
    Pointerloc.fignorm_x = interp1(fxlim,[0 1],Pointerloc.screennorm_x,'linear','extrap');
    Pointerloc.fignorm_y = interp1(fylim,[0 1],Pointerloc.screennorm_y,'linear','extrap');
end

% Axes data
if ~isempty(gca)
    pos=get(gca,'Position');
    fxlim=[pos(1) pos(1)+pos(3)];
    fylim=[pos(2) pos(2)+pos(4)];
    axxlim=get(gca,'XLim');
    axylim=get(gca,'YLim');
    Pointerloc.axesscale_x = interp1(fxlim,axxlim,Pointerloc.fignorm_x,'linear','extrap');
    Pointerloc.axesscale_y = interp1(fylim,axylim,Pointerloc.fignorm_y,'linear','extrap');
end

% Resets
set(0,'Units',screenunits)
set(gcf,'Units',figunits)
set(gca,'Units',axesunits)
%set(gco,'Units',objectunits)



