function Status = zz_report_clip(Reportstruct,varargin)
% Function for sending reportstruct to clipboard
% varargin is used as dummy to ensure compliance with other reports that
% has an 'openfile' variable as second input
% ver 221031 SAM

numformat = '%.7g'; % 7 sign. digits (single precision) 
%numformat = '%.15g'; % 15 sign. digits (double precision)

if ~isfield(Reportstruct,'newbe')
    Reportstruct(1).newbe = false;
end

if Reportstruct(1).newbe
    Status.failed = true;
    Status.errormsg = '';
    Status.savedas = '';
else
    Status = [];
end

linefeed=char([13 10]);
tn=1; 
cstr={}; lno = 0;

% ------------- Writes header -------------
if isfield(Reportstruct,'header')
    for x=1:length(Reportstruct(tn).header)
        lno=lno+1;
        cstr{lno,1} = Reportstruct(tn).header{x};
    end
end
        
% ------------- Writes cells -------------
[n_columns,n_rows]=size(Reportstruct(tn).cells);
n_headers=0;
if isfield(Reportstruct,'columntitle')
    [dummy,n_headers]=size(Reportstruct(tn).columntitle);
end
U=[]; typestr=[]; 
for x=1:n_columns
    for hn=1:n_headers
        cstr{lno+hn,x}=[Reportstruct(tn).columntitle{x,hn}];
    end
    sline=lno+n_headers;
    for y=1:n_rows
        
        if strcmp(Reportstruct(tn).format{x,y},'str')
            cstr{sline+y,x}=[Reportstruct(tn).cells{x,y}];
        else
            %cstr{sline+y,x}=[num2str(Reportstruct(tn).cells{x,y},Reportstruct(tn).format{x,y})];
            cstr{sline+y,x}=[num2str(Reportstruct(tn).cells{x,y},numformat)]; % overrides formatting
        end
    end
end       

% ------------- Writes footer -------------
if isfield(Reportstruct,'footer')
    [nrow,ncol]=size(cstr); 
    for x=1:length(Reportstruct(tn).footer)
        cstr{nrow+x,1}=Reportstruct(tn).footer{x};
    end
end

% ------------- Formats and copies -------------
if ~isempty(cstr)
    [nrow,ncol]=size(cstr);
    cstr(cellfun(@isempty,cstr)) = {''};
    ostr = '';
    for rn=1:nrow
        for cn=1:ncol
            ostr=[ostr cstr{rn,cn} char(9)]; 
        end
        ostr(end)=[]; ostr=[ostr linefeed];
    end

    if Reportstruct.newbe

        if zz_sysinfo('ismatlab')
            
            clipboard('copy', ostr)
            Status.failed = false;

        else

            % solution for linux: xsel, xclip, fallback
            if zz_sysinfo('islinux')
                
                % try xsel
                [a,b] = system('command -v xsel');
                if ~a % exits with 0
                    syscmd = ['echo "' ostr '" | xsel -b'];
                    system(syscmd);
                    Status.failed = false;
                end
                
                % try xclip
                if Status.failed
                    [a,b] = system('command -v xclip');
                    if ~a % exits with 0
                        syscmd = ['echo "' ostr '" | xclip -selection clipboard'];
                        system(syscmd);
                        Status.failed = false;
                    end
                end
                
                % fallback, write to file and open
                if Status.failed
                    fnam =[pwd filesep 'TEMP_CLIPBOARD.txt'];
                    fh=fopen(fnam,'w'); fprintf(fh,'%s',ostr); fclose(fh);
                    syscmd = ['xdg-open "' fnam '"'];
                    system(syscmd);
                    Status.failed = false;
                end

            end
            
            % solution for Windows: write temporary file and pipe to clip 
            if zz_sysinfo('iswindows')
                try
                    fnam =[pwd filesep 'TEMP_CLIPBOARD.txt'];
                    fh=fopen(fnam,'w'); fprintf(fh,'%s',ostr); fclose(fh);
                    system(['powershell cat "' fnam '" | clip' ]);
                    Status.failed = false;
                    fallback = false;
                catch
                end
          end
          
            % solution for Mac: pipe to pbcopy
            if zz_sysinfo('ismac')
                syscmd = ['echo "' ostr '" | pbcopy'];
                system(syscmd);
                Status.failed = false;
                fallback = false;
            end

        end

        % WRITE FALLBACK, WRITE TO TEXTFILE AND OPEN THE FILE

    else

        clipboard('copy', ostr)
        
        % Suppress output 
        if ~nargout
            clearvars
        end

    end

end


% ====== Subfunction convstr ===== % currently unused
function  str = convstr(str)
% Converts special characters in strings for fprintf
% \\ --> \\
% % --> %%
% ' --> ''

if isempty(str) str = ''; end % ensure empties are chars

if ~ischar(str) return; end

str=strrep(str,'\','\\');
str=strrep(str,'%','%%');
str=strrep(str,'''','''''');













