function Status = zz_report_csv(Reportstruct,openfile)
% function zz_report_csv(Reportstruct,openfile)
% ver 221031 SAM
% global Zset

numformat = '%.7g'; % 7 sign. digits (single precision) 
%numformat = '%.15g'; % 15 sign. digits (double precision) 

if ~isfield(Reportstruct,'newbe')
    Reportstruct(1).newbe = false;
end

if Reportstruct(1).newbe

    Status.failed = true;
    Status.errormsg = '';
    Status.savedas = '';

else
    global Zset

    Status = [];

    % Uses value specified in Zset
    if nargin<2
        if isfield(Zset,'report_aopen') && Zset.report_aopen
            openfile=true;
        else
            openfile=false;
        end
    end

end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.csv'],'w');

if fh==-1
    if Reportstruct(1).newbe
        Status.errormsg = 'Could not write to file, file may be open or output folder may not exist';
    else
        zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r');
    end
else
    for tn=1:numel(Reportstruct)

        % ------------- Writes header -------------
        if isfield(Reportstruct,'header') && ~isempty(Reportstruct(tn).header)
            for x=1:length(Reportstruct(tn).header)
                fprintf(fh,[convstr(Reportstruct(tn).header{x}) ' ' linefeed]);
            end
        end
        
        % ------------- convert to typstr -------------
        [n_columns,n_rows]=size(Reportstruct(tn).cells);
        typestr = ''; ln = 0;
        
        if isfield(Reportstruct,'columntitle')
            [dummy,n_headers]=size(Reportstruct(tn).columntitle);
            for hno=1:n_headers
                ln=ln+1; typestr{ln} = '';
                for cno=1:n_columns
                    typestr{ln}=[typestr{ln} convstr(Reportstruct(tn).columntitle{cno,hno}) ';'];
                end
            end
        end
               
        for rno=1:n_rows
            ln = ln+1; typestr{ln} = '';
            for cno=1:n_columns
                if strcmpi(Reportstruct(tn).format{cno,rno},'str')
                    typestr{ln}=[typestr{ln} convstr(Reportstruct(tn).cells{cno,rno}) ';'];       
                else
                    %typestr{ln}=[typestr{ln} num2str(Reportstruct(tn).cells{cno,rno},Reportstruct(tn).format{cno,rno}) ';'];   
                    typestr{ln}=[typestr{ln} num2str(Reportstruct(tn).cells{cno,rno},numformat) ';']; % ignores formats  
                end
            end
        end

        % Write fields
        for x=1:numel(typestr)
            if typestr{x}(end)==';' typestr{x}(end)=[]; end
            fprintf(fh,[typestr{x} linefeed]);
        end
               
        % Writes footer
        if isfield(Reportstruct,'footer') && ~isempty(Reportstruct(tn).footer)
            for x=1:length(Reportstruct(tn).footer)
                fprintf(fh,[convstr(Reportstruct(tn).footer{x}) ' ' linefeed]);
            end
        end
        
        % Add blank line to separate multiple outputs
        if numel(Reportstruct)>1 && tn<numel(Reportstruct)
            fprintf(fh,[' ' linefeed]);
        end

    end % for tn

    if Reportstruct(1).newbe
        Status.savedas = [Reportstruct(1).pathname '.csv'];
        Status.failed = false;        
    else
        zz_message(1,['Saved as: ' Reportstruct(1).pathname '.csv'],'-b')
        Zset.lastexport=[Reportstruct(1).pathname '.csv'];
    end
    fclose(fh);

    if ~Reportstruct(1).newbe

        % Opens
        if openfile && ispc
            try
                winopen([Reportstruct(1).pathname '.csv']);
            catch
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'GLNX',4)
            err=system(['xdg-open "' Reportstruct(1).pathname '.csv"']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'MAC',3)
            err=system(['open ''' Reportstruct(1).pathname '.csv''']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        % Suppress output
        if ~nargout
            clearvars
        end

    end

end % if fid==-1


% ====== Subfunction convstr =====
function str=convstr(str)
% Converts special characters in strings for fprintf
% \\ --> \\
% % --> %%
% ' --> ''

if isempty(str) str = ''; end % ensure empties are chars

if ~ischar(str) return; end

str=strrep(str,'\','\\');
str=strrep(str,'%','%%');
str=strrep(str,'''','''''');









