function Status = zz_report_dif(Reportstruct,openfile)
% function zz_report_dif(Reportstruct,openfile)
% ver 221031 SAM
% global Zset
%

numformat = '%.7g'; % 7 sign. digits (single precision) 
%numformat = '%.15g'; % 15 sign. digits (double precision) 

if ~isfield(Reportstruct,'newbe')
    Reportstruct(1).newbe = false;
end

if Reportstruct(1).newbe

    Status.failed = true;
    Status.errormsg = '';
    Status.savedas = '';

else
    global Zset

    Status = [];

    % Uses value specified in Zset
    if nargin<2
        if isfield(Zset,'report_aopen') && Zset.report_aopen
            openfile=true;
        else
            openfile=false;
        end
    end

end

linefeed=char([13 10]);

ostr{1,1}=''; lno=0; numvals(1,1)=false;

for tn=1:numel(Reportstruct)

    % ------------- header -------------
    if isfield(Reportstruct,'header') && ~isempty(Reportstruct(tn).header)
        for x=1:length(Reportstruct(tn).header)
            lno=lno+1; 
            ostr{lno,1}=convstr(Reportstruct(tn).header{x});
            numvals(lno,1)=false;
        end
    end
    
    % ------------- column headers -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells);
    if isfield(Reportstruct,'columntitle')
        [d,n_headers]=size(Reportstruct(tn).columntitle);       
        for hno=1:n_headers
            lno=lno+1;
            for cno=1:n_columns
                ostr{lno,cno}=convstr(Reportstruct(tn).columntitle{cno,hno});
                numvals(lno,cno)=false;
            end
        end
    end
    
    % ------------- cell contents -------------
    for rno=1:n_rows
        lno=lno+1;
        for cno=1:n_columns
            if strcmpi(Reportstruct(tn).format{cno,rno},'str')
                ostr{lno,cno}=convstr(Reportstruct(tn).cells{cno,rno});
                numvals(lno,cno)=false;
            else
                %ostr{lno,cno}=num2str(Reportstruct(tn).cells{cno,rno},Reportstruct(tn).format{cno,rno});
                ostr{lno,cno}=num2str(Reportstruct(tn).cells{cno,rno},numformat); % ignores numeric precision
                numvals(lno,cno)=true;
            end
        end
    end
        
    % ------------- footer -------------
    if isfield(Reportstruct,'footer') && ~isempty(Reportstruct(tn).footer)
        for x=1:length(Reportstruct(tn).footer)
            lno=lno+1; ostr{lno,1}=convstr(Reportstruct(tn).footer{x});
            numvals(lno,1)=false;
        end
    end
    
    % Add blank line to separate multiple outputs
    if numel(Reportstruct)>1 && tn<numel(Reportstruct)
        lno=lno+1; ostr{lno,1}=' ';
        numvals(lno,1)=false;
    end    
          
end % for tn

% Fill inn blanks
ostr(cellfun('isempty',ostr))={''};

[ntup,nvec]=size(ostr);

% ------------- Opens file -------------
fh=fopen([Reportstruct(1).pathname '.dif'],'w');

if fh==-1
    if Reportstruct(1).newbe
        Status.errormsg = 'Could not write to file, file may be open or output folder may not exist';
    else
        zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r');
    end
else
    
    fprintf(fh,['TABLE',linefeed]);
    fprintf(fh,['0,1',linefeed]);
    fprintf(fh,['"CHROMBOX DIF"',linefeed]);
    fprintf(fh,['VECTORS',linefeed]);
    fprintf(fh,['0,' num2str(nvec) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['TUPLES',linefeed]);
    fprintf(fh,['0,' num2str(ntup) linefeed]);
    fprintf(fh,['""',linefeed]);
    fprintf(fh,['DATA',linefeed]);
    fprintf(fh,['0,0',linefeed]);
    fprintf(fh,['""',linefeed]);
      
    for tupno=1:ntup
        fprintf(fh,['-1,0',linefeed]);
        fprintf(fh,['BOT' linefeed]);       
        for vecno=1:nvec
            if numvals(tupno,vecno)
                fprintf(fh,['0,' ostr{tupno,vecno} linefeed]); 
                fprintf(fh,['V' linefeed]); 
            else
                fprintf(fh,['1,0' linefeed]); 
                fprintf(fh,['"' ostr{tupno,vecno} '"' linefeed]); 
            end
            
        end
    end
    fprintf(fh,['-1,0',linefeed]);
    fprintf(fh,['EOD',linefeed]);
    
    if Reportstruct(1).newbe
        Status.savedas = [Reportstruct(1).pathname '.dif'];
        Status.failed = false;
    else
        zz_message(1,['Saved as: ' Reportstruct(1).pathname '.dif'],'-b')
        Zset.lastexport=[Reportstruct(1).pathname '.dif'];
    end
    fclose(fh);

    % Open
    if ~Reportstruct(1).newbe

        if openfile && ispc
            try
                winopen([Reportstruct(1).pathname '.dif']);
            catch
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'GLNX',4)
            err=system(['xdg-open "' Reportstruct(1).pathname '.dif"']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'MAC',3)
            err=system(['open ''' Reportstruct(1).pathname '.dif''']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        % Suppress output 
        if ~nargout
            clearvars
        end        

    end
    
end % if fid==-1


% ====== Subfunction convstr =====
function str=convstr(str)
% Converts special characters in strings for fprintf
% \\ --> \\
% % --> %%
% ' --> ''

if ~ischar(str) return; end

str=strrep(str,'\','\\');
str=strrep(str,'%','%%');
str=strrep(str,'''','''''');









