function Status = zz_report_slk(Reportstruct,openfile)
% function zz_report_slk(Reportstruct,openfile)
% ver 221031 SAM
% global Zset
%

numformat = '%.7g'; % 7 sign. digits (single precision) 
%numformat = '%.15g'; % 15 sign. digits (double precision)

if ~isfield(Reportstruct,'newbe')
    Reportstruct(1).newbe = false;
end

if Reportstruct(1).newbe

    Status.failed = true;
    Status.errormsg = '';
    Status.savedas = '';

else
    global Zset

    Status = [];

    % Uses value specified in Zset
    if nargin<2
        if isfield(Zset,'report_aopen') && Zset.report_aopen
            openfile=true;
        else
            openfile=false;
        end
    end

end

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.slk'],'w');

if fh==-1 
    if Reportstruct(1).newbe
        Status.errormsg = 'Could not write to file, file may be open or output folder may not exist';
    else
        zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r');
    end
else
    nl=0; % nlines;
    rno=0; % row number
    typestr=cell(0);
    %nl=nl+1; typestr{nl}='ID;P'; % Identifier
    
    for tn=1:numel(Reportstruct)

        % ------------- Writes header -------------
        if isfield(Reportstruct,'header') && ~isempty(Reportstruct(tn).header)
            for x=1:length(Reportstruct(tn).header)
                nl=nl+1; rno=rno+1;
                typestr{nl}=['C;Y' num2str(rno) ';X1;K"' convstr(Reportstruct(tn).header{x}) '"'];
            end
        end
        
        % ------------- convert to typstr -------------
        [n_columns,n_rows]=size(Reportstruct(tn).cells);
        
        if isfield(Reportstruct,'columntitle')
            [dummy,n_headers]=size(Reportstruct(tn).columntitle);
            for hno=1:n_headers
                rno=rno+1;
                for cno=1:n_columns
                    nl=nl+1;
                    typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K"' convstr(Reportstruct(tn).columntitle{cno,hno}) '"'];
                end
            end
        end

        for x=1:n_rows
            rno=rno+1;
            for cno=1:n_columns
                if strcmpi(Reportstruct(tn).format{cno,x},'str')
                    nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K"'  convstr(Reportstruct(tn).cells{cno,x}) '"'];                   
                else
                    %nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K'  num2str(Reportstruct(tn).cells{cno,x},Reportstruct(tn).format{cno,x})];
                    nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X' num2str(cno) ';K'  num2str(Reportstruct(tn).cells{cno,x},numformat)];
                end
            end
        end
              
        
        % Writes footer
        if isfield(Reportstruct,'footer') && ~isempty(Reportstruct(tn).footer)
            for x=1:length(Reportstruct(tn).footer)
                rno=rno+1; nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X1;K"'  convstr(Reportstruct(tn).footer{x}) '"']; 
            end
        end  
        
        % Add blank line to separate multiple outputs
        if numel(Reportstruct)>1 && tn<numel(Reportstruct)
            rno=rno+1; nl=nl+1; typestr{nl}=['C;Y' num2str(rno) ';X1;K" "'];
        end

    end % for tn
    
    % Write to file
    fprintf(fh,['ID;P' linefeed]);
    for x=1:numel(typestr)
        fprintf(fh,[typestr{x} linefeed]);
    end  
    fprintf(fh,['E' linefeed]);
    
    if Reportstruct(1).newbe
        Status.savedas = [Reportstruct(1).pathname '.slk'];
        Status.failed = false;
    else
        zz_message(1,['Saved as: ' Reportstruct(1).pathname '.slk'],'-b')
        Zset.lastexport=[Reportstruct(1).pathname '.slk'];
    end
    fclose(fh);

    % Opens
    if ~Reportstruct(1).newbe

        if openfile && ispc
            try
                winopen([Reportstruct(1).pathname '.slk']);
            catch
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'GLNX',4)
            err=system(['xdg-open "' Reportstruct(1).pathname '.slk"']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'MAC',3)
            err=system(['open ''' Reportstruct(1).pathname '.slk''']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        % Suppress output 
        if ~nargout
            clearvars
        end

    end
       
end % if fid==-1


% ====== Subfunction convstr =====
function str=convstr(str)
% Converts special characters in strings for fprintf
% \\ --> \\
% % --> %%
% ' --> ''

if isempty(str) str = ''; end % ensure empties are chars

if ~ischar(str) return; end

str=strrep(str,';',';;');
str=strrep(str,'\','\\');
str=strrep(str,'%','%%');
str=strrep(str,'''','''''');









